/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.chart.renderer.longer;

import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import com.kingdee.bos.qing.core.model.exhibition.longer.ICell;
import com.kingdee.bos.qing.core.model.exhibition.longer.cell.ChartCell;
import com.kingdee.bos.qing.core.model.exhibition.longer.headcell.AxisCell;
import com.kingdee.bos.qing.export.chart.JsDrawChart;
import com.kingdee.bos.qing.export.chart.mock.Canvas;
import com.kingdee.bos.qing.export.chart.renderer.longer.AbstractCellRenderer;
import com.kingdee.bos.qing.export.common.exception.ExportJavaScriptException;
import com.kingdee.bos.qing.export.common.model.ExStyle;
import com.kingdee.bos.qing.util.LogUtil;
import java.awt.Graphics;

class CellRendererForLine
extends AbstractCellRenderer {
    CellRendererForLine() {
    }

    @Override
    public Object draw(AbstractCellRenderer.CellRenderParameter parameter) {
        Canvas value = null;
        try {
            Object cellModel = parameter.getCellModel();
            ExStyle style = parameter.getCellStyle();
            int canvasWidth = style.getWidth();
            int canvasHeight = style.getHeight();
            Graphics jdkGraphics = parameter.getJdkGraphics();
            ICell commonCell = parameter.getCommonCell();
            AbstractChartModel modelAtCommonCell = ((ChartCell)commonCell).getChart();
            if (cellModel instanceof ChartCell) {
                AbstractChartModel modelAtCell = ((ChartCell)cellModel).getChart();
                this.fillCellModelData((MultiSeriesChartModel)modelAtCommonCell, (MultiSeriesChartModel)modelAtCell);
                value = JsDrawChart.getInstance().drawLineChart(canvasWidth, canvasHeight, modelAtCell, jdkGraphics, parameter.getChartConfig().isShowLabel());
            } else if (cellModel instanceof AxisCell) {
                MultiSeriesChartModel modelAtCell = new MultiSeriesChartModel();
                this.fillCellModelData((MultiSeriesChartModel)modelAtCommonCell, modelAtCell);
                String axisType = ((AxisCell)cellModel).getAxisType();
                if ("continue".equals(axisType)) {
                    value = JsDrawChart.getInstance().drawLineChartCategoryAxis(canvasWidth, canvasHeight, modelAtCell, jdkGraphics, parameter.getChartConfig().isShowLabel());
                } else if ("number".equals(axisType)) {
                    value = JsDrawChart.getInstance().drawLineChartNumberAxis(canvasWidth, canvasHeight, modelAtCell, jdkGraphics, parameter.getChartConfig().isShowLabel());
                }
            }
        }
        catch (ExportJavaScriptException e) {
            LogUtil.error((String)"Init JsDrawChart error.", (Throwable)((Object)e));
        }
        return value;
    }
}

