/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.chart.renderer.longer;

import com.kingdee.bos.qing.export.chart.model.TreeNodeCellAdapter;
import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererForTreeNode;
import com.kingdee.bos.qing.export.common.model.ExStyle;
import java.awt.Color;
import java.awt.Graphics;

public class CellRendererForTreeNodeOfVertical
extends CellRendererForTreeNode {
    @Override
    protected void drawTree(Graphics g, TreeNodeCellAdapter cellModel, ExStyle cellStyle, int throughLinkCount, int cornerLinkCount) {
        int i;
        int xMove = cellStyle.getxOffset() + 5 + 2;
        int y = cellStyle.getyOffset();
        int height = cellStyle.getHeight();
        for (i = 0; i < throughLinkCount; ++i) {
            this.drawThroughLink(g, xMove, y, height);
            xMove += 17;
        }
        for (i = 0; i < cornerLinkCount; ++i) {
            this.drawCornerLink(g, xMove, y, height);
            xMove += 17;
        }
        if (cellModel.isLeaf()) {
            this.drawLeafButton(g, xMove, y + height / 2);
        } else if (cellModel.isExpanded()) {
            this.drawExpandedButton(g, xMove, y + height / 2, height);
        } else {
            this.drawCollapsedButton(g, xMove, y + height / 2);
        }
        if (cellModel.getText() != null && !cellModel.getText().isEmpty()) {
            cellStyle.setxOffset(xMove + 5 + 4);
            this.drawString(g, cellModel.getText().trim(), cellStyle);
        }
    }

    private void drawExpandedButton(Graphics g, int x, int y, int cellHeight) {
        g.setColor(lineColor);
        int padding = 2;
        int yEnd = y + cellHeight / 2;
        for (int yTail = y + 5; yTail < yEnd; yTail += 2) {
            g.drawLine(x, yTail, x, yTail);
        }
        g.setColor(buttonBgColor);
        g.fillRoundRect(x -= 5, y -= 5, 10, 10, 5, 5);
        g.setColor(lineColor);
        g.drawRoundRect(x, y, 10, 10, 5, 5);
        g.setColor(Color.black);
        int centerY = y + 5;
        g.drawLine(x + padding, centerY, x + 10 - padding, centerY);
    }

    private void drawThroughLink(Graphics g, int x, int y, int cellHeight) {
        g.setColor(lineColor);
        int yEnd = y + cellHeight;
        for (int yMove = y; yMove < yEnd; ++yMove) {
            g.drawLine(x, yMove, x, yMove);
            yMove += 2;
        }
    }

    private void drawCornerLink(Graphics g, int x, int y, int cellHeight) {
        int yMove;
        g.setColor(lineColor);
        int yEnd = y + cellHeight / 2;
        for (yMove = y; yMove < yEnd; ++yMove) {
            g.drawLine(x, yMove, x, yMove);
            yMove += 2;
        }
        int xMove = x;
        for (int i = 0; i < 3; ++i) {
            g.drawLine(xMove, yMove, xMove, yMove);
            xMove += 2;
        }
    }
}

