/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.common.model;

import com.kingdee.bos.qing.common.i18n.DefaultI18nContext;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.analysis.longer.ChartType;
import com.kingdee.bos.qing.core.model.analysis.longer.ParallelMeasureLayout;
import com.kingdee.bos.qing.core.model.analysis.longer.preferences.ChartConfig;
import com.kingdee.bos.qing.core.model.analysis.longer.preferences.ExhibitionStatus;
import com.kingdee.bos.qing.core.model.exhibition.common.Legends;
import com.kingdee.bos.qing.core.model.exhibition.longer.Diagonal;
import com.kingdee.bos.qing.core.model.exhibition.longer.DrawInfo;
import com.kingdee.bos.qing.core.model.exhibition.longer.ICell;
import com.kingdee.bos.qing.core.model.exhibition.longer.MergeBlock;
import com.kingdee.bos.qing.core.model.exhibition.longer.TableView;
import com.kingdee.bos.qing.core.model.exhibition.longer.cell.ChartCell;
import com.kingdee.bos.qing.core.model.exhibition.longer.cell.TextTableCell;
import com.kingdee.bos.qing.core.model.exhibition.longer.headcell.AxisCell;
import com.kingdee.bos.qing.core.model.exhibition.longer.headcell.MeasureTitleCell;
import com.kingdee.bos.qing.core.model.exhibition.longer.headcell.NonstringCell;
import com.kingdee.bos.qing.core.model.exhibition.longer.headcell.SubtotalCell;
import com.kingdee.bos.qing.core.model.exhibition.longer.headcell.TreeNodeCell;
import com.kingdee.bos.qing.export.chart.model.TreeNodeCellAdapter;
import com.kingdee.bos.qing.export.chart.renderer.longer.AbstractCellRenderer;
import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererFactory;
import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererForLegend;
import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererForString;
import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererForTreeNodeOfHorizontal;
import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererForTreeNodeOfVertical;
import com.kingdee.bos.qing.export.common.model.ExAlign;
import com.kingdee.bos.qing.export.common.model.ExBorder;
import com.kingdee.bos.qing.export.common.model.ExFont;
import com.kingdee.bos.qing.export.common.model.ExStyle;
import com.kingdee.bos.qing.export.common.model.IExportAdapter;
import com.kingdee.bos.qing.export.common.model.RowColRange;
import com.kingdee.bos.qing.export.common.persistence.ExportConfig;
import com.kingdee.bos.qing.export.common.util.ColorTransUtil;
import com.kingdee.bos.qing.export.excel.ExcelNumberFormater;
import com.kingdee.bos.qing.util.LogUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class TableViewAdapter
implements IExportAdapter {
    private static ExFont DEFAULT_FONT = new ExFont();
    private TableView tableView;
    private ChartConfig chartConfig;
    private int rowBodyHeight;
    private int colBodyWidth;
    private int[] rowHeadHeight;
    private int[] colHeadWidth;
    private Color firstColor = Color.WHITE;
    private Color rowHeadColor = new Color(244, 244, 244);
    private Color secondColor = new Color(240, 244, 250);
    private int rowCount;
    private int colCount;
    private int topHeadRowCount;
    private int leftHeadRowCount;
    private int topHeadColCount;
    private int leftHeadColCount;
    private List<RowColRange> mergeRanges;
    private ExFont font = DEFAULT_FONT;
    private List<ExcelNumberFormater> formatFiledModels;
    private boolean isRowFirst = true;
    private boolean isTopHeaderAll = true;
    private boolean isLeftHeaderAll = false;
    private boolean isLegendAll = false;
    private int legendNumber = -1;
    private int legendWidth = 148;
    private int sizeLegendBodyHeight;
    private int continuousColorLegendBodyHeight;
    private int discreteColorLegendBodyHeight;
    private int maxLegendHeight = -1;
    private int legendHeaderHeight = 24;
    private int legendGap = 9;
    private ChartType chartType;
    private II18nContext _i18nContext;
    private ExportConfig _exportConfig;

    public TableViewAdapter(TableView tableView) {
        this.setTableView(tableView);
        this.calcRowColCount();
        this.rowHeadHeight = new int[this.topHeadRowCount];
        this.colHeadWidth = new int[this.leftHeadColCount];
        this.chartType = tableView.getDraw().getTypes();
        this._i18nContext = new DefaultI18nContext(Locale.SIMPLIFIED_CHINESE);
        this.initLegendHeight();
    }

    public TableViewAdapter(TableView tableView, ExhibitionStatus exhibitionStatus, boolean isToAdjustExhibition, ChartConfig chartConfig, String skin, II18nContext i18n) {
        this(tableView);
        if (i18n != null) {
            this._i18nContext = i18n;
        }
        this.chartConfig = chartConfig != null ? chartConfig : new ChartConfig();
        this.calWidthHeight(exhibitionStatus, isToAdjustExhibition);
        this.initSkin(skin);
    }

    private void initSkin(String skin) {
        this.rowHeadColor = new Color(244, 244, 244);
        this.secondColor = new Color(240, 244, 250);
    }

    private void initLegendHeight() {
        int iRows;
        if (this.tableView.getLegends() == null) {
            return;
        }
        if (this.tableView.getLegends().getSize() != null) {
            iRows = this.tableView.getLegends().getSize().getRatios().size();
            this.sizeLegendBodyHeight = 1 + iRows * 20;
        }
        if (this.tableView.getLegends().getDiscreteColor() != null) {
            iRows = this.tableView.getLegends().getDiscreteColor().getColors().size();
            if (this.tableView.getLegends().getDiscreteColor().getOthers() > 0) {
                ++iRows;
            }
            this.discreteColorLegendBodyHeight = iRows * 20;
        }
        if (this.tableView.getLegends().getContinuousColor() != null) {
            this.continuousColorLegendBodyHeight = 40;
        }
    }

    private void calWidthHeight(ExhibitionStatus exhibitionStatus, boolean isToAdjustExhibition) {
        int i;
        int[] columnWidth = exhibitionStatus.getPaintableColumnWidth();
        int[] rowHeight = exhibitionStatus.getPaintableRowHeight();
        if (isToAdjustExhibition) {
            int len;
            if (columnWidth != null) {
                len = this.leftHeadColCount + 1;
                columnWidth = new int[len];
                for (i = 0; i < len; ++i) {
                    columnWidth[i] = 120;
                }
            }
            if (rowHeight != null) {
                len = this.topHeadRowCount + 1;
                rowHeight = new int[len];
                for (i = 0; i < len; ++i) {
                    rowHeight[i] = 24;
                }
            }
        }
        if (columnWidth != null && columnWidth.length > 0) {
            int[] cWidth = new int[this.leftHeadColCount];
            for (i = 0; i < this.leftHeadColCount; ++i) {
                cWidth[i] = columnWidth[i];
            }
            this.setColHeadWidth(cWidth);
            this.setColBodyWidth(columnWidth[this.leftHeadColCount]);
        }
        if (rowHeight != null && rowHeight.length > 0) {
            int[] rHeight = new int[this.topHeadRowCount];
            for (i = 0; i < this.topHeadRowCount; ++i) {
                rHeight[i] = rowHeight[i];
            }
            this.setRowHeadHeight(rHeight);
            this.setRowBodyHeight(rowHeight[this.topHeadRowCount]);
        }
    }

    private void calcRowColCount() {
        String[] planeHead;
        List<Object[]> leftHeads;
        List<Object[]> topHeads = this.tableView.getTopHead();
        if (topHeads != null && topHeads.size() > 0) {
            this.topHeadColCount = topHeads.size();
            Object[] topHeadRow = topHeads.get(0);
            if (topHeadRow != null) {
                this.topHeadRowCount = topHeadRow.length;
            }
        }
        if ((leftHeads = this.tableView.getLeftHead()) != null && leftHeads.size() > 0) {
            this.leftHeadRowCount = leftHeads.size();
            Object[] leftHeadRow = leftHeads.get(0);
            if (leftHeadRow != null) {
                this.leftHeadColCount = leftHeadRow.length;
            }
        }
        if ((planeHead = this.tableView.getLeftTopHead().getPlane()) != null) {
            this.leftHeadColCount = planeHead.length;
        }
        if (this.topHeadRowCount == 0) {
            String[] plane = null;
            if (this.tableView.getLeftTopHead() != null) {
                plane = this.tableView.getLeftTopHead().getPlane();
            }
            if (plane != null) {
                ++this.topHeadRowCount;
            }
        }
        this.colCount = this.topHeadColCount + this.leftHeadColCount;
        this.rowCount = this.leftHeadRowCount + this.topHeadRowCount;
    }

    @Override
    public String textAt(int row, int col) {
        return this.getStringValue(this.getCellModell(row, col));
    }

    @Override
    public Object getCellModell(int row, int col) {
        if (this.isInvalid(row, col)) {
            return null;
        }
        Object value = null;
        if (row < this.topHeadRowCount && col < this.leftHeadColCount) {
            String[] plane = this.tableView.getLeftTopHead().getPlane();
            if (plane != null && plane.length > 0) {
                value = plane[col];
            }
        } else if (row < this.topHeadRowCount) {
            List<Object[]> rows = this.tableView.getTopHead();
            Object[] cols = rows.get(col - this.leftHeadColCount);
            value = cols[row];
        } else if (col < this.leftHeadColCount) {
            List<Object[]> rows = this.tableView.getLeftHead();
            Object[] cols = rows.get(row - this.topHeadRowCount);
            value = cols[col];
        } else {
            List<ICell[]> rows = this.tableView.getCells();
            if (rows != null && rows.size() > 0) {
                ICell[] cells = rows.get(row - this.topHeadRowCount);
                ICell cell = cells[col - this.leftHeadColCount];
                value = cell;
            }
        }
        return value;
    }

    @Override
    public void drawCell(int row, int col, ExStyle cellStyle, Graphics cellGraphics) {
        if (this.isInvalid(row, col)) {
            return;
        }
        if (row < this.topHeadRowCount && col < this.leftHeadColCount) {
            String[] plane = this.tableView.getLeftTopHead().getPlane();
            if (plane != null && plane.length > 0) {
                this.drawCell(row, col, plane[col], cellStyle, cellGraphics);
            }
        } else if (row < this.topHeadRowCount) {
            List<Object[]> rows = this.tableView.getTopHead();
            Object[] cols = rows.get(col - this.leftHeadColCount);
            this.drawCell(row, col, cols[row], cellStyle, cellGraphics);
        } else if (col < this.leftHeadColCount) {
            List<Object[]> rows = this.tableView.getLeftHead();
            Object[] cols = rows.get(row - this.topHeadRowCount);
            this.drawCell(row, col, cols[col], cellStyle, cellGraphics);
        } else {
            List<ICell[]> rows = this.tableView.getCells();
            if (rows != null && rows.size() > 0) {
                ICell[] cells = rows.get(row - this.topHeadRowCount);
                ICell cell = cells[col - this.leftHeadColCount];
                this.drawCell(row, col, cell, cellStyle, cellGraphics);
            }
        }
    }

    private void drawCell(int row, int col, Object obj, ExStyle cellStyle, Graphics jdkGraphics) {
        if (obj instanceof TreeNodeCell) {
            this.drawTreeNodeCell(row, col, (TreeNodeCell)obj, cellStyle, jdkGraphics);
            return;
        }
        String textValue = this.getStringValue(obj);
        if (textValue.isEmpty() && obj != null && ChartType.Table != this.chartType) {
            AbstractCellRenderer.CellRenderParameter parameter = new AbstractCellRenderer.CellRenderParameter();
            parameter.setChartConfig(this.chartConfig);
            parameter.setCommonCell(this.tableView.getCommonCell());
            parameter.setJdkGraphics(jdkGraphics);
            parameter.setCellStyle(cellStyle);
            parameter.setCellModel(obj);
            parameter.setDirection(this.tableView.getDraw().getDirection());
            CellRendererFactory.getInstance(this.chartType).draw(parameter);
        } else {
            AbstractCellRenderer.CellRenderParameter parameter = new AbstractCellRenderer.CellRenderParameter();
            parameter.setJdkGraphics(jdkGraphics);
            parameter.setCellStyle(cellStyle);
            parameter.setCellModel(textValue);
            CellRendererForString render = new CellRendererForString();
            render.draw(parameter);
        }
    }

    @Override
    public boolean isAtColHeader(int row) {
        return row < this.topHeadRowCount;
    }

    @Override
    public boolean isAtRowHeader(int col) {
        return col < this.leftHeadColCount;
    }

    private void drawTreeNodeCell(int row, int col, TreeNodeCell cellModel, ExStyle cellStyle, Graphics jdkGraphics) {
        if (cellModel.getText() == null || cellModel.getText().isEmpty()) {
            return;
        }
        TreeNodeCellAdapter model = new TreeNodeCellAdapter(cellModel);
        model.setExpanded(true);
        AbstractCellRenderer.CellRenderParameter parameter = new AbstractCellRenderer.CellRenderParameter();
        parameter.setCellModel(model);
        parameter.setJdkGraphics(jdkGraphics);
        parameter.setCellStyle(cellStyle);
        if (this.isAtColHeader(row)) {
            model.setHorizontal(true);
            this.setLeafForTreeNode(model, this.getNextCellModel(row, col, false));
            CellRendererForTreeNodeOfHorizontal render = new CellRendererForTreeNodeOfHorizontal();
            render.draw(parameter);
            return;
        }
        if (this.isAtRowHeader(col)) {
            model.setHorizontal(false);
            this.setLeafForTreeNode(model, this.getNextCellModel(row, col, true));
            CellRendererForTreeNodeOfVertical render = new CellRendererForTreeNodeOfVertical();
            render.draw(parameter);
            return;
        }
        throw new RuntimeException("TreeNodeCell in new situation, implement me.");
    }

    private Object getNextCellModel(int row, int col, boolean isNextOfRow) {
        if (isNextOfRow) {
            return this.getCellModell(this.getNextCellIndex(row, col, isNextOfRow), col);
        }
        return this.getCellModell(row, this.getNextCellIndex(row, col, isNextOfRow));
    }

    @Override
    public int getNextCellIndex(int row, int col, boolean isNextOfRow) {
        Object nextCellModel;
        int index;
        Object cellModel = this.getCellModell(row, col);
        if (isNextOfRow) {
            index = row + 1;
            nextCellModel = this.getCellModell(index, col);
        } else {
            index = col + 1;
            nextCellModel = this.getCellModell(row, index);
        }
        if (cellModel == null || !cellModel.equals(nextCellModel)) {
            return index;
        }
        RowColRange range = this.getCellRange(row, col);
        index = isNextOfRow ? range.getToRow() + 1 : range.getToCol() + 1;
        return index;
    }

    @Override
    public RowColRange getCellRange(int row, int col) {
        List<RowColRange> mergeRangeList = this.getMergeRanges();
        if (mergeRangeList == null) {
            return new RowColRange(row, row, col, col);
        }
        for (RowColRange range : mergeRangeList) {
            if (range.getFromCol() > col || range.getToCol() < col || range.getFromRow() > row || range.getToRow() < row) continue;
            return range;
        }
        return new RowColRange(row, row, col, col);
    }

    private void setLeafForTreeNode(TreeNodeCellAdapter model, Object nextNode) {
        if (nextNode instanceof TreeNodeCell) {
            TreeNodeCell nextNodeCell = (TreeNodeCell)nextNode;
            model.setLeaf(nextNodeCell.getLevel() <= model.getLevel());
            model.setLastChild(nextNodeCell.getLevel() < model.getLevel());
        } else {
            model.setLeaf(true);
            model.setLastChild(true);
        }
    }

    @Override
    public String getStringValue(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof SubtotalCell) {
            return ((SubtotalCell)obj).getText();
        }
        if (obj instanceof TextTableCell) {
            return ((TextTableCell)obj).getText();
        }
        if (obj instanceof MeasureTitleCell) {
            return ((MeasureTitleCell)obj).getMeasureTitle();
        }
        if (obj instanceof NonstringCell) {
            return ((NonstringCell)obj).getText();
        }
        if (obj instanceof TreeNodeCell) {
            TreeNodeCell model = (TreeNodeCell)obj;
            if (model.getText() == null) {
                return "";
            }
            return model.getText();
        }
        return "";
    }

    @Override
    public ExStyle styleAt(int row, int col) {
        ExStyle style = this.chartType == ChartType.Table ? this.tableStyleAt(row, col) : this.chartStyleAt(row, col);
        style.setWidth(this.getColWidth(col));
        style.setHeight(this.getRowHeight(row));
        return style;
    }

    private boolean isNeedSecondColor(int row, int col) {
        return true;
    }

    public ExStyle tableStyleAt(int row, int col) {
        ICell[] cells;
        ICell cell;
        List<ICell[]> rows;
        ExStyle style = new ExStyle();
        this.fontAt(style, row, col);
        if (this.isInvalid(row, col)) {
            return style;
        }
        style.setNoWrap(true);
        if (row < this.getTopHeadRowCount()) {
            style.setBackgroundColor(this.rowHeadColor);
        } else if ((row - this.getTopHeadRowCount()) % 2 == 0) {
            style.setBackgroundColor(this.firstColor);
        } else if (col < this.getLeftHeadColCount() - 1) {
            style.setBackgroundColor(this.firstColor);
        } else if (this.isNeedSecondColor(row, col)) {
            style.setBackgroundColor(this.secondColor);
        }
        style.setVerticalAlignment(ExAlign.MIDDLE);
        if (row < this.topHeadRowCount && col < this.leftHeadColCount) {
            style.setHorizontalAlignment(ExAlign.CENTER);
        } else if (row < this.getTopHeadRowCount() - 1) {
            style.setHorizontalAlignment(ExAlign.CENTER);
        } else if (col < this.getLeftHeadColCount()) {
            style.setHorizontalAlignment(ExAlign.LEFT);
        } else {
            style.setHorizontalAlignment(ExAlign.RIGHT);
        }
        if (row >= this.topHeadRowCount && col >= this.leftHeadColCount && (rows = this.tableView.getCells()) != null && rows.size() > 0 && (cell = (cells = rows.get(row - this.topHeadRowCount))[col - this.leftHeadColCount]) instanceof TextTableCell) {
            style.setForegroundColor(ColorTransUtil.HSL2Color(((TextTableCell)cell).getColor()));
        }
        style.setFormatString(this.formatStringAt(row, col));
        this.initCellBorder(style, row, col);
        return style;
    }

    public ExStyle chartStyleAt(int row, int col) {
        ICell[] cells;
        ICell cell;
        List<Object[]> rows;
        ExStyle style = new ExStyle();
        this.fontAt(style, row, col);
        if (this.isInvalid(row, col)) {
            return style;
        }
        style.setNoWrap(true);
        if (row < this.getTopHeadRowCount()) {
            style.setBackgroundColor(this.rowHeadColor);
        } else {
            style.setBackgroundColor(this.firstColor);
        }
        style.setVerticalAlignment(ExAlign.MIDDLE);
        if (row < this.topHeadRowCount && col < this.leftHeadColCount) {
            style.setHorizontalAlignment(ExAlign.CENTER);
        } else if (row < this.getTopHeadRowCount()) {
            style.setHorizontalAlignment(ExAlign.CENTER);
            if (row == this.getTopHeadRowCount() - 1) {
                style.setNoWrap(false);
                if (this.chartType == ChartType.Bar || this.chartType == ChartType.StackBar) {
                    if (DrawInfo.Direction.LANDSCAPE == this.tableView.getDraw().getDirection()) {
                        style.setVerticalAlignment(ExAlign.TOP);
                    } else {
                        style.setVerticalAlignment(ExAlign.MIDDLE);
                    }
                } else if (this.chartType == ChartType.Line || this.chartType == ChartType.MultiLine || this.chartType == ChartType.Area) {
                    style.setVerticalAlignment(ExAlign.TOP);
                } else if (this.chartType == ChartType.Table || this.chartType == ChartType.Pie || this.chartType == ChartType.TreeMap || this.chartType == ChartType.HeatMap) {
                    style.setVerticalAlignment(ExAlign.MIDDLE);
                }
            }
        } else if (col < this.getLeftHeadColCount()) {
            rows = this.tableView.getLeftHead();
            Object[] cols = rows.get(row - this.topHeadRowCount);
            if (cols[col] instanceof ChartCell || cols[col] instanceof AxisCell) {
                style.setHorizontalAlignment(ExAlign.RIGHT);
            } else {
                style.setHorizontalAlignment(ExAlign.LEFT);
            }
        } else {
            style.setHorizontalAlignment(ExAlign.CENTER);
        }
        if (row >= this.topHeadRowCount && col >= this.leftHeadColCount && (rows = this.tableView.getCells()) != null && rows.size() > 0 && (cell = (cells = (ICell[])rows.get(row - this.topHeadRowCount))[col - this.leftHeadColCount]) instanceof TextTableCell) {
            style.setForegroundColor(ColorTransUtil.HSL2Color(((TextTableCell)cell).getColor()));
        }
        style.setFormatString(this.formatStringAt(row, col));
        this.initCellBorder(style, row, col);
        return style;
    }

    private void initCellBorder(ExStyle style, int row, int col) {
        int i;
        ExBorder border = new ExBorder();
        if (col == 0) {
            style.setBorderLeft(border);
        }
        if (row == 0) {
            style.setBorderTop(border);
        }
        if (row == this.rowCount - 1 || col < this.leftHeadColCount - 1 || row == this.topHeadRowCount - 1) {
            style.setBorderBottom(border);
        }
        if (col == this.colCount - 1 || col == this.leftHeadColCount - 1 || row < this.topHeadRowCount - 1) {
            style.setBorderRight(border);
        }
        if (row >= this.topHeadRowCount && col < this.leftHeadColCount) {
            style.setBorderRight(border);
        }
        if (row >= this.topHeadRowCount - 1) {
            for (i = 0; i < this.topHeadRowCount - 1; ++i) {
                String nextRowGroupValue = this.textAt(i, col + 1);
                String rowGroupValue = this.textAt(i, col);
                if (rowGroupValue == null || nextRowGroupValue == null || nextRowGroupValue.equals(rowGroupValue)) continue;
                style.setBorderRight(border);
                break;
            }
        }
        if (col >= this.leftHeadColCount - 1) {
            for (i = 0; i < this.leftHeadColCount - 1; ++i) {
                String nextColGroupValue = this.textAt(row + 1, i);
                String colGroupValue = this.textAt(row, i);
                if (nextColGroupValue == null || colGroupValue == null || nextColGroupValue.equals(colGroupValue)) continue;
                style.setBorderBottom(border);
                break;
            }
        }
    }

    private boolean isInvalid(int row, int col) {
        return row < 0 || col < 0 || row >= this.rowCount || col >= this.colCount;
    }

    @Override
    public List<String> getDiagonalTitles() {
        List<String> titles = null;
        Diagonal diagonal = this.tableView.getLeftTopHead().getDiagonal();
        if (diagonal != null) {
            titles = diagonal.getTitles();
        }
        return titles;
    }

    @Override
    public List<RowColRange> getMergeRanges() {
        List<MergeBlock> blocks;
        if (this.mergeRanges == null && (blocks = this.tableView.getMergeBlocks()) != null && !blocks.isEmpty()) {
            this.mergeRanges = new ArrayList<RowColRange>(blocks.size());
            for (MergeBlock block : blocks) {
                if (this._exportConfig != null) {
                    boolean isLeftHeadMergeBlock;
                    boolean needLeftHeadMergeBlock = this._exportConfig.isVerticalMerged();
                    boolean bl = isLeftHeadMergeBlock = (Integer)block.get(0) >= this.topHeadRowCount;
                    if (!needLeftHeadMergeBlock && isLeftHeadMergeBlock) continue;
                }
                RowColRange mergeBlock = new RowColRange();
                mergeBlock.setFromRow((Integer)block.get(0));
                mergeBlock.setToRow((Integer)block.get(1));
                mergeBlock.setFromCol((Integer)block.get(2));
                mergeBlock.setToCol((Integer)block.get(3));
                this.mergeRanges.add(mergeBlock);
            }
        }
        return this.mergeRanges;
    }

    private void fontAt(ExStyle style, int row, int col) {
        if (this.chartType == ChartType.Table) {
            this.tableFontAt(style, row, col);
        } else {
            style.setExFont(this.getFont());
        }
    }

    private void tableFontAt(ExStyle style, int row, int col) {
        ExFont exFont = new ExFont();
        if (this.isInvalid(row, col)) {
            style.setExFont(exFont);
            return;
        }
        boolean isBold = false;
        if (row < this.topHeadRowCount && col < this.leftHeadColCount) {
            style.setExFont(exFont);
            return;
        }
        if (row < this.topHeadRowCount) {
            List<Object[]> cols = this.tableView.getTopHead();
            Object[] rows = cols.get(col - this.leftHeadColCount);
            for (int i = 0; i < rows.length; ++i) {
                if (i != row || !(rows[i] instanceof SubtotalCell)) continue;
                isBold = true;
                break;
            }
        } else if (col < this.leftHeadColCount) {
            List<Object[]> rows = this.tableView.getLeftHead();
            Object[] cols = rows.get(row - this.topHeadRowCount);
            for (int i = 0; i < cols.length; ++i) {
                if (i != col || !(cols[i] instanceof SubtotalCell)) continue;
                isBold = true;
                break;
            }
        } else {
            List<Object[]> leftHeadRows = this.tableView.getLeftHead();
            Object[] leftHeadCols = leftHeadRows.get(row - this.topHeadRowCount);
            for (int i = 0; i < leftHeadCols.length; ++i) {
                if (!(leftHeadCols[i] instanceof SubtotalCell) || this.leftHeadColCount > col) continue;
                isBold = true;
                break;
            }
            List<Object[]> topHeadCols = this.tableView.getTopHead();
            Object[] topHeadRows = topHeadCols.get(col - this.leftHeadColCount);
            for (int i = 0; i < topHeadRows.length; ++i) {
                if (!(topHeadRows[i] instanceof SubtotalCell) || this.topHeadRowCount > row) continue;
                isBold = true;
                break;
            }
        }
        if (isBold) {
            exFont.setFontStyle(1);
        }
        style.setExFont(exFont);
    }

    @Override
    public Color getRowHeadColor() {
        return this.rowHeadColor;
    }

    @Override
    public int getTopHeadRowCount() {
        return this.topHeadRowCount;
    }

    @Override
    public int getLeftHeadColCount() {
        return this.leftHeadColCount;
    }

    @Override
    public int getRowHeight(int index) {
        if (index < this.topHeadRowCount) {
            return this.rowHeadHeight[index];
        }
        return this.rowBodyHeight;
    }

    public void setRowBodyHeight(int rowBodyHeight) {
        this.rowBodyHeight = rowBodyHeight;
    }

    @Override
    public int getColWidth(int index) {
        if (index < this.leftHeadColCount) {
            return this.colHeadWidth[index];
        }
        return this.colBodyWidth;
    }

    public void setColBodyWidth(int colBodyWidth) {
        this.colBodyWidth = colBodyWidth;
    }

    public int[] getRowHeadHeight() {
        return this.rowHeadHeight;
    }

    public void setRowHeadHeight(int[] rowHeadHeight) {
        this.rowHeadHeight = rowHeadHeight;
    }

    public int[] getColHeadWidth() {
        return this.colHeadWidth;
    }

    public void setColHeadWidth(int[] colHeadWidth) {
        this.colHeadWidth = colHeadWidth;
    }

    public void setTableView(TableView tableView) {
        this.tableView = tableView;
    }

    @Override
    public int getColCount() {
        return this.colCount;
    }

    public void setColCount(int colCount) {
        this.colCount = colCount;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    @Override
    public ExFont getFont() {
        return this.font;
    }

    public void setFont(ExFont font) {
        this.font = font;
    }

    public void setFormatFiledModels(List<ExcelNumberFormater> formatFiledModels) {
        this.formatFiledModels = formatFiledModels;
    }

    public String formatStringAt(int row, int col) {
        ExcelNumberFormater numberFormater;
        if (row < this.topHeadRowCount || col < this.leftHeadColCount) {
            return "@";
        }
        if (this.formatFiledModels == null || this.formatFiledModels.size() == 0) {
            return null;
        }
        if (this.formatFiledModels.size() == 1) {
            numberFormater = this.formatFiledModels.get(0);
        } else {
            ChartConfig.TableConfig tc = this.chartConfig.getTableConfig();
            ParallelMeasureLayout pml = tc == null ? ParallelMeasureLayout.AtColumn : tc.getParallelMeasureLayout();
            int index = pml == ParallelMeasureLayout.AtRow ? row - this.topHeadRowCount : col - this.leftHeadColCount;
            numberFormater = this.formatFiledModels.get(index % this.formatFiledModels.size());
        }
        String value = this.textAt(row, col);
        if (value != null && value.length() > 0) {
            try {
                double parseDouble = Double.parseDouble(value);
                return numberFormater.getUsableFormatString(parseDouble);
            }
            catch (NumberFormatException t) {
                LogUtil.error((String)"formatStringAt() occurs error.", (Throwable)t);
            }
        }
        return "";
    }

    @Override
    public int getAllRowHeight() {
        int[] height;
        int allHeight = 0;
        for (int h : height = this.getRowHeadHeight()) {
            allHeight += h;
        }
        return allHeight += this.rowBodyHeight * (this.rowCount - height.length);
    }

    @Override
    public int getAllColWidth() {
        int[] width;
        int allWidth = 0;
        for (int w : width = this.getColHeadWidth()) {
            allWidth += w;
        }
        return allWidth += this.colBodyWidth * (this.colCount - width.length);
    }

    @Override
    public boolean isRowFirst() {
        return this.isRowFirst;
    }

    public void setRowFirst(boolean isRowFirst) {
        this.isRowFirst = isRowFirst;
    }

    @Override
    public boolean isTopHeaderAll() {
        return this.isTopHeaderAll;
    }

    @Override
    public void setTopHeaderAll(boolean isTopHeaderAll) {
        this.isTopHeaderAll = isTopHeaderAll;
    }

    @Override
    public boolean isLeftHeaderAll() {
        return this.isLeftHeaderAll;
    }

    @Override
    public void setLeftHeaderAll(boolean isLeftHeaderAll) {
        this.isLeftHeaderAll = isLeftHeaderAll;
    }

    @Override
    public boolean isLegendAll() {
        return this.isLegendAll;
    }

    public void setLegendAll(boolean isLegendAll) {
        this.isLegendAll = isLegendAll;
    }

    @Override
    public int getLegendWidth() {
        return this.legendWidth;
    }

    @Override
    public int getLegendGap() {
        return this.legendGap;
    }

    @Override
    public int getLegendNumber() {
        if (this.legendNumber == -1) {
            this.legendNumber = 0;
            if (this.tableView.getLegends().getContinuousColor() != null) {
                ++this.legendNumber;
            }
            if (this.tableView.getLegends().getDiscreteColor() != null) {
                ++this.legendNumber;
            }
            if (this.tableView.getLegends().getSize() != null) {
                ++this.legendNumber;
            }
        }
        return this.legendNumber;
    }

    private int getMaxLegendHeight() {
        if (this.maxLegendHeight == -1) {
            this.maxLegendHeight = this.sizeLegendBodyHeight;
            if (this.maxLegendHeight < this.discreteColorLegendBodyHeight) {
                this.maxLegendHeight = this.discreteColorLegendBodyHeight;
            }
            if (this.maxLegendHeight < this.continuousColorLegendBodyHeight) {
                this.maxLegendHeight = this.continuousColorLegendBodyHeight;
            }
            this.maxLegendHeight += this.legendHeaderHeight;
        }
        return this.maxLegendHeight;
    }

    @Override
    public int getVerticalLegendWidth() {
        return this.legendWidth;
    }

    @Override
    public int getVerticalLegendHeight() {
        int height = 0;
        if (this.sizeLegendBodyHeight > 0) {
            height += this.sizeLegendBodyHeight + this.legendHeaderHeight;
        }
        if (this.continuousColorLegendBodyHeight > 0) {
            height += this.continuousColorLegendBodyHeight + this.legendHeaderHeight;
        }
        if (this.discreteColorLegendBodyHeight > 0) {
            height += this.discreteColorLegendBodyHeight + this.legendHeaderHeight;
        }
        return height += this.legendGap * (this.getLegendNumber() - 1);
    }

    @Override
    public int getHorizontalLegendWidth() {
        return (this.legendWidth + this.legendGap) * this.getLegendNumber() - this.legendGap;
    }

    @Override
    public int getHorizontalLegendHeight() {
        return this.getMaxLegendHeight();
    }

    @Override
    public CellRendererForLegend.LegendRenderParameter getLegendRenderParameter() {
        Legends.SizeLegend sizeLegend;
        Legends.DiscreteColorLegend discreteColorLegend;
        String legendText = Messages.getLangMessage(this._i18nContext, "legend", "\u56fe\u4f8b");
        Legends legends = this.tableView.getLegends();
        CellRendererForLegend.LegendRenderParameter parameter = new CellRendererForLegend.LegendRenderParameter();
        parameter.setLegends(legends);
        parameter.setLegendGap(this.legendGap);
        parameter.setLegendWidth(this.legendWidth);
        parameter.setLegendHeaderHeight(this.legendHeaderHeight);
        parameter.setContinuousColorLegendBodyHeight(this.continuousColorLegendBodyHeight);
        parameter.setDiscreteColorLegendBodyHeight(this.discreteColorLegendBodyHeight);
        parameter.setSizeLegendBodyHeight(this.sizeLegendBodyHeight);
        Legends.ContinuousColorLegend continuousColorLegend = legends.getContinuousColor();
        if (continuousColorLegend != null) {
            String sTitle = continuousColorLegend.getTitle();
            parameter.setContinuousColorLegendTitle(legendText + (sTitle != null ? ": " + sTitle : ""));
        }
        if ((discreteColorLegend = legends.getDiscreteColor()) != null) {
            String sTitle = discreteColorLegend.getTitle();
            parameter.setDiscreteColorLegendTitle(legendText + (sTitle != null ? ": " + sTitle : ""));
        }
        if ((sizeLegend = legends.getSize()) != null) {
            String sTitle = sizeLegend.getTitle();
            parameter.setSizeLegendTitle(legendText + (sTitle != null ? ": " + sTitle : ""));
        }
        int iBaseDiameter = (int)((double)Math.min(this.rowBodyHeight, this.colBodyWidth) * 0.8);
        parameter.setBaseDiameter(iBaseDiameter);
        parameter.setHeaderStyle(this.getLengendHeaderStyle());
        parameter.setBodyStyle(this.getLengendBodyStyle());
        return parameter;
    }

    private ExStyle getLengendHeaderStyle() {
        ExStyle style = new ExStyle();
        style.setBackgroundColor(new Color(240, 240, 240));
        style.setForegroundColor(Color.black);
        style.setHorizontalAlignment(ExAlign.LEFT);
        ExBorder border = new ExBorder();
        style.setBorderTop(border);
        style.setBorderRight(border);
        style.setBorderLeft(border);
        return style;
    }

    private ExStyle getLengendBodyStyle() {
        ExStyle style = new ExStyle();
        style.setBackgroundColor(Color.WHITE);
        style.setHorizontalAlignment(ExAlign.LEFT);
        ExBorder border = new ExBorder();
        style.setBorderRight(border);
        style.setBorderBottom(border);
        style.setBorderLeft(border);
        return style;
    }

    @Override
    public ExStyle getLengendStyle() {
        ExStyle style = new ExStyle();
        style.setBackgroundColor(Color.WHITE);
        style.setHorizontalAlignment(ExAlign.LEFT);
        return style;
    }

    public void setExportConfig(ExportConfig config) {
        this._exportConfig = config;
    }
}

