/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.excel;

import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.excel.IExcelCustomStrategy;
import com.kingdee.bos.qing.core.exception.ExportException;
import com.kingdee.bos.qing.core.exception.UserStoppedException;
import com.kingdee.bos.qing.core.model.exhibition.longer.headcell.SubtotalCell;
import com.kingdee.bos.qing.core.model.exhibition.longer.headcell.TreeNodeCell;
import com.kingdee.bos.qing.export.common.diagonal.DiagonalUtil;
import com.kingdee.bos.qing.export.common.exception.ExportIOException;
import com.kingdee.bos.qing.export.common.exception.ExportTooMuchColsException;
import com.kingdee.bos.qing.export.common.exception.ExportTooMuchRowsException;
import com.kingdee.bos.qing.export.common.model.ExAlign;
import com.kingdee.bos.qing.export.common.model.ExBorder;
import com.kingdee.bos.qing.export.common.model.ExFont;
import com.kingdee.bos.qing.export.common.model.ExStyle;
import com.kingdee.bos.qing.export.common.model.IExportAdapter;
import com.kingdee.bos.qing.export.common.model.RowColRange;
import com.kingdee.bos.qing.export.common.util.UnitUtil;
import com.kingdee.bos.qing.export.excel.FlatHeaderStyleTVAdapter;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.awt.Color;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;

public class ExcelExport {
    private static final String DEFAULT_SHEET_NAME = "Sheet1";
    private static final int DEFAULT_KEEP_CELLS = 2000;
    private DataFormat dataFormat;
    private IExportAdapter tvAdapter;
    private HashMap<Object, Object> cellStyleMap = new HashMap();

    public ExcelExport(IExportAdapter tvAdapter) {
        this.tvAdapter = new FlatHeaderStyleTVAdapter(tvAdapter);
    }

    public void exportToFile(IQingFile file) throws ExportException {
        long start = System.currentTimeMillis();
        final int rowNum = this.tvAdapter.getRowCount();
        final int colNum = this.tvAdapter.getColCount();
        if (rowNum == 0 || colNum == 0) {
            return;
        }
        if (rowNum > 1048575) {
            throw new ExportTooMuchRowsException("1048575");
        }
        if (colNum > 16383) {
            throw new ExportTooMuchColsException("16383");
        }
        this.createTempDir();
        try {
            file.write(new IWriteCall(){

                public void call(OutputStream outputStream) throws IOException {
                    SXSSFWorkbook wbHelper = new SXSSFWorkbook(-1);
                    SXSSFWorkbook wb = new SXSSFWorkbook(ExcelExport.this.calKeepRows(colNum));
                    try {
                        ExcelExport.this.writeCellHelper(wbHelper, rowNum, colNum);
                        ExcelExport.this.setGroupRowHelper(wbHelper, rowNum, colNum);
                        ExcelExport.this.writeCell(wb, wbHelper, rowNum, colNum);
                        ExcelExport.this.setGroup(wb, rowNum, colNum);
                        wb.write(outputStream);
                    }
                    catch (UserStoppedException e) {
                        try {
                            throw new IOException((Throwable)((Object)e));
                        }
                        catch (Throwable throwable) {
                            wb.dispose();
                            CloseUtil.close((Closeable[])new Closeable[]{wb});
                            throw throwable;
                        }
                    }
                    wb.dispose();
                    CloseUtil.close((Closeable[])new Closeable[]{wb});
                }
            }, true);
        }
        catch (IOException e) {
            throw new ExportIOException(e);
        }
        finally {
            this.cellStyleMap.clear();
        }
        if (LogUtil.isDebugEnabled()) {
            LogUtil.debug((String)("export excel end,usedTime:" + (System.currentTimeMillis() - start)));
        }
    }

    private void writeCellHelper(SXSSFWorkbook wb, int rowNum, int colNum) throws UserStoppedException {
        int leftHeadColCount = this.tvAdapter.getLeftHeadColCount();
        SXSSFSheet sheet = wb.createSheet(DEFAULT_SHEET_NAME);
        for (int r = 0; r < rowNum; ++r) {
            Row row = sheet.createRow(r);
            for (int c = 0; c < leftHeadColCount; ++c) {
                row.createCell(c);
            }
        }
    }

    private void writeCell(SXSSFWorkbook wb, SXSSFWorkbook wbHelper, int rowNum, int colNum) throws UserStoppedException {
        int topHeadRowCount = this.tvAdapter.getTopHeadRowCount();
        int leftHeadColCount = this.tvAdapter.getLeftHeadColCount();
        SXSSFSheet sheet = wb.createSheet(DEFAULT_SHEET_NAME);
        SXSSFSheet sheetHelper = wbHelper.getSheetAt(0);
        this.initMergeBlock((Sheet)sheet, this.tvAdapter);
        if (this.dataFormat == null) {
            this.dataFormat = wb.createDataFormat();
        }
        for (int r = 0; r < rowNum; ++r) {
            SXSSFRow row = sheet.createRow(r);
            sheet.setRowOutlineLevel(r, sheetHelper.getRow(r).getOutlineLevel());
            row.setHeight((short)UnitUtil.pixelToTwip(this.tvAdapter.getRowHeight(r)));
            for (int c = 0; c < colNum; ++c) {
                String sValue;
                Cell cell = row.createCell(c);
                if (r == 0) {
                    sheet.setColumnWidth(c, (int)UnitUtil.pixelToExcelWidth(this.tvAdapter.getColWidth(c)));
                }
                XSSFCellStyle cellStyle = this.getCellStyle((Workbook)wb, r, c);
                Object oValue = this.tvAdapter.getCellModell(r, c);
                if (oValue instanceof TreeNodeCell) {
                    TreeNodeCell treeNode = (TreeNodeCell)oValue;
                    sValue = this.getStringOfTreeNode(r, c, treeNode, c < leftHeadColCount);
                    if (r < topHeadRowCount) {
                        cellStyle.setAlignment(HorizontalAlignment.CENTER);
                    }
                } else {
                    sValue = this.tvAdapter.getStringValue(oValue);
                }
                if (sValue.length() > Short.MAX_VALUE) {
                    sValue = sValue.substring(0, 32764) + "...";
                }
                if (r >= topHeadRowCount && c >= leftHeadColCount && sValue != null && sValue.length() > 0) {
                    try {
                        cell.setCellValue(Double.parseDouble(sValue));
                    }
                    catch (NumberFormatException t) {
                        cell.setCellValue(sValue);
                    }
                } else if (sValue == null || sValue.isEmpty()) {
                    cell.setBlank();
                } else {
                    cell.setCellValue(sValue);
                }
                cell.setCellStyle((CellStyle)cellStyle);
            }
        }
    }

    private String getStringOfTreeNode(int r, int c, TreeNodeCell treeNode, boolean isRowHeader) {
        if (treeNode.getText() == null || treeNode.getText().isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (isRowHeader) {
            for (int k = 0; k < treeNode.getLevel(); ++k) {
                sb.append("    ");
            }
            sb.append(treeNode.getText().trim());
        } else {
            sb.append(treeNode.getText());
        }
        return sb.toString();
    }

    private void setGroup(SXSSFWorkbook wb, int rowNum, int colNum) throws UserStoppedException {
        SXSSFSheet sheet = wb.getSheetAt(0);
        this.setGroupColumn((Sheet)sheet, rowNum, colNum);
        sheet.setRowSumsBelow(false);
        sheet.setRowSumsRight(false);
    }

    private void setGroupRowHelper(SXSSFWorkbook wb, int rowNum, int colNum) throws UserStoppedException {
        SXSSFSheet sheet = wb.getSheetAt(0);
        this.setGroupRow((Sheet)sheet, rowNum, colNum);
    }

    private void setGroupRow(Sheet sheet, int rowNum, int colNum) throws UserStoppedException {
        boolean isRow = true;
        int topHeadRowCount = this.tvAdapter.getTopHeadRowCount();
        int leftHeadColCount = this.tvAdapter.getLeftHeadColCount();
        int maxLevel = 8;
        int colMaxLevel = 0;
        int colPreMaxLevel = 0;
        int levelCount = 0;
        BitSet isColAllLeaf = new BitSet(leftHeadColCount);
        for (int c = 0; c < leftHeadColCount && levelCount <= maxLevel; ++levelCount, ++c) {
            Object node;
            boolean isAllLeaf = true;
            int r = topHeadRowCount;
            while (r < rowNum && (node = this.tvAdapter.getCellModell(r, c)) instanceof TreeNodeCell) {
                int level = ((TreeNodeCell)node).getLevel();
                RowColRange childrenRange = this.findChildrenRange(r, c, isRow);
                if (childrenRange != null) {
                    int currentLevel;
                    int levelAdd = 1;
                    if (level == 0 && (currentLevel = this.getLevelOfPreCol(r, c, isColAllLeaf)) != colPreMaxLevel) {
                        levelAdd = colPreMaxLevel - currentLevel;
                    }
                    this.groupRow(sheet, childrenRange.getFromRow(), childrenRange.getToRow(), levelAdd);
                    isAllLeaf = false;
                }
                if (colMaxLevel < level + colPreMaxLevel) {
                    colMaxLevel = level + colPreMaxLevel;
                }
                r = this.tvAdapter.getNextCellIndex(r, c, isRow);
            }
            isColAllLeaf.set(c, isAllLeaf);
            colPreMaxLevel = colMaxLevel;
        }
    }

    private void setGroupColumn(Sheet sheet, int rowNum, int colNum) throws UserStoppedException {
        boolean isRow = false;
        int topHeadRowCount = this.tvAdapter.getTopHeadRowCount();
        int leftHeadColCount = this.tvAdapter.getLeftHeadColCount();
        int maxLevel = 8;
        int rowMaxLevel = 0;
        int rowPreMaxLevel = 0;
        int levelCount = 0;
        BitSet isRowAllLeaf = new BitSet(leftHeadColCount);
        for (int r = 0; r < topHeadRowCount && levelCount <= maxLevel; ++levelCount, ++r) {
            Object node;
            boolean isAllLeaf = true;
            int c = leftHeadColCount;
            while (c < colNum && (node = this.tvAdapter.getCellModell(r, c)) instanceof TreeNodeCell) {
                int level = ((TreeNodeCell)node).getLevel();
                RowColRange childrenRange = this.findChildrenRange(r, c, isRow);
                if (childrenRange != null) {
                    int currentLevel;
                    int levelAdd = 1;
                    if (level == 0 && (currentLevel = this.getLevelOfPreRow(r, c, isRowAllLeaf)) != rowPreMaxLevel) {
                        levelAdd = rowPreMaxLevel - currentLevel;
                    }
                    this.groupColumn(sheet, childrenRange.getFromCol(), childrenRange.getToCol(), levelAdd);
                    isAllLeaf = false;
                }
                if (rowMaxLevel < level + rowPreMaxLevel) {
                    rowMaxLevel = level + rowPreMaxLevel;
                }
                c = this.tvAdapter.getNextCellIndex(r, c, isRow);
            }
            isRowAllLeaf.set(r, isAllLeaf);
            rowPreMaxLevel = rowMaxLevel;
        }
    }

    private int getLevelOfPreCol(int r, int c, BitSet isColAllLeaf) {
        int level = 0;
        for (int i = 0; i < c; ++i) {
            Object nextCellModel;
            Object cellModel = this.tvAdapter.getCellModell(r, i);
            if (!(cellModel instanceof TreeNodeCell)) continue;
            TreeNodeCell node = (TreeNodeCell)cellModel;
            level += node.getLevel();
            if (isColAllLeaf.get(i) || !this.isLeafNode(node, nextCellModel = this.tvAdapter.getCellModell(this.tvAdapter.getNextCellIndex(r, i, true), i))) continue;
            --level;
        }
        return level;
    }

    private int getLevelOfPreRow(int r, int c, BitSet isRowAllLeaf) {
        int level = 0;
        for (int i = 0; i < r; ++i) {
            Object nextCellModel;
            Object cellModel = this.tvAdapter.getCellModell(i, c);
            if (!(cellModel instanceof TreeNodeCell)) continue;
            TreeNodeCell node = (TreeNodeCell)cellModel;
            level += node.getLevel();
            if (isRowAllLeaf.get(i) || !this.isLeafNode(node, nextCellModel = this.tvAdapter.getCellModell(i, this.tvAdapter.getNextCellIndex(i, c, false)))) continue;
            --level;
        }
        return level;
    }

    private RowColRange findChildrenRange(int r, int c, boolean isRow) {
        int i;
        RowColRange range = null;
        Object cell = this.tvAdapter.getCellModell(r, c);
        int currentLevel = ((TreeNodeCell)cell).getLevel();
        int toIndex = -1;
        int len = (isRow ? this.tvAdapter.getRowCount() : this.tvAdapter.getColCount()) - 1;
        int n = i = isRow ? r : c;
        while (i < len) {
            Object nextCell;
            int nextI;
            int n2 = nextI = isRow ? this.tvAdapter.getNextCellIndex(i, c, isRow) : this.tvAdapter.getNextCellIndex(r, i, isRow);
            if (nextI > len) break;
            Object object = nextCell = isRow ? this.tvAdapter.getCellModell(nextI, c) : this.tvAdapter.getCellModell(r, nextI);
            if (nextCell != null) {
                RowColRange nextCellRange;
                if (nextCell instanceof TreeNodeCell) {
                    TreeNodeCell nextNode = (TreeNodeCell)nextCell;
                    if (nextNode.getLevel() <= currentLevel) break;
                    if (nextNode.getLevel() > currentLevel) {
                        if (isRow) {
                            nextCellRange = this.tvAdapter.getCellRange(nextI, c);
                            toIndex = nextCellRange.getToRow();
                        } else {
                            nextCellRange = this.tvAdapter.getCellRange(r, nextI);
                            toIndex = nextCellRange.getToCol();
                        }
                    }
                } else if (nextCell instanceof SubtotalCell) {
                    nextCellRange = this.tvAdapter.getCellRange(nextI, c);
                    toIndex = nextCellRange.getToRow();
                }
            }
            i = nextI;
        }
        if (toIndex != -1) {
            range = new RowColRange();
            if (isRow) {
                range.setFromRow(r + 1);
                range.setToRow(toIndex);
            } else {
                range.setFromCol(c + 1);
                range.setToCol(toIndex);
            }
        }
        return range;
    }

    private void groupRow(Sheet sheet, int fromRow, int toRow, int times) {
        for (int i = 0; i < times; ++i) {
            sheet.groupRow(fromRow, toRow);
        }
    }

    private void groupColumn(Sheet sheet, int fromCol, int toCol, int times) {
        for (int j = 0; j < times; ++j) {
            sheet.groupColumn(fromCol, toCol);
        }
    }

    private boolean isLeafNode(TreeNodeCell node, Object nextCellModel) {
        if (nextCellModel instanceof TreeNodeCell) {
            return ((TreeNodeCell)nextCellModel).getLevel() <= node.getLevel();
        }
        return true;
    }

    private void createCrossHeader(Workbook wb, Sheet sheet) {
        byte[] crossHeader = DiagonalUtil.getCrossHeader(1.0f, this.tvAdapter);
        if (crossHeader != null) {
            int picIndex = wb.addPicture(crossHeader, 6);
            Drawing patriarch = sheet.createDrawingPatriarch();
            XSSFClientAnchor anchor = new XSSFClientAnchor(0, 0, 1023, 255, 0, 0, this.tvAdapter.getLeftHeadColCount(), this.tvAdapter.getTopHeadRowCount());
            patriarch.createPicture((ClientAnchor)anchor, picIndex);
        }
    }

    private int calKeepRows(int colNum) {
        int keepRows = 2000 / colNum;
        return keepRows == 0 ? 1 : keepRows;
    }

    private XSSFCellStyle getCellStyle(Workbook wb, int rowIndex, int colIndex) {
        XSSFCellStyle cellStyle;
        ExStyle style = this.tvAdapter.styleAt(rowIndex, colIndex);
        if (this.cellStyleMap.containsKey(style.hashCode())) {
            cellStyle = (XSSFCellStyle)this.cellStyleMap.get(style.hashCode());
        } else {
            cellStyle = (XSSFCellStyle)wb.createCellStyle();
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cellStyle.setFillForegroundColor(new XSSFColor(style.getBackgroundColor() == null ? Color.white : style.getBackgroundColor(), (IndexedColorMap)new DefaultIndexedColorMap()));
            if (style.getVerticalAlignment() == ExAlign.MIDDLE) {
                cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            }
            switch (style.getHorizontalAlignment()) {
                case CENTER: {
                    cellStyle.setAlignment(HorizontalAlignment.CENTER);
                    break;
                }
                case LEFT: {
                    cellStyle.setAlignment(HorizontalAlignment.LEFT);
                    break;
                }
                case RIGHT: {
                    cellStyle.setAlignment(HorizontalAlignment.RIGHT);
                    break;
                }
            }
            ExFont exFont = style.getExFont();
            XSSFFont font = (XSSFFont)wb.createFont();
            font.setFontName(exFont.getFontName());
            font.setFontHeightInPoints((short)exFont.getFontSize());
            font.setBold(exFont.getFontStyle() == 1);
            ExBorder borderTop = style.getBorderTop();
            ExBorder borderBottom = style.getBorderBottom();
            ExBorder borderLeft = style.getBorderLeft();
            ExBorder borderRight = style.getBorderRight();
            if (borderTop != null) {
                cellStyle.setBorderTop(BorderStyle.THIN);
                cellStyle.setBorderColor(XSSFCellBorder.BorderSide.TOP, new XSSFColor(borderTop.getBorderColor(), (IndexedColorMap)new DefaultIndexedColorMap()));
            }
            if (borderBottom != null) {
                cellStyle.setBorderBottom(BorderStyle.THIN);
                cellStyle.setBorderColor(XSSFCellBorder.BorderSide.BOTTOM, new XSSFColor(borderBottom.getBorderColor(), (IndexedColorMap)new DefaultIndexedColorMap()));
            }
            if (borderLeft != null) {
                cellStyle.setBorderLeft(BorderStyle.THIN);
                cellStyle.setBorderColor(XSSFCellBorder.BorderSide.LEFT, new XSSFColor(borderLeft.getBorderColor(), (IndexedColorMap)new DefaultIndexedColorMap()));
            }
            if (borderRight != null) {
                cellStyle.setBorderRight(BorderStyle.THIN);
                cellStyle.setBorderColor(XSSFCellBorder.BorderSide.RIGHT, new XSSFColor(borderRight.getBorderColor(), (IndexedColorMap)new DefaultIndexedColorMap()));
            }
            if (style.getForegroundColor() != null) {
                font.setColor(new XSSFColor(style.getForegroundColor(), (IndexedColorMap)new DefaultIndexedColorMap()));
            }
            String formatString = style.getFormatString();
            cellStyle.setFont((Font)font);
            if (formatString != null && formatString.length() > 0) {
                cellStyle.setDataFormat(this.dataFormat.getFormat(formatString));
            }
            this.cellStyleMap.put(style.hashCode(), cellStyle);
        }
        return cellStyle;
    }

    private void initFreezeLine(Sheet sheet, IExportAdapter tvAdapter) {
        sheet.createFreezePane(tvAdapter.getLeftHeadColCount(), tvAdapter.getTopHeadRowCount());
    }

    private void initMergeBlock(Sheet sheet, IExportAdapter tvAdapter) {
        List<RowColRange> mergeRanges = tvAdapter.getMergeRanges();
        if (mergeRanges == null) {
            return;
        }
        IExcelCustomStrategy excelCustomService = (IExcelCustomStrategy)CustomStrategyRegistrar.getStrategy(IExcelCustomStrategy.class);
        for (RowColRange rowColRange : mergeRanges) {
            CellRangeAddress cellRangeAddress = new CellRangeAddress(rowColRange.getFromRow(), rowColRange.getToRow(), rowColRange.getFromCol(), rowColRange.getToCol());
            excelCustomService.addMergedRegion(sheet, cellRangeAddress);
        }
    }

    private void createTempDir() {
        String tmpdir = System.getProperty("java.io.tmpdir");
        File dir = new File(tmpdir, "poifiles");
        boolean dirExists = dir.exists() || dir.mkdirs();
        try {
            if (!dirExists) {
                throw new IOException("Could not create temporary directory '" + dir + "'");
            }
            if (!dir.isDirectory()) {
                throw new IOException("Could not create temporary directory. '" + dir + "' exists but is not a directory.");
            }
        }
        catch (IOException e) {
            LogUtil.error((String)"Fail to create temporary directory", (Throwable)e);
        }
    }
}

