/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.excel;

import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererForLegend;
import com.kingdee.bos.qing.export.common.model.ExAlign;
import com.kingdee.bos.qing.export.common.model.ExBorder;
import com.kingdee.bos.qing.export.common.model.ExFont;
import com.kingdee.bos.qing.export.common.model.ExStyle;
import com.kingdee.bos.qing.export.common.model.IExportAdapter;
import com.kingdee.bos.qing.export.common.model.RowColRange;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;

public class FlatHeaderStyleTVAdapter
implements IExportAdapter {
    private static final int TOPHEAD_ROWCOUNT = 1;
    private IExportAdapter tvAdapter;
    private boolean diagonalExist;

    public FlatHeaderStyleTVAdapter(IExportAdapter tvAdapter) {
        this.tvAdapter = tvAdapter;
        this.diagonalExist = tvAdapter.getDiagonalTitles() != null;
    }

    @Override
    public int getTopHeadRowCount() {
        int extraRowCount = this.diagonalExist ? 1 : 0;
        return this.tvAdapter.getTopHeadRowCount() + extraRowCount;
    }

    @Override
    public List<RowColRange> getMergeRanges() {
        int leftHeadColCount;
        int totalColCount;
        int bodyColCount;
        List<RowColRange> mergeRanges = this.tvAdapter.getMergeRanges();
        if (!this.diagonalExist) {
            return mergeRanges;
        }
        if (mergeRanges == null) {
            mergeRanges = new ArrayList<RowColRange>();
            RowColRange leftTop = new RowColRange(0, 0, 0, 0);
            mergeRanges.add(leftTop);
        }
        RowColRange diagonalBlock = null;
        for (RowColRange range : mergeRanges) {
            range.setToRow(range.getToRow() + 1);
            if (!this.isDiagonalBlock(range)) {
                range.setFromRow(range.getFromRow() + 1);
                continue;
            }
            diagonalBlock = range;
        }
        if (diagonalBlock != null) {
            int fromCol = 0;
            int toCol = 0;
            int fromRow = diagonalBlock.getFromRow();
            int toRow = diagonalBlock.getToRow();
            for (int i = 0; i <= diagonalBlock.getToCol(); ++i) {
                RowColRange splitDiagonal = new RowColRange(fromRow, toRow, fromCol, toCol);
                mergeRanges.add(splitDiagonal);
                ++fromCol;
                ++toCol;
            }
            mergeRanges.remove(diagonalBlock);
        }
        if ((bodyColCount = (totalColCount = this.getColCount()) - (leftHeadColCount = this.getLeftHeadColCount())) > 1) {
            int topFromCol = Math.max(0, leftHeadColCount);
            int topToCol = Math.max(0, totalColCount - 1);
            RowColRange topColBlock = new RowColRange(0, 0, topFromCol, topToCol);
            mergeRanges.add(topColBlock);
        }
        return mergeRanges;
    }

    private boolean isDiagonalBlock(RowColRange range) {
        return range.getFromCol() == 0 && range.getFromRow() == 0;
    }

    @Override
    public Color getRowHeadColor() {
        return this.tvAdapter.getRowHeadColor();
    }

    @Override
    public int getRowHeight(int index) {
        int idxInTV = this.diagonalExist ? Math.max(0, index - 1) : index;
        return this.tvAdapter.getRowHeight(idxInTV);
    }

    @Override
    public int getColWidth(int index) {
        return this.tvAdapter.getColWidth(index);
    }

    @Override
    public int getRowCount() {
        int extraRowCount = this.diagonalExist ? 1 : 0;
        return this.tvAdapter.getRowCount() + extraRowCount;
    }

    @Override
    public int getColCount() {
        return this.tvAdapter.getColCount();
    }

    @Override
    public RowColRange getCellRange(int row, int col) {
        return this.tvAdapter.getCellRange(row, col);
    }

    @Override
    public int getNextCellIndex(int row, int col, boolean isNextOfRow) {
        return this.tvAdapter.getNextCellIndex(row, col, isNextOfRow);
    }

    @Override
    public String textAt(int row, int col) {
        return this.tvAdapter.textAt(row, col);
    }

    @Override
    public Object getCellModell(int row, int col) {
        if (!this.diagonalExist) {
            return this.tvAdapter.getCellModell(row, col);
        }
        if (row == 0 && col >= this.getLeftHeadColCount()) {
            List<String> titles = this.tvAdapter.getDiagonalTitles();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.tvAdapter.getTopHeadRowCount(); ++i) {
                sb.append(titles.get(i));
                if (i == this.tvAdapter.getTopHeadRowCount() - 1) continue;
                sb.append("/");
            }
            return sb.toString();
        }
        if (col < this.getLeftHeadColCount() && row < this.getTopHeadRowCount()) {
            List<String> titles = this.tvAdapter.getDiagonalTitles();
            int idx = titles.size() - col - 1;
            return titles.get(idx);
        }
        return this.tvAdapter.getCellModell(row - 1, col);
    }

    @Override
    public String getStringValue(Object obj) {
        return this.tvAdapter.getStringValue(obj);
    }

    @Override
    public void drawCell(int row, int col, ExStyle cellStyle, Graphics jdkGraphics) {
        this.tvAdapter.drawCell(row, col, cellStyle, jdkGraphics);
    }

    @Override
    public ExStyle styleAt(int row, int col) {
        if (!this.diagonalExist) {
            return this.tvAdapter.styleAt(row, col);
        }
        ExStyle style = this.tvAdapter.styleAt(Math.max(0, row - 1), col);
        if (row < 1) {
            style.setHorizontalAlignment(ExAlign.CENTER);
            style.setExFont(new ExFont());
        }
        if (row < this.getTopHeadRowCount() && col < this.getLeftHeadColCount()) {
            style.setBorderRight(new ExBorder());
        }
        return style;
    }

    @Override
    public int getLeftHeadColCount() {
        return this.tvAdapter.getLeftHeadColCount();
    }

    @Override
    public boolean isAtColHeader(int row) {
        return this.tvAdapter.isAtColHeader(row);
    }

    @Override
    public boolean isAtRowHeader(int col) {
        return this.tvAdapter.isAtRowHeader(col);
    }

    @Override
    public List<String> getDiagonalTitles() {
        return this.tvAdapter.getDiagonalTitles();
    }

    @Override
    public ExFont getFont() {
        return this.tvAdapter.getFont();
    }

    @Override
    public int getAllRowHeight() {
        return this.tvAdapter.getAllRowHeight();
    }

    @Override
    public int getAllColWidth() {
        return this.tvAdapter.getAllColWidth();
    }

    @Override
    public boolean isRowFirst() {
        return this.tvAdapter.isRowFirst();
    }

    @Override
    public boolean isTopHeaderAll() {
        return this.tvAdapter.isTopHeaderAll();
    }

    @Override
    public boolean isLeftHeaderAll() {
        return this.tvAdapter.isLeftHeaderAll();
    }

    @Override
    public boolean isLegendAll() {
        return this.tvAdapter.isLegendAll();
    }

    @Override
    public void setTopHeaderAll(boolean b) {
        this.tvAdapter.setTopHeaderAll(b);
    }

    @Override
    public void setLeftHeaderAll(boolean b) {
        this.tvAdapter.setLeftHeaderAll(b);
    }

    @Override
    public CellRendererForLegend.LegendRenderParameter getLegendRenderParameter() {
        return this.tvAdapter.getLegendRenderParameter();
    }

    @Override
    public ExStyle getLengendStyle() {
        return this.tvAdapter.getLengendStyle();
    }

    @Override
    public int getLegendNumber() {
        return this.tvAdapter.getLegendNumber();
    }

    @Override
    public int getLegendWidth() {
        return this.tvAdapter.getLegendWidth();
    }

    @Override
    public int getLegendGap() {
        return this.tvAdapter.getLegendGap();
    }

    @Override
    public int getVerticalLegendWidth() {
        return this.tvAdapter.getVerticalLegendWidth();
    }

    @Override
    public int getVerticalLegendHeight() {
        return this.tvAdapter.getVerticalLegendHeight();
    }

    @Override
    public int getHorizontalLegendWidth() {
        return this.tvAdapter.getHorizontalLegendWidth();
    }

    @Override
    public int getHorizontalLegendHeight() {
        return this.tvAdapter.getHorizontalLegendHeight();
    }
}

