/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.image;

import com.kingdee.bos.qing.core.exception.ExportException;
import com.kingdee.bos.qing.core.exception.UserStoppedException;
import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererForLegend;
import com.kingdee.bos.qing.export.common.diagonal.DiagonalUtil;
import com.kingdee.bos.qing.export.common.exception.ExportIOException;
import com.kingdee.bos.qing.export.common.exception.ExportJavaScriptException;
import com.kingdee.bos.qing.export.common.exception.ExportTooMuchColsException;
import com.kingdee.bos.qing.export.common.model.ExBorder;
import com.kingdee.bos.qing.export.common.model.ExFont;
import com.kingdee.bos.qing.export.common.model.ExStyle;
import com.kingdee.bos.qing.export.common.model.IExportAdapter;
import com.kingdee.bos.qing.export.common.model.LegendAlign;
import com.kingdee.bos.qing.export.common.model.RowColRange;
import com.kingdee.bos.qing.export.common.util.UnitUtil;
import com.kingdee.bos.qing.export.image.AbstractImageExport;
import com.kingdee.bos.qing.export.image.model.PageInfo;
import com.kingdee.bos.qing.export.image.util.PngUtil;
import com.kingdee.bos.qing.export.pdf.model.DimensionFloat;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.localimpl.LocalTempQingFile;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ImageExport
extends AbstractImageExport {
    private static final int ONE_IMAGE_SIZE = 0x400000;
    private static final int COMPRESSION = 9;
    private static final int INDEX_INIT_VALUE = -2;
    private IExportAdapter tvAdapter;
    private int topHeadRowCount;
    private int leftHeadColCount;
    private LegendAlign legendAlign = LegendAlign.RIGHT_VERTICAL;
    private boolean exportWithLegend = true;

    public ImageExport(IExportAdapter tvAdapter, String imageType) {
        this.tvAdapter = tvAdapter;
        this.imageType = imageType;
        this.topHeadRowCount = tvAdapter.getTopHeadRowCount();
        this.leftHeadColCount = tvAdapter.getLeftHeadColCount();
    }

    @Override
    public void exportToFile(IQingFile fileName) throws UserStoppedException, ExportException {
        int allRowHeight;
        int allColWidth = this.tvAdapter.getAllColWidth();
        if ((long)allColWidth * (long)(allRowHeight = this.tvAdapter.getAllRowHeight()) > Integer.MAX_VALUE) {
            throw new ExportTooMuchColsException();
        }
        int iImageType = this.getBufferedImageType();
        int imageWidth = allColWidth;
        int imageHeight = allRowHeight;
        LocalTempQingFile legendImageSavedFileName = null;
        try {
            if (this.tvAdapter.getLegendNumber() > 0 && this.exportWithLegend) {
                legendImageSavedFileName = new LocalTempQingFile(QingTempFileType.EXPORT);
                DimensionFloat dimension = this.drawLegend(imageWidth, imageHeight, this.legendAlign, legendImageSavedFileName, iImageType);
                imageWidth = (int)dimension.getWidth();
                imageHeight = (int)dimension.getHeight();
            }
            this.export(fileName, legendImageSavedFileName, iImageType, this.legendAlign, ++imageWidth, ++imageHeight, this.tvAdapter.getRowCount(), this.tvAdapter.getColCount());
        }
        catch (IOException e) {
            throw new ExportIOException(e);
        }
    }

    private void export(IQingFile exportFile, LocalTempQingFile legendImageSavedFileName, int iImageType, LegendAlign legendAlign, int imageWidth, int imageHeight, int exportRowCount, int exportColCount) throws UserStoppedException, ExportException {
        long start = System.currentTimeMillis();
        if (exportRowCount == 0 || exportColCount == 0) {
            return;
        }
        ArrayList imagePaths = new ArrayList();
        PageInfo pageInfo = null;
        int fromRow = 0;
        int fromCol = 0;
        int toRow = -2;
        while (fromRow < exportRowCount) {
            int yMove;
            ArrayList<LocalTempQingFile> oneRowImagePaths = new ArrayList<LocalTempQingFile>();
            imagePaths.add(oneRowImagePaths);
            int n = yMove = fromRow == 0 ? 0 : -1;
            while (fromCol < exportColCount) {
                int xMove;
                pageInfo = this.paging(exportRowCount, exportColCount, fromRow, fromCol, 0x400000, toRow);
                if (fromRow == 0) {
                    pageInfo.setHeight(pageInfo.getHeight() + 1);
                }
                if (fromCol == 0) {
                    pageInfo.setWidth(pageInfo.getWidth() + 1);
                    xMove = 0;
                } else {
                    xMove = -1;
                }
                LocalTempQingFile file = new LocalTempQingFile(QingTempFileType.EXPORT);
                this.drawOneImage(xMove, yMove, pageInfo, iImageType, file);
                oneRowImagePaths.add(file);
                fromCol = pageInfo.getToCol() + 1;
                toRow = pageInfo.getToRow();
            }
            if (pageInfo == null) break;
            fromRow = pageInfo.getToRow() + 1;
            toRow = -2;
            fromCol = 0;
        }
        ArrayList<LocalTempQingFile[]> imagePathList = new ArrayList<LocalTempQingFile[]>(imagePaths.size());
        for (List list : imagePaths) {
            LocalTempQingFile[] strArray = new LocalTempQingFile[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                strArray[i] = (LocalTempQingFile)list.get(i);
            }
            imagePathList.add(strArray);
        }
        try {
            this.mergeImage(imagePathList, legendImageSavedFileName, exportFile, imageWidth, imageHeight, legendAlign);
        }
        catch (IOException e) {
            throw new ExportIOException(e);
        }
        if (LogUtil.isDebugEnabled()) {
            LogUtil.debug((String)("export " + iImageType + " end, usedTime:" + (System.currentTimeMillis() - start)));
        }
    }

    private void drawOneImage(int startX, int startY, PageInfo pageInfo, int iImageType, LocalTempQingFile imageSavedPath) throws UserStoppedException, ExportException {
        int imageWidth = pageInfo.getWidth();
        int imageHeight = pageInfo.getHeight();
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, iImageType);
        Graphics2D mainGraphics = (Graphics2D)image.getGraphics();
        mainGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        mainGraphics.setBackground(this.backgroundColor);
        mainGraphics.setColor(this.backgroundColor);
        mainGraphics.fillRect(startX, startY, imageWidth, startY < 0 ? imageHeight - startY : imageHeight);
        this.drawChart(mainGraphics, startX, startY, pageInfo);
        this.writeImg(image, (IQingFile)imageSavedPath);
        mainGraphics.dispose();
    }

    private void exportMergeImage(IQingFile exportFile, final List<InputStream[]> imageISs, final int[] backgroundColorRgba, final int totalWidth, final int totalHeight, int compression, final InputStream rightmostImageIS) throws IOException {
        exportFile.write(new IWriteCall(){

            public void call(OutputStream outputStream) throws IOException {
                PngUtil.merge(outputStream, imageISs, backgroundColorRgba, totalWidth, totalHeight, 9, rightmostImageIS);
            }
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mergeImage(List<LocalTempQingFile[]> imageFiles, LocalTempQingFile legendImage, IQingFile exportFile, int width, int mergedImageHeight, LegendAlign legendAlign) throws IOException {
        QingInputStream legendImageIS;
        List<InputStream[]> imageISs;
        block9: {
            imageISs = null;
            legendImageIS = null;
            try {
                if (imageFiles.size() != 1 || imageFiles.get(0).length != 1 || legendImage != null) break block9;
                QingInputStream inputStream = null;
                try {
                    inputStream = imageFiles.get(0)[0].getInputStream();
                    exportFile.write((IWriteCall)new CopyWriteCall((InputStream)inputStream, false), true);
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                this.closeInputStreamForExportFile(imageISs);
            }
            catch (Throwable throwable) {
                this.closeInputStreamForExportFile(imageISs);
                CloseUtil.close((Closeable[])new Closeable[]{legendImageIS});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{legendImageIS});
            return;
        }
        if (legendImage != null) {
            int[] backgroundColorRgba = new int[]{this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), this.backgroundColor.getAlpha()};
            if (LegendAlign.RIGHT_HORIZONTAL == legendAlign || LegendAlign.RIGHT_VERTICAL == legendAlign) {
                imageISs = this.getInputStreamFormExportFile(imageFiles);
                legendImageIS = legendImage.getInputStream();
                this.exportMergeImage(exportFile, imageISs, backgroundColorRgba, width, mergedImageHeight, 9, (InputStream)legendImageIS);
            } else {
                if (LegendAlign.BOTTOM_HORIZONTAL != legendAlign && LegendAlign.BOTTOM_VERTICAL != legendAlign) throw new RuntimeException("Unsupported legendAlign: " + (Object)((Object)legendAlign));
                imageFiles.add(new LocalTempQingFile[]{legendImage});
                imageISs = this.getInputStreamFormExportFile(imageFiles);
                this.exportMergeImage(exportFile, imageISs, backgroundColorRgba, width, mergedImageHeight, 9, null);
            }
        } else {
            imageISs = this.getInputStreamFormExportFile(imageFiles);
            this.exportMergeImage(exportFile, imageISs, null, width, mergedImageHeight, 9, null);
        }
        this.closeInputStreamForExportFile(imageISs);
        CloseUtil.close((Closeable[])new Closeable[]{legendImageIS});
    }

    private void closeInputStreamForExportFile(List<InputStream[]> iss) {
        if (iss == null || iss.size() == 0) {
            return;
        }
        for (InputStream[] issArray : iss) {
            for (InputStream is : issArray) {
                CloseUtil.close((Closeable[])new Closeable[]{is});
            }
        }
    }

    private List<InputStream[]> getInputStreamFormExportFile(List<LocalTempQingFile[]> files) throws FileNotFoundException {
        if (files == null || files.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<InputStream[]> result = new ArrayList<InputStream[]>();
        try {
            for (LocalTempQingFile[] fileArray : files) {
                InputStream[] iss = new InputStream[fileArray.length];
                result.add(iss);
                int index = 0;
                for (LocalTempQingFile exportFile : fileArray) {
                    iss[index] = exportFile.getInputStream();
                    ++index;
                }
            }
            return result;
        }
        catch (FileNotFoundException e) {
            this.closeInputStreamForExportFile(result);
            result.clear();
            throw e;
        }
    }

    private PageInfo paging(int rowCount, int colCount, int row, int col, int oneImageSize, int toRow) {
        int width;
        int height;
        int r;
        PageInfo page = new PageInfo();
        page.setFromRow(row);
        page.setFromCol(col);
        int fromRow = row;
        int fromCol = col;
        int toCol = -2;
        int imageWidth = 0;
        int imageHeight = 0;
        if (fromRow == 0 && fromCol == 0) {
            for (r = fromRow; r < this.topHeadRowCount; ++r) {
                height = this.tvAdapter.getRowHeight(r);
                imageHeight += height;
            }
            toRow = -2;
            fromRow = this.topHeadRowCount;
            if (imageHeight == 0) {
                imageHeight = 1;
            }
            height = imageHeight;
            for (int c = 0; c < this.leftHeadColCount; ++c) {
                width = this.tvAdapter.getColWidth(c);
                imageWidth += width;
            }
            toCol = this.leftHeadColCount - 1;
            fromCol = this.leftHeadColCount;
        } else if (toRow != -2) {
            height = 0;
            for (r = fromRow; r <= toRow; ++r) {
                height += this.tvAdapter.getRowHeight(r);
            }
        } else {
            height = this.tvAdapter.getRowHeight(fromRow);
        }
        int oneImageWidth = oneImageSize / height;
        int c = fromCol;
        while (c < colCount) {
            width = this.tvAdapter.getColWidth(c);
            if ((imageWidth += width) > oneImageWidth) {
                imageWidth -= width;
                break;
            }
            toCol = c++;
        }
        if (toRow == -2) {
            if (imageWidth > 0) {
                int oneImageHeight = oneImageSize / imageWidth;
                toRow = fromRow - 1;
                int r2 = fromRow;
                while (r2 < rowCount) {
                    height = this.tvAdapter.getRowHeight(r2);
                    if ((imageHeight += height) > oneImageHeight) {
                        imageHeight -= height;
                        break;
                    }
                    toRow = r2++;
                }
            }
        } else {
            imageHeight = height;
        }
        page.setToRow(toRow);
        page.setToCol(toCol);
        page.setWidth(imageWidth);
        page.setHeight(imageHeight);
        return page;
    }

    private void drawChart(Graphics2D mainGraphics, int startX, int startY, PageInfo rowColRange) throws UserStoppedException {
        int xMove = startX;
        int yMove = startY;
        int fromRow = rowColRange.getFromRow();
        int toRow = rowColRange.getToRow();
        int fromCol = rowColRange.getFromCol();
        int toCol = rowColRange.getToCol();
        List<String> diagonalTitles = null;
        if (fromRow == 0 && fromCol == 0) {
            diagonalTitles = this.tvAdapter.getDiagonalTitles();
        }
        int r = fromRow;
        while (r <= toRow) {
            int height = this.tvAdapter.getRowHeight(r);
            xMove = startX;
            int c = fromCol;
            while (c <= toCol) {
                int width = this.tvAdapter.getColWidth(c);
                ExStyle mergeCellStyle = this.getMergeCellStyle(r, c, fromRow, fromCol);
                if (mergeCellStyle != null) {
                    Graphics cellGraphics;
                    this.drawBackground(mainGraphics, xMove, yMove, mergeCellStyle);
                    ExFont exFont = mergeCellStyle.getExFont();
                    float fontSize = (float)exFont.getFontSize() * UnitUtil.getCurrentDpi() / 72.0f;
                    mainGraphics.setFont(ExFont.getDefaultAwtFont().deriveFont(exFont.getFontStyle(), fontSize));
                    if (r == 0 && c == 0 && diagonalTitles != null && !diagonalTitles.isEmpty()) {
                        cellGraphics = mainGraphics.create(xMove + 1, yMove + 1, mergeCellStyle.getWidth(), mergeCellStyle.getHeight());
                        cellGraphics.setColor(mergeCellStyle.getForegroundColor());
                        this.createCrossHeader(cellGraphics);
                        cellGraphics.dispose();
                        this.drawBorder(mainGraphics, xMove, yMove, mergeCellStyle);
                    } else {
                        String text = this.tvAdapter.textAt(r, c);
                        if (text != null && !text.isEmpty()) {
                            int xBorderReal = xMove;
                            int xOffset = 0;
                            int yOffset = 0;
                            if (c == fromCol) {
                                xOffset = mergeCellStyle.getxOffset();
                                xBorderReal += xOffset;
                            }
                            int yBorderReal = yMove;
                            if (r == fromRow) {
                                yOffset = mergeCellStyle.getyOffset();
                                yBorderReal += yOffset;
                            }
                            cellGraphics = mainGraphics.create(xMove + 1, yMove + 1, mergeCellStyle.getWidth(), mergeCellStyle.getHeight());
                            this.tvAdapter.drawCell(r, c, mergeCellStyle, cellGraphics);
                            cellGraphics.dispose();
                            this.drawBorder(mainGraphics, xBorderReal, yBorderReal, mergeCellStyle);
                        } else {
                            cellGraphics = mainGraphics.create(xMove + 1, yMove + 1, mergeCellStyle.getWidth(), mergeCellStyle.getHeight());
                            this.tvAdapter.drawCell(r, c, mergeCellStyle, cellGraphics);
                            cellGraphics.dispose();
                            this.drawBorder(mainGraphics, xMove, yMove, mergeCellStyle);
                        }
                    }
                }
                ++c;
                xMove += width;
            }
            ++r;
            yMove += height;
        }
    }

    private DimensionFloat drawLegend(int chartWidth, int chartHeight, LegendAlign legendAlign, LocalTempQingFile legendImageSavedPath, int iImageType) throws UserStoppedException, IOException, ExportException {
        int legendGap = this.tvAdapter.getLegendGap();
        switch (legendAlign) {
            case RIGHT_VERTICAL: {
                int legendWidth = legendGap + this.tvAdapter.getVerticalLegendWidth() + 1;
                chartWidth += legendWidth;
                int legendHeight = this.tvAdapter.getVerticalLegendHeight() + 1;
                chartHeight = Math.max(chartHeight, legendHeight);
                this.drawLegendOnImage(legendGap, 0, legendWidth, legendHeight, iImageType, legendImageSavedPath, true);
                break;
            }
            case BOTTOM_VERTICAL: {
                int legendWidth = this.tvAdapter.getVerticalLegendWidth() + 1;
                chartWidth = Math.max(chartWidth, legendWidth);
                int legendHeight = legendGap + this.tvAdapter.getVerticalLegendHeight() + 1;
                chartHeight += legendHeight;
                this.drawLegendOnImage(0, legendGap, legendWidth, legendHeight, iImageType, legendImageSavedPath, true);
                break;
            }
            case RIGHT_HORIZONTAL: {
                int legendWidth = legendGap + this.tvAdapter.getHorizontalLegendWidth() + 1;
                chartWidth += legendWidth;
                int legendHeight = this.tvAdapter.getHorizontalLegendHeight() + 1;
                chartHeight = Math.max(chartHeight, legendHeight);
                this.drawLegendOnImage(legendGap, 0, legendWidth, legendHeight, iImageType, legendImageSavedPath, false);
                break;
            }
            case BOTTOM_HORIZONTAL: {
                int legendWidth = this.tvAdapter.getHorizontalLegendWidth() + 1;
                chartWidth = Math.max(chartWidth, legendWidth);
                int legendHeight = legendGap + this.tvAdapter.getHorizontalLegendHeight() + 1;
                chartHeight += legendHeight;
                this.drawLegendOnImage(0, legendGap, legendWidth, legendHeight, iImageType, legendImageSavedPath, false);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported legendAlign: " + (Object)((Object)legendAlign));
            }
        }
        return new DimensionFloat(chartWidth, chartHeight);
    }

    private void drawLegendOnImage(int startX, int startY, int imageWidth, int imageHeight, int iImageType, LocalTempQingFile imageSavedPath, boolean isVerticalAlign) throws UserStoppedException, IOException, ExportException {
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, iImageType);
        Graphics2D mainGraphics = (Graphics2D)image.getGraphics();
        mainGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        mainGraphics.setBackground(this.backgroundColor);
        mainGraphics.setColor(this.backgroundColor);
        mainGraphics.fillRect(0, 0, imageWidth, startY < 0 ? imageHeight - startY : imageHeight);
        ExFont exFont = this.tvAdapter.getFont();
        float fontSize = (float)exFont.getFontSize() * UnitUtil.getCurrentDpi() / 72.0f;
        mainGraphics.setFont(ExFont.getDefaultAwtFont().deriveFont(fontSize));
        this.drawLegendOnGraphics(mainGraphics, startX, startY, isVerticalAlign);
        this.writeImg(image, (IQingFile)imageSavedPath);
        mainGraphics.dispose();
    }

    private void drawLegendOnGraphics(Graphics2D mainGraphics, int startX, int startY, boolean isVerticalAlign) throws ExportJavaScriptException {
        CellRendererForLegend.LegendRenderParameter parameter = this.tvAdapter.getLegendRenderParameter();
        parameter.setMainGraphics(mainGraphics);
        parameter.setStartX(startX);
        parameter.setStartY(startY);
        CellRendererForLegend render = new CellRendererForLegend();
        if (isVerticalAlign) {
            render.drawVerticalLegends(parameter);
        } else {
            render.drawHorizontalLegends(parameter);
        }
    }

    private void drawBackground(Graphics2D g2, int x, int y, ExStyle style) {
        if (style.getBackgroundColor() != null) {
            Color backgroundColor = style.getBackgroundColor();
            g2.setBackground(backgroundColor);
            g2.setColor(backgroundColor);
            g2.fillRect(x + 1, y + 1, style.getWidth(), style.getHeight());
        }
    }

    private void drawBorder(Graphics2D g2, int leftX, int upY, ExStyle style) {
        int width = style.getWidth();
        int height = style.getHeight();
        int rightX = leftX + width;
        int lowY = upY + height;
        ExBorder border = style.getBorderTop();
        if (border != null) {
            g2.setColor(border.getBorderColor());
            g2.setStroke(new BasicStroke(border.getBorderWidth()));
            g2.drawLine(leftX + 1, upY, rightX, upY);
        }
        if ((border = style.getBorderBottom()) != null) {
            g2.setColor(border.getBorderColor());
            g2.setStroke(new BasicStroke(border.getBorderWidth()));
            g2.drawLine(leftX + 1, lowY, rightX, lowY);
        }
        if ((border = style.getBorderRight()) != null) {
            g2.setColor(border.getBorderColor());
            g2.setStroke(new BasicStroke(border.getBorderWidth()));
            g2.drawLine(rightX, upY, rightX, lowY);
        }
        if ((border = style.getBorderLeft()) != null) {
            g2.setColor(border.getBorderColor());
            g2.setStroke(new BasicStroke(border.getBorderWidth()));
            g2.drawLine(leftX, upY, leftX, lowY);
        }
        g2.setColor(style.getForegroundColor());
    }

    private ExStyle getMergeCellStyle(int row, int col, int pageFromRow, int pageFromCol) {
        RowColRange mergeRange = this.getCellMergeRange(row, col);
        if (mergeRange == null) {
            ExStyle style = this.tvAdapter.styleAt(row, col);
            if (row == pageFromRow) {
                this.setBorderTopByBgCorlor(style);
            }
            if (col == pageFromCol) {
                this.setBorderLeftByBgCorlor(style);
            }
            return style;
        }
        if (row == mergeRange.getFromRow() && col == mergeRange.getFromCol() || row > 0 && row == pageFromRow || col > 0 && col == pageFromCol) {
            ExStyle cellStyle = this.tvAdapter.styleAt(row, col);
            int width = 0;
            int end = mergeRange.getToCol();
            for (int c = mergeRange.getFromCol(); c <= end; ++c) {
                width += this.tvAdapter.getColWidth(c);
            }
            int startRow = mergeRange.getFromRow();
            end = mergeRange.getToRow();
            int height = 0;
            for (int r = startRow; r <= end; ++r) {
                height += this.tvAdapter.getRowHeight(r);
            }
            cellStyle.setWidth(width);
            cellStyle.setHeight(height);
            if (mergeRange.getToCol() - mergeRange.getFromCol() > 0) {
                ExStyle endRowCellStyle = this.tvAdapter.styleAt(row, mergeRange.getToCol());
                cellStyle.setBorderRight(endRowCellStyle.getBorderRight());
            }
            if (mergeRange.getToRow() - mergeRange.getFromRow() > 0) {
                ExStyle endColCellStyle = this.tvAdapter.styleAt(mergeRange.getToRow(), col);
                cellStyle.setBorderBottom(endColCellStyle.getBorderBottom());
            }
            if (row == pageFromRow && row != mergeRange.getFromRow()) {
                int yOffset = (row - mergeRange.getFromRow()) * this.tvAdapter.getRowHeight(row);
                cellStyle.setyOffset(-yOffset);
                this.setBorderTopByBgCorlor(cellStyle);
            }
            if (col == pageFromCol && col != mergeRange.getFromCol()) {
                int xOffset = (col - mergeRange.getFromCol()) * this.tvAdapter.getColWidth(col);
                cellStyle.setxOffset(-xOffset);
                this.setBorderLeftByBgCorlor(cellStyle);
            }
            return cellStyle;
        }
        return null;
    }

    private void setBorderTopByBgCorlor(ExStyle style) {
        Color bgCorlor = style.getBackgroundColor();
        ExBorder tBoder = style.getBorderTop();
        if (tBoder == null && bgCorlor != null) {
            tBoder = new ExBorder();
            tBoder.setBorderColor(style.getBackgroundColor());
            style.setBorderTop(tBoder);
        }
    }

    private void setBorderLeftByBgCorlor(ExStyle style) {
        Color bgCorlor = style.getBackgroundColor();
        ExBorder tBoder = style.getBorderLeft();
        if (tBoder == null && bgCorlor != null) {
            tBoder = new ExBorder();
            tBoder.setBorderColor(style.getBackgroundColor());
            style.setBorderLeft(tBoder);
        }
    }

    private RowColRange getCellMergeRange(int row, int col) {
        List<RowColRange> mergeRanges = this.tvAdapter.getMergeRanges();
        if (mergeRanges == null) {
            return null;
        }
        for (RowColRange range : mergeRanges) {
            if (row < range.getFromRow() || row > range.getToRow() || col < range.getFromCol() || col > range.getToCol()) continue;
            return range;
        }
        return null;
    }

    private void createCrossHeader(Graphics cellGraphics) {
        DiagonalUtil.draw(cellGraphics, 1.0f, this.tvAdapter);
    }
}

