/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.map.designer.model;

import com.kingdee.bos.qing.map.designer.exception.PersistentModelParseException;
import com.kingdee.bos.qing.map.designer.model.Page;
import com.kingdee.bos.qing.util.XmlUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public class DesigntimeMapModel {
    private static final String VERSION = "20200101";
    private Boolean isTooModern;
    private Page page;

    public Page getPage() {
        if (this.page == null) {
            this.page = new Page();
        }
        return this.page;
    }

    public void fixBackImageIdentity(String imgId) {
        this.getPage().setBackImageId(imgId);
    }

    public String pickBackImageIdentity() {
        return this.getPage().getBackImageId();
    }

    public Element toXml() {
        Element root = new Element("Map");
        root.setAttribute("version", VERSION);
        Element nodePage = new Element("Page");
        this.page.toXml(nodePage);
        root.addContent((Content)nodePage);
        return root;
    }

    public void fromXml(Element root) throws PersistentModelParseException {
        int modelVersion = this.checkVersion(root);
        Element nodePage = null;
        try {
            nodePage = XmlUtil.getChildNotNull((Element)root, (String)"Page");
        }
        catch (XmlUtil.NullException e) {
            PersistentModelParseException.createParseError("<Page> not found.");
        }
        this.page = new Page();
        try {
            this.page.fromXml(nodePage);
        }
        catch (PersistentModelParseException ex) {
            if (this.isTooModern == Boolean.TRUE) {
                String msg = "Runtime env(20200101) is older than persistent model(" + modelVersion + ").";
                throw PersistentModelParseException.createTooModern((Throwable)((Object)ex), msg);
            }
            throw ex;
        }
    }

    private int checkVersion(Element root) throws PersistentModelParseException {
        int modelVersion;
        String version;
        try {
            version = XmlUtil.readAttrNotNull((Element)root, (String)"version");
        }
        catch (XmlUtil.NullException e) {
            throw PersistentModelParseException.createParseError("The attribute 'version' is missing.");
        }
        int runtimeVersion = Integer.parseInt(VERSION);
        try {
            modelVersion = Integer.parseInt(version);
        }
        catch (NumberFormatException ex) {
            throw PersistentModelParseException.createParseError("Invalid version: " + version);
        }
        if (modelVersion > runtimeVersion) {
            this.isTooModern = Boolean.TRUE;
        }
        return modelVersion;
    }
}

