/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.service;

import com.kingdee.bos.qing.behavior.BehaviorAssociate;
import com.kingdee.bos.qing.behavior.impl.BehaviorService;
import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.framework.server.annotation.longtime.LongTimeServiceMethodAnnotation;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.common.trace.TraceSpansCacheUtil;
import com.kingdee.bos.qing.common.trace.TracerUtil;
import com.kingdee.bos.qing.core.brief.BriefOutput;
import com.kingdee.bos.qing.core.brief.WarningRule;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.MetaParseException;
import com.kingdee.bos.qing.core.model.ExecutingModelWrapper;
import com.kingdee.bos.qing.core.model.ModelJsonDecoder;
import com.kingdee.bos.qing.core.model.ResultWrapper;
import com.kingdee.bos.qing.core.model.SquareResultWrapper;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.ContinuousColor;
import com.kingdee.bos.qing.core.model.analysis.common.CustomPalette;
import com.kingdee.bos.qing.core.model.analysis.common.brief.BriefOutputDefinition;
import com.kingdee.bos.qing.core.model.analysis.common.brief.WarningRuleDefinition;
import com.kingdee.bos.qing.core.model.analysis.common.filter.ContinuousDateFilter;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.exhibition.common.Legends;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractPreparedValue;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.core.model.meta.MetaTable;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.AdditionalFilterDomain;
import com.kingdee.bos.qing.domain.BriefOutputDomain;
import com.kingdee.bos.qing.domain.DataDetailDomain;
import com.kingdee.bos.qing.domain.ExecuteDomain;
import com.kingdee.bos.qing.domain.ExportDomain;
import com.kingdee.bos.qing.domain.FilterDomain;
import com.kingdee.bos.qing.domain.FormulaCheckDomain;
import com.kingdee.bos.qing.domain.LinkageDomain;
import com.kingdee.bos.qing.domain.MapDomain;
import com.kingdee.bos.qing.domain.MdExecuteDomain;
import com.kingdee.bos.qing.domain.MetaDomain;
import com.kingdee.bos.qing.domain.PaletteDomain;
import com.kingdee.bos.qing.domain.PostExecuteDomain;
import com.kingdee.bos.qing.domain.SharedDomain;
import com.kingdee.bos.qing.domain.SquareExecuteDomain;
import com.kingdee.bos.qing.domain.SquareFilterDomain;
import com.kingdee.bos.qing.domain.WarningRuleDomain;
import com.kingdee.bos.qing.export.ExportVO;
import com.kingdee.bos.qing.export.common.exception.ExportNoContentException;
import com.kingdee.bos.qing.export.common.util.UnitUtil;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseErrorWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.service.Associate;
import com.kingdee.bos.qing.service.ICoreService;
import com.kingdee.bos.qing.service.IExecutable;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoreService
extends BehaviorService
implements ICoreService,
IExecutable,
IQingContextable {
    private AbstractDomain.IDataSourceCreator _dataSourceCreator;
    private QingContext _qingContext;
    private ICoreService.IExecutingInfoFans _executingInfoFans;

    public void setExecutingInfoFans(ICoreService.IExecutingInfoFans fans) {
        this._executingInfoFans = fans;
    }

    private void interestInExecuting(AbstractResponseWrap wrap, Map<String, Object> info) {
        if (this._executingInfoFans != null) {
            this._executingInfoFans.setPerformaceInfo(info);
            this._executingInfoFans.finish(wrap);
        }
    }

    private void interestInExecuting(AbstractResponseWrap wrap, Exception ex) {
        if (this._executingInfoFans != null) {
            this._executingInfoFans.setException(ex);
            this._executingInfoFans.finish(wrap);
        }
    }

    @Override
    public void setDataSourceCreator(AbstractDomain.IDataSourceCreator dsc) {
        this._dataSourceCreator = dsc;
    }

    private AbstractDomain.IDataSourceCreator getDataSourceCreator() {
        if (this._dataSourceCreator == null) {
            throw new RuntimeException("The implement of IDataSourceCreator must be appointed.");
        }
        return this._dataSourceCreator;
    }

    public void setQingContext(QingContext qingContext) {
        this._qingContext = qingContext;
    }

    private ExecuteDomain createExecuteDomain(Map<String, String> params, Meta meta) {
        String skin = params.get("skin");
        ExecuteDomain domain = null;
        domain = meta.getSrcMode() == Meta.Src.MD ? new MdExecuteDomain(this.getDataSourceCreator()) : new ExecuteDomain(this.getDataSourceCreator());
        domain.setQingContext(this._qingContext);
        domain.setI18nContext(this._qingContext.getIi18nContext());
        domain.setSkinName(skin);
        return domain;
    }

    private SquareExecuteDomain createSquareExecuteDomain(Map<String, String> params) {
        String skin = params.get("skin");
        SquareExecuteDomain domain = new SquareExecuteDomain(this.getDataSourceCreator());
        domain.setI18nContext(this._qingContext.getIi18nContext());
        domain.setSkinName(skin);
        return domain;
    }

    private FormulaCheckDomain createFormulaCheckDomain() {
        FormulaCheckDomain domain = new FormulaCheckDomain();
        domain.setI18nContext(this._qingContext.getIi18nContext());
        return domain;
    }

    private AdditionalFilterDomain.AdditionalFilters parseParamAdditionalFilters(Map<String, String> params) {
        AdditionalFilterDomain.AdditionalFilters additionalFilters = null;
        String additionalFiltersJsonString = params.get("additionalFilters");
        if (additionalFiltersJsonString != null) {
            additionalFilters = AdditionalFilterDomain.AdditionalFilters.decodeAdditionalFilters(additionalFiltersJsonString);
        }
        return additionalFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Associate(data=true)
    public byte[] getMeta(Map<String, String> params) {
        TraceSpan traceSpan = null;
        try {
            traceSpan = TracerUtil.create((String)"\u83b7\u53d6\u6570\u636e\u6e90\u5143\u4fe1\u606f");
            traceSpan.addClassMethodAttribute(this.getClass().getName() + ".getMeta");
            Meta meta = new MetaDomain(this.getDataSourceCreator()).getMeta();
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)meta);
            byte[] byArray = ResponseUtil.output((IResponseWrap)wrap);
            return byArray;
        }
        catch (MetaParseException ex) {
            byte[] byArray = ResponseUtil.output((Exception)((Object)ex));
            return byArray;
        }
        finally {
            TracerUtil.close((TraceSpan)traceSpan);
            TraceSpansCacheUtil.appendToCacheLimitMax((TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.EXECUTE, (TraceSpan)traceSpan, (boolean)true);
        }
    }

    @Override
    public byte[] updateMeta(Map<String, String> params) {
        String metaJsonString = params.get("meta");
        Meta meta = ModelJsonDecoder.decode(metaJsonString, Meta.class);
        meta.fixMetaFieldOwner();
        try {
            this.createFormulaCheckDomain().repairMeta(meta);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)meta));
        }
        catch (AnalysisException ex) {
            return ResponseUtil.output((Exception)((Object)ex));
        }
    }

    @Override
    public byte[] checkFormula(Map<String, String> params) {
        String fieldName = params.get("name");
        String formula = params.get("formula");
        String metaJsonString = params.get("meta");
        Meta meta = ModelJsonDecoder.decode(metaJsonString, Meta.class);
        meta.fixMetaFieldOwner();
        try {
            FormulaCheckDomain.CheckingInfo info = this.createFormulaCheckDomain().checkFormula(formula, meta, fieldName);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)info));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Override
    @Associate(data=true)
    public byte[] getMetaTableDetailRowData(Map<String, String> params) {
        String metaTableJsonString = params.get("metaTable");
        long startRowNum = Long.parseLong(params.get("startRowNum"));
        long endRowNum = Long.parseLong(params.get("endRowNum"));
        boolean export = Boolean.parseBoolean(params.get("export"));
        MetaTable metaTable = ModelJsonDecoder.decode(metaTableJsonString, MetaTable.class);
        metaTable.fixMetaFieldOwner();
        try {
            MetaDomain domain = new MetaDomain(this.getDataSourceCreator());
            if (export) {
                throw new UnsupportedOperationException("TODO");
            }
            MetaDomain.TableRowsSegment data = domain.getMetaTableDetailRowData(metaTable, startRowNum, endRowNum);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)data));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Associate(data=true)
    @LongTimeServiceMethodAnnotation
    public byte[] getCustomizedOrderDimensionMembers(Map<String, String> params) {
        String fieldFullName = params.get("fieldFullName");
        List oriCustomOrder = (List)JsonUtil.decodeFromString((String)params.get("oriCustomOrder"), ArrayList.class);
        Meta meta = null;
        String metaJsonString = params.get("meta");
        if (metaJsonString != null) {
            meta = ModelJsonDecoder.decode(metaJsonString, Meta.class);
            meta.fixMetaFieldOwner();
            meta.fixExprAndDependents();
        }
        TraceSpan traceSpan = null;
        try {
            traceSpan = TracerUtil.create((String)"\u83b7\u53d6\u7ef4\u5ea6\u5b57\u6bb5\u7684\u624b\u52a8\u6392\u5e8f\u6210\u5458");
            traceSpan.addClassMethodAttribute(this.getClass().getName() + ".getCustomizedOrderDimensionMembers");
            SharedDomain domain = new SharedDomain(this.getDataSourceCreator());
            domain.setI18nContext(this._qingContext.getIi18nContext());
            List<String> members = domain.getCustomizedOrderDimensionMembers(fieldFullName, oriCustomOrder, meta);
            byte[] byArray = ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(members));
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = ResponseUtil.output((Exception)e);
            return byArray;
        }
        finally {
            TracerUtil.close((TraceSpan)traceSpan);
            TraceSpansCacheUtil.appendToCacheLimitMax((TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.EXECUTE, (TraceSpan)traceSpan, (boolean)false);
        }
    }

    @Override
    @LongTimeServiceMethodAnnotation
    public byte[] parseDateRange(Map<String, String> params) {
        String filterJsonString = params.get("dateFilter");
        ContinuousDateFilter dateFilter = ModelJsonDecoder.decode(filterJsonString, ContinuousDateFilter.class);
        FilterDomain domain = new FilterDomain(null);
        ContinuousDateFilter parsedDateFilter = domain.parseRelativeDateRange(dateFilter);
        return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)parsedDateFilter));
    }

    @Override
    public byte[] getPresetPalettes(Map<String, String> params) {
        String paletteGroup = params.get("paletteGroup");
        String paletteType = params.get("paletteType");
        PaletteDomain domain = new PaletteDomain();
        List<CustomPalette> palettes = domain.getPresetPalettes(paletteGroup, paletteType);
        return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(palettes));
    }

    @Override
    public byte[] previewContinuousColor(Map<String, String> params) {
        String modelJsonString = params.get("model");
        ContinuousColor model = ModelJsonDecoder.decode(modelJsonString, ContinuousColor.class);
        SharedDomain domain = new SharedDomain(null);
        Legends.ContinuousColorLegend legend = domain.previewContinuousColor(model);
        return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)legend));
    }

    @Override
    @Associate(data=true)
    @LongTimeServiceMethodAnnotation
    public byte[] previewWarningRule(Map<String, String> params) {
        String modelWrapperJsonString = params.get("executingModelWrapper");
        ExecutingModelWrapper modelWrapper = ModelJsonDecoder.decodeForExecuting(modelWrapperJsonString);
        IQingModel model = modelWrapper.getModel();
        String definitionJsonString = params.get("definition");
        WarningRuleDefinition definition = ModelJsonDecoder.decode(definitionJsonString, WarningRuleDefinition.class);
        WarningRuleDomain domain = new WarningRuleDomain(this.getDataSourceCreator());
        try {
            WarningRule wr = domain.execute(model, definition);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)wr));
        }
        catch (Exception ex) {
            return ResponseUtil.output((Exception)ex);
        }
    }

    @Override
    @Associate(data=true)
    @LongTimeServiceMethodAnnotation
    public byte[] previewBriefOutput(Map<String, String> params) {
        String modelWrapperJsonString = params.get("executingModelWrapper");
        ExecutingModelWrapper modelWrapper = ModelJsonDecoder.decodeForExecuting(modelWrapperJsonString);
        IQingModel model = modelWrapper.getModel();
        String definitionJsonString = params.get("definition");
        BriefOutputDefinition definition = ModelJsonDecoder.decode(definitionJsonString, BriefOutputDefinition.class);
        BriefOutputDomain domain = new BriefOutputDomain(this.getDataSourceCreator());
        try {
            BriefOutput brief = domain.execute(model, definition);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)brief));
        }
        catch (Exception ex) {
            return ResponseUtil.output((Exception)ex);
        }
    }

    @Override
    @Associate(data=true)
    @LongTimeServiceMethodAnnotation
    public byte[] executeBriefOutput(Map<String, String> params) {
        String modelWrapperJsonString = params.get("executingModelWrapper");
        ExecutingModelWrapper modelWrapper = ModelJsonDecoder.decodeForExecuting(modelWrapperJsonString);
        IQingModel model = modelWrapper.getModel();
        AdditionalFilterDomain.AdditionalFilters additionalFilters = this.parseParamAdditionalFilters(params);
        String paramNamesJsonString = params.get("paramNames");
        List paramNames = (List)JsonUtil.decodeFromString((String)paramNamesJsonString, ArrayList.class);
        BriefOutputDomain domain = new BriefOutputDomain(this.getDataSourceCreator());
        try {
            Map<String, BriefOutput> briefs = domain.execute(model, additionalFilters, paramNames);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(briefs));
        }
        catch (Exception ex) {
            return ResponseUtil.output((Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Associate(data=true)
    @LongTimeServiceMethodAnnotation
    public byte[] searchLinkTargetForeignKeyMembers(Map<String, String> params) {
        String foreignKeyMetaField = params.get("foreignKey");
        String bizUiId = params.get("bizUiId");
        String tag = params.get("tag");
        String modelWrapperJsonString = params.get("executingModelWrapper");
        ExecutingModelWrapper modelWrapper = ModelJsonDecoder.decodeForExecuting(modelWrapperJsonString);
        IQingModel model = modelWrapper.getModel();
        AdditionalFilterDomain.AdditionalFilters additionalFilters = this.parseParamAdditionalFilters(params);
        String linkageContextJsonString = params.get("linkageContext");
        LinkageDomain.LinkageContext linkageCtx = LinkageDomain.LinkageContext.decodeFromJson(linkageContextJsonString);
        TraceSpan traceSpan = null;
        try {
            traceSpan = TracerUtil.create((String)"\u4e3a\u8054\u67e5\u76ee\u6807\uff08\u4e1a\u52a1\u754c\u9762\uff09\u7684\u5916\u952e\u51c6\u5907\u503c");
            traceSpan.addClassMethodAttribute(this.getClass().getName() + ".searchLinkTargetForeignKeyMembers");
            LinkageDomain domain = new LinkageDomain(this.getDataSourceCreator());
            LinkageDomain.StoredForeignKeyMembers vo = domain.cacheForeignKeyMembers(model, additionalFilters, linkageCtx, foreignKeyMetaField, bizUiId, tag);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)vo);
            byte[] byArray = ResponseUtil.output((IResponseWrap)wrap);
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = ResponseUtil.output((Exception)e);
            return byArray;
        }
        finally {
            TracerUtil.close((TraceSpan)traceSpan);
            TraceSpansCacheUtil.appendToCacheLimitMax((TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.EXECUTE, (TraceSpan)traceSpan, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Associate(data=true)
    @LongTimeServiceMethodAnnotation
    public byte[] getFilterPreparedValue(Map<String, String> params) {
        String modelWrapperJsonString = params.get("executingModelWrapper");
        ExecutingModelWrapper modelWrapper = ModelJsonDecoder.decodeForExecuting(modelWrapperJsonString);
        AnalyticalModel model = modelWrapper.getAnalyticalModel();
        String fieldJsonString = params.get("field");
        AnalyticalField field = (AnalyticalField)JsonUtil.decodeFromString((String)fieldJsonString, AnalyticalField.class);
        model.fixMetaFieldBinding(field);
        TraceSpan traceSpan = null;
        try {
            traceSpan = TracerUtil.create((String)"\u83b7\u53d6\u7b5b\u9009\u5668\u7684\u5907\u9009\u503c");
            traceSpan.addClassMethodAttribute(this.getClass().getName() + ".getFilterPreparedValue");
            traceSpan.addAttribute("\u5b57\u6bb5", field.getName());
            FilterDomain domain = new FilterDomain(this.getDataSourceCreator());
            domain.setI18nContext(this._qingContext.getIi18nContext());
            AbstractPreparedValue pv = domain.getFilterPreparedValue(model, field);
            byte[] byArray = ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)pv));
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = ResponseUtil.output((Exception)e);
            return byArray;
        }
        finally {
            TracerUtil.close((TraceSpan)traceSpan);
            TraceSpansCacheUtil.appendToCacheLimitMax((TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.EXECUTE, (TraceSpan)traceSpan, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Associate(data=true)
    @BehaviorAssociate(behavior=true)
    @LongTimeServiceMethodAnnotation
    public byte[] christmas(Map<String, String> params) {
        boolean isCheckSelectedValueScope = Boolean.parseBoolean(params.get("checkSelectedValueScope"));
        String modelWrapperJsonString = params.get("executingModelWrapper");
        ExecutingModelWrapper modelWrapper = ModelJsonDecoder.decodeForExecuting(modelWrapperJsonString);
        AnalyticalModel model = modelWrapper.getAnalyticalModel();
        AdditionalFilterDomain.AdditionalFilters additionalFilters = this.parseParamAdditionalFilters(params);
        TraceSpan traceSpan = null;
        try {
            traceSpan = TracerUtil.create((String)"\u6267\u884c\uff08christmas\uff09");
            traceSpan.addClassMethodAttribute(this.getClass().getName() + ".christmas");
            ExecuteDomain domain = this.createExecuteDomain(params, model.getMeta());
            domain.setExhibitionCacheable(true);
            ResultWrapper result = domain.christmas(model, additionalFilters, isCheckSelectedValueScope);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)result);
            this.interestInExecuting((AbstractResponseWrap)wrap, domain.getPerformaceInfo());
            this.interestInBehavior((AbstractResponseWrap)wrap, (Long)domain.getPerformaceInfo().get("allTime"), model.getChartType().toPersistance());
            byte[] byArray = ResponseUtil.output((IResponseWrap)wrap);
            return byArray;
        }
        catch (Exception ex) {
            ResponseErrorWrap wrap = new ResponseErrorWrap((Throwable)ex);
            this.interestInExecuting((AbstractResponseWrap)wrap, ex);
            byte[] byArray = ResponseUtil.output((IResponseWrap)wrap);
            return byArray;
        }
        finally {
            TracerUtil.close((TraceSpan)traceSpan);
            TraceSpansCacheUtil.appendToCacheLimitMax((TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.EXECUTE, (TraceSpan)traceSpan, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Associate(data=true)
    @BehaviorAssociate(behavior=true)
    @LongTimeServiceMethodAnnotation
    public byte[] filtering(Map<String, String> params) {
        int filterIndex = Integer.parseInt(params.get("filterIndex"));
        String modelWrapperJsonString = params.get("executingModelWrapper");
        ExecutingModelWrapper modelWrapper = ModelJsonDecoder.decodeForExecuting(modelWrapperJsonString);
        AnalyticalModel model = modelWrapper.getAnalyticalModel();
        AdditionalFilterDomain.AdditionalFilters additionalFilters = this.parseParamAdditionalFilters(params);
        TraceSpan traceSpan = null;
        try {
            traceSpan = TracerUtil.create((String)"\u64cd\u4f5c\u4e86\u8fc7\u6ee4\u5668\u540e\u6267\u884c");
            traceSpan.addClassMethodAttribute(this.getClass().getName() + ".filtering");
            ExecuteDomain domain = this.createExecuteDomain(params, model.getMeta());
            domain.setExhibitionCacheable(true);
            ResultWrapper result = domain.filtering(model, additionalFilters, filterIndex);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)result);
            this.interestInExecuting((AbstractResponseWrap)wrap, domain.getPerformaceInfo());
            this.interestInBehavior((AbstractResponseWrap)wrap, (Long)domain.getPerformaceInfo().get("allTime"), model.getChartType().toPersistance());
            byte[] byArray = ResponseUtil.output((IResponseWrap)wrap);
            return byArray;
        }
        catch (Exception ex) {
            ResponseErrorWrap wrap = new ResponseErrorWrap((Throwable)ex);
            this.interestInExecuting((AbstractResponseWrap)wrap, ex);
            byte[] byArray = ResponseUtil.output((IResponseWrap)wrap);
            return byArray;
        }
        finally {
            TracerUtil.close((TraceSpan)traceSpan);
            TraceSpansCacheUtil.appendToCacheLimitMax((TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.EXECUTE, (TraceSpan)traceSpan, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Associate(data=true)
    @BehaviorAssociate(behavior=true)
    @LongTimeServiceMethodAnnotation
    public byte[] execute(Map<String, String> params) {
        String modelWrapperJsonString = params.get("executingModelWrapper");
        ExecutingModelWrapper modelWrapper = ModelJsonDecoder.decodeForExecuting(modelWrapperJsonString);
        AnalyticalModel model = modelWrapper.getAnalyticalModel();
        AdditionalFilterDomain.AdditionalFilters additionalFilters = this.parseParamAdditionalFilters(params);
        TraceSpan traceSpan = null;
        try {
            traceSpan = TracerUtil.create((String)"\u6267\u884c\uff08execute\uff09");
            traceSpan.addClassMethodAttribute(this.getClass().getName() + ".execute");
            ExecuteDomain domain = this.createExecuteDomain(params, model.getMeta());
            domain.setExhibitionCacheable(true);
            ResultWrapper result = domain.execute(model, additionalFilters);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)result);
            this.interestInExecuting((AbstractResponseWrap)wrap, domain.getPerformaceInfo());
            this.interestInBehavior((AbstractResponseWrap)wrap, (Long)domain.getPerformaceInfo().get("allTime"), model.getChartType().toPersistance());
            byte[] byArray = ResponseUtil.output((IResponseWrap)wrap);
            return byArray;
        }
        catch (Exception ex) {
            ResponseErrorWrap wrap = new ResponseErrorWrap((Throwable)ex);
            this.interestInExecuting((AbstractResponseWrap)wrap, ex);
            byte[] byArray = ResponseUtil.output((IResponseWrap)wrap);
            return byArray;
        }
        finally {
            TracerUtil.close((TraceSpan)traceSpan);
            TraceSpansCacheUtil.appendToCacheLimitMax((TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.EXECUTE, (TraceSpan)traceSpan, (boolean)true);
        }
    }

    @Override
    @Associate(data=true)
    @LongTimeServiceMethodAnnotation
    public byte[] easter(Map<String, String> params) {
        long timestamp = Long.parseLong(params.get("timestamp"));
        String cacheKey = params.get("cacheKey");
        int fromRow = Integer.parseInt(params.get("fromRow"));
        int fromCol = Integer.parseInt(params.get("fromCol"));
        int rows = Integer.parseInt(params.get("rows"));
        int appendRowAtView = Integer.parseInt(params.get("appendRowAtView"));
        PostExecuteDomain domain = new PostExecuteDomain();
        AbstractDomain.IExhibitionCacheReader cacheReader = this.getDataSourceCreator().createExhibitionCacheReader();
        try {
            String json = fromCol < 0 ? domain.getNormalCachedExhibition(cacheReader, cacheKey, fromRow, rows, timestamp) : domain.getTreeCachedExhibition(cacheReader, cacheKey, fromRow, fromCol, appendRowAtView, timestamp);
            json = ResponseSuccessWrap.wrapJsonString((String)json);
            return json.getBytes(Charset.forName("utf-8"));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Override
    @Associate(data=true)
    @LongTimeServiceMethodAnnotation
    public byte[] getDetailRowNums(Map<String, String> params) {
        String modelWrapperJsonString = params.get("executingModelWrapper");
        String tvCoordinate = params.get("tvCoordinate");
        boolean showAllField = Boolean.parseBoolean(params.get("showAllField"));
        ExecutingModelWrapper modelWrapper = ModelJsonDecoder.decodeForExecuting(modelWrapperJsonString);
        AnalyticalModel model = modelWrapper.getAnalyticalModel();
        DataDetailDomain.TableViewCoordinate coordinate = (DataDetailDomain.TableViewCoordinate)JsonUtil.decodeFromString((String)tvCoordinate, DataDetailDomain.TableViewCoordinate.class);
        AdditionalFilterDomain.AdditionalFilters additionalFilters = this.parseParamAdditionalFilters(params);
        try {
            DataDetailDomain domain = new DataDetailDomain(this.getDataSourceCreator());
            Map<String, Object> result = domain.getDataDetailRowNums(model, additionalFilters, coordinate, showAllField);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(result));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Override
    @Associate(data=true)
    @BehaviorAssociate(behavior=true)
    @LongTimeServiceMethodAnnotation
    public byte[] getDetailRowData(Map<String, String> params) {
        String dataSourceCacheKey = params.get("dataSourceCacheKey");
        String dataRowInfo = params.get("dataRowInfo");
        DataDetailDomain.DataRowInfo dri = (DataDetailDomain.DataRowInfo)JsonUtil.decodeFromString((String)dataRowInfo, DataDetailDomain.DataRowInfo.class);
        String modelWrapperJsonString = params.get("executingModelWrapper");
        ExecutingModelWrapper modelWrapper = ModelJsonDecoder.decodeForExecuting(modelWrapperJsonString);
        AnalyticalModel model = modelWrapper.getAnalyticalModel();
        try {
            DataDetailDomain.DataDetailSegment result = new DataDetailDomain(this.getDataSourceCreator()).getDataDetailData(model, dataSourceCacheKey, dri);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)result);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Override
    @Associate(data=true)
    public byte[] searchDetailRowLinkTargetForeignKeyMember(Map<String, String> params) {
        String dataSourceCacheKey = params.get("dataSourceCacheKey");
        long rowNum = Long.parseLong(params.get("row"));
        String foreignKeyMetaField = params.get("col");
        String bizUiId = params.get("bizUiId");
        String tag = params.get("tag");
        try {
            String member = new DataDetailDomain(this.getDataSourceCreator()).getDataDetailValue(dataSourceCacheKey, rowNum, foreignKeyMetaField, bizUiId, tag);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)member);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception ex) {
            return ResponseUtil.output((Exception)ex);
        }
    }

    @Override
    @Associate(data=true)
    @BehaviorAssociate(behavior=true)
    @LongTimeServiceMethodAnnotation
    public byte[] exportDetailRowData(Map<String, String> params) {
        String dataSourceCacheKey = params.get("dataSourceCacheKey");
        String dataRowInfo = params.get("dataRowInfo");
        DataDetailDomain.DataRowInfo dri = (DataDetailDomain.DataRowInfo)JsonUtil.decodeFromString((String)dataRowInfo, DataDetailDomain.DataRowInfo.class);
        String modelWrapperJsonString = params.get("executingModelWrapper");
        boolean isAssignedOnly = Boolean.parseBoolean(params.get("assignedOnly"));
        AnalyticalModel analyticalModel = null;
        if (modelWrapperJsonString == null) {
            return ResponseUtil.output((Exception)((Object)new ExportNoContentException("Model wrapper is null.")));
        }
        ExecutingModelWrapper modelWrapper = ModelJsonDecoder.decodeForExecuting(modelWrapperJsonString);
        analyticalModel = modelWrapper.getAnalyticalModel();
        DataDetailDomain dataDetailDomain = new DataDetailDomain(this.getDataSourceCreator());
        IQingFile qingFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
        try {
            dataDetailDomain.checkEntityExportPermission(this._qingContext, params.get("tag"), analyticalModel);
            dataDetailDomain.exportDataDetail(qingFile, dataSourceCacheKey, isAssignedOnly, analyticalModel, dri);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)qingFile.getName());
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Override
    @Associate(data=true)
    @BehaviorAssociate(behavior=true)
    @LongTimeServiceMethodAnnotation
    public byte[] exportExhibition(Map<String, String> params) {
        String fileName = params.get("fileName");
        IQingFile exportFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
        String modelJsonString = params.get("model");
        ExportVO vo = (ExportVO)JsonUtil.decodeFromString((String)modelJsonString, ExportVO.class);
        ExecutingModelWrapper emw = ModelJsonDecoder.decodeForExecuting(vo.getModelWrapper());
        UnitUtil.ExportType oExportType = UnitUtil.ExportType.valueOf(vo.getExportType());
        ExecuteDomain excuteDomain = this.createExecuteDomain(params, emw.getMeta());
        excuteDomain.setOutputMaxColumns(16000);
        ExportDomain domain = new ExportDomain();
        try {
            domain.checkEntityExportPermission(this._qingContext, params.get("tag"), emw.getAnalyticalModel());
            domain.doExport(exportFile, fileName, oExportType, emw.getAnalyticalModel(), excuteDomain, emw.getAnalyticalPreferences(), excuteDomain.getSkinName(), this._qingContext.getIi18nContext());
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)exportFile.getName());
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, vo.getExportType());
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Associate(data=true)
    @BehaviorAssociate(behavior=true)
    public byte[] getSquareFilterPreparedValue(Map<String, String> params) {
        String modelWrapperJsonString = params.get("executingModelWrapper");
        ExecutingModelWrapper modelWrapper = ModelJsonDecoder.decodeForExecuting(modelWrapperJsonString);
        SquareModel model = modelWrapper.getSquareModel();
        String fieldJsonString = params.get("field");
        AnalyticalField field = (AnalyticalField)JsonUtil.decodeFromString((String)fieldJsonString, AnalyticalField.class);
        model.fixMetaFieldBinding(field);
        TraceSpan traceSpan = null;
        try {
            traceSpan = TracerUtil.create((String)"\u83b7\u53d6\u6597\u65b9\u7b5b\u9009\u5668\u5907\u9009\u503c");
            traceSpan.addClassMethodAttribute(this.getClass().getName() + ".getSquareFilterPreparedValue");
            AbstractPreparedValue pv = new SquareFilterDomain(this.getDataSourceCreator()).getFilterPreparedValue(model, field);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)pv);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, model.getChartModel().getChartType().toPersistance());
            byte[] byArray = ResponseUtil.output((IResponseWrap)wrap);
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = ResponseUtil.output((Exception)e);
            return byArray;
        }
        finally {
            TracerUtil.close((TraceSpan)traceSpan);
            TraceSpansCacheUtil.appendToCacheLimitMax((TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.EXECUTE, (TraceSpan)traceSpan, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Associate(data=true)
    @BehaviorAssociate(behavior=true)
    @LongTimeServiceMethodAnnotation
    public byte[] squareExecute(Map<String, String> params) {
        String modelWrapperJsonString = params.get("executingModelWrapper");
        ExecutingModelWrapper modelWrapper = ModelJsonDecoder.decodeForExecuting(modelWrapperJsonString);
        SquareModel model = modelWrapper.getSquareModel();
        AdditionalFilterDomain.AdditionalFilters additionalFilters = this.parseParamAdditionalFilters(params);
        CustomPalette paletteFitSkin = null;
        String paletteFitSkinJsonString = params.get("paletteFitSkin");
        if (paletteFitSkinJsonString != null) {
            paletteFitSkin = (CustomPalette)JsonUtil.decodeFromString((String)paletteFitSkinJsonString, CustomPalette.class);
        }
        TraceSpan traceSpan = null;
        try {
            traceSpan = TracerUtil.create((String)"\u6267\u884c\uff08squareExecute\uff09");
            traceSpan.addClassMethodAttribute(this.getClass().getName() + ".squareExecute");
            SquareExecuteDomain domain = this.createSquareExecuteDomain(params);
            SquareResultWrapper result = domain.execute(model, additionalFilters, paletteFitSkin);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)result);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, model.getChartModel().getChartType().toPersistance());
            byte[] byArray = ResponseUtil.output((IResponseWrap)wrap);
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = ResponseUtil.output((Exception)e);
            return byArray;
        }
        finally {
            TracerUtil.close((TraceSpan)traceSpan);
            TraceSpansCacheUtil.appendToCacheLimitMax((TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.EXECUTE, (TraceSpan)traceSpan, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] loadMapTemplate(Map<String, String> params) {
        String refToId = params.get("refToId");
        String refToFullPath = params.get("refToFullPath");
        TraceSpan traceSpan = null;
        try {
            traceSpan = TracerUtil.create((String)"\u52a0\u8f7d\u5730\u56fe\u6a21\u677f");
            traceSpan.addClassMethodAttribute(this.getClass().getName() + ".loadMapTemplate");
            MapDomain domain = new MapDomain(null);
            MapDomain.MapTemplate template = domain.loadMapTemplate(refToId, refToFullPath);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)template);
            byte[] byArray = ResponseUtil.output((IResponseWrap)wrap);
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = ResponseUtil.output((Exception)e);
            return byArray;
        }
        finally {
            TracerUtil.close((TraceSpan)traceSpan);
            TraceSpansCacheUtil.appendToCacheLimitMax((TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.EXECUTE, (TraceSpan)traceSpan, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Associate(data=true)
    @LongTimeServiceMethodAnnotation
    public byte[] loadMapRegions(Map<String, String> params) {
        String refToId = params.get("refToId");
        String refToFullPath = params.get("refToFullPath");
        String modelSerapperJsonString = params.get("executingModelWrapper");
        ExecutingModelWrapper modelWrapper = ModelJsonDecoder.decodeForExecuting(modelSerapperJsonString);
        SquareModel model = modelWrapper.getSquareModel();
        TraceSpan traceSpan = null;
        try {
            traceSpan = TracerUtil.create((String)"\u52a0\u8f7d\u5730\u56fe\u533a\u57df\u63cf\u8ff0\u4fe1\u606f\uff0c\u4ee5\u53ca\u7ef4\u5ea6\u5b57\u6bb5\u7684\u5907\u9009\u503c");
            traceSpan.addClassMethodAttribute(this.getClass().getName() + ".loadMapRegions");
            String skin = params.get("skin");
            MapDomain domain = new MapDomain(this.getDataSourceCreator());
            domain.setI18nContext(this._qingContext.getIi18nContext());
            domain.setSkinName(skin);
            MapDomain.RegionMappingSupport rms = domain.getRegionMappingSupport(refToId, refToFullPath, model);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)rms);
            byte[] byArray = ResponseUtil.output((IResponseWrap)wrap);
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = ResponseUtil.output((Exception)e);
            return byArray;
        }
        finally {
            TracerUtil.close((TraceSpan)traceSpan);
            TraceSpansCacheUtil.appendToCacheLimitMax((TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.EXECUTE, (TraceSpan)traceSpan, (boolean)false);
        }
    }

    @Override
    public byte[] getGisServerConfig(Map<String, String> params) {
        String host = SystemPropertyUtil.getString((String)"qing.gis.serverurl", (String)"https://q.kingdee.com");
        String path = "/qing-gis-server/gisEntrance.do";
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("host", host);
        result.put("path", path);
        ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
        return ResponseUtil.output((IResponseWrap)wrap);
    }
}

