//轻分析图表控件绘制器
//Copyright (c) 2016 金蝶软件(中国)有限公司
//
//第三方依赖：
//无 
//
//依赖：
//qing-common.js
//qing-framework-common.js

(function()
{
	if(typeof(com) == "undefined") com = {};
	if(typeof(com.kingdee) == "undefined") com.kingdee = {};
	if(typeof(com.kingdee.bos) == "undefined") com.kingdee.bos = {};
	if(typeof(com.kingdee.bos.qing) == "undefined") com.kingdee.bos.qing = {};
	if(typeof(com.kingdee.bos.qing.chart) == "undefined") com.kingdee.bos.qing.chart = {};
	if(typeof(com.kingdee.bos.qing.chart.render) == "undefined") com.kingdee.bos.qing.chart.render = {};
	
	var NS = com.kingdee.bos.qing.chart.render;
	
	//public
	NS.StyleTool = StyleTool;
	
	NS.SizeLegendRender = SizeLegendRender;
	NS.ContinuousColorLegendRender = ContinuousColorLegendRender;
	NS.DiscreteColorLegendRender = DiscreteColorLegendRender;
	NS.ProgressDiscreteLegendRender = ProgressDiscreteLegendRender;
	NS.ProgressCircleLegendRender = ProgressCircleLegendRender;
	NS.CompositeDescreteLegendRender = CompositeDescreteLegendRender;
	
	NS.PieChartRender = PieChartRender;
	NS.RectTreeRender = RectTreeRender;
	
	NS.SeparatedHeatMapRender = SeparatedHeatMapRender;
	NS.SeparatedVBarRender = SeparatedVBarRender;
	NS.SeparatedHBarRender = SeparatedHBarRender;
	NS.SeparatedLineChartRender = SeparatedLineChartRender;
	NS.SeparatedAreaChartRender = SeparatedAreaChartRender;
	NS.SeparatedScatterChartRender = SeparatedScatterChartRender;
	
	NS.KPICardChartRender = KPICardChartRender;
	NS.ColumnChartRender = VColumnChartRender;
	NS.BarChartRender = HColumnChartRender;
	NS.CompositeChartRender = CompositeChartRender;
	NS.LineChartRender = LineChartRender;
	NS.AreaChartRender = AreaChartRender;
	NS.RadarChartRender = RadarChartRender;
	NS.ProgressCircleChartRender = ProgressCircleChartRender;
	NS.ProgressBarChartRender = HProgressChartRender;
	NS.ProgressColumnChartRender = VProgressChartRender;
	NS.DialChartRender = DialChartRender;
	NS.GridChartRender = GridChartRender;
	NS.CustomListChartRender = CustomListChartRender;
	NS.WaterfallChartRender = WaterfallChartRender;
	NS.FunnelChartRender = FunnelChartRender;
	NS.ScatterChartRender = ScatterChartRender;
	NS.SunburstRender = SunburstRender;
	
	//import
	var Graphics;
	var NumberFormater;
	var ColorUtil;
	
	var GlobalFont;
	
	var Node;
	var AxisValueScope;
	var AbstractAttr;
	var PieAttr;
	var AbstractXYProgressAttr;
	var DialAttr;
	(function()
	{
		var oPackage = com.kingdee.bos.qing.common;
		Graphics = oPackage.Graphics;
		NumberFormater = oPackage.NumberFormater;
		ColorUtil = oPackage.ColorUtil;
		
		oPackage = com.kingdee.bos.qing.framework.common;
		GlobalFont = oPackage.GlobalFont;
		
		oPackage = com.kingdee.bos.qing.chart.model;
		Node = oPackage.Node;
		AxisValueScope = oPackage.AxisValueScope;
		AbstractAttr = oPackage.AbstractAttr;
		PieAttr = oPackage.PieAttr;
		AbstractXYProgressAttr = oPackage.AbstractXYProgressAttr;
		DialAttr = oPackage.DialAttr;
	})();

	var DEFAULT_COLOR = "#ccc"; //用于后端没给颜色的容错处理
	var DEFAULT_DATA_LABEL_COLOR = "#666";
	var DEFAULT_DATA_LABEL_FONT_SIZE = GlobalFont.getFontSize();
	var COLUMN_MAX_WIDE = 48;
	
	var HOVER_MASK_COLOR = "rgba(128,128,128,0.15)";
	var HOVER_LINE_COLOR = "#aaa";
	
	function StyleTool(oAttr)
	{
		var _this = this;
		var _sUnselectedMaskColor;
		var _sTextShadowColor;
		
		this.getCustomStyle = function(sKey, sDefault)
		{
			var sValue = oAttr.getCustomStyle(sKey);
			return sValue ? sValue : sDefault;
		}
		
		this.getBackgroundColor = function()
		{
			return _this.getCustomStyle(StyleTool.BACKGROUND, "#fff");
		}
		
		this.getUnselectedMaskColor = function()
		{
			!_sUnselectedMaskColor && (_sUnselectedMaskColor = createBackgroundColorWithAlpha(0.85));
			return _sUnselectedMaskColor;
		}
		
		this.getTextShadowColor = function()
		{
			!_sTextShadowColor && (_sTextShadowColor = createBackgroundColorWithAlpha(0.5));
			return _sTextShadowColor;
		}
		
		var createBackgroundColorWithAlpha = function(numAlpha)
		{
			var sColor = _this.getBackgroundColor();
			return Util.createColorWithAlpha(sColor, numAlpha);
		}
	}
	StyleTool.BACKGROUND = "background";
	StyleTool.LEGEND_COLOR = "legendColor";
	StyleTool.LEGEND_FONTSIZE = "legendFontSize";
	StyleTool.DATALABEL_COLOR = "dataLabelColor";
	StyleTool.DATALABEL_FONTSIZE = "dataLabelFontSize";
	StyleTool.AXIS_FONTSIZE = "axisFontSize";
	StyleTool.AXIS_TEXT_COLOR = "axisTextColor";
	StyleTool.AXIS_LINE_COLOR = "axisLineColor";
	StyleTool.RULER_FONTSIZE = "rulerFontSize";
	StyleTool.RULER_TEXT_COLOR = "rulerColor";
	StyleTool.RULER_MARK_LINE_COLOR = "rulerMarkLineColor";
	StyleTool.RULER_MARK_COLOR = "rulerMarkColor";
	StyleTool.REFLINE_COLOR = "reflineColor";
	StyleTool.REFLINE_COLOR_HOVER = "reflineColorHover";
	StyleTool.REFLINE_TIPS_COLOR = "reflineTipsColor";
	StyleTool.REFLINE_TIPS_FONTSIZE = "reflineTipsFontSize";
	
	StyleTool.CHART_KPI = "chartKpi";
	StyleTool.CHART_PIE = "chartPie";
	StyleTool.CHART_RADAR = "chartRadar";
	StyleTool.CHART_GRID = "chartGrid";
	StyleTool.CHART_WATERFALL = "chartWaterfall";
	
	var Util = new (function()
	{
		var _this = this;
		
		this.createColorWithAlpha = function(sColor, numAlpha)
		{
			return ColorUtil.withOpacityToRgba(sColor, numAlpha);
		}
		
		this.createColorWithoutAlpha = function(sColor)
		{
			var arrRgba = ColorUtil.decodeStringToRgbaArray(sColor);
			return "rgb(" + arrRgba[0] + "," + arrRgba[1] + "," + arrRgba[2] + ")";
		}
		
		this.getFitLabelColor = function(sBackgroundColor)
		{
			var arrRgb = ColorUtil.decodeStringToRgbArray(sBackgroundColor);
			var arrHsl = ColorUtil.rgbToHsl(arrRgb[0], arrRgb[1], arrRgb[2]);
			var iHue = arrHsl[0];
			var iLight = arrHsl[2];
			if(30 < iHue && iHue < 190)
			{
				return (iLight > 40 ? "#333" : "#fff");
			}
			else
			{
				return (iLight > 70 ? "#333" : "#fff");
			}
		}
		
		/** 
		 * 将字符串sText从原来的numTextWidth绘制宽度，缩短为不超过numTargetWidth，截短后加点点点。
		 * 如果需要精确，传入oCtx。否则只是估算。
		 */
		this.shortenText = function(sText, numTextWidth, numTargetWidth, oCtx)
		{
			var iNewLength = parseInt(sText.length * numTargetWidth / numTextWidth);
			sText = sText.substring(0, iNewLength) + "...";
			while(oCtx && oCtx.measureText(sText).width > numTargetWidth && iNewLength >= 0)
			{
				iNewLength--;
				sText = sText.substring(0, iNewLength) + "...";
			}
			return sText;
		}
		
		/** 
		 * 将字符串sText从原来的numTextWidth绘制宽度，缩短为不超过numTargetWidth，截掉前面字符，且在前面加点点点。
		 * 如果需要精确，传入oCtx。否则只是估算。
		 */
		this.shortenTextBefore = function(sText, numTextWidth, numTargetWidth, oCtx)
		{
			var iNewLength = parseInt(sText.length * numTargetWidth / numTextWidth);
			var sShortenText = "..." + sText.substring(sText.length - iNewLength);
			while(oCtx && oCtx.measureText(sShortenText).width > numTargetWidth && iNewLength >= 0)
			{
				iNewLength--;
				sShortenText = "..." + sText.substring(sText.length - iNewLength);
			}
			return sShortenText;
		}
		
		/** 
		 * 计算字体高度
		 */
		this.getTextHeight = function(oCtx)
		{
			return oCtx.measureText("宋").width;
		}
		
		this.getCustomStyle = function(oStyleTool, sKey, sDefaultValue)
		{
			return oStyleTool ? oStyleTool.getCustomStyle(sKey, sDefaultValue) : sDefaultValue;
		}
		
		this.getDataLabelColor = function(oStyleTool)
		{
			return _this.getCustomStyle(oStyleTool, StyleTool.DATALABEL_COLOR, DEFAULT_DATA_LABEL_COLOR);
		}
		this.getDataLabelFontSize = function(oStyleTool)
		{
			return parseInt(_this.getCustomStyle(oStyleTool, StyleTool.DATALABEL_FONTSIZE, DEFAULT_DATA_LABEL_FONT_SIZE));
		}
		
		this.getAxisTextFontSize = function(oStyleTool)
		{
			return parseInt(_this.getCustomStyle(oStyleTool, StyleTool.AXIS_FONTSIZE, GlobalFont.getFontSize()));
		}
		this.getAxisTextColor = function(oStyleTool)
		{
			return _this.getCustomStyle(oStyleTool, StyleTool.AXIS_TEXT_COLOR, "#999");
		}
		this.getAxisLineColor = function(oStyleTool)
		{
			return _this.getCustomStyle(oStyleTool, StyleTool.AXIS_LINE_COLOR, "#ccc");
		}
		
		this.getRulerMarkTextFontSize = function(oStyleTool)
		{
			return parseInt(_this.getCustomStyle(oStyleTool, StyleTool.RULER_FONTSIZE, GlobalFont.getFontSize()));
		}
		this.getRulerMarkTextColor = function(oStyleTool)
		{
			return _this.getCustomStyle(oStyleTool, StyleTool.RULER_TEXT_COLOR, "#999");
		}
		this.getRulerMarkLongLineColor = function(oStyleTool)
		{
			return _this.getCustomStyle(oStyleTool, StyleTool.RULER_MARK_LINE_COLOR, "#e5e5e5");
		}
		this.getRulerMarkShortLineColor = function(oStyleTool)
		{
			return _this.getCustomStyle(oStyleTool, StyleTool.RULER_MARK_COLOR, "#ccc");
		}
		
		this.setupFont = function(oCtx, iFontSize, sFontName)
		{
			setupFont(oCtx, iFontSize + "px", sFontName);
		}
		this.setupFontWithBold = function(oCtx, iFontSize, sFontName)
		{
			setupFont(oCtx, "bold " + iFontSize + "px", sFontName);
		}
		var setupFont = function(oCtx, sPreContent, sFontName)
		{
			oCtx.font = sPreContent + " " + (sFontName ? sFontName : GlobalFont.getFontName());
		}
		
		this.drawShadowText = function(oStyleTool, oGraphics, sText, iLogicX, iLogicY, funAdjust)
		{
			var bDraw = true;
			var arrXY = oGraphics.transformXY(iLogicX, iLogicY);
			funAdjust && (bDraw = funAdjust(arrXY));
			if(bDraw === false)
			{
				return;
			}
			var iApiX = arrXY[0];
			var iApiY = arrXY[1];
			_this.drawTextWithShadow(oStyleTool, oGraphics.getContext(), sText, iApiX, iApiY);
		}
		this.drawTextWithShadow = function(oStyleTool, oCtx, sText, iX, iY)
		{
			var sColor = oCtx.fillStyle;			
			oCtx.fillStyle = (oStyleTool ? oStyleTool.getTextShadowColor() : "grba(255,255,255,0.5)");
			oCtx.fillText(sText, iX - 1, iY - 1);
			oCtx.fillText(sText, iX - 1, iY + 1);
			oCtx.fillText(sText, iX + 1, iY - 1);
			oCtx.fillText(sText, iX + 1, iY + 1);
			oCtx.fillStyle = sColor;
			oCtx.fillText(sText, iX, iY);
		}
		
		this.drawTextFitBackground = function(sBackgroundColor, oCtx, sText, iX, iY)
		{
			var sTextColor = Util.getFitLabelColor(sBackgroundColor);
			var sColor = oCtx.fillStyle;
			oCtx.fillStyle = sTextColor;
			oCtx.fillText(sText, iX, iY);
			oCtx.fillStyle = sColor;
		}
		
		this.formatPercentage = function(numRatio, iDecimalDigit)
		{
			var iTimes = Math.pow(10, iDecimalDigit);
			var iIncreaseTimes = 100 * iTimes;
			var iReduceTimes = iTimes;
			return Math.round(numRatio * iIncreaseTimes) / iReduceTimes + "%";
		}
	})();
	
	/** 
	 * 百分比模式计算器
	 */
	var PercentModeCalculator = new (function()
	{
		/** 
		 * 获得单个category所有Series值的总和
		 */
		this.getCategoryTotal = function(oModel, iCategoryIdx)
		{
			var iCategoryTotal = 0;
			var arrSeries = oModel.getSeries();
			var iSeriesCount = (arrSeries ? arrSeries.length : 0);
			for(var j = 0; j < iSeriesCount; j++)
			{
				var oSeries = arrSeries[j];
				var oNode = oSeries.getNodes()[iCategoryIdx];
				if(!oNode || isNaN(oNode.getValue()))
				{
					continue;
				}
				iCategoryTotal += oNode.getValue();
			}
			return iCategoryTotal;
		}
		
		/** 
		 * 获得多个category中正值和占总和的最大百分比、负值和占总和的最小百分比
		 * 返回：arrMaxPercent[0]正值最大百分比，arrMaxPercent[1]负值最小百分比
		 */
		this.getMaxCategoryPercent = function(oModel)
		{
			var arrCategory = oModel.getCategories();
			var iCategoryCount = arrCategory.length;
			var arrSeries = oModel.getSeries();
			var iSeriesCount = (arrSeries ? arrSeries.length : 0);
			var arrMaxPercent = [0, 0];
			for(var i = 0; i < iCategoryCount; i++)
			{
				var iPositiveNum = 0;
				var iNegativeNum = 0;
				var iCategoryTotal = 0;
				for(var j = 0; j < iSeriesCount; j++)
				{
					var oSeries = arrSeries[j];
					var oNode = oSeries.getNodes()[i];
					if(!oNode || isNaN(oNode.getValue()))
					{
						continue;
					}
					var iValue = oNode.getValue();
					iCategoryTotal += iValue;
					if(iValue > 0)
					{
						iPositiveNum += iValue;
					}
					else
					{
						iNegativeNum += iValue;
					}
				}
				if(iCategoryTotal > 0) //取正百分比的最大值和负百分比的最小值
				{
					arrMaxPercent[0] = Math.max(iPositiveNum / iCategoryTotal, arrMaxPercent[0]);
					arrMaxPercent[1] = Math.min(iNegativeNum / iCategoryTotal, arrMaxPercent[1]);
				}
				else if(iCategoryTotal < 0)
				{
					arrMaxPercent[0] = Math.max(iNegativeNum / iCategoryTotal, arrMaxPercent[0]);
					arrMaxPercent[1] = Math.min(iPositiveNum / iCategoryTotal, arrMaxPercent[1]);
				}
				else
				{
					arrMaxPercent = [1, 0];
				}
			}
			return arrMaxPercent;
		}
	})();
	
	/** 判断矩形区域是否重叠 */
	function NonoverlappingConfirmer(iAreaX, iAreaY, iAreaWidth, iAreaHeight)
	{
		var _this = this;
		var _bCheckArea = (iAreaWidth ? true : false);
		var _arrExistRects = [];
		
		//iX, iY 矩形左上角顶点坐标
		this.isRectCanDraw = function(iX, iY, iWidth, iHeight)
		{
			if(_this.askRectCanDraw(iX, iY, iWidth, iHeight))
			{
				_this.setRectHasBeenDrawn(iX, iY, iWidth, iHeight);
				return true;
			}
			return false;
		}
		
		//iX, iY 矩形左上角顶点坐标
		this.askRectCanDraw = function(iX, iY, iWidth, iHeight)
		{
			if(_bCheckArea && 
				(iX < iAreaX || iY < iAreaY || iX + iWidth > iAreaX + iAreaWidth || iY + iHeight > iAreaY + iAreaHeight))
			{
				return false;
			}
			iX += 0.5;
			iY += 0.5;
			iWidth -= 1;
			iHeight -= 1;
			var iDataLabelToDrawCenterX = iX + (iWidth >> 1);
			var iDataLabelToDrawCenterY = iY + (iHeight >> 1);
			for(var i = _arrExistRects.length - 1; i >= 0; i--)
			{
				var arrExistOneRect = _arrExistRects[i];
				var iExistX = arrExistOneRect[0];
				var iExistY = arrExistOneRect[1];
				var iExistWidth = arrExistOneRect[2];
				var iExistHeight = arrExistOneRect[3];
				var iDataLabelCenterX = iExistX + (iExistWidth >> 1);
				var iDataLabelCenterY = iExistY + (iExistHeight >> 1);
				if(Math.abs(iDataLabelToDrawCenterX - iDataLabelCenterX) < ((iExistWidth + iWidth) >> 1)
					&& Math.abs(iDataLabelToDrawCenterY - iDataLabelCenterY) < ((iExistHeight + iHeight) >> 1))
				{
					return false;
				}
			}
			return true;
		}
		
		//iX, iY 矩形左上角顶点坐标
		this.setRectHasBeenDrawn = function(iX, iY, iWidth, iHeight)
		{
			iX += 0.5;
			iY += 0.5;
			iWidth -= 1;
			iHeight -= 1;
			_arrExistRects.push([iX, iY, iWidth, iHeight]);
		}
	}
	
	function RulerScaleAdapter(oScope, sRulerScale, sRulerStart)
	{
		var _this = this;
		var _oScope = oScope;
		var _bWithLog = (sRulerScale == AbstractAttr.RulerScale_Auto ? oScope.isSuggestUseLog() : 
						(sRulerScale == AbstractAttr.RulerScale_Log ? true : false));
		var _bCutFoot = (sRulerStart == AbstractAttr.RulerStart_Nonzero ? true : false);
		var _numUsableMax = null;
		var _numUsableMin = null;
		
		/** 数轴刻度向外取大之后，重新给的范围。 @see SECTION_WITH_CEILING_AUTO | SECTION_WITH_CEILING_ALWAYS */
		this.updateScopeMaxMin = function(numMax, numMin)
		{
			(numMax !== null) && (_numUsableMax = numMax);
			(numMin !== null) && (_numUsableMin = numMin);
		}
		
		this.isWithLog = function()
		{
			return _bWithLog;
		}
		
		this.getScopeMax = function()
		{
			return (_numUsableMax === null ? getScopeMax() : _numUsableMax);
		}
		var getScopeMax = function()
		{
			return (_bWithLog ? _oScope.getLogMax() : _oScope.getMax());
		}
		
		this.getScopeMin = function()
		{
			return (_numUsableMin === null ? getScopeMin() : _numUsableMin);
		}
		var getScopeMin = function()
		{
			return (_bWithLog ? _oScope.getLogMin() : _oScope.getMin());
		}
		
		this.scale = function(numRealValue)
		{
			if(_bWithLog)
			{
				if(numRealValue == 0)
				{
					return 0;
				}
				else if(numRealValue < 0)
				{
					return -(Math.log(-numRealValue) / Math.LN10 + _oScope.getLogOffset());
				}
				else
				{
					return Math.log(numRealValue) / Math.LN10 + _oScope.getLogOffset();
				}
			}
			return numRealValue;
		}
		
		this.unscale = function(numScaledValue)
		{
			if(_bWithLog)
			{
				if(numScaledValue == 0)
				{
					return 0;
				}
				else if(numScaledValue < 0)
				{
					return -Math.pow(10, -numScaledValue - _oScope.getLogOffset());
				}
				else
				{
					return Math.pow(10, numScaledValue - _oScope.getLogOffset());
				}
			}
			return numScaledValue;
		}
		
		this.cutFoot = function(numScaledValue)
		{
			if(numScaledValue == 0)//如果包含有零的话，不可能有cuttableFoot
			{
				return 0;
			}
			else if(numScaledValue < 0)
			{
				return numScaledValue + _this.getCuttableFoot();
			}
			else
			{
				return numScaledValue - _this.getCuttableFoot();
			}
		}
		
		this.getCuttableFoot = function()
		{
			if(_bCutFoot)
			{
				return (_bWithLog ? _oScope.getCuttableFootForLog() : _oScope.getCuttableFootForLinear());
			}
			return 0;
		}
		
		this.isCuttingFoot = function()
		{
			return (_bCutFoot ? (_this.getCuttableFoot() > 0) : false);
		}
	}
	
	var PolarCoordinate = new (function()
	{
		var _this = this;
		
		//原点移到指定的中心，逆时针转90度，使从12点方向顺时针开始算角度（纵向向上的是X轴，横向向右是Y轴）
		this.transform = function(oGraphics, iApiXOfCenter, iApiYOfCenter)
		{
			oGraphics.setTransformMatrix(0, -1, 1, 0, iApiXOfCenter, iApiYOfCenter);
		}
		
		this.logicXyToRadius = function(numLogicX, numLogicY)
		{
			return Math.sqrt(numLogicX * numLogicX + numLogicY * numLogicY);
		}
		
		this.logicXyToAngle = function(numLogicX, numLogicY, numRadius)
		{
			(numRadius === undefined) && (numRadius = _this.logicXyToRadius(numLogicX, numLogicY));
			var numAngle = Math.acos(numLogicX / numRadius);
			(numLogicY < 0) && (numAngle = Math.PI * 2 - numAngle);
			return numAngle;
		}
		
		this.toLogicXy = function(numAngle, numRadius)
		{
			var numLogicX = Math.cos(numAngle) * numRadius;
			var numLogicY = Math.sin(numAngle) * numRadius;
			return [numLogicX, numLogicY];
		}
	})();
	
	var CoordinateTransformer = new (function()
	{
		//在oGraphics画面内，将(iApiX, iApiY)开始的高度为iHeight的区域的左侧某个点定义为(0,0)原点，X轴向右，Y轴向上，Y轴原点由oScope确定
		this.verticalNumberAxis = function(oGraphics, iApiX, iApiY, iHeight, oScopeAdapter, iShrinkForTopAlways, iShrinkForLabel)
		{
			var arrResult = vAxis(iApiY, iHeight, oScopeAdapter, iShrinkForTopAlways, iShrinkForLabel);
			var numPixelPerValue = arrResult[0];
			var numTranslateY = arrResult[1];
			var numTranslateX = iApiX;
			oGraphics.setTransformMatrix(1, 0, 0, -1, numTranslateX, numTranslateY);
			return numPixelPerValue;
		}
		
		var vAxis = function(iApiY, iHeight, oScopeAdapter, iShrinkForTopAlways, iShrinkForLabel)
		{
			var numMax = oScopeAdapter.getScopeMax();
			var numMin = oScopeAdapter.getScopeMin();
			var numCuttableFoot = oScopeAdapter.getCuttableFoot();
			var numTranslateY;
			var numDistance;
			if(numMax > 0 && numMin < 0) //有正有负
			{
				var iShrinkTop = Math.max(iShrinkForTopAlways, iShrinkForLabel);
				iHeight -= iShrinkTop;
				iHeight -= iShrinkForLabel;
				numDistance = numMax - numMin - numCuttableFoot * 2;
				numTranslateY = iApiY + iShrinkTop + iHeight * (numMax - numCuttableFoot) / numDistance;
			}
			else if(numMin >= 0) //都是正的
			{
				var iShrinkTop = Math.max(iShrinkForTopAlways, iShrinkForLabel);
				iHeight -= iShrinkTop;
				numDistance = numMax - numCuttableFoot;
				numTranslateY = iApiY + iShrinkTop + iHeight;
			}
			else //都是负值
			{
				var iShrinkTop = iShrinkForTopAlways;
				iHeight -= iShrinkTop;
				iHeight -= iShrinkForLabel;
				numDistance = -numMin - numCuttableFoot;
				numTranslateY = iApiY + iShrinkTop;
			}
			var numPixelPerValue = (numDistance == 0 ? 1 : iHeight / numDistance);
			return [numPixelPerValue, numTranslateY];
		}
		
		//在oGraphics画面内，将(iApiX, iApiY)开始的宽度为iWidth的区域的上方某个点定义为(0,0)原点，X轴和Y轴互换
		this.horizontalNumberAxis = function(oGraphics, iApiX, iApiY, iWidth, oScopeAdapter, 
			iShrinkForTopAlways, iPositiveShrinkForLabel, iNegativeShrinkForLabel)
		{
			var arrResult = hAxis(iApiX, iWidth, oScopeAdapter, iPositiveShrinkForLabel, iNegativeShrinkForLabel);
			var numPixelPerValue = arrResult[0];
			var numTranslateX = arrResult[1];
			var numTranslateY = iApiY + iShrinkForTopAlways;
			oGraphics.setTransformMatrix(0, 1, 1, 0, numTranslateX, numTranslateY);
			return numPixelPerValue;
		}
		
		var hAxis = function(iApiX, iWidth, oScopeAdapter, iPositiveShrinkForLabel, iNegativeShrinkForLabel)
		{
			var numMax = oScopeAdapter.getScopeMax();
			var numMin = oScopeAdapter.getScopeMin();
			var numCuttableFoot = oScopeAdapter.getCuttableFoot();
			var numTranslateX;
			var numDistance;
			iWidth -= iPositiveShrinkForLabel;
			iWidth -= iNegativeShrinkForLabel;
			if(numMax > 0 && numMin < 0) //有正有负
			{
				numDistance = numMax - numMin - numCuttableFoot * 2;
				numTranslateX = iApiX + iNegativeShrinkForLabel + iWidth * (-numMin - numCuttableFoot) / numDistance;
			}
			else if(numMin >= 0) //都是正的
			{
				numDistance = numMax - numCuttableFoot;
				numTranslateX = iApiX;
			}
			else //都是负值
			{
				numDistance = -numMin - numCuttableFoot;
				numTranslateX = iApiX + iNegativeShrinkForLabel + iWidth;
			}
			var numPixelPerValue = (numDistance == 0 ? 1 : iWidth / numDistance);
			return [numPixelPerValue, numTranslateX];
		}
		
		//在oGraphics画面内，将(iApiX, iApiY)开始的宽高为iWidth/iHeight的区域的左侧某个点定义为(x,0)Y轴原点，下方某个点定义为(0,y)X轴原点，X轴向右，Y轴向上。
		this.doubleNumberAxis = function(oGraphics, iApiX, iApiY, iWidth, iHeight, oXScopeAdapter, oYScopeAdapter, iShrinkForTopAlways)
		{
			var arrResult = vAxis(iApiY, iHeight, oYScopeAdapter, iShrinkForTopAlways, 0);
			var numPixelPerValueForY = arrResult[0];
			var numTranslateY = arrResult[1];
			
			var arrResult = hAxis(iApiX, iWidth, oXScopeAdapter, 0, 0);
			var numPixelPerValueForX = arrResult[0];
			var numTranslateX = arrResult[1];
			
			oGraphics.setTransformMatrix(1, 0, 0, -1, numTranslateX, numTranslateY);
			return [numPixelPerValueForX, numPixelPerValueForY];
		}
	})();
	
	var YNXSPainter = new (function()
	{
		var TEXT_LEAN_ANGLE = Math.PI * 60 / 180;
		
		this.confirmNumberAxis = function(numPixelPerValue, iShrinkForLabel, oScopeAdapter, oStyleTool, oYNXSAttr)
		{
			var numScopeMin = oScopeAdapter.getScopeMin();
			var numScopeMax = oScopeAdapter.getScopeMax();
			var numYMax, numYMin;
			if(numScopeMin >= 0)
			{
				var iShrinkTop = Math.max(iShrinkForLabel, getShrinkForTop(oStyleTool, oYNXSAttr));
				numYMax = (numScopeMax - oScopeAdapter.getCuttableFoot()) * numPixelPerValue + iShrinkTop;
				numYMin = 0;
			}
			else if(numScopeMax <= 0)
			{
				var iShrinkBottom = iShrinkForLabel;
				numYMax = 0;
				numYMin = (numScopeMin + oScopeAdapter.getCuttableFoot()) * numPixelPerValue - iShrinkBottom;
			}
			else
			{
				var iShrinkTop = Math.max(iShrinkForLabel, getShrinkForTop(oStyleTool, oYNXSAttr));
				var iShrinkBottom = iShrinkForLabel;
				numYMax = (numScopeMax - oScopeAdapter.getCuttableFoot()) * numPixelPerValue + iShrinkTop;
				numYMin = (numScopeMin + oScopeAdapter.getCuttableFoot()) * numPixelPerValue - iShrinkBottom;
			}
			return [numYMin, numYMax];
		}
		
		this.getShrinkForTopAlways = function(oStyleTool, oYNXSAttr)
		{
			var iFontSize = GlobalFont.getFontSize();
			var iSpaceForRollOut = (oYNXSAttr.isReserveRollOutSpace() ? iFontSize * 1.6 : 0);
			return parseInt(iSpaceForRollOut + getShrinkForTop(oStyleTool, oYNXSAttr));
		}
		
		var getShrinkForTop = function(oStyleTool, oYNXSAttr)
		{
			var iFontSize = parseInt(Util.getCustomStyle(oStyleTool, StyleTool.RULER_FONTSIZE, GlobalFont.getFontSize()));
			var iSpaceForMark = iFontSize * 0.6;
			var iSpaceForUnit = (oYNXSAttr.getYUnitText() ? iFontSize * 1.6 : 0);
			return parseInt(Math.max(iSpaceForMark, iSpaceForUnit));
		}
		
		this.suggestCategoryAxisHeight = function(oStyleTool, oGraphics, numPixelPerCategory, arrCategory)
		{
			var iHeight = 0;
			drawCategoryAxisParamsConfirmer(oStyleTool, oGraphics, numPixelPerCategory, arrCategory, 
				function(bLieOrLean, bSingleLine, numUsableTextOffsetX, numUsableTextWidth, arrEachTextWidth, iFontSize)
				{
					if(bLieOrLean)
					{
						if(bSingleLine)
						{
							iHeight = iFontSize;
						}
						else
						{
							var iLines = 0;
							var iUsableWithEachLine = parseInt(numUsableTextWidth / iFontSize) * iFontSize;
							for(var i = 0; i < arrEachTextWidth.length; i++)
							{
								var numTextWidth = arrEachTextWidth[i];
								iLines = Math.max(iLines, parseInt(numTextWidth / iUsableWithEachLine + 1));
							}
							iHeight = iLines * iFontSize;
						}
					}
					else
					{
						var iUsableHeight = 65535;
						var iLineHeight = iFontSize;
						drawXAxisTextLeanAlgorithm(arrCategory, arrEachTextWidth, iUsableHeight, iLineHeight, 
							function(iCategoryIdx)
							{
								return iCategoryIdx * numPixelPerCategory;
							}, 
							function(numHeightA, numColumnX, sLabel, numUsableTextWidth)
							{
								iHeight = Math.max(iHeight, numHeightA);
							});
					}
					iHeight += iFontSize;
				});
			return iHeight;
		}
		
		this.drawCategoryAxis = function(arrCategory, funCategoryXConfirmer, oStyleTool, oGraphics, iAreaWidth, iAreaHeight, numPixelPerCategory, numNumberAxisMinY)
		{
			drawZeroLine(oStyleTool, oGraphics, iAreaWidth);
			if(Math.abs(numNumberAxisMinY - 0) > 30)//0就在下方或离下方很近时不再另画类别轴线
			{
				drawXAxisLine(oGraphics, iAreaWidth, numNumberAxisMinY);
			}
			drawCategoryAxisParamsConfirmer(oStyleTool, oGraphics, numPixelPerCategory, arrCategory, 
				function(bLieOrLean, bSingleLine, numUsableTextOffsetX, numUsableTextWidth, arrEachTextWidth, iFontSize)
				{
					if(bLieOrLean)
					{
						var funTextLeftConfirmer = function(iCategoryIdx)
						{
							return funCategoryXConfirmer(iCategoryIdx, "left") + numUsableTextOffsetX;
						};
						var numTextY = numNumberAxisMinY - iFontSize * 0.5;
						var numUsableTextHeight = iAreaHeight - iFontSize;
						var iLineHeight = iFontSize;
						drawXAxisTextLie(oGraphics, arrCategory, arrEachTextWidth, numUsableTextWidth, numUsableTextHeight, 
								funTextLeftConfirmer, numTextY, bSingleLine, iLineHeight);
					}
					else
					{
						var funTextCenterConfirmer = function(iCategoryIdx)
						{
							return funCategoryXConfirmer(iCategoryIdx, "center");
						};
						var numUsableTextHeight = iAreaHeight;
						var iLineHeight = iFontSize;
						drawXAxisTextLean(oGraphics, arrCategory, arrEachTextWidth, numUsableTextHeight, 
								funTextCenterConfirmer, numNumberAxisMinY, iLineHeight);
					}
				});
		}
		
		var drawCategoryAxisParamsConfirmer = function(oStyleTool, oGraphics, numPixelPerCategory, arrCategory, funCallback)
		{
			var iFontSize = Util.getAxisTextFontSize(oStyleTool);
			var oCtx = oGraphics.getContext();
			oCtx.fillStyle = Util.getAxisTextColor(oStyleTool);
			Util.setupFont(oCtx, iFontSize);
			
			var numUsableTextOffsetX = Math.max(iFontSize * 0.25, numPixelPerCategory * 0.05);
			var numUsableTextWidth = Math.max(0, numPixelPerCategory - numUsableTextOffsetX * 2);
			var bNarrow = (numUsableTextWidth < iFontSize * 2);
			var bLieOrLean = true;
			var bSingleLine = true;
			var arrEachTextWidth = [];
			for(var i = 0; i < arrCategory.length; i++)
			{
				var oCategory = arrCategory[i];
				var sLabel = oCategory.getLabel();
				var numTextWidth = (sLabel ? oCtx.measureText(sLabel).width : 0);
				arrEachTextWidth.push(numTextWidth);
				if(numTextWidth > numUsableTextWidth)//横向单行画不下
				{
					if(bNarrow)//太挤，斜向
					{
						bLieOrLean = false;
					}
					else//横向多行
					{
						bSingleLine = false;
					}
				}
			}
			funCallback(bLieOrLean, bSingleLine, numUsableTextOffsetX, numUsableTextWidth, arrEachTextWidth, iFontSize);
		}
		
		var drawXAxisTextLie = function(oGraphics, arrCategory, arrEachTextWidth, iUsableWidth, iUsableHeight, funTextLeftConfirmer, numTextY, bSingleLine, iLineHeight)
		{
			var oSingleLineRender = new CuttingTextRender();
			oSingleLineRender.setTextBaseline("top");
			var oMultiLineRender = null;
			if(!bSingleLine)
			{
				oMultiLineRender = new MultiLineTextRender();
				oMultiLineRender.setHorizontalAlign("center");
			}
			for(var i = 0; i < arrCategory.length; i++)
			{
				var oCategory = arrCategory[i];
				var sLabel = oCategory.getLabel();
				if(!sLabel)//没有类别字段
				{
					continue;
				}
				var numTextX = funTextLeftConfirmer(i);
				if(bSingleLine || arrEachTextWidth[i] <= iUsableWidth)
				{
					oSingleLineRender.drawAlignCenterWithLogicCoord(oGraphics, numTextX, numTextY, sLabel, iUsableWidth);
				}
				else
				{
					oMultiLineRender.drawTextLines(oGraphics, numTextX, numTextY, sLabel, iUsableWidth, iUsableHeight, iLineHeight);
				}
			}
		}
		
		var drawXAxisTextLean = function(oGraphics, arrCategory, arrEachTextWidth, iUsableHeight, funTextCenterConfirmer, numNumberAxisMinY, iLineHeight)
		{
			var numDetaXRate = Math.cos(TEXT_LEAN_ANGLE) / Math.sin(TEXT_LEAN_ANGLE); 
			//以上，DeltaY乘以系数numDetaXRate为DeltaX。
			var oRender = new CuttingTextRender();
			oRender.setTextBaseline("top");
			var oCtx = oGraphics.getContext();
			drawXAxisTextLeanAlgorithm(arrCategory, arrEachTextWidth, iUsableHeight, iLineHeight, funTextCenterConfirmer, 
				function(numHeightA, numColumnX, sLabel, numUsableTextWidth)
				{
					var numTextY = numNumberAxisMinY - numHeightA - 2;//-2 字不要贴着线
					var numTextX = numColumnX - iLineHeight * 0.4 - numHeightA * numDetaXRate;//*0.4 视觉OK的经验值。（由于上对齐）理论上应该偏移半个行高除以sin。
					var arrApiXY = oGraphics.transformXY(numTextX, numTextY);
					var iApiX = arrApiXY[0];
					var iApiY = arrApiXY[1];
					oCtx.translate(iApiX, iApiY);
					oCtx.rotate(-TEXT_LEAN_ANGLE);
					oRender.drawAlignRight(oCtx, 0, 0, sLabel, numUsableTextWidth);
					oCtx.rotate(TEXT_LEAN_ANGLE);
					oCtx.translate(-iApiX, -iApiY);
				});
		}
		
		var drawXAxisTextLeanAlgorithm = function(arrCategory, arrEachTextWidth, iUsableHeight, iLineHeight, funTextCenterConfirmer, funDrawEach)
		{
			var numDetaYRate = Math.sin(TEXT_LEAN_ANGLE);//TextWidth乘以系数numDetaYRate为DeltaY
			var iNarrowestWide = parseInt(iLineHeight * 1.2 / Math.sin(TEXT_LEAN_ANGLE));
			var iHeightB = parseInt(iLineHeight * Math.cos(TEXT_LEAN_ANGLE) + 1);
			var numLastColumnX = -65535;
			for(var i = 0; i < arrCategory.length; i++)
			{
				var oCategory = arrCategory[i];
				var sLabel = oCategory.getLabel();
				if(!sLabel)//没有类别字段
				{
					continue;
				}
				var numColumnX = funTextCenterConfirmer(i);
				if(numColumnX - numLastColumnX < iNarrowestWide)//太挤放不下
				{
					continue;
				}
				numLastColumnX = numColumnX;
				
				var numTextWidth = arrEachTextWidth[i];
				var numHeightA = numTextWidth * numDetaYRate;
				var numHeightWillOccupy = numHeightA + iHeightB;
				if(numHeightWillOccupy > iUsableHeight)
				{
					numHeightA = iUsableHeight - iHeightB;
					numTextWidth = numHeightA / numDetaYRate;
				}
				funDrawEach(numHeightA, numColumnX, sLabel, numTextWidth);
			}
		}
		
		var drawZeroLine = function(oStyleTool, oGraphics, iAreaWidth)
		{
			oGraphics.getContext().strokeStyle = Util.getAxisLineColor(oStyleTool);
			oGraphics.beginPath();
			oGraphics.moveTo(-5, 0);
			oGraphics.lineTo(iAreaWidth, 0);
			oGraphics.stroke();
		}
		
		var drawXAxisLine = function(oGraphics, iAreaWidth, numNumberAxisMinY)
		{
			oGraphics.beginPath();
			oGraphics.moveTo(0, numNumberAxisMinY);
			oGraphics.lineTo(iAreaWidth, numNumberAxisMinY);
			oGraphics.stroke();
		}
		
		
		this.suggestContinueCategoryAxisHeight = function(oStyleTool)
		{
			var iFontSize = Util.getAxisTextFontSize(oStyleTool);
			return iFontSize * 2;
		}
		
		this.drawContinueCategoryAxis = function(arrCategory, funXConfirmer, oStyleTool, oGraphics, iAreaWidth, iAreaHeight, numNumberAxisMinY, iMinX)
		{
			drawZeroLine(oStyleTool, oGraphics, iAreaWidth);
			var numMarkY1 = 0;
			if(Math.abs(numNumberAxisMinY - 0) > 8)//0就在下方或离下方很近时不再另画类别轴线
			{
				drawXAxisLine(oGraphics, iAreaWidth, numNumberAxisMinY);
				numMarkY1 = numNumberAxisMinY;
			}
			var numMarkY2 = numMarkY1 + 5;
			var numTextY = numNumberAxisMinY - (iAreaHeight >> 1);
			drawContinueCategoryAxis(arrCategory, funXConfirmer, oStyleTool, oGraphics, iAreaWidth, numMarkY1, numMarkY2, numTextY, iMinX);
		}
		
		/** 上方连续值类别轴（长卷）。以轴所在位置为Y零，方向向上。 */
		this.drawTopContinueCategoryAxis = function(arrCategory, funXConfirmer, oStyleTool, oGraphics, iAreaWidth)
		{
			var iTextHeight = Util.getTextHeight(oGraphics.getContext());
			var numMarkY1 = 0;
			var numMarkY2 = 8;
			var numTextY = numMarkY2 + 4 + iTextHeight * 0.5;
			var iMinX = 0;
			drawContinueCategoryAxis(arrCategory, funXConfirmer, oStyleTool, oGraphics, iAreaWidth, numMarkY1, numMarkY2, numTextY, iMinX);
		}
		
		var drawContinueCategoryAxis = function(arrCategory, funXConfirmer, oStyleTool, oGraphics, iAreaWidth, numMarkY1, numMarkY2, numTextY, iMinX)
		{
			var oCtx = oGraphics.getContext();
			oCtx.strokeStyle = Util.getAxisLineColor(oStyleTool);
			oCtx.fillStyle = Util.getAxisTextColor(oStyleTool);
			Util.setupFont(oCtx, Util.getAxisTextFontSize(oStyleTool));
			oCtx.textBaseline = "middle";
			var iTextGap = 14;
			var numRunningX = -32768;
			for(var i = 0; i < arrCategory.length; i++)
			{
				var oCategory = arrCategory[i];
				var sLabel = oCategory.getLabel();
				if(!sLabel)
				{
					continue;
				}
				var numColumnCenterX = funXConfirmer(i);
				if(numColumnCenterX < numRunningX)
				{
					continue;
				}
				var iTextWidth = oCtx.measureText(sLabel).width;
				var numTextX = numColumnCenterX - iTextWidth / 2;
				if(numTextX < iMinX)
				{
					numTextX = iMinX;
				}
				if(numTextX < numRunningX)
				{
					continue;
				}
				var numTextEndX = numTextX + iTextWidth;
				if(numTextEndX > iAreaWidth)
				{
					numTextX = iAreaWidth - iTextWidth;
				}
				if(numTextX < numRunningX)
				{
					numTextX = numRunningX;
					var numLimitedWidth = iAreaWidth - numRunningX;
					sLabel = Util.shortenText(sLabel, iTextWidth, numLimitedWidth);
				}
				oGraphics.fillText(sLabel, numTextX, numTextY);
				numRunningX = numTextX + iTextWidth + iTextGap;
				
				oGraphics.beginPath();
				oGraphics.moveTo(numColumnCenterX, numMarkY1);
				oGraphics.lineTo(numColumnCenterX, numMarkY2);
				oGraphics.stroke();
			}
		}
	})();
	
	var XNYSPainter = new (function()
	{
		this.confirmNumberAxis = function(numPixelPerValue, oScopeAdapter)
		{
			var numScopeMin = oScopeAdapter.getScopeMin();
			var numScopeMax = oScopeAdapter.getScopeMax();
			var numYMax, numYMin;
			if(numScopeMin >= 0)
			{
				numYMax = (numScopeMax - oScopeAdapter.getCuttableFoot()) * numPixelPerValue;
				numYMin = 0;
			}
			else if(numScopeMax <= 0)
			{
				numYMax = 0;
				numYMin = (numScopeMin + oScopeAdapter.getCuttableFoot()) * numPixelPerValue;
			}
			else
			{
				numYMax = (numScopeMax - oScopeAdapter.getCuttableFoot()) * numPixelPerValue;
				numYMin = (numScopeMin + oScopeAdapter.getCuttableFoot()) * numPixelPerValue;
			}
			return [numYMin, numYMax];
		}
		
		var calculateUsableTextWide = function(numPixelPerCategory, iLineHeight)
		{
			var numUsableTextOffset = Math.max(iLineHeight * 0.25, numPixelPerCategory * 0.05);
			var numUsableTextWide = Math.max(0, numPixelPerCategory - numUsableTextOffset * 2);
			var iUsableLines = Math.max(1, parseInt(numUsableTextWide / iLineHeight));
			return [numUsableTextOffset, numUsableTextWide, iUsableLines];
		}
		
		this.suggestCategoryAxisWidth = function(oStyleTool, oGraphics, numPixelPerCategory, arrCategory, numPerferredMaxWidth)
		{
			var iFontSize = Util.getAxisTextFontSize(oStyleTool);
			var numMaxWidth = 0;
			drawLeftAxisTextAlgorithm(oGraphics.getContext(), iFontSize, arrCategory, 
				function(iCategoryIdx)
				{
					return iCategoryIdx * numPixelPerCategory;
				},
				function(sLabel, numColumnX, numTextWidth)
				{
					numMaxWidth = Math.max(numMaxWidth, numTextWidth);
				});
			var numSuggestAxisWidth = numMaxWidth + iFontSize;
			if(numSuggestAxisWidth > numPerferredMaxWidth)
			{
				var iLineHeight = iFontSize;
				var iUsableLines = calculateUsableTextWide(numPixelPerCategory, iLineHeight)[2];
				for(var iLines = 1; iLines <= iUsableLines; iLines++)
				{
					numSuggestAxisWidth = numMaxWidth / iLines + iFontSize;
					if(numSuggestAxisWidth <= numPerferredMaxWidth)
					{
						break;
					}
				}
			}
			return numSuggestAxisWidth;
		}
		
		this.drawLeftCategoryAxis = function(arrCategory, funXConfirmer, oStyleTool, oGraphics, iAreaWidth, iAreaHeight, numPixelPerCategory, numNumberAxisMinY)
		{
			var oCtx = oGraphics.getContext();
			oCtx.strokeStyle = Util.getAxisLineColor(oStyleTool);
			oCtx.fillStyle = Util.getAxisTextColor(oStyleTool);
			
			oGraphics.beginPath();
			oGraphics.moveTo(0, 0);
			oGraphics.lineTo(iAreaHeight + 5, 0);
			oGraphics.stroke();
			if(Math.abs(numNumberAxisMinY - 0) > 40)//0就在左边或离左边很近时不再另画类别轴线
			{
				oGraphics.beginPath();
				oGraphics.moveTo(0, numNumberAxisMinY);
				oGraphics.lineTo(iAreaHeight, numNumberAxisMinY);
				oGraphics.stroke();
			}
			
			var iFontSize = Util.getAxisTextFontSize(oStyleTool);
			var iLineHeight = iFontSize;
			
			var arrParams = calculateUsableTextWide(numPixelPerCategory, iLineHeight);
			var numUsableTextOffset = arrParams[0];
			var numUsableTextHeight = arrParams[1];
			var bMultiLine = (arrParams[2] > 1);
			var iGap = 6;
			var iUsableTextWidth = iAreaWidth - iGap;
			var numTextLogicY = numNumberAxisMinY - iAreaWidth;
			var oSingleLineRender = new CuttingTextRender();
			var oMultiLineRender = null;
			if(bMultiLine)
			{
				oMultiLineRender = new MultiLineTextRender();
				oMultiLineRender.setHorizontalAlign("right");
				oMultiLineRender.setVerticalAlign("middle");
			}
			drawLeftAxisTextAlgorithm(oCtx, iFontSize, arrCategory, funXConfirmer,
				function(sLabel, numColumnCenterX, numTextWidth)
				{
					var numTextLogicX = numColumnCenterX;
					if(bMultiLine && (numTextWidth > iUsableTextWidth))
					{
						numTextLogicX = numTextLogicX - numUsableTextHeight * 0.5;
						oMultiLineRender.drawTextLines(oGraphics, numTextLogicX, numTextLogicY, sLabel, iUsableTextWidth, numUsableTextHeight, iLineHeight);
					}
					else
					{
						oSingleLineRender.drawAlignRightWithLogicCoord(oGraphics, numTextLogicX, numTextLogicY, sLabel, iUsableTextWidth);
					}
				});
		}
		
		var drawLeftAxisTextAlgorithm = function(oCtx, iFontSize, arrCategory, funXConfirmer, funDrawEach)
		{
			Util.setupFont(oCtx, iFontSize);
			var iNarrowestWide = parseInt(iFontSize * 1.2);
			var numLastX = -32768;
			for(var i = 0; i < arrCategory.length; i++)
			{
				var oCategory = arrCategory[i];
				var sLabel = oCategory.getLabel();
				if(!sLabel)//没有类别字段
				{
					continue;
				}
				var numColumnCenterX = funXConfirmer(i);
				if(numColumnCenterX - numLastX < iNarrowestWide)
				{
					continue;//挨太近跳掉不画
				}
				numLastX = numColumnCenterX;
				
				var numTextWidth = oCtx.measureText(sLabel).width;
				funDrawEach(sLabel, numColumnCenterX, numTextWidth);
			}
		}
	})();
	
	var ReflinePainter = new (function()
	{
		var LINE_COLOR = "rgba(80,80,80,0.5)";
		var LINE_COLOR_HOVER = "rgba(80,80,80,1)";
		var TIPS_COLOR = "rgba(80,80,80,0.5)";
		var TIPS_FONTSIZE = 12;
		
		function DrawingRefline(iLineValue, sTipsTitle, sTipsText)
		{
			this.getTipsTitle = function()
			{
				return sTipsTitle;
			}
			
			this.getTipsText = function()
			{
				return sTipsText;
			}
			
			this.isNearEnough = function(iValue)
			{
				return (iValue < iLineValue + 4 && iValue > iLineValue - 4);
			}
		}
		
		/** Y数轴上的横向参考线 */
		this.drawHorizontalLines = function(arrPaintableLine, iHoverIdx, 
				oScopeAdapter, oStyleTool, oGraphics, numCrossAxisMinPixel, numCrossAxisMaxPixel, numPixelPerValue, numNumberAxisMaxY, bRightAxis)
		{
			if(arrPaintableLine)
			{
				return drawReflines(arrPaintableLine, iHoverIdx, 
					oScopeAdapter, oStyleTool, oGraphics, numPixelPerValue,
					function(oGraphics, iReflineValue)
					{
						oGraphics.moveTo(numCrossAxisMinPixel, iReflineValue);
						oGraphics.lineTo(numCrossAxisMaxPixel, iReflineValue);
					},
					function(oGraphics, sText, iTextWidth, iTextHeight, iReflineValue)
					{
						var bTextUnderLine = (iReflineValue > numNumberAxisMaxY - iTextHeight * 1.5);//线太靠上，让字在线下
						var iX1 = (bRightAxis ? numCrossAxisMaxPixel - iTextWidth - 1 : numCrossAxisMinPixel + 2);
						var iBaseY = (bTextUnderLine ? iReflineValue - iTextHeight * 1.25 - 1 : iReflineValue + 1) + 1;
						Util.drawShadowText(oStyleTool, oGraphics, sText, iX1, iBaseY);
					});
			}
			return null;
		}
		
		/** 座标转换后横着的Y数轴（看起来是X轴）上的纵向参考线 */
		this.drawVerticalLinesAtTransY = function(arrPaintableLine, iHoverIdx, 
				oScopeAdapter, oStyleTool, oGraphics, numCrossAxisMinPixel, numCrossAxisMaxPixel, numPixelPerValue, numNumberAxisMaxPixel)
		{
			if(arrPaintableLine)
			{
				return drawReflines(arrPaintableLine, iHoverIdx, 
					oScopeAdapter, oStyleTool, oGraphics, numPixelPerValue,
					function(oGraphics, iReflineValue)
					{
						oGraphics.moveTo(numCrossAxisMinPixel, iReflineValue);
						oGraphics.lineTo(numCrossAxisMaxPixel, iReflineValue);
					},
					function(oGraphics, sText, iTextWidth, iTextHeight, iReflineValue)
					{
						var bTextBeforeLine = (iReflineValue > numNumberAxisMaxPixel - iTextWidth) && (iReflineValue - iTextWidth > 0);
						var iTextY = (bTextBeforeLine ? iReflineValue - iTextWidth - 1 : iReflineValue + 1);
						Util.drawShadowText(oStyleTool, oGraphics, sText, numCrossAxisMaxPixel, iTextY);
					});
			}
			return null;
		}
		
		/** X数轴上的纵向参考线 */
		this.drawVerticalLines = function(arrPaintableLine, iHoverIdx, 
				oScopeAdapter, oStyleTool, oGraphics, numCrossAxisMinPixel, numCrossAxisMaxPixel, 
				numPixelPerValue, numNumberAxisMinPixel, numNumberAxisMaxPixel)
		{
			if(arrPaintableLine)
			{
				return drawReflines(arrPaintableLine, iHoverIdx, 
					oScopeAdapter, oStyleTool, oGraphics, numPixelPerValue,
					function(oGraphics, iReflineValue)
					{
						oGraphics.moveTo(iReflineValue, numCrossAxisMinPixel);
						oGraphics.lineTo(iReflineValue, numCrossAxisMaxPixel);
					},
					function(oGraphics, sText, iTextWidth, iTextHeight, iReflineValue)
					{
						oGraphics.getContext().textBaseline = "bottom";
						var bTextBeforeLine = 
								(iReflineValue > numNumberAxisMaxPixel - iTextWidth) 
								&& (iReflineValue - iTextWidth > numNumberAxisMinPixel);
						var iBaseX = (bTextBeforeLine ? iReflineValue - iTextWidth - 1 : iReflineValue + 1);
						Util.drawShadowText(oStyleTool, oGraphics, sText, iBaseX, numCrossAxisMinPixel);
					});
			}
			return null;
		}
		
		var drawReflines = function(arrPaintableLine, iHoverIdx, 
				oScopeAdapter, oStyleTool, oGraphics, numPixelPerValue, funDrawLine, funDrawText)
		{
			var arrDrawingRefline = [];
			var oCtx = oGraphics.getContext();
			oCtx.strokeStyle = Util.getCustomStyle(oStyleTool, StyleTool.REFLINE_COLOR, LINE_COLOR);
			var arrHover;
			for(var i = 0; i < arrPaintableLine.length; i++)
			{
				var oPaintableLine = arrPaintableLine[i];
				if(oPaintableLine)
				{
					var numValue = oPaintableLine.getLineValue();
					numValue = oScopeAdapter.scale(numValue);
					numValue = oScopeAdapter.cutFoot(numValue);
					var iValue = parseInt(numValue * numPixelPerValue);
					
					var sLabel = oPaintableLine.getLabel();
					var sTipsTitle = oPaintableLine.getTipsTitle();
					var sTipsText = oPaintableLine.getTipsText();
					
					var oDrawingRefline = new DrawingRefline(iValue, sTipsTitle, sTipsText);
					arrDrawingRefline.push(oDrawingRefline);
					
					if(i == iHoverIdx)
					{
						arrHover = [iValue, sLabel];
					}
					else
					{
						drawRefline(oGraphics, oStyleTool, iValue, funDrawLine, sLabel, funDrawText);
					}
				}
			}
			if(arrHover)
			{
				setTimeout(
					function()
					{
						var iValue = arrHover[0];
						var sLabel = arrHover[1];
						oCtx.strokeStyle = Util.getCustomStyle(oStyleTool, StyleTool.REFLINE_COLOR_HOVER, LINE_COLOR_HOVER);
						drawRefline(oGraphics, oStyleTool, iValue, funDrawLine, sLabel, funDrawText, true);
					}, 
					0);//盖在上面
			}
			return arrDrawingRefline;
		}
		
		var drawRefline = function(oGraphics, oStyleTool, iValue, funDrawLine, sText, funDrawText, bHover)
		{
			oGraphics.beginPath();
			funDrawLine(oGraphics, iValue);
			oGraphics.stroke();
			if(sText)
			{
				var oCtx = oGraphics.getContext();
				applyStyleForText(oCtx, oStyleTool, bHover);
				var iTextWidth = oCtx.measureText(sText).width;
				var iTextHeight = oCtx.measureText("字").width;
				funDrawText(oGraphics, sText, iTextWidth, iTextHeight, iValue);
			}
		}
		
		var applyStyleForText = function(oCtx, oStyleTool, bHover)
		{
			if(bHover)
			{
				oCtx.fillStyle = Util.getCustomStyle(oStyleTool, StyleTool.REFLINE_COLOR_HOVER, LINE_COLOR_HOVER);
			}
			else
			{
				oCtx.fillStyle = Util.getCustomStyle(oStyleTool, StyleTool.REFLINE_TIPS_COLOR, TIPS_COLOR);
			}
			oCtx.textBaseline = "bottom";
			Util.setupFont(oCtx, Util.getCustomStyle(oStyleTool, StyleTool.REFLINE_TIPS_FONTSIZE, TIPS_FONTSIZE));
		}
		
		var drawGuidelines = function(arrGuideline, oStyleTool, oGraphics, numNumberAxisMinY, numNumberAxisMaxY, funCategoryAxisCoordConfirmer, funDrawLabel)
		{
			var oCtx = oGraphics.getContext();
			oCtx.strokeStyle = Util.getCustomStyle(oStyleTool, StyleTool.REFLINE_COLOR, LINE_COLOR);
			for(var i = 0; i < arrGuideline.length; i++)
			{
				var oGuideline = arrGuideline[i];
				var iCategoryIdx = oGuideline.getCategoryIndex();
				var numLineValue = funCategoryAxisCoordConfirmer(iCategoryIdx);
				oGraphics.drawDashedLine(numLineValue, numNumberAxisMaxY + 6, numLineValue, numNumberAxisMinY - 12, 6);
				var sText = oGuideline.getLabel();
				if(sText)
				{
					applyStyleForText(oCtx, oStyleTool);
					var numTextWidth = oCtx.measureText(sText).width;
					var numTextHeight = oCtx.measureText("字").width * 1.2;
					funDrawLabel(oGraphics, sText, numTextWidth, numTextHeight, numLineValue);
				}
			}
		}
		
		this.drawHGuidelines = function(arrGuideline, oStyleTool, oGraphics, numNumberAxisMinY, numNumberAxisMaxY, funCategoryAxisCoordConfirmer)
		{
			if(arrGuideline)
			{
				drawGuidelines(arrGuideline, oStyleTool, oGraphics, numNumberAxisMinY, numNumberAxisMaxY, funCategoryAxisCoordConfirmer,
					function(oGraphics, sText, numTextWidth, numTextHeight, numLineValue)
					{
						var bTextUnderLine = (numLineValue < numTextHeight);
						var numX = (bTextUnderLine ? numLineValue + numTextHeight + 1 : numLineValue - 1);
						var numY = numNumberAxisMaxY - numTextWidth - 1;
						Util.drawShadowText(oStyleTool, oGraphics, sText, numX, numY);
					});
			}
		}
		
		this.drawVGuidelines = function(arrGuideline, oStyleTool, oGraphics, numNumberAxisMinY, numNumberAxisMaxY, funCategoryAxisCoordConfirmer)
		{
			if(arrGuideline)
			{
				drawGuidelines(arrGuideline, oStyleTool, oGraphics, numNumberAxisMinY, numNumberAxisMaxY, funCategoryAxisCoordConfirmer, 
					function(oGraphics, sText, numTextWidth, numTextHeight, numLineValue)
					{
						var numCategoryAxisMaxCoord = funCategoryAxisCoordConfirmer(65535);
						var bTextBeforeLine = (numLineValue > numCategoryAxisMaxCoord - numTextWidth) && (numLineValue - numTextWidth > 0);
						var numX = (bTextBeforeLine ? numLineValue - numTextWidth - 1: numLineValue + 1);
						var numY = numNumberAxisMaxY - numTextHeight - 1;
						Util.drawShadowText(oStyleTool, oGraphics, sText, numX, numY);
					});
			}
		}
	})();
	
	
	/** 大小图例 */
	function SizeLegendRender()
	{
		var ROW_HEIGHT = 20;
		var MAX_ROW_HEIGHT = 18;
		var PADDING_LEFT = 4;
		var PADDING_TOP = 1;
		var FONT_SIZE = 12;
		var GAP_RECT2SIGN = 6;
		var GAP_SIGN2NUM = 2;
		
		var RECT_COLOR = "#ccc";
		var TEXT_COLOR = "#666";
		
		this.draw = function(oCtx, iBaseDiameter, iContainerWidth, arrRatio, arrText)
		{
			var iRows = arrRatio.length;
			var iX = PADDING_LEFT;
			var iY = PADDING_TOP;
			var iMaxTextWidth = 0;
			
			oCtx.fillStyle = RECT_COLOR;
			oCtx.textBaseline = "middle";
			Util.setupFont(oCtx, FONT_SIZE);
			for(var i = 0; i < iRows; i++)
			{
				var fRatio = parseFloat(arrRatio[i]);
				var iRectWidth = iBaseDiameter * fRatio;
				var iRectHeight = Math.min(MAX_ROW_HEIGHT, iRectWidth);
				oCtx.fillRect(iX + iBaseDiameter - iRectWidth, iY + ((ROW_HEIGHT - iRectHeight) >> 1), iRectWidth, iRectHeight);
				iY += ROW_HEIGHT;
				
				var sText = arrText[i];
				var oMetrics = oCtx.measureText(sText);
				iMaxTextWidth = Math.max(iMaxTextWidth, oMetrics.width);
			}
			
			var iY = PADDING_TOP + (ROW_HEIGHT >> 1);
			var iSignTextAllWidth = FONT_SIZE + GAP_SIGN2NUM + iMaxTextWidth;
			var iXStart = iX + iBaseDiameter + GAP_RECT2SIGN;
			var iXEnd = iXStart + iSignTextAllWidth;
			
			var iOutside = iXEnd - iContainerWidth;
			if(iOutside > 0)
			{
//				if(iOutside > iMaxTextWidth / 2)
//				{
//					//超长太多了干脆把文字放前头
//					iXStart = iX;
//					iXEnd = iXStart + iSignTextAllWidth;
//				}
//				else
				{
					//超出不多，文字向前挤，文字和矩形重叠
					iXEnd = iContainerWidth - 2;
					iXStart = iXEnd - iMaxTextWidth - FONT_SIZE - GAP_SIGN2NUM;
				}
			}
			oCtx.fillStyle = TEXT_COLOR;
			for(var i = 0; i < iRows; i++)
			{
				var sText = arrText[i];
				var oMetrics = oCtx.measureText(sText);
				var iX = iXEnd - oMetrics.width;
				oCtx.fillText("≥", iXStart, iY);
				oCtx.fillText(sText, iX, iY);
				iY += ROW_HEIGHT;
			}
		}
	}
	
	/** 连续值颜色图例 */
	function ContinuousColorLegendRender()
	{
		var PADDING = 4;
		var COLOR_BAR_HEIGHT = 18;
		var GAP = 4;
		var FONT_SIZE = 12;
		
		var RECT_BORDER_COLOR = "#333";
		var TEXT_COLOR = "#666";
		
		var EMBEDDED_VBAR_WIDTH = 10;
		var EMBEDDED_VBAR_HEIGHT = 60;
		var EMBEDDED_HBAR_WIDTH = 100;
		var EMBEDDED_HBAR_HEIGHT = 8;
		
		var _iUsableWidth = 65535;
		var _iUsableHeight = 65535;
		var _sPosition = AbstractAttr.ShowLegend_Bottom;
		var _oStyleTool;
		
		this.setUsableSize = function(iWidth, iHeight)
		{
			iWidth && (_iUsableWidth = iWidth);
			iHeight && (_iUsableHeight = iHeight);
		}
		
		this.setPosition = function(sPosition)
		{
			_sPosition = sPosition;
		}
		
		this.setStyleTool = function(oStyleTool)
		{
			_oStyleTool = oStyleTool;
		}
		
		this.draw = function(oCtx, iContainerWidth, oModel)
		{
			var iBorderWidth = 1;
			var iW = iContainerWidth - (iBorderWidth + PADDING) * 2;
			var iH = COLOR_BAR_HEIGHT;
			var iX = PADDING;			
			var iY = PADDING;
			
			oCtx.lineWidth = iBorderWidth;
			oCtx.strokeStyle = RECT_BORDER_COLOR;
			oCtx.strokeRect(iX, iY, iW, iH);
			
			commonDraw(oCtx, oModel,
				function(oCtx)
				{
					var oGradientUi = oCtx.createLinearGradient(iX, 0, iX + iW, 0);
					var arrRect = [iX, iY, iW, iH];
					return [oGradientUi, arrRect];
				},
				function(oCtx, iSegmentIdx, iSegmentCount)
				{
					var numSegmentWidth = iW / iSegmentCount;
					var numSegmentX = iX + numSegmentWidth * iSegmentIdx;
					var iSegmentWidth = Math.ceil(numSegmentWidth);
					oCtx.fillRect(numSegmentX, iY, iSegmentWidth, iH);
				});
			
			iY += iH + GAP;
			oCtx.textBaseline = "top";
			oCtx.fillStyle = getTextColor();
			Util.setupFont(oCtx, FONT_SIZE);
			oCtx.fillText(oModel.getMinText(), iX, iY);
			
			var sMaxText = oModel.getMaxText();
			var oMetrics = oCtx.measureText(sMaxText);
			iX = iX + iW - oMetrics.width;
			oCtx.fillText(sMaxText, iX, iY);
		}
		
		this.drawEmbedded = function(oCtx, oContinuousColorLegendModel)
		{
			if(_sPosition == AbstractAttr.ShowLegend_Right)
			{
				drawVertical(oCtx, oContinuousColorLegendModel);
			}
			else if(_sPosition == AbstractAttr.ShowLegend_Bottom)
			{
				drawHorizontal(oCtx, oContinuousColorLegendModel);
			}
		}
		
		var commonDraw = function(oCtx, oModel, funGradientUiCreator, funSegmentRender)
		{
			if(oModel.isGradientColor())
			{
				var oGradientModel = oModel.getGradientColor();
				var arrUiCtx = funGradientUiCreator(oCtx);
				var oGradientUi = arrUiCtx[0];
				var arrRect = arrUiCtx[1]; 
				if(oGradientModel.isDiverging())
				{
					var numPos = oGradientModel.getPos();
					oGradientUi.addColorStop(0, oGradientModel.getColor1());
					oGradientUi.addColorStop(Math.max(0, numPos - 0.05), oGradientModel.getColor2());
					oGradientUi.addColorStop(Math.min(1, numPos + 0.05), oGradientModel.getColor3());
					oGradientUi.addColorStop(1, oGradientModel.getColor4());
				}
				else
				{
					oGradientUi.addColorStop(0, oGradientModel.getColor1());
					oGradientUi.addColorStop(1, oGradientModel.getColor2());
				}
				oCtx.fillStyle = oGradientUi;
				oCtx.fillRect(arrRect[0], arrRect[1], arrRect[2], arrRect[3]);
			}
			else
			{
				var iSegments = oModel.getSegmentCount();
				for(var i = 0; i < iSegments; i++)
				{
					var sColor = oModel.getSegmentColor(i);
					oCtx.fillStyle = sColor;
					funSegmentRender(oCtx, i, iSegments);
				}
			}
		}
		
		var drawVertical = function(oCtx, oModel)
		{
			var iW = EMBEDDED_VBAR_WIDTH;
			var iH = EMBEDDED_VBAR_HEIGHT;
			var iX = _iUsableWidth - iW;
			var iY = _iUsableHeight - iH;
			commonDraw(oCtx, oModel,
				function(oCtx)
				{
					var oGradientUi = oCtx.createLinearGradient(0, iY + iH, 0, iY);
					var arrRect = [iX, iY, iW, iH];
					return [oGradientUi, arrRect];
				},
				function(oCtx, iSegmentIdx, iSegmentCount)
				{
					var numSegmentHeight = iH / iSegmentCount;
					var numSegmentY = iY + numSegmentHeight * (iSegmentCount - 1 - iSegmentIdx);
					var iSegmentHeight = Math.ceil(numSegmentHeight);
					oCtx.fillRect(iX, numSegmentY, iW, iSegmentHeight);
				});
			
			oCtx.fillStyle = getTextColor();
			Util.setupFont(oCtx, FONT_SIZE);
			var funDrawText = function(sText, iTextY)
			{
				var numTextWidth = oCtx.measureText(sText).width;
				var iTextX = Math.max(0, iX - numTextWidth - 2);
				oCtx.fillText(sText, iTextX, iTextY);
			};
			oCtx.textBaseline = "top";
			funDrawText(oModel.getMaxText(), iY);
			oCtx.textBaseline = "bottom";
			funDrawText(oModel.getMinText(), iY + iH);
		}
		
		var drawHorizontal = function(oCtx, oModel)
		{
			var iW = EMBEDDED_HBAR_WIDTH;
			var iH = EMBEDDED_HBAR_HEIGHT;
			var iX = 0;
			var iY = _iUsableHeight - iH;
			commonDraw(oCtx, oModel,
				function(oCtx)
				{
					var oGradientUi = oCtx.createLinearGradient(iX, 0, iX + iW, 0);
					var arrRect = [iX, iY, iW, iH];
					return [oGradientUi, arrRect];
				},
				function(oCtx, iSegmentIdx, iSegmentCount)
				{
					var numSegmentWidth = iW / iSegmentCount;
					var numSegmentX = iX + numSegmentWidth * iSegmentIdx;
					var iSegmentWidth = Math.ceil(numSegmentWidth);
					oCtx.fillRect(numSegmentX, iY, iSegmentWidth, iH);
				});
			
			oCtx.fillStyle = getTextColor();
			Util.setupFont(oCtx, FONT_SIZE);
			var funDrawText = function(sText, iTextX)
			{
				var iTextY = iY;
				oCtx.fillText(sText, iTextX, iTextY);
			};
			oCtx.textBaseline = "bottom";
			funDrawText(oModel.getMinText(), iX);
			var numTextWidth = oCtx.measureText(oModel.getMaxText()).width;
			funDrawText(oModel.getMaxText(), iX + iW - numTextWidth);
		}
		
		this.askSize = function(oModel)
		{
			var iWidth = 0;
			var iHeight = 0;
			if(_sPosition == AbstractAttr.ShowLegend_Right)
			{
				var oCtx = document.createElement("canvas").getContext("2d");
				Util.setupFont(oCtx, FONT_SIZE);
				var numW1 = oCtx.measureText(oModel.getMinText()).width;
				var numW2 = oCtx.measureText(oModel.getMaxText()).width;
				iWidth = parseInt(Math.max(numW1, numW2)) + 4 + EMBEDDED_VBAR_WIDTH;
				iHeight = EMBEDDED_VBAR_HEIGHT + 4;
			}
			else if(_sPosition == AbstractAttr.ShowLegend_Bottom)
			{
				iWidth = EMBEDDED_HBAR_WIDTH;
				iHeight = 4 + FONT_SIZE + EMBEDDED_HBAR_HEIGHT;
			}
			return [iWidth, iHeight];
		}
		
		this.askMinSize = function()
		{
			if(_sPosition == AbstractAttr.ShowLegend_Right)
			{
				return [EMBEDDED_VBAR_WIDTH, EMBEDDED_VBAR_HEIGHT];
			}
			else if(_sPosition == AbstractAttr.ShowLegend_Bottom)
			{
				return [EMBEDDED_HBAR_WIDTH, EMBEDDED_HBAR_HEIGHT];
			}
			return [0, 0];
		}
		
		var getTextColor = function()
		{
			return Util.getCustomStyle(_oStyleTool, StyleTool.LEGEND_COLOR, TEXT_COLOR);
		}
	}
	
	/** 和图表的DrawingModel对等的，图例的也用于支持鼠标操作 */
	function DiscreteColorLegendDrawingModel()
	{
		var _arrRect = [];
		var _oAndSoOnRect = null;
		
		this.clearRects = function()
		{
			_arrRect = [];
			_oAndSoOnRect = null;
		}
		
		this.setRect = function(iIdx, iX, iY, iW, iH)
		{
			_arrRect[iIdx] = new Rect(iX, iY, iW, iH);
		}
		this.getRect = function(iIdx)
		{
			return _arrRect[iIdx];
		}
		
		this.setAndSoOnRect = function(iX, iY, iW, iH)
		{
			_oAndSoOnRect = new Rect(iX, iY, iW, iH);
		}
		this.getAndSoOnRect = function()
		{
			return _oAndSoOnRect;
		}
		
		this.getMaxY = function()
		{
			var oRect = (_oAndSoOnRect ? _oAndSoOnRect : _arrRect[_arrRect.length - 1]);
			return (oRect ? oRect.getY() + oRect.getHeight() : 0);
		}
		
		function Rect(iX, iY, iW, iH)
		{
			this.getX = function(){return iX;}
			this.getY = function(){return iY;}
			this.getWidth = function(){return iW;}
			this.getHeight = function(){return iH;}
		}
	}
	
	/** 离散值颜色图例 */
	function DiscreteColorLegendRender()
	{
		var _this = this;
		var ROW_HEIGHT = 20;
		var RECT_LEN = 10;
		var GAP = 6;
		var PADDING_LEFT = 4;
		var PADDING_TOP = 0;
		var FONT_SIZE = 12;
		var TEXT_COLOR = "#666";
		
		var _iUsableWidth = 65535;
		var _iUsableHeight = 65535;
		var _sPosition = AbstractAttr.ShowLegend_Right;
		var _oStyleTool;
		
		this.setUsableSize = function(iWidth, iHeight)
		{
			iWidth && (_iUsableWidth = iWidth);
			iHeight && (_iUsableHeight = iHeight);
		}
		
		this.setPosition = function(sPosition)
		{
			_sPosition = sPosition;
		}
		this.getPosition = function()
		{
			return _sPosition;
		}
		
		this.setStyleTool = function(oStyleTool)
		{
			_oStyleTool = oStyleTool;
		}
		
		this.draw = function(oCtx, oDiscreteColorLegendModel)
		{
			if(_sPosition == AbstractAttr.ShowLegend_Right)
			{
				drawVertical(oCtx, oDiscreteColorLegendModel, drawEach);
			}
			else if(_sPosition == AbstractAttr.ShowLegend_Bottom)
			{
				drawHorizontal(oCtx, oDiscreteColorLegendModel, drawEach,
					function(oDrawingModel)
					{
						drawBreakLine(oCtx, oDiscreteColorLegendModel, oDrawingModel, drawEach);
					});
			}
		}
		var drawEach = function(oDiscreteColorLegendModel, iIdx, iXRect, iXText, iTextMaxWidth, iYTop, oCtx, sText, sColor)
		{
			var iRectOffsetY = (ROW_HEIGHT - RECT_LEN) * 0.4;//文字的middle对齐不是绝对的正中，色块偏上一点视觉上更对齐些
			var iHalfRowHeight = ROW_HEIGHT * 0.5;
			var iYRect = iYTop + iRectOffsetY;
			_this.protectedDrawLegendIcon(sColor, oCtx, iXRect, iYRect, RECT_LEN, RECT_LEN, oDiscreteColorLegendModel, iIdx);
			var iYText = iYTop + iHalfRowHeight;
			oCtx.fillStyle = getTextColor();
			_this.protectedDrawLegendText(oCtx, iXText, iYText, sText, iTextMaxWidth, oDiscreteColorLegendModel, iIdx);
		}
		this.protectedDrawLegendIcon = function(sColor, oCtx, iX, iY, iWidth, iHeight, oLegendModel, iIdx)
		{
			oCtx.fillStyle = sColor;
			oCtx.fillRect(iX, iY, iWidth, iHeight);
		}
		this.protectedDrawLegendText = function(oCtx, iXText, iYText, sText, iNoMoreThanWidth, oDiscreteColorLegendModel, iIdx)
		{
			var oTextRender = new CuttingTextRender();
			oTextRender.drawAlignLeft(oCtx, iXText, iYText, sText, iNoMoreThanWidth);
		}
		
		this.askSize = function(oDiscreteColorLegendModel)
		{
			var iSuggestedWidth = null;
			var iSuggestedHeight = null;
			if(_sPosition == AbstractAttr.ShowLegend_Right)
			{
				var oCtx = document.createElement("canvas").getContext("2d");
				var iMaxRight = 0;
				drawVertical(oCtx, oDiscreteColorLegendModel, 
					function(oDiscreteColorLegendModel, iIdx, iXRect, iXText, iTextMaxWidth, iYTop, oCtx, sText, sColor)
					{
						var iTextWidth = oCtx.measureText(sText).width;
						iMaxRight = Math.max(iMaxRight, iXText + iTextWidth);
					});
				iSuggestedWidth = iMaxRight;
			}
			else if(_sPosition == AbstractAttr.ShowLegend_Bottom)
			{
				iSuggestedHeight = 0;
				var oCtx = document.createElement("canvas").getContext("2d");
				drawHorizontal(oCtx, oDiscreteColorLegendModel, 
					function(oDiscreteColorLegendModel, iIdx, iXRect, iXText, iTextMaxWidth, iYTop, oCtx, sText, sColor)
					{
						iSuggestedHeight = iYTop + ROW_HEIGHT;//最后一个一定最大
					},
					function(oDrawingModel)
					{
						iSuggestedHeight = oDrawingModel.getMaxY();
					});
				iSuggestedHeight += getFontSize() * 0.5;
			}
			return [iSuggestedWidth, iSuggestedHeight];
		}
		
		var getDrawingItemCount = function(oDiscreteColorLegendModel)
		{
			var iItemCount = oDiscreteColorLegendModel.getItemCount();
			var iOthersItemCount = oDiscreteColorLegendModel.getOthersItemCount();
			var iDrawingItemCount = (iOthersItemCount > 0 ? iItemCount + 1 : iItemCount);
			return iDrawingItemCount;
		}
		
		var getAndSoOnText = function(oDiscreteColorLegendModel, iCurrentIdx)
		{
			var iItemCount = oDiscreteColorLegendModel.getItemCount();
			var iOthersItemCount = oDiscreteColorLegendModel.getOthersItemCount();
			var sText = oDiscreteColorLegendModel.getAdditionalText();
			(iCurrentIdx < iItemCount) && (iOthersItemCount = iItemCount + iOthersItemCount - iCurrentIdx);
			sText = sText.replace("#1", iOthersItemCount);
			return sText;
		}
		
		var drawVertical = function(oCtx, oDiscreteColorLegendModel, funDrawEachImpl)
		{
			Util.setupFont(oCtx, getFontSize());
			var iXRect = PADDING_LEFT;
			var iXText = iXRect + RECT_LEN + GAP;
			var iYTop = PADDING_TOP;
			var iItemCount = oDiscreteColorLegendModel.getItemCount();
			var iDrawingItemCount = getDrawingItemCount(oDiscreteColorLegendModel);
			var bAndSoOnAlwaysNeeded = (iItemCount < iDrawingItemCount);
			for(var i = 0; i < iDrawingItemCount; i++)
			{
				var iItemBottom = iYTop + ROW_HEIGHT;
				if(iItemBottom > _iUsableHeight)
				{
					break;
				}
				var sText, sColor;
				if(i >= iItemCount || ((bAndSoOnAlwaysNeeded || i < iItemCount - 1) && iItemBottom + ROW_HEIGHT > _iUsableHeight))
				{
					sText = getAndSoOnText(oDiscreteColorLegendModel, i);
					sColor = "rgba(0,0,0,0)";
					iXText -= (RECT_LEN + GAP);
				}
				else
				{
					sText = _this.protectedGetItemText(oDiscreteColorLegendModel, i);
					sColor = oDiscreteColorLegendModel.getColor(i);
				}
				var iTextMaxWidth = _iUsableWidth - iXText;
				funDrawEachImpl(oDiscreteColorLegendModel, i, iXRect, iXText, iTextMaxWidth, iYTop, oCtx, sText, sColor);
				iYTop = iItemBottom;
			}
		}
		
		var drawHorizontal = function(oCtx, oDiscreteColorLegendModel, funDrawEachImpl, funDrawBreakLine)
		{
			Util.setupFont(oCtx, getFontSize());
			var arrComfortableTextWidth = [];
			var iItemCount = oDiscreteColorLegendModel.getItemCount();
			for(var i = 0; i < iItemCount; i++)
			{
				var sText = _this.protectedGetItemText(oDiscreteColorLegendModel, i);
				!sText && (sText = "　");
				var numTextWidth = oCtx.measureText(sText).width;
				arrComfortableTextWidth[i] = numTextWidth;
			}
			
			var iLongTextCount = 0;
			for(var i = 0; i < arrComfortableTextWidth.length; i++)
			{
				var numTextWidth = arrComfortableTextWidth[i];
				iLongTextCount += (numTextWidth > _iUsableWidth * 0.5 ? 1 : 0);
			}
			//60%条目的宽度超过可用宽度的一半，优先用单列式
			var iItemCount = oDiscreteColorLegendModel.getItemCount();
			if(iLongTextCount / iItemCount > 0.6 && getDrawingItemCount(oDiscreteColorLegendModel) * ROW_HEIGHT <= _iUsableHeight)
			{
				drawVertical(oCtx, oDiscreteColorLegendModel, funDrawEachImpl);
			}
			else
			{
				var oDrawingModel = new DiscreteColorLegendDrawingModel();
				if(horizontalBreakLine(oCtx, oDiscreteColorLegendModel, arrComfortableTextWidth, oDrawingModel))
				{
					funDrawBreakLine(oDrawingModel);
				}
				else
				{
					drawVertical(oCtx, oDiscreteColorLegendModel, funDrawEachImpl);
				}
			}
		}
		
		var horizontalBreakLine = function(oCtx, oDiscreteColorLegendModel, arrComfortableTextWidth, oDrawingModel)
		{
			var iMaxLines = Math.max(1, parseInt(_iUsableHeight / ROW_HEIGHT));
			var iFontSize = getFontSize();
			var iItemGap = iFontSize * 1.5;
			var iColumnCount = 2;
			while(iColumnCount < 20)
			{
				var numAvgColumnTextWidth = (_iUsableWidth + iItemGap) / iColumnCount - RECT_LEN - GAP - iItemGap;
				if(numAvgColumnTextWidth < iFontSize)
				{
					break;
				}
				iColumnCount++;
				oDrawingModel.clearRects();
				var numItemX = 0;
				var iLineIdx = 0;
				var iCurrentLineItemIdx = 0;
				var arrEatted = [];
				var arrHungry = [];
				var bAndSoOn = false;
				for(var iIdx = 0, iDrawingItemCount = getDrawingItemCount(oDiscreteColorLegendModel); iIdx < iDrawingItemCount; iIdx++)
				{
					var numComfortableWidth, numOccupiedWidth;
					if(iIdx >= oDiscreteColorLegendModel.getItemCount())
					{
						var sAndSoOn = getAndSoOnText(oDiscreteColorLegendModel, iIdx);
						var numAndSoOnWidth = oCtx.measureText(sAndSoOn).width;
						numComfortableWidth = numAndSoOnWidth;
						numOccupiedWidth = numAndSoOnWidth;
						bAndSoOn = true;
					}
					else
					{
						numComfortableWidth = arrComfortableTextWidth[iIdx];
						numOccupiedWidth = (numComfortableWidth > numAvgColumnTextWidth ? numAvgColumnTextWidth : numComfortableWidth);
					}
					var numItemWidth = RECT_LEN + GAP + numOccupiedWidth;
					var numItemRight = (numItemX > 0 ? numItemX + iItemGap : 0) + numItemWidth;
					if(numItemRight > _iUsableWidth)
					{
						if(iLineIdx + 1 >= iMaxLines)
						{
							var sAndSoOn = getAndSoOnText(oDiscreteColorLegendModel, iIdx);//iIdx只大不小，占空间只多不少
							var numAndSoOnWidth = oCtx.measureText(sAndSoOn).width;
							suddenlyAppendAndSoOn(arrEatted, arrHungry, numAndSoOnWidth, numItemX, iItemGap);
							bAndSoOn = true;
							break;
						}
						feedRemainder(arrEatted, arrHungry, _iUsableWidth - numItemX);
						acceptCurrentLine(oDrawingModel, iIdx - iCurrentLineItemIdx, arrEatted, false, 0, iLineIdx * ROW_HEIGHT, iItemGap, false);
						iLineIdx++;
						iCurrentLineItemIdx = 0;
						numItemX = numItemWidth;
						arrEatted = [];
						arrHungry = [];
					}
					else
					{
						numItemX = numItemRight;
					}
					arrEatted[iCurrentLineItemIdx] = numOccupiedWidth;
					arrHungry[iCurrentLineItemIdx] = numComfortableWidth - numOccupiedWidth;
					iCurrentLineItemIdx++
				}
				if(iLineIdx < iMaxLines)
				{
					if(iMaxLines * 0.5 <= iLineIdx && iLineIdx < iMaxLines - 1)
					{
						//仅当以下情形时发生：
						//askSize时已建议单列，但高度刚好超过上限一点被取了上限。回来绘制时高度不够单列，只能进横向折行算法，每行两列起步，会剩余大片空白。
						//此时放弃，重新用回单列。
						return false;
					}
					feedRemainder(arrEatted, arrHungry, _iUsableWidth - numItemX);
					var bAlignToRight = (iLineIdx == 0);
					acceptCurrentLine(oDrawingModel, iIdx - iCurrentLineItemIdx, arrEatted, bAndSoOn, 0, iLineIdx * ROW_HEIGHT, iItemGap, bAlignToRight);
					break;
				}
			}
			return true;
		}
		
		var suddenlyAppendAndSoOn = function(arrEatted, arrHungry, numAndSoOnWidth, numLastItemRight, iItemGap)
		{
			var numRight = numLastItemRight;
			for(var i = arrEatted.length - 1; i >= 0; i--)
			{
				if(numRight + iItemGap + numAndSoOnWidth > _iUsableWidth)
				{
					numRight -= (arrEatted[i] + RECT_LEN + GAP + iItemGap); 
					arrEatted.length = arrEatted.length - 1;
					arrHungry.length = arrHungry.length - 1;
				}
				else
				{
					break;
				}
			}
			arrEatted.push(numAndSoOnWidth);
			arrHungry.push(0);
		}
		
		var feedRemainder = function(arrEatted, arrHungry, numRemainderWidth)
		{
			if(numRemainderWidth > 0)
			{
				var numTotalHungry = 0;
				for(var i = 0; i < arrHungry.length; i++)
				{
					numTotalHungry += arrHungry[i];
				}
				if(numTotalHungry > 0)
				{
					for(var i = 0; i < arrHungry.length; i++)
					{
						if(numTotalHungry < numRemainderWidth)
						{
							arrEatted[i] += arrHungry[i];
						}
						else
						{
							arrEatted[i] += arrHungry[i] / numTotalHungry * numRemainderWidth;
						}
					}
				}
			}
		}
		
		var acceptCurrentLine = function(oDrawingModel, iIdxStart, arrEatted, bAndSoOn, numX, numYTop, iItemGap, bAlignToRight)
		{
			for(var i = 0; i < arrEatted.length; i++)
			{
				var numTextOccupied = arrEatted[i];
				var numWidth = RECT_LEN + GAP + numTextOccupied;
				var iIdx = iIdxStart + i;
				if(bAndSoOn && i == arrEatted.length - 1)
				{
					numWidth = numTextOccupied;
					oDrawingModel.setAndSoOnRect(numX, numYTop, numWidth, ROW_HEIGHT);
				}
				else
				{
					oDrawingModel.setRect(iIdx, numX, numYTop, numWidth, ROW_HEIGHT);
				}
				numX += numWidth + iItemGap;
			}
			if(bAlignToRight)
			{
				var numRemainder = _iUsableWidth - (numX - iItemGap);
				acceptCurrentLine(oDrawingModel, iIdxStart, arrEatted, bAndSoOn, numRemainder, numYTop, iItemGap, false);
			}	
		}
		
		var drawBreakLine = function(oCtx, oDiscreteColorLegendModel, oDrawingModel, funDrawEachImpl)
		{
			var iXRect = 0;
			var iXText = 0;
			var iTextMaxWidth = 0;
			var numYTop = 0;
			var numYOffset = _iUsableHeight % ROW_HEIGHT;
			var iDrawingItemCount = getDrawingItemCount(oDiscreteColorLegendModel);
			for(var i = 0; i < iDrawingItemCount; i++)
			{
				var sText, sColor;
				var bAndSoOn = false;
				var oRect = oDrawingModel.getRect(i);
				if(!oRect)
				{
					oRect = oDrawingModel.getAndSoOnRect();
					if(!oRect)
					{
						break;
					}
					sText = getAndSoOnText(oDiscreteColorLegendModel, i);
					sColor = "rgba(0,0,0,0)";
					bAndSoOn = true;
				}
				else
				{
					sText = _this.protectedGetItemText(oDiscreteColorLegendModel, i);
					sColor = oDiscreteColorLegendModel.getColor(i);
				}
				iXRect = oRect.getX();
				iXText = iXRect + (bAndSoOn ? 0 : RECT_LEN + GAP);
				iTextMaxWidth = oRect.getWidth() - (bAndSoOn ? 0 : RECT_LEN + GAP);
				numYTop = oRect.getY() + numYOffset;
				funDrawEachImpl(oDiscreteColorLegendModel, i, iXRect, iXText, iTextMaxWidth, numYTop, oCtx, sText, sColor);
				if(bAndSoOn)
				{
					break;
				}
			}
		}
		
		var getTextColor = function()
		{
			return Util.getCustomStyle(_oStyleTool, StyleTool.LEGEND_COLOR, TEXT_COLOR);
		}
		
		var getFontSize = function()
		{
			return parseInt(Util.getCustomStyle(_oStyleTool, StyleTool.LEGEND_FONTSIZE, FONT_SIZE));
		}
		
		this.protectedGetItemText = function(oDiscreteColorLegendModel, iIdx)
		{
			return oDiscreteColorLegendModel.getText(iIdx);
		}
	}
	
	function CompositeDescreteLegendRender(oChartModel)
	{
		DiscreteColorLegendRender.call(this);
		var _this = this;
		
		var _superDrawLegendIcon = _this.protectedDrawLegendIcon;
		this.protectedDrawLegendIcon = function(sColor, oCtx, iX, iY, iWidth, iHeight, oLegendModel, iIdx)
		{
			var oSeries = oChartModel.getSeries()[iIdx];
			if(oSeries && oSeries.getAxisIndex() === 0)
			{
				_superDrawLegendIcon(sColor, oCtx, iX, iY, iWidth, iHeight, oLegendModel, iIdx);
			}
			else if(oSeries && oSeries.getAxisIndex() === 1)
			{
				var iMidX = iX + iWidth * 0.5;
				var iMidY = iY + iHeight * 0.5
				var iRadius = 3;
				oCtx.lineWidth = 2;
				oCtx.fillStyle = sColor;
				oCtx.strokeStyle = sColor;
				oCtx.beginPath();
				oCtx.moveTo(iX + iWidth - 0.5, iY + 0.5);
				oCtx.lineTo(iX + 0.5, iY + iHeight - 0.5);
				oCtx.stroke();
				oCtx.moveTo(iMidX, iMidY);
				oCtx.arc(iMidX, iMidY, iRadius, 0, Math.PI * 2);
				oCtx.fill();
			}
		}
	}
	
	function ProgressDiscreteLegendRender()
	{
		DiscreteColorLegendRender.call(this);
		
		this.protectedDrawLegendIcon = function(sColor, oCtx, iX, iY, iWidth, iHeight, oLegendModel, iIdx)
		{
			if(iIdx == 0)
			{
				oCtx.beginPath();
				oCtx.moveTo(iX, iY);
				oCtx.lineTo(iX + iWidth, iY + iHeight);
				oCtx.lineTo(iX + iWidth, iY);
				oCtx.closePath();
				oCtx.fillStyle = oLegendModel.getColor(0);
				oCtx.fill();
				
				oCtx.beginPath();
				oCtx.moveTo(iX, iY);
				oCtx.lineTo(iX + iWidth, iY + iHeight);
				oCtx.lineTo(iX, iY + iHeight);
				oCtx.closePath();
				oCtx.fillStyle = oLegendModel.getColor(1);
				oCtx.fill();	
			}
			else
			{
				oCtx.fillStyle = sColor;
				oCtx.fillRect(iX, iY, iWidth, iHeight);
			}
		}
	}
	
	function ProgressCircleLegendRender()
	{
		ProgressDiscreteLegendRender.call(this);
		var _this = this;
		var _numItemUsableWidth;
		var _numIconPaddingLeft;
		var _iUsableWidth;
		
		var _superSetUsableSize = this.setUsableSize;
		this.setUsableSize = function(iWidth, iHeight)
		{
			_iUsableWidth = iWidth;
			_superSetUsableSize(iWidth, iHeight);
		}
		
		var _superAskSize = this.askSize;
		this.askSize = function(oDiscreteColorLegendModel)
		{
			isBottomSide() && _superSetUsableSize(10, null);//足够“不宽”，使底部总是算出两行
			return _superAskSize(oDiscreteColorLegendModel);
		}
		
		var _superDarw = this.draw;
		this.draw = function(oCtx, oDiscreteColorLegendModel)
		{
			if(isBottomSide())
			{
				_this.setPosition(AbstractAttr.ShowLegend_Right);
				_numItemUsableWidth = _superAskSize(oDiscreteColorLegendModel)[0];
				_numItemUsableWidth = Math.min(_iUsableWidth, _numItemUsableWidth);
				_this.setPosition(AbstractAttr.ShowLegend_Bottom);
				
				_superSetUsableSize(10, null);
			}
			_superDarw(oCtx, oDiscreteColorLegendModel);
		}
		
		this.protectedGetItemText = function(oDiscreteColorLegendModel, iIdx)
		{
			//虽然下面绘制时用不到这个sFullText，但可能需要依赖这个拼接结果算宽度。
			var sFullText = oDiscreteColorLegendModel.getCaption(iIdx) + "　" + oDiscreteColorLegendModel.getText(iIdx);
			return sFullText;
		}
		
		var _superProtectedDrawLegendIcon = this.protectedDrawLegendIcon;
		this.protectedDrawLegendIcon = function(sColor, oCtx, iX, iY, iWidth, iHeight, oLegendModel, iIdx)
		{
			if(isBottomSide())
			{
				_numIconPaddingLeft = iX;
				iX = offsetX(0, oCtx);
			}
			_superProtectedDrawLegendIcon(sColor, oCtx, iX, iY, iWidth, iHeight, oLegendModel, iIdx);
		}
		
		this.protectedDrawLegendText = function(oCtx, iXText, iYText, sText, iNoMoreThanWidth, oDiscreteColorLegendModel, iIdx)
		{
			var oTextRender = new CuttingTextRender();
			var numTextUsableWidth;
			if(isBottomSide())
			{
				numTextUsableWidth = _numItemUsableWidth - iXText + _numIconPaddingLeft;
				iXText = offsetX(iXText, oCtx) - _numIconPaddingLeft;
			}
			else
			{
				numTextUsableWidth = iNoMoreThanWidth;
			}
			drawItemText(oTextRender, oCtx, iXText, iYText, numTextUsableWidth, oDiscreteColorLegendModel, iIdx);
		}
		
		var isBottomSide = function()
		{
			return (_this.getPosition() == AbstractAttr.ShowLegend_Bottom);
		}
		
		var offsetX = function(iX, oCtx)
		{
			return iX + (_iUsableWidth - _numItemUsableWidth) * 0.5;
		}
		
		var drawItemText = function(oTextRender, oCtx, iX, iY, iUsableWidth, oDiscreteColorLegendModel, iIdx)
		{
			var sCaption = oDiscreteColorLegendModel.getCaption(iIdx);
			var sFormatedValue = oDiscreteColorLegendModel.getText(iIdx);
			var iGap = 6;
			var numWideForValue = Math.min(iUsableWidth, oCtx.measureText(sFormatedValue).width);
			var numWideForCaption = iUsableWidth - numWideForValue - iGap;
			if(numWideForCaption > 0)
			{
				oTextRender.drawAlignLeft(oCtx, iX, iY, sCaption, numWideForCaption);
			}
			iX = iX + iUsableWidth - numWideForValue;
			oTextRender.drawAlignRight(oCtx, iX, iY, sFormatedValue, numWideForValue);
		}
	}
	
	
	/** 棚架式的热力图的一个单元格的绘制器；虽然没有数轴，也没有分类轴（分类标题在表头单元格），但只画一个单元格，相当于分片 */
	function SeparatedHeatMapRender(oCtx, sColor, iDiameter)
	{
		var _oGraphics = new Graphics(oCtx);
		var _sColor = sColor;
		var _iDiameter = iDiameter;
		
		this.drawShape = function(bHover)
		{
			var iX1 = (_oGraphics.getWidth() - _iDiameter) >> 1;
			var iY1 = (_oGraphics.getHeight() - _iDiameter) >> 1;
			var iX2 = iX1 + _iDiameter;
			var iY2 = iY1 + _iDiameter;
			_oGraphics.clearAll();
			_oGraphics.getContext().fillStyle = _sColor;
			_oGraphics.fillRect(iX1, iY1, iX2, iY2);
			if(bHover)
			{
				_oGraphics.getContext().lineWidth = 1;
				_oGraphics.getContext().strokeStyle = "#000";
				_oGraphics.strokeRect(iX1, iY1, iX2, iY2);
			}
		}
		
		this.drawColorRect = function(bHover)
		{
			var iX1 = 0;
			var iY1 = 0;
			var iX2 = _oGraphics.getWidth() - iX1;
			var iY2 = _oGraphics.getHeight() - iY1;
			_oGraphics.clearAll();
			_oGraphics.getContext().fillStyle = _sColor;
			_oGraphics.fillRect(iX1, iY1, iX2, iY2);
			if(bHover)
			{
				_oGraphics.getContext().lineWidth = 1;
				_oGraphics.getContext().strokeStyle = "#000";
				_oGraphics.strokeRect(iX1 + 1, iY1 + 1, iX2 - 1, iY2 - 1);
			}
		}
	}
	
	/** 饼图绘制器，没有轴也就没有分片/完整之分 */
	function PieChartRender(oCtx, oModel, oAttr, iRadius, iOffsetX, iOffsetY)
	{
		var IGNORED = "ignored";
		var _oGraphics = new Graphics(oCtx);
		var _oModel = oModel;
		var _oAttr = oAttr;
		var _oStyleTool = new StyleTool(oAttr);
		var _iRadius = iRadius;
		var _oSelectionModel;
		var _oDrawingModel;
		
		(function()
		{
			//原点移到饼的圆心，逆时针转90度，使从12点方向开始画扇形
			iOffsetX = (iOffsetX ? iOffsetX : 0);
			iOffsetY = (iOffsetY ? iOffsetY : 0);
			var iWidth = _oGraphics.getWidth();
			var iHeight = _oGraphics.getHeight();
			PolarCoordinate.transform(_oGraphics, iOffsetX + (iWidth >> 1), iOffsetY + (iHeight >> 1));
		})();
		
		this.apiXYToCategoryIndex = function(iApiX, iApiY)
		{
			var arrXY = _oGraphics.retransformMouseXY(iApiX, iApiY);
			var numLogicX = arrXY[0];
			var numLogicY = arrXY[1];
			var numRadius = PolarCoordinate.logicXyToRadius(numLogicX, numLogicY);
			var iIdx = -1;
			if(numRadius < getHollowRadius() - 1)
			{
				iIdx = -128;
			}
			else if(numRadius < _iRadius + 1)
			{
				var numAngle = PolarCoordinate.logicXyToAngle(numLogicX, numLogicY, numRadius);
				var arrAngleEnd = _oDrawingModel.getEachAngleEnd();
				for(var i = 0; i < arrAngleEnd.length; i++)
				{
					if(numAngle <= arrAngleEnd[i])
					{
						iIdx = i;
						break;
					}
				}
			}
			return iIdx;
		}
		
		this.getDrawingModel = function()
		{
			return _oDrawingModel;
		}
		
		this.setSelectionModel = function(oSelectionModel)
		{
			_oSelectionModel = oSelectionModel;
		}
		
		this.drawChart = function(iCategoryIdx)
		{
			_oGraphics.clearAll();
			
			var sBackground = _oStyleTool.getBackgroundColor();
			_oGraphics.getContext().strokeStyle = sBackground;
			_oGraphics.getContext().lineWidth = Math.min(4, (_iRadius * 0.005) + 0.5);
			
			var arrRadius = [];
			var arrAngleEnd = [];
			var arrPercent = [];
			var sFormatedTotal = null;
			
			var arrCategory = _oModel.getCategories();
			if(arrCategory.length > 0)
			{
				var iInnerRadius = getHollowRadius();
				var arrValueForDraw = [];
				var arrTotal = total(arrValueForDraw);
				var numTotal = arrTotal[0];
				var numOriTotal = arrTotal[1];
				var numMaxValue = arrTotal[2];
				var bByAngle = _oAttr.isPresentByAngle() && (numTotal != 0);
				var numAddingValue = 0;
				var iCategoryCount = arrCategory.length;
				for(var i = 0; i < iCategoryCount; i++)
				{
					var numValue = arrValueForDraw[i];
					if(numValue == IGNORED)
					{
						continue;
					}
					
					if(numTotal == 0 || numValue == null)
					{
						arrPercent[i] = "";
					}
					else
					{
						var numRate = numValue / numTotal;
						arrPercent[i] = Util.formatPercentage(numRate, 2);
					}
					
					var numAngleFrom;
					var numAngleTo;
					var numAnglePercent;
					if(bByAngle)
					{
						numAngleFrom = numAddingValue / numTotal *  Math.PI * 2;
						numAddingValue += numValue;
						numAngleTo = numAddingValue / numTotal *  Math.PI * 2;
						numAnglePercent = numValue / numTotal;
					}
					else
					{
						numAngleFrom = numAddingValue / iCategoryCount *  Math.PI * 2;
						numAddingValue += 1;
						numAngleTo = numAddingValue / iCategoryCount *  Math.PI * 2;
						numAnglePercent = 1 / iCategoryCount;
					}
					var iOuterRadius = getRadius(numValue, numMaxValue);
					arrRadius[i] = iOuterRadius;
					arrAngleEnd[i] = numAngleTo;
					
					(iCategoryIdx == i) && (iOuterRadius = getExtendedRadius(iOuterRadius));
					drawSector(iOuterRadius, iInnerRadius, numAngleFrom, numAngleTo, arrCategory[i]);
					if(numAnglePercent > 0.01 && iCategoryCount > 1)
					{
						drawSplitLine((i > 0 ? arrAngleEnd[i - 1] : 0), iInnerRadius, iOuterRadius);
						drawSplitLine(arrAngleEnd[i], iInnerRadius, iOuterRadius);
					}
				}
				if(_oAttr.isHollow() && _oAttr.isShowTotalWhenHollow())
				{
					sFormatedTotal = drawCenterText(numOriTotal);
				}
				if(_oAttr.isShowDataLabel())
				{
					drawDataLabel(arrCategory, arrRadius, arrAngleEnd, arrPercent);
				}
			}
			_oDrawingModel = new DrawingModel(arrAngleEnd, arrPercent, sFormatedTotal);
		}
		
		var total = function(arrValueForDraw)
		{
			var numTotal = 0;
			var numOriTotal = 0;
			var numMaxValue = 0;
			var arrNode = _oModel.getSeries()[0].getNodes();
			for(var i = 0; i < arrNode.length; i++)
			{
				var oNode = arrNode[i];
				if(!oNode || isNaN(oNode.getValue()))
				{
					continue;
				}
				var numValueForDraw;
				var numOriValue = oNode.getValue();
				if(numOriValue < 0 && _oAttr.isIgnoreNegative())
				{
					numValueForDraw = IGNORED;
				}
				else
				{
					numValueForDraw = Math.abs(numOriValue);
					numTotal += numValueForDraw;
					numMaxValue = Math.max(numMaxValue, numValueForDraw);
				}
				arrValueForDraw[i] = numValueForDraw;
				numOriTotal += numOriValue;
			}
			return [numTotal, numOriTotal, numMaxValue];
		}
		
		var drawCenterText = function(numOriTotal)
		{
			var iFontSize = Math.min(100, Math.max(12, Math.log(_iRadius * 0.05) * 32));
			var oFormater = new NumberFormater();
			oFormater.setFormatString(_oModel.getSeries()[0].getFormatString());
			var sText = oFormater.format(numOriTotal);
			_oGraphics.getContext().fillStyle = _oStyleTool.getCustomStyle(PieChartRender.RING_CENTER_COLOR, "#6c7fae");
			new ShrinkableTextRender().drawInCircle(_oGraphics, 0, getHollowRadius(), sText, iFontSize);
			return sText;			
		}
		
		var drawSector = function(iRadius, iInnerRadius, numAngleFrom, numAngleTo, oCategory)
		{
			var sColor = getCategoryColor(oCategory);
			fillSectorWithColor(sColor, iRadius, iInnerRadius, numAngleFrom, numAngleTo);
			if(_oSelectionModel && _oSelectionModel.isAnySelected())
			{
				if(!_oSelectionModel.isSelected(oCategory, null))
				{
					var sMaskColor = _oStyleTool.getUnselectedMaskColor();
					fillSectorWithColor(sMaskColor, iRadius + 1, Math.max(0, iInnerRadius - 1), numAngleFrom, numAngleTo);
				}	
			}
		}
		
		var fillSectorWithColor = function(sColor, iRadius, iInnerRadius, numAngleFrom, numAngleTo)
		{
			if(numAngleFrom == numAngleTo)
			{
				return;
			}

			_oGraphics.getContext().fillStyle = sColor;
			_oGraphics.beginPath();
			_oGraphics.arc(0, 0, iRadius, numAngleFrom, numAngleTo);
		    _oGraphics.arc(0, 0, iInnerRadius, numAngleTo, numAngleFrom, true);
			_oGraphics.fill();
		}
		
		var getCategoryColor = function(oCategory)
		{
			var sColor = oCategory.getColor();
			sColor = (sColor ? sColor : DEFAULT_COLOR);
			return sColor;
		}
		
		var drawSplitLine = function(numAngleTo, iInnerRadius, iOuterRadius)
		{
			_oGraphics.beginPath();
			_oGraphics.arc(0, 0, iOuterRadius + 1, numAngleTo, numAngleTo);
			_oGraphics.arc(0, 0, Math.max(0, iInnerRadius - 1), numAngleTo, numAngleTo);
			_oGraphics.stroke();
		}
		
		var drawDataLabel = function(arrCategory, arrRadius, arrAngleEnd, arrPercent)
		{
			var bOverlappable = _oAttr.isDataLabelOverlappable();
			var arrNode = _oModel.getSeries()[0].getNodes();
			var funTextCollector = function(iIdx, arrText, arrShortenAtLeast)
			{
				var iLabelType = _oAttr.getDataLabelType();
				if((iLabelType & PieAttr.SHOW_LABEL_NAME) == PieAttr.SHOW_LABEL_NAME)
				{
					arrText.push(arrCategory[iIdx].getLabel());
					arrShortenAtLeast.push(bOverlappable ? 0 : 0.5);
				}
				if((iLabelType & PieAttr.SHOW_LABEL_NUMBER) == PieAttr.SHOW_LABEL_NUMBER)
				{
					var oNode = arrNode[iIdx];
					arrText.push(oNode ? oNode.getText() : "");
					arrShortenAtLeast.push(bOverlappable ? 0 : 1);
				}
				if((iLabelType & PieAttr.SHOW_LABEL_PERCENT) == PieAttr.SHOW_LABEL_PERCENT)
				{
					arrText.push(arrPercent[iIdx]);
					arrShortenAtLeast.push(bOverlappable ? 0 : 1);
				}
			}
			var iExtendedRadius = getExtendedRadius(_iRadius);
			var oRender = new PieCircleDataLabelRender();
			oRender.drawDataLabel(_oStyleTool, _oGraphics, _iRadius, iExtendedRadius, arrRadius, arrAngleEnd, funTextCollector, bOverlappable);
		}
		
		var getHollowRadius = function()
		{
			return (_oAttr.isHollow() ? _oAttr.getHollowRadius(_iRadius) : 0);
		}
		
		var getRadius = function(numValue, numMaxValue)
		{
			if(_oAttr.isPresentByRadius() && numMaxValue != 0)
			{
				var numInnerRadius = getHollowRadius();
				var numThick = _iRadius - numInnerRadius;
				var numBase = numThick * 0.2;
				var numActive = numThick - numBase;
				return numInnerRadius + numBase + numActive * numValue / numMaxValue;
			}
			else
			{
				return iRadius;
			}
		}
		
		var getExtendedRadius = function(iRadius)
		{
			return iRadius + Math.min(8, Math.max(2, parseInt(_iRadius * 0.05)));
		}
		
		function DrawingModel(arrAngleEnd, arrPercent, sTotal)
		{
			this.getEachAngleEnd = function(){return arrAngleEnd;}
			this.getDisplayablePercentage = function(iIdx){return arrPercent[iIdx];}
			this.getDisplayableTotal = function(){return sTotal;}
		}
	}
	PieChartRender.RING_CENTER_COLOR = "ringCenterColor";
	
	/** 柱子的基类 */
	function AbstractSeparatedBarRender(oCtx, oModel, oAttr)
	{
		var _this = this;
		var _oGraphics = new Graphics(oCtx);
		var _oModel = oModel;
		var _oAttr = oAttr;
		var _oStyleTool = new StyleTool(oAttr);
		var _bStackMode = false;
		
		this.setStackMode = function(bStackMode)
		{
			_bStackMode = bStackMode;
		}
		this.isStackMode = function()
		{
			return _bStackMode;
		}
		
		this.protectedTransformCoordinate = function(oGraphics, oDrawingContext, iApiX, iApiY)
		{
			throw new Error("Implement");
		}
		
		this.drawNumberAxis = function(sAxisTitle)
		{
			var oDrawingContext = createDrawingContext();
			var sFormatString = _oModel.getSeries()[0].getFormatString();
			_oGraphics.clearAll();
			_this.protectedDrawNumberAxisImpl(_oGraphics, oDrawingContext, sFormatString, sAxisTitle);
		}
		this.protectedDrawNumberAxisImpl = function(oGraphics, oDrawingContext, sFormatString, sAxisTitle)
		{
			throw new Error("Implement");
		}
		
		this.drawChart = function(bHover)
		{
			var oDrawingContext = createDrawingContext();
			oDrawingContext.setHover(bHover);
			
			var numPixelPerValue = _this.protectedTransformCoordinate(_oGraphics, oDrawingContext, 0, 0);
			oDrawingContext.setPixelPerValue(numPixelPerValue);
			
			_oGraphics.clearAll();
			drawZeroLine(oDrawingContext);
			var bDrew = drawMain(oDrawingContext);
			if(bDrew && _oAttr.isShowDataLabel())
			{
				var iFontSize = Util.getDataLabelFontSize(_oStyleTool);
				var sLabelColor = Util.getDataLabelColor(_oStyleTool);
				var oCtx = _oGraphics.getContext();
				oCtx.fillStyle = sLabelColor;
				Util.setupFont(oCtx, iFontSize);
				oCtx.textBaseline = "middle";
				_this.protectedDrawDataLabel(_oGraphics, oDrawingContext, iFontSize);
			}
		}
		this.protectedDrawDataLabel = function(oGraphics, oDrawingContext, iFontSize)
		{
			throw new Error("Implement");
		}
		
		var createDrawingContext = function()
		{
			var oDrawingContext = new DrawingContext();
			
			var oScope = _oModel.getScopes()[0];
			var oScopeAdapter = new RulerScaleAdapter(oScope);
			var oNumberRulerHelper = new NumberRulerHelper(oScopeAdapter, _oStyleTool);
			oDrawingContext.bind(oScopeAdapter, oNumberRulerHelper);
			
			var iWidth = _oGraphics.getWidth();
			var iHeight = _oGraphics.getHeight();
			var arrWH = _this.protectedConfirmLogicSize(iWidth, iHeight);
			iWidth = arrWH[0];
			iHeight = arrWH[1];
			oDrawingContext.setLogicSize(iWidth, iHeight);
			
			_this.protectedConfirmRulerMark(oDrawingContext);
			return oDrawingContext;
		}
		this.protectedConfirmLogicSize = function(iWidth, iHeight)
		{
			throw new Error("Implement");
		}
		this.protectedConfirmRulerMark = function(oDrawingContext)
		{
			throw new Error("Implement");
		}
		
		var drawZeroLine = function(oDrawingContext)
		{
			_oGraphics.getContext().strokeStyle = "#ccc";
			_oGraphics.beginPath();
			_oGraphics.moveTo(0, 0);
			_oGraphics.lineTo(oDrawingContext.getLogicWidth(), 0);
			_oGraphics.stroke();
		}
		
		var drawMain = function(oDrawingContext)
		{
			var arrCategory = _oModel.getCategories();
			var oSeries = _oModel.getSeries()[0];
			var arrNode = oSeries.getNodes();
			if(!arrNode)
			{
				return false;
			}
			
			var iWidth = oDrawingContext.getLogicWidth();
			var numBarWidth = (iWidth > 10 ? iWidth * 0.4 : Math.max(1, iWidth - 4));
			var numStartX = (iWidth - numBarWidth) * 0.5;
			var numEndX = numStartX + numBarWidth;
			oDrawingContext.setBarWidth(numBarWidth);

			var numPositiveAdd = 0;//正负两个方向分别堆积
			var numNegativeAdd = 0;
			for(var i = arrCategory.length - 1; i >= 0 ; i--)//堆积图是多个category
			{
				var oCategory = arrCategory[i];
				var oNode = arrNode[i];
				var numValue = oNode.getValue();
				var numBarHeight = numValue * oDrawingContext.getPixelPerValue();
				var numStartY, numEndY;
				if(numValue >= 0)
				{
					numStartY = numPositiveAdd;
					numPositiveAdd += numBarHeight;
				 	numEndY = numPositiveAdd;
				}
				else
				{
					numEndY = numNegativeAdd;
					numNegativeAdd += numBarHeight;
					numStartY = numNegativeAdd;
				}
				var sColor = oCategory.getColor();
				sColor = (sColor ? sColor : oSeries.getColor());
				_oGraphics.getContext().fillStyle = (sColor ? sColor : DEFAULT_COLOR);
				_oGraphics.fillRect(numStartX, numStartY, numEndX, numEndY);
				oDrawingContext.setRectInfo(i, sColor, numStartY, numEndY);
			}
			
			if(oDrawingContext.isHover())
			{
				var iW = _oGraphics.getWidth();
				var iH = _oGraphics.getHeight();
				var iX = Math.min(2, iW >> 1);
				var iY = Math.min(2, iH >> 1);
				var iW = Math.max(4, iW - 4);
				var iH = Math.max(4, iH - 4);
				_oGraphics.getContext().fillStyle = HOVER_MASK_COLOR;
				_oGraphics.getContext().fillRect(iX, iY, iW, iH);
			}
			return true;
		}
		
		function DrawingContext()
		{
			var _bHover;
			var _oNumberRulerHelper;
			var _oScopeAdapter;
			var _iLogicWidth;
			var _iLogicHeight;
			var _numPixelPerValue;
			var _numBarWidth;
			var _arrRectInfo = [];
			
			this.bind = function(oScopeAdapter, oNumberRulerHelper)
			{
				_oScopeAdapter = oScopeAdapter;
				_oNumberRulerHelper = oNumberRulerHelper;
			}
			
			this.setHover = function(bHover)
			{
				_bHover = bHover;
			}
			
			this.setLogicSize = function(iLogicWidth, iLogicHeight)
			{
				_iLogicWidth = iLogicWidth;
				_iLogicHeight = iLogicHeight;
			}
			
			this.setPixelPerValue = function(numPixelPerValue)
			{
				_numPixelPerValue = numPixelPerValue;
			}
			
			this.setRectInfo = function(iCategoryIdx, sColor, numStartY, numEndY)
			{
				_arrRectInfo[iCategoryIdx] = [sColor, numStartY, numEndY];
			}
			
			this.setBarWidth = function(numBarWidth)
			{
				_numBarWidth = numBarWidth;
			}
			
			this.getScopeAdapter = function(){return _oScopeAdapter;}
			this.getNumberRulerHelper = function(){return _oNumberRulerHelper;}
			this.isHover = function(){return _bHover;}
			this.getLogicWidth = function(){return _iLogicWidth;}
			this.getLogicHeight = function(){return _iLogicHeight;}
			this.getPixelPerValue = function(){return _numPixelPerValue;}
			this.getRectInfo = function(iCategoryIdx){return _arrRectInfo[iCategoryIdx];}
			this.getBarWidth = function(){return _numBarWidth;}
		}
		
		this.protectedMethod = {};
		this.protectedMethod.getModel = function(){return _oModel;}
		this.protectedMethod.getAttr = function(){return _oAttr;}
		this.protectedMethod.getStyleTool = function(){return _oStyleTool;}
	}
	
	/** 纵向柱子绘制器；服务于棚架，一个单元格一根柱子（或其堆积）；分片处理数轴；没有分类轴，分类标题在上表头单元格 */
	function SeparatedVBarRender(oCtx, oModel, oAttr)
	{
		AbstractSeparatedBarRender.call(this, oCtx, oModel, oAttr);
		var _this = this;
		var _super = this.protectedMethod;
		
		//@Implement AbstractSeparatedBarRender
		this.protectedTransformCoordinate = function(oGraphics, oDrawingContext, iApiX, iApiY)
		{
			var bShrinkForText = (_super.getAttr().isShowDataLabel() && !_this.isStackMode());
			var iShrinkForText = (bShrinkForText ? (Util.getAxisTextFontSize(_super.getStyleTool()) * 1.5) : 0);
			var iHeight = oGraphics.getHeight()
			var iPadding = Math.max(8, Math.min(16, parseInt(iHeight * 0.05)));
			iApiY += iPadding;
			iHeight -= iPadding * 2;
			var oScopeAdapter = oDrawingContext.getScopeAdapter();
			return CoordinateTransformer.verticalNumberAxis(oGraphics, iApiX, iApiY, iHeight, oScopeAdapter, 0, iShrinkForText);
		}
		
		//@Implement AbstractSeparatedBarRender
		this.protectedDrawNumberAxisImpl = function(oGraphics, oDrawingContext, sFormatString, sAxisTitle)
		{
			var numPixelPerValue = _this.protectedTransformCoordinate(oGraphics, oDrawingContext, oGraphics.getWidth(), 0);
			oDrawingContext.setPixelPerValue(numPixelPerValue);
			var iAxisAreaWidth = oDrawingContext.getLogicWidth();
			oDrawingContext.getNumberRulerHelper().drawLeftNumberAxisWithMark(oGraphics, iAxisAreaWidth, numPixelPerValue, sFormatString, null);
		}
		
		//@Implement AbstractSeparatedBarRender
		this.protectedConfirmLogicSize = function(iWidth, iHeight)
		{
			return [iWidth, iHeight];
		}
		
		//@Implement AbstractSeparatedBarRender
		this.protectedConfirmRulerMark = function(oDrawingContext)
		{
			oDrawingContext.getNumberRulerHelper().confirmVerticalRulerMark(oDrawingContext.getLogicHeight());
		}
		
		//@Implement AbstractSeparatedBarRender
		this.protectedDrawDataLabel = function(oGraphics, oDrawingContext, iFontSize)
		{
			var iAllWidth = oGraphics.getWidth();
			var iAllHeight = oGraphics.getHeight();
			var oNonoverlap = new NonoverlappingConfirmer(0, 0, iAllWidth, iAllHeight);
			var bLabelInBar = _this.isStackMode();
			var arrNode = _super.getModel().getSeries()[0].getNodes();
			var numBarThickness = oDrawingContext.getBarWidth();
			for(var i = 0, c = _super.getModel().getCategories().length; i < c; i++)
			{
				var arrRectInfo = oDrawingContext.getRectInfo(i);
				var sColor = arrRectInfo[0];
				var numStartY = arrRectInfo[1];
				var numEndY = arrRectInfo[2];
				var numYLen = Math.abs(numEndY - numStartY);
				if(bLabelInBar && numYLen < iFontSize * 0.6)
				{
					continue;
				}
				var oNode = arrNode[i];
				var numValue = oNode.getValue();
				var sText = oNode.getText();
				var numTextWidth = oGraphics.getContext().measureText(sText).width;
				if(numTextWidth > iAllWidth)
				{
					continue;
				}
				var bTextInsideRect = false;
				var numX = (iAllWidth - numTextWidth) * 0.5;
				var numY;
				if(bLabelInBar)
				{
					numY = (numStartY + numEndY) * 0.5;
					bTextInsideRect = (numTextWidth < numBarThickness && iFontSize < numYLen);
				}
				else
				{
					numY = (numValue < 0 ? 
							Math.min(numStartY, numEndY) - iFontSize * 0.75 :
							Math.max(numStartY, numEndY) + iFontSize * 0.75); 
				}
				var arrXY = oGraphics.transformXY(numX, numY);
				numX = arrXY[0];
				numY = arrXY[1];
				if(oNonoverlap.isRectCanDraw(arrXY[0], arrXY[1], numTextWidth, iFontSize))
				{
					if(bTextInsideRect)
					{
						Util.drawTextFitBackground(sColor, oGraphics.getContext(), sText, numX, numY);
					}
					else
					{
						Util.drawTextWithShadow(_super.getStyleTool(), oGraphics.getContext(), sText, numX, numY);
					}
				}
			}
		}
	}
	
	/** 横向柱子绘制器；服务于棚架，一个单元格一根柱子（或其堆积）；分片处理数轴；没有分类轴，分类标题在左表头单元格 */
	function SeparatedHBarRender(oCtx, oModel, oAttr)
	{
		AbstractSeparatedBarRender.call(this, oCtx, oModel, oAttr);
		var _this = this;
		var _super = this.protectedMethod;
		
		//@Implement AbstractSeparatedBarRender
		this.protectedTransformCoordinate = function(oGraphics, oDrawingContext, iApiX, iApiY)
		{
			var iWidth = oGraphics.getWidth();
			var iPadding = Math.min(16, parseInt(iWidth * 0.05));
			iApiX += iPadding;
			iWidth -= iPadding * 2;
			var oScopeAdapter = oDrawingContext.getScopeAdapter();
			return CoordinateTransformer.horizontalNumberAxis(oGraphics, iApiX, iApiY, iWidth, oScopeAdapter, 0, 0, 0);
		}
		
		//@Implement AbstractSeparatedBarRender
		this.protectedDrawNumberAxisImpl = function(oGraphics, oDrawingContext, sFormatString, sAxisTitle)
		{
			var numPixelPerValue = _this.protectedTransformCoordinate(oGraphics, oDrawingContext, 0, oGraphics.getHeight());
			oDrawingContext.setPixelPerValue(numPixelPerValue);
			oDrawingContext.getNumberRulerHelper().drawTopNumberAxisWithMark(oGraphics, numPixelPerValue, sFormatString, null);
		}
		
		//@Implement AbstractSeparatedBarRender
		this.protectedConfirmLogicSize = function(iWidth, iHeight)
		{
			return [iHeight, iWidth];
		}
		
		//@Implement AbstractSeparatedBarRender
		this.protectedConfirmRulerMark = function(oDrawingContext)
		{
			oDrawingContext.getNumberRulerHelper().confirmHorizontalRulerMark(oDrawingContext.getLogicHeight());
		}
		
		//@Implement AbstractSeparatedBarRender
		this.protectedDrawDataLabel = function(oGraphics, oDrawingContext, iFontSize)
		{
			var iAllWidth = oGraphics.getWidth();
			var iAllHeight = oGraphics.getHeight();
			if(iAllHeight < iFontSize)
			{
				return;
			}
			var bLabelInBar = _this.isStackMode();
			var arrNode = _super.getModel().getSeries()[0].getNodes();
			var numBarThickness = oDrawingContext.getBarWidth();
			for(var i = 0, c = _super.getModel().getCategories().length; i < c; i++)
			{
				var arrRectInfo = oDrawingContext.getRectInfo(i);
				var sColor = arrRectInfo[0];
				var numStartY = arrRectInfo[1];
				var numEndY = arrRectInfo[2];
				var numYLen = Math.abs(numEndY - numStartY);
				var oNode = arrNode[i];
				var numValue = oNode.getValue();
				var sText = oNode.getText();
				var numTextWidth = oCtx.measureText(sText).width;
				if(bLabelInBar && numYLen < numTextWidth)
				{
					continue;
				}
				var bTextInsideRect = false;
				var numX = iAllHeight * 0.5 + iFontSize * 0.08;//字体向下偏移一点点效果好
				var numY;
				if(bLabelInBar)
				{
					numY = (numStartY + numEndY - numTextWidth) * 0.5;
					bTextInsideRect = (numTextWidth < numYLen && iFontSize < numBarThickness);
				}
				else
				{
					numY = (numValue < 0 ? 
							Math.min(numStartY, numEndY) - numTextWidth - 4 : 
							Math.max(numStartY, numEndY) + 4);
				}
				var arrXY = oGraphics.transformXY(numX, numY);
				numX = arrXY[0];
				numY = arrXY[1];
				(numX + numTextWidth > iAllWidth) && (numX = iAllWidth - numTextWidth);
				(numX < 0) && (numX = 0);
				if(bTextInsideRect)
				{
					Util.drawTextFitBackground(sColor, oGraphics.getContext(), sText, numX, numY);
				}
				else
				{
					Util.drawTextWithShadow(_super.getStyleTool(), oGraphics.getContext(), sText, numX, numY);
				}
			}
		}
	}
	
	/** 一个数轴一个类别轴，鼠标划过在类别轴上有反馈 */
	function AbstractNSHoverable()
	{
		var searchHoverTarget = function(iLogicX, iLogicY, oModel, oDrawingModel)
		{
			if(iLogicX > 0)
			{
				var iReflineCount = oDrawingModel.getReflineCount();
				if(iReflineCount > 0)
				{
					for(var i = 0; i < iReflineCount; i++)
					{
						var oDrawingRefline = oDrawingModel.getRefline(i);
						if(oDrawingRefline.isNearEnough(iLogicY))
						{
							var iReflineTag = i + 1;
							return new HoverTarget(iReflineTag, -1);
						}
					}
				}
				if(oDrawingModel.getPixelMinY() < iLogicY && iLogicY < oDrawingModel.getPixelMaxY())
				{
					var iCategoryIdx = oDrawingModel.whichCategoryNeared(iLogicX);
					if(0 <= iCategoryIdx && iCategoryIdx < oModel.getCategories().length)
					{
						return new HoverTarget(0, iCategoryIdx);
					}
				}
			}
			return new HoverTarget(0, -1);
		}
		
		/** 鼠标所在位置的信息 */
		function HoverTarget(iReflineTag, iCategoryIdx)
		{
			var _iReflineTag = iReflineTag;//0表示没有，序号从1开始，负值表示副轴。
			var _iCategoryIdx = iCategoryIdx;
			var _oInnerApi;
			
			this.getReflineIndex = function()
			{
				return _iReflineTag == 0 ? -1 : Math.abs(_iReflineTag) - 1;
			}
			
			this.getCategoryIndex = function()
			{
				return _iCategoryIdx;
			}
			
			this.isEquals = function(oAnother)
			{
				if(oAnother)
				{
					return _iCategoryIdx == oAnother.getCategoryIndex()
						&& _iReflineTag == oAnother.inner().getReflineTag(); 
				}
				return false;
			}
			
			this.inner = function()
			{
				if(!_oInnerApi)
				{
					_oInnerApi = {};
					_oInnerApi.getReflineTag = function(){return _iReflineTag;}
					_oInnerApi.isHoveringRefline = function(){return _iReflineTag != 0;}
					_oInnerApi.isHoveringSecondaryAxisRefline = function(){return _iReflineTag < 0;}
					_oInnerApi.toSecondaryAxisRefline = function(){return new HoverTarget(-_iReflineTag, -1);}
				}
				return _oInnerApi;
			}
		}
		
		this.protectedMethod = {};
		this.protectedMethod.searchHoverTarget = searchHoverTarget;
	}
	
	/** 完整柱图抽象绘制器，不管是纵向的柱子还是横向的柱子，都抽象成Y是数值轴，X是类别轴，通过坐标转换用相同的算法实现绘制。 */
	function AbstractColumnChartRender(oCtx, oModel, oAttr)
	{
		AbstractNSHoverable.call(this);
		var _this = this;
		var _super = this.protectedMethod;
		
		var _oGraphics = new Graphics(oCtx);
		var _oCompositeContext;
		
		var _oModel = oModel;
		var _oAttr = oAttr;
		var _oStyleTool = new StyleTool(oAttr);
		var _iMode = 0;
		var _oSelectionModel;
		
		var _oDrawingModel;
		var _oHoverTarget;
		
		this.searchHoverTarget = function(iApiX, iApiY)
		{
			var arrXY = _oGraphics.retransformMouseXY(iApiX, iApiY);
			return _super.searchHoverTarget(arrXY[0], arrXY[1], _oModel, _oDrawingModel);
		}
		
		this.getDrawingModel = function()
		{
			return _oDrawingModel;
		}
		
		/** 堆积、百分比、进度等类型，通过此接口设定。@see AbstractColumnChartRender.MODE_XXX */
		this.setMode = function(iMode)
		{
			_iMode = iMode;
		}
		var isOneColumnMergedMode = function()//多个系列绘制在一个柱子上
		{
			return (_iMode & AbstractColumnChartRender.MODE_ONE_COLUMN_MERGED) == AbstractColumnChartRender.MODE_ONE_COLUMN_MERGED;
		}
		var isStackedMode = function()//堆积
		{
			return (_iMode & AbstractColumnChartRender.MODE_STACKED) == AbstractColumnChartRender.MODE_STACKED;
		}
		var isPercentStackedMode = function()//百分比堆积
		{
			return (_iMode & AbstractColumnChartRender.MODE_PERCENT_STACKED) == AbstractColumnChartRender.MODE_PERCENT_STACKED;
		}
		var isOverlapMode = function()//重叠（进度图）
		{
			return (_iMode & AbstractColumnChartRender.MODE_OVERLAP) == AbstractColumnChartRender.MODE_OVERLAP;
		}
			
		this.setSelectionModel = function(oSelectionModel)
		{
			_oSelectionModel = oSelectionModel;
		}
		
		this.hookCompositeContext = function(oCompositeContext)
		{
			_oCompositeContext = oCompositeContext;
		}
		
		this.drawChart = function(oHoverTarget)
		{
			_oHoverTarget = oHoverTarget;
			_oGraphics.clearAll();
			
			_oDrawingModel = new DrawingModel();
			var oDrawingContext = createDrawingContext();
			
			var arrReturn = _this.protectedDivideParts(_oGraphics, oDrawingContext.getNumberRulerHelper());
			oDrawingContext.setDivided(arrReturn[0], arrReturn[1], arrReturn[2], arrReturn[3]);
			
			_this.protectedConfirmRulerMark(oDrawingContext);
			
			var numPixelPerValue = _this.protectedTransformCoordinate(_oGraphics, oDrawingContext);
			oDrawingContext.setPixelPerValue(numPixelPerValue);
			
			_this.protectedDrawChart(_oGraphics, oDrawingContext);
		}
		//划分各轴、绘图区的大小。
		this.protectedDivideParts = function(oGraphics, oNumberRulerHelper)
		{
			throw new Error("Implement");
		}
		//确定数轴标尺刻度1/2/5，修订最大最小值。
		this.protectedConfirmRulerMark = function(oDrawingContext)
		{
			throw new Error("Implement");
		}
		//坐标转换，返回像素值与业务值换算率。
		this.protectedTransformCoordinate = function(oGraphics, oDrawingContext)
		{
			throw new Error("Implement");
		}
		//绘制
		this.protectedDrawChart = function(oGraphics, oDrawingContext)
		{
			throw new Error("Implement");
		}
		
		var createDrawingContext = function()
		{
			var oDrawingContext = new DrawingContext();
			var oScopeAdapter = createScopeAdapter();
			var oNumberRulerHelper = new NumberRulerHelper(oScopeAdapter, _oStyleTool);
			oDrawingContext.bind(oScopeAdapter, oNumberRulerHelper);
			return oDrawingContext;
		}
		
		var drawMain = function(oDrawingContext)
		{
			var numPixelPerCategory = _oDrawingModel.getPixelPerCategory();
			
			var arrSeries = getSuitableSeries();
			var iSeriesCount = (arrSeries ? arrSeries.length : 0);
			
			var numUnitThickness, numX;
			if(isOneColumnMergedMode() || iSeriesCount == 1)
			{
				var numParam = 0.4;
				if(numPixelPerCategory < 20)
				{
					numParam = 0.6;
				}
				else if(numPixelPerCategory < 30)
				{
					numParam = -0.02 * numPixelPerCategory + 1;
				}
				numUnitThickness = numPixelPerCategory * numParam;
				numX = numPixelPerCategory * (1 - numParam) / 2;
			}
			else
			{
				var iBlankPeersCount = 0.375 * iSeriesCount + 0.75;//空白部分相当于几根柱子宽度
				numUnitThickness = numPixelPerCategory / (iSeriesCount + iBlankPeersCount);
				numX = numUnitThickness * iBlankPeersCount / 2;
			}
			
			var iCategoryCount = _oModel.getCategories().length;
			var numOuterX = 0;
			for(var i = 0; i < iCategoryCount; i++)
			{
				var numOuterX1 = numOuterX;
				var numOuterX2 = numOuterX + numPixelPerCategory;
				drawHoverCategory(i, numOuterX1, numOuterX2);
				if(isStackedMode())
				{
					drawOneCategoryForStacked(oDrawingContext, numX, numX + numUnitThickness, i);
				}
				else if(isOverlapMode())
				{
					drawOneCategoryForOverlap(oDrawingContext, numX, numX + numUnitThickness, i);
				}
				else
				{
					drawOneCategoryForMultiSeries(oDrawingContext, numX, numUnitThickness, i);
				}
				numOuterX += numPixelPerCategory;
				numX += numPixelPerCategory;
			}
		}
		
		var drawOneCategoryForMultiSeries = function(oDrawingContext, numInnerX, numUnitThickness, iCategoryIdx)
		{
			var arrSeries = getSuitableSeries();
			var iSeriesCount = (arrSeries ? arrSeries.length : 0);
			var numUnitThicknessRealDraw = Math.min(COLUMN_MAX_WIDE, numUnitThickness);
			var numAdjust = (iSeriesCount > 1 ? Math.max(1, Math.min(6, numUnitThickness / 4)) : 0) / 2;
			numAdjust += ((numUnitThickness - numUnitThicknessRealDraw) / 2);
			for(var j = 0; j < iSeriesCount; j++)
			{
				var oSeries = arrSeries[j];
				var oNode = oSeries.getNodes()[iCategoryIdx];
				if(oNode)
				{
					var numValue = oNode.getValue();
					numValue = oDrawingContext.getScopeAdapter().scale(numValue);
					numValue = oDrawingContext.getScopeAdapter().cutFoot(numValue);
					var numX1 = numInnerX + numAdjust;
					var numY1 = 0;
					var numX2 = numInnerX + numUnitThickness - numAdjust;
					var numY2 = numValue * oDrawingContext.getPixelPerValue();
					drawRect(numX1, numY1, numX2, numY2, iCategoryIdx, oSeries, oNode);
					var oDrawingRect = [numX1, numY1, numX2, numY2];
					oDrawingContext.setDrawingRect(iCategoryIdx, j, oDrawingRect);
				}
				numInnerX += numUnitThickness;
			}
		}
		
		var drawOneCategoryForStacked = function(oDrawingContext, numX1, numX2, iCategoryIdx)
		{
			var arrAdjusted = keepColumnNotTooFat(numX1, numX2);
			numX1 = arrAdjusted[0];
			numX2 = arrAdjusted[1];
			
			var bPercentStackedMode = isPercentStackedMode();
			var oFormater;
			var numPercentModeScale = 0;
			if(bPercentStackedMode)
			{
				var iCategoryTotal = PercentModeCalculator.getCategoryTotal(_oModel, iCategoryIdx);
				if(iCategoryTotal != 0)
				{
					numPercentModeScale = 1 / iCategoryTotal;
				}
				oFormater = new NumberFormater(); //为了保证tips百分比的显示格式与轴和标签的显示格式一致
				oFormater.setFormatString(getNumberAxisFormat());
			}
			
			var numPositiveAdd = 0;
			var numNegativeAdd = 0;
			var arrSeries = getSuitableSeries();
			var iSeriesCount = (arrSeries ? arrSeries.length : 0);
			for(var j = iSeriesCount - 1; j >= 0; j--)
			{
				var oSeries = arrSeries[j];
				var oNode = oSeries.getNodes()[iCategoryIdx];
				if(!oNode)
				{
					continue;
				}
				var numValue = oNode.getValue();
				var numBarHeight = numValue * oDrawingContext.getPixelPerValue();
				if(bPercentStackedMode)
				{
					numBarHeight = numBarHeight * numPercentModeScale;
					var sPercent = (numPercentModeScale == 0 ? "---" : oFormater.format(numValue * numPercentModeScale));
					_oDrawingModel.setPercentage(iCategoryIdx, j, sPercent);
				}
				var numStartY, numEndY;
				if(numValue > 0)
				{
					numStartY = numPositiveAdd;
					numPositiveAdd += numBarHeight;
				 	numEndY = numPositiveAdd;
				}
				else
				{
					numEndY = numNegativeAdd;
					numNegativeAdd += numBarHeight;
					numStartY = numNegativeAdd;
				}
				drawRect(numX1, numStartY, numX2, numEndY, iCategoryIdx, oSeries, oNode);
				var oDrawingRect = [numX1, numStartY, numX2, numEndY];
				oDrawingContext.setDrawingRect(iCategoryIdx, j, oDrawingRect);
			}
		}
		
		var drawOneCategoryForOverlap = function(oDrawingContext, numX1, numX2, iCategoryIdx)
		{
			var arrAdjusted = keepColumnNotTooFat(numX1, numX2);
			numX1 = arrAdjusted[0];
			numX2 = arrAdjusted[1];
			
			var arrSeries = getSuitableSeries();
			var iSeriesCount = (arrSeries ? arrSeries.length : 0);
			for(var j = 0; j < iSeriesCount; j++)
			{
				var oSeries = arrSeries[j];
				var oNode = oSeries.getNodes()[iCategoryIdx];
				if(oNode)
				{
					var numValue = oNode.getValue();
					var numY1 = 0;
					var numY2 = numValue * oDrawingContext.getPixelPerValue();
					drawRect(numX1, numY1, numX2, numY2, iCategoryIdx, oSeries, oNode);
					var oDrawingRect = [numX1, numY1, numX2, numY2];
					oDrawingContext.setDrawingRect(iCategoryIdx, j, oDrawingRect);
				}
				var numWide = numX2 - numX1;
				var numAdjust = numWide * (1 - _oAttr.getOverlapShrinkingRatio()) * 0.5;
				numX1 += numAdjust;
				numX2 -= numAdjust;
			}
		}
		
		var keepColumnNotTooFat = function(numX1, numX2)
		{
			if(numX2 - numX1 > COLUMN_MAX_WIDE)
			{
				var numAdjust = (numX2 - numX1 - COLUMN_MAX_WIDE ) / 2;
				numX1 += numAdjust;
				numX2 -= numAdjust;
			}
			return [numX1, numX2];
		}
		
		var drawHoverCategory = function(iCategoryIdx, numX1, numX2)
		{
			if(_oHoverTarget && _oHoverTarget.getCategoryIndex() == iCategoryIdx)
			{
				var numY1 = _oDrawingModel.getPixelMinY();
				var numY2 = _oDrawingModel.getPixelMaxY();
				_oGraphics.getContext().fillStyle = HOVER_MASK_COLOR;
				_oGraphics.fillRect(numX1, numY1, numX2, numY2);
			}
		}
		
		var drawRect = function(numX1, numY1, numX2, numY2, iCategoryIdx, oSeries, oNode)
		{
			_oGraphics.getContext().fillStyle = (oNode.getColor() || oSeries.getColor());
			_oGraphics.fillRect(numX1, numY1, numX2, numY2);
			if(isHumble(iCategoryIdx, oSeries))
			{
				var sMaskColor = _oStyleTool.getUnselectedMaskColor();
				_oGraphics.getContext().strokeStyle = sMaskColor;
				_oGraphics.getContext().fillStyle = sMaskColor;
				_oGraphics.strokeRect(numX1, numY1, numX2, numY2);//TODO 边缘会少掉或相互覆盖造成有线
				_oGraphics.fillRect(numX1, numY1, numX2, numY2);
			}	
		}
		
		var isHumble = function(iCategoryIdx, oSeries)
		{
			if(_oSelectionModel && _oSelectionModel.isAnySelected())
			{
				var oCategory = _oModel.getCategories()[iCategoryIdx];
				return !_oSelectionModel.isSelected(oCategory, oSeries);
			}
			return false;
		}
		
		var drawDataLabel = function(funTextLogicXYConfirmer, oDrawingContext)
		{
			if(!_oAttr.isShowDataLabel())
			{
				return;
			}
			var iFontSize = Util.getDataLabelFontSize(_oStyleTool);
			var sLabelColor = Util.getDataLabelColor(_oStyleTool);
			var oCtx = _oGraphics.getContext();
			oCtx.fillStyle = sLabelColor;
			Util.setupFont(oCtx, iFontSize);
			oCtx.textBaseline = "middle";
			
			var sHumbleLabelColor;
			var funDynamicStyleChanger = function(iCategoryIdx, oSeries)
			{
				if(isHumble(iCategoryIdx, oSeries))
				{
					!sHumbleLabelColor && (sHumbleLabelColor = Util.createColorWithAlpha(sLabelColor, 0.25));
					oCtx.fillStyle = sHumbleLabelColor;
					return true;
				}
				else if(sHumbleLabelColor)
				{
					oCtx.fillStyle = sLabelColor;
				}
				return false;
			};
			
			var oFormater = new NumberFormater();//为了与轴的格式一致，不用服务端格式化好的node.getText()，而是自己重新格式化。
			oFormater.setFormatString(_oAttr.getDataLabelFormat() || getNumberAxisFormat());
			var oNonoverlap = _oAttr.isDataLabelOverlappable() ? null : 
								(_oCompositeContext ? _oCompositeContext.createNonoverlaper() :
										new NonoverlappingConfirmer(0, 0, _oGraphics.getWidth(), _oGraphics.getHeight()));
			
			_this.protectedDrawDataLabel(funTextLogicXYConfirmer, funDynamicStyleChanger, 
					oDrawingContext, getSuitableSeries(), oFormater, oNonoverlap, iFontSize);
		}
		this.protectedDrawDataLabel = function(funTextLogicXYConfirmer, funDynamicStyleChanger, 
				oDrawingContext, arrSuitableSeries, oFormater, oNonoverlap, iFontSize)
		{
			var oCtx = _oGraphics.getContext();
			var iCategoryCount = _oModel.getCategories().length;
			for(var i = 0; i < iCategoryCount; i++)
			{
				for(var j = 0; j < arrSuitableSeries.length; j++)
				{
					var oSeries = arrSuitableSeries[j];
					var oNode = oSeries.getNodes()[i];
					if(!oNode)
					{
						continue;
					}
					var sText = isPercentStackedMode() ? _oDrawingModel.getPercentage(i, j) : oFormater.format(oNode.getValue());
					var numTextWidth = oCtx.measureText(sText).width;
					var oDrawingRect = oDrawingContext.getDrawingRect(i, j);
					var numX1 = oDrawingRect[0];
					var numY1 = oDrawingRect[1];
					var numX2 = oDrawingRect[2];
					var numY2 = oDrawingRect[3];
					var arrXY = funTextLogicXYConfirmer(oNode.getValue(), numTextWidth, numX1, numY1, numX2, numY2);
					if(!arrXY)
					{
						continue;
					}
					var arrApiXY = _oGraphics.transformXY(arrXY[0], arrXY[1]);
					var numTextApiX = arrApiXY[0];
					var numTextApiY = arrApiXY[1] + 1;//数字绘制偏上，+1调整视觉效果。
					var numTextApiLeft = numTextApiX;
					var numTextApiTop = numTextApiY - iFontSize * 0.5;//baseline:middle
					if(oNonoverlap && !oNonoverlap.isRectCanDraw(numTextApiLeft, numTextApiTop, numTextWidth, iFontSize))
					{
						continue;
					}
					var bHumble = funDynamicStyleChanger(i, oSeries);
					if(bHumble)
					{
						oCtx.fillText(sText, numTextApiX, numTextApiY);
					}
					else
					{
						var arrRectApiPa = _oGraphics.transformXY(numX1, numY1);
						var arrRectApiPb = _oGraphics.transformXY(numX2, numY2);
						var numRectApiX1 = Math.min(arrRectApiPa[0], arrRectApiPb[0]);
						var numRectApiX2 = Math.max(arrRectApiPa[0], arrRectApiPb[0]);
						var numRectApiY1 = Math.min(arrRectApiPa[1], arrRectApiPb[1]);
						var numRectApiY2 = Math.max(arrRectApiPa[1], arrRectApiPb[1]) + 1;
						var bAllInsideRect = (numRectApiX1 < numTextApiLeft && numTextApiLeft + numTextWidth < numRectApiX2
												&& numRectApiY1 < numTextApiTop && numTextApiTop + iFontSize < numRectApiY2);
						if(bAllInsideRect)
						{
							var sBackgroundColor = oSeries.getColor();
							Util.drawTextFitBackground(sBackgroundColor, oCtx, sText, numTextApiX, numTextApiY);
						}
						else
						{
							Util.drawTextWithShadow(_oStyleTool, oCtx, sText, numTextApiX, numTextApiY);
						}
					}
				}
			}
		}
		
		var drawRefline = function(bVerticalColumn, oDrawingContext, iCategoryAxisLength)
		{
			var arrPaintableLines = _oModel.getPaintableLines();
			var arrOneAxisPaintableLine = (arrPaintableLines ? arrPaintableLines[0] : null);
			var iHoverIdx = (_oHoverTarget ? _oHoverTarget.getReflineIndex() : -1);
			
			var oScopeAdapter = oDrawingContext.getScopeAdapter();
			var numPixelPerValue = oDrawingContext.getPixelPerValue();
			var numPixelMinY = _oDrawingModel.getPixelMinY();
			var numPixelMaxY = _oDrawingModel.getPixelMaxY();
			var numPixelPerCategory = _oDrawingModel.getPixelPerCategory();
			
			var arrDrawingRefline;
			if(bVerticalColumn)
			{
				arrDrawingRefline = ReflinePainter.drawHorizontalLines(arrOneAxisPaintableLine, iHoverIdx,
						oScopeAdapter, _oStyleTool, _oGraphics, 0, iCategoryAxisLength, numPixelPerValue, numPixelMaxY);
				
				ReflinePainter.drawVGuidelines(
						_oModel.getGuidelines(), _oStyleTool, _oGraphics, numPixelMinY, numPixelMaxY, 
						function(iCategoryIndex)
						{
							return numPixelPerCategory * iCategoryIndex;
						});
			}
			else
			{
				arrDrawingRefline = ReflinePainter.drawVerticalLinesAtTransY(arrOneAxisPaintableLine, iHoverIdx,
						oScopeAdapter, _oStyleTool, _oGraphics, 0, iCategoryAxisLength, numPixelPerValue, numPixelMaxY);
						
				ReflinePainter.drawHGuidelines(
						_oModel.getGuidelines(), _oStyleTool, _oGraphics, numPixelMinY, numPixelMaxY,
						function(iCategoryIndex)
						{
							return numPixelPerCategory * iCategoryIndex;
						});
			}
			_oDrawingModel.setReflines(arrDrawingRefline);
		}
		
		var getSuitableSeries = function()
		{
			return _this.protectedGetSeries(_oModel);
		}
		this.protectedGetSeries = function(oModel)
		{
			return oModel.getSeries();
		}
		
		var getNumberAxisFormat = function()
		{
			var sFormatString = _this.protectedGetNumberAxisFormat();
			!sFormatString && (sFormatString = getSuitableSeries()[0].getFormatString());
			return sFormatString;
		}
		this.protectedGetNumberAxisFormat = function()
		{
			throw new Error("Override me");
		}
		
		var createScopeAdapter = function()
		{
			var oScope = _oModel.getScopes()[0];
			if(isPercentStackedMode())
			{
				var arrMaxCategoryPercent = PercentModeCalculator.getMaxCategoryPercent(_oModel);
				oScope.setMax(arrMaxCategoryPercent[0]);
				oScope.setMin(arrMaxCategoryPercent[1]);
			}
			var oScopeAdapter = _this.protectedCreateScopeAdapter(oScope);
			return oScopeAdapter;
		}
		this.protectedCreateScopeAdapter = function(oScope)
		{
			throw new Error("Override me");
		}
		
		/** 绘制过程的计算结果，绘制完成即丢。 */
		function DrawingContext()
		{
			var _oScopeAdapter;
			var _oNumberRulerHelper;
			var _iLeftAxisWidth;
			var _iBottomAxisHeight;
			var _iMainWidth;
			var _iMainHeight;
			var _numPixelPerValue;
			var _arrAllDrawingRect = [];
			
			this.bind = function(oScopeAdapter, oNumberRulerHelper)
			{
				_oScopeAdapter = oScopeAdapter;
				_oNumberRulerHelper = oNumberRulerHelper;
			}
			this.getScopeAdapter = function()
			{
				return _oScopeAdapter;
			}
			this.getNumberRulerHelper = function()
			{
				return _oNumberRulerHelper;
			}
			
			this.setDivided = function(iLeftAxisWidth, iBottomAxisHeight, iMainWidth, iMainHeight)
			{
				_iLeftAxisWidth = iLeftAxisWidth;
				_iBottomAxisHeight = iBottomAxisHeight;
				_iMainWidth = iMainWidth;
				_iMainHeight = iMainHeight;
			}
			this.getLeftAxisWidth    = function(){return _iLeftAxisWidth;}
			this.getBottomAxisHeight = function(){return _iBottomAxisHeight;}
			this.getMainWidth        = function(){return _iMainWidth;}
			this.getMainHeight       = function(){return _iMainHeight;}
			
			this.setPixelPerValue = function(numPixelPerValue)
			{
				_numPixelPerValue = numPixelPerValue;
			}
			this.getPixelPerValue = function()
			{
				return _numPixelPerValue;
			}
			
			this.setDrawingRect = function(iCategoryIdx, iSeriesIdx, oRect)
			{
				var arrRectOfOneCategory = _arrAllDrawingRect[iCategoryIdx];
				if(!arrRectOfOneCategory)
				{
					arrRectOfOneCategory = [];
					_arrAllDrawingRect[iCategoryIdx] = arrRectOfOneCategory;
				}
				arrRectOfOneCategory[iSeriesIdx] = oRect;
			}
			this.getDrawingRect = function(iCategoryIdx, iSeriesIdx)
			{
				return _arrAllDrawingRect[iCategoryIdx][iSeriesIdx];
			}
		}
		
		/** 绘制过程的计算结果，由于交互时有用而保留。 */
		function DrawingModel()
		{
			var _numPixelPerCategory;
			var _numPixelMinY;
			var _numPixelMaxY;
			var _arrPercent;
			var _arrRefline;
			
			this.setPixelPerCategory = function(numValue){_numPixelPerCategory = numValue;}
			this.getPixelPerCategory = function(){return _numPixelPerCategory;}
			
			this.setPixelMinY = function(numValue){_numPixelMinY = numValue;}
			this.getPixelMinY = function(){return _numPixelMinY;}
			
			this.setPixelMaxY = function(numValue){_numPixelMaxY = numValue;}
			this.getPixelMaxY = function(){return _numPixelMaxY;}
			
			this.whichCategoryNeared = function(iLogicX)
			{
				return parseInt(iLogicX / _numPixelPerCategory);
			}
			
			this.setPercentage = function(iCategoryIndex, iSeriesIndex, sText)
			{
				!_arrPercent && (_arrPercent = []);
				var arrPercentOfOneCategory = _arrPercent[iCategoryIndex];
				if(!arrPercentOfOneCategory)
				{
					arrPercentOfOneCategory = [];
					_arrPercent[iCategoryIndex] = arrPercentOfOneCategory;
				}
				arrPercentOfOneCategory[iSeriesIndex] = sText;
			}
			this.getPercentage = function(iCategoryIndex, iSeriesIndex)
			{
				var arrPercentOfOneCategory = (_arrPercent ? _arrPercent[iCategoryIndex] : null);
				return (arrPercentOfOneCategory ? arrPercentOfOneCategory[iSeriesIndex] : null);
			}
			this.isWithRatio = function()
			{
				return (_arrPercent ? true : false);
			}
			
			this.setReflines = function(arrDrawingRefline)
			{
				_arrRefline = arrDrawingRefline;
			}
			this.getReflineCount = function()
			{
				return (_arrRefline ? _arrRefline.length : 0);
			}
			this.getRefline = function(iIdx)
			{
				return _arrRefline[iIdx];
			}
		}
		
		_super.getGraphics = function(){return _oGraphics;}
		_super.getModel = function(){return _oModel;}
		_super.getAttr = function(){return _oAttr;}
		_super.getStyleTool = function(){return _oStyleTool;}
		_super.getNumberAxisFormat = getNumberAxisFormat;
		_super.isStackedMode = isStackedMode;
		_super.drawMain = drawMain;
		_super.drawDataLabel = drawDataLabel;
		_super.drawRefline = drawRefline;
		_super.createDrawingContext = createDrawingContext;
	}
	AbstractColumnChartRender.MODE_ONE_COLUMN_MERGED = 0x1;
	AbstractColumnChartRender.MODE_STACKED = 0x2 | AbstractColumnChartRender.MODE_ONE_COLUMN_MERGED;
	AbstractColumnChartRender.MODE_PERCENT_STACKED = 0x4 | AbstractColumnChartRender.MODE_STACKED;
	AbstractColumnChartRender.MODE_OVERLAP = 0x8 | AbstractColumnChartRender.MODE_ONE_COLUMN_MERGED;
	
	function AbstractYNXSType()
	{
		var _this = this;
		
		var divideLeftBottomAxis = function(oGraphics, oNumberRulerHelper, iUsableWidth, iUsableHeight)
		{
			var iAllWidth = (iUsableWidth === undefined ? oGraphics.getWidth() : iUsableWidth);
			var iAllHeight = (iUsableHeight === undefined ? oGraphics.getHeight() : iUsableHeight);
			
			var iSuggestLeftWidth = _this.protectedSuggestYAxisWidth(oGraphics, oNumberRulerHelper);
			var iLeftMinWidth = 40;
			var iLeftMaxWidth = iAllWidth * 0.382;
			var iLeftWidth = Math.max(iLeftMinWidth, Math.min(iLeftMaxWidth, iSuggestLeftWidth));
			var iMainWidth = iAllWidth - iLeftWidth;
			
			var iSuggestBottomHeight = _this.protectedSuggestXAxisHeight(oGraphics, iMainWidth);
			var iBottomMinHeight = 24;
			var iBottomMaxHeight = iAllHeight * 0.382;
			var iBottomHeight = Math.max(iBottomMinHeight, Math.min(iBottomMaxHeight, iSuggestBottomHeight));
			var iMainHeight = iAllHeight - iBottomHeight;
			
			return [iLeftWidth, iBottomHeight, iMainWidth, iMainHeight];
		}
		this.protectedSuggestYAxisWidth = function(oGraphics, oNumberRulerHelper)
		{
			throw new Error("Implement");
		}
		this.protectedSuggestXAxisHeight = function(oGraphics, iMainWidth)
		{
			throw new Error("Implement");
		}
		
		if(!this.protectedMethod)
		{
			this.protectedMethod = {};
		}
		this.protectedMethod["divideLeftBottomAxis"] = divideLeftBottomAxis;
	}
	
	function AbstractXNYSType()
	{
		var _this = this;
		
		var divideBottomLeftAxis = function(oGraphics, oNumberRulerHelper)
		{
			var iAllWidth = oGraphics.getWidth();
			var iAllHeight = oGraphics.getHeight();
			
			var iSuggestBottomHeight = _this.protectedSuggestHAxisHeight(oNumberRulerHelper);
			var iBottomMinHeight = 24;
			var iBottomMaxHeight = iAllHeight * 0.382;
			var iBottomHeight = Math.max(iBottomMinHeight, Math.min(iBottomMaxHeight, iSuggestBottomHeight));
			var iMainHeight = iAllHeight - iBottomHeight;
			
			var numLeftPerferredMaxWidth = iAllWidth * 0.3;
			var iSuggestLeftWidth = _this.protectedSuggestVAxisWidth(oGraphics, iMainHeight, numLeftPerferredMaxWidth);
			var iLeftMinWidth = Math.max(42, iAllWidth * 0.05);
			var iLeftMaxWidth = iAllWidth * 0.382;
			var iLeftWidth = Math.max(iLeftMinWidth, Math.min(iLeftMaxWidth, iSuggestLeftWidth));
			var iMainWidth = iAllWidth - iLeftWidth;
			
			return [iLeftWidth, iBottomHeight, iMainWidth, iMainHeight];
		}
		this.protectedSuggestHAxisHeight = function(oNumberRulerHelper)
		{
			throw new Error("Implement");
		}
		this.protectedSuggestVAxisWidth = function(oGraphics, iMainHeight, numLeftPerferredMaxWidth)
		{
			throw new Error("Implement");
		}
		
		if(!this.protectedMethod)
		{
			this.protectedMethod = {};
		}
		this.protectedMethod["divideBottomLeftAxis"] = divideBottomLeftAxis;
	}
	
	/** 完整柱图（纵向）绘制器 */
	function VColumnChartRender(oCtx, oModel, oAttr)
	{
		AbstractColumnChartRender.call(this, oCtx, oModel, oAttr);
		AbstractYNXSType.call(this);
		var _this = this;
		var _super = this.protectedMethod;
		
		//@Implement AbstractColumnChartRender
		this.protectedDivideParts = function(oGraphics, oNumberRulerHelper)
		{
			return _super.divideLeftBottomAxis(oGraphics, oNumberRulerHelper);
		}
		//@Implement AbstractYNXSType
		this.protectedSuggestYAxisWidth = function(oGraphics, oNumberRulerHelper)
		{
			var sYAxisFormatString = _super.getNumberAxisFormat(); 
			var sYAxisTitle = _super.getAttr().getYUnitText();
			return oNumberRulerHelper.suggestVerticalRulerWidth(oGraphics, sYAxisFormatString, sYAxisTitle);
		}
		//@Implement AbstractYNXSType
		this.protectedSuggestXAxisHeight = function(oGraphics, iMainWidth)
		{
			var oStyleTool = _super.getStyleTool();
			var arrCategory = _super.getModel().getCategories();
			var numPixelPerCategory =  iMainWidth / arrCategory.length;
			return YNXSPainter.suggestCategoryAxisHeight(oStyleTool, oGraphics, numPixelPerCategory, arrCategory);
		}
		
		//@Implement AbstractColumnChartRender
		this.protectedConfirmRulerMark = function(oDrawingContext)
		{
			oDrawingContext.getNumberRulerHelper().confirmVerticalRulerMark(oDrawingContext.getMainHeight());
		}
		
		//@Implement AbstractColumnChartRender
		this.protectedTransformCoordinate = function(oGraphics, oDrawingContext)
		{
			var oScopeAdapter = oDrawingContext.getScopeAdapter();
			var iApiX = oDrawingContext.getLeftAxisWidth();
			var iApiY = 0;
			var numPixelPerValue = CoordinateTransformer.verticalNumberAxis(oGraphics, 
					iApiX, iApiY, oDrawingContext.getMainHeight(), oScopeAdapter, getShrinkForTopAlways(), getShrinkForDataLabel());
			return numPixelPerValue;
		}
		
		//@Implement AbstractColumnChartRender
		this.protectedDrawChart = function(oGraphics, oDrawingContext)
		{
			var oScopeAdapter = oDrawingContext.getScopeAdapter();
			var numPixelPerValue = oDrawingContext.getPixelPerValue();
			var iShrinkForLabel = getShrinkForDataLabel();
			var arrYPair = YNXSPainter.confirmNumberAxis(numPixelPerValue, iShrinkForLabel, oScopeAdapter, _super.getStyleTool(), _super.getAttr());
			var numPixelMinY = arrYPair[0];
			var numPixelMaxY = arrYPair[1];
			_this.getDrawingModel().setPixelMinY(numPixelMinY);
			_this.getDrawingModel().setPixelMaxY(numPixelMaxY);
			
			var sFormatString = _super.getNumberAxisFormat(); 
			var sAxisTitle = _super.getAttr().getYUnitText();
			var iAxisWidth = oDrawingContext.getLeftAxisWidth();
			var iAssistantLineLen = oDrawingContext.getMainWidth();
			oDrawingContext.getNumberRulerHelper().drawLeftNumberAxisWithAssistantLine(
					oGraphics, iAxisWidth, numPixelPerValue, sFormatString, sAxisTitle, iAssistantLineLen);
			
			var arrCategory = _super.getModel().getCategories();
			var iCategoryAxisWidth = oDrawingContext.getMainWidth();
			var iCategoryAxisHeight = oDrawingContext.getBottomAxisHeight();
			var numPixelPerCategory =  iCategoryAxisWidth / arrCategory.length;
			_this.getDrawingModel().setPixelPerCategory(numPixelPerCategory);
			
			_super.drawMain(oDrawingContext);
			
			YNXSPainter.drawCategoryAxis(arrCategory, 
					function(iCategoryIndex, sSide)
					{
						var numCategoryX = numPixelPerCategory * iCategoryIndex;
						var numCategoryWith = numPixelPerCategory;
						return numCategoryX + (sSide == "center" ? numCategoryWith / 2 : 0);
					}, 
					_super.getStyleTool(), oGraphics, iCategoryAxisWidth, iCategoryAxisHeight, numPixelPerCategory, numPixelMinY);
			
			_super.drawRefline(true, oDrawingContext, iCategoryAxisWidth);
			
			_super.drawDataLabel(dataLabelLogicXYConfirmer, oDrawingContext);
		}
		
		var dataLabelLogicXYConfirmer = function(numValue, iTextWidth, numX1, numY1, numX2, numY2)
		{
			var iFontSize = Util.getDataLabelFontSize(_super.getStyleTool());
			var numY;
			if(_super.isStackedMode())
			{
				if(!_super.getAttr().isDataLabelOverlappable() && Math.abs(numY2 - numY1) < iFontSize)
				{
					return null;
				}
				numY = numY1 + (numY2 - numY1) * 0.5;
			}
			else
			{
				var iNegativeParam = (numValue < 0 ? -1 : 1);
				numY = numY2 + iNegativeParam * iFontSize * 0.7;
			}
			var numX = (numX1 + numX2 - iTextWidth) / 2;
			return [numX, numY];
		}
		
		var getShrinkForTopAlways = function()
		{
			return YNXSPainter.getShrinkForTopAlways(_super.getStyleTool(), _super.getAttr());
		}
		
		var getShrinkForDataLabel = function()
		{
			return (!_super.isStackedMode() && _super.getAttr().isShowDataLabel() ? parseInt(Util.getDataLabelFontSize(_super.getStyleTool()) * 1.25) : 0);
		}
		
		//@Implement AbstractColumnChartRender
		this.protectedGetNumberAxisFormat = function()
		{
			return _super.getAttr().getYFormat();
		}
		
		//@Implement AbstractColumnChartRender
		this.protectedCreateScopeAdapter = function(oScope)
		{
			if(_super.isStackedMode())
			{
				return new RulerScaleAdapter(oScope);
			}
			else
			{
				return new RulerScaleAdapter(oScope, _super.getAttr().getYRulerScale(), _super.getAttr().getYRulerStart());
			}
		}
	}
	VColumnChartRender.MODE_STACKED = AbstractColumnChartRender.MODE_STACKED;
	VColumnChartRender.MODE_PERCENT_STACKED = AbstractColumnChartRender.MODE_PERCENT_STACKED;
	
	/** 完整条形图（横向）绘制器 */
	function HColumnChartRender(oCtx, oModel, oAttr)
	{
		AbstractColumnChartRender.call(this, oCtx, oModel, oAttr);
		AbstractXNYSType.call(this);
		var _this = this;
		var _super = this.protectedMethod;
		
		//@Implement AbstractColumnChartRender
		this.protectedDivideParts = function(oGraphics, oNumberRulerHelper)
		{
			return _super.divideBottomLeftAxis(oGraphics, oNumberRulerHelper);
		}
		//@Implement AbstractXNYSType
		this.protectedSuggestHAxisHeight = function(oNumberRulerHelper)
		{
			var sYAxisTitle = _super.getAttr().getXUnitText();
			var bWithAxisTitle = (sYAxisTitle ? true : false);
			return oNumberRulerHelper.suggestHorizontalRulerHeight(bWithAxisTitle);
		}
		//@Implement AbstractXNYSType
		this.protectedSuggestVAxisWidth = function(oGraphics, iMainHeight, numLeftPerferredMaxWidth)
		{
			var oStyleTool = _super.getStyleTool();
			var arrCategory = _super.getModel().getCategories();
			var numPixelPerCategory =  iMainHeight / arrCategory.length;
			return XNYSPainter.suggestCategoryAxisWidth(oStyleTool, oGraphics, numPixelPerCategory, arrCategory, numLeftPerferredMaxWidth);
		}
		
		//@Implement AbstractColumnChartRender
		this.protectedConfirmRulerMark = function(oDrawingContext)
		{
			oDrawingContext.getNumberRulerHelper().confirmHorizontalRulerMark(oDrawingContext.getMainWidth());
		}
		
		//@Implement AbstractColumnChartRender
		this.protectedTransformCoordinate = function(oGraphics, oDrawingContext)
		{
			var oScopeAdapter = oDrawingContext.getScopeAdapter();
			var iApiX = oDrawingContext.getLeftAxisWidth();
			var iApiY = 0;
			var numPixelPerValue = CoordinateTransformer.horizontalNumberAxis(oGraphics, 
					iApiX, iApiY, oDrawingContext.getMainWidth() - 5, oScopeAdapter, getShrinkForTopAlways(), 0, 0);
			return numPixelPerValue;
		}
		
		//@Implement AbstractColumnChartRender
		this.protectedDrawChart = function(oGraphics, oDrawingContext)
		{
			var oScopeAdapter = oDrawingContext.getScopeAdapter();
			var numPixelPerValue = oDrawingContext.getPixelPerValue();
			var arrYPair = XNYSPainter.confirmNumberAxis(numPixelPerValue, oScopeAdapter);
			var numPixelMinY = arrYPair[0];
			var numPixelMaxY = arrYPair[1];
			_this.getDrawingModel().setPixelMinY(numPixelMinY);
			_this.getDrawingModel().setPixelMaxY(numPixelMaxY);
			
			var arrCategory = _super.getModel().getCategories();
			var iCategoryAxisWidth = oDrawingContext.getLeftAxisWidth();
			var iCategoryAxisHeight = oDrawingContext.getMainHeight() - getShrinkForTopAlways();
			var numPixelPerCategory =  iCategoryAxisHeight / arrCategory.length;
			_this.getDrawingModel().setPixelPerCategory(numPixelPerCategory);
			
			var sFormatString = _super.getNumberAxisFormat(); 
			var sAxisTitle = _super.getAttr().getXUnitText();
			oDrawingContext.getNumberRulerHelper().drawBottomNumberAxisWithAssistantLine(
					oGraphics, numPixelPerValue, sFormatString, sAxisTitle, iCategoryAxisHeight);
			
			_super.drawMain(oDrawingContext);
			
			XNYSPainter.drawLeftCategoryAxis(arrCategory, 
					function(iCategoryIndex)
					{
						var numCategoryX = numPixelPerCategory * iCategoryIndex;
						var numCategoryWith = numPixelPerCategory;
						return numCategoryX + numCategoryWith / 2;
					},
					_super.getStyleTool(), oGraphics, iCategoryAxisWidth, iCategoryAxisHeight, numPixelPerCategory, numPixelMinY);
			
			_super.drawRefline(false, oDrawingContext, iCategoryAxisHeight);
			
			_super.drawDataLabel(dataLabelLogicXYConfirmer, oDrawingContext);
		}
		
		var dataLabelLogicXYConfirmer = function(numValue, iTextWidth, numX1, numY1, numX2, numY2)
		{
			var numY;
			if(_super.isStackedMode())
			{
				if(!_super.getAttr().isDataLabelOverlappable() && Math.abs(numY2 - numY1) < iTextWidth)
				{
					return null;
				}
				numY = (numY2 + numY1 - iTextWidth) * 0.5;
			}
			else
			{
				var iOffset = (numValue < 0 ? -iTextWidth - 2 : 2);
				numY = numY2 + iOffset;
				var numPixelMinY = _this.getDrawingModel().getPixelMinY();
				var numPixelMaxY = _this.getDrawingModel().getPixelMaxY();
				(numY + iTextWidth > numPixelMaxY) && (numY = numPixelMaxY - iTextWidth - 1);
				(numY < numPixelMinY) && (numY = numPixelMinY + 1);
			}
			var numX = (numX1 + numX2) * 0.5;
			return [numX, numY];
		}
		
		var getShrinkForTopAlways = function()
		{
			return (_super.getAttr().isReserveRollOutSpace() ? 24 : 6);
		}
		
		//@Implement AbstractColumnChartRender
		this.protectedGetNumberAxisFormat = function()
		{
			return _super.getAttr().getXFormat();
		}
		
		//@Implement AbstractColumnChartRender
		this.protectedCreateScopeAdapter = function(oScope)
		{
			if(_super.isStackedMode())
			{
				return new RulerScaleAdapter(oScope);
			}
			else
			{
				return new RulerScaleAdapter(oScope, _super.getAttr().getXRulerScale(), _super.getAttr().getXRulerStart());
			}
		}
	}
	HColumnChartRender.MODE_STACKED = AbstractColumnChartRender.MODE_STACKED;
	HColumnChartRender.MODE_PERCENT_STACKED = AbstractColumnChartRender.MODE_PERCENT_STACKED;
	
	/** 组合图（多系列柱图+折线图）绘制器 */
	function CompositeChartRender(oCtx, oModel, oCompositeAttr)
	{
		var AXIS_LEFT = 0;
		var AXIS_RIGHT = 1;
		
		var _oCtx = oCtx;
		var _oModel = oModel;
		var _oColumnAttr;
		var _oLineAttr;
		var _arrSeriesLeftAxis = [];
		var _arrSeriesRightAxis = [];
		var _oSelectionModel;
		
		var _oColumnRender;
		var _oLineRender;
		
		var _iLeftAxisWidth;
		var _iMainWidth;
		var _iRightAxisWidth;
		var _iMainHeight;
		var _iBottomAxisHeight;
		
		(function()
		{
			var arrAttr = oCompositeAttr.splitTwoY();
			_oColumnAttr = arrAttr[0];
			_oLineAttr = arrAttr[1];
			_oColumnRender = new MyColumnRender(oCtx, oModel, _oColumnAttr);
			_oLineRender = new MyLineRender(oCtx, oModel, _oLineAttr);
			_oLineRender.setAxisIndex(AbstractLineChartRender.AXIS_RIGHT);
			
			var arrSeries = _oModel.getSeries();
			for(var i = 0; i < arrSeries.length; i++)
			{
				var oSeries = arrSeries[i];
				if(oSeries.getAxisIndex() == AXIS_LEFT)
				{
					_arrSeriesLeftAxis.push(oSeries);
				}
				else if(oSeries.getAxisIndex() == AXIS_RIGHT)
				{
					_arrSeriesRightAxis.push(oSeries);
				}
			}
		})();
		
		this.setSelectionModel = function(oSelectionModel)
		{
			_oSelectionModel = oSelectionModel;
			_oColumnRender.setSelectionModel(oSelectionModel);
		}
		
		var initCompositeContext = function()
		{
			var oNonoverlaper = null;
			if(_oColumnAttr.isShowDataLabel() || _oLineAttr.isShowDataLabel())
			{
				var iX = _iLeftAxisWidth - 8;
				var iY = 0;
				var iWidth = _iMainWidth + 16;
				var iHeight = _iMainHeight + 2;
				oNonoverlaper = new NonoverlappingConfirmer(iX, iY, iWidth, iHeight);
			}
			
			_oColumnRender.hookCompositeContext(
				new (function()
				{
					this.createNonoverlaper = function()
					{
						return oNonoverlaper;
					}
				})());
			_oLineRender.hookCompositeContext(
				new (function()
				{
					this.createNonoverlaper = function()
					{
						return oNonoverlaper;
					}
					
					this.isHumble = function(iCategoryIdx, iSeriesIdx)
					{
						if(_oSelectionModel && _oSelectionModel.isAnySelected())
						{
							var oCategory = _oModel.getCategories()[iCategoryIdx];
							var oSeries = _arrSeriesRightAxis[iSeriesIdx];
							return !_oSelectionModel.isSelected(oCategory, oSeries);
						}
						return false;
					}
				})());
		}
		
		this.drawChart = function(oHoverTarget)
		{
			var oGraphics = new Graphics(_oCtx);
			var iAllWidth = oGraphics.getWidth();
			var iAllHeight = oGraphics.getHeight();
			
			var iSuggestRightWidth = _oLineRender.suggestRightAxisWidth();
			var iRightMinWidth = 32;
			var iRightMaxWidth = iAllWidth * 0.25;
			_iRightAxisWidth = Math.max(iRightMinWidth, Math.min(iRightMaxWidth, iSuggestRightWidth));
			
			var iRemainWidth = iAllWidth - _iRightAxisWidth;
			var arrColumnDivided = _oColumnRender.myDivideParts(iRemainWidth, iAllHeight);
			_iLeftAxisWidth = arrColumnDivided[0];
			_iBottomAxisHeight = arrColumnDivided[1];
			_iMainWidth = arrColumnDivided[2];
			_iMainHeight = arrColumnDivided[3];
			
			initCompositeContext();
			
			var oHoverTarget1 = oHoverTarget;
			var oHoverTarget2 = oHoverTarget;
			if(oHoverTarget && oHoverTarget.inner().isHoveringRefline())
			{
				var bHoverSecondary = oHoverTarget.inner().isHoveringSecondaryAxisRefline();
				oHoverTarget1 = (bHoverSecondary ? null : oHoverTarget);
				oHoverTarget2 = (bHoverSecondary ? oHoverTarget : null);
			}
			
			_oColumnRender.drawChart(oHoverTarget1);
			_oLineRender.drawChart(oHoverTarget2);
		}
		
		this.getDrawingModel = function()
		{
			return _oColumnRender.getDrawingModel();
		}
		
		this.getDrawingRefline = function(oHoverTarget)
		{
			var oRender = (oHoverTarget.inner().isHoveringSecondaryAxisRefline() ? _oLineRender : _oColumnRender);
			return oRender.getDrawingModel().getRefline(oHoverTarget.getReflineIndex());
		}
		
		this.searchHoverTarget = function(iApiX, iApiY)
		{
			var oHoverTarget1 = _oColumnRender.searchHoverTarget(iApiX, iApiY);
			if(!oHoverTarget1.inner().isHoveringRefline())
			{
				var oHoverTarget2 = _oLineRender.searchHoverTarget(iApiX, iApiY);
				if(oHoverTarget2.inner().isHoveringRefline())
				{
					oHoverTarget2 = oHoverTarget2.inner().toSecondaryAxisRefline();
					return oHoverTarget2;
				}
			}
			return oHoverTarget1;
		}
		
		function MyColumnRender(oCtx, oModel, oAttr)
		{
			VColumnChartRender.call(this, oCtx, oModel, oAttr);
			var _super = this.protectedMethod;
			
			this.myDivideParts = function(iUsableWidth, iUsableHeight)
			{
				var oGraphics = _super.getGraphics();
				var oDrawingContext = _super.createDrawingContext();
				var oNumberRulerHelper = oDrawingContext.getNumberRulerHelper();
				return _super.divideLeftBottomAxis(oGraphics, oNumberRulerHelper, iUsableWidth, iUsableHeight);
			}
			//@Override VColumnChartRender
			this.protectedDivideParts = function(oGraphics, oNumberRulerHelper)
			{
				return [_iLeftAxisWidth, _iBottomAxisHeight, _iMainWidth, _iMainHeight];
			}
			
			//@Override AbstractColumnChartRender
			this.protectedGetSeries = function(oModel)
			{
				return _arrSeriesLeftAxis;
			}
		}
		
		function MyLineRender(oCtx, oModel, oAttr)
		{
			AbstractLineChartRender.call(this, oCtx, oModel, oAttr);
			var _this = this;
			var _super = this.protectedMethod;
			
			this.suggestRightAxisWidth = function()
			{
				var oGraphics = _super.getGraphics();
				var oDrawingContext = _super.createDrawingContext();
				var oNumberRulerHelper = oDrawingContext.getNumberRulerHelper();
				var sYAxisFormatString = getNumberAxisFormat();
				var sYAxisTitle = _super.getAttr().getYUnitText();
				return oNumberRulerHelper.suggestVerticalRulerWidth(oGraphics, sYAxisFormatString, sYAxisTitle);
			}
			
			//@Implement AbstractLineChartRender
			this.protectedDrawChart = function(oGraphics, oDrawingContext)
			{
				oDrawingContext.setMainRect(_iLeftAxisWidth, 0, _iMainWidth, _iMainHeight);
				var oNumberRulerHelper = oDrawingContext.getNumberRulerHelper();
				var oScopeAdapter = oDrawingContext.getScopeAdapter();
				var oDrawingModel = _this.getDrawingModel();
				
				_super.updateScopeWhenSmooth(oScopeAdapter);
				oNumberRulerHelper.confirmVerticalRulerMark(_iMainHeight);
				
				var iShrinkForTopAlways = getShrinkForTopAlways();
				var iShrinkForLabel = getShrinkForDataLabel();
				var iApiX = _iLeftAxisWidth;
				var iApiY = 0;
				var numPixelPerValue = CoordinateTransformer.verticalNumberAxis(oGraphics, 
						iApiX, iApiY, _iMainHeight, oScopeAdapter, iShrinkForTopAlways, iShrinkForLabel);
				oDrawingContext.setPixelPerValue(numPixelPerValue);
				
				var arrYPair = YNXSPainter.confirmNumberAxis(numPixelPerValue, iShrinkForLabel, oScopeAdapter, _super.getStyleTool(), _super.getAttr());
				var numPixelMinY = arrYPair[0];
				var numPixelMaxY = arrYPair[1];
				oDrawingModel.setPixelMinY(numPixelMinY);
				oDrawingModel.setPixelMaxY(numPixelMaxY);
				
				var sFormatString = getNumberAxisFormat(); 
				var sAxisTitle = _super.getAttr().getYUnitText();
				var iRightAxisX = _iMainWidth;
				oNumberRulerHelper.drawRightNumberAxisWithMark(
						oGraphics, iRightAxisX, _iRightAxisWidth, numPixelPerValue, sFormatString, sAxisTitle);
				
				oDrawingModel.setCategoryXCalculator(
					new (function()
					{
						this.getCategoryX = function(iCategoryIdx)
						{
							var numPixelPerCategory = _oColumnRender.getDrawingModel().getPixelPerCategory();
							return numPixelPerCategory * (iCategoryIdx + 0.5);
						}
						this.whichCategoryNeared = function(iLogicX)
						{
							return _oColumnRender.getDrawingModel().whichCategoryNeared(iLogicX);
						}
					})());
				_super.drawMain(oDrawingContext);
			}
			
			//@Override AbstractLineChartRender
			this.protectedCreateDataLabelFormater = function()
			{
				var oFormater = new NumberFormater();//为了与轴的格式一致，不用服务端格式化好的node.getText()，而是自己重新格式化。
				oFormater.setFormatString(_super.getAttr().getDataLabelFormat() || getNumberAxisFormat());
				return oFormater;
			}
			
			//@Override AbstractLineChartRender
			this.protectedGetSeries = function(oModel)
			{
				return _arrSeriesRightAxis;
			}
			
			var getShrinkForTopAlways = function()
			{
				return YNXSPainter.getShrinkForTopAlways(_super.getStyleTool(), _super.getAttr());
			}
			
			var getShrinkForDataLabel = function()
			{
				return (_super.getAttr().isShowDataLabel() ? parseInt(Util.getDataLabelFontSize(_super.getStyleTool()) * 1.25) : 0);
			}
			
			var getNumberAxisFormat = function()
			{
				var sFormatString = _super.getAttr().getYFormat();
				if(!sFormatString && _arrSeriesRightAxis.length > 0)
				{
					 sFormatString = _arrSeriesRightAxis[0].getFormatString();
				}
				return sFormatString;
			}
		}
	}
	
	/** 折线图绘制器基类 */
	function AbstractLineChartRender(oCtx, oModel, oAttr)
	{
		AbstractNSHoverable.call(this);
		var _this = this;
		var _super = this.protectedMethod;
		
		var _oGraphics = new Graphics(oCtx);
		var _oCompositeContext;
		
		var _oModel = oModel;
		var _oAttr = oAttr;
		var _oStyleTool = new StyleTool(oAttr);
		var _iAxisIndex = AbstractLineChartRender.AXIS_LEFT;
		
		var _oDrawingModel;
		var _oHoverTarget;
		
		this.searchHoverTarget = function(iApiX, iApiY)
		{
			var arrXY = _oGraphics.retransformMouseXY(iApiX, iApiY);
			return _super.searchHoverTarget(arrXY[0], arrXY[1], _oModel, _oDrawingModel);
		}
		
		this.getDrawingModel = function()
		{
			return _oDrawingModel;
		}
		
		this.setAxisIndex = function(iAxisIndex)
		{
			_iAxisIndex = iAxisIndex;
		}
		
		this.hookCompositeContext = function(oCompositeContext)
		{
			_oCompositeContext = oCompositeContext;
		}
		
		this.drawChart = function(oHoverTarget)
		{
			_oHoverTarget = oHoverTarget;
			_oDrawingModel = new DrawingModel();
			var oDrawingContext = createDrawingContext();
			_this.protectedDrawChart(_oGraphics, oDrawingContext);
		}
		this.protectedDrawChart = function(oGraphics, oDrawingContext)
		{
			throw new Error("Implement");
		}
		
		var updateScopeWhenSmooth = function(oScopeAdapter)
		{
			if(_oAttr.isSmooth() && !oScopeAdapter.isWithLog())
			{
				var numMaxY = -Infinity;
				var numMinY = Infinity;
				var bChecked = false;
				var funCheck = function(oLastPoint3, oLastPoint2, oLastPoint1, oPoint)
				{
					var numY1 = (oLastPoint3 ? oLastPoint3[1] : null);
					var numY2 = oLastPoint2[1];
					var numY3 = oLastPoint1[1];
					var numY4 = (oPoint ? oPoint[1] : null);
					var numDeltaYa = (numY1 === null ? 0 : (numY3 - numY1) / 6);
					var numDeltaYb = (numY4 === null ? 0 : (numY4 - numY2) / 6);
					var numCaY = numY2 + numDeltaYa;
					var numCbY = numY3 - numDeltaYb;
					numMaxY = Math.max(Math.max(numMaxY, numCaY), numCbY);
					numMinY = Math.min(Math.min(numMinY, numCaY), numCbY);
					bChecked = true;
				};
				visitModelForward(
					null,
					function(iCategoryIdx, oNode)
					{
						return [null, oNode.getValue()];
					},
					function(iSeriesIdx, iCategoryIdx, oLastPoint3, oLastPoint2, oLastPoint1, oPoint)
					{
						(oLastPoint1 && oLastPoint2) && funCheck(oLastPoint3, oLastPoint2, oLastPoint1, oPoint);
					},
					function(iSeriesIdx, oLastPoint3, oLastPoint2, oLastPoint1, oPoint)
					{
						(oLastPoint1 && oLastPoint2) && funCheck(oLastPoint3, oLastPoint2, oLastPoint1, oPoint);
					});
				if(bChecked)
				{
					oScopeAdapter.updateScopeMaxMin(
						(numMaxY > oScopeAdapter.getScopeMax() ? numMaxY : null), 
						(numMinY < oScopeAdapter.getScopeMin() ? numMinY : null));
				}
			}
		}
		
		var visitModel = function(bForward, funSeriesStart, funConfirmXY, funNodeHandler, funSeriesEnd)
		{
			var arrCategory = _oModel.getCategories();
			var arrSeries = getSuitableSeries();
			for(var iSeriesIdx = (bForward ? 0 : arrSeries.length - 1); 
					(bForward ? iSeriesIdx < arrSeries.length : iSeriesIdx >= 0); 
					(bForward ? iSeriesIdx++ : iSeriesIdx--))
			{
				var oSeries = arrSeries[iSeriesIdx];
				funSeriesStart && funSeriesStart(iSeriesIdx, oSeries);
				var oPoint = null;
				var oLastPoint1 = null;
				var oLastPoint2 = null;
				var oLastPoint3 = null;
				for(var iCategoryIdx = 0; iCategoryIdx < arrCategory.length; iCategoryIdx++)
				{
					var oNode = getNodeModel(iSeriesIdx, iCategoryIdx);
					if(oNode)
					{
						oPoint = funConfirmXY(iCategoryIdx, oNode);
						funNodeHandler(iSeriesIdx, iCategoryIdx, oLastPoint3, oLastPoint2, oLastPoint1, oPoint);
						oLastPoint3 = oLastPoint2;
						oLastPoint2 = oLastPoint1;
						oLastPoint1 = oPoint;
						oPoint = null;
					}
				}
				funSeriesEnd && funSeriesEnd(iSeriesIdx, oLastPoint3, oLastPoint2, oLastPoint1, oPoint);
			}
		}
		var visitModelForward = function(funSeriesStart, funConfirmXY, funNodeHandler, funSeriesEnd)
		{
			visitModel(true, funSeriesStart, funConfirmXY, funNodeHandler, funSeriesEnd);
		}
		var visitModelBackward = function(funSeriesStart, funConfirmXY, funNodeHandler, funSeriesEnd)
		{
			visitModel(false, funSeriesStart, funConfirmXY, funNodeHandler, funSeriesEnd);
		}
		
		var drawMain = function(oDrawingContext)
		{
			var bShowDataLabel = _oAttr.isShowDataLabel();
			var bPaintingPoint = _oAttr.isPaintingPoint() || bShowDataLabel;
			var bHover = _oHoverTarget && _oHoverTarget.getCategoryIndex() >= 0;
			drawLines(oDrawingContext);
			bPaintingPoint && drawPoints(oDrawingContext);
			drawRefline(oDrawingContext);
			bHover && drawHoverCategory(oDrawingContext, bPaintingPoint);
			bShowDataLabel && drawDataLabel(oDrawingContext);
		}
		
		var drawLines = function(oDrawingContext)
		{
			var bSortingSeries = getSuitableSeries().length > 1 && (_oAttr.isTooltipsSorted() || _oAttr.isShowDataLabel());
			var bLineDrew = false;
			_oGraphics.getContext().save();
			_oGraphics.getContext().lineWidth = 2.5;
			_oGraphics.getContext().lineJoin = "round";
			visitModelBackward(
				function(iSeriesIdx, oSeries)
				{
					setupSeriesColor(oSeries);
					bLineDrew = false;
				},
				function(iCategoryIdx, oNode)
				{
					return calculatePointXY(oDrawingContext, iCategoryIdx, oNode.getValue());
				},
				function(iSeriesIdx, iCategoryIdx, oLastPoint3, oLastPoint2, oLastPoint1, oPoint)
				{
					bSortingSeries && _oDrawingModel.sortSeries(iCategoryIdx, iSeriesIdx);
					bLineDrew = _oAttr.isSmooth() ? 
						paintSmoothLine(oLastPoint3, oLastPoint2, oLastPoint1, oPoint) : 
						paintHardLine(oLastPoint1, oPoint);
				},
				function(iSeriesIdx, oLastPoint3, oLastPoint2, oLastPoint1, oPoint)
				{
					_oAttr.isSmooth() && (bLineDrew = paintSmoothLine(oLastPoint3, oLastPoint2, oLastPoint1, oPoint));
					(!bLineDrew && oLastPoint1) && paintPoint(oLastPoint1, 3);
				});
			_oGraphics.getContext().restore();
		}
		
		var drawPoints = function(oDrawingContext)
		{
			visitModelBackward(
				function(iSeriesIdx, oSeries)
				{
					setupSeriesColor(oSeries);
				},
				function(iCategoryIdx, oNode)
				{
					return calculatePointXY(oDrawingContext, iCategoryIdx, oNode.getValue());
				},
				function(iSeriesIdx, iCategoryIdx, oLastPoint3, oLastPoint2, oLastPoint1, oPoint)
				{
					paintPoint(oPoint, 3);
				},
				null);
		}
		
		var drawRefline = function(oDrawingContext)
		{
			var arrPaintableLines = _oModel.getPaintableLines();
			var arrOneAxisPaintableLine = (arrPaintableLines ? arrPaintableLines[_iAxisIndex] : null);
			var iHoverIdx = (_oHoverTarget ? _oHoverTarget.getReflineIndex() : -1);
			var bRightSide = (_iAxisIndex == AbstractLineChartRender.AXIS_RIGHT);
			var arrDrawingRefline = ReflinePainter.drawHorizontalLines(arrOneAxisPaintableLine, iHoverIdx, 
					oDrawingContext.getScopeAdapter(), _oStyleTool, _oGraphics, 0, oDrawingContext.getMainWidth(), 
					oDrawingContext.getPixelPerValue(), _oDrawingModel.getPixelMaxY(), bRightSide);
			_oDrawingModel.setReflines(arrDrawingRefline);
			
			if(!bRightSide)
			{
				ReflinePainter.drawVGuidelines(
						_oModel.getGuidelines(), _oStyleTool, _oGraphics, _oDrawingModel.getPixelMinY(), _oDrawingModel.getPixelMaxY(), 
						function(iCategoryIndex)
						{
							return _oDrawingModel.getCategoryX(iCategoryIndex);
						});
			}
		}
		
		var drawHoverCategory = function(oDrawingContext, bMoreObvious)
		{
			var iCategoryIdx = _oHoverTarget.getCategoryIndex();
			if(_iAxisIndex == AbstractLineChartRender.AXIS_LEFT)
			{
				var iX = _oDrawingModel.getCategoryX(iCategoryIdx);
				_oGraphics.getContext().strokeStyle = HOVER_LINE_COLOR;
				_oGraphics.getContext().lineWidth = 1;
				_oGraphics.beginPath();
				_oGraphics.moveTo(iX, _oDrawingModel.getPixelMinY());
				_oGraphics.lineTo(iX, _oDrawingModel.getPixelMaxY());
				_oGraphics.stroke();
			}
			var arrSeries = getSuitableSeries();
			for(var iSeriesIdx = arrSeries.length - 1; iSeriesIdx >= 0; iSeriesIdx--)
			{
				var oSeries = arrSeries[iSeriesIdx];
				var oNode = getNodeModel(iSeriesIdx, iCategoryIdx);
				if(oNode)
				{
					setupSeriesColor(oSeries);
					var oPoint = calculatePointXY(oDrawingContext, iCategoryIdx, oNode.getValue());
					paintPoint(oPoint, (bMoreObvious ? 4 : 3));
				}
			}
		}
		
		var setupSeriesColor = function(oSeries)
		{
			var sColor = oSeries.getColor();
			sColor = (sColor ? sColor : DEFAULT_COLOR);
			_oGraphics.getContext().strokeStyle = sColor;
			_oGraphics.getContext().fillStyle = sColor;
		}
		
		var calculatePointXY = function(oDrawingContext, iCategoryIdx, numValue)
		{
			numValue = oDrawingContext.getScopeAdapter().scale(numValue);
			numValue = oDrawingContext.getScopeAdapter().cutFoot(numValue); 
			var numY = numValue * oDrawingContext.getPixelPerValue();
			var numX = _oDrawingModel.getCategoryX(iCategoryIdx);
			return [numX, numY];
		}
		
		var paintHardLine = function(oLastPoint, oPoint)
		{
			if(oLastPoint && oPoint)
			{
				_oGraphics.beginPath();
				_oGraphics.moveTo(oPoint[0], oPoint[1]);
				_oGraphics.lineTo(oLastPoint[0], oLastPoint[1]);
				_oGraphics.stroke();
				return true;
			}
			return false;
		}
		
		//绘制oLastPoint2到oLastPoint1之间的曲线
		var paintSmoothLine = function(oLastPoint3, oLastPoint2, oLastPoint1, oPoint)
		{
			if(!oLastPoint1 || !oLastPoint2)
			{
				return false;
			}
			var numX1 = (oLastPoint3 ? oLastPoint3[0] : null);
			var numY1 = (oLastPoint3 ? oLastPoint3[1] : null);
			var numX2 = oLastPoint2[0];
			var numY2 = oLastPoint2[1];
			var numX3 = oLastPoint1[0];
			var numY3 = oLastPoint1[1];
			var numX4 = (oPoint ? oPoint[0] : null);
			var numY4 = (oPoint ? oPoint[1] : null);
			
			var numDeltaXa = (numX1 === null ? 0 : (numX3 - numX1) / 6);
			var numDeltaYa = (numY1 === null ? 0 : (numY3 - numY1) / 6);
			var numDeltaXb = (numX4 === null ? 0 : (numX4 - numX2) / 6);
			var numDeltaYb = (numY4 === null ? 0 : (numY4 - numY2) / 6);
			var numDistributionDeltaX = numX3 - numX2;
			var numTotalDeltaX = numDeltaXa + numDeltaXb;
			if(numTotalDeltaX > numDistributionDeltaX)
			{
				var numRatio = numDistributionDeltaX / numTotalDeltaX;
				numDeltaXa *= numRatio;
				numDeltaXb *= numRatio;
				numDeltaYa *= numRatio;
				numDeltaYb *= numRatio;
			}
			var numCaX = numX2 + numDeltaXa;
			var numCaY = numY2 + numDeltaYa;
			var numCbX = numX3 - numDeltaXb;
			var numCbY = numY3 - numDeltaYb;
			
			_oGraphics.beginPath();
			_oGraphics.moveTo(numX2, numY2);
			_oGraphics.bezierCurveTo(numCaX, numCaY, numCbX, numCbY, numX3, numY3);
			_oGraphics.stroke();
			return true;
		}
		
		var paintPoint = function(oPoint, numRadius)
		{
			_oGraphics.getContext().save();
			_oGraphics.getContext().strokeStyle = _oStyleTool.getBackgroundColor();
			_oGraphics.getContext().lineWidth = 1;
			_oGraphics.beginPath();
			_oGraphics.arc(oPoint[0], oPoint[1], numRadius, 0, Math.PI * 2);
			_oGraphics.fill();
			_oGraphics.stroke();
			_oGraphics.getContext().restore();
		}
		
		var drawDataLabel = function(oDrawingContext)
		{
			var iFontSize = Util.getDataLabelFontSize(_oStyleTool);
			var sLabelColor = Util.getDataLabelColor(_oStyleTool);
			var oCtx = _oGraphics.getContext();
			oCtx.fillStyle = sLabelColor;
			oCtx.textBaseline = "middle";
			Util.setupFont(oCtx, iFontSize);
			var numTextHeight = iFontSize;
			oDrawingContext.bindLabelFormater(_this.protectedCreateDataLabelFormater());
			oDrawingContext.initHumbleChecker(sLabelColor);
			var bSingleSeries = (getSuitableSeries().length == 1);
			for(var iCategoryIdx = 0; iCategoryIdx < _oModel.getCategories().length; iCategoryIdx++)
			{
				if(bSingleSeries)
				{
					drawSingleSeriesDataLabel(oDrawingContext, iCategoryIdx, numTextHeight);
				}
				else
				{
					drawMultiSeriesDataLabel(oDrawingContext, iCategoryIdx, numTextHeight);
				}
			}
		}
		this.protectedCreateDataLabelFormater = function()
		{
			return null;
		}
		
		var drawSingleSeriesDataLabel = function(oDrawingContext, iCategoryIdx, numTextHeight)
		{
			var iSeriesIdx = 0;
			var oNode = getNodeModel(iSeriesIdx, iCategoryIdx);
			if(oNode)
			{
				var numValue = oNode.getValue();
				var arrPriorClock = [0, 6];
				var oNodeBefore = (iCategoryIdx == 0 ? null : getNodeModel(iSeriesIdx, iCategoryIdx - 1));
				if(oNodeBefore)
				{
					var numValueBefore = oNodeBefore.getValue();
					(numValue < numValueBefore) && (arrPriorClock = [6, 0]); 
				}
				paintDataLabel(oDrawingContext, iCategoryIdx, iSeriesIdx, oNode, numTextHeight, arrPriorClock);
			}
		}
		
		var drawMultiSeriesDataLabel = function(oDrawingContext, iCategoryIdx, numTextHeight)
		{
			var arrSeriesIdx = _oDrawingModel.getSeriesOrder(iCategoryIdx);
			if(arrSeriesIdx)
			{
				var arrPriorClock = [0, 6];
				var iSeriesIdx = arrSeriesIdx[0];
				paintDataLabel(oDrawingContext, iCategoryIdx, iSeriesIdx, null, numTextHeight, arrPriorClock);
				if(arrSeriesIdx.length > 1)//优先max/min
				{
					var arrPriorClock = [6, 0];
					var iSeriesIdx = arrSeriesIdx[arrSeriesIdx.length - 1];
					paintDataLabel(oDrawingContext, iCategoryIdx, iSeriesIdx, null, numTextHeight, arrPriorClock);
				}
				if(arrSeriesIdx.length > 2)
				{
					var arrPriorClock = [0, 6];
					for(var j = 1; j < arrSeriesIdx.length - 1; j++)
					{
						var iSeriesIdx = arrSeriesIdx[j];
						paintDataLabel(oDrawingContext, iCategoryIdx, iSeriesIdx, null, numTextHeight, arrPriorClock);
					}
				}
			}
		}
		
		var paintDataLabel = function(oDrawingContext, iCategoryIdx, iSeriesIdx, oNode, numTextHeight, arrPriorClock)
		{
			(!oNode) && (oNode = getNodeModel(iSeriesIdx, iCategoryIdx));
			var oPoint = calculatePointXY(oDrawingContext, iCategoryIdx, oNode.getValue());
			var sLabel = oDrawingContext.formatLabel(oNode);
			var numTextWidth = _oGraphics.getContext().measureText(sLabel).width;
			var iMainLeft = oDrawingContext.getMainX();
			var iMainRight = iMainLeft + oDrawingContext.getMainWidth();
			for(var i = 0; i < arrPriorClock.length; i++)
			{
				var numX = oPoint[0] - numTextWidth * 0.5;
				var numY = oPoint[1];
				(arrPriorClock[i] == 0) && (numY = numY + numTextHeight * 0.5 + 2);
				(arrPriorClock[i] == 6) && (numY = numY - numTextHeight * 0.5 - 4);
				
				var arrApiXY = _oGraphics.transformXY(numX, numY);
				var numApiX = arrApiXY[0];
				var numApiY = arrApiXY[1];
				numApiX = (numApiX < iMainLeft ? iMainLeft : (numApiX + numTextWidth > iMainRight ? iMainRight - numTextWidth : numApiX));
				var bCanDraw = (_oAttr.isDataLabelOverlappable() ? true :
						oDrawingContext.getNonoverlaper().isRectCanDraw(numApiX, numApiY - numTextHeight * 0.5, numTextWidth, numTextHeight));
				if(bCanDraw)
				{
					if(oDrawingContext.isHumbleAndChangingStyle(iCategoryIdx, iSeriesIdx))
					{
						_oGraphics.getContext().fillText(sLabel, numApiX, numApiY);
					}
					else
					{
						Util.drawTextWithShadow(_oStyleTool, _oGraphics.getContext(), sLabel, numApiX, numApiY);
					}
					break;
				}
			}
		}
		
		var createDrawingContext = function()
		{
			var oDrawingContext = new DrawingContext();
			var oScopeAdapter = createScopeAdapter();
			var oNumberRulerHelper = new NumberRulerHelper(oScopeAdapter, _oStyleTool);
			oDrawingContext.bind(oScopeAdapter, oNumberRulerHelper);
			return oDrawingContext;
		}
		
		var createScopeAdapter = function()
		{
			var oScope = _oModel.getScopes()[_iAxisIndex];
			var oScopeAdapter = new RulerScaleAdapter(oScope, _oAttr.getYRulerScale(), _oAttr.getYRulerStart());
			return oScopeAdapter;
		}
		
		var getSuitableSeries = function()
		{
			return _this.protectedGetSeries(_oModel);
		}
		this.protectedGetSeries = function(oModel)
		{
			return oModel.getSeries();
		}
		
		var getNodeModel = function(iSeriesIdx, iCategoryIdx)
		{
			var oSeries = getSuitableSeries()[iSeriesIdx];
			var arrNode = oSeries.getNodes();
			var oNode = (arrNode ? arrNode[iCategoryIdx] : null);
			if(!oNode || isNaN(oNode.getValue()))
			{
				oNode = null;
				if(_oAttr.isZeroInsteadNull())
				{
					oNode = new Node();
					oNode.setValue(0);
					oNode.setText("0");
				}
			}
			return oNode;
		}
		
		var createCategoryXCalculator = function(iCategoryAxisWidth, iCategoryCount)
		{
			return new CategoryXCalculator(iCategoryAxisWidth, iCategoryCount);
		}
		
		/** 绘制过程的计算结果，绘制完成即丢。 */
		function DrawingContext()
		{
			var _oScopeAdapter;
			var _oNumberRulerHelper;
			var _numPixelPerValue;
			var _iMainX;
			var _iMainY;
			var _iMainWidth;
			var _iMainHeight;
			var _oNonoverlap;
			var _oLabelFormater;
			var _funHumbleChecker;
			
			this.bind = function(oScopeAdapter, oNumberRulerHelper)
			{
				_oScopeAdapter = oScopeAdapter;
				_oNumberRulerHelper = oNumberRulerHelper;
			}
			this.getScopeAdapter = function()
			{
				return _oScopeAdapter;
			}
			this.getNumberRulerHelper = function()
			{
				return _oNumberRulerHelper;
			}
			
			this.setPixelPerValue = function(numPixelPerValue)
			{
				_numPixelPerValue = numPixelPerValue;
			}
			this.getPixelPerValue = function()
			{
				return _numPixelPerValue;
			}
			
			this.setMainRect = function(iMainX, iMainY, iMainWidth, iMainHeight)
			{
				_iMainX = iMainX;
				_iMainY = iMainY;
				_iMainWidth = iMainWidth;
				_iMainHeight = iMainHeight;
			}
			this.getMainX = function()
			{
				return _iMainX;
			}
			this.getMainWidth = function()
			{
				return _iMainWidth;
			}
			
			this.getNonoverlaper = function()
			{
				if(!_oNonoverlap)
				{
					_oNonoverlap = _oCompositeContext ? 
							_oCompositeContext.createNonoverlaper() : 
							new NonoverlappingConfirmer(_iMainX, _iMainY, _iMainWidth, _iMainHeight);
				}
				return _oNonoverlap;
			}
			
			this.bindLabelFormater = function(oLabelFormater)
			{
				_oLabelFormater = oLabelFormater;
			}
			this.formatLabel = function(oNode)
			{
				return _oLabelFormater ? _oLabelFormater.format(oNode.getValue()) : oNode.getText();
			}
			
			this.initHumbleChecker = function(sLabelColor)
			{
				var sHumbleLabelColor;
				_funHumbleChecker = (_oCompositeContext ? 
					function(iCategoryIdx, iSeriesIdx)
					{
						if(_oCompositeContext.isHumble(iCategoryIdx, iSeriesIdx))
						{
							!sHumbleLabelColor && (sHumbleLabelColor = Util.createColorWithAlpha(sLabelColor, 0.25));
							oCtx.fillStyle = sHumbleLabelColor;
							return true;
						}
						else if(sHumbleLabelColor)
						{
							oCtx.fillStyle = sLabelColor;
						}
						return false;
					} 
					: null);
			}
			this.isHumbleAndChangingStyle = function(iCategoryIdx, iSeriesIdx)
			{
				return _funHumbleChecker ? _funHumbleChecker(iCategoryIdx, iSeriesIdx) : false;
			}
		}
		
		/** 绘制过程的计算结果，由于交互时有用而保留。 */
		function DrawingModel()
		{
			var _oCategoryXCalculator;
			var _numPixelMinY;
			var _numPixelMaxY;
			var _arrRefline;
			var _arrEachCategorySorted;//每个类别里头，系列从大到小
			
			this.setPixelMinY = function(numValue){_numPixelMinY = numValue;}
			this.getPixelMinY = function(){return _numPixelMinY;}
			
			this.setPixelMaxY = function(numValue){_numPixelMaxY = numValue;}
			this.getPixelMaxY = function(){return _numPixelMaxY;}
			
			this.setCategoryXCalculator = function(oCategoryXCalculator)
			{
				_oCategoryXCalculator = oCategoryXCalculator;
			}
			this.getCategoryX = function(iCategoryIdx)
			{
				return _oCategoryXCalculator.getCategoryX(iCategoryIdx);
			}
			this.whichCategoryNeared = function(iLogicX)
			{
				return _oCategoryXCalculator.whichCategoryNeared(iLogicX);
			}
			
			this.setReflines = function(arrDrawingRefline)
			{
				_arrRefline = arrDrawingRefline;
			}
			this.getReflineCount = function()
			{
				return (_arrRefline ? _arrRefline.length : 0);
			}
			this.getRefline = function(iIdx)
			{
				return _arrRefline[iIdx];
			}
			
			this.sortSeries = function(iCategoryIdx, iSeriesIdx)
			{
				var oNode = getNodeModel(iSeriesIdx, iCategoryIdx);
				var numValue = oNode.getValue();
				(!_arrEachCategorySorted) && (_arrEachCategorySorted = []);
				var arrSortedSeriesIdx = _arrEachCategorySorted[iCategoryIdx];
				if(!arrSortedSeriesIdx)
				{
					arrSortedSeriesIdx = [];
					_arrEachCategorySorted[iCategoryIdx] = arrSortedSeriesIdx;
				}
				var bBingo = false;
				for(var i = 0; i < arrSortedSeriesIdx.length; i++)
				{
					var iComparingSeriesIdx = arrSortedSeriesIdx[i];
					var numComparingValue = getNodeModel(iComparingSeriesIdx, iCategoryIdx).getValue();
					if(numValue > numComparingValue)
					{
						bBingo = true;
						arrSortedSeriesIdx = arrSortedSeriesIdx.splice(i, 0, iSeriesIdx);
						break;
					}
				}
				if(!bBingo)
				{
					arrSortedSeriesIdx.push(iSeriesIdx);
				}
			}
			this.getSeriesOrder = function(iCategoryIdx)
			{
				return _arrEachCategorySorted ? _arrEachCategorySorted[iCategoryIdx] : null;
			}
			
			/** for tooltips */
			this.getNodeModel = function(iSeriesIdx, iCategoryIdx)
			{
				return getNodeModel(iSeriesIdx, iCategoryIdx);
			}
		}
		
		function CategoryXCalculator(iAxisWidth, iCategoryCount)
		{
			var _numHPadding;
			var _numCategoryDistance;
			(function()
			{
				_numHPadding = Math.min(iAxisWidth / iCategoryCount, iAxisWidth * 0.05);
				_numCategoryDistance = (iCategoryCount > 1 ? (iAxisWidth - _numHPadding * 2) / (iCategoryCount - 1) : 0);
			})();
			
			this.getCategoryX = function(iCategoryIdx)
			{
				return _numHPadding + _numCategoryDistance * iCategoryIdx;
			}
			this.whichCategoryNeared = function(iLogicX)
			{
				if(_numCategoryDistance == 0)
				{
					return (iCategoryCount == 1 ? 0 : -1);
				}
				else
				{
					var numNearedIdx = (iLogicX - _numHPadding + _numCategoryDistance * 0.5) / _numCategoryDistance;
					return (numNearedIdx < 0 ? -1 : parseInt(numNearedIdx));
				}
			}
		}
		
		_super.getGraphics = function(){return _oGraphics;}
		_super.getModel = function(){return _oModel;}
		_super.getAttr = function(){return _oAttr;}
		_super.getStyleTool = function(){return _oStyleTool;}
		_super.updateScopeWhenSmooth = updateScopeWhenSmooth;
		_super.createCategoryXCalculator = createCategoryXCalculator;
		_super.drawMain = drawMain;
		_super.createDrawingContext = createDrawingContext;
	}
	AbstractLineChartRender.AXIS_LEFT = 0;
	AbstractLineChartRender.AXIS_RIGHT = 1;
	
	/** 分片折线图绘制器，服务于棚架式，内容与横轴、纵轴分开绘制 */
	function SeparatedLineChartRender(oCtx, oModel, oAttr)
	{
		AbstractLineChartRender.call(this, oCtx, oModel, oAttr);
		var _this = this;
		var _super = this.protectedMethod;
		
		var transformCoordinate = function(oGraphics, iApiX, iApiY, iHeight, oScopeAdapter, arrYPair)
		{
			var iShrinkForLabel = (_super.getAttr().isShowDataLabel() ? 6 : 0);
			var iPadding = Math.max(14, Math.min(20, parseInt(iHeight * 0.05)));
			iApiY += iPadding;
			iHeight = iHeight - iPadding * 2;
			var numPixelPerValue = CoordinateTransformer.verticalNumberAxis(oGraphics, iApiX, iApiY, iHeight, oScopeAdapter, 0, iShrinkForLabel);
			if(arrYPair)
			{
				var numCeilingY = Math.max(0, oScopeAdapter.getScopeMax() * numPixelPerValue);
				var numFloorY = Math.min(0, oScopeAdapter.getScopeMin() * numPixelPerValue);
				arrYPair[0] = numFloorY - iPadding - iShrinkForLabel;
				arrYPair[1] = numCeilingY + iPadding + iShrinkForLabel;
			}
			return numPixelPerValue;
		}
		
		//@Implement AbstractLineChartRender
		this.protectedDrawChart = function(oGraphics, oDrawingContext)
		{
			oGraphics.clearAll();
			
			var oNumberRulerHelper = oDrawingContext.getNumberRulerHelper();
			var oScopeAdapter = oDrawingContext.getScopeAdapter();
			var oDrawingModel = _this.getDrawingModel();
			
			var iWidth = oGraphics.getWidth();
			var iHeight = oGraphics.getHeight();
			oDrawingContext.setMainRect(0, 0, iWidth, iHeight);
			
			_super.updateScopeWhenSmooth(oScopeAdapter);
			oNumberRulerHelper.confirmVerticalRulerMark(iHeight);
			
			var arrYPair = [];
			var numPixelPerValue = transformCoordinate(oGraphics, 0, 0, iHeight, oScopeAdapter, arrYPair);
			oDrawingContext.setPixelPerValue(numPixelPerValue);
			oDrawingModel.setPixelMinY(arrYPair[0]);
			oDrawingModel.setPixelMaxY(arrYPair[1]);
			
			oDrawingModel.setCategoryXCalculator(_super.createCategoryXCalculator(iWidth, _super.getModel().getCategories().length));
			_super.drawMain(oDrawingContext);
		}
		
		this.drawNumberAxis = function(sAxisTitle)
		{
			var oDrawingContext = _super.createDrawingContext();
			var oNumberRulerHelper = oDrawingContext.getNumberRulerHelper();
			var oScopeAdapter = oDrawingContext.getScopeAdapter();
			var oGraphics = _super.getGraphics();
			var iWidth = oGraphics.getWidth();
			var iHeight = oGraphics.getHeight();
			_super.updateScopeWhenSmooth(oScopeAdapter);
			oNumberRulerHelper.confirmVerticalRulerMark(iHeight);
			var numPixelPerValue = transformCoordinate(oGraphics, iWidth, 0, iHeight, oScopeAdapter, null);
			var sFormatString = _super.getModel().getSeries()[0].getFormatString();
			oNumberRulerHelper.drawLeftNumberAxisWithMark(oGraphics, iWidth, numPixelPerValue, sFormatString, null);
		}
		
		this.drawCategoryAxis = function()
		{
			var oGraphics = _super.getGraphics();
			var iWidth = oGraphics.getWidth();
			var iHeight = oGraphics.getHeight();
			oGraphics.setTransformMatrix(1, 0, 0, -1, 0, iHeight);
			var arrCategory = _super.getModel().getCategories();
			var oCategoryXCalculator = _super.createCategoryXCalculator(iWidth, arrCategory.length);
			YNXSPainter.drawTopContinueCategoryAxis(arrCategory,
					function(iCategoryIdx)
					{
						return oCategoryXCalculator.getCategoryX(iCategoryIdx);
					},
					_super.getStyleTool(), oGraphics, iWidth);
		}
	}
	
	/** 完整的折线图绘制器，包含轴、内容、图例 */
	function LineChartRender(oCtx, oModel, oAttr)
	{
		AbstractLineChartRender.call(this, oCtx, oModel, oAttr);
		AbstractYNXSType.call(this);
		var _this = this;
		var _super = this.protectedMethod;
		
		//@Implement AbstractYNXSType
		this.protectedSuggestYAxisWidth = function(oGraphics, oNumberRulerHelper)
		{
			var sYAxisFormatString = getNumberAxisFormat(); 
			var sYAxisTitle = _super.getAttr().getYUnitText();
			return oNumberRulerHelper.suggestVerticalRulerWidth(oGraphics, sYAxisFormatString, sYAxisTitle);
		}
		
		//@Implement AbstractYNXSType
		this.protectedSuggestXAxisHeight = function(oGraphics, iMainWidth)
		{
			return YNXSPainter.suggestContinueCategoryAxisHeight(_super.getStyleTool());
		}
		
		//@Implement AbstractLineChartRender
		this.protectedDrawChart = function(oGraphics, oDrawingContext)
		{
			oGraphics.clearAll();
			
			var oNumberRulerHelper = oDrawingContext.getNumberRulerHelper();
			var oScopeAdapter = oDrawingContext.getScopeAdapter();
			var oDrawingModel = _this.getDrawingModel();
			
			var arrDivided = _super.divideLeftBottomAxis(oGraphics, oNumberRulerHelper);
			var iLeftWidth = arrDivided[0];
			var iBottomHeight = arrDivided[1];
			var iMainWidth = arrDivided[2];
			var iMainHeight = arrDivided[3];
			oDrawingContext.setMainRect(iLeftWidth, 0, iMainWidth, iMainHeight);
			
			_super.updateScopeWhenSmooth(oScopeAdapter);
			oNumberRulerHelper.confirmVerticalRulerMark(iMainHeight);
			
			var iShrinkForTopAlways = getShrinkForTopAlways();
			var iShrinkForLabel = getShrinkForDataLabel();
			var iApiX = iLeftWidth;
			var iApiY = 0;
			var numPixelPerValue = CoordinateTransformer.verticalNumberAxis(oGraphics, 
					iApiX, iApiY, iMainHeight, oScopeAdapter, iShrinkForTopAlways, iShrinkForLabel);
			oDrawingContext.setPixelPerValue(numPixelPerValue);
			
			var arrYPair = YNXSPainter.confirmNumberAxis(numPixelPerValue, iShrinkForLabel, oScopeAdapter, _super.getStyleTool(), _super.getAttr());
			var numPixelMinY = arrYPair[0];
			var numPixelMaxY = arrYPair[1];
			oDrawingModel.setPixelMinY(numPixelMinY);
			oDrawingModel.setPixelMaxY(numPixelMaxY);
			
			var sFormatString = getNumberAxisFormat(); 
			var sAxisTitle = _super.getAttr().getYUnitText();
			var iAssistantLineLen = iMainWidth;
			oNumberRulerHelper.drawLeftNumberAxisWithAssistantLine(
					oGraphics, iLeftWidth, numPixelPerValue, sFormatString, sAxisTitle, iAssistantLineLen);
			
			var arrCategory = _super.getModel().getCategories();
			var iCategoryAxisWidth = iMainWidth;
			var iCategoryAxisHeight = iBottomHeight;
			oDrawingModel.setCategoryXCalculator(_super.createCategoryXCalculator(iCategoryAxisWidth, arrCategory.length));
			YNXSPainter.drawContinueCategoryAxis(arrCategory, 
					function(iCategoryIdx)
					{
						return oDrawingModel.getCategoryX(iCategoryIdx);
					},
					_super.getStyleTool(), oGraphics, iCategoryAxisWidth, iCategoryAxisHeight, numPixelMinY, -iLeftWidth);
			
			_super.drawMain(oDrawingContext);
		}
		
		//@Override AbstractLineChartRender
		this.protectedCreateDataLabelFormater = function()
		{
			var oFormater = new NumberFormater();//为了与轴的格式一致，不用服务端格式化好的node.getText()，而是自己重新格式化。
			oFormater.setFormatString(_super.getAttr().getDataLabelFormat() || getNumberAxisFormat());
			return oFormater;
		}
		
		var getShrinkForTopAlways = function()
		{
			return YNXSPainter.getShrinkForTopAlways(_super.getStyleTool(), _super.getAttr());
		}
		
		var getShrinkForDataLabel = function()
		{
			return (_super.getAttr().isShowDataLabel() ? parseInt(Util.getDataLabelFontSize(_super.getStyleTool()) * 1.25) : 0);
		}
		
		var getNumberAxisFormat = function()
		{
			var sFormatString = _super.getAttr().getYFormat();
			!sFormatString && (sFormatString = _super.getModel().getSeries()[0].getFormatString());
			return sFormatString;
		}
	}
	
	/** 面积图绘制器基类 */
	function AbstractAreaChartRender(oCtx, oModel, oAttr)
	{
		AbstractNSHoverable.call(this);
		var _this = this;
		var _super = this.protectedMethod;
		
		var _oGraphics = new Graphics(oCtx);
		
		var _oModel = oModel;
		var _oAttr = oAttr;
		var _oStyleTool = new StyleTool(oAttr);
		var _bPercentMode = false;
		
		var _oDrawingModel;
		var _oHoverTarget;
		
		this.setPercentMode = function(bPercentMode)
		{
			_bPercentMode = bPercentMode;
		}
		this.isPercentMode = function()
		{
			return _bPercentMode;
		}
		
		this.searchHoverTarget = function(iApiX, iApiY)
		{
			var arrXY = _oGraphics.retransformMouseXY(iApiX, iApiY);
			return _super.searchHoverTarget(arrXY[0], arrXY[1], _oModel, _oDrawingModel);
		}
		
		this.getDrawingModel = function()
		{
			!_oDrawingModel && (_oDrawingModel = new DrawingModel());
			return _oDrawingModel;
		}
		
		this.drawChart = function(oHoverTarget)
		{
			_oHoverTarget = oHoverTarget;
			_this.getDrawingModel();
			var oDrawingContext = createDrawingContext();
			_this.protectedDrawChart(_oGraphics, oDrawingContext);
		}
		this.protectedDrawChart = function(oGraphics, oDrawingContext)
		{
			throw new Error("Implement");
		}
		
		var drawMain = function(oDrawingContext)
		{
			preCalculate(oDrawingContext);
			drawArea(oDrawingContext);
			drawRefline(oDrawingContext);
			var bHover = _oHoverTarget && _oHoverTarget.getCategoryIndex() >= 0;
			bHover && drawHoverCategory(oDrawingContext);
			var bShowDataLabel = _oAttr.isShowDataLabel();
			bShowDataLabel && drawDataLabel(oDrawingContext);
		}
		
		var preCalculate = function(oDrawingContext)
		{
			var arrPositiveCumulated = [];
			var arrNegativeCumulated = [];
			var oFormater;
			if(_bPercentMode)
			{
				oFormater = new NumberFormater();
				oFormater.setFormatString(getNumberAxisFormat());
			}
			for(var iCategoryIdx = 0; iCategoryIdx < _oModel.getCategories().length; iCategoryIdx++)
			{
				var numScale = 1;
				if(_bPercentMode)
				{
					var numTotal = PercentModeCalculator.getCategoryTotal(_oModel, iCategoryIdx);
					numScale = (numTotal == 0 ? 0 : 1 / numTotal);
				}
				for(var iSeriesIdx = _oModel.getSeries().length - 1; iSeriesIdx >= 0; iSeriesIdx--)
				{
					var oNode = getNodeModel(iSeriesIdx, iCategoryIdx);
					var numValue = (oNode ? oNode.getValue() : 0);
					var arrCumulated = (numValue < 0 ? arrNegativeCumulated : arrPositiveCumulated);
					var arrCumulatedAtCategory = arrCumulated[iCategoryIdx];
					var numLastCumulatedPixel = 0;
					if(arrCumulatedAtCategory)
					{
						numLastCumulatedPixel = arrCumulatedAtCategory[arrCumulatedAtCategory.length - 1];
					}
					else
					{
						arrCumulatedAtCategory = [];
						arrCumulated[iCategoryIdx] = arrCumulatedAtCategory;
					}
					var numCumulatedPixel = numLastCumulatedPixel + numValue * oDrawingContext.getPixelPerValue() * numScale;
					arrCumulatedAtCategory.push(numCumulatedPixel);
					oDrawingContext.setCumulatedPixel(iCategoryIdx, iSeriesIdx, numCumulatedPixel);
					if(oFormater)
					{
						var sPercent = (!oNode ? "" : (numScale == 0 ? "---" : oFormater.format(numValue * numScale)));
						_oDrawingModel.setPercentage(iCategoryIdx, iSeriesIdx, sPercent);
					}
				}
			}
		}
		
		var drawArea = function(oDrawingContext)
		{
			var arrPositive = [];
			var arrNegative = [];
			var arrCategory = _oModel.getCategories();
			var arrSeries = _oModel.getSeries();
			var iMaxCategoryIdx = arrCategory.length - 1;
			var iMaxSeriesIdx = arrSeries.length - 1;
			for(var iSeriesIdx = iMaxSeriesIdx; iSeriesIdx >= 0; iSeriesIdx--)
			{
				setupSeriesColor(arrSeries[iSeriesIdx]);
				_oGraphics.beginPath();
				for(var iCategoryIdx = 0; iCategoryIdx <= iMaxCategoryIdx; iCategoryIdx++)
				{
					var numX = _oDrawingModel.getCategoryX(iCategoryIdx);
					var numY1 = oDrawingContext.getCumulatedPixel(iCategoryIdx, iSeriesIdx);
					var arrCumulated = (numY1 < 0 ? arrNegative : arrPositive);
					var numY2 = arrCumulated[iCategoryIdx];
					(!numY2) && (numY2 = 0);
					(iCategoryIdx == 0) ? _oGraphics.moveTo(numX, numY2) : _oGraphics.lineTo(numX, numY2);
				}
				for(var iCategoryIdx = iMaxCategoryIdx; iCategoryIdx >= 0; iCategoryIdx--)
				{
					var numX = _oDrawingModel.getCategoryX(iCategoryIdx);
					var numY1 = oDrawingContext.getCumulatedPixel(iCategoryIdx, iSeriesIdx);
					_oGraphics.lineTo(numX, numY1);
					var arrCumulated = (numY1 < 0 ? arrNegative : arrPositive);
					arrCumulated[iCategoryIdx] = numY1;
					if(_oAttr.isShowDataLabel())
					{
						var arrApiXY = _oGraphics.transformXY(numX, numY1);
						oDrawingContext.getNonoverlaper().setRectHasBeenDrawn(arrApiXY[0], arrApiXY[1], 1, 1);
					}
				}
				_oGraphics.closePath();
				(iMaxCategoryIdx > 0) ?_oGraphics.fill() : _oGraphics.stroke();
			}
		}
		
		var drawRefline = function(oDrawingContext)
		{
			var arrPaintableLines = _oModel.getPaintableLines();
			var arrOneAxisPaintableLine = (arrPaintableLines ? arrPaintableLines[0] : null);
			var iHoverIdx = (_oHoverTarget ? _oHoverTarget.getReflineIndex() : -1);
			var arrDrawingRefline = ReflinePainter.drawHorizontalLines(arrOneAxisPaintableLine, iHoverIdx, 
					oDrawingContext.getScopeAdapter(), _oStyleTool, _oGraphics, 0, oDrawingContext.getMainWidth(), 
					oDrawingContext.getPixelPerValue(), _oDrawingModel.getPixelMaxY());
			_oDrawingModel.setReflines(arrDrawingRefline);
			
			ReflinePainter.drawVGuidelines(
					_oModel.getGuidelines(), _oStyleTool, _oGraphics, _oDrawingModel.getPixelMinY(), _oDrawingModel.getPixelMaxY(), 
					function(iCategoryIndex)
					{
						return _oDrawingModel.getCategoryX(iCategoryIndex);
					});
		}
		
		var drawHoverCategory = function(oDrawingContext)
		{
			var iCategoryIdx = _oHoverTarget.getCategoryIndex();
			var numX = _oDrawingModel.getCategoryX(iCategoryIdx);
			_oGraphics.getContext().strokeStyle = HOVER_LINE_COLOR;
			_oGraphics.getContext().lineWidth = 1;
			_oGraphics.beginPath();
			_oGraphics.moveTo(numX, _oDrawingModel.getPixelMinY());
			_oGraphics.lineTo(numX, _oDrawingModel.getPixelMaxY());
			_oGraphics.stroke();
			
			var arrSeries = _oModel.getSeries();
			for(var iSeriesIdx = arrSeries.length - 1; iSeriesIdx >= 0; iSeriesIdx--)
			{
				var oSeries = arrSeries[iSeriesIdx];
				var oNode = getNodeModel(iSeriesIdx, iCategoryIdx);
				if(oNode)
				{
					setupSeriesColor(oSeries);
					var numY = oDrawingContext.getCumulatedPixel(iCategoryIdx, iSeriesIdx);
					_oGraphics.getContext().strokeStyle = _oStyleTool.getBackgroundColor();
					_oGraphics.beginPath();
					_oGraphics.arc(numX, numY, 3, 0, Math.PI * 2);
					_oGraphics.fill();
					_oGraphics.stroke();
				}
			}
		}
		
		var drawDataLabel = function(oDrawingContext)
		{
			var iFontSize = Util.getDataLabelFontSize(_oStyleTool);
			var sLabelColor = Util.getDataLabelColor(_oStyleTool);
			var oCtx = _oGraphics.getContext();
			oCtx.fillStyle = sLabelColor;
			oCtx.textBaseline = "middle";
			Util.setupFont(oCtx, iFontSize);
			var numHeight = iFontSize;
			var iMainLeft = oDrawingContext.getMainX();
			var iMainRight = iMainLeft + oDrawingContext.getMainWidth();
			if(!_bPercentMode)
			{
				var oFormater = new NumberFormater();
				oFormater.setFormatString(_oAttr.getDataLabelFormat() || getNumberAxisFormat());
				oDrawingContext.bindLabelFormater(oFormater);
			}
			for(var iCategoryIdx = 0; iCategoryIdx < _oModel.getCategories().length; iCategoryIdx++)
			{
				for(var iSeriesIdx = 0; iSeriesIdx < _oModel.getSeries().length; iSeriesIdx++)
				{
					var oNode = getNodeModel(iSeriesIdx, iCategoryIdx);
					if(oNode)
					{
						var sLabel = (_bPercentMode ? 
								_oDrawingModel.getPercentage(iCategoryIdx, iSeriesIdx) : 
								oDrawingContext.formatLabel(oNode));
						var numWidth = oCtx.measureText(sLabel).width;
						var numX = _oDrawingModel.getCategoryX(iCategoryIdx) - numWidth * 0.5;
						var numY = oDrawingContext.getCumulatedPixel(iCategoryIdx, iSeriesIdx);
						numY = numY - (numY < 0 ? -1 : 1) * numHeight;
						var arrApiXY = _oGraphics.transformXY(numX, numY);
						numX = arrApiXY[0];
						numY = arrApiXY[1];
						numX = (numX < iMainLeft ? iMainLeft : (numX + numWidth > iMainRight ? iMainRight - numWidth : numX));
						var bCanDraw = (_oAttr.isDataLabelOverlappable() ? true : 
								oDrawingContext.getNonoverlaper().isRectCanDraw(numX, numY - numHeight * 0.5, numWidth, numHeight));
						bCanDraw && Util.drawTextWithShadow(_oStyleTool, oCtx, sLabel, numX, numY);
					}
				}
			}
		}
		
		var setupSeriesColor = function(oSeries)
		{
			var sColor = oSeries.getColor();
			sColor = (sColor ? sColor : DEFAULT_COLOR);
			_oGraphics.getContext().strokeStyle = sColor;
			_oGraphics.getContext().fillStyle = sColor;
		}
		
		var createDrawingContext = function()
		{
			var oDrawingContext = new DrawingContext();
			var oScopeAdapter = createScopeAdapter();
			var oNumberRulerHelper = new NumberRulerHelper(oScopeAdapter, _oStyleTool);
			oDrawingContext.bind(oScopeAdapter, oNumberRulerHelper);
			return oDrawingContext;
		}
		
		var createScopeAdapter = function()
		{
			var oScope = _oModel.getScopes()[0];
			if(_bPercentMode)
			{
				var arrMaxCategoryPercent = PercentModeCalculator.getMaxCategoryPercent(_oModel);
				oScope.setMax(arrMaxCategoryPercent[0]);
				oScope.setMin(arrMaxCategoryPercent[1]);
			}
			var oScopeAdapter = new RulerScaleAdapter(oScope);
			return oScopeAdapter;
		}
		
		var getNodeModel = function(iSeriesIdx, iCategoryIdx)
		{
			var oSeries = _oModel.getSeries()[iSeriesIdx];
			var arrNode = oSeries.getNodes();
			var oNode = (arrNode ? arrNode[iCategoryIdx] : null);
			return (oNode && !isNaN(oNode.getValue()) ? oNode : null);
		}
		
		var getNumberAxisFormat = function()
		{
			var sFormatString = _oAttr.getYFormat();
			!sFormatString && (sFormatString = _oModel.getSeries()[0].getFormatString());
			return sFormatString;
		}
		
		function DrawingContext()
		{
			var _oScopeAdapter;
			var _oNumberRulerHelper;
			var _numPixelPerValue;
			var _iMainX;
			var _iMainY;
			var _iMainWidth;
			var _iMainHeight;
			var _arrCumulated = [];
			var _oNonoverlap;
			var _oLabelFormater;
			
			this.bind = function(oScopeAdapter, oNumberRulerHelper)
			{
				_oScopeAdapter = oScopeAdapter;
				_oNumberRulerHelper = oNumberRulerHelper;
			}
			this.getScopeAdapter = function()
			{
				return _oScopeAdapter;
			}
			this.getNumberRulerHelper = function()
			{
				return _oNumberRulerHelper;
			}
			
			this.setPixelPerValue = function(numPixelPerValue)
			{
				_numPixelPerValue = numPixelPerValue;
			}
			this.getPixelPerValue = function()
			{
				return _numPixelPerValue;
			}
			
			this.setMainRect = function(iMainX, iMainY, iMainWidth, iMainHeight)
			{
				_iMainX = iMainX;
				_iMainY = iMainY;
				_iMainWidth = iMainWidth;
				_iMainHeight = iMainHeight;
			}
			this.getMainX = function()
			{
				return _iMainX;
			}
			this.getMainWidth = function()
			{
				return _iMainWidth;
			}
			
			this.setCumulatedPixel = function(iCategoryIdx, iSeriesIdx, numCumulatedPixel)
			{
				var arrCumulatedAtCategory = _arrCumulated[iCategoryIdx];
				if(!arrCumulatedAtCategory)
				{
					arrCumulatedAtCategory = [];
					_arrCumulated[iCategoryIdx] = arrCumulatedAtCategory;
				}
				arrCumulatedAtCategory[iSeriesIdx] = numCumulatedPixel;
			}
			this.getCumulatedPixel = function(iCategoryIdx, iSeriesIdx)
			{
				return _arrCumulated[iCategoryIdx][iSeriesIdx];
			}
			
			this.getNonoverlaper = function()
			{
				(!_oNonoverlap) && (_oNonoverlap = new NonoverlappingConfirmer(_iMainX, _iMainY, _iMainWidth, _iMainHeight + 10));
				return _oNonoverlap;
			}
			
			this.bindLabelFormater = function(oLabelFormater)
			{
				_oLabelFormater = oLabelFormater;
			}
			this.formatLabel = function(oNode)
			{
				return _oLabelFormater ? _oLabelFormater.format(oNode.getValue()) : oNode.getText();
			}
		}
		
		function DrawingModel()
		{
			var _numPixelMinY;
			var _numPixelMaxY;
			var _oCategoryXCalculator;
			var _arrPercent;
			var _arrRefline;
			
			this.setPixelMinY = function(numValue){_numPixelMinY = numValue;}
			this.getPixelMinY = function(){return _numPixelMinY;}
			
			this.setPixelMaxY = function(numValue){_numPixelMaxY = numValue;}
			this.getPixelMaxY = function(){return _numPixelMaxY;}
			
			this.initCategoryXCalculator = function(iCategoryAxisWidth, iCategoryCount)
			{
				_oCategoryXCalculator = new CategoryXCalculator(iCategoryAxisWidth, iCategoryCount);
			}
			this.getCategoryX = function(iCategoryIdx)
			{
				return _oCategoryXCalculator.getCategoryX(iCategoryIdx);
			}
			this.whichCategoryNeared = function(iLogicX)
			{
				return _oCategoryXCalculator.whichCategoryNeared(iLogicX);
			}
			
			this.setPercentage = function(iCategoryIndex, iSeriesIndex, sText)
			{
				!_arrPercent && (_arrPercent = []);
				var arrPercentOfOneCategory = _arrPercent[iCategoryIndex];
				if(!arrPercentOfOneCategory)
				{
					arrPercentOfOneCategory = [];
					_arrPercent[iCategoryIndex] = arrPercentOfOneCategory;
				}
				arrPercentOfOneCategory[iSeriesIndex] = sText;
			}
			this.getPercentage = function(iCategoryIndex, iSeriesIndex)
			{
				var arrPercentOfOneCategory = (_arrPercent ? _arrPercent[iCategoryIndex] : null);
				return (arrPercentOfOneCategory ? arrPercentOfOneCategory[iSeriesIndex] : null);
			}
			this.isWithRatio = function()
			{
				return (_arrPercent ? true : false);
			}
			
			this.setReflines = function(arrDrawingRefline)
			{
				_arrRefline = arrDrawingRefline;
			}
			this.getReflineCount = function()
			{
				return (_arrRefline ? _arrRefline.length : 0);
			}
			this.getRefline = function(iIdx)
			{
				return _arrRefline[iIdx];
			}
			
			/** for tooltips */
			this.getNodeModel = function(iSeriesIdx, iCategoryIdx)
			{
				return getNodeModel(iSeriesIdx, iCategoryIdx);
			}
		}
		
		function CategoryXCalculator(iAxisWidth, iCategoryCount)
		{
			var _numHPadding;
			var _numCategoryDistance;
			(function()
			{
				_numHPadding = Math.min(iAxisWidth / iCategoryCount, iAxisWidth * 0.05);
				_numCategoryDistance = (iCategoryCount > 1 ? (iAxisWidth - _numHPadding * 2) / (iCategoryCount - 1) : 0);
			})();
			
			this.getCategoryX = function(iCategoryIdx)
			{
				return _numHPadding + _numCategoryDistance * iCategoryIdx;
			}
			this.whichCategoryNeared = function(iLogicX)
			{
				if(_numCategoryDistance == 0)
				{
					return (iCategoryCount == 1 ? 0 : -1);
				}
				else
				{
					var numNearedIdx = (iLogicX - _numHPadding + _numCategoryDistance * 0.5) / _numCategoryDistance;
					return (numNearedIdx < 0 ? -1 : parseInt(numNearedIdx));
				}
			}
		}
		
		_super.getGraphics = function(){return _oGraphics;}
		_super.getModel = function(){return _oModel;}
		_super.getAttr = function(){return _oAttr;}
		_super.getStyleTool = function(){return _oStyleTool;}
		_super.getNumberAxisFormat = getNumberAxisFormat;
		_super.drawMain = drawMain;
		_super.createDrawingContext = createDrawingContext;
	}
	
	/** 分片面积图绘制器，服务于棚架式，内容与横轴、纵轴分开绘制 */
	function SeparatedAreaChartRender(oCtx, oModel, oAttr)
	{
		AbstractAreaChartRender.call(this, oCtx, oModel, oAttr);
		var _this = this;
		var _super = this.protectedMethod;
		
		var transformCoordinate = function(oGraphics, iApiX, iApiY, iHeight, oScopeAdapter, arrYPair)
		{
			var iPadding = Math.max(14, Math.min(20, parseInt(iHeight * 0.05)));
			iApiY += iPadding;
			iHeight = iHeight - iPadding * 2;
			var numPixelPerValue = CoordinateTransformer.verticalNumberAxis(oGraphics, iApiX, iApiY, iHeight, oScopeAdapter, 0, 0);
			if(arrYPair)
			{
				var numCeilingY = Math.max(0, oScopeAdapter.getScopeMax() * numPixelPerValue);
				var numFloorY = Math.min(0, oScopeAdapter.getScopeMin() * numPixelPerValue);
				arrYPair[0] = numFloorY - iPadding;
				arrYPair[1] = numCeilingY + iPadding;
			}
			return numPixelPerValue;
		}
		
		//@Implement AbstractAreaChartRender
		this.protectedDrawChart = function(oGraphics, oDrawingContext)
		{
			oGraphics.clearAll();
			
			var oNumberRulerHelper = oDrawingContext.getNumberRulerHelper();
			var oScopeAdapter = oDrawingContext.getScopeAdapter();
			var oDrawingModel = _this.getDrawingModel();
			
			var iWidth = oGraphics.getWidth();
			var iHeight = oGraphics.getHeight();
			oDrawingContext.setMainRect(0, 0, iWidth, iHeight);
			
			oNumberRulerHelper.confirmVerticalRulerMark(iHeight);
			
			var arrYPair = [];
			var numPixelPerValue = transformCoordinate(oGraphics, 0, 0, iHeight, oScopeAdapter, arrYPair);
			oDrawingContext.setPixelPerValue(numPixelPerValue);
			oDrawingModel.setPixelMinY(arrYPair[0]);
			oDrawingModel.setPixelMaxY(arrYPair[1]);
			
			oDrawingModel.initCategoryXCalculator(iWidth, _super.getModel().getCategories().length);
			_super.drawMain(oDrawingContext);
		}
		
		this.drawNumberAxis = function(sAxisTitle)
		{
			var oDrawingContext = _super.createDrawingContext();
			var oNumberRulerHelper = oDrawingContext.getNumberRulerHelper();
			var oScopeAdapter = oDrawingContext.getScopeAdapter();
			var oGraphics = _super.getGraphics();
			var iWidth = oGraphics.getWidth();
			var iHeight = oGraphics.getHeight();
			oNumberRulerHelper.confirmVerticalRulerMark(iHeight);
			var numPixelPerValue = transformCoordinate(oGraphics, iWidth, 0, iHeight, oScopeAdapter, null);
			var sFormatString = _super.getModel().getSeries()[0].getFormatString();
			oNumberRulerHelper.drawLeftNumberAxisWithMark(oGraphics, iWidth, numPixelPerValue, sFormatString, null);
		}
		
		this.drawCategoryAxis = function()
		{
			var oDrawingModel = _this.getDrawingModel();
			var oGraphics = _super.getGraphics();
			var iWidth = oGraphics.getWidth();
			var iHeight = oGraphics.getHeight();
			oGraphics.setTransformMatrix(1, 0, 0, -1, 0, iHeight);
			var arrCategory = _super.getModel().getCategories();
			oDrawingModel.initCategoryXCalculator(iWidth, arrCategory.length);
			YNXSPainter.drawTopContinueCategoryAxis(arrCategory,
					function(iCategoryIdx)
					{
						return oDrawingModel.getCategoryX(iCategoryIdx);
					},
					_super.getStyleTool(), oGraphics, iWidth);
		}
	}
	
	/** 完整的面积图的绘制器，包含轴、内容、图例 */
	function AreaChartRender(oCtx, oModel, oAttr)
	{
		AbstractAreaChartRender.call(this, oCtx, oModel, oAttr);
		AbstractYNXSType.call(this);
		var _this = this;
		var _super = this.protectedMethod;
		
		//@Implement AbstractYNXSType
		this.protectedSuggestYAxisWidth = function(oGraphics, oNumberRulerHelper)
		{
			var sYAxisFormatString = _super.getNumberAxisFormat(); 
			var sYAxisTitle = _super.getAttr().getYUnitText();
			return oNumberRulerHelper.suggestVerticalRulerWidth(oGraphics, sYAxisFormatString, sYAxisTitle);
		}
		
		//@Implement AbstractYNXSType
		this.protectedSuggestXAxisHeight = function(oGraphics, iMainWidth)
		{
			return YNXSPainter.suggestContinueCategoryAxisHeight(_super.getStyleTool());
		}
		
		//@Implement AbstractAreaChartRender
		this.protectedDrawChart = function(oGraphics, oDrawingContext)
		{
			oGraphics.clearAll();
			
			var oNumberRulerHelper = oDrawingContext.getNumberRulerHelper();
			var oScopeAdapter = oDrawingContext.getScopeAdapter();
			var oDrawingModel = _this.getDrawingModel();
			
			var arrDivided = _super.divideLeftBottomAxis(oGraphics, oNumberRulerHelper);
			var iLeftWidth = arrDivided[0];
			var iBottomHeight = arrDivided[1];
			var iMainWidth = arrDivided[2];
			var iMainHeight = arrDivided[3];
			oDrawingContext.setMainRect(iLeftWidth, 0, iMainWidth, iMainHeight);
			
			oNumberRulerHelper.confirmVerticalRulerMark(iMainHeight);
			
			var iShrinkForTopAlways = getShrinkForTopAlways();
			var iShrinkForLabel = 0;
			var iApiX = iLeftWidth;
			var iApiY = 0;
			var numPixelPerValue = CoordinateTransformer.verticalNumberAxis(oGraphics, 
					iApiX, iApiY, iMainHeight, oScopeAdapter, iShrinkForTopAlways, iShrinkForLabel);
			oDrawingContext.setPixelPerValue(numPixelPerValue);
			
			var arrYPair = YNXSPainter.confirmNumberAxis(numPixelPerValue, iShrinkForLabel, oScopeAdapter, _super.getStyleTool(), _super.getAttr());
			var numPixelMinY = arrYPair[0];
			var numPixelMaxY = arrYPair[1];
			oDrawingModel.setPixelMinY(numPixelMinY);
			oDrawingModel.setPixelMaxY(numPixelMaxY);
			
			var sFormatString = _super.getNumberAxisFormat(); 
			var sAxisTitle = _super.getAttr().getYUnitText();
			var iAssistantLineLen = iMainWidth;
			oNumberRulerHelper.drawLeftNumberAxisWithAssistantLine(
					oGraphics, iLeftWidth, numPixelPerValue, sFormatString, sAxisTitle, iAssistantLineLen);
			
			var arrCategory = _super.getModel().getCategories();
			var iCategoryAxisWidth = iMainWidth;
			var iCategoryAxisHeight = iBottomHeight;
			oDrawingModel.initCategoryXCalculator(iCategoryAxisWidth, arrCategory.length);
			YNXSPainter.drawContinueCategoryAxis(arrCategory, 
					function(iCategoryIdx)
					{
						return oDrawingModel.getCategoryX(iCategoryIdx);
					},
					_super.getStyleTool(), oGraphics, iCategoryAxisWidth, iCategoryAxisHeight, numPixelMinY, -iLeftWidth);
			
			_super.drawMain(oDrawingContext);
		}
		
		var getShrinkForTopAlways = function()
		{
			return YNXSPainter.getShrinkForTopAlways(_super.getStyleTool(), _super.getAttr());
		}
	}
	
	/** XY两个数轴，鼠标划过有反馈 */
	function AbstractDoubleNumberAxisHoverable()
	{
		var searchHoverTarget = function(iLogicX, iLogicY, oModel, oDrawingModel)
		{
			var arrCategorySeriesIdx = oDrawingModel.whichPointNearest(iLogicX, iLogicY);
			if(arrCategorySeriesIdx)
			{
				return new HoverTarget(-1, -1, arrCategorySeriesIdx);
			}
			var arrXYReflineIdx = oDrawingModel.whichReflineNearest(iLogicX, iLogicY);
			if(arrXYReflineIdx)
			{
				var iXAxisReflineIdx = arrXYReflineIdx[0];
				var iYAxisReflineIdx = arrXYReflineIdx[1];
				if(iXAxisReflineIdx >= 0 || iYAxisReflineIdx >= 0)
				{
					return new HoverTarget(iXAxisReflineIdx, iYAxisReflineIdx, null);
				}
			}
			return new HoverTarget(-1, -1, null);
		}
		
		function HoverTarget(iXAxisReflineIdx, iYAxisReflineIdx, arrCategorySeriesIdx)
		{
			var _iXAxisReflineIdx = iXAxisReflineIdx;
			var _iYAxisReflineIdx = iYAxisReflineIdx;
			var _iCategoryIdx = (arrCategorySeriesIdx ? arrCategorySeriesIdx[0] : -1);
			var _iSeriesIdx = (arrCategorySeriesIdx ? arrCategorySeriesIdx[1] : -1);
			
			this.getXAxisReflineIndex = function()
			{
				return _iXAxisReflineIdx;
			}
			this.getYAxisReflineIndex = function()
			{
				return _iYAxisReflineIdx;
			}
			
			this.getCategoryIndex = function()
			{
				return _iCategoryIdx;
			}
			this.getSeriesIndex = function()
			{
				return _iSeriesIdx;
			}
			
			this.isEquals = function(oAnother)
			{
				if(oAnother)
				{
					return _iCategoryIdx == oAnother.getCategoryIndex()
						&& _iSeriesIdx == oAnother.getSeriesIndex()
						&& _iXAxisReflineIdx == oAnother.getXAxisReflineIndex() 
						&& _iYAxisReflineIdx == oAnother.getYAxisReflineIndex();
				}
				return false;
			}
		}
		
		this.protectedMethod = {};
		this.protectedMethod.searchHoverTarget = searchHoverTarget;
	}
	
	/** 散点、气泡图绘制器基类 */
	function AbstractScatterChartRender(oCtx, oModel, oAttr)
	{
		AbstractDoubleNumberAxisHoverable.call(this);
		var _this = this;
		var _super = this.protectedMethod;
		var _oGraphics = new Graphics(oCtx);
		var _oModel = oModel;
		var _oAttr = oAttr;
		var _oStyleTool = new StyleTool(oAttr);
		var _oDrawingModel;
		
		var MIN_RADIUS = 3;
		var MAX_RADIUS = 40;
		
		this.searchHoverTarget = function(iApiX, iApiY)
		{
			var arrXY = _oGraphics.retransformMouseXY(iApiX, iApiY);
			return _super.searchHoverTarget(arrXY[0], arrXY[1], _oModel, _oDrawingModel);
		}
		
		this.getDrawingModel = function()
		{
			return _oDrawingModel;
		}
		
		this.drawChart = function(oHoverTarget)
		{
			_oDrawingModel = new DrawingModel();
			var oDrawingContext = createDrawingContext(oHoverTarget);
			if(_oModel.getScopes().length > 2)
			{
				var iWidth = _oGraphics.getWidth();
				var iHeight = _oGraphics.getHeight();
				var arrBubbleParam = confirmBubbleParam(Math.min(iWidth, iHeight));
				oDrawingContext.setBubbleParam(arrBubbleParam);
			}
			_this.protectedDrawChart(_oGraphics, oDrawingContext);
		}
		this.protectedDrawChart = function(oGraphics, oDrawingContext)
		{
			throw new Error("Implement");
		}
		
		var confirmBubbleParam = function(iPixel)
		{
			var numMaxSizeRatio = 0.16;
			var numMaxSize = iPixel * numMaxSizeRatio;
			var iMaxRadius = Math.max(MIN_RADIUS, Math.min(MAX_RADIUS, parseInt(numMaxSize / 2)));
			var iMinRadius = MIN_RADIUS;
			
			var oZScope = _oModel.getScopes()[2];
			var numDistance = oZScope.getMax() - oZScope.getMin();
			var numTransformRadio = (numDistance == 0 ? 0 : (iMaxRadius - iMinRadius) / numDistance);
			return [oZScope.getMin(), numTransformRadio, iMinRadius];
		}
		var getBubbleRadius = function(numZValue, arrBubbleParam)
		{
			var numR = MIN_RADIUS;
			if(arrBubbleParam && (numZValue || numZValue === 0))
			{
				var numMinValue = arrBubbleParam[0];
				var numTransformRadio = arrBubbleParam[1];
				var iMinRadius = arrBubbleParam[2];
				numR = iMinRadius + (numZValue - numMinValue) * numTransformRadio;
			}
			return numR;
		}
		
		var drawMain = function(oDrawingContext)
		{
			_oGraphics.getContext().save();
			var arrHover;
			for(var iSeriesIdx = 0; iSeriesIdx < _oModel.getSeries().length; iSeriesIdx++)
			{
				var oSeries = _oModel.getSeries()[iSeriesIdx];
				var sColor = oSeries.getColor();
				_oGraphics.getContext().fillStyle = sColor;
				for(var iCategoryIdx = 0; iCategoryIdx < _oModel.getCategories().length; iCategoryIdx++)
				{
					var oNode = _oModel.getNode(iSeriesIdx, iCategoryIdx);
					if(oNode)
					{
						var numX = oDrawingContext.getDrawableX(oNode.getXAxisValue());
						var numY =  oDrawingContext.getDrawableY(oNode.getYAxisValue());
						var numRadius = oDrawingContext.getDrawableRadius(oNode.getZAxisValue());
						_oDrawingModel.addPoint(iCategoryIdx, iSeriesIdx, numX, numY, numRadius);
						if(oDrawingContext.isHoverPoint(iCategoryIdx, iSeriesIdx))
						{
							arrHover = [Util.createColorWithoutAlpha(sColor), numX, numY, numRadius + 2];
						}
						else
						{
							_oGraphics.beginPath();
							_oGraphics.arc(numX, numY, numRadius, 0, Math.PI * 2);
							_oGraphics.fill();
						}
					}
				}
			}
			drawRefline(oDrawingContext);
			if(arrHover)
			{
				_oGraphics.getContext().fillStyle = arrHover[0];
				_oGraphics.beginPath();
				_oGraphics.arc(arrHover[1], arrHover[2], arrHover[3], 0, Math.PI * 2);
				_oGraphics.fill();
			}
			_oGraphics.getContext().restore();
		}
		
		var drawRefline = function(oDrawingContext)
		{
			var arrPaintableLines = _oModel.getPaintableLines();
			
			var arrXAxisPaintableLine = (arrPaintableLines ? arrPaintableLines[0] : null);
			var iXHoverIdx = oDrawingContext.getXHoverReflineIndex();
			var arrXDrawingRefline = ReflinePainter.drawVerticalLines(arrXAxisPaintableLine, iXHoverIdx, 
					oDrawingContext.getXScopeAdapter(), _oStyleTool, _oGraphics, 
					oDrawingContext.getPixelMinY(), oDrawingContext.getPixelMaxY(),
					oDrawingContext.getXPixelPerValue(), oDrawingContext.getPixelMinX(), oDrawingContext.getPixelMaxX());
			_oDrawingModel.setXReflines(arrXDrawingRefline);
			
			var arrYAxisPaintableLine = (arrPaintableLines ? arrPaintableLines[1] : null);
			var iYHoverIdx = oDrawingContext.getYHoverReflineIndex();
			var arrYDrawingRefline = ReflinePainter.drawHorizontalLines(arrYAxisPaintableLine, iYHoverIdx, 
					oDrawingContext.getYScopeAdapter(), _oStyleTool, _oGraphics, 
					oDrawingContext.getPixelMinX(), oDrawingContext.getPixelMaxX(),
					oDrawingContext.getYPixelPerValue(), oDrawingContext.getPixelMaxY());
			_oDrawingModel.setYReflines(arrYDrawingRefline);
		}
		
		var createDrawingContext = function(oHoverTarget)
		{
			var oDrawingContext = new DrawingContext();
			oDrawingContext.setHoverTarget(oHoverTarget);
			oDrawingContext.bind(_oModel, _oAttr, _oStyleTool);
			return oDrawingContext;
		}
		
		function DrawingContext()
		{
			var _oHoverTarget;
			var _oXScope;
			var _oXScopeAdapter;
			var _oXRulerHelper;
			var _numXPixelPerValue;
			var _oYScope;
			var _oYScopeAdapter;
			var _oYRulerHelper;
			var _numYPixelPerValue;
			var _arrBubbleParam;
			var _numPixelMinX;
			var _numPixelMaxX;
			var _numPixelMinY;
			var _numPixelMaxY;
			
			this.setHoverTarget = function(oHoverTarget)
			{
				_oHoverTarget = oHoverTarget;
			}
			this.isHoverPoint = function(iCategoryIdx, iSeriesIdx)
			{
				return (_oHoverTarget 
					&& _oHoverTarget.getCategoryIndex() == iCategoryIdx
					&& _oHoverTarget.getSeriesIndex() == iSeriesIdx);
			}
			this.getXHoverReflineIndex = function()
			{
				return (_oHoverTarget ? _oHoverTarget.getXAxisReflineIndex() : -1);
			}
			this.getYHoverReflineIndex = function()
			{
				return (_oHoverTarget ? _oHoverTarget.getYAxisReflineIndex() : -1);
			}
			
			this.bind = function(oModel, oAttr, oStyleTool)
			{
				_oXScope = oModel.getScopes()[0];
				_oYScope = oModel.getScopes()[1];
				_oXScopeAdapter = new RulerScaleAdapter(_oXScope, oAttr.getXRulerScale(), oAttr.getXRulerStart());
				_oYScopeAdapter = new RulerScaleAdapter(_oYScope, oAttr.getYRulerScale(), oAttr.getYRulerStart());
				_oXRulerHelper = new NumberRulerHelper(_oXScopeAdapter, oStyleTool);
				_oYRulerHelper = new NumberRulerHelper(_oYScopeAdapter, oStyleTool);
			}
			this.getXScope = function(){return _oXScope;}
			this.getXScopeAdapter = function(){return _oXScopeAdapter;}
			this.getXRulerHelper = function(){return _oXRulerHelper;}
			this.getYScope = function(){return _oYScope;}
			this.getYScopeAdapter = function(){return _oYScopeAdapter;}
			this.getYRulerHelper = function(){return _oYRulerHelper;}
			
			this.getXPixelPerValue = function(){return _numXPixelPerValue;}
			this.getYPixelPerValue = function(){return _numYPixelPerValue;}
			this.setPixelPerValue = function(numXPixelPerValue, numYPixelPerValue)
			{
				_numXPixelPerValue = numXPixelPerValue;
				_numYPixelPerValue = numYPixelPerValue;
			}
			this.getDrawableX = function(numXValue)
			{
				return _numXPixelPerValue * _oXScopeAdapter.cutFoot(numXValue);
			}
			this.getDrawableY = function(numYValue)
			{
				return _numYPixelPerValue * _oYScopeAdapter.cutFoot(numYValue);
			}
			
			this.setBubbleParam = function(arrBubbleParam)
			{
				_arrBubbleParam = arrBubbleParam;
			}
			this.getDrawableRadius = function(numZValue)
			{
				return getBubbleRadius(numZValue, _arrBubbleParam);
			}
			
			this.setXPixelScope = function(numPixelMinX, numPixelMaxX)
			{
				_numPixelMinX = numPixelMinX;
				_numPixelMaxX = numPixelMaxX;
			}
			this.getPixelMinX = function(){return _numPixelMinX;}
			this.getPixelMaxX = function(){return _numPixelMaxX;}
						
			this.setYPixelScope = function(numPixelMinY, numPixelMaxY)
			{
				_numPixelMinY = numPixelMinY;
				_numPixelMaxY = numPixelMaxY;
			}
			this.getPixelMinY = function(){return _numPixelMinY;}
			this.getPixelMaxY = function(){return _numPixelMaxY;}
		}
		
		function DrawingModel()
		{
			var _arrPoint = [];
			var _arrXRefline;
			var _arrYRefline;
			
			this.addPoint = function(iCategoryIdx, iSeriesIdx, numX, numY, numRadius)
			{
				_arrPoint.push([numX, numY, numRadius, iCategoryIdx, iSeriesIdx]);
			}
			
			this.setXReflines = function(arrDrawingRefline)
			{
				_arrXRefline = arrDrawingRefline;
			}
			
			this.setYReflines = function(arrDrawingRefline)
			{
				_arrYRefline = arrDrawingRefline;
			}
			
			this.whichReflineNearest = function(iLogicX, iLogicY)
			{
				if(_arrXRefline)
				{
					for(var i = 0; i < _arrXRefline.length; i++)
					{
						var oDrawingRefline = _arrXRefline[i];
						if(oDrawingRefline.isNearEnough(iLogicX))
						{
							return [i, -1];
						}
					}
				}
				if(_arrYRefline)
				{
					for(var i = 0; i < _arrYRefline.length; i++)
					{
						var oDrawingRefline = _arrYRefline[i];
						if(oDrawingRefline.isNearEnough(iLogicY))
						{
							return [-1, i];
						}
					}
				}
				return null;
			}
			
			this.whichPointNearest = function(iLogicX, iLogicY)
			{
				var numMinDistance = 65535;
				var arrFound = null;
				for(var i = _arrPoint.length - 1; i >= 0; i--)
				{
					var oPoint = _arrPoint[i];
					var numPx = oPoint[0];
					var numPy = oPoint[1];
					var numPr = oPoint[2];
					var numDistanceX = Math.abs(iLogicX - numPx);
					var numDistanceY = Math.abs(iLogicY - numPy);
					var numDistance = Math.sqrt(numDistanceX * numDistanceX + numDistanceY * numDistanceY);
					if(numDistance < numMinDistance && numDistance <= numPr + 2)
					{
						numMinDistance = numDistance;
						var iCategoryIdx = oPoint[3];
						var iSeriesIdx = oPoint[4];
						arrFound = [iCategoryIdx, iSeriesIdx];
					}
				}
				return arrFound;
			}
			
			this.getXAxisRefline = function(iIdx)
			{
				return _arrXRefline[iIdx];
			}
			
			this.getYAxisRefline = function(iIdx)
			{
				return _arrYRefline[iIdx];
			}
		}
		
		_super.getGraphics = function(){return _oGraphics;}
		_super.getModel = function(){return _oModel;}
		_super.getAttr = function(){return _oAttr;}
		_super.getStyleTool = function(){return _oStyleTool;}
		_super.drawMain = drawMain;
		_super.createDrawingContext = createDrawingContext;
	}
	
	/** 分片散点、气泡图绘制器，服务于棚架式，内容与横轴、纵轴分开绘制 */
	function SeparatedScatterChartRender(oCtx, oModel, oAttr)
	{
		AbstractScatterChartRender.call(this, oCtx, oModel, oAttr);
		var _super = this.protectedMethod;
		
		var getHorizontalPadding = function(iWidth)
		{
			return Math.min(16, parseInt(iWidth * 0.05));
		}
		
		var getVerticalPadding = function(iHeight)
		{
			return Math.max(14, Math.min(20, parseInt(iHeight * 0.05)));
		}
		
		var transformCoordinateX = function(oGraphics, iApiX, iApiY, iWidth, oXScopeAdapter)
		{
			var iPadding = getHorizontalPadding(iWidth);
			iApiX += iPadding;
			iWidth = iWidth - iPadding * 2;
			var numPixelPerValue = CoordinateTransformer.horizontalNumberAxis(oGraphics, iApiX, iApiY, iWidth, oXScopeAdapter, 0, 0, 0);
			return numPixelPerValue;
		}
		
		var transformCoordinateY = function(oGraphics, iApiX, iApiY, iHeight, oYScopeAdapter)
		{
			var iPadding = getVerticalPadding(iHeight);
			iApiY += iPadding;
			iHeight = iHeight - iPadding * 2;
			var numPixelPerValue = CoordinateTransformer.verticalNumberAxis(oGraphics, iApiX, iApiY, iHeight, oYScopeAdapter, 0, 0);
			return numPixelPerValue;
		}
		
		var transformCoordinate = function(oGraphics, iApiX, iApiY, iWidth, iHeight, oXScopeAdapter, oYScopeAdapter, arrXPair, arrYPair)
		{
			var iHPadding = getHorizontalPadding(iWidth);
			var iVPadding = getVerticalPadding(iHeight);
			iApiX += iHPadding;
			iApiY += iVPadding;
			iWidth = iWidth - iHPadding * 2;
			iHeight = iHeight - iVPadding * 2;
			var arrPixelPerValue = CoordinateTransformer.doubleNumberAxis(oGraphics, iApiX, iApiY, iWidth, iHeight, oXScopeAdapter, oYScopeAdapter, 0);
			
			var numXPixelPerValue = arrPixelPerValue[0];
			var numYPixelPerValue = arrPixelPerValue[1];
			var numCeilingX = Math.max(0, oXScopeAdapter.getScopeMax() * numXPixelPerValue);
			var numFloorX = Math.min(0, oXScopeAdapter.getScopeMin() * numXPixelPerValue);
			arrXPair[0] = numFloorX - iHPadding;
			arrXPair[1] = numCeilingX + iHPadding;
			var numCeilingY = Math.max(0, oYScopeAdapter.getScopeMax() * numYPixelPerValue);
			var numFloorY = Math.min(0, oYScopeAdapter.getScopeMin() * numYPixelPerValue);
			arrYPair[0] = numFloorY - iVPadding;
			arrYPair[1] = numCeilingY + iVPadding;
			
			return arrPixelPerValue;
		}
		
		//@Implement AbstractScatterChartRender
		this.protectedDrawChart = function(oGraphics, oDrawingContext)
		{
			oGraphics.clearAll();
			
			var iWidth = oGraphics.getWidth();
			var iHeight = oGraphics.getHeight();
			var oXRulerHelper = oDrawingContext.getXRulerHelper();
			var oYRulerHelper = oDrawingContext.getYRulerHelper();
			var oXScopeAdapter = oDrawingContext.getXScopeAdapter();
			var oYScopeAdapter = oDrawingContext.getYScopeAdapter();			
			
			oXRulerHelper.confirmHorizontalRulerMark(iWidth);
			oYRulerHelper.confirmVerticalRulerMark(iHeight);
			
			var arrXPair = [];
			var arrYPair = [];
			var arrPixelPerValue = transformCoordinate(oGraphics, 
					0, 0, iWidth, iHeight, oXScopeAdapter, oYScopeAdapter, arrXPair, arrYPair);
			var numXPixelPerValue = arrPixelPerValue[0];
			var numYPixelPerValue = arrPixelPerValue[1];
			oDrawingContext.setPixelPerValue(numXPixelPerValue, numYPixelPerValue);
			oDrawingContext.setXPixelScope(arrXPair[0], arrXPair[1]);
			oDrawingContext.setYPixelScope(arrYPair[0], arrYPair[1]);
			
			oXRulerHelper.drawVerticalAssistantLine(oGraphics, numXPixelPerValue);
			oYRulerHelper.drawHorizontalAssistantLine(oGraphics, numYPixelPerValue);
			
			_super.drawMain(oDrawingContext);
		}
		
		this.drawXAxis = function(sAxisTitle)
		{
			var oDrawingContext = _super.createDrawingContext();
			var oNumberRulerHelper = oDrawingContext.getXRulerHelper();
			var oScopeAdapter = oDrawingContext.getXScopeAdapter();
			var oGraphics = _super.getGraphics();
			var iWidth = oGraphics.getWidth();
			var iHeight = oGraphics.getHeight();
			oNumberRulerHelper.confirmHorizontalRulerMark(iWidth);
			var numPixelPerValue = transformCoordinateX(oGraphics, 0, iHeight, iWidth, oScopeAdapter);
			var sFormatString =  oDrawingContext.getXScope().getFormatString();
			oNumberRulerHelper.drawTopNumberAxisWithMark(oGraphics, numPixelPerValue, sFormatString, null);
		}
		
		this.drawYAxis = function(sAxisTitle)
		{
			var oDrawingContext = _super.createDrawingContext();
			var oNumberRulerHelper = oDrawingContext.getYRulerHelper();
			var oScopeAdapter = oDrawingContext.getYScopeAdapter();
			var oGraphics = _super.getGraphics();
			var iWidth = oGraphics.getWidth();
			var iHeight = oGraphics.getHeight();
			oNumberRulerHelper.confirmVerticalRulerMark(iHeight);
			var numPixelPerValue = transformCoordinateY(oGraphics, iWidth, 0, iHeight, oScopeAdapter);
			var sFormatString =  oDrawingContext.getYScope().getFormatString();
			oNumberRulerHelper.drawLeftNumberAxisWithMark(oGraphics, iWidth, numPixelPerValue, sFormatString, null);
		}
	}
	
	/** 完整的散点、气泡图的绘制器，包含轴、内容、图例 */
	function ScatterChartRender(oCtx, oModel, oAttr)
	{
		AbstractScatterChartRender.call(this, oCtx, oModel, oAttr);
		var _super = this.protectedMethod;
		
		//@Implement AbstractScatterChartRender
		this.protectedDrawChart = function(oGraphics, oDrawingContext)
		{
			oGraphics.clearAll();
			
			var oXRulerHelper = oDrawingContext.getXRulerHelper();
			var oYRulerHelper = oDrawingContext.getYRulerHelper();
			var oXScopeAdapter = oDrawingContext.getXScopeAdapter();
			var oYScopeAdapter = oDrawingContext.getYScopeAdapter();
			
			var arrDivided = divideLeftBottomAxis(oGraphics, oDrawingContext);
			var iLeftWidth = arrDivided[0];
			//var iBottomHeight = arrDivided[1];
			var iMainWidth = arrDivided[2];
			var iMainHeight = arrDivided[3];
			
			updateXYScopeByZ(oDrawingContext, iMainWidth, iMainHeight);
			
			oXRulerHelper.confirmHorizontalRulerMark(iMainWidth);
			oYRulerHelper.confirmVerticalRulerMark(iMainHeight);
			
			var iShrinkForTopAlways = YNXSPainter.getShrinkForTopAlways(_super.getStyleTool(), _super.getAttr());
			var iApiX = iLeftWidth;
			var iApiY = 4;
			var iPlotWidth = iMainWidth - 6;
			var iPlotHeight = iMainHeight - iApiY;
			var arrPixelPerValue = CoordinateTransformer.doubleNumberAxis(
					oGraphics, iApiX, iApiY, iPlotWidth, iPlotHeight, oXScopeAdapter, oYScopeAdapter, iShrinkForTopAlways);
			var numXPixelPerValue = arrPixelPerValue[0];
			var numYPixelPerValue = arrPixelPerValue[1];
			oDrawingContext.setPixelPerValue(numXPixelPerValue, numYPixelPerValue);
			
			var arrXPair = XNYSPainter.confirmNumberAxis(numXPixelPerValue, oXScopeAdapter);
			var numPixelMinX = arrXPair[0];
			var numPixelMaxX = arrXPair[1];
			oDrawingContext.setXPixelScope(numPixelMinX, numPixelMaxX);
			var arrYPair = YNXSPainter.confirmNumberAxis(numYPixelPerValue, 0, oYScopeAdapter, _super.getStyleTool(), _super.getAttr());
			var numPixelMinY = arrYPair[0];
			var numPixelMaxY = arrYPair[1];
			oDrawingContext.setYPixelScope(numPixelMinY, numPixelMaxY);
			
			var sYAxisFormat = getYFormat(oDrawingContext); 
			var sYAxisTitle = _super.getAttr().getYUnitText();
			var iYAxisAtXPosition = numPixelMinX;
			var iYAxisWidth = iLeftWidth;
			var iHAssistantLineLen = iMainWidth;
			oYRulerHelper.drawDoubleNumberAxisOfLeft(
					oGraphics, iYAxisAtXPosition, iYAxisWidth, numYPixelPerValue, sYAxisFormat, sYAxisTitle, iHAssistantLineLen);
			
			var sXAxisFormat = getXFormat(oDrawingContext);
			var sXAxisTitle = _super.getAttr().getXUnitText();
			var iXAxisAtYPosition = numPixelMinY;
			var iVAssistantLineLen = iMainHeight;
			oXRulerHelper.drawDoubleNumberAxisOfBottom(
					oGraphics, iXAxisAtYPosition, numXPixelPerValue, sXAxisFormat, sXAxisTitle, iVAssistantLineLen);
			
			_super.drawMain(oDrawingContext);
		}
		
		var divideLeftBottomAxis = function(oGraphics, oDrawingContext)
		{
			var iAllWidth = oGraphics.getWidth();
			var iAllHeight = oGraphics.getHeight();
			
			var sYAxisFormat = getYFormat(oDrawingContext);
			var sYAxisTitle = _super.getAttr().getYUnitText();
			var iSuggestLeftWidth = oDrawingContext.getYRulerHelper().suggestVerticalRulerWidth(oGraphics, sYAxisFormat, sYAxisTitle);
			var iLeftMinWidth = 40;
			var iLeftMaxWidth = iAllWidth * 0.382;
			var iLeftWidth = Math.max(iLeftMinWidth, Math.min(iLeftMaxWidth, iSuggestLeftWidth));
			var iMainWidth = iAllWidth - iLeftWidth;
			
			var bWithXAxisTitle = (_super.getAttr().getXUnitText() ? true : false);
			var iSuggestBottomHeight = oDrawingContext.getXRulerHelper().suggestHorizontalRulerHeight(bWithXAxisTitle);
			var iBottomMinHeight = 24;
			var iBottomMaxHeight = iAllHeight * 0.382;
			var iBottomHeight = Math.max(iBottomMinHeight, Math.min(iBottomMaxHeight, iSuggestBottomHeight));
			var iMainHeight = iAllHeight - iBottomHeight;
			
			return [iLeftWidth, iBottomHeight, iMainWidth, iMainHeight];
		}
		
		var getXFormat = function(oDrawingContext)
		{
			var sXAxisFormatString = _super.getAttr().getXFormat();
			!sXAxisFormatString && (sXAxisFormatString = oDrawingContext.getXScope().getFormatString());
			return sXAxisFormatString;
		}
		
		var getYFormat = function(oDrawingContext)
		{
			var sYAxisFormatString = _super.getAttr().getYFormat();
			!sYAxisFormatString && (sYAxisFormatString = oDrawingContext.getYScope().getFormatString());
			return sYAxisFormatString;
		}
		
		var updateXYScopeByZ = function(oDrawingContext, iWidth, iHeight)//仅用于斗方
		{
			var oModel = _super.getModel();
			if(oModel.getScopes().length < 3 
				|| oDrawingContext.getXScopeAdapter().isWithLog() 
				|| oDrawingContext.getYScopeAdapter().isWithLog())
			{
				return;
			}
			var arrXScope = getAxisDrawingScope(oDrawingContext.getXScope());
			var numXAxisScopeMin = arrXScope[0];
			var numXAxisScopeMax = arrXScope[1];
			var numXAxisScopeDelta = numXAxisScopeMax - numXAxisScopeMin;
			var numXAxisScopeMinus = 0;
			var numXAxisScopeAdd = 0;
			
			var arrYScope = getAxisDrawingScope(oDrawingContext.getYScope());
			var numYAxisScopeMin = arrYScope[0];
			var numYAxisScopeMax = arrYScope[1];
			var numYAxisScopeDelta = numYAxisScopeMax - numYAxisScopeMin;
			var numYAxisScopeMinus = 0;
			var numYAxisScopeAdd = 0;
			
			for(var iSeriesIdx = 0; iSeriesIdx < oModel.getSeries().length; iSeriesIdx++)
			{
				for(var iCategoryIdx = 0; iCategoryIdx < oModel.getCategories().length; iCategoryIdx++)
				{
					var oNode = oModel.getNode(iSeriesIdx, iCategoryIdx);
					if(oNode)
					{
						var numXValue = oNode.getXAxisValue();
						var numYValue = oNode.getYAxisValue();
						var numZValue = oNode.getZAxisValue();
						var numRadius = oDrawingContext.getDrawableRadius(numZValue);
						
						var numXDrawingOccupied = numRadius / iWidth;
						var numXMinDistanceRatio = (numXValue - numXAxisScopeMin) / numXAxisScopeDelta;
						var numXMaxDistanceRatio = (numXAxisScopeMax - numXValue) / numXAxisScopeDelta;
						if(numXMinDistanceRatio < numXDrawingOccupied)
						{
							numXAxisScopeMinus = Math.max(numXAxisScopeMinus, (numXDrawingOccupied - numXMinDistanceRatio) * numXAxisScopeDelta);
						}
						else if(numXMaxDistanceRatio < numXDrawingOccupied)
						{
							numXAxisScopeAdd = Math.max(numXAxisScopeAdd, (numXDrawingOccupied - numXMaxDistanceRatio) * numXAxisScopeDelta);
						}
						
						var numYDrawingOccupied = numRadius / iHeight;
						var numYMinDistanceRatio = (numYValue - numYAxisScopeMin) / numYAxisScopeDelta;
						var numYMaxDistanceRatio = (numYAxisScopeMax - numYValue) / numYAxisScopeDelta;
						if(numYMinDistanceRatio < numYDrawingOccupied)
						{
							numYAxisScopeMinus = Math.max(numYAxisScopeMinus, (numYDrawingOccupied - numYMinDistanceRatio) * numYAxisScopeDelta);
						}
						else if(numYMaxDistanceRatio < numYDrawingOccupied)
						{
							numYAxisScopeAdd = Math.max(numYAxisScopeAdd, (numYDrawingOccupied - numYMaxDistanceRatio) * numYAxisScopeDelta);
						}
					}
				}
			}
			if(numXAxisScopeMinus > 0 || numXAxisScopeAdd > 0)
			{
				oDrawingContext.getXScopeAdapter().updateScopeMaxMin(
						(numXAxisScopeAdd > 0 ? numXAxisScopeMax + numXAxisScopeAdd : null),
						(numXAxisScopeMinus > 0 ? numXAxisScopeMin - numXAxisScopeMinus : null));
			}
			if(numYAxisScopeMinus > 0 || numYAxisScopeAdd > 0)
			{
				oDrawingContext.getYScopeAdapter().updateScopeMaxMin(
						(numYAxisScopeAdd > 0 ? numYAxisScopeMax + numYAxisScopeAdd : null),
						(numYAxisScopeMinus > 0 ? numYAxisScopeMin - numYAxisScopeMinus : null));
			}
		}
		
		var getAxisDrawingScope = function(oScope)
		{
			var numMax = oScope.getMax();
			var numMin = oScope.getMin();
			if(numMax > 0 && numMin < 0)
			{
				return [numMin, numMax];
			}
			else if(numMin >= 0)
			{
				return [0, numMax];
			}
			else
			{
				return [numMin, 0];
			}
		}
	}
	
	function AbstractTreeRender(oCtx, oModel, oAttr)
	{
		var _this = this;
		
		this.searchHoverTarget = function(iApiX, iApiY)
		{
			var arrPathIdx = [];
			var bFound = _this.protectedSearchHoverTarget(iApiX, iApiY, arrPathIdx);
			!bFound && (arrPathIdx = null);
			return new HoverTarget(arrPathIdx);
		}
		this.protectedSearchHoverTarget = function(iApiX, iApiY, arrPathIdx)
		{
			throw new Error("Implement");
		}
		
		var sumary = function(oBranchNode, bIngoreNegative)
		{
			var iContainsDeep = 1;
			var numSubTotal = 0;
			var numDrawingTotal = 0;
			for(var i = 0; i < oBranchNode.getChildCount(); i++)
			{
				var oTreeNode = oBranchNode.getChild(i);
				var bHasChildren = (oTreeNode.getChildCount() > 0);
				if(bHasChildren)
				{
					var iSubContainsDeep = sumary(oTreeNode, bIngoreNegative);
					iContainsDeep = Math.max(iContainsDeep, iSubContainsDeep + 1);
				}
				var numSize = oTreeNode.getSize();
				var numDrawingSize;
				if(bHasChildren)
				{
					numDrawingSize = oTreeNode.getDrawingSize();
				}
				else
				{
					(numSize < 0 && bIngoreNegative) && (numSize = 0);
					numDrawingSize = (numSize < 0 ? -numSize : numSize);
					oTreeNode.setDrawingSize(numDrawingSize);
				}
				numSubTotal += numSize;
				numDrawingTotal += numDrawingSize;
			}
			oBranchNode.setSize(numSubTotal);
			oBranchNode.setDrawingSize(numDrawingTotal);
			return iContainsDeep;
		}
		
		function HoverTarget(arrPathIdx)
		{
			var _arrPathIdx = arrPathIdx;
			
			this.getPath = function()
			{
				return _arrPathIdx;
			}
			
			this.isEquals = function(oAnother)
			{
				if(oAnother)
				{
					if(_arrPathIdx)
					{
						if(oAnother.getPath() && _arrPathIdx.length == oAnother.getPath().length)
						{
							var bSame = true;
							for(var i = 0; i < _arrPathIdx.length; i++)
							{
								bSame = bSame && (_arrPathIdx[i] == oAnother.getPath()[i]);
							}
							return bSame;
						}
					}
					else
					{
						return (!oAnother.getPath());
					}
				}
				return false;
			}
		}
		
		this.protectedMethod = {};
		this.protectedMethod.sumary = sumary;
	}
	
	function RectTreeRender(oCtx, oModel, oAttr)
	{
		AbstractTreeRender.call(this, oCtx, oModel, oAttr);
		var _super = this.protectedMethod; 
		var _oGraphics = new Graphics(oCtx);
		var _oModel = oModel;
		var _oAttr = oAttr;
		var _oStyleTool = new StyleTool(oAttr);
		
		//@Implement AbstractTreeRender
		this.protectedSearchHoverTarget = function(iApiX, iApiY, arrPathIdx)
		{
			return search(iApiX, iApiY, _oModel.getRoot(), arrPathIdx);
		}
		var search = function(iApiX, iApiY, oBranchNode, arrPathIdx)
		{
			var bFound = false;
			for(var i = 0; i < oBranchNode.getChildCount(); i++)
			{
				var oTreeNode = oBranchNode.getChild(i);
				var oDrawing = oTreeNode.getDrawingObject();
				if(oDrawing 
					&& getDrawingX(oDrawing) <= iApiX && iApiX <= getDrawingX(oDrawing) + getDrawingWidth(oDrawing)
					&& getDrawingY(oDrawing) <= iApiY && iApiY <= getDrawingY(oDrawing) + getDrawingHeight(oDrawing))
				{
					arrPathIdx.push(i);
					bFound = true;
					if(oTreeNode.getChildCount() > 0)
					{
						bFound = search(iApiX, iApiY, oTreeNode, arrPathIdx);
					}
					break;
				}
			}
			return bFound;
		}
		
		this.drawChart = function()
		{
			var oRoot = _oModel.getRoot();
			var iLevelDeeps = _super.sumary(oRoot, _oAttr.isIgnoreNegative());
			iLevelDeeps = Math.min(3, iLevelDeeps);
			
			var oDrawing = createDrawingNode(0, 0, _oGraphics.getWidth(), _oGraphics.getHeight());
			oRoot.setDrawingObject(oDrawing);
			divideRect(oRoot, iLevelDeeps, 0);
			
			_oGraphics.clearAll();
			_oGraphics.getContext().strokeStyle = _oStyleTool.getBackgroundColor();
			_oGraphics.getContext().lineWidth = 0.5;
			_oGraphics.getContext().textBaseline = "bottom";
			var iFontSize = getLabelFontSize();
			Util.setupFont(_oGraphics.getContext(), iFontSize);
			drawTree(oRoot, oRoot.getColor(), iFontSize);
		}
		
		this.drawHover = function(oHoverTarget, bHover)
		{
			var arrHoverPathIdx = (oHoverTarget ? oHoverTarget.getPath() : null);
			arrHoverPathIdx && drawHover(_oModel.getRoot(), arrHoverPathIdx, bHover);
		}
		
		var divideRect = function(oBranchNode, iLevelDeeps, numPadding)
		{
			var numDrawingTotal = oBranchNode.getDrawingSize();
			if(!numDrawingTotal)
			{
				return;
			}
			var oDrawing = oBranchNode.getDrawingObject();
			var numCurrentX = getDrawingX(oDrawing) + numPadding;
			var numCurrentY = getDrawingY(oDrawing) + numPadding;
			var numCurrentW = getDrawingWidth(oDrawing) - numPadding * 2;
			var numCurrentH = getDrawingHeight(oDrawing) - numPadding * 2;
			if(numCurrentW <= 0 || numCurrentH <= 0)
			{
				return;
			}
			var numSubPadding = getLevelBorderWide(Math.max(0, iLevelDeeps - 1)) * 0.5;
			var iIdx = 0;
			while(iIdx < oBranchNode.getChildCount())
			{
				var bLongIsWidth = (numCurrentW > numCurrentH);
				var numLong = (bLongIsWidth ? numCurrentW : numCurrentH);
				var numShort = (bLongIsWidth ? numCurrentH : numCurrentW);
				var iFromIdx = iIdx;
				var arrWrap = tryDivideGroup(oBranchNode, iFromIdx, numDrawingTotal, numLong, numShort);
				var iToIdx = arrWrap[0];
				var numGroupTotal = arrWrap[1];
				var numLongUsed = numGroupTotal / numDrawingTotal * numLong;
				var numStartOffset = 0;
				for(var i = iFromIdx; i < iToIdx; i++)
				{
					var oTreeNode = oBranchNode.getChild(i);
					var numDrawingSize = oTreeNode.getDrawingSize();
					var numWide1 = numLongUsed;
					var numWide2 = numDrawingSize / numGroupTotal * numShort;
					var numSubX = numCurrentX + (bLongIsWidth ? 0 : numStartOffset);
					var numSubY = numCurrentY + (bLongIsWidth ? numStartOffset : 0);
					var numSubW = (bLongIsWidth ? numWide1 : numWide2);
					var numSubH = (bLongIsWidth ? numWide2 : numWide1);
					numStartOffset += numWide2;
					var oDrawing = createDrawingNode(numSubX, numSubY, numSubW, numSubH);
					oTreeNode.setDrawingObject(oDrawing);
					if(oTreeNode.getChildCount() > 0)
					{
						divideRect(oTreeNode, iLevelDeeps - 1, numSubPadding);
					}
				}
				numCurrentX = numCurrentX + (bLongIsWidth ? numLongUsed : 0);
				numCurrentY = numCurrentY + (bLongIsWidth ? 0 : numLongUsed);
				numCurrentW = numCurrentW - (bLongIsWidth ? numLongUsed : 0);
				numCurrentH = numCurrentH - (bLongIsWidth ? 0 : numLongUsed);
				numDrawingTotal -= numGroupTotal;
				!(iToIdx > iFromIdx) && (iToIdx = iFromIdx + 1);//Prevent infinite loop.
				iIdx = iToIdx;
			}
		}
		
		var tryDivideGroup = function(oBranchNode, iFromIdx, numRemainDrawingTotal, numLong, numShort)
		{
			var numNearSquareLastTime = 0;
			var numGroupDrawingTotal = 0;
			var arrGroupDrawing = [];
			for(var iIdx = iFromIdx; iIdx < oBranchNode.getChildCount(); iIdx++)
			{
				var oTreeNode = oBranchNode.getChild(iIdx);
				var numDrawingSize = oTreeNode.getDrawingSize();
				if(!numDrawingSize)
				{
					continue;
				}
				arrGroupDrawing.push(numDrawingSize);
				var numGroupValue = numGroupDrawingTotal + numDrawingSize;
				var numGroupRatioInRemain = numGroupValue / numRemainDrawingTotal;
				var numWide1 = numLong * numGroupRatioInRemain;
				var numNearSquare = 1;
				for(var i = 0; i < arrGroupDrawing.length; i++)
				{
					var numEach = arrGroupDrawing[i];
					var numEachRatioInGroup = numEach / numGroupValue;
					var numWide2 = numShort * numEachRatioInGroup;
					var numEachNearSquare = numWide1 < numWide2 ? 
												(numWide1 / numWide2) : 
												(numWide2 / numWide1);
					numNearSquare = Math.min(numEachNearSquare, numNearSquare);
				}
				if(numNearSquare > numNearSquareLastTime)//更接近1
				{
					numNearSquareLastTime = numNearSquare;
					numGroupDrawingTotal = numGroupValue;
				}
				else
				{
					break;
				}
			}
			var iToIdx = iIdx;
			return [iToIdx, numGroupDrawingTotal];
		}
		
		var drawTree = function(oBranchNode, sParentColor, iFontSize)
		{
			for(var i = 0; i < oBranchNode.getChildCount(); i++)
			{
				var oTreeNode = oBranchNode.getChild(i);
				var oDrawing = oTreeNode.getDrawingObject();
				if(oDrawing)
				{
					var sColor = (oTreeNode.getColor() || sParentColor);
					if(oTreeNode.getChildCount() > 0)
					{
						drawTree(oTreeNode, sColor, iFontSize);
					}
					else
					{
						drawRect(oDrawing, sColor);
						drawLabel(oTreeNode, oDrawing, sColor, iFontSize);
					}
				}
			}
		}
		
		var drawRect = function(oDrawing, sColor)
		{
			var numX = getDrawingX(oDrawing);
			var numY = getDrawingY(oDrawing);
			var numWidth = getDrawingWidth(oDrawing);
			var numHeight = getDrawingHeight(oDrawing);
			_oGraphics.getContext().fillStyle = (sColor || DEFAULT_COLOR);
			_oGraphics.getContext().fillRect(numX, numY, numWidth, numHeight);
			_oGraphics.getContext().strokeRect(numX, numY, numWidth, numHeight);
		}
		
		var drawHoverRect = function(oDrawing)
		{
			var numWidth = getDrawingWidth(oDrawing);
			var numHeight = getDrawingHeight(oDrawing);
			var numLine = Math.min(numWidth, numHeight) * 0.2;
			if(numLine > 0.1)
			{
				numLine = Math.min(1, numLine);
				var numX = getDrawingX(oDrawing) + numLine * 2;
				var numY = getDrawingY(oDrawing) + numLine * 2;
				numWidth = numWidth - numLine * 4;
				numHeight = numHeight - numLine * 4;
				_oGraphics.getContext().save();
				_oGraphics.getContext().strokeStyle = "#000";
				_oGraphics.getContext().lineWidth = numLine;
				_oGraphics.getContext().strokeRect(numX, numY, numWidth, numHeight);
				_oGraphics.getContext().restore();
			}
		}
		
		var drawHover = function(oRootNode, arrHoverPathIdx, bHover)
		{
			var oTreeNode = oRootNode;
			var sColor = oTreeNode.getColor();
			for(var i = 0; i < arrHoverPathIdx.length; i++)
			{
				var iIdx = arrHoverPathIdx[i];
				oTreeNode = oTreeNode.getChild(iIdx);
				sColor = (oTreeNode.getColor() || sColor);
			}
			var oDrawing = oTreeNode.getDrawingObject();
			if(oDrawing)
			{
				bHover ? drawHoverRect(oDrawing) : drawRect(oDrawing, sColor);
				drawLabel(oTreeNode, oDrawing, sColor, getLabelFontSize());
			}
		}
		
		var getLabelFontSize = function()
		{
			return Util.getDataLabelFontSize(_oStyleTool);
		}
		
		var getLevelBorderWide = function(iContainsDeep)
		{
			return iContainsDeep * 2.4;
		}
		
		var createDrawingNode = function(numX, numY, numW, numH)
		{
			return [numX, numY, numW, numH];
		}
		var getDrawingX = function(oDrawing)
		{
			return oDrawing[0];
		}
		var getDrawingY = function(oDrawing)
		{
			return oDrawing[1];
		}
		var getDrawingWidth = function(oDrawing)
		{
			return oDrawing[2];
		}
		var getDrawingHeight = function(oDrawing)
		{
			return oDrawing[3];
		}
		
		var drawLabel = function(oTreeNode, oDrawing, sColor, iFontSize)
		{
			if(!_oAttr.isShowDataLabel())
			{
				return;
			}
			sColor = (sColor || DEFAULT_COLOR);
			var iPadding = 4;
			var numLeft = getDrawingX(oDrawing);
			var numTop = getDrawingY(oDrawing);
			var numRight = numLeft + getDrawingWidth(oDrawing);
			var numBottom = numTop + getDrawingHeight(oDrawing);
			numTop += iPadding * 1.5;
			numRight -= iPadding;
			var numTextX = numLeft + iPadding;
			var numTextY = numBottom - iPadding;
			while(oTreeNode && oTreeNode != _oModel.getRoot())
			{
				var sText = oTreeNode.getLabel();
				!sText && (sText = "");
				var numTextWidth = _oGraphics.getContext().measureText(sText).width;
				if(numTextX + numTextWidth > numRight || numTextY - iFontSize < numTop)
				{
					break;
				}
				Util.drawTextFitBackground(sColor, _oGraphics.getContext(), sText, numTextX, numTextY);
				numTextY -= iFontSize * 1.25;
				oTreeNode = oTreeNode.getParent();
			}
		}
	}
	
	function SunburstRender(oCtx, oModel, oAttr, iOffsetX, iOffsetY)
	{
		AbstractTreeRender.call(this, oCtx, oModel, oAttr);
		var _super = this.protectedMethod; 
		var _oGraphics = new Graphics(oCtx);
		var _oModel = oModel;
		var _oAttr = oAttr;
		var _oStyleTool = new StyleTool(oAttr);
		var _oDrawingModel;

		
		(function()
		{
			iOffsetX = (iOffsetX ? iOffsetX : 0);
			iOffsetY = (iOffsetY ? iOffsetY : 0);
			var iWidth = _oGraphics.getWidth();
			var iHeight = _oGraphics.getHeight();
			var iHalfWidth = (iWidth >> 1);
			var iHalfHeight = (iHeight >> 1);
			PolarCoordinate.transform(_oGraphics, iOffsetX + iHalfWidth, iOffsetY + iHalfHeight);
			var iUsableMaxRadius = Math.min(iHalfWidth - Math.abs(iOffsetX), iHalfHeight - Math.abs(iOffsetY));
			iUsableMaxRadius = Math.max(0, iUsableMaxRadius);
			var iPadding = Math.min(10, parseInt(iUsableMaxRadius * 0.05)); 
			var iWholeRadius = iUsableMaxRadius - iPadding;
			var numRadiusStart = Math.min(20, iWholeRadius * 0.1);
			_oDrawingModel = new DrawingModel();
			_oDrawingModel.setSize(iPadding, iWholeRadius, numRadiusStart);
		})();
		
		//@Implement AbstractTreeRender
		this.protectedSearchHoverTarget = function(iApiX, iApiY, arrPathIdx)
		{
			var arrXY = _oGraphics.retransformMouseXY(iApiX, iApiY);
			var numLogicX = arrXY[0];
			var numLogicY = arrXY[1];
			var numRadius = PolarCoordinate.logicXyToRadius(numLogicX, numLogicY);
			var bFound = false;
			if(numRadius < _oDrawingModel.getRadiusStart())
			{
				bFound = true;
				arrPathIdx.push(-1);
			}
			else if(numRadius < _oDrawingModel.getWholeRadius())
			{
				var numAngle = PolarCoordinate.logicXyToAngle(numLogicX, numLogicY, numRadius);
				var iLevel = _oDrawingModel.radiusToLevel(numRadius);
				var oBranchNode = _oModel.getRoot();
				for(var i = 0; i <= iLevel; i++)
				{
					for(var j = 0; j < oBranchNode.getChildCount(); j++)
					{
						var oSubTreeNode = oBranchNode.getChild(j);
						var oDrawing = oSubTreeNode.getDrawingObject();
						if(oDrawing && numAngle <= getDrawingAngleTo(oDrawing))
						{
							bFound = true;
							arrPathIdx[i] = j;
							oBranchNode = oSubTreeNode;
							break;
						}
					}
				}
			}
			return bFound;
		}
		
		this.drawChart = function(oHoverTarget)
		{
			var oRoot = _oModel.getRoot();
			var iLevelDeeps = _super.sumary(oRoot, _oAttr.isIgnoreNegative());
			_oDrawingModel.confirmRadiusPerLevel(iLevelDeeps);
			
			var oDrawingContext = new DrawingContext();
			(iLevelDeeps > 1) && oDrawingContext.transformColorStep(oRoot, iLevelDeeps);
			
			var oDrawing = createDrawingNode(0, 2 * Math.PI);
			oRoot.setDrawingObject(oDrawing);
			divideAngle(oRoot, 0);
			
			var sBackgroundColor = _oStyleTool.getBackgroundColor();
			_oGraphics.clearAll();
			_oGraphics.getContext().strokeStyle = sBackgroundColor;
			_oGraphics.getContext().lineWidth = 0.5;
			_oGraphics.getContext().textBaseline = "middle";
			Util.setupFont(_oGraphics.getContext(), getLabelFontSize());
			fillSectorWithColor(sBackgroundColor, 0, _oDrawingModel.getRadiusStart(), 0, Math.PI * 2);
			drawTree(oDrawingContext, oRoot, 0, oRoot.getColor());
			
			var arrHoverPathIdx = (oHoverTarget ? oHoverTarget.getPath() : null);
			arrHoverPathIdx = (arrHoverPathIdx && arrHoverPathIdx[0] >= 0 ? arrHoverPathIdx : null);
			arrHoverPathIdx && drawHover(oDrawingContext, oRoot, arrHoverPathIdx);
		}
		
		var divideAngle = function(oBranchNode, iLevel)
		{
			var numDrawingTotal = oBranchNode.getDrawingSize();
			if(!numDrawingTotal)
			{
				return;
			}
			var oDrawing = oBranchNode.getDrawingObject();
			var numAngleFrom = getDrawingAngleFrom(oDrawing);
			var numAngleTo = getDrawingAngleTo(oDrawing);
			var numAngleDelta = numAngleTo - numAngleFrom;
			for(var i = 0; i < oBranchNode.getChildCount(); i++)
			{
				var oTreeNode = oBranchNode.getChild(i);
				var numDrawingSize = oTreeNode.getDrawingSize();
				var numRatio = numDrawingSize / numDrawingTotal;
				numAngleTo = numAngleFrom + numAngleDelta * numRatio;
				var oDrawing = createDrawingNode(numAngleFrom, numAngleTo);
				oTreeNode.setDrawingObject(oDrawing);
				numAngleFrom = numAngleTo;
				if(oTreeNode.getChildCount() > 0)
				{
					divideAngle(oTreeNode, iLevel + 1);
				}
			}
		}
		
		var drawTree = function(oDrawingContext, oBranchNode, iLevel, sParentColor)
		{
			for(var i = 0; i < oBranchNode.getChildCount(); i++)
			{
				var oTreeNode = oBranchNode.getChild(i);
				var oDrawing = oTreeNode.getDrawingObject();
				if(oDrawing)
				{
					var sColor = (oTreeNode.getColor() || sParentColor);
					var sHsl = (oDrawingContext.searchHslColor(sColor, iLevel) || sColor);
					drawSector(iLevel, oDrawing, sHsl);
					drawLabel(oDrawingContext, iLevel, oTreeNode.getLabel(), oDrawing, sHsl);
					if(oTreeNode.getChildCount() > 0)
					{
						drawTree(oDrawingContext, oTreeNode, iLevel + 1, sColor);
					}
				}
			}
		}
		
		var drawHover = function(oDrawingContext, oRoot, arrPathIdx)
		{
			var oTreeNode = oRoot;
			var sColor;
			for(var i = 0; i < arrPathIdx.length; i++)
			{
				oTreeNode = oTreeNode.getChild(arrPathIdx[i]);
				!sColor && (sColor = oTreeNode.getColor());
			}
			var iRadiusMore = _oDrawingModel.hoverRadiusMore();
			for(var i = arrPathIdx.length - 1; i >= 0; i--)
			{
				var oDrawing = oTreeNode.getDrawingObject();
				drawSector(i, oDrawing, sColor, iRadiusMore);
				drawLabel(oDrawingContext, i, oTreeNode.getLabel(), oDrawing, sColor, iRadiusMore);
				oTreeNode = oTreeNode.getParent();
			}
		}
		
		var drawSector = function(iLevel, oDrawing, sColor, iRadiusMore)
		{
			var numAngleFrom = getDrawingAngleFrom(oDrawing);
			var numAngleTo = getDrawingAngleTo(oDrawing);
			var numInnerRadius = _oDrawingModel.levelToRadiusInner(iLevel);
			var numOuterRadius = _oDrawingModel.levelToRadiusInner(iLevel + 1) + (iRadiusMore ? iRadiusMore : 0);
			fillSectorWithColor(sColor, numInnerRadius, numOuterRadius, numAngleFrom, numAngleTo);
		}
		
		var fillSectorWithColor = function(sColor, numInnerRadius, numOuterRadius, numAngleFrom, numAngleTo)
		{
			if(numAngleFrom == numAngleTo)
			{
				return;
			}
			_oGraphics.getContext().fillStyle = sColor || DEFAULT_COLOR;
			_oGraphics.beginPath();
			_oGraphics.arc(0, 0, numOuterRadius, numAngleFrom, numAngleTo);
		    _oGraphics.arc(0, 0, numInnerRadius, numAngleTo, numAngleFrom, true);
		    _oGraphics.closePath();
			_oGraphics.fill();
			_oGraphics.stroke();
		}
		
		var drawLabel = function(oDrawingContext, iLevel, sText, oDrawing, sColor, iRadiusMore)
		{
			if(!_oAttr.isShowDataLabel() || !sText)
			{
				return;
			}
			var numAngleFrom = getDrawingAngleFrom(oDrawing);
			var numAngleTo = getDrawingAngleTo(oDrawing);
			if(numAngleTo - numAngleFrom < 0.05)
			{
				return;
			}
			var numRadiusInner = _oDrawingModel.levelToRadiusInner(iLevel) + (iRadiusMore ? iRadiusMore : 0);
			var numRadiusOuter = _oDrawingModel.levelToRadiusInner(iLevel + 1) + (iRadiusMore ? iRadiusMore : 0);
			var numRadiusMiddle = _oDrawingModel.levelToRadiusInner(iLevel + 0.5) + (iRadiusMore ? iRadiusMore : 0);
			var numAngleMiddle = (numAngleFrom + numAngleTo) * 0.5;
			var arrLogicXY = PolarCoordinate.toLogicXy(numAngleMiddle, numRadiusMiddle);
			var arrApiXY = _oGraphics.transformXY(arrLogicXY[0], arrLogicXY[1]);
			var numTextX = arrApiXY[0];
			var numTextY = arrApiXY[1];
			var numTextWidth = _oGraphics.getContext().measureText(sText).width;
			var numTextHeight = oDrawingContext.getTextHeight();
			numTextX = numTextX - numTextWidth * 0.5;
			var numX1 = numTextX;
			var numX2 = numTextX + numTextWidth;
			var numY1 = numTextY - numTextHeight * 0.5;
			var numY2 = numTextY + numTextHeight * 0.5
			var arrFourPoint = [[numX1, numY1], [numX2, numY1], [numX1, numY2], [numX2, numY2]];
			var bOutsideSector = false;
			for(var i = 0; i < arrFourPoint.length; i++)
			{
				var arrPoint = arrFourPoint[i];
				var arrXY = _oGraphics.retransformMouseXY(arrPoint[0], arrPoint[1]);
				var numX = arrXY[0];
				var numY = arrXY[1];
				var numRadius = PolarCoordinate.logicXyToRadius(numX, numY);
				if(numRadius < numRadiusInner || numRadius > numRadiusOuter)
				{
					bOutsideSector = true;
					break;
				}
				var numAngle = PolarCoordinate.logicXyToAngle(numX, numY, numRadius);
				if(numAngle < numAngleFrom || numAngle > numAngleTo)
				{
					bOutsideSector = true;
					break;
				}
			}
			if(!bOutsideSector)
			{
				sColor = (sColor || DEFAULT_COLOR);
				Util.drawTextFitBackground(sColor, _oGraphics.getContext(), sText, numTextX, numTextY);
			}
		}
		
		var createDrawingNode = function(numAngleFrom, numAngleTo)
		{
			return [numAngleFrom, numAngleTo];
		}
		var getDrawingAngleFrom = function(oDrawing)
		{
			return oDrawing[0];
		}
		var getDrawingAngleTo = function(oDrawing)
		{
			return oDrawing[1];
		}
		
		var getLabelFontSize = function()
		{
			return Util.getDataLabelFontSize(_oStyleTool);
		}
		
		function DrawingModel()
		{
			var _iPadding;
			var _iWholeRadius;
			var _numRadiusStart;
			var _numRadiusPerLevel;
			
			this.setSize = function(iPadding, iWholeRadius, numRadiusStart)
			{
				_iPadding = iPadding;
				_iWholeRadius = iWholeRadius;
				_numRadiusStart = numRadiusStart;
			}
			
			this.confirmRadiusPerLevel = function(iLevelDeeps)
			{
				_numRadiusPerLevel = Math.max(0, (_iWholeRadius - _numRadiusStart) / iLevelDeeps);
			}
			
			this.getWholeRadius = function()
			{
				return _iWholeRadius;
			}
			
			this.getRadiusStart = function()
			{
				return _numRadiusStart;
			}
			
			this.hoverRadiusMore = function()
			{
				return Math.min(_iPadding, parseInt(_numRadiusPerLevel * 0.1));
			}
			
			this.radiusToLevel = function(numRadius)
			{
				return parseInt((numRadius - _numRadiusStart) / _numRadiusPerLevel);
			}
			
			this.levelToRadiusInner = function(iLevel)
			{
				return _numRadiusStart + iLevel * _numRadiusPerLevel;
			}
		}
		
		function DrawingContext()
		{
			var _mapColor;
			var _numTextHeight;
			
			this.transformColorStep = function(oRoot, iLevelDeeps)
			{
				_mapColor = {};
				for(var i = 0; i < oRoot.getChildCount(); i++)
				{
					var oTreeNode = oRoot.getChild(i);
					var sColor = oTreeNode.getColor();
					if(sColor)
					{
						var arrHsl;
						if(ColorUtil.isFunctionHsl(sColor))
						{
							arrHsl = ColorUtil.decodeFunctionHsl(sColor);
						}
						else if(ColorUtil.isFunctionHsla(sColor))
						{
							arrHsl = ColorUtil.decodeFunctionHsla(sColor);
						}
						else
						{
							var arrRgb = ColorUtil.decodeStringToRgbArray(sColor);
							arrRgb && (arrHsl = ColorUtil.rgbToHsl(arrRgb[0], arrRgb[1], arrRgb[2]));
						}
						
						if(arrHsl)
						{
							var arrLevelColor = [sColor];
							_mapColor[sColor] = arrLevelColor;
							for(var iLevel = 1; iLevel < iLevelDeeps; iLevel++)
							{
								var iSaturation = arrHsl[1];
								var iLight = arrHsl[2];
								var numStepRatio = Math.min(4, iLevel) * 0.2;
								iSaturation += Math.round((100 - iSaturation) * numStepRatio);
								iLight += Math.round((100 - iLight) * numStepRatio);
								sColor = "hsl(" + arrHsl[0] + "," + iSaturation + "%," + iLight + "%)";
								arrLevelColor[iLevel] = sColor;
							}
						}
					}
				}
			}
			
			this.searchHslColor = function(sColor, iLevel)
			{
				var arrLevelColor = (_mapColor ? _mapColor[sColor] : null);
				return (arrLevelColor ? arrLevelColor[iLevel] : null);
			}
			
			this.getTextHeight = function()
			{
				!_numTextHeight && (_numTextHeight = getLabelFontSize());
				return _numTextHeight;
			}
		}
	}
	
	function KPICardChartRender(oModel, oCtx, iWidth, iHeight)
	{
		var _oCtx = oCtx;
		var _iWidth = iWidth;
		var _iHeight = iHeight;
		var _oModel = oModel;
		var _oAttr;
		var _oStyleTool;
		
		this.setAttr = function(oAttr)
		{
			_oAttr = oAttr;
			_oStyleTool = new StyleTool(oAttr);
		}
		this.getAttr = function()
		{
			return _oAttr;
		}
		
		this.drawChart = function()
		{
			var iValueCount = _oModel.getCategories().length;
			if(iValueCount == 0)
			{
				return;
			}
			
			var arrCaptionParts = getParts("caption", getCaptionColor, null);
			var arrPrimaryParts = getParts("primary", getPrimaryTextColor, getPrimaryValueColor);
			var arrSecondaryParts = getParts("secondary", getSecondaryTextColor, getSecondaryValueColor);
			
			var bHasCaption = (arrCaptionParts.length > 0 ? true : false);
			var bHasSecondary = hasSecondaryLine(arrSecondaryParts);
			
			var arrParam = confirmParams(bHasCaption, bHasSecondary);
			var iBigSize = arrParam[0];
			var iNormalSize = arrParam[1];
			var iYCaption = arrParam[2];
			var iYPrimary = arrParam[3];
			var iYSecondary = arrParam[4];
			
			_oCtx.textBaseline = "alphabetic";
			var arrCtx = drawPrimary(arrPrimaryParts, iYPrimary, iBigSize, iNormalSize);
			var iPrimaryLeft = arrCtx[0];
			var iPrimaryWidth = arrCtx[1];
			Util.setupFont(_oCtx, iNormalSize);
			bHasCaption && drawCaption(arrCaptionParts, iYCaption, iPrimaryLeft, iPrimaryWidth, iNormalSize);
			bHasSecondary && drawSecondary(arrSecondaryParts, iYSecondary, iNormalSize);
		}
		
		var getParts = function(sKey, funTextDefaultColorGetter, funValueDefaultColorGetter)
		{
			var arrCategory = _oModel.getCategories();
			var arrNode = _oModel.getSeries()[0].getNodes();
			var arrPart = [];
			for(var i = 0; i < arrCategory.length; i++)
			{
				var oCategory = arrCategory[i];
				if(startsWith(oCategory.getLabel(), sKey))
				{
					var bValue = endsWith(oCategory.getLabel(), "_value");
					var oNode = arrNode[i];
					var sDisplay = (oNode ? oNode.getText() : "");
					var sColor = oCategory.getColor();
					if(!sColor)
					{
						sColor = bValue ? funValueDefaultColorGetter() : funTextDefaultColorGetter();
					}
					arrPart.push([sDisplay, bValue, sColor]);
				}
			}
			return arrPart;
		}
		
		var startsWith = function(sSrc, sHead)
		{
			return (sSrc.indexOf(sHead) == 0);
		}
		
		var endsWith = function(sSrc, sTail)
		{
			return (sSrc.indexOf(sTail) == sSrc.length - sTail.length);
		}
		
		var getCaptionColor = function(){return _oStyleTool.getCustomStyle(KPICardChartRender.C_COLOR, "#999");}
		var getPrimaryValueColor = function(){return _oStyleTool.getCustomStyle(KPICardChartRender.P_VALUE_COLOR, "#6c7fae");}
		var getPrimaryTextColor = function(){return _oStyleTool.getCustomStyle(KPICardChartRender.P_TEXT_COLOR, "#999");}
		var getSecondaryValueColor = function(){return _oStyleTool.getCustomStyle(KPICardChartRender.S_VALUE_COLOR, "#6c7fae");}
		var getSecondaryTextColor = function(){return _oStyleTool.getCustomStyle(KPICardChartRender.S_TEXT_COLOR, "#999");}
		
		var confirmParams = function(bLineA, bLineC)
		{
			var numP1 = (bLineA && bLineC ? 2.5 : (bLineA || bLineC ? 2.2 : 2));
			var numP2 = 4;//(bLineA && bLineC ? 6 : (bLineA || bLineC ? 5 : 4));
			var iBigSize = Math.min(64, Math.max(20, Math.min(parseInt(_iHeight / numP1), parseInt(_iWidth / numP2))));
			var iNormalSize = Math.min(18, Math.max(14, parseInt(iBigSize * 0.25)));
			
			var iOffset = parseInt(iBigSize * ((bLineA && !bLineC) ? 1 : ((!bLineA && bLineC) ? 0.3 : 0.6)));
			var iYPrimary = parseInt((_iHeight + iOffset) / 2);
			var iYCaption = parseInt((iYPrimary - iBigSize) - iNormalSize * 0.5);
			var iYSecondary = iYPrimary + iNormalSize * 2.25;
			
			return [iBigSize, iNormalSize, iYCaption, iYPrimary, iYSecondary];
		}
		
		var drawCaption = function(arrCaptionParts, iY, iPrimaryLeft, iPrimaryWidth, iFontSize)
		{
			var arrOnePart = arrCaptionParts[0];
			var sCaption = arrOnePart[0];
			var sColor = arrOnePart[2];
			var iX = iPrimaryLeft;
			var iCaptionWidth = _oCtx.measureText(sCaption).width;
			if(iCaptionWidth > iPrimaryWidth)//标题长则居中，不是左对齐
			{
				iX = (_iWidth - iCaptionWidth) >> 1;
			}
			_oCtx.fillStyle = sColor;
			_oCtx.fillText(sCaption, iX, iY);
		}
		
		var drawPrimary = function(arrPrimaryParts, iY, iBigFontSize, iNormalFontSize)
		{
			var iAllWidth = 0;
			var arrPartsWidth = [];
			var bTryAgain = true;
			while(bTryAgain)
			{
				iAllWidth = 0;
				for(var i = 0; i < arrPrimaryParts.length; i++)
				{
					var arrOnePart = arrPrimaryParts[i];
					var sText = arrOnePart[0];
					var bValue = arrOnePart[1];
					Util.setupFont(_oCtx, (bValue ? iBigFontSize : iNormalFontSize));
					var iPartWidth = _oCtx.measureText(sText).width + (i == arrPrimaryParts.length - 1 ? 0 : 4);
					arrPartsWidth[i] = iPartWidth;
					iAllWidth += iPartWidth;
				}
				if(iAllWidth > _iWidth)
				{
					iBigFontSize -= 5;
					if(iBigFontSize < iNormalFontSize)
					{
						iBigFontSize += 5;
						bTryAgain = false;
					}
				}
				else
				{
					bTryAgain = false;
				}
			}
			var iTextLeft = (_iWidth - iAllWidth) >> 1;
			var iX = iTextLeft;
			for(var i = 0; i < arrPrimaryParts.length; i++)
			{
				var arrOnePart = arrPrimaryParts[i];
				var sText = arrOnePart[0];
				var bValue = arrOnePart[1];
				var sColor = arrOnePart[2];
				Util.setupFont(_oCtx, (bValue ? iBigFontSize : iNormalFontSize));
				_oCtx.fillStyle = sColor;
				_oCtx.fillText(sText, iX, iY);
				iX += arrPartsWidth[i];
			}
			return [iTextLeft, iAllWidth];
		}
		
		var drawSecondary = function(arrSecondaryParts, iY, iFontSize)
		{
			var iAllWidth = 0;
			var arrPartsWidth = [];
			for(var i = 0; i < arrSecondaryParts.length; i++)
			{
				var arrOnePart = arrSecondaryParts[i];
				var sText = arrOnePart[0];
				var iPartWidth = _oCtx.measureText(sText).width + (i == arrSecondaryParts.length - 1 ? 0 : 4);
				arrPartsWidth[i] = iPartWidth;
				iAllWidth += iPartWidth;
			}
			var iX = (_iWidth - iAllWidth) >> 1;
			for(var i = 0; i < arrSecondaryParts.length; i++)
			{
				var arrOnePart = arrSecondaryParts[i];
				var sText = arrOnePart[0];
				var sColor = arrOnePart[2];
				_oCtx.fillStyle = sColor;
				_oCtx.fillText(sText, iX, iY);
				iX += arrPartsWidth[i];
			}
		}
		
		var hasSecondaryLine = function(arrSecondaryParts)
		{
			for(var i = 0; i < arrSecondaryParts.length; i++)
			{
				var arrOnePart = arrSecondaryParts[i];
				var sText = arrOnePart[0];
				if(sText)
				{
					return true;
				}
			}
			return false;
		}
	}
	KPICardChartRender.C_COLOR = "kpiCaptionColor";
	KPICardChartRender.P_VALUE_COLOR = "kpiPrimaryValueColor";
	KPICardChartRender.P_TEXT_COLOR = "kpiPrimaryTextColor";
	KPICardChartRender.S_VALUE_COLOR = "kpiSecondaryValueColor";
	KPICardChartRender.S_TEXT_COLOR = "kpiSecondaryTextColor";
	
	function RadarChartRender(oCtx, oModel, oAttr, iWidth, iHeight, iOffsetX, iOffsetY)
	{
		var ANGLE_00_15 = Math.PI * 0.025; 
		var ANGLE_05_45 = Math.PI * 0.975;
		var ANGLE_06_15 = Math.PI * 1.025;   
		var ANGLE_11_45 = Math.PI * 1.975;
		var ANGLE_03_00 = Math.PI * 0.5;
		var ANGLE_09_00 = Math.PI * 1.5;
		
		var _oGraphics = new Graphics(oCtx);
		var _oModel = oModel;
		var _oAttr = oAttr;
		var _oStyleTool = new StyleTool(oAttr);
		var _iPolygonal;
		var _numAnglePerLongitude;
		var _numRadius;
		var _numBizFloor;
		var _numBizCeiling;
		var _iHoverCategoryIdx;
		
		(function()
		{
			_iPolygonal = (_oModel ? _oModel.getCategories().length : 0);
			_numAnglePerLongitude = Math.PI * 2 / _iPolygonal;
			_numRadius = Math.max(0, (Math.min(iWidth - 120, iHeight - 60) * 0.5));//减值是预留写字的空间
			var iDelta = 0;
			if(_iPolygonal % 2 == 1 && _iPolygonal > 2)
			{
				iDelta = parseInt(_numRadius * (1 - Math.sin(Math.PI * (_iPolygonal - 2) / _iPolygonal * 0.5)));
			}
			iOffsetX = (iOffsetX ? iOffsetX : 0);
			iOffsetY = (iOffsetY ? iOffsetY : 0) + (iDelta >> 1);
			PolarCoordinate.transform(_oGraphics, iOffsetX + (iWidth >> 1), iOffsetY + (iHeight >> 1));
		})();
		
		this.drawChart = function(iHoverCategoryIdx)
		{
			_iHoverCategoryIdx = iHoverCategoryIdx;
			_oGraphics.clearAll();
			if(_oModel)
			{
				drawSpiderWeb();//雷达底图，看起来是个“蜘蛛网”
				drawSkeeter();//数据点，是“蜘蛛网”上的“蚊子”
			}
		}
		
		this.apiXYToCategoryIndex = function(iApiX, iApiY)
		{
			var arrXY = _oGraphics.retransformMouseXY(iApiX, iApiY);
			var numLogicX = arrXY[0];
			var numLogicY = arrXY[1];
			var numRadius = PolarCoordinate.logicXyToRadius(numLogicX, numLogicY);
			var iIdx = -1;
			if(numRadius < _numRadius + 10)
			{
				var numAngle = PolarCoordinate.logicXyToAngle(numLogicX, numLogicY, numRadius);
				var iIdx = parseInt((numAngle + _numAnglePerLongitude * 0.5) / _numAnglePerLongitude);
				iIdx = (iIdx % _iPolygonal);
			}
			return iIdx;
		}
		
		var setupSpiderWebStyle = function()
		{
			var sLineColor = Util.getCustomStyle(_oStyleTool, RadarChartRender.WEB_LINE, "#ddd");
			var sBackColor = Util.getCustomStyle(_oStyleTool, RadarChartRender.WEB_INTERVAL_BACKGROUND, "#f7f7f7");
			_oGraphics.getContext().lineJoin = "round";
			_oGraphics.getContext().lineWidth = 1;
			_oGraphics.getContext().strokeStyle = sLineColor;
			_oGraphics.getContext().fillStyle = sBackColor;
		}
		
		var setupWebNumberStyle = function()
		{
			var sColor = Util.getCustomStyle(_oStyleTool, StyleTool.RULER_TEXT_COLOR, "#999");
			var iFontSize = parseInt(Util.getCustomStyle(_oStyleTool, StyleTool.RULER_FONTSIZE, 12));
			_oGraphics.getContext().fillStyle = sColor;
			Util.setupFont(_oGraphics.getContext(), iFontSize);
		}
		
		var setupWebLabelStyle = function()
		{
			_oGraphics.getContext().fillStyle = Util.getAxisTextColor(_oStyleTool);
			Util.setupFont(_oGraphics.getContext(), Util.getAxisTextFontSize(_oStyleTool));
		}
		
		var setupSkeeterTrackStyle = function(sColor)
		{
			var sFillColor = Util.createColorWithAlpha(sColor, 0.3);
			_oGraphics.getContext().lineWidth = 2.5;
			_oGraphics.getContext().strokeStyle = sColor;
			_oGraphics.getContext().fillStyle = sFillColor;
		}
		
		var setupSkeeterLabelStyle = function()
		{
			_oGraphics.getContext().fillStyle = Util.getDataLabelColor(_oStyleTool);
			_oGraphics.getContext().textBaseline = "middle";
			Util.setupFont(_oGraphics.getContext(), Util.getDataLabelFontSize(_oStyleTool));
		}
		
		//画蜘蛛网
		var drawSpiderWeb = function()
		{
			var oScopeAdapter = createScopeAdapter();
			var oNumberRulerHelper = new NumberRulerHelper(oScopeAdapter, _oStyleTool);
			var arrMark = oNumberRulerHelper.confirmRadarRulerMarker(_numRadius);
			_numBizFloor = arrMark[0];
			_numBizCeiling = arrMark[arrMark.length - 1];
			var numWidePerLatitude = Math.max(0, _numRadius / (arrMark.length - 1));
			
			setupSpiderWebStyle();
			drawWebLatitude(arrMark, numWidePerLatitude);
			
			setupWebLabelStyle();
			drawWebLongitude();
			
			if(_oAttr.isShowRulerMarkLabel())
			{ 
				setupWebNumberStyle();
				drawLatitudeNumber(arrMark, numWidePerLatitude);
			}
		}
		
		//纬线
		var drawWebLatitude = function(arrMark, numWidePerLatitude)
		{
			if(_iPolygonal < 3)
			{
				for(var j = arrMark.length - 1; j > 0; j --)
				{
					var numRadius = numWidePerLatitude * j;
					_oGraphics.arc(0, 0, numRadius, 0, 2 * Math.PI);
					_oGraphics.stroke();
				}
			}
			else
			{
				for(var j = arrMark.length - 1; j > 0; j -= 2)
				{
					_oGraphics.beginPath();
					var numRadius = numWidePerLatitude * j;
					for(var i = 0; i <= _iPolygonal; i++)
					{
						var numAngle = _numAnglePerLongitude * i;
						arcPointTo(numRadius, numAngle);
					}
					var numRadius = numWidePerLatitude * (j - 1);
					for(var i = _iPolygonal; i >= 0; i--)
					{
						var numAngle = _numAnglePerLongitude * i;
						arcPointTo(numRadius, numAngle, true);
					}
					_oGraphics.closePath();
					_oGraphics.fill();
					_oGraphics.stroke();
				}
			}
		}
		
		//经线及其末端的文字
		var drawWebLongitude = function()
		{
			var iWholeWidth = _oGraphics.getWidth();
			var iWholeHeight = _oGraphics.getHeight();
			var iGap = 4;
			var numLineHeight = Util.getTextHeight(_oGraphics.getContext());
			var oTextRender = new CuttingTextRender();
			var arrCategory = _oModel.getCategories();
			for(var i = 0; i < arrCategory.length; i++)
			{
				if(i == _iHoverCategoryIdx)
				{
					_oGraphics.getContext().save();
					_oGraphics.getContext().lineWidth = 2;
				}
				var numAngle = _numAnglePerLongitude * i;
				drawLongitudeLine(numAngle);
				if(i == _iHoverCategoryIdx)
				{
					_oGraphics.getContext().restore();
				}
				
				var sText = arrCategory[i].getLabel();
				var numUsableWith = iWholeWidth * 0.5 - Math.abs(Math.sin(numAngle)) * _numRadius;
				var arrXY = getPointXY(numAngle, _numRadius);
				var numX = arrXY[0];
				var numY = arrXY[1];
				var funMethod;
				if(ANGLE_00_15 < numAngle && numAngle < ANGLE_05_45)
				{
					numY += iGap;
					funMethod = oTextRender.drawAlignLeftWithLogicCoord;
				}
				else if(ANGLE_06_15 < numAngle && numAngle < ANGLE_11_45)
				{
					numY -= (numUsableWith + iGap);
					funMethod = oTextRender.drawAlignRightWithLogicCoord;
				}
				else
				{
					numUsableWith = iWholeWidth;
					numY -= numUsableWith * 0.5;
					funMethod = oTextRender.drawAlignCenterWithLogicCoord;
				}
				numX += Math.cos(numAngle) * numLineHeight;
				var numAbsMaxHeight = 0.5 * iWholeHeight;
				if(numX + 0.5 * numLineHeight > numAbsMaxHeight)//文字在上方超出画布
				{
					numX = numAbsMaxHeight - 0.5 * numLineHeight;
				}
				else if(numX - 0.5 * numLineHeight < -numAbsMaxHeight)//文字在下方超出画布
				{
					numX = -numAbsMaxHeight + 0.5 * numLineHeight;
				}
				funMethod(_oGraphics, numX, numY, sText, numUsableWith);
			}
		}
		
		//纬线上的刻度值
		var drawLatitudeNumber = function(arrMark, numWidePerLatitude)
		{
			var bTine = (_iPolygonal % 2 == 1);
			var numRadiusRatio = (bTine ? Math.cos(Math.PI / _iPolygonal) : 1);
			var oTextRender = new CuttingTextRender();
			oTextRender.setTextBaseline("bottom");
			var oFormater = new NumberFormater();
			oFormater.setFormatString(_oAttr.getRadarFormat());
			var sLastText = "";
			for(var j = 1; j < arrMark.length; j++)
			{
				var sText = oFormater.format(arrMark[j], NumberFormater.RoundingMode.DOWN);
				if(sText == sLastText)
				{
					continue;
				}
				sLastText = sText;
				var numWide = _numRadius;
				var numRadius = numWidePerLatitude * j * numRadiusRatio;
				var arrXY = getPointXY(Math.PI, numRadius);
				var numX = arrXY[0];//X轴向上，Y轴向右
				var numY = arrXY[1];
				if(bTine)
				{
					numY -= numWide / 2;
					oTextRender.drawAlignCenterWithLogicCoord(_oGraphics, numX, numY, sText, numWide);
				}
				else
				{
					numY += 2;
					oTextRender.drawAlignLeftWithLogicCoord(_oGraphics, numX, numY, sText, numWide);
				}
			}
		}
		
		//画蚊子--数据点
		var drawSkeeter = function()
		{
			var iWidth = _oGraphics.getWidth();
			var iHeight = _oGraphics.getHeight();
			var oNonoverlap = (_oAttr.isDataLabelOverlappable() ? null : new NonoverlappingConfirmer(-iHeight * 0.5, -iWidth * 0.5, iHeight, iWidth));//逻辑XY轴和高度颠倒
			var arrSeries = _oModel.getSeries();
			for(var j = arrSeries.length - 1; j >= 0; j--)
			{
				var oSeries = arrSeries[j];
				var arrNode = oSeries.getNodes();
				var sColor = oSeries.getColor();
				var arrAngle = [];
				var arrRadius = [];
				setupSkeeterTrackStyle(sColor);
				drawSkeeterTrack(arrNode, arrAngle, arrRadius);
				for(var i = 0; i < _iPolygonal; i++)
				{
					var oNode = arrNode[i];
					if(oNode)
					{
						var numRadius = arrRadius[i];
						var numAngle = arrAngle[i];
						drawPoint(numRadius, numAngle, (i == _iHoverCategoryIdx ? 2.5 : 1));
						_oAttr.isShowDataLabel() && drawSkeeterLabel(numRadius, numAngle, oNode.getText(), oNonoverlap);
					}
				}
			}
		}
		
		//同一系列的点间连线
		var drawSkeeterTrack = function(arrNode, arrAngle, arrRadius)
		{
			var bBroken = false;
			_oGraphics.beginPath();
			for(var i = 0; i < _iPolygonal; i++)
			{
				var oNode = arrNode[i];
				if(oNode)
				{
					arrAngle[i] = _numAnglePerLongitude * i;
					arrRadius[i] = getPointRadius(oNode.getValue());
					arcPointTo(arrRadius[i], arrAngle[i]);
				}
				else
				{
					bBroken = true;
					_oGraphics.stroke();
					_oGraphics.beginPath();
				}
			}
			if(bBroken)
			{
				var oNode = arrNode[0];
				oNode && arcPointTo(arrRadius[0], arrAngle[0]);
			}
			else
			{
				_oGraphics.closePath();
				_oAttr.isFillColor() && _oGraphics.fill();
			}
			_oGraphics.stroke();
		}
		
		//数据标签
		var drawSkeeterLabel = function(numRadius, numAngle, sText, oNonoverlap)
		{
			_oGraphics.getContext().save();
			setupSkeeterLabelStyle();
			var arrXY = getPointXY(numAngle, numRadius);
			var numTextWidth = _oGraphics.getContext().measureText(sText).width;
			var numTextHeight = Util.getTextHeight(_oGraphics.getContext()) * 0.9;
			var numX = arrXY[0] + (ANGLE_03_00 < numAngle && numAngle < ANGLE_09_00 ? -1 : 1) * numTextHeight;
			var numY = arrXY[1] - numTextWidth * 0.5;
			if(!oNonoverlap || oNonoverlap.isRectCanDraw(numX, numY - numTextHeight * 0.5, numTextHeight, numTextWidth))//逻辑XY轴和高度颠倒
			{
				_oGraphics.fillText(sText, numX, numY);
			}
			_oGraphics.getContext().restore();
		}
		
		var getPointRadius = function(numBizValue)
		{
			return (numBizValue - _numBizFloor) / (_numBizCeiling - _numBizFloor) * _numRadius;
		}
		
		var getPointXY = function(numAngle, numRadius)
		{
			return PolarCoordinate.toLogicXy(numAngle, numRadius);
		}
		
		var createScopeAdapter = function()
		{
			var oScope = _oModel.getScopes()[0];
			var oScopeAdapter = new RulerScaleAdapter(oScope);
			return oScopeAdapter;
		}
		
		var arcPointTo = function(numRadius, numAngle, bAnticlockwise)
		{
			var numDelta = (bAnticlockwise ? -0.0001 : 0.0001);
			_oGraphics.arc(0, 0, numRadius, numAngle, numAngle + numDelta, bAnticlockwise);
		}
		
		var drawLongitudeLine = function(numAngle)
		{
			_oGraphics.beginPath();
			_oGraphics.moveTo(0, 0);
			arcPointTo(_numRadius, numAngle);
			_oGraphics.stroke();
		}
		
		var drawPoint = function(numRadius, numAngle, iPointRadius)
		{
			var arrXY = getPointXY(numAngle, numRadius);
			_oGraphics.beginPath();
			_oGraphics.arc(arrXY[0], arrXY[1], iPointRadius, 0, 2 * Math.PI);
			_oGraphics.fill();
			_oGraphics.stroke();
		}
	}
	RadarChartRender.WEB_INTERVAL_BACKGROUND = "radarWebIntervalBackground";
	RadarChartRender.WEB_LINE = "radarWebLine"; 
	
	function AbstractVHProgresssChartRender()
	{
		var _this = this;
		var _super = this.protectedMethod;
		
		(function()
		{
			_this.setMode(AbstractColumnChartRender.MODE_OVERLAP);
		})();
		
		var _superProtectedDrawChart = this.protectedDrawChart;
		this.protectedDrawChart = function(oGraphics, numPixelPerValue)
		{
			_superProtectedDrawChart(oGraphics, numPixelPerValue);
			calculatePercentForTooltips();
		}
		
		var calculatePercentForTooltips = function()
		{
			var oDrawingModel = _this.getDrawingModel();
			var arrSeries = _super.getModel().getSeries();
			if(arrSeries.length < 2)
			{
				return;
			}
			var oPercentFormat = new NumberFormater();
			oPercentFormat.setFormatString("{-2}0.00%");
			var arrNodeOfSeries0 = arrSeries[0].getNodes();
			var arrNodeOfSeries1 = arrSeries[1].getNodes();
			var iCategoryCount = _super.getModel().getCategories().length;
			for(var i = 0; i < iCategoryCount; i++)
			{
				var oNode0 = arrNodeOfSeries0[i];
				var oNode1 = arrNodeOfSeries1[i];
				var numValue0 = (oNode0 ? oNode0.getValue() : NaN);
				var numValue1 = (oNode1 ? oNode1.getValue() : NaN);
				var sPercent;
				if(isNaN(numValue0) || isNaN(numValue1) || numValue0 === 0)
				{
					sPercent = "---";
				}
				else
				{
					sPercent = oPercentFormat.format(numValue1 / numValue0);
				}
				oDrawingModel.setPercentage(i, 0, sPercent);
			}
		}
		
		this.protectedDrawDataLabel = function(funTextLogicXYConfirmer, funDynamicStyleChanger, 
				oDrawingContext, arrSuitableSeries, oFormater, oNonoverlap, iFontSize)
		{
			var oGraphics = _super.getGraphics();
			var oCtx = oGraphics.getContext();
			var sBackgroundColor =  (arrSuitableSeries.length > 1 ? arrSuitableSeries[1].getColor() : null);
			var iCurrentCategoryIdx = -1;
			var oCurrentRect;
			var funDrawText = function(sText, funConfirmLogicXY)
			{
				var numTextWidth = oCtx.measureText(sText).width;
				var arrLogicXY = funConfirmLogicXY(numTextWidth);
				if(arrLogicXY == null)
				{
					return 0;
				}
				var arrApiXY = oGraphics.transformXY(arrLogicXY[0], arrLogicXY[1]);
				var numTextApiX = arrApiXY[0];
				var numTextApiY = arrApiXY[1] + 1;
				var numTextApiLeft = numTextApiX;
				var numTextApiTop = numTextApiY - iFontSize * 0.5;//baseline:middle
				if(oNonoverlap && !oNonoverlap.isRectCanDraw(numTextApiLeft, numTextApiTop, numTextWidth, iFontSize))
				{
					return 0;
				}
				var bHumble = funDynamicStyleChanger(iCurrentCategoryIdx, null);
				if(bHumble)
				{
					oCtx.fillText(sText, numTextApiX, numTextApiY);
				}
				else
				{
					var numX1 = oCurrentRect[0];
					var numY1 = oCurrentRect[1];
					var numX2 = oCurrentRect[2];
					var numY2 = oCurrentRect[3];
					var arrRectApiPa = oGraphics.transformXY(numX1, numY1);
					var arrRectApiPb = oGraphics.transformXY(numX2, numY2);
					var numRectApiX1 = Math.min(arrRectApiPa[0], arrRectApiPb[0]);
					var numRectApiX2 = Math.max(arrRectApiPa[0], arrRectApiPb[0]);
					var numRectApiY1 = Math.min(arrRectApiPa[1], arrRectApiPb[1]);
					var numRectApiY2 = Math.max(arrRectApiPa[1], arrRectApiPb[1]) + 1;
					var bAllInsideRect = (numRectApiX1 < numTextApiLeft && numTextApiLeft + numTextWidth < numRectApiX2
											&& numRectApiY1 < numTextApiTop && numTextApiTop + iFontSize < numRectApiY2);
					if(bAllInsideRect && sBackgroundColor)
					{
						Util.drawTextFitBackground(sBackgroundColor, oCtx, sText, numTextApiX, numTextApiY);
					}
					else
					{
						Util.drawTextWithShadow(_super.getStyleTool(), oCtx, sText, numTextApiX, numTextApiY);
					}
				}
				return numTextWidth;
			};
			
			var funFormatValue = function(numValue)
			{
				return (isNaN(numValue) ? "" : oFormater.format(numValue));
			};
			
			var iLabelType = _super.getAttr().getLabelType();
			var bShowNumber = ((iLabelType & AbstractXYProgressAttr.SHOW_LABEL_NUMBER) == AbstractXYProgressAttr.SHOW_LABEL_NUMBER);
			var bShowPercent = ((iLabelType & AbstractXYProgressAttr.SHOW_LABEL_PERCENT) == AbstractXYProgressAttr.SHOW_LABEL_PERCENT);
			var funFormatPercent = null;
			if(bShowPercent)
			{ 
				var oPercentFormat = new NumberFormater();
				oPercentFormat.setFormatString("{-2}0%");
				funFormatPercent = function(numNumerator, numDenominator)
				{
					return (isNaN(numNumerator) || isNaN(numDenominator) || numDenominator === 0 ? "" : oPercentFormat.format(numNumerator / numDenominator));
				};
			}
			
			var arrNodeOfSeries0 = arrSuitableSeries[0].getNodes();
			var arrNodeOfSeries1 = (arrSuitableSeries.length > 1 ? arrSuitableSeries[1].getNodes() : null);
			var iCategoryCount = _super.getModel().getCategories().length;
			for(var i = 0; i < iCategoryCount; i++)
			{
				var oNode0 = arrNodeOfSeries0[i];
				var oNode1 = (arrNodeOfSeries1 ? arrNodeOfSeries1[i] : null);
				if(!oNode0 || !oNode1)
				{
					continue;
				}
				var numValue0 = oNode0.getValue();
				var numValue1 = oNode1.getValue();
				var oDrawingRect0 = oDrawingContext.getDrawingRect(i, 0);
				var oDrawingRect1 = oDrawingContext.getDrawingRect(i, 1);
				iCurrentCategoryIdx = i;
				oCurrentRect = oDrawingRect1;
				_this.protectedDrawOneCagegoryDataLabel(numValue0, numValue1, oDrawingRect0, oDrawingRect1, 
						bShowNumber, bShowPercent, funDrawText, funFormatValue, funFormatPercent, iFontSize);
			}
		}
		this.protectedDrawOneCagegoryDataLabel = function(numValue0, numValue1, oDrawingRect0, oDrawingRect1, 
				bShowNumber, bShowPercent, funDrawText, funFormatValue, funFormatPercent, iFontSize)
		{
			throw new Error("Override");
		}
	}
	
	function VProgressChartRender(oCtx, oModel, oAttr)
	{
		VColumnChartRender.call(this, oCtx, oModel, oAttr);
		AbstractVHProgresssChartRender.call(this);
		
		this.protectedDrawOneCagegoryDataLabel = function(numValue0, numValue1, oDrawingRect0, oDrawingRect1, 
				bShowNumber, bShowPercent, funDrawText, funFormatValue, funFormatPercent, iFontSize)
		{
			var numMaxAbsY = 0;//目标值标签可以占用的下限（绝对值），使之画在外面且不与实际值重叠。
			if(oDrawingRect1)
			{
				var numRect1X1 = oDrawingRect1[0];
				var numRect1Y1 = oDrawingRect1[1];
				var numRect1X2 = oDrawingRect1[2];
				var numRect1Y2 = oDrawingRect1[3];
				
				numMaxAbsY = Math.max(Math.abs(numRect1Y2), iFontSize * 2.5);
				
				var numY = numRect1Y1 + (numRect1Y2 - numRect1Y1) / 2;
				var numMinAbsY = iFontSize * 0.7;//实际值起始位置（绝对值），使之不会穿过轴。
				if(bShowNumber && bShowPercent)
				{
					numY += iFontSize * 0.5;//一行变两行，上移半个行高（不管正负总是上移）
					(numValue1 >= 0) && (numMinAbsY = iFontSize * 1.7);
				}
				var iNegativeParam = (numValue1 < 0 ? -1 : 1);
				(Math.abs(numY) < numMinAbsY) && (numY = numMinAbsY * iNegativeParam);
				
				if(bShowNumber)
				{
					funDrawText(funFormatValue(numValue1), createLogicXYConfirmer(numRect1X1, numRect1X2, numY));
					numY -= iFontSize * 1.1;
				}
				if(bShowPercent)
				{
					funDrawText(funFormatPercent(numValue1, numValue0), createLogicXYConfirmer(numRect1X1, numRect1X2, numY));
				}
			}
			if(bShowNumber)
			{
				var numRect0X1 = oDrawingRect0[0];
				var numRect0Y1 = oDrawingRect0[1];
				var numRect0X2 = oDrawingRect0[2];
				var numRect0Y2 = oDrawingRect0[3];
				var iNegativeParam = (numValue0 < 0 ? -1 : 1);
				var numY = iNegativeParam * (Math.max(numMaxAbsY, Math.abs(numRect0Y2)) + iFontSize * 0.7);
				funDrawText(funFormatValue(numValue0), createLogicXYConfirmer(numRect0X1, numRect0X2, numY));
			}
		}
		
		var createLogicXYConfirmer = function(numX1, numX2, numY)
		{
			var funConfirmLogicXY = function(iTextWidth)
			{
				var numX = (numX1 + numX2 - iTextWidth) / 2;
				return [numX, numY];
			};
			return funConfirmLogicXY;
		}
	}
	
	function HProgressChartRender(oCtx, oModel, oAttr)
	{
		HColumnChartRender.call(this, oCtx, oModel, oAttr);
		AbstractVHProgresssChartRender.call(this);
		var _this = this;
		
		this.protectedDrawOneCagegoryDataLabel = function(numValue0, numValue1, oDrawingRect0, oDrawingRect1, 
				bShowNumber, bShowPercent, funDrawText, funFormatValue, funFormatPercent, iFontSize)
		{
			var iGap = 2;
			var numMinAbsY = iGap;
			if(oDrawingRect1)
			{
				var sText = "";
				if(bShowNumber)
				{
					sText = funFormatValue(numValue1);
				}
				if(bShowPercent)
				{
					var sPercent = funFormatPercent(numValue1, numValue0);
					sPercent && (sText = (bShowNumber ? (sText + " (" + sPercent + ")") : sPercent));
				}
				var numRect1X1 = oDrawingRect1[0];
				var numRect1Y1 = oDrawingRect1[1];
				var numRect1X2 = oDrawingRect1[2];
				var numRect1Y2 = oDrawingRect1[3];
				var numX = (numRect1X1 + numRect1X2) / 2;
				var numY = (numRect1Y1 + numRect1Y2) / 2;
				var iTextWidth = funDrawText(sText, 
					function(iTextWidth)
					{
						numY -= iTextWidth / 2;
						numY = (numValue1 < 0 ? Math.min(-numMinAbsY - iTextWidth, numY) : Math.max(numMinAbsY, numY));
						return [numX, numY];
					});
				if((numValue0 >= 0 && numValue1 >= 0) || (numValue0 < 0 && numValue1 < 0))
				{
					numMinAbsY = (numValue1 < 0 ? Math.abs(numY - iFontSize) : numY + iTextWidth + iFontSize);//a fontSize as gap
				}
			}
			if(!bShowNumber)
			{
				return;
			}
			var numPixelScopeMin = _this.getDrawingModel().getPixelMinY();
			var numPixelScopeMax = _this.getDrawingModel().getPixelMaxY();
			var numRect0X1 = oDrawingRect0[0];
			var numRect0Y1 = oDrawingRect0[1];
			var numRect0X2 = oDrawingRect0[2];
			var numRect0Y2 = oDrawingRect0[3];
			var iNegativeParam = (numValue0 < 0 ? -1 : 1);
			var numX = (numRect0X1 + numRect0X2) / 2;
			var numY = iNegativeParam * Math.max(Math.abs(numRect0Y2) + iGap, numMinAbsY);
			funDrawText(funFormatValue(numValue0), 
				function(iTextWidth)
				{
					if(numValue0 < 0)
					{
						numY -= iTextWidth;
						if(numY < numPixelScopeMin)
						{
							numY = numPixelScopeMin;
							if(numY + iTextWidth > -numMinAbsY)
							{
								return null;
							}
						}
					}
					else
					{
						if(numY + iTextWidth > numPixelScopeMax)
						{
							numY = numPixelScopeMax - iTextWidth;
							if(numY < numMinAbsY)
							{
								return null;
							}
						}
					}
					return [numX, numY];
				});
		}
	}
	
	function ProgressCircleChartRender(oCtx, oModel, oAttr)
	{
		var _oGraphics = new Graphics(oCtx);
		var _oModel = oModel;
		var _oAttr = oAttr;
		var _iDrawingRadius;
		var _iOuterRadius;
		var _iInnerRadius;
		var _iRingThickness;
		var _iRingThinness;
		var _sPercentage;
		
		(function()
		{
			var iWidth = _oGraphics.getWidth();
			var iHeight = _oGraphics.getHeight();
			var iMaxRadius = parseInt(Math.max(0, (Math.min(iWidth, iHeight) * 0.5)));
			var iUnit = parseInt(iMaxRadius * 0.1);
			_iOuterRadius = iMaxRadius - iUnit;
			_iDrawingRadius = _iOuterRadius - iUnit;
			_iInnerRadius = _iDrawingRadius - iUnit;
			_iRingThickness = iUnit * 2;
			_iRingThinness = parseInt(_iRingThickness * _oAttr.getOverlapShrinkingRatio());
			PolarCoordinate.transform(_oGraphics, (iWidth >> 1), (iHeight >> 1));
		})();
		
		this.apiXYToCheckInside = function(iApiX, iApiY)
		{
			var arrXY = _oGraphics.retransformMouseXY(iApiX, iApiY);
			var numLogicX = arrXY[0];
			var numLogicY = arrXY[1];
			var numRadius = PolarCoordinate.logicXyToRadius(numLogicX, numLogicY);
			return (numRadius <= _iOuterRadius);
		}
		
		this.getDrawingPercentage = function()
		{
			return _sPercentage;
		}
		
		this.drawChart = function()
		{
			draw(false);
		}
		
		this.drawChartWithAnimation = function()
		{
			draw(true);
		}
		
		var draw = function(bAnimate)
		{
			var sColorBack = _oModel.getSeries()[0].getColor();
			var sColorFront = _oModel.getSeries()[1].getColor();
			
			var numDesired = _oModel.getNode(0, 0).getValue();
			var numCompleted = _oModel.getNode(1, 0).getValue();
			
			var numPercent = null;
			if(_oAttr.isDataEmpty())
			{
				numPercent = _oAttr.getDataEmptyPercentageInstead() / 100;
			}
			else if(!isNaN(numDesired) && !isNaN(numCompleted) && numDesired !== 0)//有值，分母不为零
			{
				numPercent = numCompleted / numDesired;
				(numPercent < 0) && (numPercent = 0);//异号按完成率为0处理
				(_oAttr.isPercentageCeiling() && numPercent > 1) && (numPercent = 1);//封顶
			}
			_sPercentage = (numPercent === null ? "---" : Util.formatPercentage(numPercent, _oAttr.getPercentageDecimalDigit()));
			var numAngle = (numPercent === null ? 0 : Math.min(1, numPercent) * Math.PI * 2);
			
			_oGraphics.getContext().lineWidth = _iRingThickness;
			_oGraphics.getContext().strokeStyle = sColorBack;
			arc(Math.PI * 2);
			
			_oGraphics.getContext().lineWidth = _iRingThinness;
			_oGraphics.getContext().strokeStyle = sColorFront;
			bAnimate ? drawProgring(numAngle) : arc(numAngle);
			
			_oGraphics.getContext().fillStyle = sColorFront;
			drawText();
		}
		
		var drawProgring = function(numAngle)
		{
			//[0,2] -> [0,8] -> [2,10] -> (0.69,2.3) -> [4,14]
			var iStepCount = parseInt(Math.log(numAngle / Math.PI * 4 + 2) * 6 + 0.5);
			var iCurrentStep = 0;
			var funDrawing = 
				function()
				{
					iCurrentStep++;
					var numCurrentAngle = numAngle * iCurrentStep / iStepCount;
					arc(numCurrentAngle);
					if(iCurrentStep < iStepCount)
					{
						setTimeout(funDrawing, 40);
					}
				}
			funDrawing();
		}
		
		var arc = function(numAngle)
		{
			_oGraphics.beginPath();
			_oGraphics.arc(0, 0, _iDrawingRadius, 0, numAngle);
			_oGraphics.stroke();
		}
		
		var drawText = function()
		{
			var oTextRender = new ShrinkableTextRender();
			var iFontSize1 = Math.min(100, Math.max(10, Math.log(_iInnerRadius * 0.05) * 32));
			var iFontSize2 = Math.min(60, Math.max(6, Math.log(_iInnerRadius * 0.05) * 18));
			var sLabel = _oAttr.getLabelDesc();
			if(sLabel)
			{
				oTextRender.drawDualLineInCircle(_oGraphics, _iInnerRadius, _sPercentage, iFontSize1, sLabel, iFontSize2);
			}
			else
			{
				oTextRender.drawInCircle(_oGraphics, 0, _iInnerRadius, _sPercentage, iFontSize1);
			}
		}
	}
	
	function DialChartRender(oCtx, oModel, oAttr)
	{
		var _oGraphics = new Graphics(oCtx);
		var _oModel = oModel;
		var _oAttr = oAttr;
		var _oStyleTool = new StyleTool(oAttr);
		var _oDrawingModel;
		
		this.searchHoverTarget = function(iApiX, iApiY)
		{
			var arrXY = _oGraphics.retransformMouseXY(iApiX, iApiY);
			var numRadius = Math.sqrt(arrXY[0] * arrXY[0] + arrXY[1] * arrXY[1]);
			var numMaxRadius = _oDrawingModel.getMaxRadius();
			var bHoverPointer = false;
			var bHoverSection = false;
			if(numRadius < numMaxRadius)
			{
				if(numRadius < numMaxRadius - getMainMarkLength(numMaxRadius))
				{
					bHoverPointer = true;
				}
				else
				{
					bHoverSection = true;
				}
			}
			return new HoverTarget(bHoverPointer, bHoverSection);
		}
		
		this.getDrawingModel = function()
		{
			return _oDrawingModel;
		}
		
		this.drawChart = function()
		{
			draw(false);
		}
		
		this.drawChartWithAnimation = function()
		{
			draw(true);
		}
		
		var draw = function(bAnimate)
		{
			_oDrawingModel = new DrawingModel();
			var oDrawingContext = new DrawingContext();
			parseModel(oDrawingContext);
			parsePointerLabel(oDrawingContext);
			transformCoordinate(oDrawingContext);
			if(bAnimate)
			{
				var iTimes = Math.min(16, Math.max(6, parseInt(_oAttr.getArcDegree() * oDrawingContext.getPointerRatio() / 15)));
				var iDurationMs = 40;
				var iCount = 0;
				var funDrawing = function()
				{
					setTimeout(
						function()
						{
							drawAll(oDrawingContext, iCount / iTimes);
							if(iCount < iTimes)
							{
								iCount++;
								funDrawing();
							}
						},
						iDurationMs);
				};
				funDrawing();
			}
			else
			{
				drawAll(oDrawingContext, 1);
			}
		}
		
		var drawAll = function(oDrawingContext, numDynamic)
		{
			_oGraphics.clearAll();
			_oGraphics.getContext().textBaseline = "middle";
			drawPan(oDrawingContext);
			drawPointerLabel(oDrawingContext);
			drawPointer(oDrawingContext, numDynamic);
		}
		
		var getPointXY = function(iDegree, numRadius)
		{
			var numAngle = degreeToAngle(iDegree);
			return PolarCoordinate.toLogicXy(numAngle, numRadius);
		}
		
		var degreeToAngle = function(iDegree)
		{
			return iDegree * Math.PI / 180;
		}
		
		var ratioToDegree = function(numRatioByStartValue)
		{
			return _oAttr.getArcDegree() * numRatioByStartValue;
		}
		
		var ratioToAngle = function(numRatioByStartValue)
		{
			return degreeToAngle(ratioToDegree(numRatioByStartValue));
		}
		
		var toClockDegree = function(iDegree)
		{
			return ((iDegree - _oAttr.getRotate() - _oAttr.getArcDegree() * 0.5 + 360) % 360);
		}
		
		var isMoreThanHalfCircle = function()
		{
			return _oAttr.getArcDegree() >= 200;
		}
		
		var isMoreThanQuasiCircle = function()
		{
			return _oAttr.getArcDegree() >= 280;
		}
		
		//可用尺寸能分给几个半径
		var getRadiusTimes = function()
		{
			return 1 + Math.sin(degreeToAngle(Math.max(0, _oAttr.getArcDegree() - 180) / 2));
		}
		
		var getMainMarkLength = function(numMaxRadius)
		{
			return Math.min(88, numMaxRadius / 6);
		}
		
		var getPointerFontSize = function()
		{
			return Math.min(32, parseInt(Math.min(_oGraphics.getWidth() * 0.0618, _oGraphics.getHeight() * 0.1)));
		}
		
		var getPointerParam = function(numRadius)
		{
			var numPointerLength = numRadius * 0.75;
			var numRBase = 100 / getRadiusTimes();
			var numRPointHead = Math.log(numRadius / numRBase * 2.718) * 3;
			numRPointHead = Math.max(1, Math.min(6, numRPointHead));
			var numRNail = numRPointHead * 1.5;
			var numRShim = numRPointHead * 3;
			return [numPointerLength, numRPointHead, numRNail, numRShim];
		}
		
		var parseModel = function(oDrawingContext)
		{
			var arrProgressColor = ["#49a2ff", "#dde7fd"];
			var arrSeries = _oModel.getSeries();
			var oSeriesPointer = (arrSeries && arrSeries.length > 0 ? arrSeries[0] : null);
			var arrNode = (oSeriesPointer ? oSeriesPointer.getNodes() : null);
			var oNode = (arrNode ? arrNode[0] : null);
			var numPointerValue = (oNode ? oNode.getValue() : 0);
			var sPointerColor;
			var sPointerMeasureFormat = (oSeriesPointer ? oSeriesPointer.getFormatString() : null);
			var sPointerMeasureName = (oSeriesPointer ? oSeriesPointer.getName() : null);
			var arrScope = _oModel.getScopes();
			if(!arrScope || arrScope.length == 0)
			{
				if(numPointerValue < 0)
				{
					oDrawingContext.setValueScope(numPointerValue, 0);
					var numAddTiny = numPointerValue + (0 - numPointerValue) * 0.0001;
					oDrawingContext.createDrawingSection(numPointerValue, numAddTiny, arrProgressColor[0], null);
					oDrawingContext.createDrawingSection(numAddTiny, 0, arrProgressColor[1], null);
					_oDrawingModel.addSection(numPointerValue, 0, null, null, sPointerMeasureFormat);
				}
				else
				{
					oDrawingContext.setValueScope(0, numPointerValue);
					oDrawingContext.createDrawingSection(0, numPointerValue, arrProgressColor[0], null);
					_oDrawingModel.addSection(0, numPointerValue, null, null, sPointerMeasureFormat);
				}
				sPointerColor = arrProgressColor[0];
			}
			else if(arrScope.length == 1 && !arrScope[0].getColor())
			{
				var oScope = arrScope[0];
				var numMin = Math.min(oScope.getMin(), oScope.getMax());
				var numMax = Math.max(oScope.getMin(), oScope.getMax());
				oDrawingContext.setValueScope(numMin, numMax);
				var numAddTiny = numPointerValue + (numMax - numMin) * 0.0001;
				oDrawingContext.createDrawingSection(numMin, numAddTiny, arrProgressColor[0], null);
				oDrawingContext.createDrawingSection(numAddTiny, numMax, arrProgressColor[1], null);
				_oDrawingModel.addSection(numMin, numMax, null, null, sPointerMeasureFormat);
				sPointerColor = arrProgressColor[0];
			}
			else
			{
				var arrOrderedScope = [];
				var numStartValue = arrScope[0].getMin();
				var numRunningValue = numStartValue;
				var bSectionLabel = false;
				for(var i = 0; i < arrScope.length; i++)
				{
					var oScope = arrScope[i];
					var numMin = oScope.getMin();
					var numMax = oScope.getMax();
					var sSectionColor = oScope.getColor();
					var sSectionLabel = oScope.getTitle();
					bSectionLabel = bSectionLabel || (sSectionLabel ? true : false);
					_oDrawingModel.addSection(numMin, numMax, sSectionColor, sSectionLabel, sPointerMeasureFormat);
					
					var numSectionStartValue = Math.max(numMin, numRunningValue);
					numRunningValue = numSectionStartValue;
					var numSectionEndValue = Math.max(numMax, numRunningValue);
					numRunningValue = numSectionEndValue;
					arrOrderedScope.push([numSectionStartValue, numSectionEndValue, sSectionColor, sSectionLabel]);
					
					(!sPointerColor || numPointerValue >= numSectionStartValue) && (sPointerColor = sSectionColor);
				}
				var numEndValue = numRunningValue;
				oDrawingContext.setValueScope(numStartValue, numEndValue);
				oDrawingContext.setAnySectionLabelExist(bSectionLabel);
				for(var i = 0; i < arrOrderedScope.length; i++)
				{
					var arrOne = arrOrderedScope[i];
					oDrawingContext.createDrawingSection(arrOne[0], arrOne[1], arrOne[2], arrOne[3]);
				}
			}
			oDrawingContext.createDrawingPointer(numPointerValue, sPointerColor, sPointerMeasureFormat);
			_oDrawingModel.setPointerValue(numPointerValue, sPointerMeasureFormat, sPointerMeasureName);
		}
		
		var parsePointerLabel = function(oDrawingContext)
		{
			var iType = _oAttr.getPointerLabelType();
			var bShowName =  ((iType & DialAttr.SHOW_LABEL_NAME) == DialAttr.SHOW_LABEL_NAME);
			var bShowNumber = ((iType & DialAttr.SHOW_LABEL_NUMBER) == DialAttr.SHOW_LABEL_NUMBER);
			var bShowPercent = ((iType & DialAttr.SHOW_LABEL_PERCENT) == DialAttr.SHOW_LABEL_PERCENT);
			var arrTextLine = [];
			if(bShowName && _oAttr.getPointerName())
			{
				arrTextLine.push([_oAttr.getPointerName(), false]);
			}
			if(bShowNumber)
			{
				var sFormat = _oAttr.getPointerNumberFormat();
				(!sFormat) && (sFormat = oDrawingContext.getPointerMeasureFormat());
				var oFormater = new NumberFormater();
				oFormater.setFormatString(sFormat);
				var sNumber = oFormater.format(oDrawingContext.getPointerValue());
				arrTextLine.push([sNumber, true]);
			}
			if(bShowPercent)
			{
				var iDecimal = _oAttr.getPointerPercentDecimal();
				var numRatio = oDrawingContext.getPointerRatio();
				var sPercent = Util.formatPercentage(numRatio, iDecimal);
				arrTextLine.push([sPercent, true]);
			}
			oDrawingContext.setPointerLabel(arrTextLine);
		}
		
		var transformCoordinate = function(oDrawingContext)
		{
			var iDegreeStartOffset = 90 + _oAttr.getArcDegree() * 0.5 + _oAttr.getRotate();
			var numAngle = degreeToAngle(iDegreeStartOffset);
			var numRadiusTimes = getRadiusTimes();
			
			var iWidth = _oGraphics.getWidth();
			var iHeight = _oGraphics.getHeight();
			
			var bSectionLabel = oDrawingContext.hasSectionLabel();
			var iSectionLabelFontSize = Util.getAxisTextFontSize(_oStyleTool);
			var numPaddingTop = Math.min(iSectionLabelFontSize * (bSectionLabel ? 1.8 : 0.5), iHeight * 0.12);
			var numPaddingBottom = Math.min(iSectionLabelFontSize * (bSectionLabel ? 1.6 : 0.5), iHeight * 0.1);
			var numPaddingHorizontal = Math.min(iSectionLabelFontSize * (bSectionLabel ? 5 : 1), iWidth * 0.1);
			if(!isMoreThanHalfCircle() && _oAttr.getRotate() == 0)
			{
				var numPredictedRadius = Math.min(iWidth * 0.5, iHeight / numRadiusTimes);
				var arrPointerParam = getPointerParam(numPredictedRadius);
				var numRShim = arrPointerParam[3] + 2;
				numPaddingBottom = Math.max(numPaddingBottom, numRShim);
			}
			
			var numCoreWidth = Math.max(0, iWidth - numPaddingHorizontal * 2);
			var numCoreHeight = Math.max(0, iHeight - numPaddingTop - numPaddingBottom);
			
			var numRadius = Math.min(numCoreWidth, numCoreHeight) * 0.5; 
			var iOffsetY = numCoreHeight * 0.5 - numRadius;
			if(_oAttr.getRotate() == 0)//不旋转--正向，才考虑位置偏移，圆心靠下不在正中间。
			{
				var numRemainForBottomText = (isMoreThanHalfCircle() && !isMoreThanQuasiCircle() ? getPointerFontSize() * 1.2 : 0);
				var numUsableHeight = Math.max(0, numCoreHeight - numRemainForBottomText);
				numRadius = Math.min(numCoreWidth * 0.5, numUsableHeight / numRadiusTimes);
				iOffsetY = (numCoreHeight - (numRadius * numRadiusTimes + numRemainForBottomText)) * 0.5
			}
			var iOffsetX = numCoreWidth * 0.5 - numRadius;
			_oDrawingModel.setMaxRadius(numRadius);
			
			var numXScale = Math.cos(numAngle);
			var numYScale = numXScale;
			var numYLean = Math.sin(numAngle); 
			var numXLean = -numYLean;
			var numXMove = numPaddingHorizontal + iOffsetX + numRadius;
			var numYMove = numPaddingTop + iOffsetY + numRadius;
			_oGraphics.setTransformMatrix(numXScale, numXLean, numYLean, numYScale, numXMove, numYMove);
		}
		
		var drawPan = function(oDrawingContext)
		{
			var bWithTrack = (_oAttr.getPanStyle() == DialAttr.PAN_STYLE_WITH_TRACK);
			var numROut = _oDrawingModel.getMaxRadius();
			var iMainMarkLen = getMainMarkLength(numROut);
			var numRMarkIn = numROut - iMainMarkLen;
			var numRSubMarkIn = numROut - iMainMarkLen * (bWithTrack ? 0.8 : 0.4);
			var numRTrackIn = numROut - iMainMarkLen * (_oAttr.isShowRulerMarkLabel() ? 0.618 : 1);
			
			var numStartValue = oDrawingContext.getStartValue();
			var numEndValue = oDrawingContext.getEndValue();
			var oScope = new AxisValueScope();
			oScope.setMin(numStartValue);
			oScope.setMax(numEndValue);
			var sRulerStart = AbstractAttr.RulerStart_Zero;
			if(numStartValue > 0 || numEndValue < 0)
			{
				oScope.setCuttableFootForLinear(numStartValue > 0 ? numStartValue : Math.abs(numEndValue));
				sRulerStart = AbstractAttr.RulerStart_Nonzero;
			}
			var oScopeAdapter = new RulerScaleAdapter(oScope, AbstractAttr.RulerScale_Linear, sRulerStart);
			var oNumberRulerHelper = new NumberRulerHelper(oScopeAdapter, null);
			var iMarkParam = (_oAttr.getArcDegree() < 90 ? 3 : (_oAttr.getArcDegree() < 180 ? 5 : 7));
			var arrMarkValue = oNumberRulerHelper.confirmDialMark(iMarkParam);
			if(arrMarkValue.length < 2)
			{
				return;
			}
			
			var numSubMarkValueDelta = (arrMarkValue[1] - arrMarkValue[0]) / 5;
			for(var j = 1; j < 5; j++)
			{
				var numSubMark = arrMarkValue[0] - numSubMarkValueDelta * j;
				(numSubMark >= numStartValue) && paintMark(oDrawingContext, numSubMark, numROut, numRSubMarkIn, 1);
			}
			for(var i = 0; i < arrMarkValue.length; i++)
			{
				var numMark = arrMarkValue[i];
				paintMark(oDrawingContext, numMark, numROut, numRMarkIn, 2.5);
				_oAttr.isShowRulerMarkLabel() && paintMarkLabel(oDrawingContext, numMark, numRMarkIn);
				for(var j = 1; j < 5; j++)
				{
					var numSubMark = numMark + numSubMarkValueDelta * j;
					(numSubMark <= numEndValue) && paintMark(oDrawingContext, numSubMark, numROut, numRSubMarkIn, 1.5);		
				}
			}
			
			if(bWithTrack)
			{
				for(var i = 0, c = oDrawingContext.getSectionCount(); i < c; i++)
				{
					var numSectionStartRatio = oDrawingContext.getSectionStartRatio(i);
					var numSectionEndRatio = oDrawingContext.getSectionEndRatio(i);
					var sSectionColor = oDrawingContext.getSectionColor(i);
					paintSection(numSectionStartRatio, numSectionEndRatio, numROut, numRTrackIn, sSectionColor);
				}
			}
			
			if(oDrawingContext.hasSectionLabel())
			{
				for(var i = 0, c = oDrawingContext.getSectionCount(); i < c; i++)
				{
					var numSectionMiddleRatio = oDrawingContext.getSectionMiddleRatio(i);
					var sLabel = oDrawingContext.getSectionLabel(i);
					var sSectionColor = oDrawingContext.getSectionColor(i);
					sLabel && paintSectionLabel(sLabel, numROut, numSectionMiddleRatio, sSectionColor);
				}
			}
		}
		
		var drawPointer = function(oDrawingContext, numDynamic)
		{
			var arrParam = getPointerParam(_oDrawingModel.getMaxRadius());
			var numPointerLength = arrParam[0];
			var numRPointHead = arrParam[1];
			var numRNail = arrParam[2];
			var numRShim = arrParam[3];
			
			_oGraphics.getContext().fillStyle = "rgba(215,235,255,0.5)";
			_oGraphics.beginPath();
			_oGraphics.arc(0, 0, numRShim, 0, Math.PI * 2);
			_oGraphics.fill();
			
			var numPointerAngle = ratioToAngle(oDrawingContext.getPointerRatio() * numDynamic);
			_oGraphics.getContext().fillStyle = oDrawingContext.getPointerColor();
			_oGraphics.beginPath();
			arcPointTo(numRPointHead, numPointerAngle - Math.PI * 0.5);
			arcPointTo(numPointerLength, numPointerAngle);
			arcPointTo(numRPointHead, numPointerAngle + Math.PI * 0.5);
			_oGraphics.closePath();
			_oGraphics.fill();
			
			_oGraphics.getContext().fillStyle = "#999";
			_oGraphics.beginPath();
			_oGraphics.arc(0, 0, numRNail, 0, Math.PI * 2);
			_oGraphics.fill();
		}
		
		var drawPointerLabel = function(oDrawingContext)
		{
			var iFontSize = getPointerFontSize();
			var numLineHeight = iFontSize * 1.2;
			var arrTextLine = oDrawingContext.getPointerLabel();
			var numBaseRadius;
			var iBaseDegree;
			if(isMoreThanHalfCircle())
			{
				if(isMoreThanQuasiCircle())
				{
					numBaseRadius = _oDrawingModel.getMaxRadius() * (getRadiusTimes() - 1) - numLineHeight * (arrTextLine.length > 1 ? 2.5 : 1.8);
				}
				else
				{
					numBaseRadius = _oDrawingModel.getMaxRadius() * (getRadiusTimes() - 1) - (arrTextLine.length > 1 ? numLineHeight * 0.4 : 0);
				}
				iBaseDegree = _oAttr.getArcDegree() * 0.5 + 180 + _oAttr.getRotate();
				arrTextLine = arrTextLine.slice(0).reverse();
			}
			else
			{
				numBaseRadius = iFontSize * 1.5;
				iBaseDegree = _oAttr.getArcDegree() * 0.5 + _oAttr.getRotate();
			}
			
			_oGraphics.getContext().fillStyle = oDrawingContext.getPointerColor();
			for(var i = 0; i < arrTextLine.length; i++)
			{
				var arrTextWrap = arrTextLine[i];
				var sText = arrTextWrap[0];
				var bNumber = arrTextWrap[1];
				Util.setupFont(_oGraphics.getContext(), iFontSize * (bNumber ? 1 : 0.8));
				var numLineMiddle = numBaseRadius + numLineHeight * i;
				var arrLogicXY = getPointXY(iBaseDegree, numLineMiddle);
				var numTextWidth = _oGraphics.getContext().measureText(sText).width;
				if(numTextWidth > _oDrawingModel.getMaxRadius() * 2)
				{
					sText = Util.shortenText(sText, numTextWidth, _oDrawingModel.getMaxRadius() * 2, _oGraphics.getContext());
					numTextWidth = _oGraphics.getContext().measureText(sText).width;
				}
				Util.drawShadowText(_oStyleTool, _oGraphics, sText, arrLogicXY[0], arrLogicXY[1], 
					function(arrApiXY)
					{
						arrApiXY[0] = arrApiXY[0] - numTextWidth * 0.5;
					});
			}
		}
		
		var paintMarkLabel = function(oDrawingContext, numMarkValue, numRadius)
		{
			var sFormat = _oAttr.getRulerMarkLabelFormat();
			(!sFormat) && (sFormat = oDrawingContext.getPointerMeasureFormat());
			var oFormater = new NumberFormater();
			oFormater.setFormatString(sFormat);
			var sText = oFormater.format(numMarkValue);
			
			var iFontSize = Util.getAxisTextFontSize(_oStyleTool);
			Util.setupFont(_oGraphics.getContext(), iFontSize);
			_oGraphics.getContext().fillStyle = Util.getAxisTextColor(_oStyleTool);
			var numTextWidth = _oGraphics.getContext().measureText(sText).width;
			
			var arrWrap = oDrawingContext.calculateDrawingMark(numMarkValue);
			var numRatio = arrWrap[0];
			var iDegree = ratioToDegree(numRatio);
			var numClockAngle = degreeToAngle(toClockDegree(iDegree));
			
			numRadius = Math.max(0, numRadius - iFontSize * (0.5 + 0.5 * Math.abs(Math.cos(numClockAngle))));
			var arrLogicXY = getPointXY(iDegree, numRadius);
			_oGraphics.fillText(sText, arrLogicXY[0], arrLogicXY[1],
				function(arrApiXY)
				{
					arrApiXY[0] = arrApiXY[0] - numTextWidth * 0.5 * (1 + Math.sin(numClockAngle));
				});
		}
		
		var paintMark = function(oDrawingContext, numMarkValue, numR1, numR2, iLineWidth)
		{
			var arrWrap = oDrawingContext.calculateDrawingMark(numMarkValue);
			var numRatio = arrWrap[0];
			var sColor = arrWrap[1];
			var numAngle = ratioToAngle(numRatio);
			_oGraphics.getContext().lineWidth = iLineWidth;
			_oGraphics.getContext().strokeStyle = sColor;
			_oGraphics.beginPath();
			arcPointTo(numR1, numAngle);
			arcPointTo(numR2, numAngle);
			_oGraphics.stroke();
		}
		
		var paintSection = function(numSectionStartRatio, numSectionEndRatio, numR1, numR2, sSectionColor)
		{
			var numAngleStart = ratioToAngle(numSectionStartRatio);
			var numAngleEnd = ratioToAngle(numSectionEndRatio);
			_oGraphics.getContext().lineWidth = 1;
			_oGraphics.getContext().strokeStyle = sSectionColor;
			_oGraphics.getContext().fillStyle = sSectionColor;
			_oGraphics.beginPath();
			_oGraphics.arc(0, 0, numR1, numAngleStart, numAngleEnd);
			_oGraphics.arc(0, 0, numR2, numAngleEnd, numAngleStart, true);
			_oGraphics.closePath();
			_oGraphics.stroke();
			_oGraphics.fill();
		}
		
		var paintSectionLabel = function(sLabel, numRadius, numSectionMiddleRatio, sSectionColor)
		{
			var iFontSize = Util.getAxisTextFontSize(_oStyleTool);
			Util.setupFont(_oGraphics.getContext(), iFontSize);
			_oGraphics.getContext().fillStyle = sSectionColor;
			var iDegree = ratioToDegree(numSectionMiddleRatio);
			var numClockAngle = degreeToAngle(toClockDegree(iDegree));
			numRadius = numRadius + iFontSize * (0.5 + 0.5 * Math.abs(Math.cos(numClockAngle)));
			var arrLogicXY = getPointXY(iDegree, numRadius);
			var numTextWidth = _oGraphics.getContext().measureText(sLabel).width;
			Util.drawShadowText(_oStyleTool, _oGraphics, sLabel, arrLogicXY[0], arrLogicXY[1],
				function(arrApiXY)
				{
					var numX = arrApiXY[0] - numTextWidth * 0.5 * (1 - Math.sin(numClockAngle));
					(numX + numTextWidth > _oGraphics.getWidth()) && (numX = _oGraphics.getWidth() - numTextWidth);
					(numX < 0) && (numX = 0);
					arrApiXY[0] = numX;
				});
		}
		
		var arcPointTo = function(numRadius, numAngle)
		{
			_oGraphics.arc(0, 0, numRadius, numAngle, numAngle + 0.0001);
		}
		
		function DrawingModel()
		{
			var _numMaxRadius;
			var _arrSection = [];
			var _sPointerName;
			var _sPointerText;
			
			this.setMaxRadius = function(numRadius)
			{
				_numMaxRadius = numRadius;
			}
			this.getMaxRadius = function()
			{
				return _numMaxRadius;
			}
			
			this.addSection = function(numStartValue, numEndValue, sSectionColor, sSectionLabel, sPointerMeasureFormat)
			{
				var sStart = numStartValue;
				var sEnd = numEndValue;
				if(sPointerMeasureFormat)
				{
					var oFormater = new NumberFormater();
					oFormater.setFormatString(sPointerMeasureFormat);
					sStart = oFormater.format(numStartValue);
					sEnd = oFormater.format(numEndValue);
				}
				var oSection = [sStart, sEnd, sSectionColor, sSectionLabel];
				_arrSection.push(oSection);
			}
			this.getSectionCount = function()
			{
				return _arrSection.length;
			}
			this.getSectionStart = function(iIdx)
			{
				return _arrSection[iIdx][0];
			}
			this.getSectionEnd = function(iIdx)
			{
				return _arrSection[iIdx][1];
			}
			this.getSectionColor = function(iIdx)
			{
				return _arrSection[iIdx][2];
			}
			this.getSectionLabel = function(iIdx)
			{
				return _arrSection[iIdx][3];
			}
			
			this.setPointerValue = function(numValue, sPointerMeasureFormat, sPointerMeasureName)
			{
				_sPointerName = sPointerMeasureName;
				_sPointerText = numValue;
				if(sPointerMeasureFormat)
				{
					var oFormater = new NumberFormater();
					oFormater.setFormatString(sPointerMeasureFormat);
					_sPointerText = oFormater.format(numValue);
				}
			}
			this.getPointerName = function()
			{
				return _sPointerName;
			}
			this.getPointerText = function()
			{
				return _sPointerText;
			}
		}
		
		function DrawingContext()
		{
			var _this = this;
			var _numStartValue;
			var _numEndValue;
			var _oPointer;
			var _arrPointerLabelLine = [];
			var _arrSection = [];
			var _bSectionLabel = false;
			
			this.setValueScope = function(numStartValue, numEndValue)
			{
				_numStartValue = numStartValue;
				_numEndValue = numEndValue;
			}
			this.getStartValue = function()
			{
				return _numStartValue;
			}
			this.getEndValue = function()
			{
				return _numEndValue;
			}
			
			this.createDrawingSection = function(numSectionStartValue, numSectionEndValue, sSectionColor, sSectionLabel)
			{
				var numSectionMdiileValue = numSectionStartValue + (numSectionEndValue - numSectionStartValue) * 0.5;
				var numSectionMiddleRatio = calculateDrawingRatio(numSectionMdiileValue);
				var numSectionStartRatio = calculateDrawingRatio(numSectionStartValue);
				var numSectionEndRatio = calculateDrawingRatio(numSectionEndValue);
				var oSection = [numSectionStartRatio, numSectionMiddleRatio, numSectionEndRatio, sSectionColor, sSectionLabel];
				_arrSection.push(oSection);
			}
			this.getSectionCount = function()
			{
				return _arrSection.length;
			}
			this.getSectionStartRatio = function(iIdx)
			{
				return _arrSection[iIdx][0];
			}
			this.getSectionMiddleRatio = function(iIdx)
			{
				return _arrSection[iIdx][1]; 
			}
			this.getSectionEndRatio = function(iIdx)
			{
				return _arrSection[iIdx][2];
			}
			this.getSectionColor = function(iIdx)
			{
				return _arrSection[iIdx][3];
			}
			this.getSectionLabel = function(iIdx)
			{
				return _arrSection[iIdx][4];
			}
			
			this.setAnySectionLabelExist = function(bSectionLabel)
			{
				_bSectionLabel = bSectionLabel;
			}
			this.hasSectionLabel = function()
			{
				return _bSectionLabel;
			}
			
			this.createDrawingPointer = function(numPointerValue, sPointerColor, sPointerMeasureFormat)
			{
				_oPointer = [numPointerValue, sPointerColor, sPointerMeasureFormat];
			}
			this.getPointerRatio = function()
			{
				return calculateDrawingRatio(_oPointer[0]);
			}
			this.getPointerValue = function()
			{
				return _oPointer[0];
			}
			this.getPointerColor = function()
			{
				return _oPointer[1];
			}
			this.getPointerMeasureFormat = function()
			{
				return _oPointer[2];
			}
			
			this.setPointerLabel = function(arrLine)
			{
				_arrPointerLabelLine = arrLine;
			}
			this.getPointerLabel = function()
			{
				return _arrPointerLabelLine;
			}
			
			this.calculateDrawingMark = function(numMark)
			{
				var numMarkRatio = calculateDrawingRatio(numMark);
				var sMarkColor = "#999";
				var iLastSectionIdx = _this.getSectionCount() - 1;
				for(var i = iLastSectionIdx; i >= 0; i--)
				{
					var numSectionStartRatio = _this.getSectionStartRatio(i);
					var numSectionEndRatio = (i == iLastSectionIdx ? Infinity : _this.getSectionEndRatio(i));
					if(numSectionStartRatio <= numMarkRatio && numMarkRatio < numSectionEndRatio)
					{
						sMarkColor = _this.getSectionColor(i);
						break;
					}
				}
				return [numMarkRatio, sMarkColor];
			}
			
			var calculateDrawingRatio = function(numValue)
			{
				var numDelta = _numEndValue - _numStartValue;
				var numRatio = (numDelta == 0 ? 0 : (numValue - _numStartValue) / numDelta);
				return Math.min(1, Math.max(0, numRatio));
			}
		}
		
		function HoverTarget(bPointer, bSections)
		{
			var _bPointer = bPointer;
			var _bSections = bSections;
			
			this.isHoverPointer = function()
			{
				return _bPointer;
			}
			
			this.isHoverSections = function()
			{
				return _bSections;
			}
			
			this.isEquals = function(oAnother)
			{
				if(oAnother)
				{
					return _bPointer == oAnother.isHoverPointer()
						&& _bSections == oAnother.isHoverSections();
				}
				return false;
			}
		}
	}
	
	function AbstractScrollableList(oCtx, oModel, oAttr)
	{
		var ICON_ARROW_ROTATE = {"N":0, "NE":0.25, "E":0.5, "SE":0.75, "S":1, "SW":1.25, "W":1.5, "NW":1.75};
		
		var _this = this;
		var _oCtx = oCtx;
		var _oModel = oModel;
		var _oAttr = oAttr;
		var _oStyleTool = new StyleTool(oAttr);
		
		var _iWidth;
		var _iHeight;
		var _iRowHeight;
		
		var _iBodyTop;
		var _iBodyBottom;
		var _iScrollingAreaY;
		var _iSrcollingOffsetY;
		var _bScrollingLoopableAlways = false;
		
		var _bScrollable = false;
		var _iHoverRowIdx = -1;
		
		var setSizeContext = function(iAllWidth, iAllHeight, iRowHeight)
		{
			_iWidth = iAllWidth;
			_iHeight = iAllHeight;
			_iRowHeight = iRowHeight;
		}
		
		this.apiXYToRowIndex = function(iApiX, iApiY)
		{
			var iRowIdx = -1;
			var iBodyTopOffset = _this.protectedGetBodyTopOffset();
			var iBodyTop = _iBodyTop + iBodyTopOffset;
			var iBodyBottom = _iBodyBottom - iBodyTopOffset;
			if(iBodyTop <= iApiY && iApiY < iBodyBottom)//除去表头表尾
			{
				var iY = iApiY - iBodyTop;
				var bInFixedArea = true;//在冻结区
				if(iApiY >= _iScrollingAreaY + iBodyTopOffset)
				{
					bInFixedArea = false;//在滚动区
					iY = iY - _iSrcollingOffsetY;
				}
				var iLogicBodyHeight = _oModel.getRowCount() * _iRowHeight;
				if(iY >= iLogicBodyHeight)//超过第一片
				{
					if(!_bScrollable || iY < iLogicBodyHeight + getGapBetweenPieces())//在两片间距中（_iSrcollingOffsetY为负数时）
					{
						iY = -1;
					}
					else
					{
						iY = iY - iLogicBodyHeight - getGapBetweenPieces() + (_iScrollingAreaY - _iBodyTop);
					}
				}
				iRowIdx = Math.floor(iY / _iRowHeight);
				if(!bInFixedArea && _iSrcollingOffsetY > 0 && iRowIdx < _oAttr.getStickRows())//在两片间距中（_iSrcollingOffsetY为正数时）
				{
					iRowIdx = -1;
				}
			}
			return iRowIdx;
		}
		
		this.redrawWhenHover = function(iHoverRowIdx)
		{
			_iHoverRowIdx = iHoverRowIdx;
			if(_oAttr.isAutoScroll() && _bScrollable)
			{
				_this.drawScrollableArea(0, true);
			}
			else
			{
				var iStickRows = _oAttr.getStickRows();
				var iOffsetY = (_iSrcollingOffsetY >= 0 ? _iSrcollingOffsetY : (_iSrcollingOffsetY % _iRowHeight));
				var iOffsetRows = (_iSrcollingOffsetY >= 0 ? 0 : parseInt(-_iSrcollingOffsetY / _iRowHeight));
				var iFromRowIdx = _oAttr.getStickRows() + iOffsetRows;
				var iToRowIdx = _oModel.getRowCount() - 1;
				var iY = _iScrollingAreaY + iOffsetY;
				drawRows(iFromRowIdx, iToRowIdx, iY);
				if(iStickRows > 0)
				{
					var iFixedAreaLastRowIdx = iStickRows - 1;
					drawRows(0, iFixedAreaLastRowIdx, _iBodyTop);
				}
				var iHeadHeight = _this.protectedGetHeadRowHeight(_iRowHeight);
				_this.protectedDrawHead(0, 0, _iWidth, iHeadHeight);//不仅仅为了盖掉滚动痕迹，当垂直居中重绘时，也必须。
				var iFootHeight = _this.protectedGetFootRowHeight(_iRowHeight);
				_this.protectedDrawFoot(0, _iBodyBottom, _iWidth, iFootHeight);
			}
		}
		
		this.drawScrollableArea = function(iDeltaY, bAuto)
		{
			var bMovable = true;
			
			var iRowCount = _oModel.getRowCount();
			var iStickRows = _oAttr.getStickRows();
			var iPurePieceHeight = (iRowCount - iStickRows) * _iRowHeight;//不包括间距的完整一片的高度
			var iOnePieceHeight = iPurePieceHeight + getGapBetweenPieces();
			
			var iScrollingAreaHeight = Math.max(0, _iBodyBottom - _iScrollingAreaY);
			var iLimitedScrollTop = -(iPurePieceHeight - iScrollingAreaHeight);
			var bInterPiece = (_iSrcollingOffsetY > 0 || _iSrcollingOffsetY < iLimitedScrollTop);
			
			_iSrcollingOffsetY += iDeltaY;
			if(bAuto)
			{
				limitScrollingOffsetY(iPurePieceHeight, iOnePieceHeight);
				_bScrollingLoopableAlways = bInterPiece;//当自动滚动进入跨片的状态，开启“总是允许循环”。
			}
			else
			{
				if(_bScrollingLoopableAlways)
				{
					limitScrollingOffsetY(iPurePieceHeight, iOnePieceHeight);
				}
				else
				{
					if(_iSrcollingOffsetY > 0)
					{
						_iSrcollingOffsetY = 0;
						bMovable = false;
					}
					else if(_iSrcollingOffsetY < iLimitedScrollTop)
					{
						_iSrcollingOffsetY = iLimitedScrollTop;
						bMovable = false;
					}
				}
				
				if(!bInterPiece)//当恢复到不跨片的状态，关闭“总是允许循环”。
				{
					_bScrollingLoopableAlways = false;
				}
			}
			
			var iOffsetY = (_iSrcollingOffsetY >= 0 ? _iSrcollingOffsetY : (_iSrcollingOffsetY % _iRowHeight));
			var iOffsetRows = (_iSrcollingOffsetY >= 0 ? 0 : parseInt(-_iSrcollingOffsetY / _iRowHeight));
			
			if(iOffsetY > 0)
			{
				_oCtx.clearRect(0, _iScrollingAreaY, _iWidth, iOffsetY);
			}
			//第一片
			var iFromRowIdx = iStickRows + iOffsetRows;
			var iToRowIdx = iRowCount - 1;
			var iY = _iScrollingAreaY + iOffsetY;
			drawRows(iFromRowIdx, iToRowIdx, iY);
			//间距
			iY += (iToRowIdx - iFromRowIdx + 1) * _iRowHeight;
			_oCtx.clearRect(0, iY, _iWidth, getGapBetweenPieces());
			//续第二片
			iY += getGapBetweenPieces();
			if(iY < _iBodyBottom)
			{
				drawRows(iStickRows, iRowCount - 1, iY);
			}
			
			//重绘滚动区域上面最后一行，盖掉滚动痕迹
			if(iStickRows > 0)
			{
				var iFixedAreaLastRowIdx = iStickRows - 1;
				drawRows(0, iFixedAreaLastRowIdx, _iBodyTop);//由于要表现鼠标划过，整个冻结区重绘
			}
			else
			{
				_this.protectedDrawHead(0, 0, _iWidth, _this.protectedGetHeadRowHeight(_iRowHeight));
			}
			//重绘表尾，盖掉滚动痕迹
			_this.protectedDrawFoot(0, _iBodyBottom, _iWidth, _this.protectedGetFootRowHeight(_iRowHeight));
			return bMovable;
		}
		
		var limitScrollingOffsetY = function(iPurePieceHeight, iOnePieceHeight)
		{
			//取值范围：[负的完整一片纯高度, 正的两片间距]
			while(_iSrcollingOffsetY > getGapBetweenPieces())
			{
				_iSrcollingOffsetY -= iOnePieceHeight;
			}
			while(_iSrcollingOffsetY < -iPurePieceHeight)
			{
				_iSrcollingOffsetY += iOnePieceHeight;
			}
		}
		
		this.protectedGetHeadRowHeight = function(iRowHeight)
		{
			throw new Error("Implement");
		}
		
		this.protectedGetFootRowHeight = function(iRowHeight)
		{
			throw new Error("Implement");
		}
		
		this.protectedDrawHead = function(iX, iY, iWidth, iHeadHeight)
		{
			throw new Error("Implement");
		}
		
		this.protectedDrawFoot = function(iX, iY, iWidth, iFootHeight)
		{
			throw new Error("Implement");
		}
		
		var getGapBetweenPieces = function()
		{
			return _iRowHeight;
		}
		
		var drawAll = function(iAllWidth, iAllHeight, iRowHeight)
		{
			setSizeContext(iAllWidth, iAllHeight, iRowHeight);
			
			var iRowCount = _oModel.getRowCount();
			var iStickRows = _oAttr.getStickRows();
			var iScrollableRows = iRowCount - iStickRows;
			
			var iHeadY = 0;
			var iHeadHeight = _this.protectedGetHeadRowHeight(_iRowHeight);
			var iFootHeight = _this.protectedGetFootRowHeight(_iRowHeight);
			_iBodyTop = iHeadY + iHeadHeight;
			var iFixedAreaHeight = _iRowHeight * iStickRows;
			_iScrollingAreaY = _iBodyTop + iFixedAreaHeight;
			_iBodyBottom = iHeadY + _iHeight - iFootHeight;
			var iScrollingAreaHeight = Math.max(0, _iBodyBottom - _iScrollingAreaY);
			
			_this.protectedDrawHead(0, 0, _iWidth, iHeadHeight);
			drawRows(0, iRowCount - 1, _iBodyTop);
			_this.protectedDrawFoot(0, _iBodyBottom, _iWidth, iFootHeight);
			
			_iSrcollingOffsetY = 0;
			_bScrollable = _this.protectedIsScrollingRequested(iScrollingAreaHeight, _iRowHeight, iScrollableRows);
			return _bScrollable;
		}
		this.protectedIsScrollingRequested = function(iScrollingAreaHeight, iRowHeight, iScrollableRows)
		{
			throw new Error("Implement");
		}
		
		var drawRows = function(iFromRowIdx, iToRowIdx, iStartY)
		{
			_this.protectedSetupDrawRows();
			var iColumnCount = _oModel.getColumnCount();
			var iTop = iStartY + _this.protectedGetBodyTopOffset();
			for(var i = iFromRowIdx; i <= iToRowIdx; i++)
			{
				var iBottom = iTop + _iRowHeight;
				if(iBottom > iStartY)
				{
					_oCtx.clearRect(0, iTop, _iWidth, _iRowHeight);
					var oRow = _oModel.getRow(i);
					var sBackground = _oModel.getPrioritizedStyle(null, oRow, null, "getBackground");
					if(_iHoverRowIdx == i)
					{
						!sBackground && (sBackground = _oStyleTool.getBackgroundColor());
						sBackground = calculateContrastColor(sBackground);
					}
					sBackground && paintBackgroundColor(sBackground, 0, iTop, _iWidth, _iRowHeight);
					for(var j = 0; j < iColumnCount; j++)
					{
						var oColumn = _oModel.getColumn(j);
						if(oColumn.isVisible())
						{
							var oCell = oRow.getCell(j);
							_this.protectedDrawCell(oRow, oColumn, oCell, j, iTop, _iRowHeight)
						}
					}
					_this.protectedAfterDrawRow(_iWidth, iBottom - 0.5);
				}
				iTop = iBottom;
				if(iTop >= _iBodyBottom)
				{
					break;
				}
			}
		}
		this.protectedGetBodyTopOffset = function()
		{
			return 0;
		}
		this.protectedSetupDrawRows = function()
		{
			throw new Error("Implement");
		}
		this.protectedDrawCell = function(oRow, oColumn, oCell, iColumnIdx, numRowTop, numRowHeight)
		{
			throw new Error("Implement");
		}
		this.protectedAfterDrawRow = function(numAllWidth, numRowBottom)
		{
			//Can override
		}
		
		var paintBackgroundColor = function(sColor, numX, numY, numWidth, numHeight)
		{
			_oCtx.save();
			_oCtx.fillStyle = sColor;
			_oCtx.fillRect(numX, numY, numWidth, numHeight);
			_oCtx.restore();
		}
		
		var paintIcon = function(oStyle, numX, numY, numHeight, iIconWide)
		{
			var numRadius = iIconWide * 0.309;
			numX += iIconWide * 0.5;
			numY += numHeight * 0.5;
			_oCtx.save();
			_oCtx.beginPath();
			_oCtx.fillStyle = oStyle.getBackgroundIconColor();
			var sIconName = oStyle.getBackgroundIconName();
			sIconName = sIconName.toUpperCase();
			if(sIconName == "CIRCLE")
			{
				_oCtx.arc(numX, numY, numRadius, 0, Math.PI * 2);
			}
			else if(sIconName.substr(0, 6) == "ARROW-")
			{
				var sPostfix = sIconName.substr(6);
				var numRotate = ICON_ARROW_ROTATE[sPostfix];
				if(numRotate !== undefined)
				{
					paintIconArrow(numX, numY, numRadius, numRotate);
				}
				else
				{
					paintIconUnknown(numX, numY, numRadius);
				}
			}
			else
			{
				paintIconUnknown(numX, numY, numRadius);
			}
			_oCtx.fill();
			_oCtx.restore();
		}
		
		var paintIconUnknown = function(numX, numY, numRadius)
		{
			_oCtx.fillRect(numX - numRadius * 0.25, numY - numRadius, numRadius * 0.75, 2);
			_oCtx.fillRect(numX + numRadius * 0.5, numY - numRadius, 2, numRadius);
			_oCtx.fillRect(numX, numY - 2, numRadius * 0.5, 2);
			_oCtx.fillRect(numX, numY, 2, numRadius * 0.5);
			_oCtx.fillRect(numX, numY + numRadius * 0.75, 2, 2);
		}
		
		var paintIconArrow = function(numX, numY, numRadius, numRotate)
		{
			_oCtx.translate(numX, numY);
			_oCtx.rotate(Math.PI * numRotate);
			_oCtx.translate(-numX, -numY);
			var numQuarter = numRadius * 0.5;
			var numFoot = numRadius * 0.75;
			_oCtx.moveTo(numX, numY - numRadius);
			_oCtx.lineTo(numX - numRadius, numY);
			_oCtx.lineTo(numX - numQuarter, numY);
			_oCtx.lineTo(numX - numQuarter, numY + numFoot);
			_oCtx.lineTo(numX + numQuarter, numY + numFoot);
			_oCtx.lineTo(numX + numQuarter, numY);
			_oCtx.lineTo(numX + numRadius, numY);
			_oCtx.closePath();
		}
		
		var isAlignCenter = function(sAlign)
		{
			return "center" == sAlign;
		}
		
		var isAlignRight = function(sAlign)
		{
			return "right" == sAlign;
		}
		
		var getStyleTool = function()
		{
			return _oStyleTool;
		}
		
		var calculateContrastColor = function(sBaseColor)
		{
			var arrRgba = ColorUtil.decodeStringToRgbaArray(sBaseColor);
			!arrRgba && (arrRgba = ColorUtil.decodeStringToRgbaArray("#808080"));
			var arrHsl = ColorUtil.rgbToHsl(arrRgba[0], arrRgba[1], arrRgba[2]);
			var iLight = arrHsl[2];
			iLight += (iLight > 40 ? -6 : 6);
			arrHsl[2] = iLight;
			arrHsl.push(arrRgba[3]);
			var sColor = "hsla(#0,#1%,#2%,#3)";
			for(var i = 0; i <= 3; i++)
			{
				sColor = sColor.replace("#" + i, arrHsl[i]);
			}
			return sColor;
		}
		
		this.protectedMethod = {};
		this.protectedMethod.getStyleTool = getStyleTool;
		this.protectedMethod.calculateContrastColor = calculateContrastColor;
		this.protectedMethod.drawAll = drawAll;
		this.protectedMethod.paintBackgroundColor = paintBackgroundColor;
		this.protectedMethod.paintIcon = paintIcon;
		this.protectedMethod.isAlignCenter = isAlignCenter;
		this.protectedMethod.isAlignRight = isAlignRight;
	}
	
	function CustomListChartRender(oCtx, oModel, oAttr)
	{
		AbstractScrollableList.call(this, oCtx, oModel, oAttr);
		var _this = this;
		var _super = this.protectedMethod;
		var _oCtx = oCtx;
		var _oModel = oModel;
		var _oAttr = oAttr;
		var _arrRectAtHead;
		var _arrRectPerRow;
		var _arrRectAtFoot;
		var _sSplitLineColor;
		var _iBodyTopOffset;
		
		this.drawChart = function()
		{
			var oGraphics = new Graphics(_oCtx);
			var iWidth = oGraphics.getWidth();
			var iHeight = oGraphics.getHeight();
			
			var iRowHeight = _oAttr.getRowHeight();
			_arrRectPerRow = _oAttr.getRuntimeRects(iWidth, iRowHeight);//这里预留了行高自调整的可能
			_arrRectAtHead = _oAttr.getRuntimeHeaderRects(iWidth);
			_arrRectAtFoot = _oAttr.getRuntimeFooterRects(iWidth);
			
			_iBodyTopOffset = 0;
			var bScrollingRequested = _super.drawAll(iWidth, iHeight, iRowHeight);
			if(!bScrollingRequested && _iBodyTopOffset > 0)
			{
				_oCtx.clearRect(0, 0, iWidth, iHeight);
				_this.redrawWhenHover(-1);
			}
			return bScrollingRequested;
		}
		
		this.protectedGetHeadRowHeight = function(iRowHeight)
		{
			return _oAttr.getHeaderHeight();
		}
		
		this.protectedGetFootRowHeight = function(iRowHeight)
		{
			return _oAttr.getFooterHeight();
		}
		
		this.protectedDrawHead = function(iX, iY, iWidth, iHeadHeight)
		{
			var oHead = _oModel.getCustomHeader();
			if(oHead)
			{
				var sBackgroundColor = _oAttr.getHeaderBackgroundColor() || getTitleBackgroundColor();
				drawHeadOrFoot(iX, iY, iWidth, iHeadHeight, oHead, _arrRectAtHead, sBackgroundColor);
			}
		}
		
		this.protectedDrawFoot = function(iX, iY, iWidth, iFootHeight)
		{
			var oFoot = _oModel.getCustomFooter();
			if(oFoot)
			{
				var sBackgroundColor = _oAttr.getFooterBackgroundColor() || getTitleBackgroundColor();
				drawHeadOrFoot(iX, iY, iWidth, iFootHeight, oFoot, _arrRectAtFoot, sBackgroundColor);
			}
		}
		
		var drawHeadOrFoot = function(iX, iY, iWidth, iHeight, oRow, arrRtRect, sBackgroundColor)
		{
			_oCtx.clearRect(iX, iY, iWidth, iHeight);
			_oCtx.fillStyle = sBackgroundColor;
			_oCtx.fillRect(iX, iY, iWidth, iHeight);
			_oCtx.fillStyle = getColor();
			Util.setupFont(_oCtx, getFontSize());
			for(var i = 0; i < oRow.getCellCount(); i++)
			{
				var oCell = oRow.getCell(i);
				var oRect = arrRtRect[i];
				oRect && drawCell(oRow, null, oCell, oRect, iY);
			}
		}
		
		this.protectedIsScrollingRequested = function(iScrollingAreaHeight, iRowHeight, iScrollableRows)
		{
			var iScrollableContentLength = iRowHeight * iScrollableRows;
			if(_oAttr.isBodyMiddleAlign())
			{
				_iBodyTopOffset = Math.max(0, (iScrollingAreaHeight - iScrollableContentLength) >> 1);
			}
			else
			{
				_iBodyTopOffset = 0;
			}
			return (0 < iScrollingAreaHeight && iScrollingAreaHeight < iScrollableContentLength);
		}
		
		//@Override
		this.protectedGetBodyTopOffset = function()
		{
			return _iBodyTopOffset;
		}
		
		this.protectedSetupDrawRows = function()
		{
			Util.setupFont(_oCtx, getFontSize());
			_oCtx.fillStyle = getColor();
			
			!_sSplitLineColor && (_sSplitLineColor = _oAttr.getSplitLineColor());
			!_sSplitLineColor && (_sSplitLineColor = _super.calculateContrastColor(_super.getStyleTool().getBackgroundColor()));
		}
		
		//@Override
		this.protectedAfterDrawRow = function(numAllWidth, numRowBottom)
		{
			_oCtx.save();
			_oCtx.strokeStyle = _sSplitLineColor;
			_oCtx.lineWidth = 1;
			_oCtx.beginPath();
			_oCtx.moveTo(0, numRowBottom);
			_oCtx.lineTo(numAllWidth, numRowBottom);
			_oCtx.stroke();
			_oCtx.restore();
		}
		
		this.protectedDrawCell = function(oRow, oColumn, oCell, iColumnIdx, numRowTop, numRowHeight)
		{
			var oRect = _arrRectPerRow[iColumnIdx];
			oRect && drawCell(oRow, oColumn, oCell, oRect, numRowTop);
		}
		
		var drawCell = function(oRow, oColumn, oCell, oRect, numRowTop)
		{
			var arrCellRect = [oRect.getRectX(), numRowTop + oRect.getRectY(), oRect.getRectWidth(), oRect.getRectHeight()];
			drawBackground(oColumn, oCell, arrCellRect);
			var numLeft = arrCellRect[0];
			var numTop = arrCellRect[1];
			var numWidth = arrCellRect[2];
			var numHeight = arrCellRect[3];
			
			var sColor = _oModel.getPrioritizedStyle(oColumn, oRow, oCell, "getColor");
			var sBold = _oModel.getPrioritizedStyle(oColumn, oRow, oCell, "getBold");
			var iFontSize = _oModel.getPrioritizedStyle(oColumn, oRow, oCell, "getFontSize");
			var bChangeColor = (sColor != null);
			var bChangeBold = (sBold != null);
			var bChangeFontSize = (iFontSize != null);
			var bChangeStyle = (bChangeColor || bChangeBold || bChangeFontSize);
			bChangeStyle && _oCtx.save();
			bChangeColor && (_oCtx.fillStyle = sColor);
			if(bChangeBold)
			{
				Util.setupFontWithBold(_oCtx, (bChangeFontSize ? iFontSize : getFontSize()));
			}
			else if(bChangeFontSize)
			{
				Util.setupFont(_oCtx, iFontSize);
			}
			
			var oColorBar = (oColumn ? oColumn.getBar() : null);
			var numValue = oCell.getNumber();
			if(oColorBar && (numValue || numValue === 0))
			{
				drawColorBar(oColorBar, numValue, numLeft, numTop, numWidth, numHeight);
			}
			
			var sText = oCell.getContent();
			!sText && (sText = "");
			var sAlign = _oModel.getPrioritizedStyle(oColumn, oRow, oCell, "getAlign");
			drawText(sAlign, sText, numLeft, numTop, numWidth, numHeight);
			
			bChangeStyle && _oCtx.restore();
		}
		
		var drawBackground = function(oColumn, oCell, arrCellRect)
		{
			var numLeft = arrCellRect[0];
			var numTop = arrCellRect[1];
			var numWidth = arrCellRect[2];
			var numHeight = arrCellRect[3];
			var oStyle = _oModel.getPrioritizedStyle(null, null, oCell, "getBackground", true);
			if(!oStyle || oStyle.isBackgroundImage() || oStyle.isBackgroundIcon())
			{
				var sBackground = _oModel.getPrioritizedStyle(oColumn, null, null, "getBackground");
				sBackground && _super.paintBackgroundColor(sBackground, numLeft, numTop, numWidth, numHeight);
			}
			if(oStyle)
			{
				if(oStyle.isBackgroundImage())
				{
					oStyle.getBackgroundImage(
						function(oImg)
						{
							if(oImg)
							{
								var arrRect = oStyle.getBackgroundImageRect();
								var numImgX = numLeft + (arrRect ? arrRect[0] : 0);
								var numImgY = numTop + (arrRect ? arrRect[1] : 0);
								var numImgWidth = (arrRect ? arrRect[2] : numWidth);
								var numImgHeight = (arrRect ? arrRect[3] : numHeight);
								_oCtx.drawImage(oImg, numImgX, numImgY, numImgWidth, numImgHeight);
							}
						});
				}
				else if(oStyle.isBackgroundIcon())
				{
					var iIconWide = 20;
					var numIconX = null;
					if(oStyle.isBackgroundIconBefore())
					{
						numIconX = numLeft;
						numLeft += iIconWide;
						numWidth -= iIconWide;
					}
					else if(oStyle.isBackgroundIconAfter())
					{
						numIconX = numLeft + numWidth - iIconWide;
						numWidth -= iIconWide;
					}
					(numIconX != null) && _super.paintIcon(oStyle, numIconX, numTop, numHeight, iIconWide);
				}
				else
				{
					_super.paintBackgroundColor(oStyle.getBackground(), numLeft, numTop, numWidth, numHeight);
				}
			}
			arrCellRect[0] = numLeft;
			arrCellRect[2] = numWidth;
		}
		
		var drawColorBar = function(oColorBar, numValue, numLeft, numTop, numWidth, numHeight)
		{
			var numZeroPosRatio = oColorBar.getRtZeroPosRatio();
			if(numZeroPosRatio === null)
			{
				return;
			}
			var numValuePosRatio = oColorBar.getRtValuePosRatio(numValue);
			
			var sColor = (numValue < 0 ? oColorBar.getNegativeColor() : oColorBar.getPositiveColor());
			!sColor && (sColor = "#99CCFF");
			_oCtx.save();
			_oCtx.fillStyle = sColor;
			
			var numX1 = numLeft + numWidth * numZeroPosRatio;
			var numX2 = numLeft + numWidth * numValuePosRatio;
			var numX = Math.min(numX1, numX2);
			var numW = Math.abs(numX2 - numX1);
			_oCtx.fillRect(numX, numTop, numW, numHeight);
			
			var sCrossAxisColor = oColorBar.getCrossAxisColor();
			if(sCrossAxisColor)
			{
				_oCtx.strokeStyle = sCrossAxisColor;
				_oCtx.lineWidth = 1;
				_oCtx.beginPath();
				_oCtx.moveTo(numX1, numTop - 4);
				_oCtx.lineTo(numX1, numTop + numHeight + 4);
				_oCtx.stroke();
			}
			_oCtx.restore();
		}
		
		var drawText = function(sAlign, sText, numLeft, numTop, numWidth, numHeight)
		{
			var numX = numLeft;
			var numY = parseInt(numTop + numHeight * 0.5 + 2);
			var oTextRender = new CuttingTextRender();
			if(_super.isAlignCenter(sAlign))
			{
				oTextRender.drawAlignCenter(_oCtx, numX, numY, sText, numWidth);
			}
			else if(_super.isAlignRight(sAlign))
			{
				oTextRender.drawAlignRight(_oCtx, numX, numY, sText, numWidth);
			}
			else
			{
				oTextRender.drawAlignLeft(_oCtx, numX, numY, sText, numWidth);
			}
		}
		
		var getFontSize = function()
		{
			return parseInt(Util.getCustomStyle(_super.getStyleTool(), GridChartRender.FONTSIZE, 14));//用Grid的
		}
		
		var getColor = function()
		{
			return Util.getCustomStyle(_super.getStyleTool(), GridChartRender.COLOR, "#808080");//用Grid的
		}
		
		var getTitleBackgroundColor = function()
		{
			return Util.getCustomStyle(_super.getStyleTool(), GridChartRender.TITLE_BACKGROUND, "#f4f4f4");//用Grid的
		}
	}
	
	function GridChartRender(oCtx, oModel, oAttr)
	{
		AbstractScrollableList.call(this, oCtx, oModel, oAttr);
		
		var PADDING = 6;
		var DEFAULT_GAP = 20;
		var ICON_WIDE = 20;
		var GAP_DISTRIBUTER = [
			[[3,0], [3,1], [3,1], [1,0]],
			[[2,0], [2,2], [2,2], [1,0]],
			[[0,0], [0,2], [0,3], [0,0]],
			[[0,0], [0,1], [0,1], [0,0]]];//O[前一个对齐方式][后一个对齐方式]，下标0123->左中右无；[分配给前一个的权重，分配给后一个的权重]
		var GAP_LEFT = 0;
		var GAP_CENTER = 1;
		var GAP_RIGHT = 2;
		
		var _super = this.protectedMethod;	
		var _oCtx = oCtx;
		var _oModel = oModel;
		var _oAttr = oAttr;
		var _oTextRender = new CuttingTextRender();
		var _arrPaintingColumn;
		
		this.drawChart = function()
		{
			var oGraphics = new Graphics(_oCtx);
			var iWidth = oGraphics.getWidth();
			var iHeight = oGraphics.getHeight();
			
			var iFontSize = getFontSize();
			Util.setupFontWithBold(_oCtx, iFontSize);
			var iRowHeight = confirmRowHeight(iHeight, iFontSize);
			confirmColumnsWidth(iWidth);
			Util.setupFont(_oCtx, iFontSize);
			
			var bScrollingRequested = _super.drawAll(iWidth, iHeight, iRowHeight);
			return bScrollingRequested;
		}
		this.protectedIsScrollingRequested = function(iScrollingAreaHeight, iRowHeight, iScrollableRows)
		{
			return (iRowHeight * 0.6 < iScrollingAreaHeight && iScrollingAreaHeight < iRowHeight * (iScrollableRows - 0.3));
		}
		
		var confirmRowHeight = function(iAllHeight, iFontSize)
		{
			var numRatio = Math.log(iAllHeight) / Math.LN10;
			numRatio = Math.max(1.6, Math.min(2.4, numRatio));
			var iRowHeight = parseInt(iFontSize * numRatio);
			return iRowHeight;
		}
		
		var confirmColumnsWidth = function(iAllWidth)
		{
			var iColumnCount = _oModel.getColumnCount();
			var iVisibleColumnCount = 0;
			var arrColumnTextWidth = [];
			var arrColumnIconBefore = [];
			var arrColumnIconAfter = [];
			var iFirstVisibleColIdx = -1;
			var iLastVisibleColIdx = -1;
			for(var j = 0; j < iColumnCount; j++)
			{
				var oColumn = _oModel.getColumn(j);
				if(oColumn.isVisible())
				{
					(iFirstVisibleColIdx < 0) && (iFirstVisibleColIdx = j);
					iLastVisibleColIdx = j;
					arrColumnTextWidth[j] = (_oAttr.isShowHeader() ? calculateTextWidth(oColumn.getTitle()) : 0);
					arrColumnIconBefore[j] = false;
					arrColumnIconAfter[j] = false;
					iVisibleColumnCount++;
				}
				else
				{
					arrColumnTextWidth[j] = 0;
				}
			}
			var iRowCount = _oModel.getRowCount();
			for(var i = 0; i < iRowCount; i++)
			{
				var oRow = _oModel.getRow(i);
				for(var j = 0; j < iColumnCount; j++)
				{
					var oColumn = _oModel.getColumn(j);
					if(oColumn.isVisible())
					{
						var oCell = oRow.getCell(j);
						if(!arrColumnIconBefore[j] || !arrColumnIconAfter[j])
						{
							var oStyle = _oModel.getPrioritizedStyle(null, null, oCell, "getBackground", true);
							if(oStyle && oStyle.isBackgroundIcon())
							{
								arrColumnIconBefore[j] = arrColumnIconBefore[j] || oStyle.isBackgroundIconBefore();
								arrColumnIconAfter[j] = arrColumnIconAfter[j] || oStyle.isBackgroundIconAfter();
							}
						}
						var iTextWidth = calculateTextWidth(oCell.getContent());
						arrColumnTextWidth[j] = Math.max(arrColumnTextWidth[j], iTextWidth);
					}
				}
			}
			
			var arrRequiredColWidth = arrColumnTextWidth.slice(0);
			var numRequiredAllWidth = 0;
			for(var j = 0; j < iColumnCount; j++)
			{
				arrRequiredColWidth[j] += (arrColumnIconBefore[j] ? ICON_WIDE : 0) + (arrColumnIconAfter[j] ? ICON_WIDE : 0);
				numRequiredAllWidth += arrRequiredColWidth[j];
			}
			var numWidth = iAllWidth - PADDING * 2;
			var numDividableWidth = numWidth - DEFAULT_GAP * (iVisibleColumnCount - 1);//可能为负，不管
			if(numRequiredAllWidth > numDividableWidth)
			{
				reduceColumnsWidth(arrRequiredColWidth, numRequiredAllWidth - numDividableWidth);
			}
			else
			{
				increaseColumnsWidth(iColumnCount, arrRequiredColWidth, numDividableWidth - numRequiredAllWidth);
			}
			
			_arrPaintingColumn = [];
			var numContentX = PADDING;
			for(var j = 0; j < iColumnCount; j++)
			{
				var oColumn = _oModel.getColumn(j);
				var oPaintingColumn = null;
				if(oColumn.isVisible())
				{
					var numContentWidth = arrRequiredColWidth[j];
					var numLeftPadding = (j == iFirstVisibleColIdx ? PADDING : DEFAULT_GAP / 2);
					var numRightPadding = (j == iLastVisibleColIdx ? PADDING : DEFAULT_GAP / 2) ;
					var numBackX = numContentX - numLeftPadding;
					var numBackWidth = numLeftPadding + numContentWidth + numRightPadding;
					var numIcon1Width = (arrColumnIconBefore[j] ? ICON_WIDE : 0);
					var numIcon2Width = (arrColumnIconAfter[j] ? ICON_WIDE : 0);
					var arrParam = playWithIcon(oColumn, numContentX, numContentWidth, arrColumnTextWidth[j], numIcon1Width, numIcon2Width);
					var numTextX = arrParam[0];
					var numTextWidth = arrParam[1];
					var numIcon1X = arrParam[2];
					var numIcon2X = arrParam[3];
					oPaintingColumn = new PaintingColumn(numBackX, numBackWidth, numContentX, numContentWidth, numTextX, numTextWidth, numIcon1X, numIcon2X);
					numContentX += numContentWidth + DEFAULT_GAP;
				}
				_arrPaintingColumn[j] = oPaintingColumn;
			}
		}
		
		var playWithIcon = function(oColumn, numContentX, numContentWidth, numPreferredTextWidth, numIcon1Width, numIcon2Width)
		{
			var numUsableTextWidth = numContentWidth - numIcon1Width - numIcon2Width;
			var numTextWidth = Math.min(numUsableTextWidth, numPreferredTextWidth);
			var numTextX, numIcon1X, numIcon2X;
			var sAlign = getColumnAlign(oColumn);
			if(_super.isAlignRight(sAlign))
			{
				numIcon2X = numContentX + numContentWidth - numIcon2Width;
				numTextX = numIcon2X - numTextWidth;
				numIcon1X = numTextX - numIcon1Width;
			}
			else if(_super.isAlignCenter(sAlign))
			{
				var numCenter = numContentX + numContentWidth / 2;
				numTextX = numCenter - numTextWidth / 2;
				numIcon1X = numTextX - numIcon1Width;
				numIcon2X = numTextX + numTextWidth;
			}
			else
			{
				numIcon1X = numContentX;
				numTextX = numContentX + numIcon1Width;
				numIcon2X = numTextX + numTextWidth;
			}
			return [numTextX, numTextWidth, numIcon1X, numIcon2X];
		}
		
		var calculateTextWidth = function(sText)
		{
			_oTextRender.trying(_oCtx, sText, 65535);
			return parseInt(_oTextRender.getUsedWidth() + 1);
		}
		
		var increaseColumnsWidth = function(iColumnCount, arrRequiredColWidth, numDeltaToIncrease)
		{
			var arrWeight = [];
			var iWeightTotal = 0;
			var funAppendWeight = function(iDisIdxA, iDisIdxB)
			{
				var arrWeightPair = GAP_DISTRIBUTER[iDisIdxA][iDisIdxB];
				var iWeightBefore = arrWeightPair[0];
				var iWeightAfter = arrWeightPair[1];
				iWeightTotal += iWeightBefore + iWeightAfter;
				if(arrWeight.length > 0)
				{
					arrWeight[arrWeight.length - 1] += iWeightBefore;
				}
				else if(iWeightBefore != 0)
				{
					throw new Error("Impossible");//前一个为“无”时，其权重必须为0。
				}
				arrWeight.push(iWeightAfter);
			};
			var iLastDisIdx = 3;
			for(var j = 0; j < iColumnCount; j++)
			{
				var oColumn = _oModel.getColumn(j);
				if(oColumn.isVisible())
				{
					var sAlign = getColumnAlign(oColumn);
					var iDisIdx = (_super.isAlignRight(sAlign) ? GAP_RIGHT : (_super.isAlignCenter(sAlign) ?  GAP_CENTER : GAP_LEFT));
					var bRowNum = (j == 0 && _oAttr.isShowRowNum());
					funAppendWeight(iLastDisIdx, (bRowNum ? GAP_LEFT : iDisIdx));
					iLastDisIdx = iDisIdx;
				}
			}
			funAppendWeight(iLastDisIdx, 3);
			
			var numDeltaEachWeight = numDeltaToIncrease / iWeightTotal;
			
			var iWeightIdx = 0;
			for(var j = 0; j < iColumnCount; j++)
			{
				var oColumn = _oModel.getColumn(j);
				if(oColumn.isVisible())
				{
					var iWeight = arrWeight[iWeightIdx++];
					var numDelta = numDeltaEachWeight * iWeight;
					arrRequiredColWidth[j] += numDelta;
				}
			}
		}
		
		var reduceColumnsWidth = function(arrRequiredColWidth, numDeltaToReduce)
		{
			var bNextRound = true;
			var iRound = 0;
			while(iRound < arrRequiredColWidth.length && bNextRound)
			{
				iRound++;
				//找出第一长和第二长
				var arrMax1Idx = [];
				var numMax1 = 0;
				var numMax2 = 0;
				for(var i = 0; i < arrRequiredColWidth.length; i++)
				{
					var numValue = arrRequiredColWidth[i];
					if(numValue > numMax1)
					{
						numMax2 = numMax1;
						numMax1 = numValue;
						arrMax1Idx = [i];
					}
					else if(numValue == numMax1)
					{
						arrMax1Idx.push(i);
					}
					else if(numValue > numMax2)
					{
						numMax2 = numValue;
					}
				}
				//将第一长减少到不小于第二长
				var numReducableThisRound  = (numMax1 - numMax2) * arrMax1Idx.length;
				if(numReducableThisRound >= numDeltaToReduce)
				{
					bNextRound = false;
					numReducableThisRound = numDeltaToReduce;
				}
				var numEachToReduceThisRound = numReducableThisRound / arrMax1Idx.length;
				for(var i = 0; i < arrMax1Idx.length; i++)
				{
					var iIdx = arrMax1Idx[i];
					arrRequiredColWidth[iIdx] -= numEachToReduceThisRound;
				}
				numDeltaToReduce -= numReducableThisRound;
			}
		}
		
		this.protectedGetHeadRowHeight = function(iRowHeight)
		{
			return (_oAttr.isShowHeader() ? parseInt(iRowHeight * 1.2) : 0);
		}
		
		this.protectedGetFootRowHeight = function(iRowHeight)
		{
			return 0;
		}
		
		this.protectedDrawHead = function(iX, iY, iWidth, iHeadHeight)
		{
			if(!_oAttr.isShowHeader())
			{
				return;
			}
			_oCtx.clearRect(iX, iY, iWidth, iHeadHeight);
			_oCtx.fillStyle = getTitleBackgroundColor();
			_oCtx.fillRect(iX, iY, iWidth, iHeadHeight);
			_oCtx.fillStyle = getColor();
			for(var j = 0; j < _oModel.getColumnCount(); j++)
			{
				var oColumn = _oModel.getColumn(j);
				if(oColumn.isVisible())
				{
					var oPaintingColumn = _arrPaintingColumn[j];
					var sAlign = getColumnAlign(oColumn);
					defaultCellRender(sAlign, oColumn.getTitle(), oPaintingColumn.getTextX(), iY, oPaintingColumn.getTextWidth(), iHeadHeight);
				}
			}
		}
		
		this.protectedDrawFoot = function(iX, iY, iWidth, iFootHeight)
		{
			//nothing
		}
		
		this.protectedSetupDrawRows = function()
		{
			_oCtx.fillStyle = getColor();
		}
		
		this.protectedDrawCell = function(oRow, oColumn, oCell, iColumnIdx, numTop, numHeight)
		{
			var oPaintingColumn = _arrPaintingColumn[iColumnIdx];
			var oStyle = _oModel.getPrioritizedStyle(null, null, oCell, "getBackground", true);
			if(!oStyle || oStyle.isBackgroundImage() || oStyle.isBackgroundIcon())
			{
				var sBackground = _oModel.getPrioritizedStyle(oColumn, null, null, "getBackground");
				sBackground && _super.paintBackgroundColor(sBackground, oPaintingColumn.getBackX(), numTop, oPaintingColumn.getBackWidth(), numHeight);
			}
			if(oStyle)
			{
				if(oStyle.isBackgroundImage())
				{
					oStyle.getBackgroundImage(
						function(oImg)
						{
							if(oImg)
							{
								var arrRect = oStyle.getBackgroundImageRect();
								var numImgX = oPaintingColumn.getTextX() + (arrRect ? arrRect[0] : 0);
								var numImgY = numTop + (arrRect ? arrRect[1] : 0);
								var numImgWidth = (arrRect ? arrRect[2] : oPaintingColumn.getTextWidth());
								var numImgHeight = (arrRect ? arrRect[3] : numHeight);
								_oCtx.drawImage(oImg, numImgX, numImgY, numImgWidth, numImgHeight);
							}
						});
				}
				else if(oStyle.isBackgroundIcon())
				{
					var numIconX = (oStyle.isBackgroundIconBefore() ? oPaintingColumn.getIcon1X()
									: (oStyle.isBackgroundIconAfter() ? oPaintingColumn.getIcon2X() : null));
					(numIconX != null) && _super.paintIcon(oStyle, numIconX, numTop, numHeight, ICON_WIDE);
				}
				else
				{
					_super.paintBackgroundColor(oStyle.getBackground(), oPaintingColumn.getBackX(), numTop, oPaintingColumn.getBackWidth(), numHeight);
				}
			}
			
			var sColor = _oModel.getPrioritizedStyle(oColumn, oRow, oCell, "getColor");
			var sBold = _oModel.getPrioritizedStyle(oColumn, oRow, oCell, "getBold");
			var bChangeStyle = (sColor || sBold);
			bChangeStyle && _oCtx.save();
			sColor && (_oCtx.fillStyle = sColor);
			sBold && Util.setupFontWithBold(_oCtx, getFontSize());
			
			var sText = oCell.getContent();
			var sAlign = getColumnAlign(oColumn);
			defaultCellRender(sAlign, sText, oPaintingColumn.getTextX(), numTop, oPaintingColumn.getTextWidth(), numHeight);
			bChangeStyle && _oCtx.restore();
		}
		
		var defaultCellRender = function(sAlign, sText, numLeft, numTop, numColumnhWidth, numRowHeight)
		{
			var numX = numLeft;
			var numY = parseInt(numTop + numRowHeight * 0.5 + 2);
			if(_super.isAlignCenter(sAlign))
			{
				_oTextRender.drawAlignCenter(_oCtx, numX, numY, sText, numColumnhWidth);
			}
			else if(_super.isAlignRight(sAlign))
			{
				_oTextRender.drawAlignRight(_oCtx, numX, numY, sText, numColumnhWidth);
			}
			else
			{
				_oTextRender.drawAlignLeft(_oCtx, numX, numY, sText, numColumnhWidth);
			}
		}
		
		var getColumnAlign = function(oColumn)
		{
			return _oModel.getPrioritizedStyle(oColumn, null, null, "getAlign");
		}
		
		var getFontSize = function()
		{
			return parseInt(Util.getCustomStyle(_super.getStyleTool(), GridChartRender.FONTSIZE, 14));
		}
		
		var getColor = function()
		{
			return Util.getCustomStyle(_super.getStyleTool(), GridChartRender.COLOR, "#666");
		}
		
		var getTitleBackgroundColor = function()
		{
			return Util.getCustomStyle(_super.getStyleTool(), GridChartRender.TITLE_BACKGROUND, "#f4f4f4");
		}
		
		function PaintingColumn(numBackX, numBackWidth, numX, numWidth, numTextX, numTextWidth, numIcon1X, numIcon2X)
		{
			/** 列的背景颜色绘制的起始位置（包含了间距） */
			this.getBackX = function(){return numBackX;}
			/** 列的背景颜色绘制的宽度（包含了间距） */
			this.getBackWidth = function(){return numBackWidth;}
			
			/** 列的内容的起始位置（不等同于背景颜色，背景颜色会向外多出半个列间距） */
			this.getX = function(){return numX;}
			/** 列的内容的宽度（不等同于背景颜色，背景颜色会向外多出半个列间距） */
			this.getWidth = function(){return numWidth;}
			
			/** 文字的起始位置，受对齐方式和有没有小图标的影响 */
			this.getTextX = function(){return numTextX;}
			/** 文字的宽度，受对齐方式和有没有小图标的影响 */
			this.getTextWidth = function(){return numTextWidth;}
			
			/** 在文字前的小图标的起始位置 */
			this.getIcon1X = function(){return numIcon1X;}
			/** 在文字后的小图标的起始位置 */
			this.getIcon2X = function(){return numIcon2X;}
		}
	}
	GridChartRender.TITLE_BACKGROUND = "gridTitleBackground";
	GridChartRender.COLOR = "gridColor";
	GridChartRender.FONTSIZE = "gridFontSize";
	
	
	function WaterfallChartRender(oCtx, oModel, oAttr)
	{
		AbstractYNXSType.call(this);
		var _super = this.protectedMethod;
		var _oGraphics = new Graphics(oCtx);
		var _oModel = oModel;
		var _oAttr = oAttr;
		var _oStyleTool = new StyleTool(oAttr);
		var _iHoverCategoryIdx;
		var _numPixelPerCategory;
		var _numNumberAxisMaxY;
		var _numNumberAxisMinY;
		
		//@Implement AbstractYNXSType
		this.protectedSuggestYAxisWidth = function(oGraphics, oNumberRulerHelper)
		{
			return oNumberRulerHelper.suggestVerticalRulerWidth(oGraphics, getNumberAxisFormat(), _oAttr.getYUnitText());
		}
		
		//@Implement AbstractYNXSType
		this.protectedSuggestXAxisHeight = function(oGraphics, iMainWidth)
		{
			var arrCategory = _oModel.getCategories();
			var numPixelPerCategory =  iMainWidth / arrCategory.length;
			var iSuggestBottomHeight = YNXSPainter.suggestCategoryAxisHeight(_oStyleTool, oGraphics, numPixelPerCategory, arrCategory);
			return iSuggestBottomHeight;
		}
		
		this.apiXYToCategoryIndex = function(iApiX, iApiY)
		{
			var arrXY = _oGraphics.retransformMouseXY(iApiX, iApiY);
			var iX = arrXY[0];
			var iY = arrXY[1];
			if(iX > 0 && _numNumberAxisMinY < iY && iY < _numNumberAxisMaxY)
			{
				var iCategoryIdx = parseInt(iX / _numPixelPerCategory);
				if(0 <= iCategoryIdx && iCategoryIdx < _oModel.getCategories().length)
				{
					return iCategoryIdx;
				}
			}
			return -1; 
		}
		
		this.drawChart = function(iHoverCategoryIdx)
		{
			_iHoverCategoryIdx = iHoverCategoryIdx;
			var oScopeAdapter = new RulerScaleAdapter(_oModel.getScopes()[0]);
			var oNumberRulerHelper = new NumberRulerHelper(oScopeAdapter, _oStyleTool);
			_oGraphics.clearAll();
			
			var arrDivided = _super.divideLeftBottomAxis(_oGraphics, oNumberRulerHelper);
			var iLeftWidth = arrDivided[0];
			var iBottomHeight = arrDivided[1];
			var iMainWidth = arrDivided[2];
			var iMainHeight = arrDivided[3];
			
			//确定标尺刻度1/2/5，修订最大最小值。
			oNumberRulerHelper.confirmVerticalRulerMark(iMainHeight);
			
			var iShrinkForTopAlways = YNXSPainter.getShrinkForTopAlways(_oStyleTool, _oAttr);
			var iShrinkForLabel = getShrinkForDataLabel();
			var iApiX = iLeftWidth;
			var iApiY = 0;
			//坐标转换，计算物理值与逻辑值换算率。
			var numPixelPerValue = CoordinateTransformer.verticalNumberAxis(_oGraphics, 
					iApiX, iApiY, iMainHeight, oScopeAdapter, iShrinkForTopAlways, iShrinkForLabel);
			
			var arrYPair = YNXSPainter.confirmNumberAxis(numPixelPerValue, iShrinkForLabel, oScopeAdapter, _oStyleTool, _oAttr);
			_numNumberAxisMinY = arrYPair[0];
			_numNumberAxisMaxY = arrYPair[1];
			
			var iCategoryAxisWidth = iMainWidth;
			var iCategoryAxisHeight = iBottomHeight;
			_numPixelPerCategory =  iCategoryAxisWidth / _oModel.getCategories().length;
			
			//绘制
			oNumberRulerHelper.drawLeftNumberAxisWithAssistantLine(_oGraphics, 
					iLeftWidth, numPixelPerValue, getNumberAxisFormat(), _oAttr.getYUnitText(), iMainWidth);
			YNXSPainter.drawCategoryAxis(_oModel.getCategories(), 
					function(iCategoryIndex, sSide)
					{
						var numCategoryX = _numPixelPerCategory * iCategoryIndex;
						var numCategoryWith = _numPixelPerCategory;
						return numCategoryX + (sSide == "center" ? numCategoryWith / 2 : 0);
					},
					_oStyleTool, _oGraphics, iCategoryAxisWidth, iCategoryAxisHeight, _numPixelPerCategory, _numNumberAxisMinY);
			drawMain(numPixelPerValue);
			_oAttr.isShowDataLabel() && drawDataLabel(numPixelPerValue);
		}
		
		var parseSeries = function(iCategoryIdx)
		{
			var arrNodeValue = _oModel.getSeries()[0].getNodes();
			var arrNodeStart = _oModel.getSeries()[1].getNodes();
			var bStage = true;
			var numStart = 0;
			var oNodeStart = arrNodeStart[iCategoryIdx];
			if(oNodeStart)
			{
				bStage = false;
				numStart = oNodeStart.getValue();
			}
			var numValue = arrNodeValue[iCategoryIdx].getValue();
			return [numStart, numValue, bStage];
		}
		
		var drawMain = function(numPixelPerValue)
		{
			_oGraphics.getContext().strokeStyle = Util.getAxisLineColor(_oStyleTool);
			_oGraphics.getContext().lineWidth = 0.75;
			var sStageColor = getStageColor();
			var sPositiveColor = getPositiveColor();
			var sNegativeColor = getNegativeColor();
			
			var numLastEndX, numLastEndY;
			var numParam = (_numPixelPerCategory < 20 ? 0.8 : (_numPixelPerCategory < 30 ? -0.02 * _numPixelPerCategory + 1.2 : 0.6));
			var numUnitThickness = Math.min(COLUMN_MAX_WIDE, _numPixelPerCategory * numParam);
			var numOuterX = 0;
			var numInnerX = (_numPixelPerCategory - numUnitThickness) / 2;
			
			var arrCategory = _oModel.getCategories();
			for(var iCategoryIdx = 0; iCategoryIdx < arrCategory.length; iCategoryIdx++)
			{
				var oCategory = arrCategory[iCategoryIdx];
				var arrWrap = parseSeries(iCategoryIdx);
				var numStart = arrWrap[0];
				var numValue = arrWrap[1];
				var bStage = arrWrap[2];
				numValue = (isNaN(numValue) ? 0 : numValue);
				
				if(iCategoryIdx == _iHoverCategoryIdx)
				{
					var numOuterX1 = numOuterX;
					var numOuterX2 = numOuterX + _numPixelPerCategory;
					drawRect(numOuterX1, _numNumberAxisMinY, numOuterX2, _numNumberAxisMaxY, HOVER_MASK_COLOR);
				}
				
				var numX1 = numInnerX;
				var numX2 = numX1 + numUnitThickness;
				var numY1 = numStart * numPixelPerValue;
				var numY2 = numY1 + numValue * numPixelPerValue;
				if(iCategoryIdx > 0)
				{
					var numXFrom = numX2;
					var numYFrom = (bStage ? numY2 : numY1);
					drawLinkLine(numXFrom, numYFrom, numLastEndX, numLastEndY);
				}
				var sColor = oCategory.getColor();
				if(!sColor)
				{
					sColor = (bStage ? sStageColor : (numValue < 0 ? sNegativeColor : sPositiveColor));
				}
				drawRect(numX1, numY1, numX2, numY2, sColor);
				
				numLastEndX = numX2;
				numLastEndY = numY2;
				numOuterX += _numPixelPerCategory;
				numInnerX += _numPixelPerCategory;
			}
		}
		
		var drawRect = function(numX1, numY1, numX2, numY2, sColor)
		{
			_oGraphics.getContext().fillStyle = sColor;
			_oGraphics.fillRect(numX1, numY1, numX2, numY2);
		}
		
		var drawLinkLine = function(numXFrom, numYFrom, numXTo, numYTo)
		{
			_oGraphics.beginPath();
			_oGraphics.moveTo(numXFrom, numYFrom);
			_oGraphics.lineTo(numXTo, numYTo);
			_oGraphics.stroke();
		}
		
		var drawDataLabel = function(numPixelPerValue)
		{
			var iFontSize = Util.getDataLabelFontSize(_oStyleTool);
			var oCtx = _oGraphics.getContext();
			oCtx.fillStyle = Util.getDataLabelColor(_oStyleTool);
			Util.setupFont(oCtx, iFontSize);
			oCtx.textBaseline = "middle";
			
			var iCategoryCount = _oModel.getCategories().length;
			var oFormater = new NumberFormater();
			oFormater.setFormatString(_oAttr.getDataLabelFormat() || getNumberAxisFormat());
			
			var oNonoverlap = (_oAttr.isDataLabelOverlappable() ? null : 
					new NonoverlappingConfirmer(
						-10, 
						_numNumberAxisMinY - iFontSize, 
						_numPixelPerCategory * iCategoryCount + 10, 
						_numNumberAxisMaxY - _numNumberAxisMinY + iFontSize));
			for(var t = 0; t < 2; t++)
			{
				for(var iCategoryIdx = 0; iCategoryIdx < iCategoryCount; iCategoryIdx++)
				{
					var arrWrap = parseSeries(iCategoryIdx);
					var numStart = arrWrap[0];
					var numValue = arrWrap[1];
					var bStage = arrWrap[2];
					if((t == 0 && !bStage) || (t == 1 && bStage) || isNaN(numValue))
					{
						continue;
					}
					var sText = oFormater.format(numValue);
					var iTextWidth = oCtx.measureText(sText).width;
					var iNegativeParam = (numValue < 0 ? -1 : 1);
					var numY = (numStart + numValue) * numPixelPerValue;
					numY = numY + iNegativeParam * iFontSize * 0.7;
					var numX = _numPixelPerCategory * (iCategoryIdx + 0.5) - iTextWidth / 2;
					if(iCategoryIdx == 0)
					{
						numX = Math.max(numX, -10);
					}
					else if(iCategoryIdx == iCategoryCount - 1)
					{
						var numLeftNeed = _numPixelPerCategory * iCategoryCount - iTextWidth;//允许从右边距向左伸，
						var numLeftMost = _numPixelPerCategory * (iCategoryIdx - 1);//但是不能超过前一个类别的左侧。
						numX = Math.max(numLeftMost, Math.min(numX, numLeftNeed));
					}
					
					if(!oNonoverlap || oNonoverlap.isRectCanDraw(numX, numY - iFontSize, iTextWidth, iFontSize))//绘制坐标，Y轴向上与文字绘制从上到下是反的。
					{
						_oGraphics.fillText(sText, numX, numY);
					}
				}
			}
		}
		
		var getNumberAxisFormat = function()
		{
			var sFormatString = _oAttr.getYFormat();
			!sFormatString && (sFormatString = _oModel.getSeries()[0].getFormatString());
			return sFormatString;
		}
		
		var getShrinkForDataLabel = function()
		{
			return (_oAttr.isShowDataLabel() ? parseInt(Util.getDataLabelFontSize(_oStyleTool) * 1.25) : 0);
		}
		
		var getPositiveColor = function(){return _oStyleTool.getCustomStyle(WaterfallChartRender.POSITVE_COLOR, "#73D13D");}
		var getNegativeColor = function(){return _oStyleTool.getCustomStyle(WaterfallChartRender.NEGATIVE_COLOR, "#F57582");}
		var getStageColor = function(){return _oStyleTool.getCustomStyle(WaterfallChartRender.STAGE_COLOR, "#40A9FF");}
	}
	WaterfallChartRender.POSITVE_COLOR = "waterfallPositiveColor";
	WaterfallChartRender.NEGATIVE_COLOR = "waterfallNegativeColor";
	WaterfallChartRender.STAGE_COLOR = "waterfallStageColor";
	
	
	function FunnelChartRender(oCtx, oModel, oAttr)
	{
		var BOTTOM_RATIO = 0.1;//“整体梯形”的底
		
		var _oGraphics = new Graphics(oCtx);
		var _oModel = oModel;
		var _oAttr = oAttr;
		var _oStyleTool = new StyleTool(oAttr);
		var _oSelectionModel;
		
		var _oDrawingModel;
		var _iHoverCategoryIdx;
		
		this.setSelectionModel = function(oSelectionModel)
		{
			_oSelectionModel = oSelectionModel;
		}
		
		this.apiXYToCategoryIndex = function(iApiX, iApiY)
		{
			var iCategoryIdx = _oDrawingModel.whichCategoryNeared(iApiX, iApiY);
			return iCategoryIdx; 
		}
		
		this.getDrawingModel = function()
		{
			return _oDrawingModel;
		}
		
		this.drawChart = function(iHoverCategoryIdx)
		{
			_iHoverCategoryIdx = iHoverCategoryIdx;
			_oGraphics.clearAll();
			_oDrawingModel = new DrawingModel();
			var oDrawingContext = new DrawingContext();
			calculateEachStepPercentage();
			confirmBounds(oDrawingContext);
			if(_oAttr.isLadderPerfect())
			{
				drawPerfectLadder(oDrawingContext);
			}
			else
			{
				drawActualLadder(oDrawingContext);
			}
			drawDataLabel(oDrawingContext);
		}
		
		var calculateEachStepPercentage = function()
		{
			var oFormater = new NumberFormater();
			oFormater.setFormatString(getPercentageFormat());
			var funDenominatorGetter = createDenominatorGetter();
			var arrPercent = [];
			for(var i = 0; i < _oModel.getCategories().length; i++)
			{
				var numValue = getNodeAbsValue(i);
				var numDenominator = funDenominatorGetter(i);
				var sPercent = (numDenominator == 0 ? "---" : oFormater.format(numValue / numDenominator));
				arrPercent.push(sPercent);
			}
			_oDrawingModel.bindPercentage(arrPercent);
		}
		
		var createDenominatorGetter = function()
		{
			var numDenominator = null;
			var funGetter = function(iCategoryIdx)
			{
				if(_oAttr.isRatioByTotal())
				{
					if(numDenominator === null)
					{
						numDenominator = 0;
						for(var i = 0; i < _oModel.getCategories().length; i++)
						{
							var numValue = getNodeAbsValue(i);
							numDenominator += numValue;
						}
					}
					return numDenominator;
				}
				else if(_oAttr.isRatioByStart())
				{
					return getNodeAbsValue(0);
				}
				else//isRatioByStep()
				{
					return (iCategoryIdx == 0 ? getNodeAbsValue(iCategoryIdx) : getNodeAbsValue(iCategoryIdx - 1));
				}
			};
			return funGetter;
		}
		
		var confirmBounds = function(oDrawingContext)
		{
			var iVPadding = 4;
			var iHPadding = 6;
			var iUsableHeight = _oGraphics.getHeight() - iVPadding * 2;
			var iUsableWidth = _oGraphics.getWidth() - iHPadding * 2;
			var iStartY = iVPadding;
			var iCenterX = iHPadding + (iUsableWidth >> 1);
			var iMaxWidth;
			var iHeight;
			if(iUsableWidth >= iUsableHeight)
			{
				iHeight = iUsableHeight;
				iMaxWidth = iHeight;
			}
			else
			{
				iMaxWidth = iUsableWidth;
				iHeight = iMaxWidth;
				iStartY = (iUsableHeight >> 1) - (iHeight >> 1);
			}
			var iMinWidth = parseInt(iMaxWidth * BOTTOM_RATIO);
			oDrawingContext.setCenterX(iCenterX);
			oDrawingContext.setWidths(iMaxWidth, iMinWidth);
			var numStepHeight = iHeight / _oModel.getCategories().length;
			_oDrawingModel.bindStepY(iStartY, numStepHeight);
		}
		
		var confirmEachStepXs = function(oDrawingContext, funAllocator)
		{
			var arrStepLR = [];
			var numXL = oDrawingContext.getCenterX() - oDrawingContext.getMinWidth() * 0.5;
			var numXR = oDrawingContext.getCenterX() + oDrawingContext.getMinWidth() * 0.5;
			var numDelta = (oDrawingContext.getMaxWidth() - oDrawingContext.getMinWidth()) * 0.5;
			var iSteps = _oModel.getCategories().length;
			for(var i = 0; i <= iSteps; i++)
			{
				var numOffset = numDelta * funAllocator(i, iSteps);
				arrStepLR.push([numXL - numOffset, numXR + numOffset]);
			}
			_oDrawingModel.bindStepX(arrStepLR);
		}
		
		var drawPerfectLadder = function(oDrawingContext)
		{
			confirmEachStepXs(
				oDrawingContext,
				function(iIdx, iSteps)
				{
					return (iSteps - iIdx) / iSteps;
				});
			paintLadder();
		}
		
		var drawActualLadder = function(oDrawingContext)
		{
			var numMaxValue = -Infinity;
			var numMinValue = Infinity;
			for(var i = 0; i < _oModel.getCategories().length; i++)
			{
				var numValue = getNodeAbsValue(i);
				numMaxValue = Math.max(numMaxValue, numValue);
				numMinValue = Math.min(numMinValue, numValue);
			}
			var numDenominator = (numMaxValue - numMinValue);
			confirmEachStepXs(
				oDrawingContext,
				function(iIdx, iSteps)
				{
					if(iIdx == iSteps)
					{
						return -BOTTOM_RATIO * 0.5;//使底部介于尖底和矩形平底之间。
					}
					else
					{
						var numValue = getNodeAbsValue(iIdx);
						return (numDenominator == 0 ? 1 : (numValue - numMinValue) / numDenominator);
					}
				});
			paintLadder();
		}
		
		var paintLadder = function()
		{
			var arrCategory = _oModel.getCategories();
			for(var i = 0; i < arrCategory.length; i++)
			{
				var sColor = arrCategory[i].getColor();
				var numXaL = _oDrawingModel.getStepTopLeftX(i);
				var numXaR = _oDrawingModel.getStepTopRightX(i);
				var numXbL = _oDrawingModel.getStepBottomLeftX(i);
				var numXbR = _oDrawingModel.getStepBottomRightX(i);
				var numYa = _oDrawingModel.getStepTopY(i);
				var numYb = _oDrawingModel.getStepBottomY(i);
				if(i == _iHoverCategoryIdx)
				{
					numXaL -= 5;
					numXbL -= 5;
					numXaR += 5;
					numXbR += 5;
				}
				paintStep(numXaL, numXaR, numXbL, numXbR, numYa, numYb, sColor);
				if(isHumble(i))
				{
					var sMaskColor = _oStyleTool.getUnselectedMaskColor();
					paintStep(numXaL, numXaR, numXbL, numXbR, numYa, numYb, sMaskColor, true);
				}
			}
		}
		
		var paintStep = function(numXaL, numXaR, numXbL, numXbR, numYa, numYb, sColor, bStroke)
		{
			_oGraphics.getContext().fillStyle = sColor;
			_oGraphics.beginPath();
			_oGraphics.moveTo(numXaL, numYa);
			_oGraphics.lineTo(numXaR, numYa);
			_oGraphics.lineTo(numXbR, numYb);
			_oGraphics.lineTo(numXbL, numYb);
			_oGraphics.closePath();
			_oGraphics.fill();
			if(bStroke)
			{
				_oGraphics.getContext().strokeStyle = sColor;
				_oGraphics.stroke();
			}
		}
		
		var isHumble = function(iCategoryIdx)
		{
			if(_oSelectionModel && _oSelectionModel.isAnySelected())
			{
				var oCategory = _oModel.getCategories()[iCategoryIdx];
				return !_oSelectionModel.isSelected(oCategory, null);
			}
			return false;
		}
		
		var drawDataLabel = function(oDrawingContext)
		{
			if(!_oAttr.isLabelHide(_oAttr.getLabelNamePosition()) || 
				!_oAttr.isLabelHide(_oAttr.getLabelValuePosition()) || 
				!_oAttr.isLabelHide(_oAttr.getLabelPercentPosition()))
			{
				var sLabelColor = Util.getDataLabelColor(_oStyleTool);
				var oCtx = _oGraphics.getContext();
				oCtx.fillStyle = sLabelColor;
				oCtx.strokeStyle = Util.getRulerMarkLongLineColor(_oStyleTool);
				oCtx.textBaseline = "middle";
				Util.setupFont(oCtx, oDrawingContext.getFontSize());
				
				var sHumbleLabelColor;
				var funDynamicStyleChanger = function(iCategoryIdx)
				{
					if(isHumble(iCategoryIdx))
					{
						!sHumbleLabelColor && (sHumbleLabelColor = Util.createColorWithAlpha(sLabelColor, 0.25));
						oCtx.fillStyle = sHumbleLabelColor;
						return true;
					}
					else if(sHumbleLabelColor)
					{
						oCtx.fillStyle = sLabelColor;
					}
					return false;
				};
				oDrawingContext.bindLabelHumbleChecker(funDynamicStyleChanger);
				
				var bNameLeft = _oAttr.isLabelLeft(_oAttr.getLabelNamePosition());
				var bValueLeft = _oAttr.isLabelLeft(_oAttr.getLabelValuePosition());
				var bPercentLeft = _oAttr.isLabelLeft(_oAttr.getLabelPercentPosition());
				var bStepPercentLeft = _oAttr.isRatioByStep() && (!bNameLeft && !bValueLeft && bPercentLeft);
				
				var bNameRight = _oAttr.isLabelRight(_oAttr.getLabelNamePosition());
				var bValueRight = _oAttr.isLabelRight(_oAttr.getLabelValuePosition());
				var bPercentRight = _oAttr.isLabelRight(_oAttr.getLabelPercentPosition());
				var bStepPercentRight = _oAttr.isRatioByStep() && (!bNameRight && !bValueRight && bPercentRight);
				
				if(bStepPercentLeft || bStepPercentRight)
				{
					for(var i = 1; i < _oModel.getCategories().length; i++)
					{
						if(bStepPercentLeft)
						{
							var arrLeft = getLabel(oCtx, i, bNameLeft, bValueLeft, bPercentLeft);
							arrLeft && drawStepPercentLabel(oDrawingContext, i, arrLeft[0], arrLeft[1], 
															0, 1, 0, _oDrawingModel.getStepMiddleLeftX);
						}
						if(bStepPercentRight)
						{
							var arrRight = getLabel(oCtx, i, bNameRight, bValueRight, bPercentRight);
							arrRight && drawStepPercentLabel(oDrawingContext, i, arrRight[0], arrRight[1], 
															1, -1, 1, _oDrawingModel.getStepMiddleRightX);
						}
					}
				}
				
				var bNameCenter = _oAttr.isLabelCenter(_oAttr.getLabelNamePosition());
				var bValueCenter = _oAttr.isLabelCenter(_oAttr.getLabelValuePosition());
				var bPercentCenter = _oAttr.isLabelCenter(_oAttr.getLabelPercentPosition());
				for(var i = 0; i < _oModel.getCategories().length; i++)
				{
					var arrCenter = getLabel(oCtx, i, bNameCenter, bValueCenter, bPercentCenter);
					arrCenter && drawDataLabelCenter(oDrawingContext, i, arrCenter[0], arrCenter[1]);
					if(!bStepPercentLeft)
					{
						var arrLeft = getLabel(oCtx, i, bNameLeft, bValueLeft, bPercentLeft);
						arrLeft && drawDataLabelLeft(oDrawingContext, i, arrLeft[0], arrLeft[1]);
					}
					if(!bStepPercentRight)
					{
						var arrRight = getLabel(oCtx, i, bNameRight, bValueRight, bPercentRight);
						arrRight && drawDataLabelRight(oDrawingContext, i, arrRight[0], arrRight[1]);
					}
				}
			}
		}
		
		//在两侧绘制逐级比率的抽象。iSign：左边向右算取1，右边向左算取-1。iTextXSign：文字起始左边不依赖宽度取0，右边减宽度取1。
		var drawStepPercentLabel = function(oDrawingContext, iCategoryIdx, sLabel, numTextWidth, 
												iSideIdx, iSign, iTextXSign, funGetStepMiddleX)
		{
			var iFontSize = oDrawingContext.getFontSize();
			var numPadding = Math.min(iFontSize, Math.max(4, (_oGraphics.getWidth() - oDrawingContext.getMaxWidth()) * 0.1));
			var numLeft = 1;
			var numRight = _oGraphics.getWidth() - 1;
			var numOuterX = [numLeft, numRight][iSideIdx];
			var numTextOuterX = numOuterX + numPadding * iSign;
			var numY1 = _oDrawingModel.getStepMiddleY(iCategoryIdx - 1, 0.3);
			var numY2 = _oDrawingModel.getStepMiddleY(iCategoryIdx, 0.1);
			var numX = numTextOuterX - numTextWidth * iTextXSign;
			var numY = numY2 - iFontSize * 0.5;
			if(checkTextCanDraw(oDrawingContext, numX, numY, numTextWidth))
			{
				var numX1In = funGetStepMiddleX(iCategoryIdx - 1, 0.3) - 6 * iSign;
				var numX2In = funGetStepMiddleX(iCategoryIdx, 0.1) - 4 * iSign;
				((numX1In - numOuterX) * iSign < 3) && (numX1In = numOuterX + 3 * iSign);
				((numX2In - numOuterX) * iSign < 6) && (numX2In = numOuterX + 6 * iSign);
				oCtx.save();
				oCtx.fillStyle = Util.getRulerMarkLongLineColor(_oStyleTool);
				oCtx.beginPath();
				oCtx.moveTo(numX1In,   numY1);
				oCtx.lineTo(numOuterX, numY1);
				oCtx.lineTo(numOuterX, numY2);
				oCtx.lineTo(numX2In,   numY2);
				oCtx.stroke();
				oCtx.beginPath();
				oCtx.moveTo(numX2In, numY2);
				oCtx.lineTo(numX2In - 5 * iSign, numY2 - 3);
				oCtx.lineTo(numX2In - 5 * iSign, numY2 + 3);
				oCtx.closePath();
				oCtx.fill();
				oCtx.restore();
				if(oDrawingContext.isLabelHumble(iCategoryIdx))
				{
					oCtx.fillText(sLabel, numX, numY);
				}
				else
				{
					Util.drawTextWithShadow(_oStyleTool, oCtx, sLabel, numX, numY);
				}
			}
		}
		
		var drawDataLabelCenter = function(oDrawingContext, iCategoryIdx, sLabel, numTextWidth)
		{
			var numX = oDrawingContext.getCenterX() - numTextWidth * 0.5;
			var numY = _oDrawingModel.getStepMiddleY(iCategoryIdx);
			var numStepMiddleLeft = _oDrawingModel.getStepMiddleLeftX(iCategoryIdx);
			var numStepMiddleRight = _oDrawingModel.getStepMiddleRightX(iCategoryIdx);
			if(checkTextCanDraw(oDrawingContext, numX, numY, numTextWidth))
			{
				if(oDrawingContext.isLabelHumble(iCategoryIdx))
				{
					oCtx.fillText(sLabel, numX, numY);
				}
				else
				{
					if(_oDrawingModel.getStepHeight() > oDrawingContext.getFontSize() 
						&& numStepMiddleRight - numStepMiddleLeft - oDrawingContext.getFontSize() * 2 > numTextWidth)
					{
						var sBackground = _oModel.getCategories()[iCategoryIdx].getColor();
						Util.drawTextFitBackground(sBackground, _oGraphics.getContext(), sLabel, numX, numY);
					}
					else
					{
						Util.drawTextWithShadow(_oStyleTool, _oGraphics.getContext(), sLabel, numX, numY);
					}
				}
			}
			oDrawingContext.setLabelLimited(iCategoryIdx, numX, numX + numTextWidth);
		}
		
		var drawDataLabelLeft = function(oDrawingContext, iCategoryIdx, sLabel, numTextWidth)
		{
			var numTextOuterX = 1;
			var numInnerLimited = oDrawingContext.getLeftLabelLimitedX(iCategoryIdx);
			var numTextX = numTextOuterX;
			paintDataLabelLeftRight(oDrawingContext, iCategoryIdx, sLabel, numTextWidth, numTextX,
				function(sLabel, numTextX, numTextWidth)
				{
					if(numInnerLimited <= numTextOuterX)
					{
						return null;
					}
					if(numInnerLimited < numTextX + numTextWidth)
					{
						if(_oAttr.isLabelLeft(_oAttr.getLabelNamePosition()))
						{
							var numShortenWidth = numInnerLimited - numTextX;
							sLabel = Util.shortenText(sLabel, numTextWidth, numShortenWidth, oCtx);
							numTextWidth = numShortenWidth;
						}
						numTextX = numInnerLimited - numTextWidth;
					}
					return [sLabel, numTextX, numTextWidth];
				},
				function(numTextX, numTextWidth)
				{
					var numLineOuterX = numTextX + numTextWidth + 8;
					var numLineInnerX = Math.min(numInnerLimited, _oDrawingModel.getStepMiddleLeftX(iCategoryIdx) - 8);
					return (numLineOuterX + 10 < numLineInnerX ? [numLineOuterX, numLineInnerX] : null);
				});
		}
		
		var drawDataLabelRight = function(oDrawingContext, iCategoryIdx, sLabel, numTextWidth)
		{
			var numTextOuterX = _oGraphics.getWidth() - 1;
			var numInnerLimited = oDrawingContext.getRightLabelLimitedX(iCategoryIdx);
			var numTextX = numTextOuterX - numTextWidth;
			paintDataLabelLeftRight(oDrawingContext, iCategoryIdx, sLabel, numTextWidth, numTextX,
				function(sLabel, numTextX, numTextWidth)
				{
					if(numInnerLimited >= numTextOuterX)
					{
						return null;
					}
					if(numInnerLimited > numTextX)
					{
						numTextX = numInnerLimited;
						if(_oAttr.isLabelRight(_oAttr.getLabelNamePosition()))
						{
							var numShortenWidth = numTextOuterX - numTextX;
							sLabel = Util.shortenText(sLabel, numTextWidth, numShortenWidth, oCtx);
							numTextWidth = numShortenWidth;
						}
					}
					return [sLabel, numTextX, numTextWidth];
				},
				function(numTextX, numTextWidth)
				{
					var numLineOuterX = numTextX - 8;
					var numLineInnerX = Math.max(numInnerLimited, _oDrawingModel.getStepMiddleRightX(iCategoryIdx) + 8);
					return (numLineInnerX + 10 < numLineOuterX ? [numLineInnerX, numLineOuterX] : null);
				});
		}
		
		var paintDataLabelLeftRight = function(oDrawingContext, iCategoryIdx, sLabel, numTextWidth, numTextX, funCheck, funGetLinePoints)
		{
			var arrChecked = funCheck(sLabel, numTextX, numTextWidth);
			if(arrChecked)
			{
				sLabel = arrChecked[0];
				numTextX = arrChecked[1];
				numTextWidth = arrChecked[2];
				var numTextY = _oDrawingModel.getStepMiddleY(iCategoryIdx);
				if(checkTextCanDraw(oDrawingContext, numTextX, numTextY, numTextWidth))
				{
					var oCtx = _oGraphics.getContext();
					if(oDrawingContext.isLabelHumble(iCategoryIdx))
					{
						oCtx.fillText(sLabel, numTextX, numTextY);
					}
					else
					{
						Util.drawTextWithShadow(_oStyleTool, oCtx, sLabel, numTextX, numTextY);
					}
					var arrLinePoint = funGetLinePoints(numTextX, numTextWidth);
					if(arrLinePoint)
					{
						oCtx.beginPath();
						oCtx.moveTo(arrLinePoint[0], numTextY);
						oCtx.lineTo(arrLinePoint[1], numTextY);
						oCtx.stroke();
					}
				}
			}
		}
		
		var getLabel = function(oCtx, iCategoryIdx, bHasName, bHasValue, bHasPercent)
		{
			if(bHasName || bHasValue || bHasPercent)
			{
				var oCategory = _oModel.getCategories()[iCategoryIdx];
				var oNode = _oModel.getSeries()[0].getNodes()[iCategoryIdx];
				var sLabel = "";
				bHasName && (sLabel = oCategory.getLabel());
				bHasValue && (sLabel += (sLabel ? "  " : "") + (oNode ? oNode.getText() : ""));
				bHasPercent && (sLabel += (sLabel ? "  " : "") + _oDrawingModel.getPercentage(iCategoryIdx));
				if(sLabel)
				{
					var numTextWidth = oCtx.measureText(sLabel).width;
					return [sLabel, numTextWidth];
				}
			}
			return null;
		}
		
		var getNodeAbsValue = function(iCategoryIdx)
		{
			var oNode = _oModel.getSeries()[0].getNodes()[iCategoryIdx];
			var numValue = (oNode && !isNaN(oNode.getValue()) ? Math.abs(oNode.getValue()) : 0);
			return numValue;
		}
		
		var getPercentageFormat = function()
		{
			var sFormatString = _oAttr.getPercentageFormat();
			!sFormatString && (sFormatString = "{-2}#,##0.00%");
			return sFormatString;
		}
		
		var checkTextCanDraw = function(oDrawingContext, numX, numY, numWidth)
		{
			return (_oAttr.isDataLabelOverlappable() ? true : oDrawingContext.checkTextCanDraw(numX, numY, numWidth));
		}
		
		function DrawingContext()
		{
			var _iCenterX;
			var _iMaxWidth;
			var _iMinWidth;
			var _iFontSize;
			var _oNonoverlap;
			var _arrLeftLabelLimited;
			var _arrRightLabelLimited;
			var _funLabelHumbleChecker;
			
			this.setCenterX = function(iCenterX)
			{
				_iCenterX = iCenterX;
			}
			this.getCenterX = function()
			{
				return _iCenterX;
			}
			
			this.setWidths = function(iMaxWidth, iMinWidth)
			{
				_iMaxWidth = iMaxWidth;
				_iMinWidth = iMinWidth;
			}
			this.getMaxWidth = function()
			{
				return _iMaxWidth;
			}
			this.getMinWidth = function()
			{
				return _iMinWidth;
			}
			
			this.setLabelLimited = function(iCategoryIdx, numLeft, numRight)
			{
				(!_arrLeftLabelLimited) && (_arrLeftLabelLimited = []);
				(!_arrRightLabelLimited) && (_arrRightLabelLimited = []);
				_arrLeftLabelLimited[iCategoryIdx] = numLeft;
				_arrRightLabelLimited[iCategoryIdx] = numRight;
			}
			this.getLeftLabelLimitedX = function(iCategoryIdx)
			{
				return (_arrLeftLabelLimited ? _arrLeftLabelLimited[iCategoryIdx] : _iCenterX) - getFontSize();
			}
			this.getRightLabelLimitedX = function(iCategoryIdx)
			{
				return (_arrRightLabelLimited ? _arrRightLabelLimited[iCategoryIdx] : _iCenterX) + getFontSize();
			}
			
			var getFontSize = function()
			{
				(!_iFontSize) && (_iFontSize = Util.getDataLabelFontSize(_oStyleTool));
				return _iFontSize;
			}
			this.getFontSize = function()
			{
				return getFontSize();
			}
			
			this.checkTextCanDraw = function(numX, numY, numWidth)
			{
				if(!_oNonoverlap)
				{
					//Y offset half font as text.baseLine="middle" 
					_oNonoverlap = new NonoverlappingConfirmer(
						0, getFontSize() * 0.5, _oGraphics.getWidth(), _oGraphics.getHeight()); 
				}
				return _oNonoverlap.isRectCanDraw(numX, numY, numWidth, getFontSize());
			}
			
			this.bindLabelHumbleChecker = function(funDynamicStyleChanger)
			{
				_funLabelHumbleChecker = funDynamicStyleChanger;
			}
			this.isLabelHumble = function(iCategoryIdx)
			{
				return _funLabelHumbleChecker(iCategoryIdx);
			}
		}
		
		function DrawingModel()
		{
			var _this = this;
			var _iStartY;
			var _numStepHeight;
			var _arrStepLR;//每条横线左右坐标，n层就有n+1个。
			var _arrPercent;
			
			this.bindStepY = function(iStartY, numStepHeight)
			{
				_iStartY = iStartY;
				_numStepHeight = numStepHeight;
			}
			
			this.bindStepX = function(arrStepLR)
			{
				_arrStepLR = arrStepLR;
			}
			
			this.bindPercentage = function(arrPercent)
			{
				_arrPercent = arrPercent;
			}
			
			this.getStepHeight = function()
			{
				return _numStepHeight;
			}
			
			this.getStepTopY = function(iCategoryIdx)
			{
				return _iStartY + _numStepHeight * iCategoryIdx;
			}
			this.getStepMiddleY = function(iCategoryIdx, numRatio)
			{
				(numRatio === undefined) && (numRatio = 0.5);
				return _this.getStepTopY(iCategoryIdx) + _numStepHeight * numRatio + 1;
			}
			this.getStepBottomY = function(iCategoryIdx)
			{
				return _this.getStepTopY(iCategoryIdx) + _numStepHeight;
			}
			
			this.getStepTopLeftX = function(iCategoryIdx)
			{
				return _arrStepLR[iCategoryIdx][0];
			}
			this.getStepTopRightX = function(iCategoryIdx)
			{
				return _arrStepLR[iCategoryIdx][1];
			}
			
			this.getStepBottomLeftX = function(iCategoryIdx)
			{
				return _arrStepLR[iCategoryIdx + 1][0];
			}
			this.getStepBottomRightX = function(iCategoryIdx)
			{
				return _arrStepLR[iCategoryIdx + 1][1];
			}
			
			this.getStepMiddleLeftX = function(iCategoryIdx, numRatio)
			{
				(numRatio === undefined) && (numRatio = 0.5);
				var numTop = _this.getStepTopLeftX(iCategoryIdx);
				var numBottom = _this.getStepBottomLeftX(iCategoryIdx);
				return numTop + (numBottom - numTop) * numRatio;
			}
			this.getStepMiddleRightX = function(iCategoryIdx, numRatio)
			{
				(numRatio === undefined) && (numRatio = 0.5);
				var numTop = _this.getStepTopRightX(iCategoryIdx);
				var numBottom = _this.getStepBottomRightX(iCategoryIdx);
				return numTop + (numBottom - numTop) * numRatio;
			}
			
			this.getPercentage = function(iCategoryIdx)
			{
				return _arrPercent[iCategoryIdx];
			}
			
			this.whichCategoryNeared = function(iApiX, iApiY)
			{
				var iCategoryIdx = -1;
				var iIdx;
				var iRelatedY = (iApiY - _iStartY);
				if(iRelatedY >= 0)
				{
					iIdx = parseInt(iRelatedY / _numStepHeight);
				}
				if(iIdx >= 0 && iIdx < _oModel.getCategories().length)
				{
					var oTopLR = _arrStepLR[iIdx];
					var oBottomLR = _arrStepLR[iIdx + 1];
					var numXL = Math.min(oTopLR[0], oBottomLR[0]);
					var numXR = Math.max(oTopLR[1], oBottomLR[1]);
					if(numXL < iApiX && iApiX < numXR)
					{
						iCategoryIdx = iIdx;
					}
				}
				return iCategoryIdx;
			}
		}
	}
	
//////////////////////////////////////////////////////////////	

	function PieCircleDataLabelRender()
	{
		var _oNonoverlap;
		var _iOuterRadius;//(_iOuterRadius-iRadius)即为蟹脚指向圆心的部分的长度
		var _iTurningLegLength;//蟹脚拐弯横向部分的长度
		var _iFontSize;
		
		this.drawDataLabel = function(oStyleTool, oGraphics, iRadius, iExtendedRadius, arrRadius, arrAngleEnd, funTextCollector, bOverlappable)
		{
			prepare(oStyleTool, oGraphics, iRadius, iExtendedRadius, bOverlappable);
			for(var i = 0; i < arrAngleEnd.length; i++)
			{
				var numDrawingRadius = arrRadius[i];
				var numAngleStart = (i == 0 ? 0 : arrAngleEnd[i - 1]);
				var numAngleEnd = arrAngleEnd[i];
				var numAngle = numAngleEnd - numAngleStart;
				var numAngleMid = numAngleStart + numAngle / 2;
				
				var arrTextLine = [];
				var arrShortenAtLeast = [];
				funTextCollector(i, arrTextLine, arrShortenAtLeast);
				
				var iRetry = 0;
				while(iRetry < 2)
				{
					var arrLogicXY = PolarCoordinate.toLogicXy(numAngleMid, _iOuterRadius);
					var arrApiXY = oGraphics.transformXY(arrLogicXY[0], arrLogicXY[1]);
					var iApiX = arrApiXY[0];
					var iApiY = arrApiXY[1];
					var bHasBeenDrawn = drawLegAndText(oStyleTool, oGraphics, numDrawingRadius, numAngleMid, iApiX, iApiY, arrTextLine, arrShortenAtLeast);
					if(bHasBeenDrawn || i > 10)
					{
						iRetry = 65535;
					}
					else//对前若干项，画不下的时候挪到空更大的角落里
					{
						var numDelta = Math.min(numAngle * 0.1, Math.PI * 0.56);//*0.56，最多不超过约10度
						if(i == 0 || numAngleMid < Math.PI * 0.5 || (Math.PI < numAngleMid && numAngleMid < Math.PI * 1.5))
						{
							numAngleMid = numAngleStart + numDelta;
						}
						else
						{
							numAngleMid = numAngleEnd - numDelta;
						}
						iRetry++;
					}
				}
			}
		}
		
		var prepare = function(oStyleTool, oGraphics, iRadius, iExtendedRadius, bOverlappable)
		{
			_iFontSize = Util.getDataLabelFontSize(oStyleTool);
			var sLabelColor = Util.getDataLabelColor(oStyleTool);
			oGraphics.getContext().strokeStyle = sLabelColor;
			oGraphics.getContext().lineWidth = 1;
			oGraphics.getContext().fillStyle = sLabelColor;
			Util.setupFont(oGraphics.getContext(), _iFontSize);
			
			
			var numHalfFontSize = _iFontSize * 0.5;
			var iWidth = oGraphics.getWidth();
			var iHeight = oGraphics.getHeight();
			_oNonoverlap = bOverlappable ? null : new NonoverlappingConfirmer(0, 0 + numHalfFontSize, iWidth, iHeight - numHalfFontSize);
			
			_iOuterRadius = iExtendedRadius + Math.min(4, Math.max(1, parseInt(iRadius * 0.05)));
			_iTurningLegLength = Math.min(10, Math.max(4, parseInt(iRadius * 0.1)));
		}
		
		var drawLegAndText = function(oStyleTool, oGraphics, numDrawingRadius, numAngleMid, iLegApiX1, iLegApiY1, arrTextLine, arrShortenAtLeast)
		{
			var iGap = 4;
			var iUsableTextWidth, iTextApiX, iTextApiY, sAlign;
			var iLegApiX2;
			if(numAngleMid > Math.PI)
			{
				iLegApiX2 = iLegApiX1 - _iTurningLegLength;
				sAlign = "right";
				iTextApiX = 0;
				iUsableTextWidth = iLegApiX2 - iGap - iTextApiX;
			}
			else
			{
				iLegApiX2 = iLegApiX1 + _iTurningLegLength;
				sAlign = "left";
				iTextApiX = iLegApiX2 + iGap;
				iUsableTextWidth = oGraphics.getWidth() - iTextApiX;
			}
			
			var iLines = arrTextLine.length;
			var iLineHeight = _iFontSize;
			iTextApiY = iLegApiY1 - (iLines - 1) * iLineHeight / 2;
			
			var oCtx = oGraphics.getContext();
			var arrRender = [];
			var arrLineParam = [];
			var iLineTextApiY = iTextApiY;
			var bAccepted = true;
			var bAllEmpty = true;
			for(var i = 0; i < iLines; i++)
			{
				var sText = arrTextLine[i];
				var numShortenAtLeast = arrShortenAtLeast[i];
				if(!sText)
				{
					continue;
				}
				bAllEmpty = false;
				var oRender = new CuttingTextRender();
				arrRender[i] = oRender;
				if(oRender.trying(oCtx, sText, iUsableTextWidth, numShortenAtLeast))
				{
					if(_oNonoverlap)
					{
						var iLineTextWidth = oRender.getUsedWidth();
						var iLineTextApiX = iTextApiX + (sAlign == "left" ? 0 : (iUsableTextWidth - iLineTextWidth));
						arrLineParam[i] = [iLineTextApiX, iLineTextApiY, iLineTextWidth, "left"];
						var iLineTextTop = iLineTextApiY - (iLineHeight >> 1);
						if(!_oNonoverlap.askRectCanDraw(iLineTextApiX, iLineTextTop, iLineTextWidth, iLineHeight))
						{
							return false;
						}
					}
					else
					{
						arrLineParam[i] = [iTextApiX, iLineTextApiY, iUsableTextWidth, sAlign];
					}
					iLineTextApiY += iLineHeight;
				}
				else
				{
					bAccepted = false;
					break;
				}
			}
			bAllEmpty && (bAccepted = false);
			if(bAccepted)
			{
				for(var i = 0; i < iLines; i++)
				{
					var oRender = arrRender[i];
					if(oRender)
					{
						var oLineParam = arrLineParam[i];
						var iLineTextApiX = oLineParam[0];
						var iLineTextApiY = oLineParam[1];
						var iLineTextWidth = oLineParam[2];
						var sLineAlign = oLineParam[3];
						oRender.draw(oCtx, iLineTextApiX, iLineTextApiY, sLineAlign);
						if(_oNonoverlap)
						{
							var iLineTextTop = iLineTextApiY - (iLineHeight >> 1);
							_oNonoverlap.setRectHasBeenDrawn(iLineTextApiX, iLineTextTop, iLineTextWidth, iLineHeight);
						}
					}
				}
				oGraphics.getContext().save();
				oGraphics.getContext().strokeStyle = Util.getRulerMarkLongLineColor(oStyleTool);
				oGraphics.beginPath();
				oGraphics.arc(0, 0, numDrawingRadius, numAngleMid, numAngleMid + 0.00001);//+0.01 for antique-Safari
				oGraphics.arc(0, 0, _iOuterRadius, numAngleMid, numAngleMid + 0.00001);
				oCtx.lineTo(iLegApiX2, iLegApiY1);
				oGraphics.stroke();
				oGraphics.getContext().restore();
				return true;
			}
			return false;
		}
	}
	
	/** 字太多会裁切掉的文字绘制器 */
	function CuttingTextRender()
	{
		var _this = this;
		var _bAppendDotDotDot = true;
		var _sTextBaseline = "middle"; 
		var _iUsableWidth;
		var _numCurrentWidth;
		var _sCurrentDrawingText;
		var _iCuttingLength = -1;
		
		/** 加点点点，默认为true */
		this.setDotDotDot = function(bValue)
		{
			_bAppendDotDotDot = bValue;
		}
		
		/** 设置垂直居中方式 */
		this.setTextBaseline = function(sTextBaseline)
		{
			_sTextBaseline = sTextBaseline;
		}
		
		/** 多行绘制器可以获得截取到哪，以便换行继续 */
		this.getCuttingLength = function()
		{
			return _iCuttingLength;
		}
		
		/** 实际占用的宽度，多行绘制器用 */
		this.getUsedWidth = function()
		{
			return _numCurrentWidth;
		}
		
		/** 多行绘制器用 */
		this.saveState = function()
		{
			return [_sCurrentDrawingText, _numCurrentWidth, _iUsableWidth];
		}
		this.restoreState = function(arrState)
		{
			_sCurrentDrawingText = arrState[0];
			_numCurrentWidth = arrState[1];
			_iUsableWidth = arrState[2];
		}
		
		/**
		 * 判断在宽度iUsableWidth中能否画得下sText。
		 * 此过程中允许缩短sText并在后面加点点点，并且保留的字符数比例不少于numShortenAtLeast∈(0,1]。
		 * 过程中保留状态以供后续draw()。
		 */
		this.trying = function(oCtx, sText, iUsableWidth, numShortenAtLeast)
		{
			_iUsableWidth = iUsableWidth;
			var sCurrentText = sText;
			_sCurrentDrawingText = sText;
			_iCuttingLength = -1;
			_numCurrentWidth = oCtx.measureText(sCurrentText).width;
			if(_numCurrentWidth > _iUsableWidth)
			{
				sCurrentText = quicklyShorten(oCtx, sText);
				var iCuttingLength = sCurrentText.length;
				do
				{
					if(numShortenAtLeast && (iCuttingLength / sText.length < numShortenAtLeast))
					{
						return false;
					}
					_iCuttingLength = iCuttingLength;
					_sCurrentDrawingText = sCurrentText + (_bAppendDotDotDot ? "..." : "");
					_numCurrentWidth = oCtx.measureText(_sCurrentDrawingText).width;
					iCuttingLength = sCurrentText.length - 1;
					sCurrentText = sCurrentText.substring(0, iCuttingLength);
				}
				while(_numCurrentWidth > _iUsableWidth && iCuttingLength > 0);
			}
			return true;
		}
		
		var quicklyShorten = function(oCtx, sText)
		{
			var iIdxFloor = 0;
			var iIdxCeiling = sText.length;
			while(iIdxFloor < iIdxCeiling)
			{
				var iIdxMid = iIdxFloor + ((iIdxCeiling - iIdxFloor) >> 1);
				var sCurrentText = sText.substring(0, iIdxMid);
				var numCurrentWidth = oCtx.measureText(sCurrentText).width;
				if(numCurrentWidth > _iUsableWidth)
				{
					iIdxCeiling = iIdxMid - 1;
				}
				else
				{
					iIdxFloor = iIdxMid + 1;
				}
			}
			return sText.substring(0, iIdxCeiling);
		}
		
		/**
		 * 在经过trying()判断的基础上，在起始坐标为(iApiX,iApiY)的位置进行绘制。
		 * 水平方向由sAlign指定左中右对齐，(默认)垂直方向居中。其中iApiX总是左侧。
		 */
		this.draw = function(oCtx, iApiX, iApiY, sAlign)
		{
			iApiX = align(sAlign, iApiX);
			oCtx.textBaseline = _sTextBaseline;
			oCtx.fillText(_sCurrentDrawingText, iApiX, iApiY);
		}
		
		var align = function(sAlign, iApiX)
		{
			var iAlignedApiX = iApiX;
			if(sAlign == "center")
			{
				iAlignedApiX = iApiX + ((_iUsableWidth - _numCurrentWidth) >> 1);
			}
			else if(sAlign == "right")
			{
				iAlignedApiX = iApiX + _iUsableWidth - _numCurrentWidth;
			}
			return iAlignedApiX;
		}
		
		var drawWithLogicCoord = function(oGraphics, iLogicX, iLogicY, sText, iPhysicalUsableWidth, sAlign)
		{
			var oCtx = oGraphics.getContext();
			oCtx.textBaseline = _sTextBaseline;
			if(_this.trying(oCtx, sText, iPhysicalUsableWidth))
			{
				oGraphics.fillText(_sCurrentDrawingText, iLogicX, iLogicY, 
					function(arrApiXY)
					{
						arrApiXY[0] = align(sAlign, arrApiXY[0]);
					});
			}
		}
		
		/**
		 * 在oCtx的(iApiX,iApiY)位置，不超过宽度iPhysicalUsableWidth，绘制sText。左对齐，(默认)垂直居中。
		 */
		this.drawAlignLeft = function(oCtx, iApiX, iApiY, sText, iPhysicalUsableWidth)
		{
			if(_this.trying(oCtx, sText, iPhysicalUsableWidth))
			{
				_this.draw(oCtx, iApiX, iApiY);
			}
		}
		
		this.drawAlignRight = function(oCtx, iApiX, iApiY, sText, iPhysicalUsableWidth)
		{
			if(_this.trying(oCtx, sText, iPhysicalUsableWidth))
			{
				_this.draw(oCtx, iApiX, iApiY, "right");
			}
		}
		
		this.drawAlignCenter = function(oCtx, iApiX, iApiY, sText, iPhysicalUsableWidth)
		{
			if(_this.trying(oCtx, sText, iPhysicalUsableWidth))
			{
				_this.draw(oCtx, iApiX, iApiY, "center");
			}
		}
		
		/**
		 * 在oGraphics的(iLogicX,iLogicY)位置，不超过宽度iPhysicalUsableWidth个物理点，绘制sText。水平居中，(默认)垂直居中。
		 */
		this.drawAlignCenterWithLogicCoord = function(oGraphics, iLogicX, iLogicY, sText, iPhysicalUsableWidth)
		{
			drawWithLogicCoord(oGraphics, iLogicX, iLogicY, sText, iPhysicalUsableWidth, "center");
		}
		
		this.drawAlignRightWithLogicCoord = function(oGraphics, iLogicX, iLogicY, sText, iPhysicalUsableWidth)
		{
			drawWithLogicCoord(oGraphics, iLogicX, iLogicY, sText, iPhysicalUsableWidth, "right");
		}
		
		this.drawAlignLeftWithLogicCoord = function(oGraphics, iLogicX, iLogicY, sText, iPhysicalUsableWidth)
		{
			drawWithLogicCoord(oGraphics, iLogicX, iLogicY, sText, iPhysicalUsableWidth, "left");
		}
	}
	
	/** 多行的文字绘制器 */
	function MultiLineTextRender()
	{
		var _iHAlign = -1;
		var _iVAlign = -1;
		
		/** left|center|right */
		this.setHorizontalAlign = function(sAlign)
		{
			_iHAlign = (sAlign == "center" ? 0 : (sAlign == "right" ? 1 : -1));
		}
		
		/** top|middle|bottom */
		this.setVerticalAlign = function(sAlign)
		{
			_iVAlign = (sAlign == "middle" ? 0 : (sAlign == "bottom" ? 1 : -1));
		}
		
		this.drawTextLines = function(oGraphics, iLogicX, iLogicY, sText, iPhysicalWidth, iPhysicalHeight, iPhysicalLineHeight)
		{
			var arrApiXY = oGraphics.transformXY(iLogicX, iLogicY);
			var iApiX = arrApiXY[0];
			var iApiY = arrApiXY[1];
			var arrEachLineState = [];
			var oCtx = oGraphics.getContext();
			var oRender = new CuttingTextRender();
			oRender.setTextBaseline("top");
			oRender.setDotDotDot(false);
			var iUsedHeight = iPhysicalLineHeight;
			var numMaxUsedWidth = 0;
			var bFirstTime = true;//至少一行
			while(iUsedHeight <= iPhysicalHeight || bFirstTime)
			{
				bFirstTime = false;
				var bLastLine = (iUsedHeight + iPhysicalLineHeight > iPhysicalHeight);
				bLastLine && oRender.setDotDotDot(true);
				
				if(oRender.trying(oCtx, sText, iPhysicalWidth))
				{
					arrEachLineState.push(oRender.saveState());
					numMaxUsedWidth = Math.max(numMaxUsedWidth, oRender.getUsedWidth());
				}
				
				var iCuttingLength = oRender.getCuttingLength();
				if(iCuttingLength < 0 || iCuttingLength >= sText.length)
				{
					break;
				}
				sText = sText.substring(iCuttingLength, sText.length);
				iUsedHeight += iPhysicalLineHeight;
			}
			var iAlignedApiX = align(_iHAlign, iApiX, iPhysicalWidth, numMaxUsedWidth);
			var iAlignedApiY = align(_iVAlign, iApiY, iPhysicalHeight, iUsedHeight);
			for(var i = 0; i < arrEachLineState.length; i++)
			{
				oRender.restoreState(arrEachLineState[i]);
				oRender.draw(oCtx, iAlignedApiX, iAlignedApiY, "left");
				iAlignedApiY += iPhysicalLineHeight;
			}
		}
		
		var align = function(iAlignTag, iStart, iUsableWide, iUsedWide)
		{
			var iAlignedStart = iStart;
			if(iAlignTag == 0)
			{
				iAlignedStart = iStart + ((iUsableWide - iUsedWide) >> 1);
			}
			else if(iAlignTag > 0)
			{
				iAlignedStart = iStart + iUsableWide - iUsedWide;
			}
			return iAlignedStart;
		}
	}
	
	/** 能自动缩小字号的文字绘制器 */
	function ShrinkableTextRender()
	{
		var _this = this;
		
		/** 
		 * 在(iApiX,iApiY)为起点的矩形区域中，以iFontSize的字号绘制文字sText。iY约定为middle。
		 * 如果宽度超出iWidth则缩小字号，但不小于iMinFontSize。
		 * sAlign指定水平对齐："left"、"right"、"center"。
		 */
		this.drawInRectangle = function(oCtx, iApiX, iApiY, iWidth, sText, iFontSize, iMinFontSize, sAlign)
		{
			oCtx.save();
			oCtx.textBaseline = "middle";
			var iCurrentFontSize = iFontSize;
			var numCurrentWidth;
			var bTryAgain = true;
			while(bTryAgain)
			{
				Util.setupFont(oCtx, iCurrentFontSize);
				numCurrentWidth = oCtx.measureText(sText).width;
				if(numCurrentWidth > iWidth)
				{
					if(iCurrentFontSize - 1 < iMinFontSize)
					{
						bTryAgain = false;
					}
					else
					{
						iCurrentFontSize -= 1;
					}
				}
				else
				{
					bTryAgain = false;
				}
			}
			var iDrawingX = iApiX;
			if(sAlign == "center")
			{
				iDrawingX = iApiX + ((iWidth - numCurrentWidth) >> 1);
			}
			else if(sAlign == "right")
			{
				iDrawingX = iApiX + iWidth - numCurrentWidth;
			}
			Util.setupFont(oCtx, iCurrentFontSize);
			oCtx.fillText(sText, iDrawingX, iApiY);
			oCtx.restore();
		}
		
		/**
		 * 在(0,0)为圆心，半径为iRadius的区域中，以iFontSize的字号绘制文字sText。
		 * 如果宽度超出区域则缩小字号。
		 * 水平、垂直方向总是以圆心居中。
		 */
		this.drawInCircle = function(oGraphics, iOffsetApiY, iRadius, sText, iFontSize)
		{
			var oCtx = oGraphics.getContext();
			oCtx.save();
			oCtx.textBaseline = "bottom";
			var iCurrentFontSize = iFontSize;
			var numCurrentWidth;
			var bTryAgain = true;
			while(bTryAgain)
			{
				var numHalfFont = iCurrentFontSize / 2;
				var numWidth = (iRadius < numHalfFont ? 0 : Math.sqrt(Math.pow(iRadius, 2) - Math.pow(numHalfFont, 2)) * 2 * 0.8);//80%，全用满不好看
				Util.setupFont(oCtx, iCurrentFontSize);
				numCurrentWidth = oCtx.measureText(sText).width;
				if(numCurrentWidth > numWidth)
				{
					if(iCurrentFontSize - 1 < 2)
					{
						bTryAgain = false;
					}
					else
					{
						iCurrentFontSize -= 1;
					}
				}
				else
				{
					bTryAgain = false;
				}
			}
			Util.setupFont(oCtx, iCurrentFontSize);
			oGraphics.fillText(sText, 0, 0,
				function(arrApiXY)
				{
					arrApiXY[0] = arrApiXY[0] - (numCurrentWidth >> 1);
					arrApiXY[1] = arrApiXY[1] + iOffsetApiY + iCurrentFontSize * 0.6;
					//+0.5，基于"bottom"，下移半个字号。这是因为"middle"存在浏览器差异。
					//+0.1，由于绘制效果偏上，再调整为了好看。
				});
			oCtx.restore();
		}
		
		this.drawDualLineInCircle = function(oGraphics, iRadius, sMainText, iFontSize1, sMinorText, iFontSize2)
		{
			_this.drawInCircle(oGraphics, -iFontSize1 * 0.3, iRadius, sMainText, iFontSize1);
			_this.drawInCircle(oGraphics, iFontSize2 * 1.2, iRadius, sMinorText, iFontSize2);
		}
	}
	
	/** 数轴辅助类 */
	function NumberRulerHelper(oScopeAdapter, oStyleTool)
	{
		var _oScopeAdapter = oScopeAdapter;
		var _oStyleTool = oStyleTool;
		var _iSectionWithCeiling = NumberRulerHelper.SECTION_WITH_CEILING_AUTO;
		
		var _arrPositiveMark;
		var _arrNegativeMark;
		var _positiveBigger = false;
		var _negativeBigger = false;
		
		/** 数轴刻度极值策略 */
		this.setSectionWithCeiling = function(iConst)
		{
			_iSectionWithCeiling = iConst;
		}
		
		var getMarkTextFontSize = function()
		{
			return Util.getRulerMarkTextFontSize(_oStyleTool);
		}
		var getMarkTextColor = function()
		{
			return Util.getRulerMarkTextColor(_oStyleTool);
		}
		var getMarkLongLineColor = function()
		{
			return Util.getRulerMarkLongLineColor(_oStyleTool);
		}
		var getMarkShortLineColor = function()
		{
			return Util.getRulerMarkShortLineColor(_oStyleTool);
		}
		
		/** 计算纵向数轴的合适宽度 */
		this.suggestVerticalRulerWidth = function(oGraphics, sFormatString, sAxisTitle)
		{
			var iFontSize = getMarkTextFontSize();
			var oCtx = oGraphics.getContext();
			Util.setupFont(oCtx, iFontSize);
			
			var iMaxWidth = 0;
			var funMeasure = function(sText)
			{
				var numTextWidth = oCtx.measureText(sText).width;
				iMaxWidth = Math.max(iMaxWidth, parseInt(numTextWidth + 1));
			};
			
			var oFormater = new NumberFormater();
			oFormater.setFormatString(sFormatString);
			
			funMeasure(oFormater.format(_oScopeAdapter.unscale(_oScopeAdapter.getScopeMin())));
			funMeasure(oFormater.format(_oScopeAdapter.unscale(_oScopeAdapter.getScopeMax())));
			sAxisTitle && funMeasure(sAxisTitle);
			
			var iReserve = (_iSectionWithCeiling == NumberRulerHelper.SECTION_WITH_CEILING_REJECT ? 0 : (iFontSize >> 1));
			var iTextGap = 10;
			return iMaxWidth + iReserve + iTextGap;
		}
		
		/** 计算横向数轴的合适高度 */
		this.suggestHorizontalRulerHeight = function(bWithAxisTitle)
		{
			var iLineHeight = getMarkTextFontSize();
			return iLineHeight * (bWithAxisTitle ? 3 : 2);//See each other ★
		}
		
		/** 纵向数轴确定标尺刻度基数1|2|5。可能向大“取整”，修订最大最小值。 */
		this.confirmVerticalRulerMark = function(numUsablePixels)
		{
			confirmHVRulerMark(
				function(numSpacePreallocatedRatio)
				{
					numUsablePixels = numUsablePixels * numSpacePreallocatedRatio;
					var iDistance;
					if(_iSectionWithCeiling == NumberRulerHelper.SECTION_WITH_CEILING_REJECT)
					{
						iDistance = (numUsablePixels < 100 ? 20 : (numUsablePixels < 150 ? 25 : 30));	
					}
					else
					{
						iDistance = (numUsablePixels < 100 ? 25 : (numUsablePixels < 150 ? 30 : 35));
					}
					var iSuggestSegmentCount = parseInt(numUsablePixels / iDistance) + 1;
					return iSuggestSegmentCount;
				});
		}
		/** 横向数轴确定标尺刻度基数1|2|5。可能向大“取整”，修订最大最小值。 */
		this.confirmHorizontalRulerMark = function(numUsablePixels)
		{
			confirmHVRulerMark(
				function(numSpacePreallocatedRatio)
				{
					numUsablePixels = numUsablePixels * numSpacePreallocatedRatio;
					var iDistance = (numUsablePixels < 200 ? 80 : numUsablePixels < 600 ? 100 : 150);
					var iSuggestSegmentCount = parseInt(numUsablePixels / iDistance) + 1;
					return iSuggestSegmentCount;
				});
		}
		var confirmHVRulerMark = function(funSuggestSegmentCount)
		{
			var numMin = _oScopeAdapter.getScopeMin();
			var numMax = _oScopeAdapter.getScopeMax();
			confirmRulerMark(numMin, numMax, funSuggestSegmentCount);
			if(_iSectionWithCeiling != NumberRulerHelper.SECTION_WITH_CEILING_REJECT)
			{
				numMax = (_arrPositiveMark && _positiveBigger ? _arrPositiveMark[_arrPositiveMark.length - 1] : null);
				numMin = (_arrNegativeMark && _negativeBigger ? _arrNegativeMark[_arrNegativeMark.length - 1] * -1 : null);
				_oScopeAdapter.updateScopeMaxMin(numMax, numMin);
			}
		}
		
		/** 确定雷达图极座标标尺刻度基数1|2|5，返回从小到大的刻度数组。总是向大“取整”，且修订ScopeAdapter的最大最小值。 */
		this.confirmRadarRulerMarker = function(numUsablePixels)
		{
			_iSectionWithCeiling = NumberRulerHelper.SECTION_WITH_CEILING_ALWAYS;
			confirmHVRulerMark( 
				function(numSpacePreallocatedRatio)
				{
					numUsablePixels = numUsablePixels * numSpacePreallocatedRatio;
					var iDistance = (numUsablePixels < 100 ? 30 : numUsablePixels < 250 ? 50 : numUsablePixels < 400 ? 80 : 100);
					var iSuggestSegmentCount = parseInt(numUsablePixels / iDistance) + 1;
					return iSuggestSegmentCount;
				});
			var arrAllMark = [0];
			if(_arrNegativeMark)
			{
				_arrNegativeMark.forEach(
					function(iValue)
					{
						arrAllMark.unshift(-iValue);
					});
			}
			if(_arrPositiveMark)
			{
				arrAllMark = arrAllMark.concat(_arrPositiveMark);
			}
			return arrAllMark;
		}
		
		/** 确定表盘的刻度基数1|2|5，返回从小到大的刻度数组。 */
		this.confirmDialMark = function(iParam)
		{
			_iSectionWithCeiling = NumberRulerHelper.SECTION_WITH_CEILING_REJECT;
			confirmHVRulerMark( 
				function(numSpacePreallocatedRatio)
				{
					return iParam;
				});
			var arrAllMark = [];
			if(!_oScopeAdapter.isCuttingFoot())
			{
				arrAllMark.push(0);
			}
			if(_arrNegativeMark)
			{
				_arrNegativeMark.forEach(
					function(iValue)
					{
						arrAllMark.unshift(-iValue);
					});
			}
			if(_arrPositiveMark)
			{
				arrAllMark = arrAllMark.concat(_arrPositiveMark);
			}
			return arrAllMark;
		}
		
		/** 绘制上方数轴及其刻度（长卷风格） */
		this.drawTopNumberAxisWithMark = function(oGraphics, numPixelPerValue, sFormatString, sAxisTitle)
		{
			drawTopNumberAxis(oGraphics, numPixelPerValue, sFormatString, sAxisTitle,
				function(iY)
				{
					var iMarkLen = 5;
					oGraphics.getContext().strokeStyle = getMarkShortLineColor();
					oGraphics.beginPath();
					oGraphics.moveTo(0, iY);
					oGraphics.lineTo(-iMarkLen, iY);
					oGraphics.stroke();
				});
		}
		
		/** 绘制左侧数轴及其刻度（长卷风格） */
		this.drawLeftNumberAxisWithMark = function(oGraphics, iAxisAreaWidth, numPixelPerValue, sFormatString, sAxisTitle)
		{
			drawLeftNumberAxis(oGraphics, 0, iAxisAreaWidth, numPixelPerValue, sFormatString, sAxisTitle,
				function(iY)
				{
					var iMarkLen = 6;
					oGraphics.getContext().strokeStyle = getMarkShortLineColor();
					oGraphics.beginPath();
					oGraphics.moveTo(-iMarkLen, iY);
					oGraphics.lineTo(0, iY);
					oGraphics.stroke();
				});
		}
		
		/** 绘制左侧数轴及绘图区的辅助线（斗方风格） */
		this.drawLeftNumberAxisWithAssistantLine = function(oGraphics, iAxisAreaWidth, numPixelPerValue, sFormatString, sAxisTitle, iAssistantLineLen)
		{
			drawLeftNumberAxis(oGraphics, 0, iAxisAreaWidth, numPixelPerValue, sFormatString, sAxisTitle,
				function(iY)
				{
					if(iY != 0)
					{
						oGraphics.getContext().strokeStyle = getMarkLongLineColor();
						oGraphics.drawDashedLine(0, iY, iAssistantLineLen, iY, 4);
					}
				});
		}
		
		/** 绘制右侧数轴及其刻度（斗方副轴） */
		this.drawRightNumberAxisWithMark = function(oGraphics, iAxisAreaX, iAxisAreaWidth, numPixelPerValue, sFormatString, sAxisTitle)
		{
			drawRightNumberAxis(oGraphics, iAxisAreaX, iAxisAreaWidth, numPixelPerValue, sFormatString, sAxisTitle, 
				function(iY)
				{
					var iMarkLen = 3;
					oGraphics.getContext().strokeStyle = getMarkShortLineColor();
					oGraphics.beginPath();
					oGraphics.moveTo(iAxisAreaX - iMarkLen, iY);
					oGraphics.lineTo(iAxisAreaX, iY);
					oGraphics.stroke();
				});
		}
		
		/** 绘制底部数轴及绘图区的辅助线 */
		this.drawBottomNumberAxisWithAssistantLine = function(oGraphics, numPixelPerValue, sFormatString, sAxisTitle, iAssistantLineLen)
		{
			drawBottomNumberAxis(oGraphics, numPixelPerValue, sFormatString, sAxisTitle,
				function(iLogicY)
				{
					oGraphics.getContext().strokeStyle = getMarkLongLineColor();
					oGraphics.drawDashedLine(iAssistantLineLen, iLogicY, 0, iLogicY, 4);
				},
				function(iLogicY)
				{
					var iLogicX = iAssistantLineLen;
					var arrApiXY = oGraphics.transformXY(iLogicX, iLogicY);
					return arrApiXY;
				});
		}
		
		/** 绘制XY双数轴的底部数轴及绘图区的辅助线 */
		this.drawDoubleNumberAxisOfBottom = function(oGraphics, iYPosition, numPixelPerValue, sFormatString, sAxisTitle, iAssistantLineLen)
		{
			drawBottomNumberAxis(oGraphics, numPixelPerValue, sFormatString, sAxisTitle,
				function(iLogicX)
				{
					oGraphics.getContext().strokeStyle = getMarkLongLineColor();
					oGraphics.drawDashedLine(iLogicX, iYPosition, iLogicX, iYPosition + iAssistantLineLen, 4);
				},
				function(iLogicX)
				{
					var iLogicY = iYPosition;
					var arrApiXY = oGraphics.transformXY(iLogicX, iLogicY);
					return arrApiXY;
				});
		}
		/** 绘制XY双数轴的左侧数轴及绘图区的辅助线 */
		this.drawDoubleNumberAxisOfLeft = function(oGraphics, iXPosition, iAxisAreaWidth, numPixelPerValue, sFormatString, sAxisTitle, iAssistantLineLen)
		{
			drawLeftNumberAxis(oGraphics, iXPosition, iAxisAreaWidth, numPixelPerValue, sFormatString, sAxisTitle,
				function(iY)
				{
					oGraphics.getContext().strokeStyle = getMarkLongLineColor();
					oGraphics.drawDashedLine(iXPosition, iY, iXPosition + iAssistantLineLen, iY, 4);
				});
		}
		
		/** 绘制横向辅助线（长卷风格）*/
		this.drawHorizontalAssistantLine = function(oGraphics, numPixelPerValue)
		{
			var iWidth = oGraphics.getWidth();
			oGraphics.getContext().strokeStyle = getMarkLongLineColor();
			drawAssistantLine(numPixelPerValue,
				function(iY)
				{
					oGraphics.drawDashedLine(-iWidth, iY, iWidth, iY, 4);
				});
		}
		/** 绘制纵向辅助线（长卷风格）*/
		this.drawVerticalAssistantLine = function(oGraphics, numPixelPerValue)
		{
			var iHeight = oGraphics.getHeight();
			oGraphics.getContext().strokeStyle = getMarkLongLineColor();
			drawAssistantLine(numPixelPerValue,
				function(iX)
				{
					oGraphics.drawDashedLine(iX, -iHeight, iX, iHeight, 4);
				});
		}
		var drawAssistantLine = function(numPixelPerValue, funDrawMark)
		{
			!_oScopeAdapter.isCuttingFoot() && funDrawMark(0);
			_arrPositiveMark && drawMarks(_arrPositiveMark, 1, numPixelPerValue, funDrawMark, function(){});
			_arrNegativeMark && drawMarks(_arrNegativeMark, -1, numPixelPerValue, funDrawMark, function(){});
		}
		
		var drawBottomNumberAxis = function(oGraphics, numPixelPerValue, sFormatString, sAxisTitle, funDrawMark, funTextXYConfirmer)
		{
			var iFontSize = getMarkTextFontSize();
			var oCtx = oGraphics.getContext();
			Util.setupFont(oCtx, iFontSize);
			oCtx.textBaseline = "bottom";//★
			var oFormater = new NumberFormater();
			oFormater.setFormatString(sFormatString);
			var iPhysicalWidth = oGraphics.getWidth();
			var iAxisTextY;
			var sLastText = "";
			var funDrawText = function(numMarkShowText, iMarkLogicValue)
			{
				var sText = oFormater.format(numMarkShowText, NumberFormater.RoundingMode.DOWN);
				if(sText == sLastText)
				{
					return;
				}
				sLastText = sText;
				oCtx.fillStyle = getMarkTextColor();
				var iTextWidth = oCtx.measureText(sText).width;
				
				var arrApiXY = funTextXYConfirmer(iMarkLogicValue, iFontSize);//标记所在轴上的点
				var iApiX = arrApiXY[0] - (iTextWidth >> 1);
				iApiX = Math.max(1, iApiX);
				iApiX = (iApiX + iTextWidth > iPhysicalWidth ? iPhysicalWidth - iTextWidth : iApiX);
				var iApiY = arrApiXY[1] + iFontSize * 1.6;//★
				oCtx.fillText(sText, iApiX, iApiY);
				
				iAxisTextY = iApiY;
			};
			if(!_oScopeAdapter.isCuttingFoot())
			{				
				funDrawMark(0);
				funDrawText("0", 0);
			}
			_arrPositiveMark && drawMarks(_arrPositiveMark, 1, numPixelPerValue, funDrawMark, funDrawText);
			_arrNegativeMark && drawMarks(_arrNegativeMark, -1, numPixelPerValue, funDrawMark, funDrawText);
			if(sAxisTitle)
			{
				iAxisTextY += getMarkTextFontSize() * 1.2;//★
				var iTextWidth = oCtx.measureText(sAxisTitle).width;
				oCtx.fillStyle = getMarkTextColor();
				oCtx.fillText(sAxisTitle, iPhysicalWidth - iTextWidth, iAxisTextY);
			}
		}
		
		var drawTopNumberAxis = function(oGraphics, numPixelPerValue, sFormatString, sAxisTitle, funDrawMark)
		{
			var iFontSize = getMarkTextFontSize();
			var oCtx = oGraphics.getContext();
			Util.setupFont(oCtx, iFontSize);
			oCtx.textBaseline = "bottom";
			var oFormater = new NumberFormater();
			oFormater.setFormatString(sFormatString);
			var iPhysicalWidth = oGraphics.getWidth();
			var iAxisTextY;
			var sLastText = "";
			var funDrawText = function(numMarkShowText, iLogicY)
			{
				var sText = oFormater.format(numMarkShowText, NumberFormater.RoundingMode.DOWN);
				if(sText == sLastText)
				{
					return;
				}
				sLastText = sText;
				oCtx.fillStyle = getMarkTextColor();
				var iTextWidth = oCtx.measureText(sText).width;
				var iLogicX = -8;
				oGraphics.fillText(sText, iLogicX, iLogicY, 
					function(arrApiXY)
					{
						var iApiX = arrApiXY[0] - (iTextWidth >> 1);
						iApiX = Math.max(1, iApiX);
						iApiX = (iApiX + iTextWidth > iPhysicalWidth ? iPhysicalWidth - iTextWidth : iApiX);
						arrApiXY[0] = iApiX;
						iAxisTextY = arrApiXY[1];
					});
			};
			if(!_oScopeAdapter.isCuttingFoot())
			{				
				funDrawMark(0);
				funDrawText("0", 0);
			}
			_arrPositiveMark && drawMarks(_arrPositiveMark, 1, numPixelPerValue, funDrawMark, funDrawText);
			_arrNegativeMark && drawMarks(_arrNegativeMark, -1, numPixelPerValue, funDrawMark, funDrawText);
			if(sAxisTitle)
			{
				iAxisTextY -= getMarkTextFontSize();
				var iTextWidth = oCtx.measureText(sAxisTitle).width;
				oCtx.fillStyle = getMarkTextColor();
				oCtx.fillText(sAxisTitle, iPhysicalWidth - iTextWidth, iAxisTextY);
			}
		}
		
		var drawLeftNumberAxis = function(oGraphics, iXPosition, iAxisAreaWidth, numPixelPerValue, sFormatString, sAxisTitle, funDrawMark)
		{
			var iXStart = iXPosition - iAxisAreaWidth;
			var iTextGap = 10;
			var oCtx = oGraphics.getContext();
			Util.setupFont(oCtx, getMarkTextFontSize());
			oCtx.textBaseline = "middle";
			var oFormater = new NumberFormater();
			oFormater.setFormatString(sFormatString);
			var sLastText = "";
			var funDrawText = function(numMarkShowText, iY)
			{
				var sText = oFormater.format(numMarkShowText, NumberFormater.RoundingMode.DOWN);
				if(sText == sLastText)
				{
					return;
				}
				sLastText = sText;
				oCtx.fillStyle = getMarkTextColor();
				var iTextWidth = parseInt(oCtx.measureText(sText).width + 1);
				var iX = iXPosition - iTextGap - iTextWidth;
				if(iX < iXStart)
				{
					iX = iXPosition - iTextWidth;//mac系统的英文字符不等宽，通过suggestVerticalRulerWidth()测算的“刚刚好”的轴宽度可能不够。借用iTextGap的空间，使其不轻易出现点点点。
					if(iX < iXStart)
					{
						sText = Util.shortenTextBefore(sText, iTextWidth, iAxisAreaWidth - iTextGap);
					}
					iX = iXStart;
				}
				oGraphics.fillText(sText, iX, iY);
			};
			if(sAxisTitle)
			{
				var iTextWidth = oCtx.measureText(sAxisTitle).width;
				var iY = Math.max(0, _oScopeAdapter.cutFoot(_oScopeAdapter.getScopeMax()) * numPixelPerValue) + getMarkTextFontSize();
				var iX = iXPosition - iTextWidth - iTextGap;
				if(iX < iXStart)
				{
					sAxisTitle = Util.shortenText(sAxisTitle, iTextWidth, iAxisAreaWidth - iTextGap, oCtx);
					iX = iXStart;
				}
				oCtx.fillStyle = getMarkTextColor();
				oGraphics.fillText(sAxisTitle, iX, iY);
			}
			if(!_oScopeAdapter.isCuttingFoot())
			{				
				funDrawMark(0);
				funDrawText("0", 0);
			}
			_arrPositiveMark && drawMarks(_arrPositiveMark, 1, numPixelPerValue, funDrawMark, funDrawText);
			_arrNegativeMark && drawMarks(_arrNegativeMark, -1, numPixelPerValue, funDrawMark, funDrawText);
		}
		
		var drawRightNumberAxis = function(oGraphics, iAxisAreaX, iAxisAreaWidth, numPixelPerValue, sFormatString, sAxisTitle, funDrawMark)
		{
			var iTextGap = 6;
			var oCtx = oGraphics.getContext();
			Util.setupFont(oCtx, getMarkTextFontSize());
			oCtx.textBaseline = "middle";
			var oFormater = new NumberFormater();
			oFormater.setFormatString(sFormatString);
			var sLastText = "";
			var funDrawText = function(numMarkShowText, iY)
			{
				var sText = oFormater.format(numMarkShowText, NumberFormater.RoundingMode.DOWN);
				if(sText == sLastText)
				{
					return;
				}
				sLastText = sText;
				oCtx.fillStyle = getMarkTextColor();
				var iTextWidth = parseInt(oCtx.measureText(sText).width) + 1;
				var iX = iAxisAreaX + iTextGap;
				if(iX + iTextWidth > iAxisAreaX + iAxisAreaWidth)
				{
					sText = Util.shortenText(sText, iTextWidth, iAxisAreaWidth - iTextGap);
				}
				oGraphics.fillText(sText, iX, iY);
			};
			if(sAxisTitle)
			{
				var iTextWidth = oCtx.measureText(sAxisTitle).width;
				var iY = Math.max(0, _oScopeAdapter.cutFoot(_oScopeAdapter.getScopeMax()) * numPixelPerValue) + getMarkTextFontSize();
				var iX = iAxisAreaX + iTextGap;
				if(iX + iTextWidth > iAxisAreaX + iAxisAreaWidth)
				{
					sAxisTitle = Util.shortenText(sAxisTitle, iTextWidth, iAxisAreaWidth - iTextGap, oCtx);
				}
				oCtx.fillStyle = getMarkTextColor();
				oGraphics.fillText(sAxisTitle, iX, iY);
			}
			if(!_oScopeAdapter.isCuttingFoot())
			{				
				funDrawMark(0);
				funDrawText("0", 0);
			}
			_arrPositiveMark && drawMarks(_arrPositiveMark, 1, numPixelPerValue, funDrawMark, funDrawText);
			_arrNegativeMark && drawMarks(_arrNegativeMark, -1, numPixelPerValue, funDrawMark, funDrawText);
		}
		
		var drawMarks = function(arrMark, iDir, numPixelPerValue, funDrawMark, funDrawText)
		{
			for(var i = 0; i < arrMark.length; i++)
			{
				var numMark = iDir * arrMark[i];
				var numMarkRulerFitted = _oScopeAdapter.cutFoot(numMark);
				var numMarkShowText = _oScopeAdapter.unscale(numMark);
				var iY = parseInt(numMarkRulerFitted * numPixelPerValue + 0.5);
				funDrawMark(iY);
				funDrawText(numMarkShowText, iY);
			}
		}
		
		var confirmRulerMark = function(numMin, numMax, funSuggestSegmentCount)
		{
			var confirmSegment = (_oScopeAdapter.isWithLog() ? confirmSegmentForLogScale : confirmSegmentForLinear);
			_arrPositiveMark = null;
			_arrNegativeMark = null;
			_positiveBigger = false;
			_negativeBigger = false;
			if(numMax > 0 && numMin < 0)
			{
				var oBase = {};
				if(numMax < -numMin)
				{
					var numSpacePreallocatedRatio = -numMin / (numMax - numMin);
					var iSegmentCount = funSuggestSegmentCount(numSpacePreallocatedRatio);
					var arrMoreReturnA = [];
					_arrNegativeMark = confirmSegment(arrMoreReturnA, -numMin, iSegmentCount, oBase);
					_negativeBigger = arrMoreReturnA[0];
					var arrMoreReturnB = [];
					_arrPositiveMark = confirmSegment(arrMoreReturnB, numMax, iSegmentCount, oBase);
					_positiveBigger = arrMoreReturnB[0];
				}
				else
				{
					var numSpacePreallocatedRatio = numMax / (numMax - numMin);
					var iSegmentCount = funSuggestSegmentCount(numSpacePreallocatedRatio);
					var arrMoreReturnA = [];
					_arrPositiveMark = confirmSegment(arrMoreReturnA, numMax, iSegmentCount, oBase);
					_positiveBigger = arrMoreReturnA[0];
					var arrMoreReturnB = [];
					_arrNegativeMark = confirmSegment(arrMoreReturnB, -numMin, iSegmentCount, oBase);
					_negativeBigger = arrMoreReturnB[0];
				}
			}
			else if(numMax <= 0)
			{
				var numSpacePreallocatedRatio = 1;
				var iSegmentCount = funSuggestSegmentCount(numSpacePreallocatedRatio);
				var arrMoreReturn = [];
				_arrNegativeMark = confirmSegment(arrMoreReturn, -numMin, iSegmentCount);
				_negativeBigger = arrMoreReturn[0];
			}
			else
			{
				var numSpacePreallocatedRatio = 1;
				var iSegmentCount = funSuggestSegmentCount(numSpacePreallocatedRatio);
				var arrMoreReturn = [];
				_arrPositiveMark = confirmSegment(arrMoreReturn, numMax, iSegmentCount);
				_positiveBigger = arrMoreReturn[0];
			}
		}
		
		var confirmSegmentForLogScale = function(arrMoreReturn, numAbsLargest, iSuggestSegmentCount, oStep)
		{
			var iStep;
			if(oStep && oStep["step"])
			{
				iStep = oStep["step"];
			}
			else
			{
				for(var i = 1; i < 64; i++)
				{
					iStep = i;
					if(numAbsLargest / iStep <= iSuggestSegmentCount)
					{
						break;
					}
				}
				oStep && (oStep["step"] = iStep);
			}
			var iCuttableFoot = _oScopeAdapter.getCuttableFoot();
			var arrValue = [];
			for(var i = iCuttableFoot + iStep; i <= numAbsLargest; i += iStep)
			{
				arrValue.push(i);
			}
			return arrValue;
		}
		
		var confirmSegmentForLinear = function(arrMoreReturn, numAbsLargest, iSuggestSegmentCount, oBase)
		{
			var numCuttableFoot = _oScopeAdapter.getCuttableFoot();
			var arrFirst2Digit = parseDistance(numAbsLargest - numCuttableFoot);
			var iFirst2Digit = arrFirst2Digit[0];
			var iPower = arrFirst2Digit[1];
			var iBase;
			if(oBase && oBase["base"])
			{
				iBase = oBase["base"] / Math.pow(10, iPower);
			}
			else
			{
				var arrCheckBase = [1, 2, 5, 10, 20, 50];
				for(var i = 0; i < arrCheckBase.length; i++)
				{
					iBase = arrCheckBase[i];
					if(iFirst2Digit / iBase < iSuggestSegmentCount)
					{
						break;
					}
				}
				oBase && (oBase["base"] = iBase * Math.pow(10, iPower));
			}
			
			var numSectionLength = iBase * Math.pow(10, iPower);//每段的距离是基于base(1|2|5)的10的power次方
			var numFootNearestLine = calculateSectionLine(numCuttableFoot, numSectionLength);
			var numStartLine = numFootNearestLine;
			var arrWrap = calculateSectionLineMaybeCeiling(numAbsLargest, numSectionLength);
			var numEndLine = arrWrap[0];
			var bBigger = arrWrap[1];
			arrMoreReturn[0] = bBigger;
			var arrValue = [];
			var numValue = numStartLine;
			while(numValue < numEndLine)
			{
				numValue = addDecimal(numValue, numSectionLength);
				arrValue.push(numValue);
			}
			return arrValue;
		}
		
		//JS 0.1+0.2 精度问题
		var addDecimal = function(numA, numB)
		{
			var iDecA;
			var iDecB;
			try{iDecA = numA.toString().split(".")[1].length;}catch(e){iDecA = 0;}
			try{iDecB = numB.toString().split(".")[1].length;}catch(e){iDecB = 0;}
			var iPower = Math.pow(10, Math.max(iDecA, iDecB));
			return (numA * iPower + numB * iPower) / iPower;
		}
		
		//离value最近，且不大于value的分段界线值
		var calculateSectionLine = function(numValue, numSectionLength)
		{
			// parseInt在值过度趋向于0时，转换异常
			// parseInt(1e-6) == 0  parseInt(5e-6) == 0
			// parseInt(1e-7) == 1  parseInt(5e-7) == 5
			var numSectionNum = numValue / numSectionLength;
			if(-1 < numSectionNum && numSectionNum < 1)
			{
				numSectionNum = 0;
			}
			return parseInt(numSectionNum) * numSectionLength;
		}
		
		//离value最近，且不小于value的分段界线值
		var calculateSectionLineMaybeCeiling = function(numValue, numSectionLength)
		{
			var numNearestFloor = calculateSectionLine(numValue, numSectionLength);
			var numNearest = numNearestFloor;
			var bBigger = false;
			if(_iSectionWithCeiling != NumberRulerHelper.SECTION_WITH_CEILING_REJECT && numNearestFloor < numValue)
			{
				if(_iSectionWithCeiling == NumberRulerHelper.SECTION_WITH_CEILING_ALWAYS 
						|| (numValue - numNearestFloor) / numSectionLength > 0.382)
				{
					numNearest = addDecimal(numNearestFloor, numSectionLength);
					bBigger = true;
				}
			}
			return [numNearest, bBigger];
		}
		
		//[0]:10~99两位整数; [1]:两位中的高位数量级为10的n次方
		var parseDistance = function(numAbsLargest)
		{
			var sValue = "" + numAbsLargest;
			var sFirstDigit = sValue.charAt(0);
			var sSecondDigit = "";
			var iDotTdx = sValue.indexOf(".");
			var iPower = 0;
			if(sFirstDigit == "0")
			{
				for(var i = 1; i < sValue.length; i++)
				{
					var sDigit = sValue.charAt(i);
					if(sDigit != "0" && sDigit != ".")
					{
						sFirstDigit = sDigit;
						iPower = -i;
						if(i + 1 < sValue.length)
						{
							sSecondDigit = sValue.charAt(i + 1);
						}
						else
						{
							sSecondDigit = "0";
						}
						break;
					}
				}
			}
			else if(iDotTdx < 0)//整数
			{
				iPower = sValue.length - 2;
				if(sValue.length == 1)
				{
					sSecondDigit = "0";
				}
				else
				{
					sSecondDigit = sValue.charAt(1);
				}
			}
			else//不以0开头的,即大于1的小数
			{
				iPower = iDotTdx - 2;
				if(iDotTdx == 1)
				{
					sSecondDigit = sValue.charAt(2);
				}
				else
				{
					sSecondDigit = sValue.charAt(1);
				}
			}
			var iFirst2Digit = parseInt(sFirstDigit + sSecondDigit);
			if(numAbsLargest > 1e+20)
			{
				//十进制整数达到22位，会表示成科学记数法。以上字符串处理误判之后，会使后续的分段循环次数变得极大从而死循环。此处不考虑效果只把power变大。
				iPower = parseInt(Math.log(numAbsLargest) / Math.LN10);
			}
			return [iFirst2Digit, iPower];
		}
	}
	NumberRulerHelper.SECTION_WITH_CEILING_REJECT = 0;//不携带最大分段线：值[50,100)可能划分出0、50二条线。
	NumberRulerHelper.SECTION_WITH_CEILING_AUTO = 1;//自动判断是否携带最大分段线：值51可能划分出0、50；值99可能划分出0、50、100。
	NumberRulerHelper.SECTION_WITH_CEILING_ALWAYS = 2;//总是携带最大分段线：值[50,100)可能划分出0、50、100三条线。
})();