//qing-analysis
//Copyright (c) 2015 金蝶软件(中国)有限公司
//
//第三方依赖：
//无 
//
//依赖：
//无

(function()
{
	if(typeof(com) == "undefined") com = {};
	if(typeof(com.kingdee) == "undefined") com.kingdee = {};
	if(typeof(com.kingdee.bos) == "undefined") com.kingdee.bos = {};
	if(typeof(com.kingdee.bos.qing) == "undefined") com.kingdee.bos.qing = {};
	if(typeof(com.kingdee.bos.qing.common) == "undefined") com.kingdee.bos.qing.common = {};
	
	var NS = com.kingdee.bos.qing.common;
	
	NS.MLS = new MLS();
	NS.Util = new Util();
	NS.BrowserUtil = new BrowserUtil();
	NS.FullScreenHelper = new FullScreenHelper();
	NS.DomUtil = new DomUtil();
	NS.Base64Util = new Base64Util();
	NS.Base32Util = new Base32Util();
	NS.ColorUtil = new ColorUtil();
	NS.CssUtil = new CssUtil();

	NS.TextMeasurer = TextMeasurer;
	NS.Graphics = Graphics;
	NS.EventListenerList = EventListenerList;
	NS.NumberFormater = NumberFormater;
	NS.DateFormater = DateFormater;
	NS.PercentageFaker = PercentageFaker;
	NS.RelativePeriodModel = RelativePeriodModel;
	NS.CompositeCtrl = CompositeCtrl;
	NS.BlocksToTable = BlocksToTable;
	
	function MLS()
	{
		var _oAccessor;
		
		this.hookAccessor = function(oPackageAccessor)
		{
			_oAccessor = oPackageAccessor;
		}
		
		this.get = function(sKey, sDefault)
		{
			return (_oAccessor ? _oAccessor.get(sKey, sDefault) : sDefault);
		}
	}
	
	function Util()
	{
		/**
		 * 从URL的?p1=v1&p2=v2...中提取出参数值
		 * @param sAll 整个url串或从问号开始的参数部分
		 * @param sKey 参数名,如上例中的p1、p2
		 * @return 参数值，如上例中的v1、v2
		 */
		this.decodeParamFromUrl = function(sAll, sKey)
		{
			var sSearch = sKey + "=";
			var iBegin = -1;
			while(true)
			{
				iBegin = sAll.indexOf(sSearch, iBegin + 1);
				if(iBegin <= 0)
				{
					break;
				}
				else
				{
					var sBefore = sAll.charAt(iBegin - 1);
					if(sBefore == "&" || sBefore == "?")
					{
						break;
					}
				}
			}
			if(iBegin != -1) 
			{
				iBegin += sSearch.length;
				var iEnd = sAll.indexOf("&", iBegin);
				iEnd = (iEnd == -1 ? sAll.length : iEnd);
				return window.decodeURIComponent(sAll.substring(iBegin, iEnd));
			}
			return null;
		}
		
		this.appendParamToUrl = function(sUrl, sParamKey, sParamValue)
		{
			sUrl += (sUrl.indexOf("?") < 0 ? "?" : "&");
			sUrl += sParamKey;
			sUrl += "=";
			sUrl += window.encodeURIComponent(sParamValue);
			return sUrl;
		}
		
     	// 写cookie
     	this.setCookie = function(sName, sValue, iExdays) 
     	{
      		var sDate = new Date();
        	sDate.setTime(sDate.getTime() + (iExdays*24*60*60*1000));
        	var expires = "expires="+sDate.toUTCString();
        	document.cookie = sName + "=" + sValue + "; " + expires +";path=/";
      	}
      	
      	// 读cookie
     	this.getCookie = function(sName) 
     	{
        	var name = sName + "=";
        	var ca = document.cookie.split(';');
        	for(var i=0; i<ca.length; i++) 
        	{
           		var c = ca[i];
           		while (c.charAt(0)==' ') c = c.substring(1);
           		if (c.indexOf(name) == 0) 
           		return c.substring(name.length,c.length);
     		}
        	return "";
 		}
 		
 		/** @deprecated 应该用浏览器无差异的API或写法 */
		this.isIEBrowser = function()
		{
			var useragent = navigator.userAgent.toLowerCase();
			if (useragent.indexOf("msie") != -1) 
			{
				return true;
			}
			return false;
		}
		
		this.createUUID = function() 
		{
			//xxxxxxxx-xxxx-Mxxx-Nxxx-xxxxxxxxxxxx
			//数字 M的四位表示 UUID 版本，当前规范有5个版本，M可选值为1, 2, 3, 4, 5 ；
			//数字 N的一至四个最高有效位表示 UUID 变体( variant )，有固定的两位10xx因此只可能取值8, 9, a, b
			var s = [];
			var hexDigits = "0123456789abcdef";
			for (var i = 0; i < 36; i++) 
			{
				s[i] = hexDigits.substr(Math.floor(Math.random() * 16), 1);
			}
			
			s[14] = "4";//版本：4
			s[19] = hexDigits.substr((Math.floor(Math.random() * 4) + 8), 1); //8、9、a、b的随机数
			s[8] = s[13] = s[18] = s[23] = "-";
			
			var uuid = s.join("");
			return uuid;
		}
		
		/** 可见的unicode字符编码范围：0x09 0x0a 0x0d 0x20~0xd7ff 0xe000~0xfffd 0x010000~0x10ffff */
		this.cleanInvalidChar = function(sText, funReturn)
		{
			var bFound = false;
			for(var i = sText.length - 1; i >= 0; i--)
			{
				var iCode = sText.charCodeAt(i);
				if((iCode > 0xd7ff && iCode < 0xe000) || (iCode < 32 && iCode != 9 && iCode != 10 && iCode != 13))
				{
					sText = sText.substring(0, i) + sText.substring(i + 1);
					bFound = true;
				}
			}
			bFound && funReturn(sText);
			return bFound;
		}
		
		this.formatDate = function(sFormat, oDate)
		{
			var oFormater = new DateFormater();
			oFormater.setFormatString(sFormat ? sFormat : "yyyy-MM-dd HH:mm:ss");
			return oFormater.format(oDate ? oDate : new Date());
		}
		
		var REG_VALID_1 = /^[a-zA-Z][a-zA-Z0-9_]*$/;
		/** 可作为变量的命名：以字母开头、只带字母数字下划线。 */
		this.checkVariableNaming = function(sValue)
		{
			return REG_VALID_1.test(sValue);
		}
	}
	
	function BrowserUtil()
	{
		var _this = this;
		var _sName;
		var _sVersion;
		
		/** 用于显示的浏览器名称 */
		this.getBrowserName = function()
		{
			!_sName && parseUserAgent();
			return _sName;
		}
		
		/** 用于显示的浏览器版本 */
		this.getBrowserVersion = function()
		{
			!_sVersion && parseUserAgent();
			return _sVersion;
		}
		
		var parseUserAgent = function()
		{
			var sUserAgent = window.navigator.userAgent.toLowerCase();
			//由于有包含关系，注意以下判断有顺序！
			if(sUserAgent.indexOf("edge") >= 0)//带chrome、safari字样
			{
				_sName = "Edge";
				_sVersion = sUserAgent.match(/edge\/([\d.]+)/)[1];
			}
			else if(sUserAgent.indexOf("chrome") >= 0)//带safari字样
			{
				_sName = "Chrome";
				_sVersion = sUserAgent.match(/chrome\/([\d.]+)/)[1];
			}
			else if(sUserAgent.indexOf("safari") >= 0)
			{
				_sName = "Safari";
				_sVersion = sUserAgent.match(/version\/([\d.]+)/)[1];
			}
			else if(sUserAgent.indexOf("firefox") >= 0)
			{
				_sName = "FireFox";
				_sVersion = sUserAgent.match(/firefox\/([\d.]+)/)[1];
			}
			else if(sUserAgent.indexOf("msie") >= 0)
			{
				_sName = "IE";
				_sVersion = sUserAgent.match(/msie ([\d.]+)/)[1];
			}
			else if(sUserAgent.indexOf("trident") >= 0)
			{
				_sName = "IE";
				_sVersion = "11";
			}
			else if(sUserAgent.indexOf("opera") >= 0)
			{
				_sName = "Opera";
				_sVersion = sUserAgent.match(/opera.([\d.]+)/)[1];
			}
			else
			{
				_sName = "Other unknown";
				_sVersion = "?";
			}
		}
	}
	
	function FullScreenHelper()
	{
		var _this = this;
		var _oEventListenerList;
		var _funRequestListener;
		var _arrTarget = [];
		
		var getEventListenerList = function()
		{
			if(!_oEventListenerList)
			{
				_oEventListenerList = new EventListenerList();
				
				if(document.onwebkitfullscreenchange !== undefined)
				{
					//webkitCurrentFullScreenElement for Safari(EAS GUI)
					document.onwebkitfullscreenchange = function(evt){doChanged(document.webkitFullscreenElement || document.webkitCurrentFullScreenElement);}
				}
				else if(document.onmsfullscreenchange !== undefined)
				{
					document.onmsfullscreenchange = function(evt){doChanged(document.msFullscreenElement);}
				}
				else if(document.onmozfullscreenchange !== undefined)
				{
					//mozFullscreenElement <= FF65 & fullscreenElement >= FF64
					document.onmozfullscreenchange = function(evt){doChanged(document.mozFullscreenElement || document.fullscreenElement);}
				}
				else
				{
					document.addEventListener("fullscreenchange", function(evt){doChanged(document.fullscreenElement);});
				}
			}
			return _oEventListenerList;
		}
		
		var doChanged = function(htmlCurrentFullTarget)
		{
			//A，没有当前全屏对象的情景：A1、调用exit()使最后一层退出；A2、全屏了任意层之后按了[Esc]或浏览器的叉完全退出。
			//B，有当前全屏对象只有一种情景：调用request()使第一层全屏，此时该对象总是为body。
 			if(!htmlCurrentFullTarget)
 			{
 				_arrTarget = [];//for A2
 			}
			fireChangedEvent();
		}
		
		/** funListener likes: func(htmlCurrentFullTarget) */
 		this.addChangedListener = function(funListener)
 		{
 			getEventListenerList().addListener(funListener);
 		}
 		this.removeChangedListener = function(funListener)
 		{
 			getEventListenerList().removeListener(funListener);
 		}
 		var fireChangedEvent = function()
 		{
 			var htmlCurrentFullTarget = (_arrTarget.length > 0 ? _arrTarget[_arrTarget.length - 1] : null);
 			_oEventListenerList.fireEvent(
 				function(funListener)
 				{
 					funListener(htmlCurrentFullTarget);
 				});
 		}
		
		/** 将指定的dom树上的对象全屏，除了全画面（body），局部的全屏要自己再另外实现。 */
		this.request = function(htmlTarget)
 		{
 			if(!isSupported())
 			{
 				window.console && window.console.error("Unsupport full-screen.");
 				return;
 			}
 			fireRequestEvent();
 			_arrTarget.push(htmlTarget);
 			if(_arrTarget.length > 1)
 			{
 				fireChangedEvent();
 				return;
 			}
 			//对于任意多层的全屏，只在第一层，让body真实地全屏
 			htmlTarget = document.body;
 			if(htmlTarget.requestFullScreen)
 			{
 				htmlTarget.requestFullScreen();
 			}
 			else if(htmlTarget.webkitRequestFullScreen)
 			{
 				htmlTarget.webkitRequestFullScreen();
 			}
 			else if(htmlTarget.msRequestFullscreen)
 			{
 				htmlTarget.msRequestFullscreen();
 			}
 			else if(htmlTarget.mozRequestFullScreen)
 			{
 				htmlTarget.mozRequestFullScreen();
 			}
 		}
 		
 		var isSupported = function()
 		{
 			return (document.body.requestFullScreen 
	 			|| document.body.webkitRequestFullScreen
	 			|| document.body.msRequestFullscreen
	 			|| document.body.mozRequestFullScreen ? true : false);
 		}
 		
 		/** 退出全屏，request()的反操作，同理局部的退出要自己再另外实现。 退到头时返回false，还有得退则返回true。*/
 		this.exit = function()
 		{
 			if(!isSupported())
 			{
 				return;
 			}
 			
 			_arrTarget.pop();
 			if(_arrTarget.length > 0)
 			{
 				fireChangedEvent();
 				return true;
 			}
 			//只在最后弹完栈，让body真实地退出全屏
 			_this.exitAll();
 			return false; 
 		}
 		
 		/** GUI集成环境提供的退出全屏按钮点击时要主动向内通知 */
 		this.exitAll = function()
 		{
 			if(document.exitFullScreen)
 			{
 				document.exitFullScreen();
 			}
 			else if(document.webkitCancelFullScreen)
 			{
 				document.webkitCancelFullScreen();
 			}
 			else if(document.msExitFullscreen)
 			{
 				document.msExitFullscreen();
 			}
 			else if(document.mozCancelFullScreen)
 			{
 				document.mozCancelFullScreen();
 			}
 		}
 		
 		/** 用于向外通知GUI的集成环境，把GUI控件全屏。而反方向的，GUI点了退出全屏，应该主动调用exitAll()。 */
 		this.setRequestListener = function(funListener)
 		{
 			_funRequestListener = funListener;
 		}
 		var fireRequestEvent = function()
 		{
 			_funRequestListener && _funRequestListener();
 		}
	}
	
	function DomUtil()
	{
		/** 获取鼠标在事件派发对象上位置 */
		this.getCurrentTargetPosition = function(evt)
		{
			var originalEvt = evt.originalEvent;
			if(evt.offsetX == undefined && evt.layerX == undefined && originalEvt != undefined)
			{
				return [(originalEvt.offsetX == undefined ? originalEvt.layerX : originalEvt.offsetX),
					    (originalEvt.offsetY == undefined ? originalEvt.layerY : originalEvt.offsetY)];
			}
			else
			{
				return [(evt.offsetX == undefined ? evt.layerX : evt.offsetX),
				  		(evt.offsetY == undefined ? evt.layerY : evt.offsetY)];
			}	
		}
		
		/** 将相对于htmlDescendent的坐标arrPoint，转换成相对于它的祖先htmlAncestor的坐标，返回[x,y] */
		this.upwardCoordinate = function(htmlDescendent, arrPointAtDescendent, htmlAncestor)
		{
			var iXDescendentAtAncestor = htmlAncestor.scrollLeft - htmlAncestor.clientLeft;
			var iYDescendentAtAncestor = htmlAncestor.scrollTop - htmlAncestor.clientTop;
			var htmlElement = htmlDescendent;
			while(htmlElement != htmlAncestor)
			{
				if(htmlElement == document.body)
				{
					throw new Error("Not immediate family.");
				}
				var htmlParent = htmlElement.parentNode;
				iXDescendentAtAncestor += htmlParent.clientLeft - htmlParent.scrollLeft + htmlElement.offsetLeft;
				iYDescendentAtAncestor += htmlParent.clientTop - htmlParent.scrollTop + htmlElement.offsetTop;
				htmlElement = htmlParent;
			}
			var iXPointAtAncestor = iXDescendentAtAncestor + arrPointAtDescendent[0];
			var iYPointAtAncestor = iYDescendentAtAncestor + arrPointAtDescendent[1];
			return [iXPointAtAncestor, iYPointAtAncestor];
		}
		
		this.upwardSearch = function(jqTarget, jqSearchUntilParent, funCondition)
		{
			while(jqTarget.length > 0 && jqTarget[0] != jqSearchUntilParent[0])
			{
				if(funCondition(jqTarget))
				{
					return jqTarget;
				}
				jqTarget = jqTarget.parent();
			}
			return null;
		}
		
		this.upwardSearchHasClass = function(jqTarget, jqSearchUntilParent, sClassName)
		{
			return this.upwardSearch(jqTarget, jqSearchUntilParent, 
				function(jqTarget)
				{
					return jqTarget.hasClass(sClassName);
				});
		}
		
		this.upwardSearchHasData = function(jqTarget, jqSearchUntilParent, sDataKey)
		{
			return this.upwardSearch(jqTarget, jqSearchUntilParent, 
				function(jqTarget)
				{
					return jqTarget.data(sDataKey);
				});
		}
		
		this.isInDomTree = function(htmlTarget)
		{
			var htmlElement = htmlTarget;
			while(htmlElement != document.body)
			{
				htmlElement = htmlElement.parentNode;
				if(!htmlElement || htmlElement === htmlTarget)
				{
					return false;
				}
			}
			return true;
		}
		
		/** htmlTarget是否是htmlAncestor的后代 */
		this.isDescendent = function(htmlTarget, htmlAncestor)
		{
			while(htmlTarget && htmlTarget != document.body)
			{
				if(htmlTarget == htmlAncestor)
				{
					return true;
				}
				htmlTarget = htmlTarget.parentNode;
			}
			return false;
		}
		
		this.layoutCtrl = function(jqCtrl, iX, iY, iW, iH)
		{
			var oCss = {};
			oCss["position"] = "absolute";
			oCss["left"] = iX;
			oCss["top"] = iY;
			oCss["width"] = iW;
			oCss["height"] = iH;
			jqCtrl.css(oCss);
		}
		
		/** e.g. func(jqCtrl, 0, 0, null, 0, null, 20) 左右顶着，上面顶着，高度20。 可以用空串擦除。 */
		this.layoutCtrlWithLRTB = function(jqCtrl, iLeft, iRight, iWidth, iTop, iBottom, iHeight)
		{
			var oCss = {};
			oCss["position"] = "absolute";
			(iLeft || iLeft === 0 || iLeft === "") && (oCss["left"] = iLeft);
			(iRight || iRight === 0 || iRight === "") && (oCss["right"] = iRight);
			(iWidth || iWidth === 0 || iWidth === "") && (oCss["width"] = iWidth);
			(iTop || iTop === 0 || iTop === "") && (oCss["top"] = iTop);
			(iBottom || iBottom === 0 || iBottom === "") && (oCss["bottom"] = iBottom);
			(iHeight || iHeight === 0 || iHeight === "") && (oCss["height"] = iHeight);
			jqCtrl.css(oCss);
		}
		
		/** jqCtrl宽度为iWidth(px)，在水平方向居中 */
		this.layoutCtrlCenterAlign = function(jqCtrl, iWidth)
		{
			var oCss = {};
			oCss["position"] = "absolute";
			oCss["left"] = "50%";
			oCss["margin-left"] = -(iWidth >> 1) + "px";
			oCss["width"] = iWidth + "px";
			jqCtrl.css(oCss);
		}
		
		/** jqCtrl高度为iHeight(px)，在垂直方向居中 */
		this.layoutCtrlMiddleAlign = function(jqCtrl, iHeight)
		{
			var oCss = {};
			oCss["position"] = "absolute";
			oCss["top"] = "50%";
			oCss["margin-top"] = -(iHeight >> 1) + "px";
			oCss["height"] = iHeight + "px";
			oCss["line-height"] = iHeight + "px";
			jqCtrl.css(oCss);
		}
		
		/** 使单行文字显示不下时出点点点 */
		this.makeTextOmissible = function(jqTarget)
		{
			var oCss = {};
			oCss["overflow"] = "hidden";
			oCss["white-space"] = "nowrap";
			oCss["text-overflow"] = "ellipsis";
			jqTarget.css(oCss);
		}
		
		/** 使目标Dom节点不能拖拽选中文字 */
		this.makeSelectable = function(jqTarget, bSelectable)
		{
			var sValue = (bSelectable ? "" : "none");
			jqTarget.css({
				"user-select": sValue,
			    "-webkit-user-select": sValue,
				"-moz-user-select": sValue,
			    "-ms-user-select": sValue,
			    "-o-user-select": sValue
			});
			if(bSelectable)
			{
				jqTarget.off("selectstart", doSelectStart);
			}
			else
			{
				jqTarget.on("selectstart", doSelectStart);
			}
		}
		var doSelectStart = function(evt)
		{
			return false;
		}
	}
	
	function TextMeasurer()
	{
		var _htmlCanvas;
		var _oCtx;
		
		this.setFontSize = function(iFontSize, sFontName)
		{
			getCtx().font = "bold " + iFontSize + "px " + (sFontName ? sFontName : "sans-serif"); 
		}
		
		this.measureWidth = function(sText)
		{
			var numWidth = getCtx().measureText(sText).width;
			return parseInt(numWidth + 1);
		}
		
		this.destroy = function()
		{
			//没有添加进dom树就不必移除了
		}
		
		var getCtx = function()
		{
			if(!_oCtx)
			{
				_htmlCanvas = document.createElement("canvas");
				_htmlCanvas.width = 1;
				_htmlCanvas.height = 1;
				_oCtx = _htmlCanvas.getContext("2d");
			}
			return _oCtx;
		}
	}
	
	/** 封装Canvas的Context，支持坐标转换成绘制视角，且文字绘制不因转换而颠倒 */
	function Graphics(oCtx)
	{
		var _oCtx = oCtx;
		//绘制坐标转换是：
		//x' = ax + cy + e
		//y' = bx + dy + f
		//鼠标位置判断是反向转换，是以上二元一次方向的解：
		//x = a'x' + c'y' + e'
		//y = b'x' + d'y' + f'
		//其中：
		//a'=d/(ad-bc);  c'=-c/(ad-bc);  e'=(cf-de)/(ad-bc);
		//b'=-b/(ad-bc);  d'=a/(ad-bc);  f'=-(af-be)/(ad-bc);
		var _arrMatrix = [1, 0, 0, 1, 0, 0];
		var _arrInverseMatrix = [1, 0, 0, 1, 0, 0];
		
		/** 可以取出context给属性赋值. e.g. font, fillStyle, ... */
		this.getContext = function()
		{
			return _oCtx;
		}
		
		this.getWidth = function()
		{
			var sStyleWidth = _oCtx.canvas.style && _oCtx.canvas.style.width;
			return sStyleWidth ? parseInt(sStyleWidth) : _oCtx.canvas.width;
		}
		
		this.getHeight = function()
		{
			var sStyleHeight = _oCtx.canvas.style && _oCtx.canvas.style.height;
			return sStyleHeight ? parseInt(sStyleHeight) : _oCtx.canvas.height;
		}
		
		this.stroke = function(){_oCtx.stroke()};
		this.beginPath = function(){_oCtx.beginPath();};
		this.closePath = function(){_oCtx.closePath();};
		this.fill = function(){_oCtx.fill();};
		
		/** 设置转换矩阵，使后面坐标相关的接口可以直接用绘制视角的逻辑点 */
		this.setTransformMatrix = function(numXScale, numXLean, numYLean, numYScale, numXMove, numYMove)
		{
			numXMove = (Math.floor(numXMove) == numXMove ? numXMove + 0.5 : numXMove); 
			numYMove = (Math.floor(numYMove) == numYMove ? numYMove + 0.5 : numYMove);
			_arrMatrix = [numXScale, numXLean, numYLean, numYScale, numXMove, numYMove];
			var numDenominator = numXScale * numYScale - numXLean * numYLean;
			_arrInverseMatrix = 
			[
				numYScale / numDenominator,
				-numXLean / numDenominator,
				-numYLean / numDenominator,
				numXScale / numDenominator,
				(numYLean * numYMove - numYScale * numXMove) / numDenominator,
				-(numXScale * numYMove - numXLean * numXMove) / numDenominator 
			];
		}
		
		/** 逻辑点转成API原坐标系的点 */
		this.transformXY = function(iX, iY)
		{
			return transXY(iX, iY);
		}
		
		/** 将鼠标事件坐标的物理点转回绘制视角的逻辑点 */
		this.retransformMouseXY = function(iApiX, iApiY)
		{
			return inverseTransXY(iApiX, iApiY);
		}
		
		var transXY = function(iX, iY)
		{
			return [
				_arrMatrix[0] * iX + _arrMatrix[2] * iY + _arrMatrix[4],
				_arrMatrix[1] * iX + _arrMatrix[3] * iY + _arrMatrix[5]];
		}
		
		var inverseTransXY = function(iX, iY)
		{
			return [
				_arrInverseMatrix[0] * iX + _arrInverseMatrix[2] * iY + _arrInverseMatrix[4],
				_arrInverseMatrix[1] * iX + _arrInverseMatrix[3] * iY + _arrInverseMatrix[5]];
		}

		var transAngle = function(numAngle)
		{
			var numXScale = _arrMatrix[0];
			var numYLean = _arrMatrix[2];
			var numAngleDelta = -Math.asin(numYLean);//-pi/2 ~ pi/2
			numAngleDelta = (numXScale < 0 ? Math.PI - numAngleDelta : numAngleDelta);
			return numAngle + numAngleDelta;
		}		
		
		/** funAdjust like: func(arrApiXY),funAdjust若返回false则不绘制 */
		this.fillText = function(sText, iX, iY, funAdjust)
		{
			var bDraw = true;
			var arrXY = transXY(iX, iY);
			funAdjust && (bDraw = funAdjust(arrXY));
			bDraw !== false && _oCtx.fillText(sText, arrXY[0], arrXY[1]);
		}
		
		this.moveTo = function(iX, iY)
		{
			var arrXY = transXY(iX, iY);
			_oCtx.moveTo(arrXY[0], arrXY[1]);
		}
		
		this.lineTo = function(iX, iY)
		{
			var arrXY = transXY(iX, iY);
			_oCtx.lineTo(arrXY[0], arrXY[1]);
		}
		
		this.drawDashedLine = function(iStartX, iStartY, iEndX, iEndY, numDashLen)
		{
			var iDeltaX = iEndX - iStartX;
			var iDeltaY = iEndY - iStartY;
			var numLineLength = Math.sqrt(iDeltaX * iDeltaX + iDeltaY * iDeltaY);
            var iDashCount = ~~(numLineLength / numDashLen);
            _oCtx.beginPath();
            for (var i = 0; i < iDashCount; i++)
            {
            	var iX = iStartX + iDeltaX * i / iDashCount;
            	var iY = iStartY + iDeltaY * i / iDashCount;
            	var arrXY = transXY(iX, iY);
            	(i & 1) ? _oCtx.lineTo(arrXY[0], arrXY[1]) : _oCtx.moveTo(arrXY[0], arrXY[1]);
            }
            _oCtx.stroke();
		}
		
		this.arc = function(iX, iY, iR, numAngleStart, numAngleEnd, bAnticlockwise)
		{
			var arrXY = transXY(iX, iY);
			var numAngle1 = transAngle(numAngleStart);
			var numAngle2 = transAngle(numAngleEnd);
			_oCtx.arc(arrXY[0], arrXY[1], iR, numAngle1, numAngle2, bAnticlockwise);
		}
		
		this.bezierCurveTo = function(iCaX, iCaY, iCbX, iCbY, iX, iY)
		{
			var arrCaXY = transXY(iCaX, iCaY);
			var arrCbXY = transXY(iCbX, iCbY);
			var arrXY = transXY(iX, iY);
			_oCtx.bezierCurveTo(arrCaXY[0], arrCaXY[1], arrCbXY[0], arrCbXY[1], arrXY[0], arrXY[1]);
		}
		
		//只有在旋转90度整数倍时可以用矩形相关的接口
		this.fillRect = function(iX1, iY1, iX2, iY2)
		{
			var arrXY1 = transXY(iX1, iY1);
			var arrXY2 = transXY(iX2, iY2);
			var iX = Math.min(arrXY1[0], arrXY2[0]);
			var iY = Math.min(arrXY1[1], arrXY2[1]);
			var iWidth = Math.max(arrXY1[0], arrXY2[0]) - iX;
			var iHeight = Math.max(arrXY1[1], arrXY2[1]) - iY;
			_oCtx.fillRect(iX, iY, iWidth, iHeight);
		}

		this.strokeRect = function(iX1, iY1, iX2, iY2)
		{
			var arrXY1 = transXY(iX1, iY1);
			var arrXY2 = transXY(iX2, iY2);
			var iX = Math.min(arrXY1[0], arrXY2[0]);
			var iY = Math.min(arrXY1[1], arrXY2[1]);
			var iWidth = Math.max(arrXY1[0], arrXY2[0]) - iX;
			var iHeight = Math.max(arrXY1[1], arrXY2[1]) - iY;
			_oCtx.strokeRect(iX, iY, iWidth, iHeight);
		}
		
		this.clearAll = function()
		{
			_oCtx.clearRect(0, 0, _oCtx.canvas.width, _oCtx.canvas.height);
		}
	}
	
	function EventListenerList()
	{
		var _arrListener = [];
		
		this.addListener = function(funListener)
		{
			var bFound = false;
			for(var i = _arrListener.length - 1; i >= 0; i--)
			{
				if(funListener == _arrListener[i])
				{
					bFound = true;
					break;
				}
			}
			if(!bFound)
			{   
				_arrListener.push(funListener);
			}
		}
		
		this.removeListener = function(funListener)
		{
			for(var i = _arrListener.length - 1; i >= 0; i--)
			{
				if(funListener == _arrListener[i])
				{
					_arrListener.splice(i, 1);
					break;
				}
			}
		}
		
		this.removeAllListener = function()
		{
			_arrListener.length = 0;
		}
		
		this.fireEvent = function(funCallback)
		{
			for(var i = 0; i < _arrListener.length; i++)
			{
				var funListener = _arrListener[i];
				funCallback(funListener);
			}
		}
	}
	
	/** 格式化器抽象基类 */
	function AbstractFormater()
	{
		this.setFormatString = function(sFormatString)
		{
			throw new Error("Override me.");
		}
		
		this.format = function(oValue)
		{
			throw new Error("Override me.");
		}
		
		var addZeroBefore = function(sTarget, iZeroCount)
		{
			var sZeros = "";
			for(var i = 0; i < iZeroCount; i++)
			{
				sZeros += "0";
			}
			return sZeros + sTarget;
		}
		
		var addZeroAfter = function(sTarget, iZeroCount)
		{
			var sZeros = "";
			for(var i = 0; i < iZeroCount; i++)
			{
				sZeros += "0";
			}
			return  sTarget + sZeros;
		}
		
		this.protectedMethod = 
		{
			"addZeroBefore": addZeroBefore,
			"addZeroAfter": addZeroAfter
		}
	}
	
	/** 数字格式化器 */
	function NumberFormater()
	{
		AbstractFormater.call(this);
		var _this = this;
		var _super = this.protectedMethod;
		
		var _arrConditionFuns;//条件判断函数
		var _arrConditionFormats;//(可能的三段条件)格式化串或格式化器
		var _arrIgnoreNegativeSign;//与条件段对应的是否忽略负号
		
		this.setFormatString = function(sFormatString)
		{
			seperateCondition(sFormatString);			
		}
		
		this.format = function(oValue, sRoundingMode)
		{
			var oFormater;
			for(var i = 0; i < _arrConditionFormats.length; i++)
			{
				if(_arrConditionFuns && _arrConditionFuns[i] && !_arrConditionFuns[i](oValue))
				{
					continue;
				}
				var oFormatStringOrFormater = _arrConditionFormats[i];
				if(oFormatStringOrFormater == null)
				{
					return "" + oValue;
				}
				else if(typeof(oFormatStringOrFormater) == "string")
				{
					oFormater = _this.parseString(oFormatStringOrFormater);			
					oFormater.setIgnoreNegativeSign(_arrIgnoreNegativeSign[i]);
					_arrConditionFormats[i] = oFormater;
				}
				else
				{
					oFormater = oFormatStringOrFormater;
				}
				break;
			}
			oFormater.setRoundingMode(sRoundingMode ? sRoundingMode : NumberFormater.RoundingMode.HALF_UP);
			return oFormater.format(oValue);
		}
		
		var seperateCondition = function(sFormatString)
		{
			if(sFormatString)
			{
				var arrStrs = sFormatString.split(";");
				if(arrStrs.length >= 3)
				{
					_arrConditionFuns = [];
					_arrConditionFuns[0] = function(nValue){return parseFloat(nValue) == 0;};
					_arrConditionFuns[1] = function(nValue){return parseFloat(nValue) < 0;};
					_arrConditionFuns[2] = null;//function(nValue){return true;};
					//按检查的顺序分123，而不是格式化串的书写顺序 
					_arrConditionFormats = [arrStrs[2], arrStrs[1], arrStrs[0]]
					_arrIgnoreNegativeSign = [false, true, false];
				}
				else if(arrStrs.length == 2)
				{
					_arrConditionFuns = [];
					_arrConditionFuns[0] = function(nValue){return parseFloat(nValue) < 0;};
					_arrConditionFuns[1] = null;
					_arrConditionFormats = [arrStrs[1], arrStrs[0]];
					_arrIgnoreNegativeSign = [true, false];
				}
				else
				{
					_arrConditionFuns = null;
					_arrConditionFormats = [sFormatString];
					_arrIgnoreNegativeSign = [false];
				}
			}
			else
			{
				_arrConditionFuns = null;
				_arrConditionFormats = [null];
				return;
			}
		}
		
		this.parseString = function(sFormatString)
		{
			//规则一：0.00 以夹在0中间的为小数点
			//规则二：#,# 以夹在#中间的为千分位符
			//规则三：{4} 花括号中的数字是10的n次幂
			var oFormater = new CoreFormater();
			var iPowerIdx = sFormatString.search(/\{-?\d+\}/);
			if(iPowerIdx >= 0)
			{
				var iPowerEndIdx = sFormatString.indexOf("}", iPowerIdx);
				var iUnitPower = parseInt(sFormatString.substring(iPowerIdx + 1, iPowerEndIdx));
				sFormatString = sFormatString.substring(0, iPowerIdx) + sFormatString.substring(iPowerEndIdx + 1);
				oFormater.setUnitPower(iUnitPower);
			}
			
			var iPureStart = -1;
			var iPureEnd = -1;
			var iGroupingSymbolIdx = -1;
			var iSharpIdx = sFormatString.indexOf('#');
			if(iSharpIdx >= 0)
			{
				var iLastSharpIdx = sFormatString.lastIndexOf('#');
				var sGroupingSymbol = null;
				for(var i = iSharpIdx + 1; i < iLastSharpIdx; i++)
				{
					var sChr = sFormatString.charAt(i);
					if(sGroupingSymbol != null)
					{
						if(sChr != '#')
						{
							sGroupingSymbol = null;
							iGroupingSymbolIdx = -1;
							break;
						}
					}
					if(sChr != '#')
					{
						sGroupingSymbol = sChr;
						iGroupingSymbolIdx = i;
					}
				}
				if(sGroupingSymbol != null)
				{
					oFormater.setGroupingSymbol(sGroupingSymbol);
				}
				iPureStart = iSharpIdx;
				iPureEnd = iLastSharpIdx + 1;
			}
			var iDecimalSymbolIdx = -1;
			var iZeroIdx = sFormatString.indexOf('0');
			if(iZeroIdx >= 0)
			{
				var iLastZeroIdx = sFormatString.lastIndexOf('0');
				var sDecimalSymbol = null;
				for(var i = iZeroIdx + 1; i < iLastZeroIdx; i++)
				{
					var sChr = sFormatString.charAt(i);
					if(sDecimalSymbol != null)
					{
						if(sChr != '0')
						{
							sDecimalSymbol = null;
							iDecimalSymbolIdx = -1;
							break;
						}
					}
					if(sChr != '0')
					{
						sDecimalSymbol = sChr;
						iDecimalSymbolIdx = i;
					}
				}
				if(sDecimalSymbol != null)
				{
					oFormater.setDecimalSymbol(sDecimalSymbol);
					oFormater.setDecimal(iLastZeroIdx - iDecimalSymbolIdx);
				}
				iPureStart = (iPureStart < 0 ? iZeroIdx : Math.min(iPureStart, iZeroIdx));
				iPureEnd = Math.max(iPureEnd, iLastZeroIdx + 1);
			}
			
			if(iPureStart >= 0)
			{
				oFormater.setPrefix(sFormatString.substring(0, iPureStart));
			}
			else
			{
				oFormater.setPrefix(sFormatString);
				oFormater.setNoNumber(true);
			}
			
			if(iPureEnd >= 0)
			{
				oFormater.setSuffix(sFormatString.substring(iPureEnd));
			}
			
			if(iGroupingSymbolIdx >= 0)
			{
				if(iDecimalSymbolIdx >= 0)
				{
					oFormater.setGrouping(iDecimalSymbolIdx - iGroupingSymbolIdx - 1);
				}
				else
				{
					oFormater.setGrouping(iPureEnd - iGroupingSymbolIdx - 1);
				}
			}
			return oFormater;
		}
	
		function CoreFormater()
		{
			var _bNoNumber = false;//因格式化串没有描述数字位(0或#)而不对数字进行处理
			var _iDecimal = 0;
			var _iGrouping = 0;
			var _iUnitPower = 0;
			var _sDecimalSymbol = ".";
			var _sGroupingSymbol = ",";
			var _sPrefix = "";
			var _sSuffix = "";
			var _bIgnoreNegativeSign;//是否忽略负号
			var _sRoundingMode;
			var _bCarryDigitToInteger;//因四舍五入小数向整数进位
			
			this.setNoNumber = function(bNoNumber)
			{
				_bNoNumber = bNoNumber;
			}
			
			this.setIgnoreNegativeSign = function(bIgnoreNegativeSign)
			{
				_bIgnoreNegativeSign = bIgnoreNegativeSign;
			}
			
			this.setRoundingMode = function(sRoundingMode)
			{
				_sRoundingMode = sRoundingMode;
			}
			
			this.setDecimal = function(iDecimal)
			{
				_iDecimal = iDecimal;
			}
			this.getDecimal = function()
			{
				return _iDecimal;
			}
			
			this.setGrouping = function(iGrouping)
			{
				_iGrouping = iGrouping;
			}
			
			this.setUnitPower = function(iUnitPower)
			{
				_iUnitPower = iUnitPower;
			}
			
			this.setDecimalSymbol = function(sDecimalSymbol)
			{
				_sDecimalSymbol = sDecimalSymbol;
			}
			
			this.setGroupingSymbol = function(sGroupingSymbol)
			{
				_sGroupingSymbol = sGroupingSymbol;
			}
			
			this.setPrefix = function(sPrefix)
			{
				_sPrefix = sPrefix;
			}
			
			this.setSuffix = function(sSuffix)
			{
				_sSuffix = sSuffix;
			}
			
			this.format = function(oValue)
			{
				var sNumber;
				if(_bNoNumber)
				{
					sNumber = "";
				}
				else
				{
					var arrIntAndDec = divideIntegerAndDecimal("" + oValue);
					var sDecimal = formatDecimal(arrIntAndDec[0], arrIntAndDec[2]);//由于四舍五入的进位，小数先于整数处理
					var sInteger = formatInteger(arrIntAndDec[0], arrIntAndDec[1]);
					sNumber = sInteger + (sDecimal ? _sDecimalSymbol + sDecimal : "");
				}
				return _sPrefix + sNumber + _sSuffix;
			}
			
			var divideIntegerAndDecimal = function(sValue)
			{
				var sNegativeSign = "";
				if(sValue.charAt(0) == "-")
				{
					sValue = sValue.substring(1);
					sNegativeSign = "-";
				}
				
				sValue = translateScientificNotation(sValue);
				
				var iDotIdx = sValue.indexOf(".");
				if(iDotIdx >= 0)
				{
					sValue = sValue.substring(0, iDotIdx) + sValue.substring(iDotIdx + 1);
				}
				else
				{
					iDotIdx = sValue.length;
				}

				var iDotNewIdx = iDotIdx - _iUnitPower;
				if(iDotNewIdx < 0)
				{
					sValue = _super.addZeroBefore(sValue, 0 - iDotNewIdx);
				}
				else if(iDotNewIdx > sValue.length)
				{
					sValue = _super.addZeroAfter(sValue, iDotNewIdx - sValue.length);
				}
				var sInteger = sValue.substring(0, iDotNewIdx);
				var sDecimal = sValue.substring(iDotNewIdx);
				return [sNegativeSign, sInteger, sDecimal];
			}
			
			var translateScientificNotation = function(sValue)
			{
				var iExpIdx = sValue.indexOf("e-");
				if(iExpIdx > 0 && iExpIdx + 2 < sValue.length)
				{
					var sBase = sValue.substring(0, iExpIdx);
					var sPower = sValue.substring(iExpIdx + 2);
					var iPower = parseInt(sPower);
					var iDotIdx = sBase.indexOf(".");
					if(iDotIdx >= 0)
					{
						sBase = sBase.substring(0, iDotIdx) + sBase.substring(iDotIdx + 1);
					}
					sValue = "0." + _super.addZeroBefore(sBase, (iPower - 1));
				}
				var iExpIdx = sValue.indexOf("e+");
				if(iExpIdx > 0 && iExpIdx + 2 < sValue.length)
				{
					var sBase = sValue.substring(0, iExpIdx);
					var sPower = sValue.substring(iExpIdx + 2);
					var iPower = parseInt(sPower);
					var iDotIdx = sBase.indexOf(".");
					var sBaseInt, sBaseDec;
					if(iDotIdx >= 0)
					{
						sBaseInt = sBase.substring(0, iDotIdx);
						sBaseDec = sBase.substring(iDotIdx + 1);
					}
					else
					{
						sBaseInt = sBase;
						sBaseDec = "";
					}
					if(sBaseDec.length > iPower)
					{
						sBaseDec = sBaseDec.substring(0, iPower) + "." + sBaseDec.substring(iPower);
					}
					else
					{
						sBaseDec = _super.addZeroAfter(sBaseDec, (iPower - sBaseDec.length));
					}
					sValue = sBaseInt + sBaseDec;
				}
				return sValue;
			}
			
			var formatDecimal = function(sNegativeSign, sDigits)
			{
				_bCarryDigitToInteger = false;
				var sResult = sDigits;
				var iAddZero = _iDecimal - sResult.length;
				if(iAddZero > 0)
				{
					sResult = _super.addZeroAfter(sResult, iAddZero);
				}
				else if(iAddZero < 0)
				{
					var iDigit = parseInt(sResult.charAt(_iDecimal));
					var bNegative = (sNegativeSign ? true : false);
					var bCarry = checkRounding(_sRoundingMode, iDigit, bNegative);
					sResult = sResult.substring(0, _iDecimal);
					if(bCarry)
					{
						if(_iDecimal == 0)
						{
							_bCarryDigitToInteger = true;
						}
						else
						{
							var iOriLen = sResult.length;
							var iResult = parseInt(sResult, 10);//防止字符串0开头，必须指定十进制
							iResult += 1;
							sResult = "" + iResult;
							if(sResult.length > iOriLen)
							{
								sResult = sResult.substring(1);
								_bCarryDigitToInteger = true;
							}
							else if(sResult.length < iOriLen)
							{
								sResult = _super.addZeroBefore(sResult, (iOriLen - sResult.length));
							}
						}
					}
				}
				return sResult;
			}

			var formatInteger = function(sNegativeSign, sDigits)
			{
				var sResult;
				if(sDigits.length > 15)//整数超长表达不了，用字符串处理的算法
				{
					sDigits = cutZeroAhead(sDigits);
					sDigits = (_bCarryDigitToInteger ? addOne(sDigits) : sDigits);
					sResult = sDigits;
				}
				else
				{
					var iNumber = (sDigits.length == 0 ? 0 : parseInt(sDigits, 10));//防止字符串0开头，必须指定十进制
					sResult = (_bCarryDigitToInteger ? iNumber + 1: iNumber) + "";
				}
				
				if(_iGrouping > 0)
				{
					for(var i = sResult.length - _iGrouping; i > 0; i -= _iGrouping)
					{
						sResult = sResult.substring(0, i) + _sGroupingSymbol + sResult.substring(i);
					}
				}
				sResult = (_bIgnoreNegativeSign ? "" : sNegativeSign) + sResult;
				return sResult;
			}
			
			var cutZeroAhead = function(sInt)
			{
				while(sInt.length > 1 && sInt.charAt(0) == "0")
				{
					sInt = sInt.substring(1);
				}
				return sInt;
			}
			
			var addOne = function(sInt)
			{
				var iIdx = sInt.length - 1;
				while(iIdx >= 0)
				{
					var iDigist = parseInt(sInt.charAt(iIdx));
					iDigist += 1;
					if(iDigist > 9)
					{
						iDigist = 0;
					}
					sInt = sInt.substring(0, iIdx) + iDigist + sInt.substring(iIdx + 1);
					(iIdx == 0) && (sInt = "1" + sInt);
					if(iDigist == 0)
					{
						iIdx--;
					}
					else
					{
						break;
					}
				}
				return sInt;
			}
			
			var checkRounding = function(sRoundingMode, iDigit, bNegative)
			{
				var bCarry = false;
				switch(sRoundingMode)
				{
					case NumberFormater.RoundingMode.HALF_UP:
						bCarry = (iDigit > 4);//四舍五入
						break;
					case NumberFormater.RoundingMode.CEILING:
						bCarry = (iDigit > 0 && !bNegative);//正数入，负数舍
						break;
					case NumberFormater.RoundingMode.FLOOR:
						bCarry = (iDigit > 0 && bNegative);//正数舍，负数入
						break;
					default:
				}
				return bCarry;
			}
		}
	}
	NumberFormater.RoundingMode = {};
	NumberFormater.RoundingMode.DOWN = "Down";//尾数丢弃
	NumberFormater.RoundingMode.HALF_UP = "HalfUp";//四舍五入
	NumberFormater.RoundingMode.CEILING = "Ceiling";//尾数向大值（数轴右侧）进位
	NumberFormater.RoundingMode.FLOOR = "Floor";//尾数向小值（数轴左侧）进位
	
	/** 日期格式化器 */
	function DateFormater()
	{
		AbstractFormater.call(this);
		var _super = this.protectedMethod;
		var KEY_MONTH = ["january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"];
		var KEY_WEEK = ["sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"];
		var KEY_AMPM = ["am", "pm"];
		var MLS = NS.MLS;
		var _oFormatModel;
		
		this.setFormatString = function(sFormatString)
		{
			_oFormatModel = parseString(sFormatString);
		}
		
		this.format = function(oValue)
		{
			var sResult;
			var oDate = prepareValue(oValue);
			if(oDate)
			{
				sResult = formatDate(oDate, _oFormatModel);
			}
			else
			{
				sResult = oValue;			
			}
			return sResult;
		}
		
		var prepareValue = function(oValue)
		{
			var oDate = null;
			if(oValue instanceof Date)
			{
				oDate = oValue;
			}
			else if(typeof(oValue) == "string")
			{
				oValue = oValue.replace(/-/g, "/");
				oDate = new Date(oValue);
			}
			else if(typeof(oValue) == "number")
			{
				oDate = new Date(oValue);
			}
			return oDate;
		}
		
		var parseString = function(sFormatString)
		{
			var arrWords = [];
			var sLastChar = null;
			var sLastWord = "";
			var bQuote = false;
			for(var i = 0; i < sFormatString.length; i++)
			{
				var sChar = sFormatString.charAt(i);
				if(bQuote)
				{
					if(sChar == "'")//字符串结束
					{
						bQuote = false;
						sLastWord && arrWords.push([false, sLastWord]);
						sLastWord = "";
					}
					else
					{
						sLastWord += sChar;
					}
				}
				else if(sChar == "'" && sFormatString.indexOf("'", i + 1) >= 0)//字符串开始
				{
					bQuote = true;
					sLastWord && arrWords.push([true, sLastWord]);
					sLastWord = "";
					sLastChar = null;
				}
				else
				{
					if(!sLastChar || sChar == sLastChar)
					{
						sLastWord += sChar;
					}
					else
					{
						sLastWord && arrWords.push([true, sLastWord]);
						sLastWord = sChar;
					}
					sLastChar = sChar;
				}
			}
			arrWords.push([true, sLastWord]);
			return arrWords;
		}
		
		var formatDate = function(oDate, arrWords)
		{
			var sResult = "";
			for(var i = 0; i < arrWords.length; i++)
			{
				var oWord = arrWords[i];
				var bMaybeSign = oWord[0];
				var sWord = oWord[1];
				var iWordLen = sWord.length;
				var sSign = (bMaybeSign ? sWord.charAt(0) : "");
				var sWordResult;
				switch(sSign)
				{
					case "y":
						sWordResult = formatYear(oDate, iWordLen);
						break;
					case "q":
						sWordResult = formatQuarter(oDate);
						break;
					case "M":
						sWordResult = formatMonth(oDate, iWordLen);
						break;
					case "d":
						sWordResult = formatDay(oDate, iWordLen);
						break;
					case "H":
						sWordResult = formatHour(oDate, iWordLen);
						break;
					case "m":
						sWordResult = formatMinute(oDate, iWordLen);
						break;
					case "s":
						sWordResult = formatSecond(oDate, iWordLen);
						break;
					case "a":
						sWordResult = formatAmPmMarker(oDate);
						break;
					case "h":
						sWordResult = formatHourInAmPm(oDate, iWordLen);
						break;
					case "E":
						sWordResult = formatDayNameInWeek(oDate, iWordLen);
						break;
					default:
						sWordResult = sWord;
				}
				sResult += sWordResult;
			}
			return sResult;
		}
		
		var fillFrontZero = function(sText, iExpectLength)
		{
			var iRealLength = sText.length;
			if(iRealLength < iExpectLength)
			{
				sText = _super.addZeroBefore(sText, (iExpectLength - iRealLength));
			}
			return sText;
		}
		
		var cut = function(sText, iExpectLength, bKeepFront)
		{
			var iRealLength = sText.length;
			if(iRealLength > iExpectLength)
			{
				if(bKeepFront)
				{
					sText = sText.substring(0, iExpectLength);
				}
				else
				{
					sText = sText.substring(iRealLength - iExpectLength);
				}
			}
			return sText;
		}
		
		//yy yyyy
		var formatYear = function(oDate, iWordLen)
		{
			var sFormated = oDate.getFullYear() + "";
			sFormated = cut(sFormated, iWordLen, false);
			sFormated = fillFrontZero(sFormated, iWordLen);
			return sFormated;
		}
		
		//q
		var formatQuarter = function(oDate)
		{
			var iMonth = oDate.getMonth();
			var iQuarter = Math.floor(iMonth / 3) + 1;
			var sFormated = iQuarter + "";
			return sFormated;
		}
		
		//M MM MMM MMMM 1位数字 2位数字 前3位字母 全部字母
		var formatMonth = function(oDate, iWordLen)
		{
			var sFormated;
			var iMonth = oDate.getMonth();
			if(iWordLen > 2)
			{
				var sKey = KEY_MONTH[iMonth];
				sFormated = MLS.get(sKey, sKey);
				(iWordLen < 4) && (sFormated = cut(sFormated, 3, true));
			}
			else
			{
				sFormated = iMonth + 1 + "";
				sFormated = fillFrontZero(sFormated, iWordLen);
			}
			return sFormated;
		}
		
		//d dd
		var formatDay = function(oDate, iWordLen)
		{
			var sFormated = oDate.getDate() + "";
			sFormated = fillFrontZero(sFormated, iWordLen);
			return sFormated;
		}
		
		//H HH
		var formatHour = function(oDate, iWordLen)
		{
			var sFormated = oDate.getHours() + "";
			sFormated = fillFrontZero(sFormated, iWordLen);
			return sFormated;
		}
		
		//m mm
		var formatMinute = function(oDate, iWordLen)
		{
			var sFormated = oDate.getMinutes() + "";
			sFormated = fillFrontZero(sFormated, iWordLen);
			return sFormated;
		}
		
		//s ss
		var formatSecond = function(oDate, iWordLen)
		{
			var sFormated = oDate.getSeconds() + "";
			sFormated = fillFrontZero(sFormated, iWordLen);
			return sFormated;
		}
		
		//a
		var formatAmPmMarker = function(oDate)
		{
			var iHour24 = oDate.getHours();
			var iIdx = (iHour24 < 12 ? 0 : 1);
			var sKey = KEY_AMPM[iIdx];
			var sFormated = MLS.get(sKey, sKey);
			return sFormated;
		}
		
		//h hh
		var formatHourInAmPm = function(oDate, iWordLen)
		{
			var iHour24 = oDate.getHours();
			var iHour12 = iHour24 % 12;
			iHour12 = (iHour12 == 0 ? 12 : iHour12);
			var sFormated = iHour12 + "";
			sFormated = fillFrontZero(sFormated, iWordLen);
			return sFormated;
		}
		
		//E EEEE 小于4取前3位
		var formatDayNameInWeek = function(oDate, iWordLen)
		{
			var iDayInWeek = oDate.getDay();
			var sKey = KEY_WEEK[iDayInWeek];
			var sFormated = MLS.get(sKey, sKey);
			(iWordLen < 4) && (sFormated = cut(sFormated, 3, true));
			return sFormated;
		}
	}
	
	function Base64Util()
	{
		var _sBase64KeyForJs = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
		
		this.encode = function(sInput)
		{
			if(sInput == undefined || sInput == "")
			{
				return "";
			}
	        sInput = utf8Encode(sInput);
			var sOutput = "";
			var sChar1, sChar2, sChar3, sEnc1, sEnc2, sEnc3, sEnc4;
			var i = 0;
	        while (i < sInput.length) 
	        {
	            sChar1 = sInput.charCodeAt(i++);
	            sChar2 = sInput.charCodeAt(i++);
	            sChar3 = sInput.charCodeAt(i++);
	            sEnc1 = sChar1 >> 2;
	            sEnc2 = ((sChar1 & 3) << 4) | (sChar2 >> 4);
	            sEnc3 = ((sChar2 & 15) << 2) | (sChar3 >> 6);
	            sEnc4 = sChar3 & 63;
	            if (isNaN(sChar2)) 
	            {
	                sEnc3 = sEnc4 = 64;
	            } 
	            else if (isNaN(sChar3)) 
	            {
	                sEnc4 = 64;
	            }
	            sOutput = sOutput +
	            _sBase64KeyForJs.charAt(sEnc1) + _sBase64KeyForJs.charAt(sEnc2) +
	            _sBase64KeyForJs.charAt(sEnc3) + _sBase64KeyForJs.charAt(sEnc4);
	        }
	        return sOutput;
		}
		
		this.decode = function(sInput)
		{
			var sOutput = "";
			var sChar1, sChar2, sChar3, sEnc1, sEnc2, sEnc3, sEnc4;
			var i = 0;
	        sInput = sInput.replace(/[^A-Za-z0-9\+\/\=]/g, "");
	        while (i < sInput.length) 
	        {
	            sEnc1 = _sBase64KeyForJs.indexOf(sInput.charAt(i++));
	            sEnc2 = _sBase64KeyForJs.indexOf(sInput.charAt(i++));
	            sEnc3 = _sBase64KeyForJs.indexOf(sInput.charAt(i++));
	            sEnc4 = _sBase64KeyForJs.indexOf(sInput.charAt(i++));
	            sChar1 = (sEnc1 << 2) | (sEnc2 >> 4);
	            sChar2 = ((sEnc2 & 15) << 4) | (sEnc3 >> 2);
	            sChar3 = ((sEnc3 & 3) << 6) | sEnc4;
	            sOutput = sOutput + String.fromCharCode(sChar1);
	            if (sEnc3 != 64) 
	            {
	                sOutput = sOutput + String.fromCharCode(sChar2);
	            }
	            if (sEnc4 != 64) 
	            {
	                sOutput = sOutput + String.fromCharCode(sChar3);
	            }
	        }
	        sOutput = utf8Decode(sOutput);
	        return sOutput;
		}
		
		var utf8Encode = function(sString)
		{
			sString = sString.replace("/\r\n\g", "\n");
	        var sUtf8 = "";
	        for (var i = 0; i < sString.length; i++) 
	        {
	            var sChar = sString.charCodeAt(i);
	            if (sChar < 128) 
	            {
	                sUtf8 += String.fromCharCode(sChar);
	            } 
	            else if((sChar > 127) && (sChar < 2048)) 
	            {
	                sUtf8 += String.fromCharCode((sChar >> 6) | 192);
	                sUtf8 += String.fromCharCode((sChar & 63) | 128);
	            } 
	            else 
	            {
	                sUtf8 += String.fromCharCode((sChar >> 12) | 224);
	                sUtf8 += String.fromCharCode(((sChar >> 6) & 63) | 128);
	                sUtf8 += String.fromCharCode((sChar & 63) | 128);
	            }
	        }
        	return sUtf8;
		}
		
		var utf8Decode = function(sUtf8)
		{
			var sString = "";
			var i = 0;
			var sChar1 = 0, sChar2 = 0, sChar3 = 0;
	        while ( i < sUtf8.length ) 
	        {
	            sChar1= sUtf8.charCodeAt(i);
	            if (sChar1 < 128) 
	            {
	                sString += String.fromCharCode(sChar1);
	                i++;
	            } 
	            else if((sChar1 > 191) && (sChar1 < 224)) 
	            {
	                sChar2 = sUtf8.charCodeAt(i+1);
	                sString += String.fromCharCode(((sChar1 & 31) << 6) | (sChar2 & 63));
	                i += 2;
	            } 
	            else 
	            {
	                sChar2 = sUtf8.charCodeAt(i+1);
	                sChar3 = sUtf8.charCodeAt(i+2);
	                sString += String.fromCharCode(((sChar1 & 15) << 12) | ((sChar2 & 63) << 6) | (sChar3 & 63));
	                i += 3;
	            }
	        }
	        return sString;
		}
	}
	
	function Base32Util()
	{
		var _sBase32Key = "ABCDEFGHIJKLMNPQRSTUVWXYZ3456789_";
		
		this.encode = function(sInput)
		{
			if(sInput == undefined || sInput == "")
			{
				return "";
			}
	        sInput = utf8Encode(sInput);
			var sOutput = "";
			var sChar1, sChar2, sChar3, sChar4, sChar5, sEnc1, sEnc2, sEnc3, sEnc4, sEnc5, sEnc6, sEnc7, sEnc8;
			var i = 0;
	        while (i < sInput.length)
	        {
	            sChar1 = sInput.charCodeAt(i++);
	            sChar2 = sInput.charCodeAt(i++);
	            sChar3 = sInput.charCodeAt(i++);
	            sChar4 = sInput.charCodeAt(i++);
	            sChar5 = sInput.charCodeAt(i++);
	            sEnc1 = sChar1 >> 3;
	            sEnc2 = ((sChar1 & 7) << 2) | (sChar2 >> 6);
	            sEnc3 = ((sChar2 & 63) >> 1);
	            sEnc4 = ((sChar2 & 1) << 4) | (sChar3 >> 4);
	            sEnc5 = ((sChar3 & 15) << 1) | (sChar4 >> 7);
	            sEnc6 = ((sChar4 & 127) >> 2);
	            sEnc7 = ((sChar4 & 3) << 3) | (sChar5 >> 5);
	            sEnc8 = sChar5 & 31;
	            if (isNaN(sChar2)) 
	            {
	                sEnc3 = sEnc4 = sEnc5 = sEnc6 = sEnc7 = sEnc8 = 32;
	            } 
	            else if (isNaN(sChar3)) 
	            {
	                sEnc5 = sEnc6 = sEnc7 = sEnc8 = 32;
	            } 
	            else if (isNaN(sChar4)) 
	            {
	                sEnc6 = sEnc7 = sEnc8 = 32;
	            } 
	            else if (isNaN(sChar5)) 
	            {
	                sEnc8 = 32;
	            }
	            sOutput = sOutput +
	            _sBase32Key.charAt(sEnc1) + _sBase32Key.charAt(sEnc2) +
	            _sBase32Key.charAt(sEnc3) + _sBase32Key.charAt(sEnc4) +
	            _sBase32Key.charAt(sEnc5) + _sBase32Key.charAt(sEnc6) +
	            _sBase32Key.charAt(sEnc7) + _sBase32Key.charAt(sEnc8) ;
	        }
	        return sOutput;
		}
		
		this.decode = function(sInput)
		{
			var sOutput = "";
			var sChar1, sChar2, sChar3, sChar4, sChar5, sEnc1, sEnc2, sEnc3, sEnc4, sEnc5, sEnc6, sEnc7, sEnc8;
			var i = 0;
	        sInput = sInput.replace(/[^A-Z3-9_]/g, "");
	        while (i < sInput.length) 
	        {
	            sEnc1 = _sBase32Key.indexOf(sInput.charAt(i++));
	            sEnc2 = _sBase32Key.indexOf(sInput.charAt(i++));
	            sEnc3 = _sBase32Key.indexOf(sInput.charAt(i++));
	            sEnc4 = _sBase32Key.indexOf(sInput.charAt(i++));
	            sEnc5 = _sBase32Key.indexOf(sInput.charAt(i++));
	            sEnc6 = _sBase32Key.indexOf(sInput.charAt(i++));
	            sEnc7 = _sBase32Key.indexOf(sInput.charAt(i++));
	            sEnc8 = _sBase32Key.indexOf(sInput.charAt(i++));
	            sChar1 = (sEnc1 << 3) | ((sEnc2 & 31) >> 2);
	            sChar2 = ((sEnc2 & 3) << 6) | (sEnc3 << 1) | (sEnc4 >> 4);
	            sChar3 = ((sEnc4 & 15) << 4) | (sEnc5 >> 1);
	            sChar4 = ((sEnc5 & 1) << 7) | (sEnc6 << 2) | (sEnc7 >> 3);
	            sChar5 = ((sEnc7 & 7) << 5) | sEnc8;
	            sOutput = sOutput + String.fromCharCode(sChar1);
	            if (sEnc3 != 32) 
	            {
	                sOutput = sOutput + String.fromCharCode(sChar2);
	            }
	            if (sEnc5 != 32) 
	            {
	                sOutput = sOutput + String.fromCharCode(sChar3);
	            }
	            if (sEnc6 != 32) 
	            {
	                sOutput = sOutput + String.fromCharCode(sChar4);
	            }
	            if (sEnc8 != 32) 
	            {
	                sOutput = sOutput + String.fromCharCode(sChar5);
	            }
	        }
	        sOutput = utf8Decode(sOutput);
	        return sOutput;
		}
		
		var utf8Encode = function(sString)
		{
			sString = sString.replace("/\r\n\g", "\n");
	        var sUtf8 = "";
	        for (var i = 0; i < sString.length; i++) 
	        {
	            var sChar = sString.charCodeAt(i);
	            if (sChar < 128) 
	            {
	                sUtf8 += String.fromCharCode(sChar);
	            } 
	            else if((sChar > 127) && (sChar < 2048)) 
	            {
	                sUtf8 += String.fromCharCode((sChar >> 6) | 192);
	                sUtf8 += String.fromCharCode((sChar & 63) | 128);
	            } 
	            else {
	                sUtf8 += String.fromCharCode((sChar >> 12) | 224);
	                sUtf8 += String.fromCharCode(((sChar >> 6) & 63) | 128);
	                sUtf8 += String.fromCharCode((sChar & 63) | 128);
	            }
	        }
        	return sUtf8;
		}
		
		var utf8Decode = function(sUtf8)
		{
			var sString = "";
			var i = 0;
			var sChar1 = 0, sChar2 = 0, sChar3 = 0;
	        while ( i < sUtf8.length )
	        {
	            sChar1= sUtf8.charCodeAt(i);
	            if (sChar1 < 128)
				{
	                sString += String.fromCharCode(sChar1);
	                i++;
	            }
				else if((sChar1 > 191) && (sChar1 < 224)) 
				{
	                sChar2 = sUtf8.charCodeAt(i+1);
	                sString += String.fromCharCode(((sChar1 & 31) << 6) | (sChar2 & 63));
	                i += 2;
	            } 
	            else 
	            {
	                sChar2 = sUtf8.charCodeAt(i+1);
	                sChar3 = sUtf8.charCodeAt(i+2);
	                sString += String.fromCharCode(((sChar1 & 15) << 12) | ((sChar2 & 63) << 6) | (sChar3 & 63));
	                i += 3;
	            }
	        }
	        return sString;
		}
	}
	
	/** 模拟0-100%的进度 */
	function PercentageFaker()
	{
		var _numValue = 0;
		
		this.run = function(bLastTime)
		{
			if(bLastTime)
			{
				_numValue = 100;
			}
			else
			{
				var numRemain = 100 - _numValue;
				var numReduceRatio = Math.sqrt(numRemain) / 100;
				var numAlloc = numRemain * numReduceRatio * (1 + (Math.random() * 4 - 2) / 10);//+-20%
				_numValue += numAlloc;
			}
			return Math.floor(_numValue); 
		}
	}
	
	/** 相对日期的数据模型 */
	function RelativePeriodModel()
	{
		var _sPeriod = RelativePeriodModel.PERIOD_DAY;//周期:Year, Quarter, Month, Week, Day, Hour, Minute
		var _iWhichPeriod = null;//0表示基准时间所在的周期，-1表示上个周期（昨天），1表示下个周期（明天）；可以为null，则fromNowOn必须有
		var _iFromNowOn = 0;//取值(-n,-1][1,n)，表示前k个周期到当前周期 或 当前周期到后k个周期
		var _bUpToNow = false;//周期开始至当前，例如本周至今
		var _oAnchor = null;//相对范围的基准时间；可以为空，则表示当前
		
		this.setPeriod = function(sPeriod)
		{
			_sPeriod = sPeriod;
		}
		this.getPeriod = function()
		{
			return _sPeriod;
		}
		
		this.setWhichPeriod = function(iWhichPeriod)
		{
			_iWhichPeriod = iWhichPeriod;
		}
		
		this.getWhichPeriod = function()
		{
			return _iWhichPeriod;
		}
		
		this.setFromNowOn = function(iFromNowOn)
		{
			_iFromNowOn = iFromNowOn;
		}
		this.getFromNowOn = function()
		{
			return _iFromNowOn;
		}
		
		this.setUpToNow = function(bUpToNow)
		{
			_bUpToNow = bUpToNow;
		}
		this.getUpToNow = function()
		{
			return _bUpToNow;
		}
		
		this.setAnchor = function(oAnchor)
		{
			_oAnchor = oAnchor;
		}
		this.getAnchor = function()
		{
			return _oAnchor;
		}
		
		this.toJsonObject = function()
		{
			var oJson = {};
			oJson["period"] = _sPeriod;
			oJson["whichPeriod"] = _iWhichPeriod;
			oJson["fromNowOn"] = _iFromNowOn;
			oJson["upToNow"] = _bUpToNow;
			oJson["anchor"] = (_oAnchor && _oAnchor instanceof Date) ? _oAnchor.getTime() : _oAnchor;
			return oJson;
		}
		
		this.fromJsonObject = function(oJson)
		{
			if(oJson)
			{
				_sPeriod = oJson.hasOwnProperty("period") ? oJson["period"] : _sPeriod;
				_iWhichPeriod = oJson.hasOwnProperty("whichPeriod") ? oJson["whichPeriod"] : null;
				_iFromNowOn = oJson.hasOwnProperty("fromNowOn") ? oJson["fromNowOn"] : _iFromNowOn;
				_bUpToNow = oJson.hasOwnProperty("upToNow") ? oJson["upToNow"] : _bUpToNow;
				var iAnchor = (oJson.hasOwnProperty("anchor") ? parseInt(oJson["anchor"]) : null);
				if(!isNaN(iAnchor) && iAnchor != null)
				{
					var oAnchor = new Date();
					oAnchor.setTime(iAnchor);
					_oAnchor = oAnchor;
				}
			}
		}
	}
	
	RelativePeriodModel.PERIOD_YEAR = "Year";
	RelativePeriodModel.PERIOD_QUARTER = "Quarter";
	RelativePeriodModel.PERIOD_MONTH = "Month";
	RelativePeriodModel.PERIOD_WEEK = "Week";
	RelativePeriodModel.PERIOD_DAY = "Day";
	RelativePeriodModel.PERIOD_HOUR = "Hour";
	RelativePeriodModel.PERIOD_MINUTE = "Minute";
	
	
	function ColorUtil()
	{
		var REG_RGBA = /^rgba\(\s*(25[0-5]|2[0-4][0-9]|[0-1]?\d?\d)\s*,\s*(25[0-5]|2[0-4][0-9]|[0-1]?\d?\d)\s*,\s*(25[0-5]|2[0-4][0-9]|[0-1]?\d?\d)\s*,\s*(0|1|0\.\d*|1\.0*)\s*\)$/i;
		var REG_RGB  =  /^rgb\(\s*(25[0-5]|2[0-4][0-9]|[0-1]?\d?\d)\s*,\s*(25[0-5]|2[0-4][0-9]|[0-1]?\d?\d)\s*,\s*(25[0-5]|2[0-4][0-9]|[0-1]?\d?\d)\s*\)$/i;
		var REG_HSL  =  /^hsl\(\s*(360|3[0-5][0-9]|[0-2]?\d?\d)\s*,\s*(100|\d?\d)%\s*,\s*(100|\d?\d)%\s*\)$/i;
		var REG_HSLA = /^hsla\(\s*(360|3[0-5][0-9]|[0-2]?\d?\d)\s*,\s*(100|\d?\d)%\s*,\s*(100|\d?\d)%\s*,\s*(0|1|0\.\d*|1\.0*)\s*\)$/i;
		var REG_HEX6 = /^#([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i;
		var REG_HEX3 = /^#([a-f\d])([a-f\d])([a-f\d])$/i;
		
		var _this = this;
		
		/** 检查颜色值是否为这样的格式：#ffffff */
		this.isHexRgb = function(sColor)
		{
			return REG_HEX6.test(sColor);
		}
		
		/** 检查颜色值是否为这样的格式：#fff */
		this.isSimpleHexRgb = function(sColor)
		{
			return REG_HEX3.test(sColor);
		}
		
		/** 检查颜色值是否为这样的格式：rgb(255,255,255) */
		this.isFunctionRgb = function(sColor)
		{
			return REG_RGB.test(sColor);
		}
		
		/** 检查颜色值是否为这样的格式：rgba(255,255,255,1) */
		this.isFunctionRgba = function(sColor)
		{
			return REG_RGBA.test(sColor);
		}
		
		/** 检查颜色值是否为这样的格式：hsl(360,100%,100%) */
		this.isFunctionHsl = function(sColor)
		{
			return REG_HSL.test(sColor);
		}
		
		/** 检查颜色值是否为这样的格式：hsl(360,100%,100%,1) */
		this.isFunctionHsla = function(sColor)
		{
			return REG_HSLA.test(sColor);
		}
		
		/** 将字符串#ffffff解析成数组[255,255,255]分别表示RGB的三个数值分量 */
		this.decodeHexRgb = function(sColor)
		{
			var arrRgb = REG_HEX6.exec(sColor);
			return [parseInt(arrRgb[1], 16), parseInt(arrRgb[2], 16), parseInt(arrRgb[3], 16)];
		}
		
		/** 将字符串#fff解析成数组[255,255,255]分别表示RGB的三个数值分量 */
		this.decodeSimpleHexRgb = function(sColor)
		{
			var arrRgb = REG_HEX3.exec(sColor);
			return [parseInt(arrRgb[1] + arrRgb[1], 16), parseInt(arrRgb[2] + arrRgb[2], 16), parseInt(arrRgb[3] + arrRgb[3], 16)];
		}
		
		/** 将字符串rgb(255,255,255)解析成数组[255,255,255]分别表示RGB的三个数值分量 */
		this.decodeFunctionRgb = function(sColor)
		{
			var arrRgb = REG_RGB.exec(sColor);
			return [parseInt(arrRgb[1]), parseInt(arrRgb[2]), parseInt(arrRgb[3])];
		}
		
		/** 将字符串rgba(255,255,255,1)解析成数组[255,255,255,1]分别表示RGBA的四个数值分量 */
		this.decodeFunctionRgba = function(sColor)
		{
			var arrRgba = REG_RGBA.exec(sColor);
			return [parseInt(arrRgba[1]), parseInt(arrRgba[2]), parseInt(arrRgba[3]), parseFloat(arrRgba[4])];
		}
		
		/** 将字符串hsl(360,100%,100%)解析成数组[360,100,100]分别表示HSL的三个数值分量 */
		this.decodeFunctionHsl = function(sColor)
		{
			var arrHsl = REG_HSL.exec(sColor);
			return [parseInt(arrHsl[1]), parseInt(arrHsl[2]), parseInt(arrHsl[3])];
		}
		
		/** 将字符串hsla(360,100%,100%,1)解析成数组[360,100,100,1]分别表示HSLA的四个数值分量 */
		this.decodeFunctionHsla = function(sColor)
		{
			var arrHsla = REG_HSLA.exec(sColor);
			return [parseInt(arrHsla[1]), parseInt(arrHsla[2]), parseInt(arrHsla[3]), parseFloat(arrHsla[4])];
		}
		
		/** 将不一定什么格式的字符串解析成数组[255,255,255]分别表示RGB的三个数值分量，如果有alpha分量会丢失，不能识别的输入则返回null。 */
		this.decodeStringToRgbArray = function(sColor)
		{
			if(_this.isHexRgb(sColor))
			{
				return _this.decodeHexRgb(sColor);
			}
			else if(_this.isSimpleHexRgb(sColor))
			{
				return _this.decodeSimpleHexRgb(sColor);
			}
			else if(_this.isFunctionRgb(sColor))
			{
				return _this.decodeFunctionRgb(sColor);
			}
			else if(_this.isFunctionHsl(sColor))
			{
				var arrHsl = _this.decodeFunctionHsl(sColor);
				return _this.hslToRgb(arrHsl[0], arrHsl[1], arrHsl[2]);
			}
			else if(_this.isFunctionRgba(sColor))
			{
				var arrRgba = _this.decodeFunctionRgba(sColor);
				return [arrRgba[0], arrRgba[1], arrRgba[2]];
			}
			else if(_this.isFunctionHsla(sColor))
			{
				var arrHsla = _this.decodeFunctionHsla(sColor);
				return _this.hslToRgb(arrHsla[0], arrHsla[1], arrHsla[2]);
			}
			return null;
		}
		
		/** 将不一定什么格式的字符串解析成数组[255,255,255,1]分别表示RGBA的四个数值分量，如果没有alpha分量会补1，不能识别的输入则返回null。 */
		this.decodeStringToRgbaArray = function(sColor)
		{
			var arrResult = null;
			if(_this.isHexRgb(sColor))
			{
				arrResult = _this.decodeHexRgb(sColor);
				arrResult.push(1);
			}
			else if(_this.isSimpleHexRgb(sColor))
			{
				arrResult = _this.decodeSimpleHexRgb(sColor);
				arrResult.push(1);
			}
			else if(_this.isFunctionRgb(sColor))
			{
				arrResult = _this.decodeFunctionRgb(sColor);
				arrResult.push(1);
			}
			else if(_this.isFunctionHsl(sColor))
			{
				var arrHsl = _this.decodeFunctionHsl(sColor);
				arrResult = _this.hslToRgb(arrHsl[0], arrHsl[1], arrHsl[2]);
				arrResult.push(1);
			}
			else if(_this.isFunctionRgba(sColor))
			{
				arrResult = _this.decodeFunctionRgba(sColor);
			}
			else if(_this.isFunctionHsla(sColor))
			{
				var arrHsla = _this.decodeFunctionHsla(sColor);
				arrResult = _this.hslToRgb(arrHsla[0], arrHsla[1], arrHsla[2]);
				arrResult.push(arrHsla[3]);
			}
			return arrResult;
		}
		
		/** iR, iG, iB的值范围都是0-255，返回数组[h,s,l] */
		this.rgbToHsl = function(iR, iG, iB)
		{
			iR /= 255;
			iG /= 255;
			iB /= 255;
		    var iMax = Math.max(iR, iG, iB), iMin = Math.min(iR, iG, iB);
		    var numH, numS, numL = (iMax + iMin) / 2;
		    if(iMax == iMin)
		    {
		        numH = numS = 0; // achromatic
		    }
		    else
		    {
		        var iD = iMax - iMin;
		        numS = numL <= 0.5 ? iD / (iMax + iMin) : iD / (2 - iMax - iMin);
		        switch(iMax)
		        {
		            case iR: numH = (iG - iB) / iD;
		            	break;
		            case iG: numH = ((iB - iR) / iD) + 2;
		            	break;
		            case iB: numH = ((iR - iG) / iD) + 4;
		            	break;
		        }
		        numH = numH * 60;
		        if(numH < 0)
		        {
		        	numH += 360;
		        }
		    }
		    return [Math.round(numH), Math.round(numS * 100), Math.round(numL * 100)];
		}
		
		/** iH，iS，iL的值范围分别是0-360，0-100，0-100，返回数组[r,g,b] */
		this.hslToRgb = function(iH, iS, iL)
		{
			iH = iH / 360;
			iS = iS / 100;
			iL = iL / 100;
		    var iRed, iGreen, iBlue;
		    if(iS == 0)
		    {
		        iRed = iGreen = iBlue = Math.round(iL * 255); // achromatic
		    }
		    else
		    {
		        var hueToRgb = function(numParameter1, numParameter2, iHue)
		        {
		            if(iHue < 0)
		            {
		            	iHue += 1;
		            }
		            if(iHue > 1)
		            {
		            	iHue -= 1;
		            }
		            
		            if(iHue < 1/6)
		            {
		            	return numParameter1 + (numParameter2 - numParameter1) * 6 * iHue;
		            }
		            else if(iHue < 1/2)
		            {
		            	return numParameter2;
		            }
		            else if(iHue < 2/3)
		            {
		            	return numParameter1 + (numParameter2 - numParameter1) * (2/3 - iHue) * 6;
		            }
		            return numParameter1;
		        }
		        var numParameter2 = iL < 0.5 ? iL * (1 + iS) : iL + iS - iL * iS;
		        var numParameter1 = 2 * iL - numParameter2;   
		        iRed = Math.round(hueToRgb(numParameter1, numParameter2, iH + 1/3) * 255);
		        iGreen = Math.round(hueToRgb(numParameter1, numParameter2, iH) * 255);
		        iBlue = Math.round(hueToRgb(numParameter1, numParameter2, iH - 1/3) * 255);
		    }
		    return [iRed, iGreen, iBlue];
		}
		
		/** iR, iG, iB的值范围都是0-255，返回数组[h,s,v] */
		this.rgbToHsv = function(iR, iG, iB)
		{
			iR /= 255;
			iG /= 255;
			iB /= 255;
		    var iMax = Math.max(iR, iG, iB), iMin = Math.min(iR, iG, iB);
		    var numH, numS, numV = iMax;
		    if(iMax == iMin)
		    {
		        numH = 0;
		    }
		    else
		    {
		        var iD = iMax - iMin;
		        switch(iMax)
		        {
		            case iR: numH = (iG - iB) / iD;
		            	break;
		            case iG: numH = ((iB - iR) / iD) + 2;
		            	break;
		            case iB: numH = ((iR - iG) / iD) + 4;
		            	break;
		        }
		        numH = numH * 60;
		        if(numH < 0)
		        {
		        	numH += 360;
		        }
		    }
		    if(iMax == 0)
		    {
		    	numS = 0;
		    }
		    else
		    {
		    	numS = 1 - (iMin / iMax);
		    }
		    return [Math.round(numH), Math.round(numS * 100), Math.round(numV * 100)];
		}
		
		/** iH，iS，iV的值范围分别是0-360，0-100，0-100，返回数组[r,g,b] */
		this.hsvToRgb = function(iH, iS, iV)
		{
			iS = iS / 100;
			iV = iV / 100;
			var numH = Math.floor(iH / 60) % 6;
			var numF = iH / 60 - numH;
			var numP = iV * (1 - iS);
		    var numQ = iV * (1 - numF * iS);
		    var numT = iV * (1 - (1 - numF) * iS);
			var numRed, numGreen, numBlue;
		    switch (numH)
		    {
		        case 0: numRed = iV;   numGreen = numT; numBlue = numP; break;
		        case 1: numRed = numQ; numGreen = iV;   numBlue = numP; break;
		        case 2: numRed = numP; numGreen = iV;   numBlue = numT; break;
		        case 3: numRed = numP; numGreen = numQ; numBlue = iV;   break;
		        case 4: numRed = numT; numGreen = numP; numBlue = iV;   break;
		        case 5: numRed = iV;   numGreen = numP; numBlue = numQ; break;
		    }
		    return [Math.round(numRed * 255), Math.round(numGreen * 255), Math.round(numBlue * 255)];
		}
		
		/** 将一个不带半透明的颜色值字符串，加上[0,1]的半透明值，变成一个rgba()格式的字符串 */
		this.withOpacityToRgba = function(sColor, numOpacity)
		{
			var arrRgb = _this.decodeStringToRgbArray(sColor);
			if(arrRgb)
			{
				arrRgb.push(numOpacity);
				sColor = "rgba(#0,#1,#2,#3)";
				for(var i = 0; i < 4; i++)
				{
					sColor = sColor.replace("#" + i, arrRgb[i]);
				}
			}
			return sColor;
		}
		
		/** 将一个可能带有半透明的颜色值，分解出两个值：纯色的rgb()格式的字符串，[0,1]的半透明值（源值不带此信息时此值总为1）。 */
		this.splitRgbAndOpacity = function(sColor)
		{
			var numOpacity = 1;
			var arrRgba = _this.decodeStringToRgbaArray(sColor);
			if(arrRgba)
			{
				sColor = "rgb(#0,#1,#2)";
				for(var i = 0; i < 3; i++)
				{
					sColor = sColor.replace("#" + i, arrRgba[i]);
				}
				numOpacity = arrRgba[3];
			}
			return [sColor, numOpacity];
		}
	}
	
	function CssUtil()
	{
		var _arrBrowserPrefix = ["", "-ms-", "-moz-", "-webkit-", "-o-"];
		
		/** 旋转多少度 */
		this.rotate = function(jqTarget, iDeg)
		{
			var sValue = "rotate(" + iDeg + "deg)";
			jqTarget.css(createCompatibleCss("transform", sValue));
		}
		
		var createCompatibleCss = function(sStandardKey, sValue)
		{
			var oCss = {};
			for(var i = 0; i < _arrBrowserPrefix.length; i++)
			{
				var sKey = _arrBrowserPrefix[i] + sStandardKey;
				oCss[sKey] = sValue;
			}
			return oCss;
		}
	}
	
	/**
	 * 让多个单行控件组合成一行。
	 * 特别适合于CheckBox+输入框这种模式，输入框紧接着不确定长度的文字。前面带有不确定的文字（考虑多语言），但文字确定后则宽度固定，紧接着的输入框可调整宽度。
	 * 注意子元素及其后代不应该绝对定位（position:absolute）。
	 * 由于使用了Flexbox，浏览器要求IE11+。
	 * e.g.
	 * var oCompositeCtrl = new CompositeCtrl();
	 * oCompositeCtrl.addStableChild(new RadioButton(), 20);
	 * oCompositeCtrl.addStableChild(new Label("..."));//文字在不同环境会不一样
	 * oCompositeCtrl.addGap(8);
	 * oCompositeCtrl.addActiveChild(new TextField());
	 */
	function CompositeCtrl()
	{
		var _this = this;
		var _jqUi;
		var _arrCtrl = [];
		
		/** 添加完子控件后再调用 */
		this.setEnabled = function(bEnabled)
		{
			for(var i = 0; i < _arrCtrl.length; i++)
			{
				_arrCtrl[i].setEnabled(bEnabled);
			}
		}
		
		this.getJqUi = function()
		{
			if(!_jqUi)
			{
				_jqUi = $("<div>");
				_jqUi.css({
					"display": "flex",
					"flex-flow": "row nowrap",
					"align-items": "stretch"
				});
			}
			return _jqUi;
		}
		
		/** 添加一段间距 */
		this.addGap = function(iWidth)
		{
			addStableChild($("<div>"), iWidth);
		}
		
		/** 添加一个不参与缩放的子控件，iWidth可选。 */
		this.addStableChild = function(oCtrl, iWidth)
		{
			_arrCtrl.push(oCtrl);
			addStableChild(oCtrl.getJqUi(), iWidth);
		}
		
		/** 添加一个会缩放的子控件 */
		this.addActiveChild = function(oCtrl)
		{
			_arrCtrl.push(oCtrl);
			var jqCtrl = oCtrl.getJqUi();
			addChild(jqCtrl);
			jqCtrl.css("flex", "auto");//1 1 auto
		}
		
		var addStableChild = function(jqCtrl, iWidth)
		{
			addChild(jqCtrl);
			jqCtrl.css("flex", "none");//0 0 auto
			iWidth && jqCtrl.css("width", iWidth);
		}
		
		var addChild = function(jqCtrl)
		{
			jqCtrl.appendTo(_this.getJqUi());
			jqCtrl.css("position", "relative");
		}
	}
	
	/** 将离散的矩形区域(以左上宽高表示)转换成表格，从而实现任意尺寸的自适应布局。 */
	function BlocksToTable()
	{
		var _bGapFixed = true;
		
		var _iOriWidth;
		var _iOriHeight;
		var _arrVerticalLine;
		var _arrHorizontalLine;
		var _mapBlockFixed;
		
		var _arrVerticalRoad;
		var _arrHorizontalRoad;
		var _mapBlockInTable;
		
		/** 间距是否锁定（默认为true） */
		this.setGapFixed = function(bGapFixed)
		{
			_bGapFixed = bGapFixed;
		}
		
		/** 指定设计期的界面尺寸 */
		this.setDesigningSize = function(iWidth, iHeight)
		{
			_iOriWidth = iWidth;
			_iOriHeight = iHeight;
			_arrVerticalLine = [];
			_arrHorizontalLine = [];
			_mapBlockFixed = {};
		}
		
		/** 添加设计期矩形，以sId识别，以左上宽高描述位置及大小 */
		this.appendBlock = function(sId, iX, iY, iW, iH, bWidthFixed, bHeightFixed)
		{
			var iX1 = Math.max(0, Math.min(_iOriWidth, iX));
			var iX2 = Math.max(0, Math.min(_iOriWidth, iX + iW));
			var iY1 = Math.max(0, Math.min(_iOriHeight, iY));
			var iY2 = Math.max(0, Math.min(_iOriHeight, iY + iH));
			if(iX1 < iX2 && iY1 < iY2)
			{
				appendTwoLines(_arrVerticalLine, sId, iX1, iX2);
				appendTwoLines(_arrHorizontalLine, sId, iY1, iY2);
				_mapBlockFixed[sId] = [(bWidthFixed ? true : false), (bHeightFixed ? true : false)];
			}
		}
		
		/** 自适应到新的尺寸 */
		this.transformTo = function(iNewWidth, iNewHeight)
		{
			if(!_mapBlockInTable)
			{
				_arrVerticalRoad = [];
				_arrHorizontalRoad = [];
				_mapBlockInTable = {};
				parse();
				_arrVerticalLine = null;
				_arrHorizontalLine = null;
				_mapBlockFixed = null;
			}
			transformTo(iNewWidth, iNewHeight);
		}
		
		/** 查询矩形的新位置大小[iX, iY, iW, iH]，可能返回null，是由于整个矩形都在容器外。 */
		this.searchBlockRect = function(sId)
		{
			var oBlockInTable = _mapBlockInTable[sId];
			if(oBlockInTable)
			{
				var iVR1 = _arrVerticalRoad[oBlockInTable.getLeft()].getCoordinateBefore();
				var iVR2 = _arrVerticalRoad[oBlockInTable.getRight()].getCoordinateAfter();
				var iLeft = Math.min(iVR1, iVR2);
				var iRight = Math.max(iVR1, iVR2);
				var iHR1 = _arrHorizontalRoad[oBlockInTable.getTop()].getCoordinateBefore();
				var iHR2 = _arrHorizontalRoad[oBlockInTable.getBottom()].getCoordinateAfter();
				var iTop = Math.min(iHR1, iHR2);
				var iBottom = Math.max(iHR1, iHR2);
				return [iLeft, iTop, (iRight - iLeft), (iBottom - iTop)];
			}
			return null;
		}
		
		//矩形的前、后边，添加两条线
		var appendTwoLines = function(arrLine, sId, iValue1, iValue2)
		{
			var iValue = iValue2;
			var bFirstDone = false;
			for(var i = arrLine.length - 1; i >= 0; i--)
			{
				var bFound = false;
				var oLine = arrLine[i];
				if(iValue == oLine.getValue())
				{
					bFound = true;
				}
				else if(iValue > oLine.getValue())
				{
					oLine = new Line();
					oLine.setValue(iValue);
					arrLine.splice(i + 1, 0, oLine);
					bFound = true;
				}
				
				if(bFound)
				{
					if(bFirstDone)
					{
						sId && oLine.addAhead(sId);
						return;
					}
					else
					{
						sId && oLine.addBehind(sId);
						bFirstDone = true;
						iValue = iValue1;
					}
					i++;
				}
			}
			
			if(!bFirstDone)
			{
				var oLine = new Line();
				oLine.setValue(iValue2);
				sId && oLine.addBehind(sId);
				arrLine.splice(0, 0, oLine);
			}
			var oLine = new Line();
			oLine.setValue(iValue1);
			sId && oLine.addAhead(sId);
			arrLine.splice(0, 0, oLine);
		}
		
		var parse = function()
		{
			appendTwoLines(_arrVerticalLine, null, 0, _iOriWidth);
			appendTwoLines(_arrHorizontalLine, null, 0, _iOriHeight);
			parseLineToRoad(_arrVerticalLine, _arrVerticalRoad, "setLeft", "setRight");
			parseLineToRoad(_arrHorizontalLine, _arrHorizontalRoad, "setTop", "setBottom");
			parseRoadFixed();
		}
		
		var parseLineToRoad = function(arrLine, arrRoad, sSetRoadIdxStart, sSetRoadIdxEnd)
		{
			for(var i = 1; i < arrLine.length; i++)
			{
				var oLineA = arrLine[i - 1];
				var oLineB = arrLine[i];
				var oRoad = new Road();
				oRoad.setOriginal(oLineB.getValue() - oLineA.getValue());
				arrRoad.push(oRoad);
				
				var arrAhead = oLineA.getAllAheads();
				var arrBehind = oLineB.getAllBehinds();
				var iRoadIdx = i - 1;
				mappingId(iRoadIdx, arrAhead, sSetRoadIdxStart);
				mappingId(iRoadIdx, arrBehind, sSetRoadIdxEnd);
				
				if(_bGapFixed)
				{
					//是否有矩形区域起止于此，从而判别该Road是否为间距。“起止”不包含穿过，因为“起止”是划线的原因，也就是生成Road的原因。
					//如果没有矩形区域起止于此，被判定为间距，直接设置锁定。
					var bFirst = (i == 1);//整体的最前不算“起”，整体的最后不算“止”，以解决一条横线（图片）顶着两端，使左右边距识别失效的问题。
					var bLast = (i == arrLine.length - 1);
					var bAnyBlockBorn = (!bFirst && arrAhead.length > 0) || (!bLast && arrBehind.length > 0);
					var bGap = !bAnyBlockBorn;
					bGap && (oRoad.getOriginal() <= 40) && oRoad.setFixed(true);
				}
			}
		}
		
		var mappingId = function(iRoadIdx, arrWhoOnLine, sMethodSetRoadIndex)
		{
			for(var i = 0; i < arrWhoOnLine.length; i++)
			{
				var sId = arrWhoOnLine[i];
				var oBlockInTable = _mapBlockInTable[sId];
				if(!oBlockInTable)
				{
					oBlockInTable = new BlockInTable();
					_mapBlockInTable[sId] = oBlockInTable;
				}
				var funSetRoadIndex = oBlockInTable[sMethodSetRoadIndex];
				funSetRoadIndex(iRoadIdx);
			}
		}
		
		var parseRoadFixed = function()
		{
			//有固定高宽的矩形穿过的行列标记为锁定
			for(var sId in _mapBlockInTable)
			{
				var oBlockInTable = _mapBlockInTable[sId];
				var arrFixed = _mapBlockFixed[sId];
				var bBlockWidthFixed = arrFixed[0];
				var bBlockHeightFixed = arrFixed[1];
				if(bBlockWidthFixed)
				{
					for(var i = oBlockInTable.getLeft(); i <= oBlockInTable.getRight(); i++)
					{
						var oRoad = _arrVerticalRoad[i];
						oRoad.setFixed(true);
					}
				}
				if(bBlockHeightFixed)
				{
					for(var i = oBlockInTable.getTop(); i <= oBlockInTable.getBottom(); i++)
					{
						var oRoad = _arrHorizontalRoad[i];
						oRoad.setFixed(true);
					}
				}
			}
			//转赠
			allocateGivenTargetWhenFixed(_arrVerticalRoad, "getLeft", "getRight");
			allocateGivenTargetWhenFixed(_arrHorizontalRoad, "getTop", "getBottom");
		}
		
		var allocateGivenTargetWhenFixed = function(arrRoad, sGetRoadIdxStart, sGetRoadIdxEnd)
		{
			//对每一个矩形，在其覆盖的Road范围内，做锁定转赠预处理（只记录转赠给谁，未计算比例）
			for(var sId in _mapBlockInTable)
			{
				var oBlockInTable = _mapBlockInTable[sId];
				var iIdxStart = oBlockInTable[sGetRoadIdxStart]();
				var iIdxEnd = oBlockInTable[sGetRoadIdxEnd]();
				preGivenInsideBlock(arrRoad, iIdxStart, iIdxEnd);
			}
			//对于锁定的Road未指定转赠目标的，则转赠给所有其它不锁定的Road
			var arrAllUnfixedIdx;
			for(var i = 0; i < arrRoad.length; i++)
			{
				var oRoad = arrRoad[i];
				if(oRoad.isFixed() && !oRoad.getGivenTargetWhenFixed())
				{
					if(!arrAllUnfixedIdx)
					{
						arrAllUnfixedIdx = [];
						for(var j = 0; j < arrRoad.length; j++)
						{
							var oEachRoad = arrRoad[j];
							!oEachRoad.isFixed() && arrAllUnfixedIdx.push(j);
						}
					}
					joinPreGivenTarget(oRoad, arrAllUnfixedIdx);
				}
			}
			//计算转赠比例
			for(var i = 0; i < arrRoad.length; i++)
			{
				var oRoad = arrRoad[i];
				if(oRoad.isFixed())
				{
					var mapGivenTarget = oRoad.getGivenTargetWhenFixed();
					var iTotal = 0;
					for(var sKey in mapGivenTarget)
					{
						var iIdx = parseInt(sKey);
						var oGivenTargetRoad = arrRoad[iIdx];
						iTotal += oGivenTargetRoad.getOriginal();
					}
					for(var sKey in mapGivenTarget)
					{
						var iIdx = parseInt(sKey);
						var oGivenTargetRoad = arrRoad[iIdx];
						var numRatio = oGivenTargetRoad.getOriginal() / iTotal;
						mapGivenTarget[sKey] = numRatio;
					}
				}
			}
		}
		
		var preGivenInsideBlock = function(arrRoad, iIdxStart, iIdxEnd)
		{
			var arrFixedIdx = [];
			var arrUnfixedIdx = [];
			for(var i = iIdxStart; i <= iIdxEnd; i++)
			{
				var oRoad = arrRoad[i];
				if(oRoad.isFixed())
				{
					arrFixedIdx.push(i);
					if(arrUnfixedIdx.length > 0)
					{
						joinPreGivenTarget(oRoad, arrUnfixedIdx);
					}
				}
				else
				{
					arrUnfixedIdx.push(i);
					for(var j = 0; j < arrFixedIdx.length; j++)
					{
						var iIdx = arrFixedIdx[j];
						var oBrotherRoad = arrRoad[iIdx];
						joinPreGivenTarget(oBrotherRoad, i); 
					}
				}
			}
		}
		
		var joinPreGivenTarget = function(oRoad, oTargetToJoin)
		{
			var mapTargetRoad = oRoad.getGivenTargetWhenFixed();
			if(!mapTargetRoad)
			{
				mapTargetRoad = {};
				oRoad.setGivenTargetWhenFixed(mapTargetRoad);
			}
			if(typeof(oTargetToJoin) == "number")
			{
				var iTarget = oTargetToJoin;
				mapTargetRoad[iTarget] = true;
			}
			else
			{
				var arrTargetToJoin = oTargetToJoin;
				for(var i = 0; i < arrTargetToJoin.length; i++)
				{
					var iTarget = arrTargetToJoin[i];
					mapTargetRoad[iTarget] = true;
				}
			}
		}
		
		var transformTo = function(iNewWidth, iNewHeight)
		{
			transform(_arrVerticalRoad, _iOriWidth, iNewWidth);
			transform(_arrHorizontalRoad, _iOriHeight, iNewHeight);
		}
		
		var transform = function(arrRoad, iOldWide, iNewWide)
		{
			var bAnyFixed = adjustBlindly(arrRoad, iOldWide, iNewWide);//不考虑锁定，盲目地等比例缩放所有行列。
			if(bAnyFixed)//当有锁定时，需进一步处理。
			{
				readjustFixed(arrRoad);//将锁定行列多算的值，按规则转赠给其它行列。
			}
			var numRunningAdd = 0;
			for(var i = 0; i < arrRoad.length; i++)
			{
				var oRoad = arrRoad[i];
				var iStart = parseInt(numRunningAdd + 0.5);
				var numWide = oRoad.getAdjusted();
				numRunningAdd += numWide;
				var iEnd = parseInt(numRunningAdd + 0.5);
				oRoad.setCoordinate(iStart, iEnd);
			}
		}
		
		var adjustBlindly = function(arrRoad, iOldWide, iNewWide)
		{
			var bAnyFixed = false;
			for(var i = 0; i < arrRoad.length; i++)
			{
				var oRoad = arrRoad[i];
				var numAdjusted = oRoad.getOriginal() / iOldWide * iNewWide;
				oRoad.setAdjusted(numAdjusted);
				if(oRoad.isFixed())
				{
					bAnyFixed = true;
				}
			}
			return bAnyFixed;
		}
		
		var readjustFixed = function(arrRoad)
		{
			for(var i = 0; i < arrRoad.length; i++)
			{
				var oRoad = arrRoad[i];
				if(oRoad.isFixed())
				{
					var numDelta = oRoad.getAdjusted() - oRoad.getOriginal();
					oRoad.setAdjusted(oRoad.getOriginal());
					
					var mapGivenTarget = oRoad.getGivenTargetWhenFixed();
					for(var sKey in mapGivenTarget)
					{
						var iTargetIdx = parseInt(sKey);
						var oAnotherRoad = arrRoad[iTargetIdx];
						var numGivenRatio = mapGivenTarget[sKey];
						var numAdjusted = oAnotherRoad.getAdjusted() + numDelta * numGivenRatio;
						oAnotherRoad.setAdjusted(numAdjusted);//Maybe numAdjusted < 0 
					}
				}
			}
		}
		
		//该类描述一个矩形在表格中从哪列到哪列，从哪行到哪行。
		function BlockInTable()
		{
			var _iLeftRoadIdx;
			var _iRightRoadIdx;
			var _iTopRoadIdx;
			var _iBottomRoadIdx;
			
			this.setLeft = function(iIdx)
			{
				_iLeftRoadIdx = iIdx;
			}
			this.getLeft = function()
			{
				return _iLeftRoadIdx;
			}
			
			this.setRight = function(iIdx)
			{
				_iRightRoadIdx = iIdx;
			}
			this.getRight = function()
			{
				return _iRightRoadIdx;
			}
			
			this.setTop = function(iIdx)
			{
				_iTopRoadIdx = iIdx;
			}
			this.getTop = function()
			{
				return _iTopRoadIdx;
			}
			
			this.setBottom = function(iIdx)
			{
				_iBottomRoadIdx = iIdx;
			}
			this.getBottom = function()
			{
				return _iBottomRoadIdx;
			}
		}
		
		//划线
		function Line()
		{
			var _iValue;
			var _arrAhead = [];
			var _arrBehind = [];
			
			//该线的坐标
			this.setValue = function(iValue)
			{
				_iValue = iValue;
			}
			this.getValue = function()
			{
				return _iValue; 
			}
			
			//哪些矩形的前边在这条线上
			this.addAhead = function(sId)
			{
				_arrAhead.push(sId);
			}
			this.getAllAheads = function()
			{
				return _arrAhead.slice(0);
			}
			
			//哪些矩形的后边在这条线上
			this.addBehind = function(sId)
			{
				_arrBehind.push(sId);
			}
			this.getAllBehinds = function()
			{
				return _arrBehind.slice(0);
			}
			
			this.toString = function()
			{
				return _iValue + "->[" + _arrAhead.join(",") + "][" + _arrBehind.join(",") + "]";
			}
		}
		
		//相临两条线是一条路
		function Road()
		{
			//以下是只有一次parse之后的状态：
			var _iOriginal;
			var _bFixed = false;
			var _mapGivenTargetWhenFixed;
			//以下是可以多次transform之后的计算结果：
			var _numAdjusted;
			var _iCoordinateBefore;
			var _iCoordinateAfter;
			
			//原始的宽度
			this.setOriginal = function(iOriginal)
			{
				_iOriginal = iOriginal;
			}
			this.getOriginal = function()
			{
				return _iOriginal;
			}
			
			//锁定--不随缩放调整
			this.setFixed = function(bFixed)
			{
				_bFixed = bFixed;
			}
			this.isFixed = function()
			{
				return _bFixed;
			}
			
			//当锁定时，多分配的值转赠给谁--map的键是Road数组的下标，值是转赠比例(0,1]。
			this.setGivenTargetWhenFixed = function(mapGivenTarget)
			{
				_mapGivenTargetWhenFixed = mapGivenTarget;
			}
			this.getGivenTargetWhenFixed = function()
			{
				return _mapGivenTargetWhenFixed;
			}
			
			//调整后的宽度
			this.setAdjusted = function(numAdjusted)
			{
				_numAdjusted = numAdjusted;
			}
			this.getAdjusted = function()
			{
				return _numAdjusted;
			}
			
			//Road前后的坐标值
			this.setCoordinate = function(iBefore, iAfter)
			{
				_iCoordinateBefore = iBefore;
				_iCoordinateAfter = iAfter;
			}
			this.getCoordinateBefore = function()
			{
				return _iCoordinateBefore;
			}
			this.getCoordinateAfter = function()
			{
				return _iCoordinateAfter;
			}
			
			this.toString = function()
			{
				return _iOriginal + "|" + (_bFixed ? "Fixed" : "Adjustable") + "|" + 
					_iCoordinateBefore + "(" + _numAdjusted + ")" + _iCoordinateAfter;
			}
		}
	}
})();