/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.cache;

import com.kingdee.bos.qing.common.cache.AbstractDataSource;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceVisitor;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;

public class SingleFileDataSource
extends AbstractDataSource {
    private String fileName;
    private AbstractQingFileType storeFileType;

    public SingleFileDataSource() {
    }

    public SingleFileDataSource(String fileName, AbstractQingFileType storeFileType) {
        this.fileName = fileName;
        this.storeFileType = storeFileType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public AbstractQingFileType getStoreFileType() {
        return this.storeFileType;
    }

    public void setStoreFileType(AbstractQingFileType storeFileType) {
        this.storeFileType = storeFileType;
    }

    @Override
    public boolean isMetaChanged(AbstractDataSource dataSource) throws AbstractDataSourceException {
        if (!(dataSource instanceof SingleFileDataSource)) {
            return true;
        }
        SingleFileDataSource singleFileDataSource = (SingleFileDataSource)dataSource;
        IQingFileVisitor otherFile = FileFactory.newFileVisitor((AbstractQingFileType)singleFileDataSource.getStoreFileType(), (String)singleFileDataSource.getFileName());
        IQingFileVisitor thisFile = FileFactory.newFileVisitor((AbstractQingFileType)this.getStoreFileType(), (String)this.getFileName());
        if (!otherFile.exists()) {
            return true;
        }
        QSDataSourceVisitor otherQsFile = new QSDataSourceVisitor(otherFile);
        QSDataSourceVisitor thisQsFile = new QSDataSourceVisitor(thisFile);
        MetaInfo otherMetaInfo = otherQsFile.getMetaInfo();
        MetaInfo thisMetaInfo = thisQsFile.getMetaInfo();
        if (otherMetaInfo.getSize() == thisMetaInfo.getSize()) {
            int size = otherMetaInfo.getSize();
            for (int index = 0; index < size; ++index) {
                Boolean newFieldHidType;
                DataType fieldDataType;
                String fieldDisplayName;
                String fieldName;
                String oldFieldName = otherMetaInfo.getFieldName(index);
                if (!oldFieldName.equals(fieldName = thisMetaInfo.getFieldName(index))) {
                    return true;
                }
                String oldFieldDisplayName = otherMetaInfo.getFieldDisplayName(index);
                if (!oldFieldDisplayName.equals(fieldDisplayName = thisMetaInfo.getFieldDisplayName(index))) {
                    return true;
                }
                DataType oldFieldDataType = otherMetaInfo.getFieldDataType(index);
                if (!oldFieldDataType.equals((Object)(fieldDataType = thisMetaInfo.getFieldDataType(index)))) {
                    return true;
                }
                Boolean oldFieldHideType = otherMetaInfo.getFieldIsHides(index);
                if (oldFieldHideType.equals(newFieldHidType = Boolean.valueOf(thisMetaInfo.getFieldIsHides(index)))) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

