/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.cache.DashboardModelBookCache;
import com.kingdee.bos.qing.dashboard.dao.DashboardSerializationUtil;
import com.kingdee.bos.qing.dashboard.domain.CommonDsbDesignDomain;
import com.kingdee.bos.qing.dashboard.exception.DashboardEncryptedLicenseException;
import com.kingdee.bos.qing.dashboard.exception.DashboardException;
import com.kingdee.bos.qing.dashboard.exception.ModelBookTemporaryStorageException;
import com.kingdee.bos.qing.dashboard.exception.NotSelectMapException;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.DashboardModelUtil;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.oplog.DashboardOpLog;
import com.kingdee.bos.qing.dashboard.reference.IPublishable;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.RefHandlerFactory;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.publish.PublishManageDomianFactory;
import com.kingdee.bos.qing.publish.dao.DashboardPublishDao;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.domain.AbstractPublishManageDomain;
import com.kingdee.bos.qing.publish.exception.PublishNotFoundException;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishVO;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schema.dao.ExtReportSchemaManageDao;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.util.OpLogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class PublishedDsbDesignDomain {
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    private QingContext context;
    private IScheduleEngine scheduleEngine;
    private DashboardPublishDao dashboardPublishDao;
    private Map<RefTypeEnum, IRefHandler> refHandlerMap;
    private CommonDsbDesignDomain commonDsbDesignDomain;
    private PublishInfoDao publishInfoDao;
    private SchemaManageDao schemaManageDao;
    private ExtReportSchemaManageDao extRptSchemaManageDao;

    public PublishedDsbDesignDomain(QingContext context, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        this.context = context;
        this.tx = tx;
        this.dbExcuter = dbExcuter;
        this.scheduleEngine = scheduleEngine;
    }

    private DashboardPublishDao getDashboardPublishDao() {
        if (this.dashboardPublishDao == null) {
            this.dashboardPublishDao = new DashboardPublishDao(this.dbExcuter);
        }
        return this.dashboardPublishDao;
    }

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private SchemaManageDao getSchemaManageDao() {
        if (this.schemaManageDao == null) {
            this.schemaManageDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaManageDao;
    }

    private ExtReportSchemaManageDao getExtRptSchemaManageDao() {
        if (this.extRptSchemaManageDao == null) {
            this.extRptSchemaManageDao = new ExtReportSchemaManageDao(this.dbExcuter);
        }
        return this.extRptSchemaManageDao;
    }

    private IRefHandler getRefHandler(RefTypeEnum refType) {
        IRefHandler refHandler;
        if (this.refHandlerMap == null) {
            this.refHandlerMap = new EnumMap<RefTypeEnum, IRefHandler>(RefTypeEnum.class);
        }
        if ((refHandler = this.refHandlerMap.get(refType)) == null) {
            refHandler = RefHandlerFactory.createHandler(refType, this.dbExcuter, this.context, this.tx);
            this.refHandlerMap.put(refType, refHandler);
        }
        return refHandler;
    }

    private CommonDsbDesignDomain getCommonDsbDesignDomain() {
        if (this.commonDsbDesignDomain == null) {
            this.commonDsbDesignDomain = new CommonDsbDesignDomain(this.context, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.commonDsbDesignDomain;
    }

    public DashboardModel loadPublishedDsbModel(String publishId) throws DashboardException, AbstractQingIntegratedException {
        try {
            DashboardModel dashboardModel = null;
            InputStream dashboardModelContent = this.getDashboardPublishDao().loadDsbModelContentStream(publishId);
            if (dashboardModelContent != null) {
                dashboardModel = DashboardSerializationUtil.toModel(dashboardModelContent);
                List<ReferenceMap> refItems = this.getDashboardPublishDao().getRefListForEditDsb(publishId);
                for (int i = 0; i < refItems.size(); ++i) {
                    IRefHandler refHandler;
                    String widgetSourcePath;
                    ReferenceMap refItem = refItems.get(i);
                    String refType = refItem.getRefType();
                    if (!StringUtils.isBlank((CharSequence)((CharSequence)refItem.get((Object)"widgetSourcePath"))) || (widgetSourcePath = (refHandler = this.getRefHandler(RefTypeEnum.valueOf((String)refType))).loadRefFullPath(refItem, this.context.getUserId())) == null) continue;
                    refItem.put((Object)"widgetSourcePath", (Object)widgetSourcePath);
                }
                dashboardModel.fixReferences(refItems);
            }
            return dashboardModel;
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
        catch (EncryptedLicenseCheckException e) {
            throw new DashboardEncryptedLicenseException(e.getMessage(), e.getErrorCode());
        }
    }

    public void savePublishedDsbModel(String publishId, DashboardModel dsbModel) throws AbstractQingException {
        PublishPO publishPO;
        List refItems = dsbModel.pickReferences();
        try {
            this.tx.beginRequired();
            publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(publishId);
            if (publishPO == null) {
                throw new PublishNotFoundException();
            }
            List<ReferenceMap> oldRefItems = this.getDashboardPublishDao().getRefList(publishId);
            this.getPublishInfoDao().updateModifyDate(publishId, this.context.getUserId());
            this.getDashboardPublishDao().updatePublishedDsbContent(publishId, dsbModel);
            for (ReferenceMap refItem : refItems) {
                IRefHandler refHandler = this.getRefHandler(RefTypeEnum.valueOf((String)refItem.getRefType()));
                if (!(refHandler instanceof IPublishable)) continue;
                ((IPublishable)((Object)refHandler)).updatePublishedRef(publishId, refItem);
            }
            this.clearInvalidReference(publishId, refItems, oldRefItems);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new DashboardException((Throwable)e);
        }
        catch (EncryptedLicenseCheckException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (DashboardException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
        try {
            int publishTargetType = publishPO.getPublishTargetType();
            AbstractPublishManageDomain publishManageDomain = PublishManageDomianFactory.getPublishManageDomian((Integer)publishTargetType, (QingContext)this.context, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, null);
            if (publishManageDomain != null) {
                PublishVO publishVO = publishManageDomain.getPublishVO(publishId);
                ArrayList<String> params = new ArrayList<String>(2);
                params.add(publishPO.getName());
                params.add(publishVO.getPathText());
                DashboardOpLog dashboardOpLog = DashboardOpLog.APPMENU_PUBLISH_RECORD_DIR;
                switch (publishTargetType) {
                    case 1: {
                        dashboardOpLog = DashboardOpLog.ANALYSIS_CENTER_PUBLISH_RECORD_DIR;
                        break;
                    }
                    case 2: {
                        dashboardOpLog = DashboardOpLog.LAPP_PUBLISH_RECORD_DIR;
                        break;
                    }
                    case 5: {
                        dashboardOpLog = DashboardOpLog.CARD_PUBLISH_RECORD_DIR;
                        break;
                    }
                }
                dashboardOpLog.setLogScene("\u53d1\u5e03\u8bb0\u5f55");
                OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.EDIT, (IOpLogConstant)dashboardOpLog, params));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearInvalidReference(String publishId, List<ReferenceMap> refItems, List<ReferenceMap> oldRefItems) throws AbstractQingIntegratedException, SQLException {
        for (int i = 0; i < oldRefItems.size(); ++i) {
            RefTypeEnum refType;
            IRefHandler refHandler;
            boolean isDelete = true;
            ReferenceMap oldRefItem = oldRefItems.get(i);
            for (int j = 0; j < refItems.size(); ++j) {
                String uid = refItems.get(j).getUid();
                if (!uid.equals(oldRefItem.getUid())) continue;
                isDelete = false;
                break;
            }
            if (!isDelete || !((refHandler = this.getRefHandler(refType = RefTypeEnum.valueOf((String)oldRefItem.getRefType()))) instanceof IPublishable)) continue;
            ((IPublishable)((Object)refHandler)).deletePublishedRef(publishId, oldRefItem.getUid(), oldRefItem.getRefToId());
        }
    }

    public ModelBook loadSchema(String publishId, ReferenceMap referenceMap, String editSchema) throws AbstractQingIntegratedException, DashboardException {
        String uid = referenceMap.getUid();
        String fileKey = referenceMap.getFileKey();
        DashboardModelBookCache dashboardCache = new DashboardModelBookCache(fileKey);
        ModelBook modelBook = null;
        List<OutsideReference> outsideRef = null;
        try {
            if (dashboardCache.exists()) {
                modelBook = dashboardCache.toModelBook();
                outsideRef = DashboardModelUtil.getOuterRefList(referenceMap);
            } else {
                byte[] schemaContent = this.getDashboardPublishDao().loadRefContent(publishId, uid);
                if (referenceMap.get((Object)"id") == null) {
                    String fid = this.getDashboardPublishDao().getRefPK(publishId, uid);
                    referenceMap.put((Object)"id", (Object)fid);
                }
                outsideRef = this.getDashboardPublishDao().loadSchemaRef((String)referenceMap.get((Object)"id"));
                if (schemaContent != null) {
                    modelBook = DashboardModelUtil.byteToSchemaModel(schemaContent);
                    if ("1".equals(editSchema)) {
                        dashboardCache.setValue(schemaContent);
                        try {
                            dashboardCache.save();
                            if (outsideRef != null) {
                                DashboardModelUtil.cacheOuterRef(referenceMap, outsideRef);
                            }
                        }
                        catch (IOException e) {
                            throw new ModelBookTemporaryStorageException(e);
                        }
                    }
                }
            }
            if (modelBook != null && outsideRef != null && outsideRef.size() > 0) {
                this.getCommonDsbDesignDomain().fixOutSideRefName(outsideRef);
                modelBook.fixReferences(outsideRef);
            }
            return modelBook;
        }
        catch (com.kingdee.bos.qing.core.exception.PersistentModelParseException e) {
            throw PersistentModelParseException.createParseError((Throwable)e);
        }
        catch (PersistentModelTooModernException e) {
            throw PersistentModelParseException.createParseError((Throwable)e);
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
    }

    public void saveSchema(ReferenceMap referenceMap, ModelBook modelBook) throws ModelBookTemporaryStorageException, NotSelectMapException {
        this.getCommonDsbDesignDomain().cacheSquareSchema(referenceMap, modelBook);
    }

    public void longerSaveSchema(ReferenceMap referenceMap, ModelBook modelBook) throws ModelBookTemporaryStorageException {
        this.getCommonDsbDesignDomain().cacheLongerSchema(referenceMap, modelBook);
    }
}

