/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.model;

import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingAppLocalTempFileType;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.QingCenterPathModel;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;

public class DashboardModelUtil {
    public static final String REF_KEY = "id";
    public static final String OUTER_REF_KEY = "outerRefKey";

    public static DashboardModel byteToDashboardModel(byte[] content) throws PersistentModelParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        return DashboardModelUtil.byteToDashboardModel(bais);
    }

    public static DashboardModel byteToDashboardModel(InputStream stream) throws PersistentModelParseException {
        Element xmlNode;
        DashboardModel modelBook = new DashboardModel();
        try {
            xmlNode = XmlUtil.loadRootElement((InputStream)stream);
        }
        catch (Exception e) {
            throw PersistentModelParseException.createParseError((Throwable)e);
        }
        modelBook.fromXml(xmlNode);
        return modelBook;
    }

    public static ModelBook byteToSchemaModel(byte[] content) throws com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException {
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        return DashboardModelUtil.byteToSchemaModel(bais);
    }

    public static ModelBook byteToSchemaModel(InputStream stream) throws com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException {
        Element xmlNode;
        ModelBook modelBook = new ModelBook();
        try {
            xmlNode = XmlUtil.loadRootElement((InputStream)stream);
        }
        catch (Exception e) {
            throw new com.kingdee.bos.qing.core.exception.PersistentModelParseException((Throwable)e);
        }
        modelBook.fromXml(xmlNode);
        return modelBook;
    }

    public static void cacheOuterRef(ReferenceMap referenceMap, List<OutsideReference> outSideRefList) {
        IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
        List<Map<String, String>> outSideRefMap = ImportUtil.createRefMap(outSideRefList);
        qingSession.set((String)referenceMap.get((Object)OUTER_REF_KEY), JsonUtil.encodeToString(outSideRefMap));
    }

    public static List<OutsideReference> getOuterRefList(ReferenceMap referenceMap) {
        IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
        String outSideRef = qingSession.get((String)referenceMap.get((Object)OUTER_REF_KEY));
        List<OutsideReference> outSideRefList = new ArrayList<OutsideReference>();
        if (outSideRef != null) {
            List outSideRefMap = (List)JsonUtil.decodeFromString((String)outSideRef, List.class);
            outSideRefList = ImportUtil.createOutSideRef(outSideRefMap, true);
        }
        return outSideRefList;
    }

    public static ModelBook getFileModelBook(String schemaFileKey) throws com.kingdee.bos.qing.core.exception.PersistentModelParseException {
        try {
            IQingFileVisitor qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingAppLocalTempFileType.LOCAL_TEMP, (String)schemaFileKey);
            return DashboardModelUtil.byteToSchemaModel((InputStream)qingFileVisitor.getInputStream());
        }
        catch (Exception e) {
            throw new com.kingdee.bos.qing.core.exception.PersistentModelParseException((Throwable)e);
        }
    }

    public static String parseFullPath(String fullPath, RefTypeEnum refEnum) {
        String widgetSourcePath;
        block11: {
            widgetSourcePath = "";
            try {
                if (refEnum == RefTypeEnum.qingcenter || refEnum == RefTypeEnum.qingcenter_qing || refEnum == RefTypeEnum.qingcenter_rpt) {
                    QingCenterPathModel qingCenterPathModel = (QingCenterPathModel)JsonUtil.decodeFromString((String)fullPath, QingCenterPathModel.class);
                    if (qingCenterPathModel != null) {
                        if (qingCenterPathModel.getCenterName1() != null) {
                            widgetSourcePath = widgetSourcePath + qingCenterPathModel.getCenterName1() + "/";
                        }
                        if (qingCenterPathModel.getCenterName2() != null) {
                            widgetSourcePath = widgetSourcePath + qingCenterPathModel.getCenterName2() + "/";
                        }
                        if (qingCenterPathModel.getCenterName3() != null) {
                            widgetSourcePath = widgetSourcePath + qingCenterPathModel.getCenterName3() + "/";
                        }
                        if (qingCenterPathModel.getCenterName4() != null) {
                            widgetSourcePath = widgetSourcePath + qingCenterPathModel.getCenterName4() + "/";
                        }
                        widgetSourcePath = widgetSourcePath + qingCenterPathModel.getName();
                    }
                } else {
                    PathModel pathModel = (PathModel)JsonUtil.decodeFromString((String)fullPath, PathModel.class);
                    if (pathModel != null) {
                        widgetSourcePath = pathModel.getGroupName() + "/" + pathModel.getName();
                    }
                }
            }
            catch (Exception e) {
                if (fullPath == null) break block11;
                if (fullPath.contains(NameSpace.user.toPersistance()) || fullPath.contains(NameSpace.system.toPersistance())) {
                    int idx = fullPath.indexOf(47);
                    widgetSourcePath = fullPath.substring(idx + 1);
                }
                widgetSourcePath = fullPath;
            }
        }
        return widgetSourcePath;
    }
}

