/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.reference;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.AbstractSwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.dashboard.dao.DashboardDao;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import java.sql.SQLException;
import java.util.List;

public class DesignTimeDSBUpdateRefPathAndIdHandler
implements AbstractSwitchPathAndIdHandler.IUpdateRefPathAndIdHandler {
    private DashboardDao dashboardDao;
    private QingContext context;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;

    public DesignTimeDSBUpdateRefPathAndIdHandler(QingContext context, ITransactionManagement tx, IDBExcuter dbExcuter) {
        this.context = context;
        this.tx = tx;
        this.dbExcuter = dbExcuter;
    }

    private DashboardDao getDashboardDao() {
        if (this.dashboardDao == null) {
            this.dashboardDao = new DashboardDao(this.dbExcuter);
        }
        return this.dashboardDao;
    }

    public void updateRefPathToId(RefTypeEnum refType, String refPath, String refId, String userId) throws AbstractQingIntegratedException, SQLException {
        String refTypeCondition = refType.name() + "%";
        List<ReferenceMap> refInfo = this.getDashboardDao().loadRefListByFullPath(refPath, refTypeCondition, userId);
        for (ReferenceMap ref : refInfo) {
            ref.setRefToId(refId);
            ref.setRefToFullPath(null);
            this.getDashboardDao().updateRef(ref);
        }
    }

    public void updateRefIdToPath(RefTypeEnum refType, String refPath, String refToId, String userId) throws AbstractQingIntegratedException, SQLException {
        List<ReferenceMap> refInfo = this.getDashboardDao().loadRefListByRefToId(refToId, refType.name(), userId);
        for (int i = 0; i < refInfo.size(); ++i) {
            ReferenceMap ref = refInfo.get(i);
            ref.setRefToId(" ");
            ref.setRefToFullPath(refPath);
            this.getDashboardDao().updateRef(ref);
        }
    }
}

