/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.reference.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.AbstractSwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.publish.PublishManageDomianFactory;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.target.card.dao.PublishCardDao;
import com.kingdee.bos.qing.publish.target.card.domain.AbstractCardManageDomain;
import com.kingdee.bos.qing.publish.target.card.exception.CardException;
import com.kingdee.bos.qing.publish.target.card.model.CardGroupPO;
import com.kingdee.bos.qing.publish.target.card.model.CardVO;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.SQLException;
import java.util.List;

public class CardSwitchPathAndIdHandler
extends AbstractSwitchPathAndIdHandler {
    private PublishCardDao publishCardDao;
    private PublishInfoDao publishInfoDao;
    private AbstractCardManageDomain cardManageDomain;

    public CardSwitchPathAndIdHandler(QingContext context, ITransactionManagement tx, IDBExcuter dbExcuter) {
        super(context, tx, dbExcuter);
    }

    private PublishCardDao getPublishCardDao() {
        if (this.publishCardDao == null) {
            this.publishCardDao = new PublishCardDao(this.context, this.dbExcuter);
        }
        return this.publishCardDao;
    }

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private AbstractCardManageDomain getCardManageDomain() {
        if (this.cardManageDomain == null) {
            this.cardManageDomain = (AbstractCardManageDomain)PublishManageDomianFactory.getPublishManageDomian((Integer)5, (QingContext)this.context, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, null);
        }
        return this.cardManageDomain;
    }

    public String switchRefPathToId(String refPath, String name, String userId) throws AbstractQingIntegratedException, SQLException {
        return this.getPublishCardDao().loadPublishId(refPath, name, userId, 5);
    }

    public String switchRefIdToPath(String refToId, String userId) throws AbstractQingIntegratedException, SQLException {
        PublishPO publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(refToId);
        if (publishPO != null) {
            String publishName = publishPO.getName();
            String cardGroupId = publishPO.getPath();
            CardGroupPO cardGroupPO = this.getPublishCardDao().loadGroupByIdForExport(cardGroupId);
            if (cardGroupPO != null) {
                String nameSpace = publishPO.isPreset() ? NameSpace.system.toPersistance() : NameSpace.user.toPersistance();
                PathModel pathModel = new PathModel();
                pathModel.setNameSpace(nameSpace);
                pathModel.setGroupName(cardGroupPO.getName());
                pathModel.setName(publishName);
                return JsonUtil.encodeToString((Object)pathModel);
            }
        }
        return null;
    }

    public void replacePersistentPathToId(String refPath, String refId, String userId) throws SQLException, AbstractQingIntegratedException {
        this.updateRefPathToId(RefTypeEnum.card, refPath, refId, userId);
    }

    public void replacePersistentIdToPath(String refPath, String refToId, String userId) throws SQLException, AbstractQingIntegratedException {
        this.updateRefIdToPath(RefTypeEnum.card, refPath, refToId, userId);
    }

    public boolean RefIsPreset(String refToId) throws AbstractQingIntegratedException, SQLException {
        PublishPO publishInfo = this.getPublishInfoDao().getPublishInfoByInfoId(refToId);
        if (publishInfo != null) {
            return publishInfo.isPreset();
        }
        return false;
    }

    public String switchRefPathToId(String fullPath, String userId) throws AbstractQingIntegratedException, SQLException {
        PathModel pathModel = (PathModel)JsonUtil.decodeFromString((String)fullPath, PathModel.class);
        if (NameSpace.system.toPersistance().equals(pathModel.getNameSpaceWithSign()) && IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.context, (IDBExcuter)this.dbExcuter)) {
            userId = IntegratedHelper.getPresetUserId();
        }
        String groupName = pathModel.getGroupName();
        String cardName = pathModel.getName();
        String publishId = this.getPublishCardDao().loadPublishId(groupName, cardName, userId, 5);
        if (publishId == null) {
            publishId = this.getAuthorizedPublish(groupName, cardName);
        }
        return publishId;
    }

    public String createEmptyPath() {
        PathModel pathModel = new PathModel();
        pathModel.setGroupName(this.getGroupHasDeleted());
        pathModel.setName(this.getPublishHasDeleted());
        pathModel.setNameSpace(NameSpace.user.toPersistance());
        return JsonUtil.encodeToString((Object)pathModel);
    }

    private boolean isSameFullpath(String groupName, String cardName, CardVO cardVO) {
        if (groupName == null || cardName == null) {
            return false;
        }
        return groupName.equals(cardVO.getPathText()) && cardName.equals(cardVO.getName());
    }

    private String getAuthorizedPublish(String groupName, String cardName) throws AbstractQingIntegratedException {
        String publishId = null;
        try {
            List<CardVO> allPermCards = this.getCardManageDomain().loadAllSelectorPublishInfos(false);
            for (CardVO permCard : allPermCards) {
                if (!this.isSameFullpath(groupName, cardName, permCard)) continue;
                publishId = permCard.getId();
                break;
            }
        }
        catch (CardException e) {
            LogUtil.error((String)"Qing get all user authorized publish info failed when import dashboard", (Throwable)((Object)e));
        }
        return publishId;
    }
}

