/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.reference.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.AbstractSwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.IThemeGroupDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.dao.impl.ThemeGroupDaoImpl;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import java.sql.SQLException;

public class SubjectSwitchPathAndIdHandler
extends AbstractSwitchPathAndIdHandler {
    private IThemeGroupDao iThemeGroupDao;
    private IThemeDao iThemeDao;

    public SubjectSwitchPathAndIdHandler(QingContext context, ITransactionManagement tx, IDBExcuter dbExcuter) {
        super(context, tx, dbExcuter);
    }

    protected IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    protected IThemeGroupDao getThemeGroupDao() {
        if (this.iThemeGroupDao == null) {
            this.iThemeGroupDao = new ThemeGroupDaoImpl(this.dbExcuter);
        }
        return this.iThemeGroupDao;
    }

    public String switchRefPathToId(String refPath, String name, String userId) throws AbstractQingIntegratedException, SQLException {
        ThemeGroupVO themeGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupName(userId, refPath);
        if (themeGroupVO != null) {
            String themeGroupId = themeGroupVO.getThemeGroupID();
            ThemeVO themeVO = this.getThemeDao().loadThemeByName(userId, themeGroupId, name, "0");
            if (themeVO != null) {
                return themeVO.getThemeID();
            }
        }
        return null;
    }

    public String switchRefIdToPath(String refToId, String userId) throws AbstractQingIntegratedException, SQLException {
        ThemePO themePO = this.getThemeDao().getThemeByID(refToId);
        if (themePO != null) {
            String queryUserId = themePO.isPreset() ? IntegratedHelper.getPresetUserId() : userId;
            ThemeGroupVO themeGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupId(queryUserId, themePO.getGroupID());
            if (themeGroupVO != null) {
                String nameSpace = themePO.isPreset() ? NameSpace.system.toPersistance() : NameSpace.user.toPersistance();
                PathModel pathModel = new PathModel();
                pathModel.setNameSpace(nameSpace);
                pathModel.setGroupName(themeGroupVO.getThemeGroupName());
                pathModel.setName(themePO.getThemeName());
                return JsonUtil.encodeToString((Object)pathModel);
            }
        }
        return null;
    }

    public void replacePersistentPathToId(String refPath, String refId, String userId) throws SQLException, AbstractQingIntegratedException {
        this.updateRefPathToId(RefTypeEnum.subject, refPath, refId, userId);
    }

    public void replacePersistentIdToPath(String refPath, String refToId, String userId) throws SQLException, AbstractQingIntegratedException {
        this.updateRefIdToPath(RefTypeEnum.subject, refPath, refToId, userId);
    }

    public boolean RefIsPreset(String refToId) throws AbstractQingIntegratedException, SQLException {
        ThemePO themePO = this.getThemeDao().getThemeByID(refToId);
        if (themePO != null) {
            return themePO.isPreset();
        }
        return false;
    }

    public String switchRefPathToId(String fullPath, String userId) throws AbstractQingIntegratedException, SQLException {
        ThemeGroupVO themeGroupVO;
        PathModel pathModel = (PathModel)JsonUtil.decodeFromString((String)fullPath, PathModel.class);
        if (NameSpace.system.toPersistance().equals(pathModel.getNameSpaceWithSign()) && IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.context, (IDBExcuter)this.dbExcuter)) {
            userId = IntegratedHelper.getPresetUserId();
        }
        if ((themeGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupName(userId, pathModel.getGroupName())) != null) {
            String themeGroupId = themeGroupVO.getThemeGroupID();
            ThemeVO themeVO = this.getThemeDao().loadThemeByName(userId, themeGroupId, pathModel.getName(), "0");
            if (themeVO != null) {
                return themeVO.getThemeID();
            }
        }
        return null;
    }

    public String createEmptyPath() {
        return null;
    }
}

