/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imagelibrary;

import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.imagelibrary.domian.ImageLibraryDomain;
import com.kingdee.bos.qing.imagelibrary.model.ImageModel;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ImageLibraryService
implements IQingContextable,
IDBAccessable {
    private static final String IMAGE_FILE_NAME = "imageFileName";
    private static final String CATEGORY_ID = "categoryId";
    private QingContext context;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private ImageLibraryDomain imageLibraryDomain;

    public void setQingContext(QingContext qingContext) {
        this.context = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    private ImageLibraryDomain getImageLibraryDomain() {
        if (this.imageLibraryDomain == null) {
            this.imageLibraryDomain = new ImageLibraryDomain();
            this.imageLibraryDomain.setDbExcuter(this.dbExcuter);
            this.imageLibraryDomain.setTx(this.tx);
            this.imageLibraryDomain.setQingContext(this.context);
        }
        return this.imageLibraryDomain;
    }

    public byte[] deleteImage(Map<String, String> params) {
        ImageModel imageModel = (ImageModel)JsonUtil.decodeFromString((String)params.get("model"), ImageModel.class);
        imageModel.setUserId(this.context.getUserId());
        try {
            this.getImageLibraryDomain().deleteImage(imageModel);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)Boolean.TRUE));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadImage(Map<String, String> params) {
        String fileName = params.get(IMAGE_FILE_NAME);
        try {
            return this.getImageLibraryDomain().loadImage(fileName);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] saveOrUpdateCategory(Map<String, String> params) {
        String categoryId = params.get(CATEGORY_ID);
        String categoryName = params.get("categoryName");
        String userId = this.context.getUserId();
        try {
            String fId = this.getImageLibraryDomain().saveOrUpdateCategory(userId, categoryId, categoryName);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)fId);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] deleteCategory(Map<String, String> params) {
        String categoryId = params.get(CATEGORY_ID);
        String categoryName = params.get("categoryName");
        try {
            this.getImageLibraryDomain().deleteCategory(categoryId, categoryName);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)Boolean.TRUE);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] saveImageInfo(Map<String, String> params) {
        ImageModel imageModel = (ImageModel)JsonUtil.decodeFromString((String)params.get("model"), ImageModel.class);
        String userId = this.context.getUserId();
        String thumbnailFileName = UUID.randomUUID().toString();
        imageModel.setThumbnailFileName(thumbnailFileName);
        imageModel.setUserId(userId);
        try {
            this.getImageLibraryDomain().saveImageInfo(imageModel);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)imageModel);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getAllCategory(Map<String, String> params) {
        String userId = this.context.getUserId();
        try {
            List<Map<String, String>> categorys = this.getImageLibraryDomain().getAllCategory(userId);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(categorys);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getAllImageOfCategory(Map<String, String> params) {
        try {
            String categoryId = params.get(CATEGORY_ID);
            boolean isPreset = "true".equals(params.get("isPreset"));
            List<ImageModel> images = this.getImageLibraryDomain().getAllImageOfCategory(categoryId, isPreset);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(images);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] updateImageName(Map<String, String> params) {
        String newImageName = params.get("imageName");
        ImageModel imageModel = (ImageModel)JsonUtil.decodeFromString((String)params.get("imageModel"), ImageModel.class);
        String userId = this.context.getUserId();
        try {
            this.getImageLibraryDomain().updateImageName(newImageName, imageModel, userId);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)Boolean.TRUE);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getRefTimeOfImage(Map<String, String> params) {
        String imageFileName = params.get(IMAGE_FILE_NAME);
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getImageLibraryDomain().getRefTimeOfImage(imageFileName));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getImageModelByImageFileName(Map<String, String> params) {
        String imageFileName = params.get(IMAGE_FILE_NAME);
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getImageLibraryDomain().getImageModelByImageFileName(imageFileName));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadImageModelByImagePath(Map<String, String> params) {
        String imagePath = params.get("imagePath");
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getImageLibraryDomain().loadImageModelByImagePath(imagePath));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

