/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.exporter.common.publishtarget;

import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.imexport.exporter.common.publishtarget.AbstractPublishExporter;
import com.kingdee.bos.qing.imexport.exporter.exception.ExportException;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.target.PublishToCard;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.target.card.dao.PublishCardDao;
import com.kingdee.bos.qing.publish.target.card.model.CardGroupPO;
import com.kingdee.bos.qing.publish.target.card.model.CardVO;
import java.io.IOException;
import java.sql.SQLException;

public class CardExporter
extends AbstractPublishExporter {
    private PublishCardDao cardDao;

    private PublishCardDao getPublishCardDao() {
        if (this.cardDao == null) {
            this.cardDao = new PublishCardDao(this.qingContext, this.dbExcuter);
        }
        return this.cardDao;
    }

    @Override
    public void exportTarget(AbstractPublishObject publishObj, PublishPO publishPO, PackageMeta meta) throws ExportException, SQLException, AbstractQingException, IOException {
        String publishId = publishPO.getId();
        PublishToCard publishToCard = new PublishToCard();
        CardVO cardInfo = this.getPublishCardDao().loadPublishCardBaseInfo(publishId);
        CardGroupPO cardGroupPO = this.getPublishCardDao().loadGroupByIdForExport(publishPO.getPath());
        if (cardGroupPO != null) {
            publishToCard.setPath(cardGroupPO.getName());
            publishToCard.setTargetType(publishPO.getPublishTargetType());
            if (cardInfo != null) {
                publishToCard.setDesc(cardInfo.getCardDesc());
                String imagePath = cardInfo.getImagePath();
                if (imagePath != null) {
                    publishToCard.setThumbnail(cardInfo.getImagePath());
                    meta.getResources().getThumbnailImagePaths().add(cardInfo.getImagePath());
                }
            }
            publishObj.setPublishTarget(publishToCard);
        }
    }
}

