/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.exporter.pkg.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.dao.DashboardDao;
import com.kingdee.bos.qing.dashboard.dao.DashboardSerializationUtil;
import com.kingdee.bos.qing.dashboard.domain.DashboardDesignDomain;
import com.kingdee.bos.qing.dashboard.domain.DashboardRuntimeDomain;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.ModelPersistenceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.source.IFileSavable;
import com.kingdee.bos.qing.imagelibrary.exception.QingImglibException;
import com.kingdee.bos.qing.imexport.exporter.common.AbstractExportDomain;
import com.kingdee.bos.qing.imexport.exporter.common.publishtarget.AbstractPublishExporter;
import com.kingdee.bos.qing.imexport.exporter.common.publishtarget.PublishExporterFactory;
import com.kingdee.bos.qing.imexport.exporter.exception.ExportException;
import com.kingdee.bos.qing.imexport.exporter.pkg.domain.LappExporter;
import com.kingdee.bos.qing.imexport.exporter.pkg.domain.integration.IntegrationCollectHelper;
import com.kingdee.bos.qing.imexport.model.Environment;
import com.kingdee.bos.qing.imexport.model.MetaTypeEnum;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.SchemaInfo;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.dashboard.DashboardObject;
import com.kingdee.bos.qing.imexport.model.dashboard.DsbRefObject;
import com.kingdee.bos.qing.imexport.model.embeddeddata.EmbeddedBillInfoObject;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.LongerSquarePublishObject;
import com.kingdee.bos.qing.imexport.model.publish.dashboard.DashboardQsInfo;
import com.kingdee.bos.qing.imexport.model.publish.dashboard.DsbCarryDataInfo;
import com.kingdee.bos.qing.imexport.model.publish.dashboard.DsbDataModelObject;
import com.kingdee.bos.qing.imexport.model.publish.dashboard.DsbPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.embedded.EmbeddedPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.subject.SubjectCarryDataInfo;
import com.kingdee.bos.qing.imexport.model.subject.AnalysisObject;
import com.kingdee.bos.qing.imexport.model.subject.DataModelingObject;
import com.kingdee.bos.qing.imexport.model.subject.SubjectObject;
import com.kingdee.bos.qing.imexport.model.subject.SubjectQsInfo;
import com.kingdee.bos.qing.imexport.oplog.ImexportOpLog;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.macro.domain.MacroCommonDomain;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.IThemeGroupDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.dao.impl.ThemeGroupDaoImpl;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.exception.ThemeManagementException;
import com.kingdee.bos.qing.manage.exception.ThemeNotFoundException;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.map.imexport.model.ExportMapModel;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.publish.dao.BillManagerDao;
import com.kingdee.bos.qing.publish.dao.DashboardPublishDao;
import com.kingdee.bos.qing.publish.dao.PublishDsbRefBillFileDao;
import com.kingdee.bos.qing.publish.dao.PublishDsbRefSubjectFileDao;
import com.kingdee.bos.qing.publish.dao.PublishDsbRefSubjectModelDao;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.dao.PublishOperPermissionsDao;
import com.kingdee.bos.qing.publish.dao.PublishPermissionDao;
import com.kingdee.bos.qing.publish.dao.PublishSubjectFileDao;
import com.kingdee.bos.qing.publish.dao.PublishSubjectModelDao;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.model.PublishDsbRefBillFile;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSubjectFilePO;
import com.kingdee.bos.qing.publish.target.lapp.util.LappHelper;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.subject.dao.BoxSerializationUtil;
import com.kingdee.bos.qing.subject.dao.ISubjectDao;
import com.kingdee.bos.qing.subject.dao.impl.SubjectDaoImpl;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.OpLogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jdom2.JDOMException;

public class ExportPKGDomain
extends AbstractExportDomain {
    private static final String SCENE_TYPE = "pkg";
    private IThemeDao iThemeDao;
    private ISubjectDao iSubjectDao;
    private SchemaManageDao schemaDao;
    private IThemeGroupDao themeGroupDao;
    private DashboardDao dashboardDao;
    private DashboardPublishDao dashboardPublishDao;
    private DashboardDesignDomain dashboardDesignDomain;
    private CommonPublishDomain commonPublishDomain;
    private PublishPermissionDao publishPermissionDao;
    private DashboardRuntimeDomain dashboardRuntimeDomain;
    private PublishSubjectFileDao publishSubjectFileDao;
    private PublishSubjectModelDao publishSubjectModelDao;
    private PublishInfoDao publishInfoDao;
    private LappExporter lappExporter;
    private MacroCommonDomain macroDomain;
    private PublishOperPermissionsDao publishOperPermissionsDao;
    private PublishDsbRefSubjectModelDao publishDsbRefSubjectModelDao;
    private PublishDsbRefSubjectFileDao publishDsbRefSubjectFileDao;
    private PublishDsbRefBillFileDao publishDsbRefBillFileDao;
    private BillManagerDao billManagerDao;

    private BillManagerDao getBillManagerDao() {
        if (this.billManagerDao == null) {
            this.billManagerDao = new BillManagerDao(this.dbExcuter);
        }
        return this.billManagerDao;
    }

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private DashboardPublishDao getDashboardPublishDao() {
        if (this.dashboardPublishDao == null) {
            this.dashboardPublishDao = new DashboardPublishDao(this.dbExcuter);
        }
        return this.dashboardPublishDao;
    }

    private PublishDsbRefSubjectModelDao getPublishDsbRefSubjectModelDao() {
        if (this.publishDsbRefSubjectModelDao == null) {
            this.publishDsbRefSubjectModelDao = new PublishDsbRefSubjectModelDao(this.dbExcuter);
        }
        return this.publishDsbRefSubjectModelDao;
    }

    private PublishDsbRefSubjectFileDao getPublishDsbRefSubjectFileDao() {
        if (this.publishDsbRefSubjectFileDao == null) {
            this.publishDsbRefSubjectFileDao = new PublishDsbRefSubjectFileDao(this.dbExcuter);
        }
        return this.publishDsbRefSubjectFileDao;
    }

    private PublishDsbRefBillFileDao getPublishDsbRefBillFileDao() {
        if (this.publishDsbRefBillFileDao == null) {
            this.publishDsbRefBillFileDao = new PublishDsbRefBillFileDao(this.dbExcuter);
        }
        return this.publishDsbRefBillFileDao;
    }

    private LappExporter getLappExporter() {
        if (this.lappExporter == null) {
            this.lappExporter = new LappExporter();
            this.lappExporter.setQingContext(this.qingContext);
            this.lappExporter.setDbExcuter(this.dbExcuter);
            this.lappExporter.setTx(this.tx);
            this.lappExporter.setScheduleEngine(this.scheduleEngine);
        }
        return this.lappExporter;
    }

    private PublishSubjectModelDao getPublishSubjectModelDao() {
        if (this.publishSubjectModelDao == null) {
            this.publishSubjectModelDao = new PublishSubjectModelDao(this.dbExcuter);
        }
        return this.publishSubjectModelDao;
    }

    private PublishSubjectFileDao getPublishSubjectFileDao() {
        if (this.publishSubjectFileDao == null) {
            this.publishSubjectFileDao = new PublishSubjectFileDao(this.dbExcuter);
        }
        return this.publishSubjectFileDao;
    }

    private IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    private ISubjectDao getSubjectDao() {
        if (this.iSubjectDao == null) {
            this.iSubjectDao = new SubjectDaoImpl(this.dbExcuter);
        }
        return this.iSubjectDao;
    }

    private SchemaManageDao getSchemaDao() {
        if (this.schemaDao == null) {
            this.schemaDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaDao;
    }

    private IThemeGroupDao getThemeGroupDao() {
        if (this.themeGroupDao == null) {
            this.themeGroupDao = new ThemeGroupDaoImpl(this.dbExcuter);
        }
        return this.themeGroupDao;
    }

    private DashboardDesignDomain getDashboardDesignDomain() {
        if (this.dashboardDesignDomain == null) {
            this.dashboardDesignDomain = new DashboardDesignDomain(this.qingContext, this.tx, this.dbExcuter, null);
        }
        return this.dashboardDesignDomain;
    }

    private DashboardDao getDashboardDao() {
        if (this.dashboardDao == null) {
            this.dashboardDao = new DashboardDao(this.dbExcuter);
        }
        return this.dashboardDao;
    }

    private CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    private PublishPermissionDao getPublishPermissionDao() {
        if (this.publishPermissionDao == null) {
            this.publishPermissionDao = new PublishPermissionDao(this.dbExcuter);
        }
        return this.publishPermissionDao;
    }

    private DashboardRuntimeDomain getDashboardRuntimeDomain() {
        if (this.dashboardRuntimeDomain == null) {
            this.dashboardRuntimeDomain = new DashboardRuntimeDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.dashboardRuntimeDomain;
    }

    private MacroCommonDomain getMacroDomain() {
        if (this.macroDomain == null) {
            this.macroDomain = new MacroCommonDomain(this.dbExcuter, this.qingContext);
        }
        return this.macroDomain;
    }

    private AbstractPublishExporter getPublishExporter(int type) {
        AbstractPublishExporter abstractPublishExporter = PublishExporterFactory.getPublishExporter(type);
        abstractPublishExporter.setDbExcuter(this.dbExcuter);
        abstractPublishExporter.setQingContext(this.qingContext);
        abstractPublishExporter.setTx(this.tx);
        return abstractPublishExporter;
    }

    private PublishOperPermissionsDao getPublishOperPermissionsDao() {
        if (this.publishOperPermissionsDao == null) {
            this.publishOperPermissionsDao = new PublishOperPermissionsDao(this.dbExcuter);
        }
        return this.publishOperPermissionsDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doHiddenExport(List<String> selectedPublishModelIds) throws SQLException, AbstractQingException, IOException, JDOMException {
        PackageMeta packageMeta = null;
        try {
            packageMeta = this.executeHiddenExport(selectedPublishModelIds);
            String string = this.exportZip(packageMeta);
            return string;
        }
        finally {
            try {
                if (packageMeta != null) {
                    packageMeta.endCleanFiles();
                }
            }
            catch (Exception e) {
                LogUtil.error((String)"fail to endCleanFiles.", (Throwable)e);
            }
        }
    }

    private PackageMeta executeHiddenExport(List<String> selectedPublishModelIds) throws SQLException, AbstractQingException, IOException, JDOMException {
        PackageMeta meta = new PackageMeta();
        meta.setType(MetaTypeEnum.pkg.name());
        meta.setVersion("20200808");
        meta.setEnvironment(new Environment.Builder().setSceneType(SCENE_TYPE).createHasEnvironment(this.qingContext));
        List<AbstractPublishObject> publishObjs = this.getBillPublishObjs(selectedPublishModelIds, meta);
        meta.setPublishObjs(publishObjs);
        IntegrationCollectHelper.collect(meta);
        return meta;
    }

    private List<AbstractPublishObject> getBillPublishObjs(List<String> selectedPublishModelIds, PackageMeta meta) throws SQLException, AbstractQingException, IOException {
        ArrayList<AbstractPublishObject> publishObjs = new ArrayList<AbstractPublishObject>(10);
        for (String publishId : selectedPublishModelIds) {
            PublishPO publishPO = this.getCommonPublishDomain().loadPublishInfo(publishId);
            EmbeddedPublishObject billPublishObj = new EmbeddedPublishObject();
            billPublishObj.setPublishPO(publishPO);
            List permissionInfos = this.getPublishPermissionDao().loadPublishPermissionInfo(publishId);
            billPublishObj.setPermissionObjs(ImExportUtil.getPermissionObjs(permissionInfos));
            List publishOperPermissionsPOList = this.getPublishOperPermissionsDao().loadPubOperByPubId(publishId);
            billPublishObj.setPublishOperPermissionsObjects(ImExportUtil.getPublishOperObjs(publishOperPermissionsPOList));
            this.getPublishExporter(publishPO.getPublishTargetType()).exportTarget(billPublishObj, publishPO, meta);
            if (billPublishObj.getPublishTarget() == null) continue;
            List<SchemaObject> schemaObjs = this.getSchemaObjs(publishId, meta);
            billPublishObj.setSchemaObjs(schemaObjs);
            EmbeddedBillInfoObject embeddedBillInfoObject = this.getBillManagerDao().getBillCtrlKeyAndFilter(publishId);
            String billFilterTempFileName = ImExportUtil.writeBytesToExportTempFile(embeddedBillInfoObject.getFilterInfo());
            embeddedBillInfoObject.setFilterContent(billFilterTempFileName);
            billPublishObj.setEmbeddedBillInfoObject(embeddedBillInfoObject);
            publishObjs.add(billPublishObj);
        }
        return publishObjs;
    }

    private List<SchemaObject> getSchemaObjs(String publishId, PackageMeta meta) throws AbstractQingIntegratedException, SQLException, IOException {
        ArrayList<SchemaObject> schemaObjs = new ArrayList<SchemaObject>(10);
        ArrayList<SchemaBO> schemaList = this.getAllPublishSchemaAttrs(publishId, this.qingContext.getUserId());
        for (SchemaBO schemaBO : schemaList) {
            SchemaObject schemaObj = new SchemaObject();
            SchemaInfo schemaInfo = new SchemaInfo();
            schemaInfo.setSchemaBO(schemaBO);
            byte[] schemaContent = this.getSchemaDao().loadSchemaContent(schemaBO.getfId());
            String schemaContentFileName = ImExportUtil.writeBytesToExportTempFile(schemaContent);
            schemaInfo.setSchemaContentFile(schemaContentFileName);
            schemaObj.setSchemaInfo(schemaInfo);
            List<OutsideReference> outSideRefList = this.getSchemaDao().loadSchemaRef(schemaBO.getfId());
            if (outSideRefList != null && !outSideRefList.isEmpty()) {
                for (int k = 0; k < outSideRefList.size(); ++k) {
                    OutsideReference outsideReference = outSideRefList.get(k);
                    String mapId = outsideReference.getRefToId();
                    PathModel pathModel = new PathModel();
                    if (mapId != null) {
                        ExportMapModel mapVO = this.getMapManageDao().loadMapWithGroupName(mapId);
                        if (mapVO != null) {
                            pathModel.setNameSpace(NameSpace.getNameSpace((String)mapVO.getNameSpace()).toPersistance());
                            pathModel.setGroupName(mapVO.getMapGroupName());
                            pathModel.setName(mapVO.getMapName());
                            outsideReference.setRefToFullPath(JsonUtil.encodeToString((Object)pathModel));
                        }
                        meta.getResources().getMapIds().add(mapId);
                        continue;
                    }
                    try {
                        JsonUtil.decodeFromString((String)outsideReference.getRefToFullPath(), PathModel.class);
                        continue;
                    }
                    catch (Exception e) {
                        String[] path = StringUtils.split((String)outsideReference.getRefToFullPath(), (char)'/');
                        if (path.length < 3) continue;
                        pathModel.setNameSpace(path[0]);
                        pathModel.setGroupName(path[1]);
                        pathModel.setName(path[2]);
                        outsideReference.setRefToFullPath(JsonUtil.encodeToString((Object)pathModel));
                    }
                }
                schemaObj.setOutSideRefs(outSideRefList);
            }
            schemaObjs.add(schemaObj);
        }
        return schemaObjs;
    }

    @Override
    public PackageMeta export(Map<String, String> params) throws SQLException, AbstractQingException, IOException, JDOMException {
        ThemeGroupVO groupVO;
        ThemeVO themeVO;
        List subjectList = (List)JsonUtil.decodeFromString((String)params.get("subjectList"), List.class);
        List dsbList = (List)JsonUtil.decodeFromString((String)params.get("dsbList"), List.class);
        PackageMeta meta = new PackageMeta();
        meta.setType(MetaTypeEnum.pkg.name());
        meta.setVersion("20200808");
        meta.setEnvironment(new Environment.Builder().setSceneType(SCENE_TYPE).createHasEnvironment(this.qingContext));
        boolean withPublish = Boolean.parseBoolean(params.get("withPublish"));
        List<SubjectObject> subjectObjes = this.getSubjectObjs(subjectList, meta);
        List<DashboardObject> dashboardObjs = this.getDashboardObjs(dsbList, meta);
        meta.setSubjectObjs(subjectObjes);
        meta.setDashboardObjs(dashboardObjs);
        if (withPublish) {
            boolean connAvailable = LappHelper.isConnAvailable();
            Map<String, Map<String, String>> lappAnalysisInfos = this.getAllLappPublishInfo(meta, subjectList, dsbList, connAvailable);
            List<AbstractPublishObject> subjectPublishObjs = this.getSubjectPublishObjs(subjectList, meta, lappAnalysisInfos, connAvailable);
            List<AbstractPublishObject> dsbPublishObjs = this.getDsbPublishObjs(dsbList, meta, lappAnalysisInfos, connAvailable);
            subjectPublishObjs.addAll(dsbPublishObjs);
            meta.setPublishObjs(subjectPublishObjs);
        }
        IntegrationCollectHelper.collect(meta);
        int subjectSize = subjectObjes.size();
        int dashBoardSize = dashboardObjs.size();
        ArrayList<String> logParams = new ArrayList<String>(3);
        ImexportOpLog qingAnalysisGroupDir = ImexportOpLog.QING_ANALYSIS_GROUP_DIR;
        qingAnalysisGroupDir.setParamsDesc("\u201c$param\u201d");
        if (subjectSize > 0) {
            themeVO = subjectObjes.get(0).getThemeVO();
            groupVO = subjectObjes.get(0).getThemeGroupVO();
            qingAnalysisGroupDir.setLogScene("\u4e1a\u52a1\u4e3b\u9898");
        } else {
            themeVO = dashboardObjs.get(0).getThemeVO();
            groupVO = dashboardObjs.get(0).getThemeGroupVO();
            qingAnalysisGroupDir.setLogScene("\u4eea\u8868\u677f");
        }
        logParams.add(themeVO.getThemeName());
        logParams.add(groupVO.getThemeGroupName());
        if (subjectSize + dashBoardSize > 1) {
            logParams.add(subjectSize + dashBoardSize + "");
            qingAnalysisGroupDir = ImexportOpLog.QING_ANALYSIS_GROUPS_DIR;
            qingAnalysisGroupDir.setLogScene(subjectSize > 0 ? "\u4e1a\u52a1\u4e3b\u9898" : "\u4eea\u8868\u677f");
            qingAnalysisGroupDir.setParamsDesc("\u201c$param\u201d");
        }
        OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.EXPORT, (IOpLogConstant)qingAnalysisGroupDir, logParams));
        return meta;
    }

    private List<SubjectObject> getSubjectObjs(List<String> subjectList, PackageMeta meta) throws AbstractQingIntegratedException, SQLException, ThemeManagementException, ModelParseException, com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException, IOException, ModelPersistenceException {
        String userId = this.qingContext.getUserId();
        ArrayList<SubjectObject> subjectObjes = new ArrayList<SubjectObject>(10);
        for (int i = 0; i < subjectList.size(); ++i) {
            String subjectId = subjectList.get(i);
            SubjectObject subjectObj = new SubjectObject();
            ThemeVO subjectVo = this.getThemeDao().loadThemeIncludePreset(userId, subjectId);
            if (subjectVo == null) {
                throw new ThemeNotFoundException();
            }
            subjectObj.setThemeVO(subjectVo);
            ThemeGroupVO themeGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupId(this.qingContext.getUserId(), subjectVo.getThemeGroupID());
            subjectObj.setThemeGroupVO(themeGroupVO);
            DataModelingObject dataModelingObj = new DataModelingObject();
            Box box = null;
            try {
                box = this.getSubjectDao().loadSubjectModelIncludePreset(this.qingContext.getUserId(), subjectVo.getThemeID());
            }
            catch (EncryptedLicenseCheckException e) {
                String errorMsg = Messages.getMLS((QingContext)this.qingContext, (String)"unableToExport", (String)"\u65e0\u6cd5\u5bfc\u51fa", (Messages.ProjectName)Messages.ProjectName.QING_THEME);
                throw new EncryptedLicenseCheckException((String)errorMsg + "\"" + themeGroupVO.getThemeGroupName() + "/" + subjectVo.getThemeName() + "\", " + e.getMessage());
            }
            if (box != null) {
                List macroUids = box.collectMacroUid();
                for (String macroUid : macroUids) {
                    meta.getResources().addMacroUid(macroUid);
                }
                InputStream dbStream = this.getSubjectDao().loadSubjectModelStream(this.qingContext.getUserId(), subjectVo.getThemeID());
                byte[] boxBytes = BoxSerializationUtil.toBytes(box, null, dbStream);
                String boxTempFileName = ImExportUtil.writeBytesToExportTempFile(boxBytes);
                dataModelingObj.setBoxFileName(boxTempFileName);
                if (box.getSources() != null && !box.getSources().isEmpty()) {
                    HashSet<String> hashSet = new HashSet<String>(16);
                    for (AbstractSource source : box.getSources()) {
                        if (!(source instanceof IFileSavable)) continue;
                        IFileSavable iFileSavable = (IFileSavable)source;
                        String fileUrl = ((IFileSavable)source).getFileUrl();
                        String fileName = iFileSavable.getFileName();
                        String fileExtension = "";
                        if (fileName.indexOf(".") > -1) {
                            fileExtension = fileName.substring(fileName.lastIndexOf("."));
                        }
                        hashSet.add(fileUrl + fileExtension);
                    }
                    dataModelingObj.setDsFileNames(hashSet);
                }
            }
            subjectObj.setDataModelingObj(dataModelingObj);
            AnalysisObject analysisObj = new AnalysisObject();
            ArrayList<SchemaObject> schemaObjs = new ArrayList<SchemaObject>(10);
            ArrayList<Object> schemaList = new ArrayList(10);
            schemaList = this.getSchemaDao().getSchemaByBiztag(subjectVo.getThemeID(), userId);
            for (SchemaBO schemaBO : schemaList) {
                SchemaObject schemaObj = new SchemaObject();
                SchemaInfo schemaInfo = new SchemaInfo();
                schemaInfo.setSchemaBO(schemaBO);
                byte[] schemaContent = this.getSchemaDao().loadSchemaContent(schemaBO.getfId());
                String schemaContentFileName = ImExportUtil.writeBytesToExportTempFile(schemaContent);
                schemaInfo.setSchemaContentFile(schemaContentFileName);
                schemaObj.setSchemaInfo(schemaInfo);
                List<OutsideReference> outSideRefList = this.getSchemaDao().loadSchemaRef(schemaBO.getfId());
                if (outSideRefList != null && !outSideRefList.isEmpty()) {
                    for (int j = 0; j < outSideRefList.size(); ++j) {
                        OutsideReference outsideReference = outSideRefList.get(j);
                        String mapId = outsideReference.getRefToId();
                        PathModel pathModel = new PathModel();
                        if (mapId != null) {
                            ExportMapModel mapVO = this.getMapManageDao().loadMapWithGroupName(mapId);
                            if (mapVO != null) {
                                pathModel.setNameSpace(NameSpace.getNameSpace((String)mapVO.getNameSpace()).toPersistance());
                                pathModel.setGroupName(mapVO.getMapGroupName());
                                pathModel.setName(mapVO.getMapName());
                                outsideReference.setRefToFullPath(JsonUtil.encodeToString((Object)pathModel));
                            }
                            meta.getResources().getMapIds().add(mapId);
                            continue;
                        }
                        try {
                            JsonUtil.decodeFromString((String)outsideReference.getRefToFullPath(), PathModel.class);
                            continue;
                        }
                        catch (Exception e) {
                            String[] path = StringUtils.split((String)outsideReference.getRefToFullPath(), (char)'/');
                            if (path.length < 3) continue;
                            pathModel.setNameSpace(path[0]);
                            pathModel.setGroupName(path[1]);
                            pathModel.setName(path[2]);
                            outsideReference.setRefToFullPath(JsonUtil.encodeToString((Object)pathModel));
                        }
                    }
                    schemaObj.setOutSideRefs(outSideRefList);
                }
                schemaObjs.add(schemaObj);
            }
            analysisObj.setSchemaObjs(schemaObjs);
            subjectObj.setAnalysisObj(analysisObj);
            subjectObjes.add(subjectObj);
        }
        return subjectObjes;
    }

    private List<AbstractPublishObject> getSubjectPublishObjs(List<String> subjectList, PackageMeta meta, Map<String, Map<String, String>> lappAnalysisInfos, boolean connAvailable) throws SQLException, ExportException, AbstractQingException, IOException, JDOMException {
        ArrayList<AbstractPublishObject> publishObjs = new ArrayList<AbstractPublishObject>();
        String userId = this.qingContext.getUserId();
        for (int i = 0; i < subjectList.size(); ++i) {
            String subjectId = subjectList.get(i);
            List publishPOs = this.getCommonPublishDomain().loadAllPublishInfosWithoutPushAndLightApp(subjectId, userId);
            List lappPublishPOs = this.getPublishInfoDao().loadPublishInfos(subjectId, 2, userId);
            List lappPushPublishPOs = this.getPublishInfoDao().loadLappPushPublishInfos(subjectId, 2, userId);
            for (PublishPO publishPO : lappPublishPOs) {
                if (lappPushPublishPOs.contains(publishPO.getId())) continue;
                publishPOs.add(publishPO);
            }
            for (int j = 0; j < publishPOs.size(); ++j) {
                PublishPO publishPO;
                publishPO = (PublishPO)publishPOs.get(j);
                String publishId = publishPO.getId();
                LongerSquarePublishObject subjectPublishObj = new LongerSquarePublishObject();
                subjectPublishObj.setPublishPO(publishPO);
                List permissionInfos = this.getPublishPermissionDao().loadPublishPermissionInfo(publishId);
                subjectPublishObj.setPermissionObjs(ImExportUtil.getPermissionObjs(permissionInfos));
                List publishOperPermissionsPOList = this.getPublishOperPermissionsDao().loadPubOperByPubId(publishId);
                subjectPublishObj.setPublishOperPermissionsObjects(ImExportUtil.getPublishOperObjs(publishOperPermissionsPOList));
                if (publishPO.getPublishTargetType() == 2) {
                    Map<String, String> lappAnalysisInfo;
                    if (!connAvailable || (lappAnalysisInfo = lappAnalysisInfos.get(publishId)) == null) continue;
                    publishPO.setName(lappAnalysisInfo.get("name"));
                    this.getLappExporter().doExport(subjectPublishObj, publishPO, meta, lappAnalysisInfo);
                } else {
                    this.getPublishExporter(publishPO.getPublishTargetType()).exportTarget(subjectPublishObj, publishPO, meta);
                }
                if (subjectPublishObj.getPublishTarget() == null) continue;
                List<SchemaObject> schemaObjs = this.getSchemaObjs(publishId, meta);
                if (publishPO.isCarryData()) {
                    SubjectCarryDataInfo subjectCarryDataInfo = this.loadCarryDataInfo(publishPO);
                    subjectPublishObj.setCarryDataInfo(subjectCarryDataInfo);
                }
                subjectPublishObj.setSchemaObjs(schemaObjs);
                publishObjs.add(subjectPublishObj);
            }
        }
        return publishObjs;
    }

    private ArrayList<SchemaBO> getAllPublishSchemaAttrs(String publishId, String userId) throws AbstractQingIntegratedException, SQLException {
        ArrayList<SchemaBO> parentSchemaList;
        SchemaBO parentSetDefaultSchema;
        ArrayList<SchemaBO> schemaList = this.getSchemaDao().loadSchemaAttrs(publishId, this.qingContext.getUserId());
        if (this.findUserSetDefaultSchema(schemaList) == null && (parentSetDefaultSchema = this.findUserSetDefaultSchema(parentSchemaList = this.getSchemaDao().loadSchemaAttrs(publishId, "SystemUser"))) != null) {
            this.adjustSchemaDefaultState(schemaList, parentSetDefaultSchema);
        }
        return schemaList;
    }

    private SchemaBO findUserSetDefaultSchema(ArrayList<SchemaBO> schemaList) {
        for (SchemaBO schemaBO : schemaList) {
            if (!schemaBO.IsDefault().booleanValue()) continue;
            return schemaBO;
        }
        return null;
    }

    private void adjustSchemaDefaultState(ArrayList<SchemaBO> schemaList, SchemaBO parentSetDefaultSchema) {
        for (SchemaBO schemaBO : schemaList) {
            if (!Objects.equals(schemaBO.getfId(), parentSetDefaultSchema.getfId())) continue;
            schemaBO.setIsDefault(true);
            break;
        }
    }

    private SubjectCarryDataInfo loadCarryDataInfo(PublishPO publishPO) throws AbstractQingIntegratedException, SQLException, ModelParseException, IOException, ModelPersistenceException, EncryptedLicenseCheckException {
        SubjectCarryDataInfo subjectCarryDataInfo = new SubjectCarryDataInfo();
        DataModelingObject dataModelingObj = new DataModelingObject();
        Box box = this.getPublishSubjectModelDao().loadBoxByPublishId(publishPO.getId());
        if (box.getSources() != null && !box.getSources().isEmpty()) {
            HashSet<String> dsFileNames = new HashSet<String>(16);
            for (AbstractSource source : box.getSources()) {
                if (!(source instanceof IFileSavable)) continue;
                IFileSavable iFileSavable = (IFileSavable)source;
                String fileUrl = ((IFileSavable)source).getFileUrl();
                String fileName = iFileSavable.getFileName();
                String fileExtension = "";
                if (fileName.indexOf(".") > -1) {
                    fileExtension = fileName.substring(fileName.lastIndexOf("."));
                }
                dsFileNames.add(fileUrl + fileExtension);
            }
            dataModelingObj.setDsFileNames(dsFileNames);
        }
        InputStream dbStream = this.getPublishSubjectModelDao().loadBoxStreamByPublishId(publishPO.getId());
        byte[] boxBytes = BoxSerializationUtil.toBytes(box, null, dbStream);
        String boxTempFileName = ImExportUtil.writeBytesToExportTempFile(boxBytes);
        dataModelingObj.setBoxFileName(boxTempFileName);
        subjectCarryDataInfo.setDataModelingObj(dataModelingObj);
        List<PublishSubjectFilePO> publishSubjectFilePOs = this.getPublishSubjectFileDao().loadPublishSubjectFile(publishPO.getId());
        if (publishSubjectFilePOs != null) {
            SubjectQsInfo subjectQsInfo = new SubjectQsInfo();
            HashMap<String, String> dataPathMap = new HashMap<String, String>(publishSubjectFilePOs.size());
            long extractTimestamp = System.currentTimeMillis();
            for (int i = 0; i < publishSubjectFilePOs.size(); ++i) {
                PublishSubjectFilePO publishSubjectFilePO = publishSubjectFilePOs.get(i);
                String qsFileName = publishSubjectFilePO.getFilePath();
                String entityName = publishSubjectFilePO.getEntityName();
                dataPathMap.put(entityName, qsFileName);
                if (publishSubjectFilePO.getExtractDataTime() == null) continue;
                extractTimestamp = publishSubjectFilePO.getExtractDataTime().getTime();
            }
            subjectQsInfo.setQs(dataPathMap);
            subjectQsInfo.setExtractTimestamp(extractTimestamp);
            subjectQsInfo.setOriginalCreatorId(publishPO.getCreatorId());
            subjectQsInfo.setOriginalCreatorName(IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)publishPO.getCreatorId()));
            subjectCarryDataInfo.setSubjectQsInfo(subjectQsInfo);
        }
        return subjectCarryDataInfo;
    }

    private List<DashboardObject> getDashboardObjs(List<String> dsbList, PackageMeta meta) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException, ThemeManagementException, QingImglibException, IOException {
        ArrayList<DashboardObject> dashboardObjs = new ArrayList<DashboardObject>();
        String userId = this.qingContext.getUserId();
        for (int i = 0; i < dsbList.size(); ++i) {
            String dsbId = dsbList.get(i);
            DashboardObject dashboardObj = new DashboardObject();
            ThemeVO dsbVo = this.getThemeDao().loadThemeIncludePreset(userId, dsbId);
            if (dsbVo == null) {
                throw new ThemeNotFoundException();
            }
            dashboardObj.setThemeVO(dsbVo);
            ThemeGroupVO themeGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupId(userId, dsbVo.getThemeGroupID());
            dashboardObj.setThemeGroupVO(themeGroupVO);
            DashboardModel dashboardModel = null;
            try {
                dashboardModel = this.getDashboardDesignDomain().loadModel(dsbId);
            }
            catch (EncryptedLicenseCheckException e) {
                String errorMsg = Messages.getMLS((QingContext)this.qingContext, (String)"unableToExport", (String)"\u65e0\u6cd5\u5bfc\u51fa", (Messages.ProjectName)Messages.ProjectName.QING_THEME);
                throw new EncryptedLicenseCheckException(errorMsg + "\"" + themeGroupVO.getThemeGroupName() + "/" + dsbVo.getThemeName() + "\", " + e.getMessage());
            }
            if (dashboardModel == null) {
                dashboardObjs.add(dashboardObj);
                continue;
            }
            InputStream dbStream = this.getDashboardDao().loadDashboardStream(dsbId);
            byte[] boxBytes = DashboardSerializationUtil.toBytes(dashboardModel, null, dbStream);
            String dsbModelTempFileName = ImExportUtil.writeBytesToExportTempFile(boxBytes);
            dashboardObj.setDsbModelFileName(dsbModelTempFileName);
            ArrayList<DsbRefObject> dsbRefObjs = new ArrayList<DsbRefObject>(10);
            List<ReferenceMap> reference = this.getDashboardDao().getRefList(dsbId);
            int c = reference.size();
            for (int j = 0; j < c; ++j) {
                String refToId;
                String refType;
                String fullPath;
                String uid;
                ReferenceMap referenceMap;
                block21: {
                    referenceMap = reference.get(j);
                    uid = referenceMap.getUid();
                    fullPath = referenceMap.getRefToFullPath();
                    refType = referenceMap.getRefType();
                    refToId = referenceMap.getRefToId();
                    RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)refType);
                    IRefHandler refHandler = this.getDashboardDesignDomain().getRefHandler(refTypeEnum);
                    ISwitchPathAndIdHandler switchPathAndIdHandler = refHandler.getSwitchPathAndIdHandler();
                    if (switchPathAndIdHandler != null) {
                        String fullPathAfterSwitch = switchPathAndIdHandler.switchRefIdToPath(refToId, userId);
                        if (fullPathAfterSwitch != null) {
                            fullPath = fullPathAfterSwitch;
                        } else {
                            try {
                                if (StringUtils.isBlank((CharSequence)fullPath)) {
                                    fullPath = switchPathAndIdHandler.createEmptyPath();
                                } else {
                                    fullPath = ImportUtil.getFullPathWithNameSpace(fullPath);
                                    JsonUtil.decodeFromString((String)fullPath, PathModel.class);
                                }
                            }
                            catch (Exception e) {
                                String[] path = StringUtils.split((String)fullPath, (char)'/');
                                if (path.length < 3) break block21;
                                PathModel pathModel = new PathModel();
                                pathModel.setNameSpace(path[0]);
                                pathModel.setGroupName(path[1]);
                                pathModel.setName(path[2]);
                                fullPath = JsonUtil.encodeToString((Object)pathModel);
                            }
                        }
                    }
                }
                referenceMap.setRefToFullPath(fullPath);
                String fId = (String)referenceMap.get((Object)"id");
                List<OutsideReference> outerRefs = this.getDashboardDao().loadSchemaRef(fId);
                byte[] refSchemaContent = this.getDashboardDesignDomain().loadShemaContent(uid, dsbId);
                DsbRefObject dsbRef = new DsbRefObject();
                dsbRef.setReferenceMap(referenceMap);
                if (refSchemaContent != null && RefTypeEnum.valueOf((String)referenceMap.getRefType()) != RefTypeEnum.picture) {
                    String refSchemaContentFileName = ImExportUtil.writeBytesToExportTempFile(refSchemaContent);
                    dsbRef.setRefSchemaContentFileName(refSchemaContentFileName);
                }
                if (outerRefs != null && !outerRefs.isEmpty()) {
                    for (int k = 0; k < outerRefs.size(); ++k) {
                        OutsideReference outsideReference = outerRefs.get(k);
                        String mapId = outsideReference.getRefToId();
                        PathModel pathModel = new PathModel();
                        if (mapId != null) {
                            ExportMapModel mapVO = this.getMapManageDao().loadMapWithGroupName(mapId);
                            if (mapVO != null) {
                                pathModel.setNameSpace(NameSpace.getNameSpace((String)mapVO.getNameSpace()).toPersistance());
                                pathModel.setGroupName(mapVO.getMapGroupName());
                                pathModel.setName(mapVO.getMapName());
                                outsideReference.setRefToFullPath(JsonUtil.encodeToString((Object)pathModel));
                            }
                            meta.getResources().getMapIds().add(mapId);
                            continue;
                        }
                        try {
                            JsonUtil.decodeFromString((String)outsideReference.getRefToFullPath(), PathModel.class);
                            continue;
                        }
                        catch (Exception e) {
                            String[] path = StringUtils.split((String)outsideReference.getRefToFullPath(), (char)'/');
                            if (path.length < 3) continue;
                            pathModel.setNameSpace(path[0]);
                            pathModel.setGroupName(path[1]);
                            pathModel.setName(path[2]);
                            outsideReference.setRefToFullPath(JsonUtil.encodeToString((Object)pathModel));
                        }
                    }
                    dsbRef.setOuterRefs(outerRefs);
                }
                if (RefTypeEnum.valueOf((String)refType) == RefTypeEnum.picture && refToId != null) {
                    meta.getResources().getPictureFileNames().add(refToId);
                }
                dsbRefObjs.add(dsbRef);
                dashboardObj.setDsbRefObjs(dsbRefObjs);
            }
            dashboardObjs.add(dashboardObj);
        }
        return dashboardObjs;
    }

    private List<AbstractPublishObject> getDsbPublishObjs(List<String> dsbList, PackageMeta meta, Map<String, Map<String, String>> lappAnalysisInfos, boolean connAvailable) throws SQLException, ExportException, AbstractQingException, IOException, JDOMException {
        ArrayList<AbstractPublishObject> publishObjs = new ArrayList<AbstractPublishObject>();
        String userId = this.qingContext.getUserId();
        for (int i = 0; i < dsbList.size(); ++i) {
            String dsbId = dsbList.get(i);
            List publishPOs = this.getCommonPublishDomain().loadAllPublishInfosWithoutPushAndLightApp(dsbId, userId);
            List lappPublishPOs = this.getPublishInfoDao().loadPublishInfos(dsbId, 2, userId);
            List lappPushPublishPOs = this.getPublishInfoDao().loadLappPushPublishInfos(dsbId, 2, userId);
            for (PublishPO publishPO : lappPublishPOs) {
                if (lappPushPublishPOs.contains(publishPO.getId())) continue;
                publishPOs.add(publishPO);
            }
            for (int j = 0; j < publishPOs.size(); ++j) {
                PublishPO publishPO;
                publishPO = (PublishPO)publishPOs.get(j);
                String publishId = publishPO.getId();
                DsbPublishObject dsbPublishObj = new DsbPublishObject();
                dsbPublishObj.setPublishPO(publishPO);
                List permissionInfos = this.getPublishPermissionDao().loadPublishPermissionInfo(publishId);
                dsbPublishObj.setPermissionObjs(ImExportUtil.getPermissionObjs(permissionInfos));
                List publishOperPermissionsPOList = this.getPublishOperPermissionsDao().loadPubOperByPubId(publishId);
                dsbPublishObj.setPublishOperPermissionsObjects(ImExportUtil.getPublishOperObjs(publishOperPermissionsPOList));
                if (publishPO.getPublishTargetType() == 2) {
                    Map<String, String> lappAnalysisInfo;
                    if (!connAvailable || (lappAnalysisInfo = lappAnalysisInfos.get(publishId)) == null) continue;
                    publishPO.setName(lappAnalysisInfo.get("name"));
                    this.getLappExporter().doExport(dsbPublishObj, publishPO, meta, lappAnalysisInfo);
                } else {
                    this.getPublishExporter(publishPO.getPublishTargetType()).exportTarget(dsbPublishObj, publishPO, meta);
                }
                if (dsbPublishObj.getPublishTarget() == null) continue;
                DashboardModel dashboardModel = this.getDashboardRuntimeDomain().loadDsbModel(publishId);
                InputStream dbStream = this.getDashboardPublishDao().loadDsbModelContentStream(publishId);
                byte[] boxBytes = DashboardSerializationUtil.toBytes(dashboardModel, null, dbStream);
                String dsbModelTempFileName = ImExportUtil.writeBytesToExportTempFile(boxBytes);
                dsbPublishObj.setDsbModelFileName(dsbModelTempFileName);
                ArrayList<DsbRefObject> dsbRefObjs = new ArrayList<DsbRefObject>(10);
                List<ReferenceMap> reference = this.getDashboardRuntimeDomain().getRefList(publishId);
                int c = reference.size();
                for (int k = 0; k < c; ++k) {
                    String refToId;
                    String refType;
                    String fullPath;
                    ReferenceMap referenceMap;
                    block20: {
                        referenceMap = reference.get(k);
                        fullPath = referenceMap.getRefToFullPath();
                        refType = referenceMap.getRefType();
                        refToId = referenceMap.getRefToId();
                        RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)refType);
                        IRefHandler refHandler = this.getDashboardRuntimeDomain().getRefHandler(refTypeEnum);
                        ISwitchPathAndIdHandler switchPathAndIdHandler = refHandler.getSwitchPathAndIdHandler();
                        if (switchPathAndIdHandler != null) {
                            String fullPathAfterSwitch = switchPathAndIdHandler.switchRefIdToPath(refToId, userId);
                            if (fullPathAfterSwitch != null) {
                                fullPath = fullPathAfterSwitch;
                            } else {
                                try {
                                    if (StringUtils.isBlank((CharSequence)fullPath)) {
                                        fullPath = switchPathAndIdHandler.createEmptyPath();
                                    }
                                    fullPath = ImportUtil.getFullPathWithNameSpace(fullPath);
                                    JsonUtil.decodeFromString((String)fullPath, PathModel.class);
                                }
                                catch (Exception e) {
                                    String[] path = StringUtils.split((String)fullPath, (char)'/');
                                    if (path.length < 3) break block20;
                                    PathModel pathModel = new PathModel();
                                    pathModel.setNameSpace(path[0]);
                                    pathModel.setGroupName(path[1]);
                                    pathModel.setName(path[2]);
                                    fullPath = JsonUtil.encodeToString((Object)pathModel);
                                }
                            }
                        }
                    }
                    referenceMap.setRefToFullPath(fullPath);
                    String fId = (String)referenceMap.get((Object)"id");
                    List<OutsideReference> outerRefs = this.getDashboardRuntimeDomain().loadOutsideReferences(fId);
                    byte[] refSchemaContent = this.getDashboardRuntimeDomain().selectRefContent(publishId, referenceMap);
                    DsbRefObject dsbRef = new DsbRefObject();
                    dsbRef.setReferenceMap(referenceMap);
                    if (refSchemaContent != null && RefTypeEnum.valueOf((String)referenceMap.getRefType()) != RefTypeEnum.picture) {
                        String refSchemaContentFileName = ImExportUtil.writeBytesToExportTempFile(refSchemaContent);
                        dsbRef.setRefSchemaContentFileName(refSchemaContentFileName);
                    }
                    if (outerRefs != null && !outerRefs.isEmpty()) {
                        for (int idx = 0; idx < outerRefs.size(); ++idx) {
                            OutsideReference outsideReference = outerRefs.get(idx);
                            String mapId = outsideReference.getRefToId();
                            PathModel pathModel = new PathModel();
                            if (mapId != null) {
                                ExportMapModel mapVO = this.getMapManageDao().loadMapWithGroupName(mapId);
                                if (mapVO != null) {
                                    pathModel.setNameSpace(NameSpace.getNameSpace((String)mapVO.getNameSpace()).toPersistance());
                                    pathModel.setGroupName(mapVO.getMapGroupName());
                                    pathModel.setName(mapVO.getMapName());
                                    outsideReference.setRefToFullPath(JsonUtil.encodeToString((Object)pathModel));
                                }
                                meta.getResources().getMapIds().add(mapId);
                                continue;
                            }
                            try {
                                JsonUtil.decodeFromString((String)outsideReference.getRefToFullPath(), PathModel.class);
                                continue;
                            }
                            catch (Exception e) {
                                String[] path = StringUtils.split((String)outsideReference.getRefToFullPath(), (char)'/');
                                if (path.length < 3) continue;
                                pathModel.setNameSpace(path[0]);
                                pathModel.setGroupName(path[1]);
                                pathModel.setName(path[2]);
                                outsideReference.setRefToFullPath(JsonUtil.encodeToString((Object)pathModel));
                            }
                        }
                        dsbRef.setOuterRefs(outerRefs);
                    }
                    dsbRefObjs.add(dsbRef);
                    if (RefTypeEnum.valueOf((String)refType) != RefTypeEnum.picture || refToId == null) continue;
                    meta.getResources().getPictureFileNames().add(refToId);
                }
                if (publishPO.isCarryData()) {
                    DsbCarryDataInfo subjectCarryDataInfo = this.loadDsbCarryDataInfo(publishPO, reference);
                    dsbPublishObj.setCarryDataInfo(subjectCarryDataInfo);
                }
                dsbPublishObj.setDsbRefObjs(dsbRefObjs);
                publishObjs.add(dsbPublishObj);
            }
        }
        return publishObjs;
    }

    private DsbCarryDataInfo loadDsbCarryDataInfo(PublishPO publishPO, List<ReferenceMap> reference) throws AbstractQingIntegratedException, SQLException, ModelParseException, IOException, ModelPersistenceException, EncryptedLicenseCheckException {
        DsbCarryDataInfo dsbCarryDataInfo = new DsbCarryDataInfo();
        DashboardQsInfo dashboardQsInfo = new DashboardQsInfo();
        boolean needCarryDataInfo = false;
        long extractTimestamp = System.currentTimeMillis();
        List<PublishDsbRefBillFile> publishDsbRefBillFiles = this.getPublishDsbRefBillFileDao().loadBillFileByPublishId(publishPO.getId());
        if (publishDsbRefBillFiles != null && !publishDsbRefBillFiles.isEmpty()) {
            ArrayList<Map<String, String>> billQsList = new ArrayList<Map<String, String>>(publishDsbRefBillFiles.size());
            for (int i = 0; i < publishDsbRefBillFiles.size(); ++i) {
                PublishDsbRefBillFile publishDsbRefBillFile = publishDsbRefBillFiles.get(i);
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put("file", publishDsbRefBillFile.getQsFileName());
                map.put("refUid", publishDsbRefBillFile.getRefUid());
                if (publishDsbRefBillFile.getExtractDataTime() != null) {
                    map.put("extractTimestamp", String.valueOf(publishDsbRefBillFile.getExtractDataTime().getTime()));
                } else {
                    map.put("extractTimestamp", String.valueOf(extractTimestamp));
                }
                billQsList.add(map);
            }
            dashboardQsInfo.setExtractTimestamp(extractTimestamp);
            dashboardQsInfo.setBillQsList(billQsList);
            dashboardQsInfo.setOriginalCreatorId(publishPO.getCreatorId());
            dashboardQsInfo.setOriginalCreatorName(IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)publishPO.getCreatorId()));
            needCarryDataInfo = true;
        }
        dsbCarryDataInfo.setDashboardQsInfo(dashboardQsInfo);
        HashMap qsFileMap = new HashMap(16);
        List<PublishSubjectFilePO> publishSubjectFilePOs = this.getPublishDsbRefSubjectFileDao().loadPublishSubjectFileByPublishId(publishPO.getId());
        if (publishSubjectFilePOs != null && !publishSubjectFilePOs.isEmpty()) {
            ArrayList<Map<String, String>> subjectQsList = new ArrayList<Map<String, String>>(publishSubjectFilePOs.size());
            for (int i = 0; i < publishSubjectFilePOs.size(); ++i) {
                PublishSubjectFilePO publishSubjectFilePO = publishSubjectFilePOs.get(i);
                HashMap<String, String> map = new HashMap<String, String>(3);
                map.put("entityName", publishSubjectFilePO.getEntityName());
                String filePath = publishSubjectFilePO.getFilePath();
                map.put("file", filePath);
                String refUid = publishSubjectFilePO.getRefUid();
                map.put("refUid", publishSubjectFilePO.getRefUid());
                if (publishSubjectFilePO.getExtractDataTime() != null) {
                    map.put("extractTimestamp", String.valueOf(publishSubjectFilePO.getExtractDataTime().getTime()));
                } else {
                    map.put("extractTimestamp", String.valueOf(extractTimestamp));
                }
                subjectQsList.add(map);
                needCarryDataInfo = true;
                List<String> qsFileList = new ArrayList<String>();
                if (qsFileMap.get(refUid) != null) {
                    qsFileList = (List)qsFileMap.get(refUid);
                }
                qsFileList.add(filePath);
                qsFileMap.put(refUid, qsFileList);
            }
            dashboardQsInfo.setSubjectQsList(subjectQsList);
            dashboardQsInfo.setExtractTimestamp(extractTimestamp);
            dashboardQsInfo.setOriginalCreatorId(publishPO.getCreatorId());
            dashboardQsInfo.setOriginalCreatorName(IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)publishPO.getCreatorId()));
        }
        ArrayList<DsbDataModelObject> dsbDataModelObjects = new ArrayList<DsbDataModelObject>(10);
        HashMap<List, String> boxFileNameMap = new HashMap<List, String>(16);
        for (ReferenceMap referenceMap : reference) {
            DsbDataModelObject dsbDataModelObject = new DsbDataModelObject();
            String uid = referenceMap.getUid();
            dsbDataModelObject.setRefUid(uid);
            String boxFileName = null;
            List qsFileList = (List)qsFileMap.get(uid);
            if (qsFileList != null) {
                for (Map.Entry map : boxFileNameMap.entrySet()) {
                    List key = (List)map.getKey();
                    if (key.size() != qsFileList.size() || !key.containsAll(qsFileList) || !qsFileList.containsAll(key)) continue;
                    boxFileName = (String)map.getValue();
                    break;
                }
            }
            if (boxFileName != null) {
                dsbDataModelObject.setBoxFileName(boxFileName);
                dsbDataModelObjects.add(dsbDataModelObject);
                continue;
            }
            Box box = this.getPublishDsbRefSubjectModelDao().loadBoxByPublishId(publishPO.getId(), uid);
            if (box == null) continue;
            InputStream dbStream = this.getPublishDsbRefSubjectModelDao().loadBoxStreamByPublishId(publishPO.getId(), uid);
            byte[] boxBytes = BoxSerializationUtil.toBytes(box, null, dbStream);
            String boxTempFileName = ImExportUtil.writeBytesToExportTempFile(boxBytes);
            dsbDataModelObject.setBoxFileName(boxTempFileName);
            dsbDataModelObjects.add(dsbDataModelObject);
            if (qsFileList == null) continue;
            boxFileNameMap.put(qsFileList, boxTempFileName);
        }
        dsbCarryDataInfo.setDsbDataModelObjects(dsbDataModelObjects);
        return needCarryDataInfo ? dsbCarryDataInfo : null;
    }

    Map<String, Map<String, String>> getAllLappPublishInfo(PackageMeta meta, List<String> subjectList, List<String> dsbList, boolean connAvailable) throws AbstractQingIntegratedException, SQLException, IOException {
        ArrayList<PublishPO> allLappPublishPO = new ArrayList<PublishPO>();
        Map<String, Map<String, String>> lappAnalysisInfos = new HashMap<String, Map<String, String>>();
        if (connAvailable) {
            List lappPushPublishPOs;
            List lappPublishPOs;
            String userId = this.qingContext.getUserId();
            for (String subjectId : subjectList) {
                lappPublishPOs = this.getPublishInfoDao().loadPublishInfos(subjectId, 2, userId);
                lappPushPublishPOs = this.getPublishInfoDao().loadLappPushPublishInfos(subjectId, 2, userId);
                for (PublishPO publishPO : lappPublishPOs) {
                    if (lappPushPublishPOs.contains(publishPO.getId())) continue;
                    allLappPublishPO.add(publishPO);
                }
            }
            for (String dsbId : dsbList) {
                lappPublishPOs = this.getPublishInfoDao().loadPublishInfos(dsbId, 2, userId);
                lappPushPublishPOs = this.getPublishInfoDao().loadLappPushPublishInfos(dsbId, 2, userId);
                for (PublishPO publishPO : lappPublishPOs) {
                    if (lappPushPublishPOs.contains(publishPO.getId())) continue;
                    allLappPublishPO.add(publishPO);
                }
            }
            lappAnalysisInfos = this.getLappExporter().loadAllLappPublishInfo(allLappPublishPO);
            this.getLappExporter().dowmloadImage(lappAnalysisInfos, meta);
        }
        return lappAnalysisInfos;
    }
}

