/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.exporter.pkg.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.target.PublishToLapp;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.target.lapp.env.LappApiEnum;
import com.kingdee.bos.qing.publish.target.lapp.model.PublishLappConfigVO;
import com.kingdee.bos.qing.publish.target.lapp.strategy.ILappStrategy;
import com.kingdee.bos.qing.publish.target.lapp.util.LappHelper;
import com.kingdee.bos.qing.publish.thumbnail.domain.ThumbnailDomain;
import com.kingdee.bos.qing.publish.thumbnail.model.ThumbnailInfo;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class LappExporter {
    private QingContext qingContext;
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    private IScheduleEngine scheduleEngine;
    private ThumbnailDomain thumbnailDomain;
    private List<PublishLappConfigVO> publishLappConfigVOs;
    private SchemaManageDao schemaManageDao;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setScheduleEngine(IScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    private ThumbnailDomain getThumbnailDomain() {
        if (this.thumbnailDomain == null) {
            this.thumbnailDomain = new ThumbnailDomain(this.qingContext, this.tx, this.dbExcuter, null);
        }
        return this.thumbnailDomain;
    }

    private List<PublishLappConfigVO> getPublishLappConfigVOs() {
        if (this.publishLappConfigVOs == null) {
            ILappStrategy lappStrategy = (ILappStrategy)CustomStrategyRegistrar.getStrategy(ILappStrategy.class);
            if (lappStrategy == null) {
                throw new RuntimeException("cannot found the implement of ILappStrategy.");
            }
            this.publishLappConfigVOs = new ArrayList<PublishLappConfigVO>();
            lappStrategy.getLappConext(this.publishLappConfigVOs, this.qingContext, this.dbExcuter, this.tx, this.scheduleEngine);
        }
        return this.publishLappConfigVOs;
    }

    public SchemaManageDao getSchemaManageDao() {
        if (this.schemaManageDao == null) {
            this.schemaManageDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaManageDao;
    }

    public void doExport(AbstractPublishObject publishObject, PublishPO publishPO, PackageMeta meta, Map<String, String> lappAnalysisInfo) throws SQLException, AbstractQingException, IOException, JDOMException {
        PublishToLapp publishToLapp = new PublishToLapp();
        publishToLapp.setTargetType(publishPO.getPublishTargetType());
        publishToLapp.setDesc(lappAnalysisInfo.get("description"));
        publishToLapp.setPath(lappAnalysisInfo.get("directoryName"));
        publishToLapp.setLayout_type(lappAnalysisInfo.get("layoutType"));
        publishToLapp.setLandscape(lappAnalysisInfo.get("landscape"));
        publishToLapp.setBottomAnnotation(lappAnalysisInfo.get("bottomAnnotation"));
        publishToLapp.setDisplayStyle(lappAnalysisInfo.get("displayStyle"));
        publishToLapp.setAppType(lappAnalysisInfo.get("appType"));
        publishToLapp.setTempThumbnailFile(lappAnalysisInfo.get("thumbnail"));
        ThumbnailInfo thumbnailInfo = this.getThumbnailDomain().loadThumbnailInfoForExport(publishPO.getId());
        if (thumbnailInfo != null) {
            byte[] schemaContent = this.getSchemaManageDao().loadSchemaContent(thumbnailInfo.getSchemaId());
            Element element = XmlUtil.loadRootElement((InputStream)new ByteArrayInputStream(schemaContent));
            ModelBook modelBook = new ModelBook();
            modelBook.fromXml(element);
            thumbnailInfo.setModelBook(modelBook);
            publishToLapp.setThumbnailInfo(thumbnailInfo);
        }
        publishObject.setPublishTarget(publishToLapp);
    }

    public Map<String, Map<String, String>> loadAllLappPublishInfo(List<PublishPO> publishPOs) {
        ArrayList<String> publishIds = new ArrayList<String>(10);
        HashMap<String, Map<String, String>> analysisInfos = new HashMap<String, Map<String, String>>(16);
        for (PublishPO publishPO : publishPOs) {
            publishIds.add(publishPO.getId());
        }
        if (publishIds.isEmpty()) {
            return analysisInfos;
        }
        try {
            List<PublishLappConfigVO> publishLappConfigVOList = this.getPublishLappConfigVOs();
            for (PublishLappConfigVO publishLappConfigVO : publishLappConfigVOList) {
                Map tmps = null;
                if (publishIds.isEmpty() || !StringUtils.isNotBlank((CharSequence)publishLappConfigVO.getLappUserId())) continue;
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("lappUserId", publishLappConfigVO.getLappUserId());
                paramMap.put("lappUserType", publishLappConfigVO.getLappUserType());
                String result = LappHelper.post(LappApiEnum.QING_GET_LAPP_LOAD_ANALYSIS_URL, null, JsonUtil.encodeToString(publishIds), paramMap);
                tmps = (Map)JsonUtil.decodeFromString((String)result, Map.class);
                if (tmps == null) continue;
                for (Map.Entry entry : tmps.entrySet()) {
                    Map analysisInfo = (Map)entry.getValue();
                    analysisInfo.put("appType", String.valueOf(publishLappConfigVO.getAppType().toString()));
                    analysisInfos.put((String)entry.getKey(), analysisInfo);
                    publishIds.remove(entry.getKey());
                }
            }
        }
        catch (Exception e) {
            LogUtil.error((String)"\u5411\u8f7b\u5e94\u7528\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff01", (Throwable)e);
        }
        return analysisInfos;
    }

    public void dowmloadImage(Map<String, Map<String, String>> analysisInfoMap, PackageMeta meta) throws IOException {
        for (Map.Entry<String, Map<String, String>> entry : analysisInfoMap.entrySet()) {
            byte[] thumbnailByteArray;
            Map<String, String> lappAnalysisInfo = entry.getValue();
            if (lappAnalysisInfo.get("largeThumb") == null || (thumbnailByteArray = LappHelper.getDownloadThumbnail(lappAnalysisInfo.get("largeThumb"))).length <= 0) continue;
            IQingFile qingFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.UPLOAD);
            qingFile.write((IWriteCall)new CopyWriteCall((InputStream)new ByteArrayInputStream(thumbnailByteArray), false), true);
            meta.getResources().getLappImagePaths().add(qingFile.getName());
            lappAnalysisInfo.put("thumbnail", qingFile.getName());
        }
    }

    public static byte[] getBytesFromInputStream(InputStream inputStream) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        return baos.toByteArray();
    }
}

