/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.pkg.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.cache.DashboardModelBookCache;
import com.kingdee.bos.qing.dashboard.dao.DashboardDao;
import com.kingdee.bos.qing.dashboard.dao.DashboardSerializationUtil;
import com.kingdee.bos.qing.dashboard.domain.DashboardDesignDomain;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.DashboardModelUtil;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.RefHandlerFactory;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.imagelibrary.exception.ImageFileSizeLimitException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportDashboardException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportDashboardPublishException;
import com.kingdee.bos.qing.imexport.importer.pkg.domain.ImportPKGDomain;
import com.kingdee.bos.qing.imexport.importer.pkg.model.ImportParamModel;
import com.kingdee.bos.qing.imexport.importer.pkg.publish.DashboardPublishImporter;
import com.kingdee.bos.qing.imexport.importer.pkg.source.MapImporter;
import com.kingdee.bos.qing.imexport.importer.pkg.source.PictureImporter;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.dashboard.DashboardObject;
import com.kingdee.bos.qing.imexport.model.dashboard.DsbRefObject;
import com.kingdee.bos.qing.imexport.model.publish.dashboard.DsbPublishObject;
import com.kingdee.bos.qing.imexport.oplog.ImexportOpLog;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.IThemeGroupDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.dao.impl.ThemeGroupDaoImpl;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.exception.ThemeGroupDuplicateNameException;
import com.kingdee.bos.qing.manage.exception.ThemeNameDuplicateException;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportThemeVO;
import com.kingdee.bos.qing.manage.model.ThemeGroupPO;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.map.domain.MapManageDomain;
import com.kingdee.bos.qing.map.imexport.model.ExportMapModel;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.util.BoxUtil;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.OpLogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DashboardImporter {
    private static final String CACHED_DSBID_SUFFIX = "dsb";
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private IThemeGroupDao iThemeGroupDao;
    private IThemeDao iThemeDao;
    private DashboardDesignDomain dashboardDesignDomain;
    private MapImporter mapImporter;
    private PictureImporter pictureImporter;
    private DashboardDao dashboardDao;
    private DashboardPublishImporter DashboardPublishImporter;
    private Map<RefTypeEnum, IRefHandler> refHandlerMap;
    private MapManageDomain mapManageDomain;
    private ImportPKGDomain.IPublishInfoCollector publishInfoCollector;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    private DashboardDao getDashboardDao() {
        if (this.dashboardDao == null) {
            this.dashboardDao = new DashboardDao(this.dbExcuter);
        }
        return this.dashboardDao;
    }

    private IThemeGroupDao getThemeGroupDao() {
        if (this.iThemeGroupDao == null) {
            this.iThemeGroupDao = new ThemeGroupDaoImpl(this.dbExcuter);
        }
        return this.iThemeGroupDao;
    }

    private IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    private DashboardDesignDomain getDashboardDesignDomain() {
        if (this.dashboardDesignDomain == null) {
            this.dashboardDesignDomain = new DashboardDesignDomain(this.qingContext, this.tx, this.dbExcuter, null);
        }
        return this.dashboardDesignDomain;
    }

    private MapImporter getMapImporter() {
        if (this.mapImporter == null) {
            this.mapImporter = new MapImporter();
            this.mapImporter.setDbExcuter(this.dbExcuter);
            this.mapImporter.setQingContext(this.qingContext);
            this.mapImporter.setTx(this.tx);
        }
        return this.mapImporter;
    }

    private PictureImporter getPictureImporter() {
        if (this.pictureImporter == null) {
            this.pictureImporter = new PictureImporter();
            this.pictureImporter.setDbExcuter(this.dbExcuter);
            this.pictureImporter.setQingContext(this.qingContext);
            this.pictureImporter.setTx(this.tx);
        }
        return this.pictureImporter;
    }

    private DashboardPublishImporter getDashboardPublishImporter() {
        if (this.DashboardPublishImporter == null) {
            this.DashboardPublishImporter = new DashboardPublishImporter();
            this.DashboardPublishImporter.setDbExcuter(this.dbExcuter);
            this.DashboardPublishImporter.setQingContext(this.qingContext);
            this.DashboardPublishImporter.setTx(this.tx);
            this.DashboardPublishImporter.registerPublishInfoCollector(this.publishInfoCollector);
        }
        return this.DashboardPublishImporter;
    }

    private MapManageDomain getMapManageDomain() {
        if (this.mapManageDomain == null) {
            this.mapManageDomain = new MapManageDomain();
            this.mapManageDomain.setDbExcuter(this.dbExcuter);
            this.mapManageDomain.setQingContext(this.qingContext);
            this.mapManageDomain.setTx(this.tx);
        }
        return this.mapManageDomain;
    }

    private IRefHandler getRefHandler(RefTypeEnum refType) {
        IRefHandler refHandler;
        if (this.refHandlerMap == null) {
            this.refHandlerMap = new HashMap<RefTypeEnum, IRefHandler>();
        }
        if ((refHandler = this.refHandlerMap.get(refType)) == null) {
            refHandler = RefHandlerFactory.createHandler(refType, this.dbExcuter, this.qingContext, this.tx);
            this.refHandlerMap.put(refType, refHandler);
        }
        return refHandler;
    }

    public void registerPublishInfoCollector(ImportPKGDomain.IPublishInfoCollector publishInfoCollector) {
        this.publishInfoCollector = publishInfoCollector;
    }

    public void doImport(ImportParamModel importParamModel, List<DsbPublishObject> lappDsbPublishObjects) throws ImportDashboardException, ImageFileSizeLimitException, ImportDashboardPublishException, EncryptedLicenseCheckException {
        String userId = this.qingContext.getUserId();
        PackageMeta meta = importParamModel.getPackageMeta();
        ExportThemeVO exportDashboardVO = importParamModel.getExportVO();
        Map<String, String> importIds = importParamModel.getImportIds();
        List<ExportThemeVO> conflictExportList = importParamModel.getConflictList();
        boolean addGroup = false;
        List<DashboardObject> dashboardObjs = meta.getDashboardObjs();
        Map<String, String> tempFile = importParamModel.getTempFile();
        try {
            for (DashboardObject dashboardObj : dashboardObjs) {
                String oldDsbId;
                String dsbId;
                boolean publishOverWrite;
                DashboardModel dashboardModel;
                String dsbModelFileName;
                ThemeVO dashboardVO;
                block39: {
                    dashboardVO = dashboardObj.getThemeVO();
                    if (!exportDashboardVO.getThemeID().equals(dashboardVO.getThemeID())) continue;
                    dsbModelFileName = tempFile.get(dashboardObj.getDsbModelFileName());
                    InputStream dsbOrignalStream = null;
                    dashboardModel = new DashboardModel();
                    if (dsbModelFileName != null && (dsbOrignalStream = BoxUtil.getBoxStreamByFileName(dsbModelFileName, (AbstractQingFileType)QingTempFileType.UPLOAD)) != null) {
                        dashboardModel = DashboardSerializationUtil.toModel(dsbOrignalStream);
                    }
                    publishOverWrite = false;
                    String publishStrategy = exportDashboardVO.getPublishStrategy();
                    if (publishStrategy != null && ExportThemeVO.StrategyType.overwrite.toPersistance().equals(publishStrategy)) {
                        publishOverWrite = true;
                    }
                    ThemeGroupVO themeGroupVO = dashboardObj.getThemeGroupVO();
                    String groupId = null;
                    if (importIds.get(themeGroupVO.getThemeGroupName()) != null) {
                        groupId = importIds.get(themeGroupVO.getThemeGroupName());
                    } else {
                        ThemeGroupPO groupPO = new ThemeGroupPO();
                        groupPO.setUserID(userId);
                        groupPO.setThemeGroupName(themeGroupVO.getThemeGroupName());
                        try {
                            groupId = this.getThemeGroupDao().saveThemeGroup(groupPO);
                            addGroup = true;
                        }
                        catch (ThemeGroupDuplicateNameException e) {
                            ThemeGroupVO newThemeGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupName(userId, themeGroupVO.getThemeGroupName());
                            groupId = newThemeGroupVO.getThemeGroupID();
                        }
                        importIds.put(themeGroupVO.getThemeGroupName(), groupId);
                    }
                    dsbId = null;
                    oldDsbId = dashboardVO.getThemeID();
                    ThemePO dashboardPO = new ThemePO();
                    try {
                        dashboardPO.setThemeName(dashboardVO.getThemeName());
                        dashboardPO.setThemeType("1");
                        dashboardPO.setDescription(dashboardVO.getDescription());
                        dashboardPO.setUserID(userId);
                        dashboardPO.setGroupID(groupId);
                        dsbId = this.getThemeDao().saveOrUpdateTheme(dashboardPO);
                        importIds.put(oldDsbId, dsbId);
                        this.addOpLog(themeGroupVO.getThemeGroupName(), dashboardPO.getThemeName());
                    }
                    catch (ThemeNameDuplicateException e) {
                        if (exportDashboardVO.getStrategy() == null) {
                            conflictExportList.add(exportDashboardVO);
                            if (!addGroup) continue;
                            this.getThemeGroupDao().deleteThemeGroup(userId, groupId);
                            continue;
                        }
                        ExportThemeVO.StrategyType strategyType = ExportThemeVO.StrategyType.valueOf(exportDashboardVO.getStrategy());
                        if (strategyType == ExportThemeVO.StrategyType.overwrite) {
                            this.overwriteImportDashboard(dashboardPO, themeGroupVO);
                            dsbId = dashboardPO.getThemeID();
                        }
                        if (strategyType != ExportThemeVO.StrategyType.rename) break block39;
                        this.renameImportTheme(dashboardPO, themeGroupVO);
                        dsbId = dashboardPO.getThemeID();
                    }
                }
                if (dsbModelFileName != null) {
                    ArrayList<ReferenceMap> refList = new ArrayList<ReferenceMap>(10);
                    List<DsbRefObject> dsbRefObjs = dashboardObj.getDsbRefObjs();
                    if (dsbRefObjs != null) {
                        for (DsbRefObject dsbRefObj : dsbRefObjs) {
                            ReferenceMap referenceMap = dsbRefObj.getReferenceMap();
                            List<OutsideReference> outSideRefs = dsbRefObj.getOuterRefs();
                            RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)referenceMap.getRefType());
                            ReferenceMap newReferenceMap = new ReferenceMap();
                            String schemaTempfileName = tempFile.get(dsbRefObj.getRefSchemaContentFileName());
                            if (refTypeEnum != RefTypeEnum.picture) {
                                String fileKey = UUID.randomUUID().toString();
                                newReferenceMap.setFileKey(fileKey);
                                if (schemaTempfileName != null) {
                                    DashboardModelBookCache dashboardCache = new DashboardModelBookCache(fileKey);
                                    byte[] schemaContent = FileFactory.getFileContent((AbstractQingFileType)QingTempFileType.UPLOAD, (String)schemaTempfileName);
                                    dashboardCache.setValue(schemaContent);
                                    dashboardCache.save();
                                }
                            }
                            newReferenceMap.setRefType(referenceMap.getRefType());
                            newReferenceMap.setUid(referenceMap.getUid());
                            if (importIds.get(referenceMap.getRefToId()) != null) {
                                newReferenceMap.setRefToId(importIds.get(referenceMap.getRefToId()));
                                newReferenceMap.setRefToFullPath(null);
                            } else {
                                String newRefToId = null;
                                if (refTypeEnum == RefTypeEnum.picture && referenceMap.getRefToId() != null) {
                                    newRefToId = this.getPictureImporter().doImport(importParamModel, referenceMap.getRefToId());
                                }
                                if (newRefToId != null) {
                                    newReferenceMap.setRefToId(newRefToId);
                                    newReferenceMap.setRefToFullPath(null);
                                    importIds.put(referenceMap.getRefToId(), newRefToId);
                                } else {
                                    String fullPath = referenceMap.getRefToFullPath();
                                    IRefHandler refHandler = this.getRefHandler(refTypeEnum);
                                    ISwitchPathAndIdHandler switchPathAndIdHandler = refHandler.getSwitchPathAndIdHandler();
                                    if (switchPathAndIdHandler != null) {
                                        if (fullPath != null) {
                                            newRefToId = switchPathAndIdHandler.switchRefPathToId(fullPath, userId);
                                        }
                                        if (newRefToId != null) {
                                            fullPath = null;
                                        }
                                        newReferenceMap.setRefToId(newRefToId);
                                        newReferenceMap.setRefToFullPath(fullPath);
                                        ImExportUtil.cacheDashboardWidgetID(importParamModel, dsbId, referenceMap.getUid(), referenceMap.getRefToFullPath(), CACHED_DSBID_SUFFIX);
                                    } else if (schemaTempfileName == null) {
                                        this.getDashboardDao().saveRefInfo(newReferenceMap, dsbId);
                                    }
                                }
                            }
                            String outerRefKey = UUID.randomUUID().toString();
                            newReferenceMap.put((Object)"outerRefKey", (Object)outerRefKey);
                            if (CollectionUtils.isNotEmpty(outSideRefs)) {
                                for (OutsideReference outsideReference : outSideRefs) {
                                    String oldMapId = outsideReference.getRefToId();
                                    outsideReference.setRefType("Map");
                                    String newMapId = null;
                                    if (importIds.get(oldMapId) != null) {
                                        newMapId = importIds.get(oldMapId);
                                    } else if (oldMapId != null && (newMapId = this.getMapImporter().doImportWithoutTx(importParamModel, oldMapId)) != null) {
                                        importIds.put(oldMapId, newMapId);
                                    }
                                    if (newMapId != null) {
                                        outsideReference.setRefToFullPath(null);
                                        outsideReference.setRefToId(newMapId);
                                        importIds.put(oldMapId, newMapId);
                                        continue;
                                    }
                                    String mapFullPath = outsideReference.getRefToFullPath();
                                    if (StringUtils.isNotEmpty((CharSequence)mapFullPath)) {
                                        PathModel pathModel = (PathModel)JsonUtil.decodeFromString((String)mapFullPath, PathModel.class);
                                        if (pathModel != null) {
                                            String nameSpace = NameSpace.valueOf((String)pathModel.getNameSpace()).getCode();
                                            ExportMapModel exportMapModel = this.getMapManageDomain().loadMapByNameAndGroupName(pathModel.getGroupName(), pathModel.getName(), nameSpace);
                                            if (exportMapModel != null) {
                                                outsideReference.setRefToFullPath(null);
                                                outsideReference.setRefToId(exportMapModel.getMapId());
                                                continue;
                                            }
                                            outsideReference.setRefToId(null);
                                            continue;
                                        }
                                        outsideReference.setRefToId(null);
                                        continue;
                                    }
                                    outsideReference.setRefToId(null);
                                }
                                DashboardModelUtil.cacheOuterRef(newReferenceMap, outSideRefs);
                            }
                            refList.add(newReferenceMap);
                        }
                    }
                    dashboardModel.fixReferences(refList);
                    InputStream dsbModelStream = BoxUtil.getBoxStreamByFileName(dsbModelFileName, (AbstractQingFileType)QingTempFileType.UPLOAD);
                    this.getDashboardDesignDomain().saveDsbAndReferencesWithoutTx(dsbId, dashboardModel, dsbModelStream);
                }
                dashboardVO.setThemeID(dsbId);
                dashboardVO.setThemeType("1");
                this.getDashboardPublishImporter().doImport(importParamModel, dashboardVO, oldDsbId, publishOverWrite, lappDsbPublishObjects);
            }
        }
        catch (ImageFileSizeLimitException e) {
            throw e;
        }
        catch (EncryptedLicenseCheckException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ImportDashboardException(e);
        }
    }

    private void addOpLog(String groupName, String themeName) {
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(themeName);
        params.add(groupName);
        ImexportOpLog qingAnalysisGroupDir = ImexportOpLog.QING_ANALYSIS_GROUP_DIR;
        qingAnalysisGroupDir.setLogScene("\u4eea\u8868\u677f");
        OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.IMPORT, (IOpLogConstant)qingAnalysisGroupDir, params));
    }

    private void overwriteImportDashboard(ThemePO themePO, ThemeGroupVO themeGroupVO) throws AbstractQingIntegratedException, SQLException {
        String themeID;
        ThemeVO themeVO = this.getThemeDao().loadThemeByName(themePO.getUserID(), themePO.getGroupID(), themePO.getThemeName(), themePO.getThemeType());
        if (themeVO != null) {
            themeID = themeVO.getThemeID();
            themePO.setThemeID(themeID);
            List<ReferenceMap> refList = this.getDashboardDao().getRefList(themeID);
            for (int i = 0; i < refList.size(); ++i) {
                ReferenceMap ref = refList.get(i);
                String fId = (String)ref.get((Object)"id");
                this.getDashboardDao().deleteOuterRef(fId);
            }
            this.getDashboardDao().deleteDashboard(themeID);
        }
        try {
            themeID = this.getThemeDao().saveOrUpdateTheme(themePO);
            themePO.setThemeID(themeID);
        }
        catch (ThemeNameDuplicateException e) {
            LogUtil.error((String)"ThemeNameDuplicateException: ", (Throwable)((Object)e));
        }
        this.addOpLog(themeGroupVO.getThemeGroupName(), themePO.getThemeName());
    }

    private void renameImportTheme(ThemePO themePO, ThemeGroupVO themeGroupVO) throws AbstractQingIntegratedException, SQLException {
        boolean bInsert = false;
        String themeID = null;
        String themeName = null;
        themePO.setThemeID(null);
        while (!bInsert) {
            String conFlictThemeName = themePO.getThemeName();
            themeName = ImExportUtil.rename(conFlictThemeName);
            themePO.setThemeName(themeName);
            try {
                themeID = this.getThemeDao().saveOrUpdateTheme(themePO);
                bInsert = true;
            }
            catch (ThemeNameDuplicateException e) {
                bInsert = false;
            }
            if (!bInsert) continue;
            this.addOpLog(themeGroupVO.getThemeGroupName(), themePO.getThemeName());
        }
        themePO.setThemeID(themeID);
    }
}

