/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.pkg.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.imexport.importer.common.AbstractImportDomain;
import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportMetaFileException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportMetaTypeException;
import com.kingdee.bos.qing.imexport.importer.exception.MetaParseException;
import com.kingdee.bos.qing.imexport.importer.pkg.domain.DashboardImporter;
import com.kingdee.bos.qing.imexport.importer.pkg.domain.SubjectImporter;
import com.kingdee.bos.qing.imexport.importer.pkg.model.ImportParamModel;
import com.kingdee.bos.qing.imexport.importer.pkg.publish.AbstractPublishImporter;
import com.kingdee.bos.qing.imexport.importer.pkg.publish.DashboardPublishImporter;
import com.kingdee.bos.qing.imexport.importer.pkg.publish.EmbeddedPublishImporter;
import com.kingdee.bos.qing.imexport.importer.pkg.publish.PublishImporterFactory;
import com.kingdee.bos.qing.imexport.importer.pkg.publish.SubjectPublishImporter;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.MetaTypeEnum;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.dashboard.DashboardObject;
import com.kingdee.bos.qing.imexport.model.dashboard.DsbRefObject;
import com.kingdee.bos.qing.imexport.model.publish.LongerSquarePublishObject;
import com.kingdee.bos.qing.imexport.model.publish.dashboard.DsbPublishObject;
import com.kingdee.bos.qing.imexport.model.subject.SubjectObject;
import com.kingdee.bos.qing.manage.domain.impl.SubjectManageDomain;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportThemeVO;
import com.kingdee.bos.qing.manage.model.FolderNode;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.target.lapp.env.LappApiEnum;
import com.kingdee.bos.qing.publish.target.lapp.model.LappContext;
import com.kingdee.bos.qing.publish.target.lapp.util.LappHelper;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.exception.ScheduleEngineException;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipInputStream;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ImportPKGDomain
extends AbstractImportDomain {
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private SubjectImporter subjectImporter;
    private DashboardImporter dashboardImporter;
    private AbstractPublishImporter lappPublishImporter;
    private IScheduleEngine scheduleEngine;
    private SubjectPublishImporter subjectPublishImporter;
    private DashboardPublishImporter dashboardPublishImporter;
    private EmbeddedPublishImporter embeddedPublishImporter;
    private SubjectManageDomain subjectManageDomain;
    private IPublishInfoCollector publishInfoCollector;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setScheduleEngine(IScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    private SubjectImporter getSubjectImporter() {
        if (this.subjectImporter == null) {
            this.subjectImporter = new SubjectImporter();
            this.subjectImporter.setDbExcuter(this.dbExcuter);
            this.subjectImporter.setQingContext(this.qingContext);
            this.subjectImporter.setTx(this.tx);
            this.subjectImporter.setScheduleEngine(this.scheduleEngine);
            this.subjectImporter.registerPublishInfoCollector(this.publishInfoCollector);
        }
        return this.subjectImporter;
    }

    private DashboardImporter getDashboardImporter() {
        if (this.dashboardImporter == null) {
            this.dashboardImporter = new DashboardImporter();
            this.dashboardImporter.setDbExcuter(this.dbExcuter);
            this.dashboardImporter.setQingContext(this.qingContext);
            this.dashboardImporter.setTx(this.tx);
            this.dashboardImporter.registerPublishInfoCollector(this.publishInfoCollector);
        }
        return this.dashboardImporter;
    }

    private AbstractPublishImporter getLappPublishImporter() {
        if (this.lappPublishImporter == null) {
            this.lappPublishImporter = PublishImporterFactory.getPublishExporter(2);
            this.lappPublishImporter.setDbExcuter(this.dbExcuter);
            this.lappPublishImporter.setQingContext(this.qingContext);
            this.lappPublishImporter.setTx(this.tx);
            this.lappPublishImporter.setScheduleEngine(this.scheduleEngine);
        }
        return this.lappPublishImporter;
    }

    private SubjectPublishImporter getSubjectPublishImporter() {
        if (this.subjectPublishImporter == null) {
            this.subjectPublishImporter = new SubjectPublishImporter();
            this.subjectPublishImporter.setDbExcuter(this.dbExcuter);
            this.subjectPublishImporter.setQingContext(this.qingContext);
            this.subjectPublishImporter.setTx(this.tx);
            this.subjectPublishImporter.setScheduleEngine(this.scheduleEngine);
            this.subjectPublishImporter.registerPublishInfoCollector(this.publishInfoCollector);
        }
        return this.subjectPublishImporter;
    }

    private DashboardPublishImporter getDashboardPublishImporter() {
        if (this.dashboardPublishImporter == null) {
            this.dashboardPublishImporter = new DashboardPublishImporter();
            this.dashboardPublishImporter.setDbExcuter(this.dbExcuter);
            this.dashboardPublishImporter.setQingContext(this.qingContext);
            this.dashboardPublishImporter.setTx(this.tx);
        }
        return this.dashboardPublishImporter;
    }

    private EmbeddedPublishImporter getEmbeddedPublishImporter() {
        if (this.embeddedPublishImporter == null) {
            this.embeddedPublishImporter = new EmbeddedPublishImporter();
            this.embeddedPublishImporter.setDbExcuter(this.dbExcuter);
            this.embeddedPublishImporter.setQingContext(this.qingContext);
            this.embeddedPublishImporter.setTx(this.tx);
            this.embeddedPublishImporter.registerPublishInfoCollector(this.publishInfoCollector);
        }
        return this.embeddedPublishImporter;
    }

    private SubjectManageDomain getSubjectManageDomain() {
        if (this.subjectManageDomain == null) {
            this.subjectManageDomain = new SubjectManageDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.subjectManageDomain;
    }

    public void registerPublishInfoCollector(IPublishInfoCollector publishInfoCollector) {
        this.publishInfoCollector = publishInfoCollector;
    }

    @Override
    public Map<String, String> doImport(String fileName) throws SQLException, AbstractQingException, IOException {
        return null;
    }

    public FolderNode parseThemeZipFile(ZipInputStream zis) throws MetaParseException {
        FolderNode root = new FolderNode();
        try {
            String groupName;
            String id;
            String name;
            ThemeVO themeVO;
            PackageMeta meta = new PackageMeta();
            Element mateXmlElement = XmlUtil.loadRootElement((InputStream)ImportUtil.getInputStreamFromZipInputStream(zis));
            meta.fromXml(mateXmlElement);
            List<SubjectObject> subjectObjs = meta.getSubjectObjs();
            List<DashboardObject> dashboardObjs = meta.getDashboardObjs();
            for (SubjectObject subjectObj : subjectObjs) {
                themeVO = subjectObj.getThemeVO();
                name = themeVO.getThemeName();
                id = themeVO.getThemeID();
                groupName = subjectObj.getThemeGroupVO().getThemeGroupName();
                this.addFloderNode(root, name, id, "0", groupName, null);
            }
            for (DashboardObject dashboardObj : dashboardObjs) {
                themeVO = dashboardObj.getThemeVO();
                name = themeVO.getThemeName();
                id = themeVO.getThemeID();
                groupName = dashboardObj.getThemeGroupVO().getThemeGroupName();
                List<DsbRefObject> dsbRefObjs = dashboardObj.getDsbRefObjs();
                ArrayList<String> relativeSubjectId = new ArrayList<String>();
                if (dsbRefObjs != null) {
                    for (DsbRefObject dsbRefObj : dsbRefObjs) {
                        ReferenceMap referenceMap = dsbRefObj.getReferenceMap();
                        if (referenceMap.getRefToId() == null || RefTypeEnum.valueOf((String)referenceMap.getRefType()) != RefTypeEnum.subject) continue;
                        relativeSubjectId.add(referenceMap.getRefToId());
                    }
                }
                this.addFloderNode(root, name, id, "1", groupName, relativeSubjectId);
            }
        }
        catch (Exception e) {
            throw new MetaParseException(e);
        }
        return root;
    }

    public Map<String, Object> importBillPublish(String fileName, String sourceStrategy) throws AbstractQingException {
        ImportParamModel importParamModel = new ImportParamModel();
        Throwable exception = null;
        String cacheIdKey = UUID.randomUUID().toString();
        try {
            this.tx.beginRequired();
            ImportedModel importedModel = this.parseZipFile(fileName, MetaTypeEnum.pkg);
            PackageMeta packageMeta = importedModel.getPackageMeta();
            Map<String, String> tempFile = importedModel.getTempFileMap();
            importParamModel.setPackageMeta(packageMeta);
            importParamModel.setTempFile(tempFile);
            importParamModel.setFileName(fileName);
            importParamModel.setSourceStrategy(sourceStrategy);
            this.getEmbeddedPublishImporter().doImportWithoutTx(importParamModel);
        }
        catch (AbstractQingException e) {
            this.tx.markRollback();
            exception = e;
            this.rollBack(importParamModel);
            FileFactory.clearFile(importParamModel.getSuccessImportFiles());
            throw e;
        }
        catch (Exception e) {
            this.tx.markRollback();
            exception = e;
            this.rollBack(importParamModel);
            FileFactory.clearFile(importParamModel.getSuccessImportFiles());
            throw new ImportException(e);
        }
        catch (Throwable e) {
            throw new ImportException(e);
        }
        finally {
            if (exception == null) {
                this.deleteMapFile(importParamModel.getNeedDeleteMapFile());
            }
            this.tx.end();
        }
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("cacheIdKey", cacheIdKey);
        result.put("conflictPublish", importParamModel.getConfilctPublishList());
        return result;
    }

    private void addFloderNode(FolderNode root, String name, String id, String type, String groupName, List<String> relativeSubjectId) throws AbstractQingIntegratedException, SQLException {
        FolderNode groupFolderNode = null;
        groupFolderNode = new FolderNode();
        groupFolderNode.setName(groupName);
        if (root.getChildCount() == 0 || !root.containChild(groupFolderNode)) {
            String groupId = UUID.randomUUID().toString();
            groupFolderNode.setThemeId(groupId);
            root.addChild(groupFolderNode);
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                FolderNode child = root.getChildren().get(i);
                if (!child.getName().equals(groupName)) continue;
                groupFolderNode = child;
                break;
            }
        }
        FolderNode folderNode = new FolderNode();
        folderNode.setName(name);
        folderNode.setThemeId(id);
        folderNode.setThemeType(type);
        folderNode.setRelativeTheme(relativeSubjectId);
        groupFolderNode.addChild(folderNode);
    }

    public Map<String, Object> importSelected(String fileName, List<ExportThemeVO> selectedThemeList, String sourceStrategy, boolean firstTimeImport, String cacheImportIdKey, String paramPathPrefix) throws AbstractQingException {
        ImportParamModel importParamModel = new ImportParamModel();
        String cacheIdKey = UUID.randomUUID().toString();
        ArrayList<LongerSquarePublishObject> lappSubjectPublishObjects = new ArrayList<LongerSquarePublishObject>();
        ArrayList<DsbPublishObject> lappDsbPublishObjects = new ArrayList<DsbPublishObject>();
        Throwable exception = null;
        try {
            String type;
            this.tx.beginRequired();
            ImportedModel importedModel = this.parseZipFile(fileName, MetaTypeEnum.pkg);
            PackageMeta meta = importedModel.getPackageMeta();
            Map<String, String> tempFile = importedModel.getTempFileMap();
            importParamModel.setPackageMeta(meta);
            importParamModel.setTempFile(tempFile);
            importParamModel.setSourceStrategy(sourceStrategy);
            importParamModel.setFileName(fileName);
            if (selectedThemeList == null) {
                selectedThemeList = this.getAllSubjectOrDashboard(meta.getSubjectObjs(), meta.getDashboardObjs(), sourceStrategy, sourceStrategy);
            }
            if (!firstTimeImport) {
                IQingSession session = QingSessionUtil.getQingSessionImpl();
                HashMap hashMap = new HashMap();
                if (cacheImportIdKey != null && session.get(cacheImportIdKey) != null) {
                    Map map = (Map)JsonUtil.decodeFromString((String)session.get(cacheImportIdKey), Map.class);
                    importParamModel.setImportIds(map);
                }
            }
            for (ExportThemeVO exportThemeVO : selectedThemeList) {
                importParamModel.setExportVO(exportThemeVO);
                type = exportThemeVO.getThemeType();
                if (!type.equals("0")) continue;
                try {
                    this.getSubjectImporter().doImportWithoutTx(importParamModel, lappSubjectPublishObjects);
                }
                catch (EncryptedLicenseCheckException e) {
                    LogUtil.error((String)"import subject check license error", (Throwable)((Object)e));
                }
            }
            for (ExportThemeVO exportThemeVO : selectedThemeList) {
                importParamModel.setExportVO(exportThemeVO);
                type = exportThemeVO.getThemeType();
                if (!type.equals("1")) continue;
                try {
                    this.getDashboardImporter().doImport(importParamModel, lappDsbPublishObjects);
                }
                catch (EncryptedLicenseCheckException e) {
                    LogUtil.error((String)"import dashboard check license error", (Throwable)((Object)e));
                }
            }
            boolean connAvailable = false;
            if (!lappSubjectPublishObjects.isEmpty() || !lappDsbPublishObjects.isEmpty()) {
                connAvailable = LappHelper.isConnAvailable();
            }
            if (connAvailable && !IntegratedHelper.getPresetUserId().equals(this.qingContext.getUserId())) {
                boolean isDuplicate;
                String newPublishId;
                PublishPO publishPO;
                this.getLappPublishImporter().doImport(paramPathPrefix, importParamModel, lappSubjectPublishObjects, lappDsbPublishObjects);
                for (LongerSquarePublishObject lappSubjectPublishObject : lappSubjectPublishObjects) {
                    publishPO = lappSubjectPublishObject.getPublishPO();
                    newPublishId = importParamModel.getNewPublishIdMap().get(publishPO.getId());
                    isDuplicate = false;
                    if (importParamModel.getDuplicateMap().containsKey(newPublishId)) {
                        isDuplicate = importParamModel.getDuplicateMap().get(newPublishId);
                    }
                    if (isDuplicate && !publishPO.isOverwrite()) continue;
                    this.getSubjectPublishImporter().savePublishWithoutTx(lappSubjectPublishObject, null, importParamModel);
                }
                for (DsbPublishObject dsbPublishObject : lappDsbPublishObjects) {
                    publishPO = dsbPublishObject.getPublishPO();
                    newPublishId = importParamModel.getNewPublishIdMap().get(publishPO.getId());
                    isDuplicate = false;
                    if (importParamModel.getDuplicateMap().containsKey(newPublishId)) {
                        isDuplicate = importParamModel.getDuplicateMap().get(newPublishId);
                    }
                    if (isDuplicate && !publishPO.isOverwrite()) continue;
                    this.getDashboardPublishImporter().savePublish(dsbPublishObject, null, importParamModel);
                }
            }
            if (firstTimeImport && importParamModel.getConflictList().size() > 0) {
                IQingSession iQingSession = QingSessionUtil.getQingSessionImpl();
                iQingSession.set(cacheIdKey, JsonUtil.encodeToString(importParamModel.getImportIds()));
            }
        }
        catch (AbstractQingException e) {
            this.tx.markRollback();
            exception = e;
            this.rollBack(importParamModel);
            FileFactory.clearFile(importParamModel.getSuccessImportFiles());
            throw e;
        }
        catch (Exception e) {
            this.tx.markRollback();
            exception = e;
            this.rollBack(importParamModel);
            FileFactory.clearFile(importParamModel.getSuccessImportFiles());
            throw new ImportException(e);
        }
        catch (Throwable e) {
            throw new ImportException(e);
        }
        finally {
            if (exception == null) {
                this.deleteLargeThumb(importParamModel);
                this.deleteMapFile(importParamModel.getNeedDeleteMapFile());
                this.clearOldSubjectData(importParamModel);
            }
            this.tx.end();
        }
        if (importParamModel.getConflictList().size() > 0 && importParamModel.getCacheDsbIdAndUid().size() > 0) {
            IQingSession session = QingSessionUtil.getQingSessionImpl();
            session.set(fileName, JsonUtil.encodeToString(importParamModel.getCacheDsbIdAndUid()));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("cacheIdKey", cacheIdKey);
        result.put("conflictTheme", importParamModel.getConflictList());
        result.put("conflictPublish", importParamModel.getConfilctPublishList());
        return result;
    }

    private void clearOldSubjectData(ImportParamModel importParamModel) {
        List<String> needDeleteFileSubjectId = importParamModel.getNeedDeleteFileSubjectId();
        String userId = this.qingContext.getUserId();
        try {
            for (int i = 0; i < needDeleteFileSubjectId.size(); ++i) {
                String subjectId = needDeleteFileSubjectId.get(i);
                this.getSubjectManageDomain().clearOldSubjectData(userId, subjectId);
            }
        }
        catch (ModelParseException e) {
            LogUtil.error((String)"clear subject data error", (Throwable)e);
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)"clear subject data error", (Throwable)e);
        }
        catch (SQLException e) {
            LogUtil.error((String)"clear subject data error", (Throwable)e);
        }
        catch (ScheduleEngineException e) {
            LogUtil.error((String)"clear subject data error", (Throwable)e);
        }
        catch (EncryptedLicenseCheckException e) {
            LogUtil.error((String)"clear subject data error", (Throwable)((Object)e));
        }
    }

    private void deleteMapFile(List<String> fileNames) {
        if (fileNames != null) {
            for (String fileName : fileNames) {
                IQingFileUpdater file = FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.MAP, (String)fileName);
                if (!file.exists()) continue;
                file.delete();
            }
        }
    }

    private void rollBack(ImportParamModel importParamModel) {
        Map<String, String> analysisIdMap = importParamModel.getAnalysisIdMap();
        ArrayList<String> analysisIds = new ArrayList<String>();
        if (analysisIdMap != null && analysisIdMap.size() > 0) {
            for (Map.Entry<String, String> analysisIdEntry : analysisIdMap.entrySet()) {
                String analysisId = analysisIdEntry.getValue();
                analysisIds.add(analysisId);
            }
        }
        if (analysisIds.size() > 0) {
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            paramMap.put("lappUserId", this.qingContext.getUserId());
            paramMap.put("lappUserType", LappContext.UserType.YZJ_OPENID.toPersistance());
            LappHelper.post(LappApiEnum.QIMG_GET_LAPP_ROLL_BACK_URL, null, JsonUtil.encodeToString(analysisIds), paramMap);
        }
    }

    private void deleteLargeThumb(ImportParamModel importParamModel) {
        Map<String, String> analysisIdMap = importParamModel.getAnalysisIdMap();
        Map<String, String> needOverwritePublishIdMap = importParamModel.getNeedOverwritePublishId();
        ArrayList<String> analysisIds = new ArrayList<String>();
        if (analysisIdMap != null && analysisIdMap.size() > 0) {
            for (Map.Entry<String, String> entry : analysisIdMap.entrySet()) {
                if (needOverwritePublishIdMap == null || needOverwritePublishIdMap.size() <= 0) continue;
                for (Map.Entry<String, String> newPublishIdEntry : needOverwritePublishIdMap.entrySet()) {
                    String oldPublishId = newPublishIdEntry.getValue();
                    if (oldPublishId == null || !entry.getKey().equals(oldPublishId)) continue;
                    String analysisId = entry.getValue();
                    analysisIds.add(analysisId);
                }
            }
        }
        if (analysisIds.size() > 0) {
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            paramMap.put("lappUserId", this.qingContext.getUserId());
            paramMap.put("lappUserType", LappContext.UserType.YZJ_OPENID.toPersistance());
            LappHelper.post(LappApiEnum.QIMG_GET_LAPP_DELETE_LARGE_THUMB_URL, null, JsonUtil.encodeToString(analysisIds), paramMap);
        }
    }

    private List<ExportThemeVO> getAllSubjectOrDashboard(List<SubjectObject> subjectObjs, List<DashboardObject> dashboardObjs, String strategy, String publishStrategy) throws IOException, MetaParseException, JDOMException, ModelParseException, ImportException, ImportMetaFileException, ImportMetaTypeException {
        ArrayList<ExportThemeVO> exportVOList = new ArrayList<ExportThemeVO>(10);
        for (SubjectObject subjectObj : subjectObjs) {
            ThemeVO subjectVO = subjectObj.getThemeVO();
            ThemeGroupVO subjectGroupVO = subjectObj.getThemeGroupVO();
            ExportThemeVO exportSubjectVO = new ExportThemeVO();
            exportSubjectVO.setDescription(subjectVO.getDescription());
            exportSubjectVO.setThemeGroupID(subjectGroupVO.getThemeGroupID());
            exportSubjectVO.setThemeGroupName(subjectGroupVO.getThemeGroupName());
            exportSubjectVO.setThemeID(subjectVO.getThemeID());
            exportSubjectVO.setThemeName(subjectVO.getThemeName());
            exportSubjectVO.setThemeType("0");
            exportSubjectVO.setStrategy(strategy);
            exportSubjectVO.setPublishStrategy(publishStrategy);
            exportVOList.add(exportSubjectVO);
        }
        for (DashboardObject dashboardObj : dashboardObjs) {
            ThemeVO dsbVO = dashboardObj.getThemeVO();
            ThemeGroupVO dsbGroupVO = dashboardObj.getThemeGroupVO();
            ExportThemeVO exportDsbtVO = new ExportThemeVO();
            exportDsbtVO.setDescription(dsbVO.getDescription());
            exportDsbtVO.setThemeGroupID(dsbGroupVO.getThemeGroupID());
            exportDsbtVO.setThemeGroupName(dsbGroupVO.getThemeGroupName());
            exportDsbtVO.setThemeID(dsbVO.getThemeID());
            exportDsbtVO.setThemeName(dsbVO.getThemeName());
            exportDsbtVO.setThemeType("1");
            exportDsbtVO.setStrategy(strategy);
            exportDsbtVO.setPublishStrategy(publishStrategy);
            exportVOList.add(exportDsbtVO);
        }
        return exportVOList;
    }

    public static interface IPublishInfoCollector {
        public void collectPublishInfo(String var1, PublishPO var2);

        public void clear();
    }
}

