/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.pkg.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.dao.DashboardDao;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.source.IFileSavable;
import com.kingdee.bos.qing.filesystem.exception.QingFileStorageLimitException;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.imexport.importer.exception.ImportSubjectException;
import com.kingdee.bos.qing.imexport.importer.pkg.domain.ImportPKGDomain;
import com.kingdee.bos.qing.imexport.importer.pkg.integration.IntegrationImportHelper;
import com.kingdee.bos.qing.imexport.importer.pkg.model.ImportParamModel;
import com.kingdee.bos.qing.imexport.importer.pkg.publish.SubjectPublishImporter;
import com.kingdee.bos.qing.imexport.importer.pkg.source.MacroImporter;
import com.kingdee.bos.qing.imexport.importer.pkg.source.MapImporter;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.SchemaInfo;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.publish.LongerSquarePublishObject;
import com.kingdee.bos.qing.imexport.model.resource.DBConnInfo;
import com.kingdee.bos.qing.imexport.model.resource.Macro;
import com.kingdee.bos.qing.imexport.model.resource.Resources;
import com.kingdee.bos.qing.imexport.model.subject.AnalysisObject;
import com.kingdee.bos.qing.imexport.model.subject.DataModelingObject;
import com.kingdee.bos.qing.imexport.model.subject.SubjectObject;
import com.kingdee.bos.qing.imexport.oplog.ImexportOpLog;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.macro.exception.NoMacroManagePermException;
import com.kingdee.bos.qing.macro.exception.QingMacroException;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.IThemeGroupDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.dao.impl.ThemeGroupDaoImpl;
import com.kingdee.bos.qing.manage.domain.impl.SubjectManageDomain;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.exception.ImportThemeFileSizeLimitException;
import com.kingdee.bos.qing.manage.exception.ThemeGroupDuplicateNameException;
import com.kingdee.bos.qing.manage.exception.ThemeNameDuplicateException;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportThemeVO;
import com.kingdee.bos.qing.manage.model.ThemeGroupPO;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.map.domain.MapManageDomain;
import com.kingdee.bos.qing.map.exception.MapException;
import com.kingdee.bos.qing.map.imexport.model.ExportMapModel;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.publish.dao.DashboardPublishDao;
import com.kingdee.bos.qing.publish.exception.MapNotFoundException;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.schema.domain.SchemaDomain;
import com.kingdee.bos.qing.schema.exception.SchemaManagerException;
import com.kingdee.bos.qing.schema.model.SchemaAttrVO;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.schema.model.SchemaVO;
import com.kingdee.bos.qing.subject.dao.BoxSerializationUtil;
import com.kingdee.bos.qing.util.BoxUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.ModelBookUtil;
import com.kingdee.bos.qing.util.OpLogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.JDOMException;

public class SubjectImporter {
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private IThemeGroupDao iThemeGroupDao;
    private IThemeDao iThemeDao;
    private SchemaDomain schemaDomain;
    private SubjectManageDomain subjectManageDomain;
    private SchemaManageDao schemaManageDao;
    private MapImporter mapImporter;
    private SubjectPublishImporter subjectPublishImporter;
    private IScheduleEngine scheduleEngine;
    private MacroImporter macroImporter;
    private MapManageDomain mapManageDomain;
    private DashboardDao dashboardDao;
    private DashboardPublishDao dashboardPublishDao;
    private ImportPKGDomain.IPublishInfoCollector publishInfoCollector;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setScheduleEngine(IScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    private IThemeGroupDao getThemeGroupDao() {
        if (this.iThemeGroupDao == null) {
            this.iThemeGroupDao = new ThemeGroupDaoImpl(this.dbExcuter);
        }
        return this.iThemeGroupDao;
    }

    private IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    private SchemaDomain getSchemaDomain() {
        if (this.schemaDomain == null) {
            this.schemaDomain = new SchemaDomain();
            this.schemaDomain.setTx(this.tx);
            this.schemaDomain.setDbExcuter(this.dbExcuter);
        }
        return this.schemaDomain;
    }

    private SubjectManageDomain getSubjectManageDomain() {
        if (this.subjectManageDomain == null) {
            this.subjectManageDomain = new SubjectManageDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.subjectManageDomain;
    }

    private SchemaManageDao getSchemaManageDao() {
        if (this.schemaManageDao == null) {
            this.schemaManageDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaManageDao;
    }

    private MapImporter getMapImporter() {
        if (this.mapImporter == null) {
            this.mapImporter = new MapImporter();
            this.mapImporter.setDbExcuter(this.dbExcuter);
            this.mapImporter.setQingContext(this.qingContext);
            this.mapImporter.setTx(this.tx);
        }
        return this.mapImporter;
    }

    private SubjectPublishImporter getSubjectPublishImporter() {
        if (this.subjectPublishImporter == null) {
            this.subjectPublishImporter = new SubjectPublishImporter();
            this.subjectPublishImporter.setDbExcuter(this.dbExcuter);
            this.subjectPublishImporter.setQingContext(this.qingContext);
            this.subjectPublishImporter.setTx(this.tx);
            this.subjectPublishImporter.setScheduleEngine(this.scheduleEngine);
            this.subjectPublishImporter.registerPublishInfoCollector(this.publishInfoCollector);
        }
        return this.subjectPublishImporter;
    }

    private MapManageDomain getMapManageDomain() {
        if (this.mapManageDomain == null) {
            this.mapManageDomain = new MapManageDomain();
            this.mapManageDomain.setDbExcuter(this.dbExcuter);
            this.mapManageDomain.setQingContext(this.qingContext);
            this.mapManageDomain.setTx(this.tx);
        }
        return this.mapManageDomain;
    }

    private DashboardDao getDashboardDao() {
        if (this.dashboardDao == null) {
            this.dashboardDao = new DashboardDao(this.dbExcuter);
        }
        return this.dashboardDao;
    }

    private DashboardPublishDao getDashboardPublishDao() {
        if (this.dashboardPublishDao == null) {
            this.dashboardPublishDao = new DashboardPublishDao(this.dbExcuter);
        }
        return this.dashboardPublishDao;
    }

    private MacroImporter getMacroImporter() {
        if (this.macroImporter == null) {
            this.macroImporter = new MacroImporter(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.macroImporter;
    }

    public void registerPublishInfoCollector(ImportPKGDomain.IPublishInfoCollector publishInfoCollector) {
        this.publishInfoCollector = publishInfoCollector;
    }

    public void doImportWithoutTx(ImportParamModel importParamModel, List<LongerSquarePublishObject> lappSubjectPublishObjects) throws ImportThemeFileSizeLimitException, ImportSubjectException, EncryptedLicenseCheckException {
        String userId = this.qingContext.getUserId();
        PackageMeta meta = importParamModel.getPackageMeta();
        ExportThemeVO exportSubjectVO = importParamModel.getExportVO();
        Map<String, String> importIds = importParamModel.getImportIds();
        List<SubjectObject> subjectObjs = meta.getSubjectObjs();
        List<ExportThemeVO> conflictExportList = importParamModel.getConflictList();
        HashSet<String> macroUids = new HashSet<String>();
        boolean addGroup = false;
        try {
            for (SubjectObject subjectObj : subjectObjs) {
                String oldSubjectName;
                ThemePO themePO;
                String oldSubjectId;
                String subjectId;
                String groupId;
                ThemeGroupVO themeGroupVO;
                boolean publishOverWrite;
                Box box;
                String boxFileName;
                ThemeVO subjectVO;
                block20: {
                    subjectVO = subjectObj.getThemeVO();
                    if (!exportSubjectVO.getThemeID().equals(subjectVO.getThemeID())) continue;
                    DataModelingObject dataModelingObj = subjectObj.getDataModelingObj();
                    boxFileName = importParamModel.getTempFile().get(dataModelingObj.getBoxFileName());
                    box = new Box();
                    InputStream boxOrignalStream = null;
                    if (boxFileName != null && (boxOrignalStream = BoxUtil.getBoxStreamByFileName(boxFileName, (AbstractQingFileType)QingTempFileType.UPLOAD)) != null) {
                        box = BoxSerializationUtil.toModel(boxOrignalStream, true);
                    }
                    publishOverWrite = false;
                    String publishStrategy = exportSubjectVO.getPublishStrategy();
                    if (publishStrategy != null && ExportThemeVO.StrategyType.overwrite.toPersistance().equals(publishStrategy)) {
                        publishOverWrite = true;
                    }
                    themeGroupVO = subjectObj.getThemeGroupVO();
                    groupId = null;
                    if (importIds.get(themeGroupVO.getThemeGroupName()) != null) {
                        groupId = importIds.get(themeGroupVO.getThemeGroupName());
                    } else {
                        ThemeGroupPO groupPO = new ThemeGroupPO();
                        groupPO.setThemeGroupName(themeGroupVO.getThemeGroupName());
                        groupPO.setUserID(userId);
                        try {
                            groupId = this.getThemeGroupDao().saveThemeGroup(groupPO);
                            addGroup = true;
                        }
                        catch (ThemeGroupDuplicateNameException e) {
                            ThemeGroupVO newThemeGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupName(userId, themeGroupVO.getThemeGroupName());
                            groupId = newThemeGroupVO.getThemeGroupID();
                        }
                    }
                    importIds.put(themeGroupVO.getThemeGroupName(), groupId);
                    subjectId = null;
                    oldSubjectId = subjectVO.getThemeID();
                    themePO = new ThemePO();
                    oldSubjectName = subjectVO.getThemeName();
                    try {
                        themePO.setThemeName(subjectVO.getThemeName());
                        themePO.setThemeType("0");
                        themePO.setDescription(subjectVO.getDescription());
                        themePO.setUserID(userId);
                        themePO.setGroupID(groupId);
                        subjectId = this.getThemeDao().saveOrUpdateTheme(themePO);
                        this.addOpLog(themeGroupVO.getThemeGroupName(), themePO.getThemeName());
                    }
                    catch (ThemeNameDuplicateException e) {
                        if (exportSubjectVO.getStrategy() == null) {
                            conflictExportList.add(exportSubjectVO);
                            if (!addGroup) continue;
                            this.getThemeGroupDao().deleteThemeGroup(userId, groupId);
                            continue;
                        }
                        ExportThemeVO.StrategyType strategyType = ExportThemeVO.StrategyType.valueOf(exportSubjectVO.getStrategy());
                        if (strategyType == ExportThemeVO.StrategyType.overwrite) {
                            this.overwriteImportSubject(themePO, themeGroupVO);
                            subjectId = themePO.getThemeID();
                        }
                        if (strategyType != ExportThemeVO.StrategyType.rename) break block20;
                        this.renameImportTheme(themePO, themeGroupVO);
                        subjectId = themePO.getThemeID();
                    }
                }
                importIds.put(oldSubjectId, subjectId);
                if (boxFileName != null) {
                    List macroUidsInBox = box.collectMacroUid();
                    macroUids.addAll(macroUidsInBox);
                    List sourceList = box.getSources();
                    if (sourceList != null) {
                        for (AbstractSource source : sourceList) {
                            if (!(source instanceof IFileSavable)) continue;
                            String fileName = ((IFileSavable)source).getFileName();
                            String fileExtension = "";
                            if (fileName.indexOf(".") > -1) {
                                fileExtension = fileName.substring(fileName.lastIndexOf("."));
                            }
                            String tempFilePathName = ((IFileSavable)source).getFileUrl();
                            ((IFileSavable)source).setFileUrl(importParamModel.getTempFile().get(tempFilePathName + fileExtension));
                        }
                    }
                    InputStream boxStream = BoxUtil.getBoxStreamByFileName(boxFileName, (AbstractQingFileType)QingTempFileType.UPLOAD);
                    this.getSubjectManageDomain().doSave(userId, subjectId, themePO.getThemeName(), box, importParamModel.getSuccessImportFiles(), boxStream);
                } else {
                    String strategyType = exportSubjectVO.getStrategy();
                    if (strategyType != null && ExportThemeVO.StrategyType.valueOf(strategyType) == ExportThemeVO.StrategyType.overwrite) {
                        importParamModel.getNeedDeleteFileSubjectId().add(subjectId);
                    }
                }
                this.importSchema(importParamModel, subjectObj, subjectId);
                subjectVO.setThemeID(subjectId);
                subjectVO.setThemeType("0");
                this.getSubjectPublishImporter().doImportWithoutTx(importParamModel, subjectVO, oldSubjectId, publishOverWrite, lappSubjectPublishObjects);
                this.updateDsbRefToIdOfImport(themeGroupVO.getThemeGroupName(), groupId, oldSubjectName, subjectId, importParamModel.getFileName());
                this.importMacroAndDBConnInfoWithoutTx(importParamModel, macroUids);
            }
            this.importIntegrationWithoutTx(importParamModel);
        }
        catch (QingFileStorageLimitException e) {
            throw new ImportThemeFileSizeLimitException(e);
        }
        catch (Exception e) {
            throw new ImportSubjectException(e);
        }
    }

    private void addOpLog(String groupName, String themeName) {
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(themeName);
        params.add(groupName);
        ImexportOpLog qingAnalysisGroupDir = ImexportOpLog.QING_ANALYSIS_GROUP_DIR;
        qingAnalysisGroupDir.setLogScene("\u4e1a\u52a1\u4e3b\u9898");
        OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.IMPORT, (IOpLogConstant)qingAnalysisGroupDir, params));
    }

    private void importIntegrationWithoutTx(ImportParamModel importParamModel) {
        IntegrationImportHelper.importIntegrationWithoutTx(this.qingContext, this.dbExcuter, importParamModel);
    }

    private void importMacroAndDBConnInfoWithoutTx(ImportParamModel importParamModel, Set<String> macroUids) throws QingMacroException, AbstractQingIntegratedException, SQLException, NoMacroManagePermException {
        PackageMeta meta = importParamModel.getPackageMeta();
        Resources resources = meta.getResources();
        List<Macro> macros = resources.getMacros();
        List<DBConnInfo> dbConnInfos = resources.getDBConnInfos();
        for (String macroUid : macroUids) {
            for (Macro macro : macros) {
                if (!macro.getUid().equals(macroUid)) continue;
                this.getMacroImporter().doImportWithoutTx(importParamModel, macro, dbConnInfos);
            }
        }
    }

    private void importSchema(ImportParamModel importParamModel, SubjectObject subjectObj, String subjectId) throws MapException, AbstractQingIntegratedException, SQLException, PersistentModelParseException, PersistentModelTooModernException, JDOMException, IOException, MapNotFoundException, SchemaManagerException {
        Map<String, String> tempFile = importParamModel.getTempFile();
        Map<String, String> importIds = importParamModel.getImportIds();
        AnalysisObject analysisObj = subjectObj.getAnalysisObj();
        List<SchemaObject> schemaObjs = analysisObj.getSchemaObjs();
        String userId = this.qingContext.getUserId();
        if (schemaObjs != null) {
            for (SchemaObject schemaObj : schemaObjs) {
                SchemaInfo schemaInfo = schemaObj.getSchemaInfo();
                SchemaBO schemaBO = schemaInfo.getSchemaBO();
                ModelBook modelBook = ModelBookUtil.fromFile((AbstractQingFileType)QingTempFileType.UPLOAD, tempFile.get(schemaInfo.getSchemaContentFile()));
                List<OutsideReference> outSideRefs = schemaObj.getOutSideRefs();
                if (outSideRefs != null && outSideRefs.size() > 0) {
                    for (OutsideReference outsideReference : outSideRefs) {
                        outsideReference.setRefType("Map");
                        String oldMapId = outsideReference.getRefToId();
                        String newMapId = null;
                        if (importIds.get(oldMapId) != null) {
                            newMapId = importIds.get(oldMapId);
                        } else if (oldMapId != null) {
                            newMapId = this.getMapImporter().doImportWithoutTx(importParamModel, oldMapId);
                        }
                        if (newMapId != null) {
                            outsideReference.setRefToFullPath(null);
                            outsideReference.setRefToId(newMapId);
                            importIds.put(oldMapId, newMapId);
                            continue;
                        }
                        String mapFullPath = outsideReference.getRefToFullPath();
                        if (StringUtils.isNotEmpty((CharSequence)mapFullPath)) {
                            PathModel pathModel = (PathModel)JsonUtil.decodeFromString((String)mapFullPath, PathModel.class);
                            if (pathModel != null) {
                                String nameSpace = NameSpace.valueOf((String)pathModel.getNameSpace()).getCode();
                                ExportMapModel exportMapModel = this.getMapManageDomain().loadMapByNameAndGroupName(pathModel.getGroupName(), pathModel.getName(), nameSpace);
                                if (exportMapModel != null) {
                                    outsideReference.setRefToFullPath(null);
                                    outsideReference.setRefToId(exportMapModel.getMapId());
                                    continue;
                                }
                                outsideReference.setRefToId(null);
                                continue;
                            }
                            outsideReference.setRefToId(null);
                            continue;
                        }
                        outsideReference.setRefToId(null);
                    }
                    modelBook.fixReferences(outSideRefs);
                }
                SchemaAttrVO schemaAttr = new SchemaAttrVO();
                schemaAttr.setIsDefault(schemaBO.IsDefault());
                schemaAttr.setSchemaName(schemaBO.getSchemaName());
                schemaAttr.setSchemaType(schemaBO.getSchemaType());
                schemaAttr.setSource(schemaBO.getSource());
                schemaAttr.setSeq(schemaBO.getSeq());
                SchemaVO vo = new SchemaVO();
                vo.setSchemaContent(modelBook);
                vo.setSchemaAttr(schemaAttr);
                this.getSchemaDomain().saveSchemaWithoutTx(subjectId, userId, vo);
            }
        }
    }

    private void renameImportTheme(ThemePO themePO, ThemeGroupVO themeGroupVO) throws AbstractQingIntegratedException, SQLException {
        boolean bInsert = false;
        String themeID = null;
        String themeName = null;
        themePO.setThemeID(null);
        while (!bInsert) {
            String conFlictThemeName = themePO.getThemeName();
            themeName = ImExportUtil.rename(conFlictThemeName);
            themePO.setThemeName(themeName);
            try {
                themeID = this.getThemeDao().saveOrUpdateTheme(themePO);
                bInsert = true;
            }
            catch (ThemeNameDuplicateException e) {
                bInsert = false;
            }
            if (!bInsert) continue;
            this.addOpLog(themeGroupVO.getThemeGroupName(), themePO.getThemeName());
        }
        themePO.setThemeID(themeID);
    }

    private void overwriteImportSubject(ThemePO themePO, ThemeGroupVO themeGroupVO) throws AbstractQingIntegratedException, SQLException {
        String themeID;
        ThemeVO themeVO = this.getThemeDao().loadThemeByName(themePO.getUserID(), themePO.getGroupID(), themePO.getThemeName(), themePO.getThemeType());
        if (themeVO != null) {
            themeID = themeVO.getThemeID();
            themePO.setThemeID(themeID);
            this.getSchemaManageDao().deleteSchemaByBizTag(themeID);
        }
        try {
            themeID = this.getThemeDao().saveOrUpdateTheme(themePO);
            themePO.setThemeID(themeID);
        }
        catch (ThemeNameDuplicateException e) {
            LogUtil.error((String)"ThemeNameDuplicateException: ", (Throwable)((Object)e));
        }
        this.addOpLog(themeGroupVO.getThemeGroupName(), themePO.getThemeName());
    }

    private void updateDsbRefToIdOfImport(String groupName, String groupId, String subjectName, String subjectId, String fileName) throws AbstractQingIntegratedException, ImportThemeException, SQLException {
        PathModel pathModel = new PathModel();
        pathModel.setNameSpace(NameSpace.user.toPersistance());
        pathModel.setGroupName(groupName);
        pathModel.setName(subjectName);
        String themePath = JsonUtil.encodeToString((Object)pathModel);
        Map cacheDsbId = (Map)JsonUtil.decodeFromString((String)QingSessionUtil.get((String)fileName), Map.class);
        if (cacheDsbId != null && cacheDsbId.containsKey(themePath)) {
            List dsbIdAndUids = (List)cacheDsbId.get(themePath);
            for (int i = 0; i < dsbIdAndUids.size(); ++i) {
                String[] ids = ((String)dsbIdAndUids.get(i)).split(",");
                this.updateRef(ids, subjectId);
            }
            cacheDsbId.remove(themePath);
        }
        this.getSubjectManageDomain().updateDsbRefToId(groupId, subjectId, subjectName);
    }

    private void updateRef(String[] ids, String refToId) throws ImportThemeException, AbstractQingIntegratedException {
        block4: {
            String refFromId = ids[0];
            String uid = ids[1];
            ReferenceMap ref = new ReferenceMap();
            ref.setRefToFullPath(null);
            ref.setRefToId(refToId);
            ref.setUid(uid);
            try {
                if ("dsb".equals(ids[2])) {
                    ref.put((Object)"dsbId", (Object)refFromId);
                    this.getDashboardDao().updateRef(ref);
                    break block4;
                }
                if ("publishDsb".equals(ids[2])) {
                    ref.put((Object)"publishId", (Object)refFromId);
                    this.getDashboardPublishDao().updateRef(ref);
                    break block4;
                }
                throw new RuntimeException("do something.");
            }
            catch (SQLException e) {
                throw new ImportThemeException(e);
            }
        }
    }
}

