/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.pkg.source;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.imexport.importer.pkg.model.ImportParamModel;
import com.kingdee.bos.qing.imexport.model.MetaTypeEnum;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.resource.QingMap;
import com.kingdee.bos.qing.imexport.model.resource.Resources;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportThemeVO;
import com.kingdee.bos.qing.map.dao.MapDesignerDao;
import com.kingdee.bos.qing.map.dao.MapManageDao;
import com.kingdee.bos.qing.map.domain.MapManageDomain;
import com.kingdee.bos.qing.map.exception.MapDuplicateNameException;
import com.kingdee.bos.qing.map.exception.MapException;
import com.kingdee.bos.qing.map.exception.MapGroupDuplicateNameException;
import com.kingdee.bos.qing.map.imexport.MapImExportDomain;
import com.kingdee.bos.qing.map.model.MapGroupVO;
import com.kingdee.bos.qing.map.model.MapModelContent;
import com.kingdee.bos.qing.map.model.MapPO;
import com.kingdee.bos.qing.map.model.MapType;
import com.kingdee.bos.qing.map.model.MapVO;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class MapImporter {
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private MapManageDomain mapManageDomain;
    private MapDesignerDao mapDesignerDao;
    private MapManageDao mapManageDao;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    private MapManageDomain getMapManageDomin() {
        if (this.mapManageDomain == null) {
            this.mapManageDomain = new MapManageDomain();
            this.mapManageDomain.setDbExcuter(this.dbExcuter);
            this.mapManageDomain.setQingContext(this.qingContext);
            this.mapManageDomain.setTx(this.tx);
        }
        return this.mapManageDomain;
    }

    private MapDesignerDao getMapDesignerDao() {
        if (this.mapDesignerDao == null) {
            this.mapDesignerDao = new MapDesignerDao();
            this.mapDesignerDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapDesignerDao;
    }

    private MapManageDao getMapManageDao() {
        if (this.mapManageDao == null) {
            this.mapManageDao = new MapManageDao();
            this.mapManageDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapManageDao;
    }

    public String doImportWithoutTx(ImportParamModel importParamModel, String oldMapId) throws MapException, AbstractQingIntegratedException, SQLException {
        PackageMeta meta = importParamModel.getPackageMeta();
        Resources resources = meta.getResources();
        List<QingMap> qingMaps = resources.getQingMaps();
        QingMap importMap = null;
        for (QingMap qingMap : qingMaps) {
            if (!oldMapId.equals(qingMap.getId())) continue;
            importMap = qingMap;
            break;
        }
        if (importMap == null) {
            return null;
        }
        NameSpace nameSpace = this.qingContext.getUserId().equals(IntegratedHelper.getPresetUserId()) ? NameSpace.system : NameSpace.user;
        String groupName = importMap.getCategoryName();
        String name = importMap.getName();
        if (!IntegratedHelper.checkMapPermission((QingContext)this.qingContext) && importParamModel.getPackageMeta().getType().equals(MetaTypeEnum.pkg.name())) {
            MapVO oldMapVO;
            MapGroupVO mapGroupVO = this.getMapManageDomin().loadMapGroupByName(groupName);
            if (mapGroupVO != null && (oldMapVO = this.getMapManageDomin().loadMapByNameAndGroupId(mapGroupVO.getMapGroupId(), name, MapType.Map.toPersistance())) != null) {
                return oldMapVO.getMapId();
            }
            return null;
        }
        String desc = importMap.getDesc();
        String version = importMap.getVersion();
        MapVO mapVO = new MapVO();
        mapVO.setMapDescription(desc);
        mapVO.setMapGroupName(groupName);
        mapVO.setMapName(name);
        mapVO.setMapType(MapType.Map);
        mapVO.setNameSpace(nameSpace.getCode());
        mapVO.setVersion(version);
        String mapId = this.saveMapWithoutTx(importParamModel, mapVO, oldMapId);
        importParamModel.getImportIds().put(oldMapId, mapId);
        return mapId;
    }

    private String saveMapWithoutTx(ImportParamModel importParamModel, MapVO mapVO, String oldMapId) throws MapException, AbstractQingIntegratedException, SQLException {
        String mapId;
        block14: {
            String sourceStrategy = importParamModel.getSourceStrategy();
            ExportThemeVO.StrategyType sourceStrategyEnum = ExportThemeVO.StrategyType.valueOf(sourceStrategy);
            String mapGroupName = mapVO.getMapGroupName();
            String mapGroupId = null;
            MapGroupVO mapGroupVO = null;
            try {
                mapGroupVO = this.getMapManageDomin().loadMapGroupByName(mapGroupName);
                if (mapGroupVO == null) {
                    mapGroupVO = new MapGroupVO();
                    mapGroupVO.setMapGroupName(mapGroupName);
                    mapGroupId = this.getMapManageDomin().saveMapGroupWithoutTx(mapGroupVO);
                } else {
                    mapGroupId = mapGroupVO.getMapGroupId();
                }
            }
            catch (MapGroupDuplicateNameException e) {
                LogUtil.error((String)e.getMessage(), (Throwable)((Object)e));
            }
            NameSpace nameSpace = this.qingContext.getUserId().equals(IntegratedHelper.getPresetUserId()) ? NameSpace.system : NameSpace.user;
            String userId = this.qingContext.getUserId();
            mapVO.setMapGroupId(mapGroupId);
            Date createDate = new Date();
            MapPO mapPO = mapVO.toMapPO();
            mapPO.setMapCreateDate(createDate);
            mapPO.setMapModifyDate(createDate);
            mapPO.setCreatorId(userId);
            mapPO.setUpdaterId(userId);
            mapId = null;
            mapPO.setNameSpace(nameSpace);
            try {
                mapId = this.getMapManageDao().saveMap(mapPO);
                mapPO.setMapId(mapId);
                this.saveMapContentWithoutTx(importParamModel, oldMapId, mapId);
                this.getMapManageDomin().updateRefToIdWithoutTx(mapGroupVO, mapPO);
            }
            catch (MapDuplicateNameException e) {
                if (sourceStrategyEnum == null) break block14;
                if (ExportThemeVO.StrategyType.rename == sourceStrategyEnum) {
                    this.addNameSuffix(mapVO);
                    mapPO.setMapName(mapVO.getMapName());
                    mapId = this.getMapManageDao().saveMap(mapPO);
                    mapPO.setMapId(mapId);
                    this.saveMapContentWithoutTx(importParamModel, oldMapId, mapId);
                } else if (ExportThemeVO.StrategyType.overwrite == sourceStrategyEnum) {
                    MapVO oldMapVO = this.getMapManageDomin().loadMapByNameAndGroupId(mapVO.getMapGroupId(), mapVO.getMapName(), mapVO.getMapType().toPersistance());
                    mapId = oldMapVO.getMapId();
                    mapPO.setMapId(mapId);
                    if (nameSpace == NameSpace.system) {
                        String version;
                        String dbVersion = oldMapVO.getVersion();
                        if (!MapImExportDomain.checkMapDBVersionIsNewest(dbVersion, version = mapPO.getVersion())) {
                            this.addNeedDeleteFile(importParamModel, mapId);
                            this.getMapManageDao().updateMap(mapPO);
                            this.getMapDesignerDao().deleteMapContent(mapId);
                            this.saveMapContentWithoutTx(importParamModel, oldMapId, mapId);
                        }
                    } else {
                        this.addNeedDeleteFile(importParamModel, mapId);
                        this.getMapManageDao().updateMap(mapPO);
                        this.getMapDesignerDao().deleteMapContent(mapId);
                        this.saveMapContentWithoutTx(importParamModel, oldMapId, mapId);
                    }
                } else {
                    MapVO oldMapVO;
                    mapId = null;
                    mapGroupVO = this.getMapManageDomin().loadMapGroupByName(mapGroupName);
                    if (mapGroupVO != null && (oldMapVO = this.getMapManageDomin().loadMapByNameAndGroupId(mapGroupVO.getMapGroupId(), mapGroupName, MapType.Map.toPersistance())) != null) {
                        this.getMapManageDomin().updateRefToIdWithoutTx(mapGroupVO, mapPO);
                        mapId = oldMapVO.getMapId();
                    }
                }
                this.getMapManageDomin().updateRefToIdWithoutTx(mapGroupVO, mapPO);
            }
        }
        return mapId;
    }

    private void addNeedDeleteFile(ImportParamModel importParamModel, String mapId) throws AbstractQingIntegratedException, SQLException {
        MapModelContent mapModelContent = this.getMapDesignerDao().loadMapContent(mapId);
        if (mapModelContent != null) {
            String modelFileName = mapModelContent.getMapModelFileName();
            String configFileName = mapModelContent.getMapConfigFileName();
            String svgFileName = mapModelContent.getMapSvgFileName();
            String imageFileName = mapModelContent.getImageFileName();
            String thumbnailFileName = mapModelContent.getMapThumbnailFileName();
            if (modelFileName != null && importParamModel.getNeedDeleteMapFile().indexOf(modelFileName) == -1) {
                importParamModel.addNeedDeleteMapFile(modelFileName);
            }
            if (configFileName != null && importParamModel.getNeedDeleteMapFile().indexOf(configFileName) == -1) {
                importParamModel.addNeedDeleteMapFile(configFileName);
            }
            if (svgFileName != null && importParamModel.getNeedDeleteMapFile().indexOf(svgFileName) == -1) {
                importParamModel.addNeedDeleteMapFile(svgFileName);
            }
            if (imageFileName != null && importParamModel.getNeedDeleteMapFile().indexOf(imageFileName) == -1) {
                importParamModel.addNeedDeleteMapFile(imageFileName);
            }
            if (thumbnailFileName != null && importParamModel.getNeedDeleteMapFile().indexOf(thumbnailFileName) == -1) {
                importParamModel.addNeedDeleteMapFile(thumbnailFileName);
            }
        }
    }

    private void saveMapContentWithoutTx(ImportParamModel importParamModel, String oldMapId, String mapId) throws MapException, AbstractQingIntegratedException, SQLException {
        Map<String, String> tempFile = importParamModel.getTempFile();
        List<IQingFile> successImportFiles = importParamModel.getSuccessImportFiles();
        String modelTempFileName = tempFile.get(oldMapId + ".model");
        String svgTempFileName = tempFile.get(oldMapId + ".svg");
        String configTempFileName = tempFile.get(oldMapId + ".config");
        String thumbnailTempFileName = tempFile.get(oldMapId + ".thumbnail");
        String backgroundImageTempFileName = tempFile.get(oldMapId + ".background-image");
        IQingFile imageFile = this.importMapFile(backgroundImageTempFileName);
        IQingFile modelFile = this.importMapFile(modelTempFileName);
        IQingFile svgFile = this.importMapFile(svgTempFileName);
        IQingFile configFile = this.importMapFile(configTempFileName);
        IQingFile thumbnailFile = this.importMapFile(thumbnailTempFileName);
        if (modelFile != null && svgFile != null && configFile != null && thumbnailFile != null) {
            MapModelContent mapModelContent = new MapModelContent();
            if (imageFile != null) {
                mapModelContent.setImageFileName(imageFile.getName());
                successImportFiles.add(imageFile);
            }
            mapModelContent.setMapConfigFileName(configFile.getName());
            mapModelContent.setMapModelFileName(modelFile.getName());
            mapModelContent.setMapSvgFileName(svgFile.getName());
            mapModelContent.setMapThumbnailFileName(thumbnailFile.getName());
            mapModelContent.setMapId(mapId);
            mapModelContent.setCreateDate(new Date());
            this.getMapDesignerDao().saveMapContent(mapModelContent);
            successImportFiles.add(svgFile);
            successImportFiles.add(configFile);
            successImportFiles.add(thumbnailFile);
            successImportFiles.add(modelFile);
        }
    }

    public IQingFile importMapFile(String fileName) throws MapException {
        IQingFileVisitor fileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)fileName);
        if (fileVisitor.exists()) {
            IQingFile file = FileFactory.newPersistentFile((QingContext)this.qingContext, null, (QingPersistentFileType)QingPersistentFileType.MAP);
            try {
                QingInputStream sis = fileVisitor.getInputStream();
                file.write((IWriteCall)new CopyWriteCall((InputStream)sis, false), true);
                return file;
            }
            catch (IOException e) {
                throw new MapException(e);
            }
        }
        return null;
    }

    private void addNameSuffix(MapVO mapVO) throws AbstractQingIntegratedException, SQLException {
        String mapName = mapVO.getMapName();
        String mapGroupId = mapVO.getMapGroupId();
        String mapType = mapVO.getMapType().toPersistance();
        String mapId = mapVO.getMapId();
        NameSpace nameSpace = this.qingContext.getUserId().equals(IntegratedHelper.getPresetUserId()) ? NameSpace.system : NameSpace.user;
        boolean imageNameDuplicate = this.getMapManageDao().checkMapNameExist(mapName, mapGroupId, mapType, mapId, nameSpace.getCode());
        while (imageNameDuplicate) {
            mapName = ImExportUtil.rename(mapName);
            imageNameDuplicate = this.getMapManageDao().checkMapNameExist(mapName, mapGroupId, mapType, mapId, nameSpace.getCode());
        }
        mapVO.setMapName(mapName);
    }
}

