/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.qhf.domain;

import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.imagelibrary.exception.ImageTypeException;
import com.kingdee.bos.qing.imagelibrary.model.ImageType;
import com.kingdee.bos.qing.imagelibrary.util.ImageTypeUtil;
import com.kingdee.bos.qing.imexport.importer.exception.ImportCacheNotFoundException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportNoInfoFoundException;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.dashboard.DsbRefObject;
import com.kingdee.bos.qing.imexport.model.resource.Picture;
import com.kingdee.bos.qing.util.CloseUtil;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class AbstractImportDsbQHFDomain {
    protected List<ReferenceMap> getReferenceMaps(List<DsbRefObject> dsbRefObjs) {
        ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>(10);
        if (dsbRefObjs != null && !dsbRefObjs.isEmpty()) {
            for (DsbRefObject dsbRefObj : dsbRefObjs) {
                refItems.add(dsbRefObj.getReferenceMap());
            }
        }
        return refItems;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> getImageSize(String tag, String pictureId) throws ImportException {
        String cacheKey = ImportedModel.getCacheKey(tag);
        ImportedModel importedModel = (ImportedModel)QingSessionUtil.getCache((String)cacheKey, ImportedModel.class);
        if (importedModel == null) {
            throw new ImportCacheNotFoundException();
        }
        List<Picture> pictures = importedModel.getPackageMeta().getResources().getPictures();
        if (pictures != null && !pictures.isEmpty()) {
            for (Picture picture : pictures) {
                HashMap<String, Object> hashMap;
                if (!picture.getId().equals(pictureId)) continue;
                String zipImageFileName = picture.getFileName();
                Map<String, String> tempFileMap = importedModel.getTempFileMap();
                String imageFileName = tempFileMap.get(zipImageFileName);
                IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)imageFileName);
                QingInputStream sis = null;
                try {
                    sis = file.getInputStream();
                    ImageType imageType = ImageTypeUtil.getPicType((InputStream)sis);
                    if (imageType == null) {
                        throw new ImageTypeException();
                    }
                    CloseUtil.close((Closeable[])new Closeable[]{sis});
                    sis = file.getInputStream();
                    BufferedImage bufImg = ImageIO.read((InputStream)sis);
                    HashMap<String, Object> imageSize = new HashMap<String, Object>();
                    imageSize.put("imageWidth", bufImg.getWidth());
                    imageSize.put("imageHeight", bufImg.getHeight());
                    imageSize.put("imageName", imageFileName);
                    hashMap = imageSize;
                }
                catch (IOException e) {
                    try {
                        throw new ImportException(e);
                        catch (ImageTypeException e2) {
                            throw new ImportException((Throwable)((Object)e2));
                        }
                    }
                    catch (Throwable throwable) {
                        CloseUtil.close((Closeable[])new Closeable[]{sis});
                        throw throwable;
                    }
                }
                CloseUtil.close((Closeable[])new Closeable[]{sis});
                return hashMap;
            }
        }
        throw new ImportNoInfoFoundException();
    }
}

