/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model;

import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.imexport.model.Environment;
import com.kingdee.bos.qing.imexport.model.Integration;
import com.kingdee.bos.qing.imexport.model.dashboard.DashboardObject;
import com.kingdee.bos.qing.imexport.model.embeddeddata.EmbeddedDataObject;
import com.kingdee.bos.qing.imexport.model.integration.IntegratedType;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.LongerSquarePublishObject;
import com.kingdee.bos.qing.imexport.model.publish.dashboard.DsbPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.embedded.EmbeddedPublishObject;
import com.kingdee.bos.qing.imexport.model.resource.Resources;
import com.kingdee.bos.qing.imexport.model.subject.SubjectObject;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class PackageMeta {
    public static final String QHF_PKG_VERSION = "20200808";
    private String type;
    private String version;
    private List<SubjectObject> subjectObjs = new ArrayList<SubjectObject>(10);
    private List<DashboardObject> dashboardObjs = new ArrayList<DashboardObject>(10);
    private List<EmbeddedDataObject> embeddedDataObjs = new ArrayList<EmbeddedDataObject>(10);
    private List<AbstractPublishObject> publishObjs = new ArrayList<AbstractPublishObject>(10);
    private Resources resources = new Resources();
    private Environment environment;
    private Integration integration = new Integration();

    public Element toXml() throws IntegratedRuntimeException {
        Element metaElement = new Element("Meta");
        metaElement.setAttribute("type", this.type);
        metaElement.setAttribute("version", this.getVersionByType());
        this.subjectObjsToElement(metaElement);
        this.dashboardObjsToElement(metaElement);
        this.embedDatasToElement(metaElement);
        this.publishObjsToElement(metaElement);
        this.resourcesToElement(metaElement);
        this.integrationToElement(metaElement);
        this.environmentToElement(metaElement);
        return metaElement;
    }

    public void fromXml(Element metaElement) throws ModelParseException, JDOMException, IOException {
        this.type = metaElement.getAttributeValue("type");
        this.version = metaElement.getAttributeValue("version");
        this.subjectObjsFromXml(metaElement);
        this.dashboardObjsFromXml(metaElement);
        this.embedDatasFromXml(metaElement);
        this.publishObjsFromXml(metaElement);
        this.resourcesFromXml(metaElement);
        this.environmentFromXml(metaElement);
        this.integrationFromElement(metaElement);
    }

    public void exportToZip(ZipOutputStream zos) throws IOException, IntegratedRuntimeException {
        this.exportMetaXml(zos);
        this.exportMetaFile(zos);
    }

    private void exportMetaXml(ZipOutputStream zos) throws IOException, IntegratedRuntimeException {
        zos.putNextEntry(new ZipEntry("package-meta.xml"));
        Element metaElement = this.toXml();
        XmlUtil.save((Element)metaElement, (OutputStream)zos);
        zos.flush();
    }

    private void exportMetaFile(ZipOutputStream zos) throws IOException {
        this.exportSubjectObjsFile(zos);
        this.exportDashboardObjsFile(zos);
        this.exportEmbeddedDatasObjsFile(zos);
        this.exportPublishObjsFile(zos);
        this.exportResourcesFile(zos);
        this.exportIntegrationsFile(zos);
    }

    private String getVersionByType() {
        return QHF_PKG_VERSION;
    }

    private void subjectObjsFromXml(Element metaElement) throws ModelParseException, JDOMException, IOException {
        Element subjectObjsElement = metaElement.getChild("Subjects");
        if (subjectObjsElement != null) {
            List subjectObjElements = subjectObjsElement.getChildren("Subject");
            for (Element subjectObjElement : subjectObjElements) {
                SubjectObject subjectObj = new SubjectObject();
                subjectObj.fromXml(subjectObjElement, this.type, this.version);
                this.subjectObjs.add(subjectObj);
            }
        }
    }

    private void dashboardObjsFromXml(Element metaElement) throws ModelParseException, JDOMException, IOException {
        Element dashboardsElement = metaElement.getChild("Dashboards");
        if (dashboardsElement != null) {
            List dashboardObjElements = dashboardsElement.getChildren("Dashboard");
            for (Element dashboardObjElement : dashboardObjElements) {
                DashboardObject dashboardObj = new DashboardObject();
                dashboardObj.fromXml(dashboardObjElement, this.type, this.version);
                this.dashboardObjs.add(dashboardObj);
            }
        }
    }

    private void embedDatasFromXml(Element metaElement) throws ModelParseException, JDOMException, IOException {
        List embeddedDataObjElements;
        Element embeddedDatasElement = metaElement.getChild("EmbeddedDatas");
        if (embeddedDatasElement != null && (embeddedDataObjElements = embeddedDatasElement.getChildren("EmbeddedData")) != null) {
            for (Element embeddedDataObjElement : embeddedDataObjElements) {
                EmbeddedDataObject embeddedDataObj = new EmbeddedDataObject();
                embeddedDataObj.fromXml(embeddedDataObjElement, this.type, this.version);
                this.embeddedDataObjs.add(embeddedDataObj);
            }
        }
    }

    private void publishObjsFromXml(Element metaElement) throws ModelParseException, JDOMException, IOException {
        Element publishInfosElement = metaElement.getChild("PublishInfos");
        if (publishInfosElement != null) {
            List publishObjElements = publishInfosElement.getChildren("Publish");
            for (Element publishObjElement : publishObjElements) {
                String sourceType = publishObjElement.getAttributeValue("sourceType");
                PublishSourceEnum sourceTypeEum = PublishSourceEnum.valueOf((String)sourceType);
                AbstractPublishObject publishObj = null;
                if (PublishSourceEnum.subject == sourceTypeEum || PublishSourceEnum.report == sourceTypeEum) {
                    publishObj = new LongerSquarePublishObject();
                } else if (PublishSourceEnum.dashboard == sourceTypeEum) {
                    publishObj = new DsbPublishObject();
                } else if (PublishSourceEnum.bill == sourceTypeEum || PublishSourceEnum.control == sourceTypeEum) {
                    publishObj = new EmbeddedPublishObject();
                }
                if (publishObj == null) continue;
                ((AbstractPublishObject)publishObj).fromXml(publishObjElement, this.type, this.version);
                this.publishObjs.add(publishObj);
            }
        }
    }

    private void resourcesFromXml(Element metaElement) throws ModelParseException, JDOMException, IOException {
        this.resources.fromXml(metaElement, this.type, this.version);
    }

    private void environmentFromXml(Element metaElement) throws ModelParseException, JDOMException, IOException {
        Element environmentElement = metaElement.getChild("Environment");
        if (environmentElement != null) {
            this.environment = new Environment.Builder().createBlank();
            this.environment.fromXml(environmentElement, this.type, this.version);
        }
    }

    private void integrationFromElement(Element metaElement) {
        this.integration.fromXml(metaElement, this.type, this.version);
    }

    private void subjectObjsToElement(Element metaElement) {
        if (this.subjectObjs != null && !this.subjectObjs.isEmpty()) {
            Element subjectsElement = new Element("Subjects");
            for (SubjectObject subjectObj : this.subjectObjs) {
                subjectsElement.addContent((Content)subjectObj.toXml());
            }
            metaElement.addContent((Content)subjectsElement);
        }
    }

    private void dashboardObjsToElement(Element metaElement) {
        if (this.dashboardObjs != null && !this.dashboardObjs.isEmpty()) {
            Element dashboardsElement = new Element("Dashboards");
            for (DashboardObject dashboard : this.dashboardObjs) {
                dashboardsElement.addContent((Content)dashboard.toXml());
            }
            metaElement.addContent((Content)dashboardsElement);
        }
    }

    private void embedDatasToElement(Element metaElement) {
        if (this.embeddedDataObjs != null && !this.embeddedDataObjs.isEmpty()) {
            Element embeddedDataObjsElement = new Element("EmbeddedDatas");
            for (EmbeddedDataObject embeddedDataObj : this.embeddedDataObjs) {
                embeddedDataObjsElement.addContent((Content)embeddedDataObj.toXml());
            }
            metaElement.addContent((Content)embeddedDataObjsElement);
        }
    }

    private void publishObjsToElement(Element metaElement) throws IntegratedRuntimeException {
        if (this.publishObjs != null && !this.publishObjs.isEmpty()) {
            Element publishInfosElement = new Element("PublishInfos");
            for (AbstractPublishObject publishObj : this.publishObjs) {
                publishInfosElement.addContent((Content)publishObj.toXml());
            }
            metaElement.addContent((Content)publishInfosElement);
        }
    }

    private void resourcesToElement(Element metaElement) {
        if (this.resources.hasContent()) {
            metaElement.addContent((Content)this.resources.toXml());
        }
    }

    private void environmentToElement(Element metaElement) {
        if (this.environment != null) {
            metaElement.addContent((Content)this.environment.toXml());
        }
    }

    private void integrationToElement(Element metaElement) {
        if (this.integration.hasContent()) {
            metaElement.addContent((Content)this.integration.toXml());
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<SubjectObject> getSubjectObjs() {
        return this.subjectObjs;
    }

    public void setSubjectObjs(List<SubjectObject> subjectObjs) {
        this.subjectObjs = subjectObjs;
    }

    public List<AbstractPublishObject> getPublishObjs() {
        return this.publishObjs;
    }

    public void setPublishObjs(List<AbstractPublishObject> publishObjs) {
        this.publishObjs = publishObjs;
    }

    public List<DashboardObject> getDashboardObjs() {
        return this.dashboardObjs;
    }

    public void setDashboardObjs(List<DashboardObject> dashboardObjs) {
        this.dashboardObjs = dashboardObjs;
    }

    public List<EmbeddedDataObject> getEmbeddedDataObjs() {
        return this.embeddedDataObjs;
    }

    public void setEmbeddedDataObjs(List<EmbeddedDataObject> embeddedDataObjs) {
        this.embeddedDataObjs = embeddedDataObjs;
    }

    public Resources getResources() {
        return this.resources;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void addIntegration(IntegratedType type, Integration.AbstractIntegratedSubNode subNode) {
        this.integration.addSubNode(type, subNode);
    }

    public Integration.AbstractIntegratedSubNode getIntegration(IntegratedType type) {
        return this.integration.getSubNodes(type);
    }

    private void exportSubjectObjsFile(ZipOutputStream zos) throws IOException {
        for (SubjectObject subjectObj : this.subjectObjs) {
            subjectObj.exportFile(zos);
        }
    }

    private void exportDashboardObjsFile(ZipOutputStream zos) throws IOException {
        for (DashboardObject dashboardObj : this.dashboardObjs) {
            dashboardObj.exportFile(zos);
        }
    }

    private void exportEmbeddedDatasObjsFile(ZipOutputStream zos) throws IOException {
        HashSet<String> hasObjExportedSchemas = new HashSet<String>();
        HashSet<String> qsFileNames = new HashSet<String>(16);
        for (EmbeddedDataObject embeddedDataObj : this.embeddedDataObjs) {
            String bizTag = embeddedDataObj.getEmbeddedDataInfo().getBizTag();
            boolean isContainBizTag = true;
            if (hasObjExportedSchemas.add(bizTag)) {
                isContainBizTag = false;
            }
            if (!qsFileNames.add(embeddedDataObj.getEmbeddedDataQsInfo().getQsFileName())) continue;
            embeddedDataObj.exportFile(zos, isContainBizTag);
        }
    }

    private void exportPublishObjsFile(ZipOutputStream zos) throws IOException {
        for (AbstractPublishObject publishObj : this.publishObjs) {
            publishObj.exportFile(zos);
        }
    }

    private void exportResourcesFile(ZipOutputStream zos) throws IOException {
        this.resources.exportFile(zos);
    }

    private void exportIntegrationsFile(ZipOutputStream zos) throws IOException {
        this.integration.exportFile(zos);
    }

    public void endCleanFiles() {
        if (CollectionUtils.isNotEmpty(this.subjectObjs)) {
            for (SubjectObject subjectObject : this.subjectObjs) {
                subjectObject.endCleanFiles();
            }
        }
        if (CollectionUtils.isNotEmpty(this.dashboardObjs)) {
            for (DashboardObject dashboardObject : this.dashboardObjs) {
                dashboardObject.endCleanFiles();
            }
        }
        if (CollectionUtils.isNotEmpty(this.embeddedDataObjs)) {
            for (EmbeddedDataObject embeddedDataObject : this.embeddedDataObjs) {
                embeddedDataObject.endCleanFiles();
            }
        }
        if (CollectionUtils.isNotEmpty(this.publishObjs)) {
            for (AbstractPublishObject publishObject : this.publishObjs) {
                publishObject.endCleanFiles();
            }
        }
        if (this.resources != null) {
            this.resources.endCleanFiles();
        }
    }
}

