/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.embeddeddata;

import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.imexport.model.QsInfo;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IOUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;

public class EmbeddedDataQsInfo
extends QsInfo {
    private String qsFileName;

    public String getQsFileName() {
        return this.qsFileName;
    }

    public void setQsFileName(String qsFileName) {
        this.qsFileName = qsFileName;
    }

    @Override
    public Element toXml() {
        Element qsInfoElement = super.toXml();
        Element qsElement = new Element("Qs");
        qsElement.setAttribute("file", this.qsFileName + ".qs");
        qsInfoElement.addContent((Content)qsElement);
        return qsInfoElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportFile(ZipOutputStream zos) throws IOException {
        super.exportFile(zos);
        QingInputStream is = null;
        try {
            IQingFileVisitor qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.TEMP_QS, (String)this.qsFileName);
            if (!qingFileVisitor.exists()) {
                qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.EMBEDDED_PUB_QS, (String)this.qsFileName);
            }
            String boxFilePath = "qs" + File.separator + this.qsFileName + ".qs";
            zos.putNextEntry(new ZipEntry(boxFilePath));
            is = qingFileVisitor.getInputStream();
            IOUtil.copy((InputStream)is, (OutputStream)zos);
            zos.flush();
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{is});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{is});
    }

    public void fromXml(Element qsInfoElement, String type, String version) {
        super.fromXml(qsInfoElement);
        Element qsElement = qsInfoElement.getChild("Qs");
        this.qsFileName = qsElement.getAttributeValue("file");
    }

    @Override
    public void endCleanFiles() {
        super.endCleanFiles();
    }
}

