/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.publish.dashboard;

import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.imexport.model.QsInfo;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IOUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;

public class DashboardQsInfo
extends QsInfo {
    private List<Map<String, String>> subjectQsList = new ArrayList<Map<String, String>>(10);
    private List<Map<String, String>> billQsList = new ArrayList<Map<String, String>>(10);
    private static final String SUBJECT = "subject";
    private static final String BILL = "bill";

    public List<Map<String, String>> getSubjectQsList() {
        return this.subjectQsList;
    }

    public void setSubjectQsList(List<Map<String, String>> subjectQsList) {
        this.subjectQsList = subjectQsList;
    }

    public List<Map<String, String>> getBillQsList() {
        return this.billQsList;
    }

    public void setBillQsList(List<Map<String, String>> billQsList) {
        this.billQsList = billQsList;
    }

    @Override
    public Element toXml() {
        Element qsElement;
        Element qsInfoElement = super.toXml();
        for (Map<String, String> qs : this.subjectQsList) {
            qsElement = new Element("Qs");
            qsElement.setAttribute("entityName", qs.get("entityName"));
            qsElement.setAttribute("file", qs.get("file") + ".qs");
            qsElement.setAttribute("refUid", qs.get("refUid"));
            qsElement.setAttribute("extractTimestamp", qs.get("extractTimestamp"));
            qsElement.setAttribute("sourceType", SUBJECT);
            qsInfoElement.addContent((Content)qsElement);
        }
        for (Map<String, String> qs : this.billQsList) {
            qsElement = new Element("Qs");
            qsElement.setAttribute("file", qs.get("file") + ".qs");
            qsElement.setAttribute("refUid", qs.get("refUid"));
            qsElement.setAttribute("extractTimestamp", qs.get("extractTimestamp"));
            qsElement.setAttribute("sourceType", BILL);
            qsInfoElement.addContent((Content)qsElement);
        }
        return qsInfoElement;
    }

    public void fromXml(Element qsInfoElement, String type, String version) {
        super.fromXml(qsInfoElement);
        List elementList = qsInfoElement.getChildren("Qs");
        for (Element element : elementList) {
            String sourceType = element.getAttributeValue("sourceType");
            HashMap<String, String> qs = new HashMap<String, String>(4);
            qs.put("sourceType", sourceType);
            qs.put("file", element.getAttributeValue("file"));
            qs.put("refUid", element.getAttributeValue("refUid"));
            qs.put("extractTimestamp", element.getAttributeValue("extractTimestamp"));
            if (SUBJECT.equals(sourceType)) {
                qs.put("entityName", element.getAttributeValue("entityName"));
                this.subjectQsList.add(qs);
                continue;
            }
            this.billQsList.add(qs);
        }
    }

    @Override
    public void exportFile(ZipOutputStream zos) throws IOException {
        super.exportFile(zos);
        this.exportQsFile(zos, this.subjectQsList, QingPersistentFileType.DATAMODELING_QS);
        this.exportQsFile(zos, this.billQsList, QingPersistentFileType.EMBEDDED_PUB_QS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportQsFile(ZipOutputStream zos, List<Map<String, String>> qsList, QingPersistentFileType fileType) throws IOException {
        HashSet<String> fileNameSet = new HashSet<String>(10);
        for (Map<String, String> qs : qsList) {
            fileNameSet.add(qs.get("file"));
        }
        for (String fileName : fileNameSet) {
            QingInputStream is = null;
            try {
                IQingFileVisitor qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.TEMP_QS, (String)fileName);
                if (!qingFileVisitor.exists()) {
                    qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)fileType, (String)fileName);
                }
                String boxFilePath = "qs" + File.separator + fileName + ".qs";
                zos.putNextEntry(new ZipEntry(boxFilePath));
                is = qingFileVisitor.getInputStream();
                IOUtil.copy((InputStream)is, (OutputStream)zos);
                zos.flush();
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{is});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{is});
        }
    }
}

