/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.publish.target;

import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.publish.model.PublishTarget;
import com.kingdee.bos.qing.publish.thumbnail.model.ThumbnailInfo;
import com.kingdee.bos.qing.schedule.model.Schedule;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;

public class PublishToLapp
extends PublishTarget {
    private String desc;
    private String layout_type;
    private String landscape;
    private String bottomAnnotation;
    private String displayStyle;
    private String tempThumbnailFile;
    private String themeType;
    private String themeName;
    private String appType;
    private ThumbnailInfo thumbnailInfo;

    public ThumbnailInfo getThumbnailInfo() {
        return this.thumbnailInfo;
    }

    public void setThumbnailInfo(ThumbnailInfo thumbnailInfo) {
        this.thumbnailInfo = thumbnailInfo;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getLayout_type() {
        return this.layout_type;
    }

    public void setLayout_type(String layout_type) {
        this.layout_type = layout_type;
    }

    public String getLandscape() {
        return this.landscape;
    }

    public void setLandscape(String landscape) {
        this.landscape = landscape;
    }

    public String getBottomAnnotation() {
        return this.bottomAnnotation;
    }

    public void setBottomAnnotation(String bottomAnnotation) {
        this.bottomAnnotation = bottomAnnotation;
    }

    public String getDisplayStyle() {
        return this.displayStyle;
    }

    public void setDisplayStyle(String displayStyle) {
        this.displayStyle = displayStyle;
    }

    public String getTempThumbnailFile() {
        return this.tempThumbnailFile + ".png";
    }

    public void setTempThumbnailFile(String tempThumbnailFile) {
        this.tempThumbnailFile = tempThumbnailFile;
    }

    public String getThemeName() {
        return this.themeName;
    }

    public void setThemeName(String themeName) {
        this.themeName = themeName;
    }

    public String getAppType() {
        return this.appType;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public String getThemeType() {
        return this.themeType;
    }

    public void setThemeType(String themeType) {
        this.themeType = themeType;
    }

    public Element toXml() {
        Element xml = super.toXml();
        if (StringUtils.isNotBlank((CharSequence)this.desc)) {
            Element descElm = new Element("Desc");
            XmlUtil.addCDATA((Element)descElm, (String)this.desc);
            xml.addContent((Content)descElm);
        }
        Element layoutTypeElm = new Element("layout");
        layoutTypeElm.setAttribute("layout_type", this.layout_type);
        xml.addContent((Content)layoutTypeElm);
        Element landscapeElm = new Element("Landscape");
        landscapeElm.setAttribute("landscape", this.landscape);
        xml.addContent((Content)landscapeElm);
        if (StringUtils.isNotBlank((CharSequence)this.bottomAnnotation)) {
            Element bottomAnnotationElm = new Element("BottomAnnotation");
            XmlUtil.addCDATA((Element)bottomAnnotationElm, (String)this.bottomAnnotation);
            xml.addContent((Content)bottomAnnotationElm);
        }
        Element displayStyleElm = new Element("DisplayStyle");
        displayStyleElm.setAttribute("displayStyle", this.displayStyle);
        xml.addContent((Content)displayStyleElm);
        Element appTypeElm = new Element("AppType");
        appTypeElm.setAttribute("appType", this.appType);
        xml.addContent((Content)appTypeElm);
        Element thumbnailElm = new Element("Thumbnail");
        if (this.tempThumbnailFile != null) {
            thumbnailElm.setAttribute("file", this.tempThumbnailFile);
        }
        if (this.thumbnailInfo != null) {
            Schedule schedule;
            String schemaId;
            String scrollLeft;
            String scrollTop;
            String apertureHeight;
            String apertureWidth;
            String apertureLeft;
            String apertureTop;
            String publishId;
            String analysisId = this.thumbnailInfo.getAnalysisId();
            if (StringUtils.isNotBlank((CharSequence)analysisId)) {
                thumbnailElm.setAttribute("analysisId", analysisId);
            }
            if (StringUtils.isNotBlank((CharSequence)(publishId = this.thumbnailInfo.getPublishId()))) {
                thumbnailElm.setAttribute("publishId", publishId);
            }
            if (StringUtils.isNotBlank((CharSequence)(apertureTop = String.valueOf(this.thumbnailInfo.getApertureTop())))) {
                thumbnailElm.setAttribute("apertureTop", String.valueOf(apertureTop));
            }
            if (StringUtils.isNotBlank((CharSequence)(apertureLeft = String.valueOf(this.thumbnailInfo.getApertureLeft())))) {
                thumbnailElm.setAttribute("apertureLeft", apertureLeft);
            }
            if (StringUtils.isNotBlank((CharSequence)(apertureWidth = String.valueOf(this.thumbnailInfo.getApertureWidth())))) {
                thumbnailElm.setAttribute("apertureWidth", apertureWidth);
            }
            if (StringUtils.isNotBlank((CharSequence)(apertureHeight = String.valueOf(this.thumbnailInfo.getApertureHeight())))) {
                thumbnailElm.setAttribute("apertureHeight", apertureHeight);
            }
            if (StringUtils.isNotBlank((CharSequence)(scrollTop = String.valueOf(this.thumbnailInfo.getScrollTop())))) {
                thumbnailElm.setAttribute("scrollTop", scrollTop);
            }
            if (StringUtils.isNotBlank((CharSequence)(scrollLeft = String.valueOf(this.thumbnailInfo.getScrollLeft())))) {
                thumbnailElm.setAttribute("scrollLeft", scrollLeft);
            }
            if (StringUtils.isNotBlank((CharSequence)(schemaId = this.thumbnailInfo.getSchemaId()))) {
                thumbnailElm.setAttribute("schemaId", schemaId);
            }
            if ((schedule = this.thumbnailInfo.getSchedule()) != null) {
                thumbnailElm.setAttribute("schedule", JsonUtil.encodeToString((Object)schedule));
            }
        }
        xml.addContent((Content)thumbnailElm);
        return xml;
    }

    public void lappFrmoXml(Element xml) {
        Element thumbnailElm;
        Element appTypeElm;
        Element displayStyleElm;
        Element bottomAnnotationElm;
        super.fromXml(xml);
        Element targetElm = xml.getChild("Target");
        Element descElm = targetElm.getChild("Desc");
        if (descElm != null) {
            this.desc = descElm.getText();
        }
        Element layoutElm = targetElm.getChild("layout");
        this.layout_type = layoutElm.getAttributeValue("layout_type");
        Element landscapeElm = targetElm.getChild("Landscape");
        if (landscapeElm != null) {
            this.landscape = landscapeElm.getAttributeValue("landscape");
        }
        if ((bottomAnnotationElm = targetElm.getChild("BottomAnnotation")) != null) {
            this.bottomAnnotation = bottomAnnotationElm.getText();
        }
        if ((displayStyleElm = targetElm.getChild("DisplayStyle")) != null) {
            this.displayStyle = displayStyleElm.getAttributeValue("displayStyle");
        }
        if ((appTypeElm = targetElm.getChild("AppType")) != null) {
            this.appType = appTypeElm.getAttributeValue("appType");
        }
        if ((thumbnailElm = targetElm.getChild("Thumbnail")) != null) {
            this.tempThumbnailFile = thumbnailElm.getAttributeValue("file");
            this.thumbnailInfo = new ThumbnailInfo();
            if (thumbnailElm.getAttributeValue("analysisId") != null) {
                this.thumbnailInfo.setAnalysisId(thumbnailElm.getAttributeValue("analysisId"));
            }
            if (thumbnailElm.getAttributeValue("publishId") != null) {
                this.thumbnailInfo.setPublishId(thumbnailElm.getAttributeValue("publishId"));
            }
            if (thumbnailElm.getAttributeValue("apertureTop") != null) {
                this.thumbnailInfo.setApertureTop(Integer.parseInt(thumbnailElm.getAttributeValue("apertureTop")));
            }
            if (thumbnailElm.getAttributeValue("apertureHeight") != null) {
                this.thumbnailInfo.setApertureHeight(Integer.parseInt(thumbnailElm.getAttributeValue("apertureHeight")));
            }
            if (thumbnailElm.getAttributeValue("apertureWidth") != null) {
                this.thumbnailInfo.setApertureWidth(Integer.parseInt(thumbnailElm.getAttributeValue("apertureWidth")));
            }
            if (thumbnailElm.getAttributeValue("apertureHeight") != null) {
                this.thumbnailInfo.setApertureHeight(Integer.parseInt(thumbnailElm.getAttributeValue("apertureHeight")));
            }
            if (thumbnailElm.getAttributeValue("scrollLeft") != null) {
                this.thumbnailInfo.setScrollLeft(Integer.parseInt(thumbnailElm.getAttributeValue("scrollLeft")));
            }
            if (thumbnailElm.getAttributeValue("scrollTop") != null) {
                this.thumbnailInfo.setScrollTop(Integer.parseInt(thumbnailElm.getAttributeValue("scrollTop")));
            }
            if (thumbnailElm.getAttributeValue("schedule") != null) {
                this.thumbnailInfo.setSchedule((Schedule)JsonUtil.decodeFromString((String)thumbnailElm.getAttributeValue("schedule"), Schedule.class));
            }
            if (thumbnailElm.getAttributeValue("schemaId") != null) {
                this.thumbnailInfo.setSchemaId(thumbnailElm.getAttributeValue("schemaId"));
            }
        }
    }

    public String getSchemaFileName() {
        return this.thumbnailInfo.getSchemaId() + ".schema";
    }

    public void exportLappThumbnailFile(ZipOutputStream zos) throws IOException {
        ModelBook modelBook;
        if (this.thumbnailInfo != null && (modelBook = this.thumbnailInfo.getModelBook()) != null) {
            String schemaContentFilePath = "schema" + File.separator + this.thumbnailInfo.getSchemaId() + ".schema";
            zos.putNextEntry(new ZipEntry(schemaContentFilePath));
            Element element = modelBook.toXml();
            XmlUtil.save((Element)element, (OutputStream)zos);
        }
    }
}

