/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.resource;

import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;

public class Picture {
    private String categoryName;
    private String imageName;
    private String id;
    private String nameSpace;

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public Element toXml() {
        Element xml = new Element("Picture");
        xml.setAttribute("categoryName", this.categoryName);
        xml.setAttribute("imageName", this.imageName);
        xml.setAttribute("id", this.id);
        xml.setAttribute("nameSpace", this.nameSpace);
        return xml;
    }

    public void fromXml(Element xml, String type, String version) {
        this.categoryName = xml.getAttributeValue("categoryName");
        this.imageName = xml.getAttributeValue("imageName");
        this.nameSpace = xml.getAttributeValue("nameSpace");
        this.id = xml.getAttributeValue("id");
    }

    private String getZipEntryPath() {
        String pathPrefix = "resource" + File.separator + "picture";
        return pathPrefix + File.separator + this.getFileName();
    }

    public void exportFile(ZipOutputStream zos) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)this.id)) {
            IOUtil.writeZipEntry((ZipOutputStream)zos, (AbstractQingFileType)QingPersistentFileType.IMAGE_LIBRARY, (String)this.id, (String)this.getZipEntryPath());
        }
    }

    public String getFileName() {
        return this.id + this.imageName.substring(this.imageName.lastIndexOf(46));
    }
}

