/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.subject;

import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.subject.SubjectQsInfo;
import com.kingdee.bos.qing.util.CollectionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;

public class AnalysisObject {
    private List<SchemaObject> schemaObjs;
    private SubjectQsInfo subjectQsInfo;

    public List<SchemaObject> getSchemaObjs() {
        return this.schemaObjs;
    }

    public void setSchemaObjs(List<SchemaObject> schemaObjs) {
        this.schemaObjs = schemaObjs;
    }

    public SubjectQsInfo getSubjectQsInfo() {
        return this.subjectQsInfo;
    }

    public void setSubjectQsInfo(SubjectQsInfo subjectQsInfo) {
        this.subjectQsInfo = subjectQsInfo;
    }

    public Element toXml() {
        Element analysisElement = new Element("Analysis");
        if (this.schemaObjs != null && !this.schemaObjs.isEmpty()) {
            Element schemasElement = new Element("Schemas");
            for (SchemaObject schemaObj : this.schemaObjs) {
                schemasElement.addContent((Content)schemaObj.toXml());
            }
            analysisElement.addContent((Content)schemasElement);
        }
        if (this.subjectQsInfo != null) {
            analysisElement.addContent((Content)this.subjectQsInfo.toXml());
        }
        return analysisElement;
    }

    public void exportFile(ZipOutputStream zos) throws IOException {
        if (this.schemaObjs != null) {
            for (SchemaObject schemaObj : this.schemaObjs) {
                schemaObj.exportFile(zos);
            }
        }
        if (this.subjectQsInfo != null) {
            this.subjectQsInfo.exportFile(zos);
        }
    }

    public void fromXml(Element analysisObjElement, String type, String version) {
        Element subjectQsInfoElement;
        Element schemaObjsElement = analysisObjElement.getChild("Schemas");
        if (schemaObjsElement != null) {
            this.schemaObjs = new ArrayList<SchemaObject>(10);
            List schemaElements = schemaObjsElement.getChildren("Schema");
            for (Element schemaObjElement : schemaElements) {
                SchemaObject schemaObj = new SchemaObject();
                schemaObj.fromXml(schemaObjElement, type, version);
                this.schemaObjs.add(schemaObj);
            }
        }
        if ((subjectQsInfoElement = analysisObjElement.getChild("QsInfo")) != null) {
            this.subjectQsInfo = new SubjectQsInfo();
            this.subjectQsInfo.fromXml(subjectQsInfoElement, type, version);
        }
    }

    public void endCleanFiles() {
        if (CollectionUtils.isNotEmpty(this.schemaObjs)) {
            for (SchemaObject schemaObject : this.schemaObjs) {
                schemaObject.endCleanFiles();
            }
        }
    }
}

