/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.subject;

import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.imexport.model.subject.DBInfo;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class DataModelingObject {
    private String boxFileName;
    private Set<String> dsFileNames;
    private List<DBInfo> dbInfos;

    public String getBoxFileName() {
        return this.boxFileName;
    }

    public void setBoxFileName(String boxFileName) {
        this.boxFileName = boxFileName;
    }

    public Set<String> getDsFileNames() {
        return this.dsFileNames;
    }

    public void setDsFileNames(Set<String> dsFileNames) {
        this.dsFileNames = dsFileNames;
    }

    public List<DBInfo> getDbInfos() {
        return this.dbInfos;
    }

    public void setDbInfos(List<DBInfo> dbInfos) {
        this.dbInfos = dbInfos;
    }

    public Element toXml(String themeId) {
        Element dataModelingElement = new Element("DataModeling");
        Element modelElement = new Element("Model");
        modelElement.setAttribute("file", this.getDmFileName(themeId));
        dataModelingElement.addContent((Content)modelElement);
        if (this.dsFileNames != null) {
            Element dsFilesElement = new Element("DsFiles");
            for (String fileName : this.dsFileNames) {
                Element dsElement = new Element("Ds");
                dsElement.setAttribute("file", fileName);
                dsFilesElement.addContent((Content)dsElement);
            }
            dataModelingElement.addContent((Content)dsFilesElement);
        }
        if (this.dbInfos != null && !this.dbInfos.isEmpty()) {
            Element dbInfosElement = new Element("DbInfos");
            for (DBInfo dbInfo : this.dbInfos) {
                Element dbInfoElement = new Element("DbInfo");
                dbInfoElement.setAttribute("sourceId", dbInfo.getSourceId());
                dbInfoElement.setAttribute("dbType", dbInfo.getDbType());
                dbInfoElement.setAttribute("dbVersion", dbInfo.getDbVersion());
                dbInfosElement.addContent((Content)dbInfoElement);
            }
            dataModelingElement.addContent((Content)dbInfosElement);
        }
        return dataModelingElement;
    }

    public void exportFile(String themeId, ZipOutputStream zos) throws IOException {
        this.exportBoxFile(themeId, zos);
        this.exportDSFile(zos);
    }

    private String getDmFileName(String themeId) {
        return themeId + ".dm";
    }

    private void exportBoxFile(String themeId, ZipOutputStream zos) throws IOException {
        String boxFilePath = "model" + File.separator + this.getDmFileName(themeId);
        ImExportUtil.exportFile(zos, this.boxFileName, boxFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportDSFile(ZipOutputStream zos) throws IOException {
        if (this.dsFileNames != null) {
            for (String fileName : this.dsFileNames) {
                QingInputStream is;
                block6: {
                    is = null;
                    try {
                        String dsFileName = fileName.substring(0, fileName.lastIndexOf("."));
                        IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_DS, (String)dsFileName);
                        if (!file.exists()) break block6;
                        try {
                            zos.putNextEntry(new ZipEntry("ds" + File.separator + fileName));
                            is = file.getInputStream();
                            IOUtil.copy((InputStream)is, (OutputStream)zos);
                            zos.flush();
                        }
                        catch (ZipException e) {
                            LogUtil.error((String)"\u591a\u4e2a\u4e3b\u9898\u7684\u5efa\u6a21\u5f15\u5165\u540c\u4e00\u4efd\u4e0a\u4f20\u578b\u7684\u6587\u4ef6", (Throwable)e);
                        }
                    }
                    catch (Throwable throwable) {
                        CloseUtil.close((Closeable[])new Closeable[]{is});
                        throw throwable;
                    }
                }
                CloseUtil.close((Closeable[])new Closeable[]{is});
            }
        }
    }

    public void fromXml(Element dataModelingElement, String type, String version) throws JDOMException, IOException, ModelParseException {
        List dbInfoElements;
        Element dbInfosElement;
        List dsElements;
        Element modelElement = dataModelingElement.getChild("Model");
        this.boxFileName = modelElement.getAttributeValue("file");
        Element dsFilesElement = dataModelingElement.getChild("DsFiles");
        if (dsFilesElement != null && (dsElements = dsFilesElement.getChildren("Ds")) != null) {
            this.dsFileNames = new HashSet<String>(16);
            for (Element dsElement : dsElements) {
                this.dsFileNames.add(dsElement.getAttributeValue("file"));
            }
        }
        if ((dbInfosElement = dataModelingElement.getChild("DbInfos")) != null && (dbInfoElements = dbInfosElement.getChildren("DbInfo")) != null) {
            this.dbInfos = new ArrayList<DBInfo>(dbInfoElements.size());
            for (Element dbInfoElement : dbInfoElements) {
                DBInfo dbInfo = new DBInfo();
                dbInfo.setSourceId(dbInfoElement.getAttributeValue("sourceId"));
                dbInfo.setDbVersion(dbInfoElement.getAttributeValue("dbVersion"));
                dbInfo.setDbType(dbInfoElement.getAttributeValue("dbType"));
                this.dbInfos.add(dbInfo);
            }
        }
    }

    public void endCleanFiles() {
        ImExportUtil.deleteExportFile(this.boxFileName);
    }
}

