/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.subject;

import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.imexport.model.subject.AnalysisObject;
import com.kingdee.bos.qing.imexport.model.subject.DataModelingObject;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class SubjectObject {
    private ThemeGroupVO themeGroupVO;
    private ThemeVO themeVO;
    private DataModelingObject dataModelingObj;
    private AnalysisObject analysisObj;

    public ThemeGroupVO getThemeGroupVO() {
        return this.themeGroupVO;
    }

    public void setThemeGroupVO(ThemeGroupVO themeGroupVO) {
        this.themeGroupVO = themeGroupVO;
    }

    public ThemeVO getThemeVO() {
        return this.themeVO;
    }

    public void setThemeVO(ThemeVO themeVO) {
        this.themeVO = themeVO;
    }

    public DataModelingObject getDataModelingObj() {
        return this.dataModelingObj;
    }

    public void setDataModelingObj(DataModelingObject dataModelingObj) {
        this.dataModelingObj = dataModelingObj;
    }

    public AnalysisObject getAnalysisObj() {
        return this.analysisObj;
    }

    public void setAnalysisObj(AnalysisObject analysisObj) {
        this.analysisObj = analysisObj;
    }

    public Element toXml() {
        String themeId = this.themeVO.getThemeID();
        Element subjectElement = new Element("Subject");
        subjectElement.setAttribute("id", themeId);
        subjectElement.setAttribute("name", this.themeVO.getThemeName());
        String nameSpace = this.themeVO.isPreset() ? NameSpace.system.toPersistance() : NameSpace.user.toPersistance();
        subjectElement.setAttribute("nameSpace", nameSpace);
        subjectElement.setAttribute("category", this.themeGroupVO.getThemeGroupName());
        if (StringUtils.isNotBlank((CharSequence)this.themeVO.getDescription())) {
            Element descElement = new Element("Desc");
            XmlUtil.addCDATA((Element)descElement, (String)this.themeVO.getDescription());
            subjectElement.addContent((Content)descElement);
        }
        if (this.dataModelingObj != null) {
            subjectElement.addContent((Content)this.dataModelingObj.toXml(themeId));
        }
        if (this.analysisObj != null) {
            subjectElement.addContent((Content)this.analysisObj.toXml());
        }
        return subjectElement;
    }

    public void exportFile(ZipOutputStream zos) throws IOException {
        if (this.dataModelingObj != null) {
            String themeId = this.themeVO.getThemeID();
            this.dataModelingObj.exportFile(themeId, zos);
        }
        if (this.analysisObj != null) {
            this.analysisObj.exportFile(zos);
        }
    }

    public void fromXml(Element subjectObjElement, String type, String version) throws ModelParseException, JDOMException, IOException {
        Element analysisElement;
        Element dataModelingElement;
        this.themeGroupVO = new ThemeGroupVO();
        this.themeGroupVO.setThemeGroupName(subjectObjElement.getAttributeValue("category"));
        this.themeVO = new ThemeVO();
        this.themeVO.setThemeID(subjectObjElement.getAttributeValue("id"));
        this.themeVO.setThemeName(subjectObjElement.getAttributeValue("name"));
        this.themeVO.setPreset(NameSpace.system.name().equals(subjectObjElement.getAttributeValue("nameSpace")));
        Element descElement = subjectObjElement.getChild("Desc");
        if (descElement != null) {
            this.themeVO.setDescription(descElement.getTextTrim());
        }
        if ((dataModelingElement = subjectObjElement.getChild("DataModeling")) != null) {
            this.dataModelingObj = new DataModelingObject();
            this.dataModelingObj.fromXml(dataModelingElement, type, version);
        }
        if ((analysisElement = subjectObjElement.getChild("Analysis")) != null) {
            this.analysisObj = new AnalysisObject();
            this.analysisObj.fromXml(analysisElement, type, version);
        }
    }

    public void endCleanFiles() {
        if (this.dataModelingObj != null) {
            this.dataModelingObj.endCleanFiles();
        }
        if (this.analysisObj != null) {
            this.analysisObj.endCleanFiles();
        }
    }
}

