/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.service;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.cache.ThemeDataSource;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.data.domain.unionsource.EntityExtractContext;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.DmDynamicData;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.ModelDecoder;
import com.kingdee.bos.qing.data.model.vo.Entites;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.data.model.vo.Sources;
import com.kingdee.bos.qing.data.service.IEntityDataService;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourceNoDataException;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.spec.IDataIterator;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.imexport.importer.exception.ImportCacheNotFoundException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportNoInfoFoundException;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.dm.QHFDMException;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.dm.QHFDmUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class QHFDMEntityService
implements IEntityDataService {
    private static final String OLD = "_old_box";
    private String tag;

    public QHFDMEntityService(String tag) {
        this.tag = tag;
    }

    public String extractEntityData(EntityExtractContext context) throws AbstractSourceException, DataSourcePersistenceException, AbstractQingIntegratedException, InterruptedException {
        return null;
    }

    public PreviewDataModel getPreviewData(QingContext qingContext, int previewRows, Entites entities, Sources sources, Map<Entity, IQingFileVisitor> qingFileVisitorMap) throws AbstractSourceException, AbstractQingIntegratedException {
        try (IDataIterator dataIterator = null;){
            AbstractEntity entity = (AbstractEntity)entities.getEntities().get(0);
            ArrayList<Object[]> result = new ArrayList<Object[]>(10);
            IQingFileVisitor qsFile = QHFDmUtil.getEntityQsFile(this.tag, entity.getName());
            QSDataSourceVisitor qsDataSourceVisitor = new QSDataSourceVisitor(qsFile);
            MetaInfo metaInfo = qsDataSourceVisitor.getMetaInfo();
            HashSet<DSFieldKey> fields = new HashSet<DSFieldKey>(16);
            List fieldNames = metaInfo.getFieldNames();
            for (int i = 0; i < fieldNames.size(); ++i) {
                fields.add(new DSFieldKey((String)fieldNames.get(i)));
            }
            try {
                dataIterator = qsDataSourceVisitor.iterator();
            }
            catch (DataSourceNoDataException ex) {
                PreviewDataModel previewDataModel = new PreviewDataModel(result);
                if (dataIterator != null) {
                    dataIterator.close();
                }
                return previewDataModel;
            }
            int columnSize = fieldNames.size();
            dataIterator.init(fields, null, null);
            while (dataIterator.hasNextRow() && previewRows > result.size()) {
                Map row = dataIterator.nextRow();
                Object[] oneRowData = new Object[columnSize];
                for (int columnIndxe = 0; columnIndxe < columnSize; ++columnIndxe) {
                    Object value = row.get(fieldNames.get(columnIndxe));
                    if (null == value) {
                        oneRowData[columnIndxe] = value;
                        continue;
                    }
                    if (value instanceof Calendar) {
                        value = ((Calendar)value).getTimeInMillis();
                    } else if (value instanceof Date) {
                        value = ((Date)value).getTime();
                    } else if (value instanceof Long) {
                        value = value.toString();
                    }
                    oneRowData[columnIndxe] = value;
                }
                result.add(oneRowData);
            }
            PreviewDataModel previewDataModel = new PreviewDataModel(result);
            return previewDataModel;
        }
    }

    public long getDataCount(QingContext qingContext, Entites entities, Sources sources, Map<Entity, IQingFileVisitor> qingFileVisitorMap) throws AbstractSourceException, AbstractQingIntegratedException {
        try {
            AbstractEntity entity = (AbstractEntity)entities.getEntities().get(0);
            IQingFileVisitor qsFile = QHFDmUtil.getEntityQsFile(this.tag, entity.getName());
            QSDataSourceVisitor qsDataSourceVisitor = new QSDataSourceVisitor(qsFile);
            return qsDataSourceVisitor.getRowCount();
        }
        catch (AbstractDataSourceException e) {
            throw new QHFDMException();
        }
        catch (ImportNoInfoFoundException e) {
            throw new QHFDMException((Throwable)((Object)e));
        }
    }

    public Box saveModel(Box boxModel) throws ImportNoInfoFoundException {
        String cacheKey = ThemeDataSource.getCacheKey(this.tag);
        ThemeDataSource themeDataSource = (ThemeDataSource)QingSessionUtil.getCache((String)cacheKey, ThemeDataSource.class);
        if (themeDataSource != null) {
            String oldBoxModelJson = QingSessionUtil.get((String)(this.tag + OLD));
            if (StringUtils.isBlank((CharSequence)oldBoxModelJson)) {
                Box oldBoxModel = themeDataSource.getBoxModel();
                QingSessionUtil.set((String)(this.tag + OLD), (String)JsonUtil.encodeToString((Object)oldBoxModel));
            }
            themeDataSource.setBox(boxModel);
            QingSessionUtil.setCache((ISessionCacheable)themeDataSource);
            return themeDataSource.getBoxModel();
        }
        throw new ImportNoInfoFoundException();
    }

    public DmDynamicData resetModel() throws ImportNoInfoFoundException, ImportCacheNotFoundException {
        String cacheKey = ThemeDataSource.getCacheKey(this.tag);
        ThemeDataSource themeDataSource = (ThemeDataSource)QingSessionUtil.getCache((String)cacheKey, ThemeDataSource.class);
        if (themeDataSource != null) {
            String oldBoxModelJson = QingSessionUtil.get((String)(this.tag + OLD));
            if (StringUtils.isNotBlank((CharSequence)oldBoxModelJson)) {
                Box oldBoxModel = (Box)ModelDecoder.decode((String)oldBoxModelJson, Box.class);
                themeDataSource.setBox(oldBoxModel);
                QingSessionUtil.setCache((ISessionCacheable)themeDataSource);
            }
            return this.loadModel();
        }
        throw new ImportNoInfoFoundException();
    }

    public DmDynamicData loadModel() throws ImportNoInfoFoundException, ImportCacheNotFoundException {
        DmDynamicData dmDynamicData = new DmDynamicData();
        Box box = QHFDmUtil.loadModel(this.tag);
        dmDynamicData.setBoxModel(box);
        String dsbTag = QingSessionUtil.get((String)this.tag);
        List<String> varTypeStringList = QHFDmUtil.loadSystemVarTypes(StringUtils.isNotBlank((CharSequence)dsbTag) ? dsbTag : this.tag);
        dmDynamicData.setSystemVarTypes(varTypeStringList);
        return dmDynamicData;
    }
}

