/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.linkage;

import com.kingdee.bos.qing.common.cache.AbstractDataSource;
import com.kingdee.bos.qing.common.cache.LinkageContext;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.linkage.ILinkageStrategy;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LinkageService {
    public final byte[] loadLinkageContext(Map<String, String> params) {
        try {
            String tag = params.get("tag");
            IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
            LinkageContext linkageContext = new LinkageContext();
            AbstractDataSource dataSource = (AbstractDataSource)qingSession.getCache(AbstractDataSource.getCacheKey(tag), AbstractDataSource.class);
            if (dataSource != null) {
                linkageContext = dataSource.getLinkageContext();
            }
            ResponseSuccessWrap successWrap = new ResponseSuccessWrap((Object)linkageContext);
            return ResponseUtil.output((IResponseWrap)successWrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public final byte[] cancleJumpToLinkTarget(Map<String, String> params) {
        String foreignKeyMembersCachedId = params.get("foreignKeyMembersCachedId");
        try {
            ILinkageStrategy linkageStoreService;
            if (null != foreignKeyMembersCachedId && null != (linkageStoreService = (ILinkageStrategy)CustomStrategyRegistrar.getStrategy(ILinkageStrategy.class))) {
                linkageStoreService.deleteLinkageForeignKeys(foreignKeyMembersCachedId);
            }
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public final byte[] lookupBizMeta(Map<String, String> params) {
        List linkageBizUiIds = (List)JsonUtil.decodeFromString((String)params.get("arrBizUiId"), List.class);
        String tag = params.get("tag");
        try {
            List linkageBizUiNames = new ArrayList(10);
            ILinkageStrategy linkageStoreService = (ILinkageStrategy)CustomStrategyRegistrar.getStrategy(ILinkageStrategy.class);
            if (null != linkageStoreService) {
                linkageBizUiNames = linkageStoreService.getDisplayNameByBizUiId(linkageBizUiIds, tag);
            }
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(linkageBizUiNames));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

