/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.macro;

import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.framework.server.annotation.longtime.LongTimeServiceMethodAnnotation;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.dbmanage.domain.DBConnectionDomain;
import com.kingdee.bos.qing.macro.domain.AbstractMacroDomain;
import com.kingdee.bos.qing.macro.domain.MacroCommonDomain;
import com.kingdee.bos.qing.macro.domain.MacroDomainFactory;
import com.kingdee.bos.qing.macro.exception.NoMacroManagePermException;
import com.kingdee.bos.qing.macro.exception.QingMacroException;
import com.kingdee.bos.qing.macro.export.MacroExportDomain;
import com.kingdee.bos.qing.macro.model.MacroType;
import com.kingdee.bos.qing.macro.model.vo.Macro;
import com.kingdee.bos.qing.macro.model.vo.MacrosPaginationVo;
import com.kingdee.bos.qing.macro.model.vo.PreviewData;
import com.kingdee.bos.qing.macro.util.MacroJsonUtil;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMacroService
implements IDBAccessable,
IQingContextable {
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    protected QingContext qingContext;
    private MacroCommonDomain commonDomain;
    private Map<MacroType, AbstractMacroDomain> domainMap;
    private MacroExportDomain macroExportDomain;
    private DBConnectionDomain dbConnectionDomain;

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    private MacroExportDomain getMacroExportDomain() {
        if (this.macroExportDomain == null) {
            this.macroExportDomain = new MacroExportDomain(this.dbExcuter, this.qingContext, this.tx);
        }
        return this.macroExportDomain;
    }

    private AbstractMacroDomain getMacroManageDomain(MacroType macroType) throws QingMacroException {
        AbstractMacroDomain manageDomain = null;
        if (this.domainMap == null) {
            this.domainMap = new HashMap<MacroType, AbstractMacroDomain>();
        } else {
            manageDomain = this.domainMap.get(macroType);
        }
        if (manageDomain == null) {
            manageDomain = MacroDomainFactory.getDomain((MacroType)macroType, (IDBExcuter)this.dbExcuter, (ITransactionManagement)this.tx, (QingContext)this.qingContext);
        }
        return manageDomain;
    }

    private MacroCommonDomain getCommonDomain() {
        if (this.commonDomain == null) {
            this.commonDomain = new MacroCommonDomain(this.dbExcuter, this.qingContext);
        }
        return this.commonDomain;
    }

    private DBConnectionDomain getDBConnectionDomain() {
        if (this.dbConnectionDomain == null) {
            this.dbConnectionDomain = new DBConnectionDomain(this.dbExcuter, this.tx, this.qingContext);
        }
        return this.dbConnectionDomain;
    }

    public byte[] saveMacro(Map<String, String> params) {
        String jsonMacro = params.get("model");
        String macroType = params.get("macroType");
        String appId = params.get("appID");
        try {
            if (this.checkMacroPermImpl(params)) {
                Macro macro = MacroJsonUtil.decodeFromJson((String)jsonMacro, (MacroType)MacroType.valueOf((String)macroType));
                macro = this.getMacroManageDomain(MacroType.valueOf((String)macroType)).saveMacro(macro, true);
                return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)macro));
            }
            return ResponseUtil.output((Exception)new NoMacroManagePermException());
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadAllMacroIds(Map<String, String> params) {
        String macroType = params.get("macroType");
        String searchText = params.get("searchText");
        try {
            List macroIds = this.getMacroManageDomain(MacroType.valueOf((String)macroType)).loadMacroIds(searchText);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)macroIds));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadMacrosRefTimeByFIds(Map<String, String> params) {
        String macroType = params.get("macroType");
        String macroIdJson = params.get("macroIds");
        List macroIds = (List)JsonUtil.decodeFromString((String)macroIdJson, List.class);
        try {
            Integer refTime = this.getMacroManageDomain(MacroType.valueOf((String)macroType)).getRefTimeOfDeleteMacros(macroIds);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)refTime));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadMacro(Map<String, String> params) {
        String macroId = params.get("macroId");
        try {
            MacroType macroType = this.getCommonDomain().getMacroType(macroId);
            Macro macro = this.getMacroManageDomain(macroType).loadMacro(macroId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)macro));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] checkMacroPermissionBeforePreview(Map<String, String> params) {
        String macroUid = params.get("macroUid");
        String macroType = params.get("macroType");
        try {
            boolean hasPermission = this.getMacroManageDomain(MacroType.valueOf((String)macroType)).checkMacroPermissionByUid(macroUid);
            HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
            map.put("macroHasPermission", hasPermission);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(map));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadMacros(Map<String, String> params) {
        String macroType = params.get("macroType");
        String searchText = params.get("searchText");
        Integer pageSize = Integer.parseInt(params.get("pageSize"));
        Integer targetPage = Integer.parseInt(params.get("targetPage"));
        try {
            MacrosPaginationVo macrosPaginationVo = this.getMacroManageDomain(MacroType.valueOf((String)macroType)).loadMacros(targetPage, pageSize, searchText);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("totalRow", macrosPaginationVo.getTotalRow());
            map.put("currentPage", macrosPaginationVo.getCurrentPage());
            map.put("pageSize", macrosPaginationVo.getPageSize());
            map.put("macros", macrosPaginationVo.getMacros());
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(map));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadMacroByValueInBox(Map<String, String> params) {
        String macroValueInBox = params.get("macroValueInBox");
        try {
            Macro macro = this.getCommonDomain().loadCommonMacroByUidInBox(macroValueInBox);
            macro = this.getMacroManageDomain(macro.getType()).loadMacro(macro.getFid());
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)macro));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadAllMacros(Map<String, String> params) {
        String macroType = params.get("macroType");
        try {
            List macros = this.getMacroManageDomain(MacroType.valueOf((String)macroType)).loadAllMacros();
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)macros));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] deleteMacros(Map<String, String> params) {
        String jsonIds = params.get("macroIds");
        List ids = (List)JsonUtil.decodeFromString((String)jsonIds, List.class);
        String macroType = params.get("macroType");
        String appId = params.get("appID");
        try {
            if (this.checkMacroPermImpl(params)) {
                this.getMacroManageDomain(MacroType.valueOf((String)macroType)).deleteMacros(ids);
                return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
            }
            return ResponseUtil.output((Exception)new NoMacroManagePermException());
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] updateMacro(Map<String, String> params) {
        String jsonMacro = params.get("model");
        String macroType = params.get("macroType");
        String appId = params.get("appID");
        try {
            if (this.checkMacroPermImpl(params)) {
                Macro macro = MacroJsonUtil.decodeFromJson((String)jsonMacro, (MacroType)MacroType.valueOf((String)macroType));
                macro = this.getMacroManageDomain(MacroType.valueOf((String)macroType)).updateMacro(macro);
                return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)macro));
            }
            return ResponseUtil.output((Exception)new NoMacroManagePermException());
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @LongTimeServiceMethodAnnotation
    public byte[] preview(Map<String, String> params) {
        String jsonMacro = params.get("model");
        String macroType = params.get("macroType");
        try {
            Macro macro = MacroJsonUtil.decodeFromJson((String)jsonMacro, (MacroType)MacroType.valueOf((String)macroType));
            AbstractMacroDomain manageDomain = this.getMacroManageDomain(MacroType.valueOf((String)macroType));
            PreviewData rs = manageDomain.getPreviewData(macro);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)rs));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getSupportedSystemVarType(Map<String, String> params) {
        Set varTypes = this.qingContext.getSupportedSystemVarTypes();
        ArrayList<String> varTypeStringList = new ArrayList<String>(varTypes.size());
        for (SystemVarType varType : varTypes) {
            varTypeStringList.add(varType.name());
        }
        ResponseSuccessWrap wrap = new ResponseSuccessWrap(varTypeStringList);
        return ResponseUtil.output((IResponseWrap)wrap);
    }

    public byte[] loadMacroByUidsInBox(Map<String, String> params) {
        String uidsInBox = params.get("macroIds");
        try {
            List ids = (List)JsonUtil.decodeFromString((String)uidsInBox, List.class);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)this.getCommonDomain().loadMacroInfoForUserSQL(ids)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadMacroByDisplayNames(Map<String, String> params) {
        String displayNames = params.get("displayNames");
        try {
            List names = (List)JsonUtil.decodeFromString((String)displayNames, List.class);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)this.getCommonDomain().loadMacroInfoForUserSQLByDisplayName(names)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] exportMacros(Map<String, String> params) {
        String macroIds = params.get("macroIds");
        String appId = params.get("appID");
        try {
            if (this.checkMacroPermImpl(params)) {
                List ids = (List)JsonUtil.decodeFromString((String)macroIds, List.class);
                String fileName = this.getMacroExportDomain().doExport(ids);
                ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)fileName);
                return ResponseUtil.output((IResponseWrap)wrap);
            }
            return ResponseUtil.output((Exception)new NoMacroManagePermException());
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getOptionalImportMacro(Map<String, String> params) {
        String uploadedFilePath = params.get("filePath");
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getMacroExportDomain().getOptionalImportMacro(uploadedFilePath)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] importMacros(Map<String, String> params) {
        String importMacroModels = params.get("models");
        List jsonMacros = (List)JsonUtil.decodeFromString((String)importMacroModels, List.class);
        try {
            if (this.checkMacroPermImpl(params)) {
                ArrayList<Macro> macros = new ArrayList<Macro>(jsonMacros.size());
                for (String jsonMacro : jsonMacros) {
                    Macro macro = MacroJsonUtil.decodeFromJson((String)jsonMacro, (MacroType)MacroType.SQL);
                    macros.add(macro);
                }
                return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)this.getMacroExportDomain().importMacros(macros, params.get("strategy"))));
            }
            return ResponseUtil.output((Exception)new NoMacroManagePermException());
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadDBConnections(Map<String, String> params) {
        try {
            List dbConnections = this.getDBConnectionDomain().loadDBConnections(this.qingContext.getUserId());
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)dbConnections));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] checkMacroPermission(Map<String, String> params) {
        String appId = params.get("appID");
        try {
            boolean flag = this.checkMacroPermImpl(params);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)flag);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    protected abstract boolean checkMacroPermImpl(Map<String, String> var1);
}

