/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.macro.export;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.dbmanage.domain.DBConnectionDomain;
import com.kingdee.bos.qing.dbmanage.export.DBExportModelConvertor;
import com.kingdee.bos.qing.dbmanage.model.DBConnection;
import com.kingdee.bos.qing.dbmanage.model.DBRefInfo;
import com.kingdee.bos.qing.dbmanage.model.RefFromType;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileWriter;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.filesystem.stream.QingOutputStream;
import com.kingdee.bos.qing.imexport.exporter.exception.ExportException;
import com.kingdee.bos.qing.imexport.model.resource.DBConnInfo;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.macro.domain.AbstractMacroDomain;
import com.kingdee.bos.qing.macro.domain.MacroCommonDomain;
import com.kingdee.bos.qing.macro.domain.MacroDomainFactory;
import com.kingdee.bos.qing.macro.exception.MacroDuplicateNameException;
import com.kingdee.bos.qing.macro.exception.MacroDuplicateUidException;
import com.kingdee.bos.qing.macro.exception.NoMacroManagePermException;
import com.kingdee.bos.qing.macro.exception.QingMacroException;
import com.kingdee.bos.qing.macro.export.ExportModelConvertor;
import com.kingdee.bos.qing.macro.export.PackageMeta;
import com.kingdee.bos.qing.macro.model.MacroType;
import com.kingdee.bos.qing.macro.model.vo.ImportResult;
import com.kingdee.bos.qing.macro.model.vo.Macro;
import com.kingdee.bos.qing.macro.model.vo.SQLMacro;
import com.kingdee.bos.qing.macro.oplog.MacroOpLog;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.OpLogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;

public class MacroExportDomain {
    private IDBExcuter dbExcuter;
    private QingContext qingContext;
    private ITransactionManagement tx;
    private MacroCommonDomain macroCommonDomain;
    private Map<MacroType, AbstractMacroDomain> macroDomainMap;
    private static final String CONFLICT_STRATEGY_OVERWRITE = "overwrite";
    private DBConnectionDomain dbConnDomain;

    public MacroExportDomain(IDBExcuter dbExcuter, QingContext qingContext, ITransactionManagement tx) {
        this.dbExcuter = dbExcuter;
        this.qingContext = qingContext;
        this.tx = tx;
    }

    private MacroCommonDomain getMacroCommonDomain() {
        if (this.macroCommonDomain == null) {
            this.macroCommonDomain = new MacroCommonDomain(this.dbExcuter, this.qingContext);
        }
        return this.macroCommonDomain;
    }

    private AbstractMacroDomain getMacroDomain(MacroType macroType) throws QingMacroException {
        AbstractMacroDomain macroDomain;
        if (this.macroDomainMap == null) {
            this.macroDomainMap = new EnumMap<MacroType, AbstractMacroDomain>(MacroType.class);
        }
        if ((macroDomain = this.macroDomainMap.get(macroType)) == null) {
            macroDomain = MacroDomainFactory.getDomain((MacroType)macroType, (IDBExcuter)this.dbExcuter, (ITransactionManagement)this.tx, (QingContext)this.qingContext);
            this.macroDomainMap.put(macroType, macroDomain);
        }
        return macroDomain;
    }

    private DBConnectionDomain getDBConnDomain() {
        if (this.dbConnDomain == null) {
            this.dbConnDomain = new DBConnectionDomain(this.dbExcuter, this.tx, this.qingContext);
        }
        return this.dbConnDomain;
    }

    public String doExport(List<String> macroIds) throws AbstractQingIntegratedException, SQLException, QingMacroException, ExportException, NoMacroManagePermException {
        if (!this.getMacroCommonDomain().hasManageAuthority()) {
            throw new NoMacroManagePermException();
        }
        PackageMeta packageMeta = new PackageMeta();
        String displayName = null;
        for (String macroId : macroIds) {
            MacroType macroType = this.getMacroCommonDomain().getMacroType(macroId);
            AbstractMacroDomain macroDomain = MacroDomainFactory.getDomain((MacroType)macroType, (IDBExcuter)this.dbExcuter, null, (QingContext)this.qingContext);
            Macro macro = macroDomain.loadMacro(macroId);
            if (displayName == null) {
                displayName = macro.getName();
            }
            com.kingdee.bos.qing.imexport.model.resource.Macro exportMacro = ExportModelConvertor.convertMacroToExportModel(macro);
            if (macro instanceof SQLMacro) {
                DBConnection dbConn;
                List dbRefInfos = this.getDBConnDomain().loadDBRefInfoByFromId(macro.getFid(), RefFromType.Macro);
                if (!dbRefInfos.isEmpty()) {
                    ((com.kingdee.bos.qing.imexport.model.resource.SQLMacro)exportMacro).setRefDBHashcode(((DBRefInfo)dbRefInfos.get(0)).getDBHashcode());
                }
                if ((dbConn = ((SQLMacro)macro).getDBInfo()) != null && dbConn.isDBCenterSource()) {
                    packageMeta.addDBConn(DBExportModelConvertor.convertDBConnToExportModel((DBConnection)dbConn));
                }
            }
            packageMeta.addMacro(exportMacro);
        }
        try {
            ArrayList<String> params = new ArrayList<String>(2);
            MacroOpLog mapDir = MacroOpLog.EMPTY_DIR;
            params.add(displayName);
            if (macroIds.size() > 1) {
                mapDir.setParamsDesc("\u201c$param\u201d\u7b49$param\u9879");
                params.add(macroIds.size() + "");
            } else {
                mapDir.setParamsDesc("\u201c$param\u201d");
            }
            mapDir.setLogScene("\u5b8f\u5b9a\u4e49");
            OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.EXPORT, (IOpLogConstant)mapDir, params));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.writeToZip(packageMeta);
    }

    public List<Macro> getOptionalImportMacro(String filePath) throws QingMacroException {
        IQingFileVisitor zipFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)filePath);
        ArrayList<Macro> optionalMacros = new ArrayList<Macro>(10);
        QingInputStream in = null;
        ZipInputStream zis = null;
        try {
            in = zipFile.getInputStream();
            zis = new ZipInputStream((InputStream)in);
            ZipEntry zipEntry = null;
            while ((zipEntry = zis.getNextEntry()) != null) {
                Element macrosElement;
                int len;
                String zipEntryName = zipEntry.getName();
                if (!zipEntryName.endsWith("package-meta.xml")) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = zis.read(buffer)) > -1) {
                    baos.write(buffer, 0, len);
                }
                baos.flush();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
                Element rootElement = XmlUtil.loadRootElement((InputStream)byteArrayInputStream);
                String version = rootElement.getAttributeValue("version");
                Element resourceElement = rootElement.getChild("Resources");
                if (resourceElement == null || (macrosElement = resourceElement.getChild("Macros")) == null) continue;
                ArrayList<DBConnection> importedDBConn = new ArrayList<DBConnection>(10);
                Element dbInfosElement = resourceElement.getChild("DBConnInfos");
                if (dbInfosElement != null) {
                    List dbInfoElements = dbInfosElement.getChildren();
                    for (Element element : dbInfoElements) {
                        DBConnInfo exportModel = new DBConnInfo();
                        exportModel.fromXml(element, version);
                        DBConnection dbConn = DBExportModelConvertor.convertExportModelToDBConn((DBConnInfo)exportModel);
                        importedDBConn.add(dbConn);
                    }
                }
                List macroElements = macrosElement.getChildren();
                for (Element element : macroElements) {
                    com.kingdee.bos.qing.imexport.model.resource.Macro exportMacro = ExportModelConvertor.fromXml(element, version);
                    Macro macro = ExportModelConvertor.convertExportModelToMacro(exportMacro);
                    if (macro instanceof SQLMacro) {
                        String refDBHashcode = ((com.kingdee.bos.qing.imexport.model.resource.SQLMacro)exportMacro).getRefDBHashcode();
                        ((SQLMacro)macro).setRefDBHashCode(refDBHashcode);
                        for (DBConnection dbConn : importedDBConn) {
                            if (!dbConn.getDBHashCode().equals(refDBHashcode)) continue;
                            ((SQLMacro)macro).setDBInfo(dbConn);
                        }
                    }
                    optionalMacros.add(macro);
                }
            }
        }
        catch (Exception e) {
            try {
                throw new QingMacroException((Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{zis});
                IQingFileUpdater fileUpdater = FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingTempFileType.UPLOAD, (String)filePath);
                fileUpdater.delete();
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{zis});
        IQingFileUpdater fileUpdater = FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingTempFileType.UPLOAD, (String)filePath);
        fileUpdater.delete();
        return optionalMacros;
    }

    public ImportResult importMacros(List<Macro> macros, String strategy) throws AbstractQingIntegratedException, SQLException, QingMacroException, NoMacroManagePermException {
        if (!this.getMacroCommonDomain().hasManageAuthority()) {
            throw new NoMacroManagePermException();
        }
        ImportResult result = new ImportResult();
        boolean overwrite = CONFLICT_STRATEGY_OVERWRITE.equals(strategy);
        try {
            this.tx.beginRequired();
            for (Macro macro : macros) {
                AbstractMacroDomain macroDomain = this.getMacroDomain(macro.getType());
                try {
                    macroDomain.saveMacroWithoutTx(macro, false);
                    result.addSuccessUid(macro.getUid());
                }
                catch (MacroDuplicateUidException e) {
                    if (overwrite) {
                        String uid = macro.getUid();
                        MacroType oldMacroType = this.getMacroCommonDomain().getMacroTypeByUid(uid);
                        AbstractMacroDomain oldMacroDomain = this.getMacroDomain(oldMacroType);
                        oldMacroDomain.deleteMacroByUidWithoutTx(uid);
                        macroDomain.saveMacroWithoutTx(macro, false);
                        result.addSuccessUid(macro.getUid());
                        continue;
                    }
                    result.addConflictUid(macro.getUid());
                }
                catch (MacroDuplicateNameException e) {
                    String name = macro.getName();
                    name = ImExportUtil.rename(name);
                    while (macroDomain.isMacroNameExist(name)) {
                        name = ImExportUtil.rename(name);
                    }
                    macro.setName(name);
                    macroDomain.saveMacroWithoutTx(macro, false);
                    result.addSuccessUid(macro.getUid());
                }
            }
        }
        catch (QingMacroException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
        boolean allSuccess = result.getSuccessUids().size() == macros.size();
        result.setAllSuccess(allSuccess);
        return result;
    }

    private String writeToZip(PackageMeta packageMeta) throws ExportException {
        String string;
        IQingFileWriter zipFileWriter = null;
        QingOutputStream fos = null;
        ZipOutputStream zos = null;
        IQingFile exportFile = null;
        Exception exception = null;
        try {
            exportFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
            zipFileWriter = exportFile.createWriter();
            fos = zipFileWriter.getOutputStream();
            zos = new ZipOutputStream((OutputStream)fos);
            zos.putNextEntry(new ZipEntry("package-meta.xml"));
            XmlUtil.save((Element)packageMeta.toXml(), (OutputStream)zos);
            string = exportFile.getName();
        }
        catch (Exception e) {
            try {
                FileFactory.clearFile((IQingFile)exportFile);
                throw new ExportException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{zos});
                CloseUtil.close((Closeable[])new Closeable[]{fos});
                if (zipFileWriter != null) {
                    zipFileWriter.close(exception);
                    zipFileWriter = null;
                }
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{zos});
        CloseUtil.close((Closeable[])new Closeable[]{fos});
        if (zipFileWriter != null) {
            zipFileWriter.close(exception);
            zipFileWriter = null;
        }
        return string;
    }
}

