/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.stream.QingEncryptedStreamUtil;
import com.kingdee.bos.qing.imexport.model.po.AbstractPublishModel;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.IThemeGroupDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.dao.impl.ThemeGroupDaoImpl;
import com.kingdee.bos.qing.manage.domain.IThemeManageDomain;
import com.kingdee.bos.qing.manage.exception.ExportThemeException;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.exception.ThemeGroupDuplicateNameException;
import com.kingdee.bos.qing.manage.exception.ThemeGroupNotFoundException;
import com.kingdee.bos.qing.manage.exception.ThemeManagementException;
import com.kingdee.bos.qing.manage.exception.ThemeNameDuplicateException;
import com.kingdee.bos.qing.manage.exception.ThemeNotFoundException;
import com.kingdee.bos.qing.manage.imexport.collector.DashboardCollectorGetter;
import com.kingdee.bos.qing.manage.imexport.collector.ICollectable;
import com.kingdee.bos.qing.manage.imexport.collector.SubjectCollectorGetter;
import com.kingdee.bos.qing.manage.imexport.domain.ImExportDomain;
import com.kingdee.bos.qing.manage.imexport.model.po.ExportThemeGroupModel;
import com.kingdee.bos.qing.manage.imexport.model.po.ExportThemeModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractPublishImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractThemeImportModel;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportThemeVO;
import com.kingdee.bos.qing.manage.model.ThemeGroupPO;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.manage.oplog.ManageOpLog;
import com.kingdee.bos.qing.map.dao.MapManageDao;
import com.kingdee.bos.qing.map.imexport.model.ExportMapModel;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.publish.PublishManageDomianFactory;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.dao.PublishOperPermissionsDao;
import com.kingdee.bos.qing.publish.dao.PublishPermissionDao;
import com.kingdee.bos.qing.publish.domain.AbstractPublishManageDomain;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishVO;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetImexportDomain;
import com.kingdee.bos.qing.publish.target.PublishTargetDomainFactory;
import com.kingdee.bos.qing.publish.target.PublishTargetImexportDomainFactory;
import com.kingdee.bos.qing.publish.target.analysiscenter.domain.AnalysisCenterManageDomain;
import com.kingdee.bos.qing.publish.target.card.domain.AbstractCardManageDomain;
import com.kingdee.bos.qing.publish.target.lapp.LappDomain;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.subject.exception.SubjectNotFoundException;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.OpLogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jdom2.JDOMException;

public abstract class AbstractThemeManageDomain
implements IThemeManageDomain {
    protected QingContext qingContext;
    protected ITransactionManagement tx;
    protected IDBExcuter dbExcuter;
    protected IScheduleEngine scheduleEngine;
    private PublishInfoDao publishInfoDao;
    private PublishPermissionDao publishPermissionDao;
    private CommonPublishDomain commonPublishDomain;
    private LappDomain lappDomain;
    private PublishOperPermissionsDao publishOperPermissionsDao;
    private AbstractCardManageDomain cardManageDomain;
    private AnalysisCenterManageDomain analysisCenterManageDomain;
    private AbstractPublishManageDomain appMenuManageDomain;
    private IThemeDao iThemeDao;
    private IThemeGroupDao iThemeGroupDao;
    private SchemaManageDao schemaDao;
    private MapManageDao mapManageDao;

    public AbstractThemeManageDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        this.qingContext = qingContext;
        this.tx = tx;
        this.dbExcuter = dbExcuter;
        this.scheduleEngine = scheduleEngine;
    }

    public AbstractThemeManageDomain() {
    }

    protected IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    protected IThemeGroupDao getThemeGroupDao() {
        if (this.iThemeGroupDao == null) {
            this.iThemeGroupDao = new ThemeGroupDaoImpl(this.dbExcuter);
        }
        return this.iThemeGroupDao;
    }

    protected PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private PublishPermissionDao getPublishPermissionDao() {
        if (this.publishPermissionDao == null) {
            this.publishPermissionDao = new PublishPermissionDao(this.dbExcuter);
        }
        return this.publishPermissionDao;
    }

    private CommonPublishDomain getcommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    protected SchemaManageDao getSchemaDao() {
        if (this.schemaDao == null) {
            this.schemaDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaDao;
    }

    protected MapManageDao getMapManageDao() {
        if (this.mapManageDao == null) {
            this.mapManageDao = new MapManageDao();
            this.mapManageDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapManageDao;
    }

    private LappDomain getLappDomain() {
        if (this.lappDomain == null) {
            this.lappDomain = new LappDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.lappDomain;
    }

    private AbstractCardManageDomain getCardDomain() {
        if (this.cardManageDomain == null) {
            this.cardManageDomain = (AbstractCardManageDomain)PublishManageDomianFactory.getPublishManageDomian((Integer)5, (QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, null);
        }
        return this.cardManageDomain;
    }

    private AbstractPublishManageDomain getAppMenuManageDomain() {
        if (this.appMenuManageDomain == null) {
            this.appMenuManageDomain = PublishManageDomianFactory.getPublishManageDomian((Integer)0, (QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, null);
        }
        return this.appMenuManageDomain;
    }

    private AnalysisCenterManageDomain getAnalysisCenterDomain() {
        if (this.analysisCenterManageDomain == null) {
            this.analysisCenterManageDomain = new AnalysisCenterManageDomain(this.qingContext, this.tx, this.dbExcuter, null);
        }
        return this.analysisCenterManageDomain;
    }

    protected PublishOperPermissionsDao getPublishOperPermissionsDao() {
        if (this.publishOperPermissionsDao == null) {
            this.publishOperPermissionsDao = new PublishOperPermissionsDao(this.dbExcuter);
        }
        return this.publishOperPermissionsDao;
    }

    private void overwriteImportTheme(ThemePO themePO) throws AbstractQingIntegratedException, SQLException {
        String themeID;
        ThemeVO themeVO = this.getThemeDao().loadThemeByName(themePO.getUserID(), themePO.getGroupID(), themePO.getThemeName(), themePO.getThemeType());
        if (themeVO != null) {
            themeID = themeVO.getThemeID();
            themePO.setThemeID(themeID);
            this.doOverwrite(themeID);
        }
        try {
            themeID = this.getThemeDao().saveOrUpdateTheme(themePO);
            themePO.setThemeID(themeID);
        }
        catch (ThemeNameDuplicateException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)((Object)e));
        }
    }

    protected abstract void doOverwrite(String var1) throws AbstractQingIntegratedException, SQLException;

    private void renameImportTheme(ThemePO themePO) throws AbstractQingIntegratedException, SQLException {
        boolean bInsert = false;
        String themeID = null;
        String themeName = null;
        themePO.setThemeID(null);
        while (!bInsert) {
            String conFlictThemeName = themePO.getThemeName();
            if (conFlictThemeName.lastIndexOf("_") > 0) {
                String indexStr = conFlictThemeName.substring(conFlictThemeName.lastIndexOf("_") + 1, conFlictThemeName.length());
                themeName = conFlictThemeName.substring(0, conFlictThemeName.lastIndexOf("_"));
                try {
                    Integer index = Integer.parseInt(indexStr);
                    index = index + 1;
                    themeName = themeName + "_" + index;
                }
                catch (NumberFormatException e) {
                    themeName = conFlictThemeName + "_1";
                }
            } else {
                themeName = conFlictThemeName + "_1";
            }
            themePO.setThemeName(themeName);
            try {
                themeID = this.getThemeDao().saveOrUpdateTheme(themePO);
                bInsert = true;
            }
            catch (ThemeNameDuplicateException e) {
                bInsert = false;
            }
        }
        themePO.setThemeID(themeID);
    }

    public final void doImportTheme(AbstractThemeImportModel themeImportModel) throws AbstractQingIntegratedException, ImportThemeException {
        String themeGroupName = themeImportModel.getGroupName();
        String strategy = themeImportModel.getStrategy();
        ExportThemeVO.StrategyType strategyType = ExportThemeVO.StrategyType.fromPersistance(strategy);
        ThemePO themePO = new ThemePO();
        themePO.setDescription(themeImportModel.getDescription());
        themePO.setThemeName(themeImportModel.getThemeName());
        themePO.setThemeType(themeImportModel.getThemeType());
        String userId = this.qingContext.getUserId();
        if (strategyType == ExportThemeVO.StrategyType.ignore) {
            return;
        }
        try {
            this.tx.beginRequired();
            ThemeGroupVO themeGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupName(userId, themeGroupName);
            String themeGroupID = null;
            if (themeGroupVO == null) {
                try {
                    ThemeGroupPO groupPO = new ThemeGroupPO();
                    groupPO.setThemeGroupName(themeGroupName);
                    groupPO.setUserID(userId);
                    themeGroupID = this.getThemeGroupDao().saveThemeGroup(groupPO);
                    themeImportModel.getSaveSuccessThemeGroupIDList().add(themeGroupID);
                }
                catch (ThemeGroupDuplicateNameException e) {
                    themeGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupName(userId, themeGroupName);
                    themeGroupID = themeGroupVO.getThemeGroupID();
                }
            } else {
                themeGroupID = themeGroupVO.getThemeGroupID();
            }
            Date date = new Date();
            themePO.setGroupID(themeGroupID);
            themePO.setUserID(userId);
            themePO.setCreateTime(date);
            themePO.setUpdateTime(date);
            if (strategy == null) {
                String themeID = this.getThemeDao().saveOrUpdateTheme(themePO);
                themePO.setThemeID(themeID);
            } else if (strategyType == ExportThemeVO.StrategyType.overwrite) {
                this.overwriteImportTheme(themePO);
            } else if (strategyType == ExportThemeVO.StrategyType.rename) {
                this.renameImportTheme(themePO);
                themeImportModel.setThemeNewName(themePO.getThemeName());
            }
            themeImportModel.setGroupName(themeGroupName);
            themeImportModel.setThemeID(themePO.getThemeID());
            themeImportModel.setThemeGroupId(themeGroupID);
            if ("0".equals(themeImportModel.getThemeType())) {
                String nameSpace = themeImportModel.getNameSpace() == null ? NameSpace.user.toPersistance() : themeImportModel.getNameSpace();
                String themePath = nameSpace + "/" + themeImportModel.getThemePath();
                themeImportModel.getImportSubjectPathAndId().put(themePath, themePO.getThemeID());
            }
            this.doImport(themeImportModel);
        }
        catch (ThemeNameDuplicateException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)((Object)e));
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new ImportThemeException(e);
        }
        catch (ImportThemeException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (Exception e) {
            this.tx.markRollback();
            throw new ImportThemeException(e);
        }
        finally {
            this.tx.end();
        }
    }

    protected final void doImportPublishInfo(AbstractThemeImportModel themeImportModel, List<IQingFile> successImportFiles) throws ThemeManagementException, AbstractQingIntegratedException {
        Map<String, AbstractPublishImportModel> publishImportModels = themeImportModel.getPublishImportModels();
        if (publishImportModels != null && !publishImportModels.isEmpty()) {
            for (Map.Entry<String, AbstractPublishImportModel> publishEntry : publishImportModels.entrySet()) {
                AbstractPublishImportModel publishImportModel = publishImportModels.get(publishEntry.getKey());
                AbstractPublishModel publishModel = publishImportModel.getPublishModel();
                AbstractPublishTargetImexportDomain publishTargetImexportDomain = PublishTargetImexportDomainFactory.createPublishTargetImexportDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine, publishModel.getPublishTargetType());
                if (publishTargetImexportDomain == null) continue;
                publishTargetImexportDomain.doImportPublishInfo(themeImportModel, publishImportModel, successImportFiles);
            }
        }
    }

    protected abstract void doImport(AbstractThemeImportModel var1) throws ImportThemeException, AbstractQingIntegratedException;

    public abstract void exportTheme(String var1, String var2, ThemeVO var3, boolean var4, ZipOutputStream var5) throws ExportThemeException, AbstractQingIntegratedException;

    private List<String> deletePublishInfos(String tagId, String userID) throws AbstractQingIntegratedException, SQLException, ThemeManagementException {
        List publishPOs = this.getPublishInfoDao().loadPublishInfos(tagId, userID);
        ArrayList<String> publishIds = new ArrayList<String>();
        for (int i = 0; i < publishPOs.size(); ++i) {
            PublishPO publishInfo = (PublishPO)publishPOs.get(i);
            String publishId = publishInfo.getId();
            try {
                boolean checkIsRobotPublish = this.getLappDomain().checkIsRobotPublih(publishId);
                if (6 == publishInfo.getPublishTargetType() || checkIsRobotPublish) continue;
                this.addDelLog(publishId);
                publishIds.add(publishId);
                PublishSourceEnum sourceType = this.getcommonPublishDomain().confirmSourceTypeByPublishInfo(publishInfo);
                AbstractPublishManageDomain.doDeletePublishInfo((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (ITransactionManagement)this.tx, (IScheduleEngine)this.scheduleEngine, (PublishPO)publishInfo, (PublishSourceEnum)sourceType, (PublishInfoDao)this.getPublishInfoDao(), (PublishPermissionDao)this.getPublishPermissionDao(), (PublishOperPermissionsDao)this.getPublishOperPermissionsDao());
                continue;
            }
            catch (PublishException e) {
                throw new ThemeManagementException(e);
            }
            catch (SQLException e) {
                throw new ThemeManagementException(e);
            }
        }
        return publishIds;
    }

    private void addDelLog(String publishId) {
        PublishVO publishVO = null;
        try {
            ArrayList<String> params = new ArrayList<String>(2);
            publishVO = this.getCardDomain().getPublishVO(publishId);
            if (publishVO != null && publishVO.getPathText() != null && publishVO.getName() != null) {
                params.add(publishVO.getName());
                params.add(publishVO.getPathText());
                this.doAddDelLog(params, this.getCardDomain());
            }
            params.clear();
            publishVO = this.getAnalysisCenterDomain().getPublishVO(publishId);
            if (publishVO != null && publishVO.getPathText() != null && publishVO.getName() != null) {
                params.add(publishVO.getName());
                params.add(publishVO.getPathText());
                this.doAddDelLog(params, (AbstractPublishManageDomain)this.getAnalysisCenterDomain());
            }
            params.clear();
            publishVO = this.getAppMenuManageDomain().getPublishVO(publishId);
            if (publishVO != null && publishVO.getPathText() != null && publishVO.getName() != null) {
                params.add(publishVO.getName());
                params.add(publishVO.getPathText());
                this.doAddDelLog(params, this.getAppMenuManageDomain());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doAddDelLog(List<String> params, AbstractPublishManageDomain domain) {
        domain.addPublishOpLog(OpLogActionType.DELETE, params, "\u201c$param\u201d");
    }

    @Override
    public final List<String> deleteTheme(String userID, String themeID, boolean isDeletePublish) throws ThemeManagementException, AbstractQingIntegratedException {
        ThemeVO themeVO;
        List<String> publishIds;
        block9: {
            publishIds = new ArrayList<String>();
            try {
                this.tx.beginRequired();
                QingEncryptedStreamUtil.setEncryptedFlag((QingEncryptedStreamUtil.EncryptedType)QingEncryptedStreamUtil.EncryptedType.DELETE);
                themeVO = this.getThemeDao().loadThemeIncludePreset(userID, themeID);
                if (themeVO != null) {
                    if (isDeletePublish) {
                        publishIds = this.deletePublishInfos(themeID, userID);
                    }
                    this.doDelete(userID, themeVO);
                    this.getThemeDao().deleteTheme(userID, themeID);
                    break block9;
                }
                ArrayList<String> arrayList = publishIds;
                return arrayList;
            }
            catch (ThemeManagementException e) {
                this.tx.markRollback();
                throw e;
            }
            catch (AbstractQingIntegratedException e) {
                this.tx.markRollback();
                throw e;
            }
            catch (SQLException e) {
                this.tx.markRollback();
                throw new ThemeManagementException(e);
            }
            finally {
                QingEncryptedStreamUtil.clearEncryptedFlag();
                this.tx.end();
            }
        }
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(themeVO.getThemeName());
        ManageOpLog qingAnalysisGroupDir = ManageOpLog.QING_ANALYSIS_GROUP_DIR;
        qingAnalysisGroupDir.setLogScene("\u4e1a\u52a1\u4e3b\u9898");
        this.addOpLog(userID, themeVO.getThemeGroupID(), themeVO.getThemeType(), OpLogActionType.DELETE, "\u201c$param\u201d", params);
        return publishIds;
    }

    protected abstract void doDelete(String var1, ThemeVO var2) throws AbstractQingIntegratedException, ThemeManagementException;

    @Override
    public final ThemeVO copyTheme(Map<String, String> params) throws ThemeManagementException, AbstractQingIntegratedException, SubjectNotFoundException {
        ThemeVO themeVO;
        String themeID = params.get("themeID");
        String groupID = params.get("groupID");
        String userID = this.qingContext.getUserId();
        String copyName = params.get("copyName");
        try {
            themeVO = this.getThemeDao().loadThemeIncludePreset(userID, themeID);
        }
        catch (SQLException e) {
            throw new ThemeManagementException(e);
        }
        if (null == themeVO) {
            throw new ThemeNotFoundException();
        }
        ThemePO themePO = new ThemePO();
        Date createTime = new Date();
        themePO.setCreateTime(createTime);
        themePO.setUpdateTime(createTime);
        themePO.setGroupID(groupID);
        themePO.setThemeName(copyName);
        themePO.setDescription(themeVO.getDescription());
        themePO.setThemeType(themeVO.getThemeType());
        themePO.setUserID(userID);
        String newThemeId = null;
        ArrayList<IFileRollback> rollbackCollector = new ArrayList<IFileRollback>();
        try {
            this.tx.beginRequired();
            newThemeId = this.getThemeDao().saveOrUpdateTheme(themePO);
            themePO.setThemeID(newThemeId);
            themeVO.setThemeGroupID(groupID);
            themeVO.setThemeID(newThemeId);
            themeVO.setThemeName(copyName);
            this.doCopy(params, themeID, newThemeId, themePO, rollbackCollector);
        }
        catch (AbstractQingIntegratedException e) {
            for (IFileRollback rollbacker : rollbackCollector) {
                rollbacker.rollback();
            }
            this.tx.markRollback();
            throw e;
        }
        catch (ThemeManagementException e) {
            for (IFileRollback rollbacker : rollbackCollector) {
                rollbacker.rollback();
            }
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            for (IFileRollback rollbacker : rollbackCollector) {
                rollbacker.rollback();
            }
            this.tx.markRollback();
            throw new ThemeManagementException(e);
        }
        catch (SubjectNotFoundException e) {
            for (IFileRollback rollbacker : rollbackCollector) {
                rollbacker.rollback();
            }
            this.tx.markRollback();
            throw new SubjectNotFoundException(e.getMessage());
        }
        finally {
            this.tx.end();
        }
        try {
            OpLogActionType opLogActionType = OpLogActionType.NEW;
            ArrayList<String> param = new ArrayList<String>(4);
            String opLogParam = "\u201c$param\u201d";
            param.add(themePO.getThemeName());
            this.addOpLog(themePO.getUserID(), themePO.getGroupID(), themePO.getThemeType(), opLogActionType, opLogParam, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return themeVO;
    }

    protected abstract void doCopy(Map<String, String> var1, String var2, String var3, ThemePO var4, List<IFileRollback> var5) throws ThemeManagementException, AbstractQingIntegratedException, SubjectNotFoundException;

    protected boolean isFileNameAccept(String fileName) {
        String regex = "^[\\u4e00-\\u9fa5_a-z0-9]+";
        return Pattern.matches(regex, fileName);
    }

    public final String saveOrUpdateTheme(ThemePO themePO) throws ThemeManagementException, AbstractQingIntegratedException {
        boolean checkDirExist = false;
        try {
            checkDirExist = this.getThemeDao().checkDirExist(themePO.getGroupID());
        }
        catch (SQLException e) {
            throw new ThemeManagementException(e);
        }
        if (!checkDirExist) {
            throw new ThemeGroupNotFoundException();
        }
        String themeId = themePO.getThemeID();
        String oldName = null;
        try {
            ThemePO oldTheme;
            this.tx.beginRequired();
            if (themeId != null && (oldTheme = this.getThemeDao().getThemeByID(themeId)) != null) {
                oldName = oldTheme.getThemeName();
            }
            themePO.setThemeID(this.getThemeDao().saveOrUpdateTheme(themePO));
            this.doSaveOrUpdate(themePO);
        }
        catch (ThemeNameDuplicateException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new ThemeManagementException(e);
        }
        finally {
            this.tx.end();
        }
        OpLogActionType opLogActionType = themeId == null ? OpLogActionType.NEW : OpLogActionType.EDIT;
        ArrayList<String> params = new ArrayList<String>(4);
        String opLogParam = "\u201c$param\u201d";
        if (oldName != null && !oldName.equals(themePO.getThemeName())) {
            opLogParam = "\u201c$param\u201d\u540d\u79f0\u4e3a\u201c$param\u201d";
            params.add(oldName);
        }
        params.add(themePO.getThemeName());
        this.addOpLog(themePO.getUserID(), themePO.getGroupID(), themePO.getThemeType(), opLogActionType, opLogParam, params);
        themeId = themePO.getThemeID();
        return themeId;
    }

    private void addOpLog(String userId, String groupId, String themeType, OpLogActionType opLogActionType, String opLogParam, List<String> params) {
        try {
            ThemeGroupVO groupVO = this.getThemeGroupDao().loadThemeGroupByGroupId(userId, groupId);
            params.add(groupVO.getThemeGroupName());
            ManageOpLog qingAnalysisGroupDir = ManageOpLog.QING_ANALYSIS_GROUP_DIR;
            if ("0".equals(themeType)) {
                qingAnalysisGroupDir.setLogScene("\u4e1a\u52a1\u4e3b\u9898");
            } else if ("1".equals(themeType)) {
                qingAnalysisGroupDir.setLogScene("\u4eea\u8868\u677f");
            }
            qingAnalysisGroupDir.setParamsDesc(opLogParam);
            OpLogUtil.addLog((OpLogBO)new OpLogBO(opLogActionType, (IOpLogConstant)qingAnalysisGroupDir, params));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract void doSaveOrUpdate(ThemePO var1) throws SQLException, AbstractQingIntegratedException;

    public final void moveTheme(String userID, String groupID, String themeID, String themeName) throws AbstractQingIntegratedException, ThemeManagementException {
        ThemeGroupVO lastGroupVO = null;
        ThemeGroupVO currGroupVO = null;
        String themeType = "0";
        try {
            this.tx.beginRequired();
            currGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupId(userID, groupID);
            ThemePO themePO = this.getThemeDao().getThemeByID(themeID);
            if (themePO != null) {
                lastGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupId(userID, themePO.getGroupID());
                themeType = themePO.getThemeType();
            }
            this.getThemeDao().moveTheme(userID, groupID, themeID);
            this.doMove(groupID, themeID, themeName);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new ThemeManagementException(e);
        }
        finally {
            this.tx.end();
        }
        if (lastGroupVO != null && currGroupVO != null) {
            ArrayList<String> params = new ArrayList<String>(3);
            params.add(themeName);
            params.add(lastGroupVO.getThemeGroupName());
            params.add(currGroupVO.getThemeGroupName());
            ManageOpLog emptyDir = ManageOpLog.EMPTY_DIR;
            if (themeType.equals("0")) {
                emptyDir.setLogScene("\u4e1a\u52a1\u4e3b\u9898");
            } else if (themeType.equals("1")) {
                emptyDir.setLogScene("\u4eea\u8868\u677f");
            }
            emptyDir.setParamsDesc("\u201c$param\u201d\u7531\u201c$param\u201d\u5230\u201c$param\u201d");
            OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.MOVE, (IOpLogConstant)emptyDir, params));
        }
    }

    protected abstract void doMove(String var1, String var2, String var3) throws SQLException, AbstractQingIntegratedException;

    public abstract void collectExportMapModel(ThemeVO var1, List<ExportMapModel> var2, List<String> var3, boolean var4) throws AbstractQingIntegratedException, SQLException;

    public abstract void updateMapRef(Map<String, String> var1, String var2) throws AbstractQingIntegratedException, SQLException;

    private String fileXmlNameToThemeType(String fileXmlName) {
        if (fileXmlName.endsWith("qing-theme.xml")) {
            return "0";
        }
        if (fileXmlName.endsWith("qing-dsb.xml")) {
            return "1";
        }
        if (fileXmlName.endsWith("qing-programablecard.xml")) {
            return "2";
        }
        return null;
    }

    private ICollectable getCollectable(String themeType, String[] zipEntryPath) {
        if ("0".equals(themeType)) {
            return SubjectCollectorGetter.getCollector(zipEntryPath);
        }
        if ("1".equals(themeType)) {
            return DashboardCollectorGetter.getCollector(zipEntryPath);
        }
        return null;
    }

    public void collectImportModels(ZipInputStream zis, Map<String, AbstractThemeImportModel> importModelMap) throws ImportThemeException, AbstractQingIntegratedException {
        HashMap<String, String> themeGroupNameUuidMap = new HashMap<String, String>();
        HashMap<String, String> themeNameUuidMap = new HashMap<String, String>();
        ZipEntry zipEntry = null;
        String themeGroupName = null;
        String themeType = null;
        String themeName = null;
        String description = null;
        String nameSpace = null;
        AbstractThemeImportModel currentModel = null;
        String currentModelKey = null;
        try {
            while ((zipEntry = zis.getNextEntry()) != null) {
                ByteArrayInputStream byteArrayInputStream;
                ExportThemeGroupModel themeGroupProperty;
                String zipEntryName = zipEntry.getName();
                String[] zipEntryPath = ImExportDomain.parseEntryNameToList(zipEntryName);
                if (zipEntryPath == null) continue;
                if (zipEntryName.endsWith("qing-theme-group.xml") && (themeGroupProperty = ExportThemeGroupModel.parseFromZipFile(byteArrayInputStream = ImExportDomain.getInputStreamFromZipInputStream(zis))).getId() != null && themeGroupProperty.getName() != null) {
                    themeGroupNameUuidMap.put(themeGroupProperty.getId(), themeGroupProperty.getName());
                }
                if (themeGroupNameUuidMap.get(zipEntryPath[0]) != null) {
                    zipEntryPath[0] = (String)themeGroupNameUuidMap.get(zipEntryPath[0]);
                }
                themeGroupName = zipEntryPath[0];
                if (zipEntryName.endsWith("qing-theme.xml") || zipEntryName.endsWith("qing-dsb.xml")) {
                    themeType = this.fileXmlNameToThemeType(zipEntryName);
                    byteArrayInputStream = ImExportDomain.getInputStreamFromZipInputStream(zis);
                    ExportThemeModel property = ExportThemeModel.parseFromZipFile(byteArrayInputStream, zipEntryPath);
                    description = property.getDescription();
                    nameSpace = property.getNameSpace();
                    themeNameUuidMap.put(zipEntryPath[1], property.getName());
                }
                if (zipEntryPath.length >= 2) {
                    zipEntryPath[1] = themeName = (String)themeNameUuidMap.get(zipEntryPath[1]);
                } else {
                    themeName = null;
                }
                if (!StringUtils.isNotBlank((CharSequence)themeType) || !StringUtils.isNotBlank((CharSequence)themeGroupName) || !StringUtils.isNotBlank((CharSequence)themeName)) continue;
                String newModelKey = AbstractThemeImportModel.getKey(themeGroupName, themeType, themeName);
                if (!newModelKey.equals(currentModelKey) && (currentModel = importModelMap.get(currentModelKey = newModelKey)) != null) {
                    currentModel.setDescription(description);
                    currentModel.setNameSpace(nameSpace);
                }
                if (currentModel == null) continue;
                ICollectable collector = this.getCollectable(themeType, zipEntryPath);
                if (collector != null) {
                    collector.collect(zis, zipEntryPath, currentModel);
                    continue;
                }
                if (zipEntryPath.length <= 3) continue;
                Set publishTargetKeys = PublishTargetDomainFactory.getPublishTargetKey();
                for (Integer publishTargetKey : publishTargetKeys) {
                    AbstractPublishTargetImexportDomain publishTargetImexportDomain = PublishTargetImexportDomainFactory.createPublishTargetImexportDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine, publishTargetKey);
                    if (publishTargetImexportDomain == null) continue;
                    publishTargetImexportDomain.collectPublishInfo(zis, zipEntryPath, currentModel);
                }
            }
        }
        catch (ModelParseException e) {
            throw new ImportThemeException(e);
        }
        catch (IOException e) {
            throw new ImportThemeException(e);
        }
        catch (JDOMException e) {
            throw new ImportThemeException(e);
        }
    }

    public ThemeVO getPublishSourceTheme(String publishId) throws AbstractQingIntegratedException, SQLException, ThemeNotFoundException {
        ThemeVO themeVO = this.getThemeDao().getSourceThemeByPublishID(publishId);
        if (null == themeVO || null == themeVO.getThemeID()) {
            throw new ThemeNotFoundException();
        }
        return themeVO;
    }

    public ThemeVO getTimePushSourceTheme(String configID) throws AbstractQingIntegratedException, SQLException, ThemeNotFoundException {
        ThemeVO themeVO = this.getThemeDao().getSourceThemeByLappConfigID(configID);
        if (null == themeVO || null == themeVO.getThemeID()) {
            throw new ThemeNotFoundException();
        }
        return themeVO;
    }

    public ThemeVO getSourceThemeByEmailConfigID(String configID) throws AbstractQingIntegratedException, SQLException, ThemeNotFoundException {
        ThemeVO themeVO = this.getThemeDao().getSourceThemeByEmailConfigID(configID);
        if (null == themeVO || null == themeVO.getThemeID()) {
            throw new ThemeNotFoundException();
        }
        return themeVO;
    }

    public static interface IFileRollback {
        public void rollback();
    }
}

