/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.domain.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.dao.DashboardDao;
import com.kingdee.bos.qing.dashboard.dao.DashboardSerializationUtil;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.IExImportable;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.RefHandlerFactory;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.imagelibrary.domian.ImageLibraryDomain;
import com.kingdee.bos.qing.imagelibrary.exception.QingImglibException;
import com.kingdee.bos.qing.manage.domain.AbstractThemeManageDomain;
import com.kingdee.bos.qing.manage.domain.ThemeDomain;
import com.kingdee.bos.qing.manage.domain.impl.SubjectManageDomain;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.exception.ExportThemeException;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.exception.ThemeManagementException;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.DsbWidgetSchemaCollecor;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.DsbWidgetSchemaPropertyCollector;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.manage.imexport.model.po.ExportThemeModel;
import com.kingdee.bos.qing.manage.imexport.model.po.dashboard.AbstractExportRefProperty;
import com.kingdee.bos.qing.manage.imexport.model.po.dashboard.ExportDsbRefProperty;
import com.kingdee.bos.qing.manage.imexport.model.po.dashboard.ExportDsbSchemaProperty;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractThemeImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardImportModel;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.map.imexport.model.ExportMapModel;
import com.kingdee.bos.qing.map.model.MapVO;
import com.kingdee.bos.qing.publish.dao.DashboardPublishDao;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetImexportDomain;
import com.kingdee.bos.qing.publish.target.PublishTargetImexportDomainFactory;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schema.dao.ExtReportSchemaManageDao;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.subject.exception.SubjectNotFoundException;
import com.kingdee.bos.qing.util.BoxUtil;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;

public class DashboardManageDomain
extends AbstractThemeManageDomain {
    public static final String CACHED_DSBID_SUFFIX = "dsb";
    public static final String CACHED_PUBLISHID_SUFFIX = "publishDsb";
    public static final String CACHE_EXPORT_PICTURE = "cacheExportPic";
    public static final String CACHE_IMPORT_PICTURE = "cacheImportPic";
    public static final String CACHE_IMPORT_PICTURE_SUFFIX = "_dsbPicture";
    private DashboardDao dashboardDao;
    private DashboardPublishDao dashboardPublishDao;
    private CommonPublishDomain commonPublishDomain;
    private Map<RefTypeEnum, IRefHandler> refHandlerMap;
    private ImageLibraryDomain imageLibraryDomain;
    private AbstractThemeManageDomain subjectManageDomain;
    private ThemeDomain themeDomain;
    private SchemaManageDao schemaManageDao;
    private ExtReportSchemaManageDao extRptSchemaManageDao;

    public DashboardManageDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    public DashboardManageDomain() {
    }

    protected DashboardDao getDashboardDao() {
        if (this.dashboardDao == null) {
            this.dashboardDao = new DashboardDao(this.dbExcuter);
        }
        return this.dashboardDao;
    }

    private CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    private DashboardPublishDao getDashboardPublishDao() {
        if (this.dashboardPublishDao == null) {
            this.dashboardPublishDao = new DashboardPublishDao(this.dbExcuter);
        }
        return this.dashboardPublishDao;
    }

    private IRefHandler getRefHandler(RefTypeEnum refType) {
        IRefHandler refHandler;
        if (this.refHandlerMap == null) {
            this.refHandlerMap = new HashMap<RefTypeEnum, IRefHandler>();
        }
        if ((refHandler = this.refHandlerMap.get(refType)) == null) {
            refHandler = RefHandlerFactory.createHandler(refType, this.dbExcuter, this.qingContext, this.tx);
            this.refHandlerMap.put(refType, refHandler);
        }
        return refHandler;
    }

    private ImageLibraryDomain getImageLibraryDomain() {
        if (this.imageLibraryDomain == null) {
            this.imageLibraryDomain = new ImageLibraryDomain();
            this.imageLibraryDomain.setDbExcuter(this.dbExcuter);
            this.imageLibraryDomain.setTx(this.tx);
            this.imageLibraryDomain.setQingContext(this.qingContext);
        }
        return this.imageLibraryDomain;
    }

    private AbstractThemeManageDomain getSubjectManageDomain() {
        if (this.subjectManageDomain == null) {
            this.subjectManageDomain = new SubjectManageDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.subjectManageDomain;
    }

    private ThemeDomain getThemeDomain() {
        if (this.themeDomain == null) {
            this.themeDomain = new ThemeDomain(this.qingContext, this.dbExcuter);
        }
        return this.themeDomain;
    }

    private SchemaManageDao getSchemaManageDao() {
        if (this.schemaManageDao == null) {
            this.schemaManageDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaManageDao;
    }

    private ExtReportSchemaManageDao getExtRptSchemaManageDao() {
        if (this.extRptSchemaManageDao == null) {
            this.extRptSchemaManageDao = new ExtReportSchemaManageDao(this.dbExcuter);
        }
        return this.extRptSchemaManageDao;
    }

    @Override
    protected void doDelete(String userID, ThemeVO themeVO) throws AbstractQingIntegratedException, ThemeManagementException {
        try {
            String themeID = themeVO.getThemeID();
            List<ReferenceMap> refList = this.getDashboardDao().getRefList(themeID);
            for (int i = 0; i < refList.size(); ++i) {
                ReferenceMap ref = refList.get(i);
                String fId = (String)ref.get((Object)"id");
                this.getDashboardDao().deleteOuterRef(fId);
                if (!this.getExtRptSchemaManageDao().isFromExtReport(ref.getRefToId())) continue;
                String extReportSchemeId = themeID + "/" + ref.getUid();
                this.getExtRptSchemaManageDao().clearExtRptSchemaInfos(extReportSchemeId);
            }
            this.getDashboardDao().deleteDashboard(themeID);
        }
        catch (SQLException e) {
            throw new ThemeManagementException(e);
        }
    }

    @Override
    protected void doCopy(Map<String, String> params, String oldDsbId, String newDsbId, ThemePO themePO, List<AbstractThemeManageDomain.IFileRollback> rollbackCollector) throws AbstractQingIntegratedException, ThemeManagementException, SubjectNotFoundException {
        try {
            DashboardModel dashboardModel = this.getDashboardDao().loadDashboard(oldDsbId);
            InputStream dsbStream = this.getDashboardDao().loadDashboardStream(oldDsbId);
            if (dashboardModel == null) {
                return;
            }
            List<Object> refItems = new ArrayList();
            refItems = this.getDashboardDao().getRefList(oldDsbId);
            this.getDashboardDao().saveDsbContent(newDsbId, dashboardModel, dsbStream);
            HashMap<String, ThemeVO> themeVOMap = new HashMap<String, ThemeVO>();
            for (int i = 0; i < refItems.size(); ++i) {
                ReferenceMap refItem = (ReferenceMap)refItems.get(i);
                IRefHandler refHandler = this.getRefHandler(RefTypeEnum.valueOf((String)refItem.getRefType()));
                boolean copyThemes = Boolean.parseBoolean(params.get("copyThemes"));
                if (copyThemes && RefTypeEnum.subject.name().equals(refItem.getRefType())) {
                    String refToId = refItem.getRefToId();
                    if (!themeVOMap.containsKey(refToId)) {
                        String copyName = this.getCopyName(params.get("groupID"), refToId);
                        params.put("themeID", refToId);
                        params.put("copyName", copyName);
                        params.put("themeType", "0");
                        params.put("analysisCase", "true");
                        ThemeVO themeVO = this.getSubjectManageDomain().copyTheme(params);
                        themeVOMap.put(refToId, themeVO);
                    }
                    refItem.setRefToId(((ThemeVO)themeVOMap.get(refToId)).getThemeID());
                }
                refHandler.copyReference(oldDsbId, newDsbId, refItem, rollbackCollector);
            }
        }
        catch (SubjectNotFoundException e) {
            throw new SubjectNotFoundException(e.getMessage());
        }
        catch (PersistentModelParseException e) {
            throw new ThemeManagementException(e);
        }
        catch (SQLException e) {
            throw new ThemeManagementException(e);
        }
        catch (AbstractQingException e) {
            throw new ThemeManagementException(e);
        }
    }

    private String getCopyName(String groupID, String themeID) throws AbstractQingIntegratedException, SQLException, SubjectNotFoundException {
        List<ThemeVO> themeVOS = this.getThemeDomain().listUserVisibleThemes(this.qingContext.getUserId(), groupID);
        ThemePO themePO = this.getThemeDomain().getThemeByID(themeID);
        if (themePO == null) {
            throw new SubjectNotFoundException();
        }
        String themeName = themePO.getThemeName();
        String themeType = themePO.getThemeType();
        ArrayList<String> samePrefixNames = new ArrayList<String>();
        boolean duplicateNameExist = false;
        int c = themeVOS.size();
        for (int i = 0; i < c; ++i) {
            ThemeVO themeVO = themeVOS.get(i);
            String nameInCategory = themeVO.getThemeName();
            String typeInCategory = themeVO.getThemeType();
            if (themeType.equals(typeInCategory) && themeName.equals(nameInCategory)) {
                duplicateNameExist = true;
                continue;
            }
            if (!themeType.equals(typeInCategory) || nameInCategory.indexOf(themeName) != 0) continue;
            samePrefixNames.add(nameInCategory);
        }
        if (duplicateNameExist) {
            int suffixIdx = 1;
            boolean finish = false;
            while (!finish) {
                boolean flag = false;
                for (int i = 0; i < samePrefixNames.size(); ++i) {
                    String samePrefixName = (String)samePrefixNames.get(i);
                    if (!samePrefixName.equals(themeName + "-" + suffixIdx)) continue;
                    ++suffixIdx;
                    flag = true;
                    break;
                }
                finish = !flag;
            }
            themeName = themeName + "-" + suffixIdx;
        }
        return themeName;
    }

    public DashboardModel loadModel(String dsbId) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException, EncryptedLicenseCheckException {
        DashboardModel dashboardModel = this.getDashboardDao().loadDashboard(dsbId);
        if (dashboardModel != null) {
            List<ReferenceMap> refItems = this.getDashboardDao().getRefList(dsbId);
            for (int i = 0; i < refItems.size(); ++i) {
                IRefHandler refHandler;
                String widgetSourcePath;
                ReferenceMap refItem = refItems.get(i);
                String refType = refItem.getRefType();
                if (!StringUtils.isBlank((CharSequence)((CharSequence)refItem.get((Object)"widgetSourcePath"))) || (widgetSourcePath = (refHandler = this.getRefHandler(RefTypeEnum.valueOf((String)refType))).loadRefFullPath(refItem, this.qingContext.getUserId())) == null) continue;
                refItem.put((Object)"widgetSourcePath", (Object)widgetSourcePath);
            }
            dashboardModel.fixReferences(refItems);
        }
        return dashboardModel;
    }

    public List<String> getRelativeSubjectIdForExport(String dsbId) throws AbstractQingIntegratedException, SQLException {
        return this.getDashboardDao().getDsbRelativeIdForExport(dsbId, RefTypeEnum.subject.name());
    }

    @Override
    protected void doOverwrite(String themeID) throws AbstractQingIntegratedException, SQLException {
        List<ReferenceMap> refList = this.getDashboardDao().getRefList(themeID);
        for (int i = 0; i < refList.size(); ++i) {
            ReferenceMap ref = refList.get(i);
            String fId = (String)ref.get((Object)"id");
            this.getDashboardDao().deleteOuterRef(fId);
        }
        this.getDashboardDao().deleteDashboard(themeID);
    }

    @Override
    public void exportTheme(String themeGroupName, String themeGroupFolderPath, ThemeVO themeVo, boolean needPublish, ZipOutputStream zos) throws ExportThemeException, AbstractQingIntegratedException {
        try {
            String dsbName = themeVo.getThemeName();
            String dsbId = themeVo.getThemeID();
            String uuid = UUID.randomUUID().toString();
            ExportThemeModel dsbProperty = new ExportThemeModel();
            dsbProperty.setId(dsbId);
            dsbProperty.setName(dsbName);
            dsbProperty.setThemeType(themeVo.getThemeType());
            dsbProperty.setDescription(themeVo.getDescription());
            String nameSpace = themeVo.isPreset() ? NameSpace.system.toPersistance() : NameSpace.user.toPersistance();
            dsbProperty.setNameSpace(nameSpace);
            List<String> relativeTheme = this.getRelativeSubjectIdForExport(dsbId);
            dsbProperty.setRelativeTheme(relativeTheme);
            String dsbFolderPath = themeGroupFolderPath + File.separator + uuid;
            Element propertyElement = dsbProperty.toXml();
            String dsbPropertyPath = dsbFolderPath + File.separator + "qing-dsb.xml";
            zos.putNextEntry(new ZipEntry(dsbPropertyPath));
            XmlUtil.save((Element)propertyElement, (OutputStream)zos);
            DashboardModel dashboardModel = this.loadModel(dsbId);
            if (dashboardModel != null) {
                List<Map<String, String>> refInfo = this.getRefInfo(dsbId, dsbFolderPath, zos);
                ExportDsbRefProperty dsbExportProperty = new ExportDsbRefProperty();
                dsbExportProperty.setReference(refInfo);
                Element dsbPropertyElement = dsbExportProperty.toXml();
                String dsbModelPropertyPath = dsbFolderPath + File.separator + "qing-dsbmodel.xml";
                zos.putNextEntry(new ZipEntry(dsbModelPropertyPath));
                XmlUtil.save((Element)dsbPropertyElement, (OutputStream)zos);
                String dsbModelPath = dsbFolderPath + File.separator + "qing-dsb.model";
                Element dsbElement = dashboardModel.toXml();
                zos.putNextEntry(new ZipEntry(dsbModelPath));
                XmlUtil.save((Element)dsbElement, (OutputStream)zos);
                this.exportDsbRefContent(zos, refInfo, dsbFolderPath, dsbId, themeVo.isPreset());
            }
            if (needPublish) {
                String userId = this.qingContext.getUserId();
                String queryUserId = themeVo.isPreset() ? IntegratedHelper.getPresetUserId() : userId;
                List publishInfos = this.getCommonPublishDomain().loadPublishInfos(themeVo.getThemeID(), queryUserId);
                for (int i = 0; i < publishInfos.size(); ++i) {
                    PublishPO publishInfo = (PublishPO)publishInfos.get(i);
                    AbstractPublishTargetImexportDomain publishTargetImexportDomain = PublishTargetImexportDomainFactory.createPublishTargetImexportDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine, publishInfo.getPublishTargetType());
                    if (publishTargetImexportDomain == null) continue;
                    publishTargetImexportDomain.doExportPublishInfo(zos, themeGroupName, publishInfo, themeVo, dsbFolderPath);
                }
            }
            IQingSession session = QingSessionUtil.getQingSessionImpl();
            session.remove(CACHE_EXPORT_PICTURE);
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExportThemeException(e);
        }
    }

    @Override
    protected void doImport(AbstractThemeImportModel exportThemeCollectModel) throws ImportThemeException, AbstractQingIntegratedException {
        ArrayList<IQingFile> successImportFiles = new ArrayList<IQingFile>();
        try {
            String dsbId = exportThemeCollectModel.getThemeID();
            this.saveImportDsb(exportThemeCollectModel, dsbId, successImportFiles);
            this.doImportPublishInfo(exportThemeCollectModel, successImportFiles);
        }
        catch (ImportThemeException e) {
            FileFactory.clearFile(successImportFiles);
            throw e;
        }
        catch (AbstractQingIntegratedException e) {
            FileFactory.clearFile(successImportFiles);
            throw e;
        }
        catch (Exception e) {
            FileFactory.clearFile(successImportFiles);
            throw new ImportThemeException(e);
        }
    }

    private void saveImportDsb(AbstractThemeImportModel exportThemeCollectModel, String dsbId, List<IQingFile> successImportFile) throws AbstractQingIntegratedException, PersistentModelParseException, SQLException, PersistentModelTooModernException, IOException, QingImglibException, EncryptedLicenseCheckException, com.kingdee.bos.qing.core.exception.PersistentModelParseException {
        DashboardImportModel exportDashboardCollectModel = (DashboardImportModel)exportThemeCollectModel;
        byte[] dsbContent = exportDashboardCollectModel.getDsbContent();
        InputStream boxStream = BoxUtil.parseByteToInputStream(dsbContent);
        if (dsbContent != null) {
            DashboardModel dsbModel = DashboardSerializationUtil.toModel(boxStream);
            this.getDashboardDao().saveDsbContent(dsbId, dsbModel, boxStream);
            this.separateImportModel(exportDashboardCollectModel);
            Set<RefTypeEnum> refTypes = exportDashboardCollectModel.getImportRefTypes();
            for (RefTypeEnum refType : refTypes) {
                IRefHandler refHandler = this.getRefHandler(refType);
                if (!(refHandler instanceof IExImportable)) continue;
                ((IExImportable)((Object)refHandler)).importRefContent(dsbId, exportDashboardCollectModel, successImportFile);
            }
        }
    }

    private void separateImportModel(DashboardImportModel dsbImportModel) {
        RefTypeEnum typeWhenCollectProp = DsbWidgetSchemaPropertyCollector.refType;
        List<AbstractExportRefProperty> schemaPropertys = dsbImportModel.getContentProperties(typeWhenCollectProp);
        RefTypeEnum typeWhenCollectFile = DsbWidgetSchemaCollecor.refType;
        List<String> schemaFileKeys = dsbImportModel.getFileKeys(typeWhenCollectFile);
        if (schemaPropertys != null && schemaFileKeys != null) {
            for (int i = 0; i < schemaPropertys.size(); ++i) {
                ExportDsbSchemaProperty dsbSchemaProperty = (ExportDsbSchemaProperty)schemaPropertys.get(i);
                RefTypeEnum refType = RefTypeEnum.valueOf((String)dsbSchemaProperty.getRefType());
                IRefHandler refHandler = this.getRefHandler(refType);
                if (!(refHandler instanceof IExImportable)) continue;
                ((IExImportable)((Object)refHandler)).separateImportModel(dsbImportModel, dsbSchemaProperty, schemaFileKeys.get(i));
            }
        }
    }

    public void updateRef(List<ReferenceMap> refItems, String userId, boolean isPublish) throws AbstractQingIntegratedException, SQLException {
        for (int i = 0; i < refItems.size(); ++i) {
            String newRefToId;
            ReferenceMap ref = refItems.get(i);
            String fullPath = ref.getRefToFullPath();
            if (fullPath == null || "".equals(fullPath)) continue;
            int idx = fullPath.lastIndexOf("/");
            String groupName = fullPath.substring(0, idx);
            String name = fullPath.substring(idx + 1, fullPath.length());
            String refType = ref.getRefType();
            RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)refType);
            IRefHandler refHandler = this.getRefHandler(refTypeEnum);
            ISwitchPathAndIdHandler switchPathAndIdHandler = refHandler.getSwitchPathAndIdHandler();
            if (switchPathAndIdHandler == null || (newRefToId = switchPathAndIdHandler.switchRefPathToId(groupName, name, userId)) == null) continue;
            ref.setRefToId(newRefToId);
            ref.setRefToFullPath(null);
            if (isPublish) {
                this.getDashboardPublishDao().updateRef(ref);
                continue;
            }
            this.getDashboardDao().updateRef(ref);
        }
    }

    private List<Map<String, String>> getRefInfo(String dsbId, String dsbFolderPath, ZipOutputStream zos) throws AbstractQingIntegratedException, SQLException, QingImglibException, IOException {
        List<ReferenceMap> references = this.getDashboardDao().getRefList(dsbId);
        String userId = this.qingContext.getUserId();
        ArrayList<Map<String, String>> refInfo = new ArrayList<Map<String, String>>(10);
        int c = references.size();
        for (int i = 0; i < c; ++i) {
            String fullPathAfterSwitch;
            ReferenceMap refItem = references.get(i);
            HashMap<String, String> item = new HashMap<String, String>();
            String refType = refItem.getRefType();
            String refToId = refItem.getRefToId();
            String fullPath = refItem.getRefToFullPath();
            String fId = (String)refItem.get((Object)"id");
            item.put("id", fId);
            item.put("fileKey", refItem.getFileKey());
            item.put("uid", refItem.getUid());
            item.put("refType", refType);
            item.put("refToId", refItem.getRefToId());
            IRefHandler refHandler = this.getRefHandler(RefTypeEnum.valueOf((String)refType));
            ISwitchPathAndIdHandler switchPathAndIdHandler = refHandler.getSwitchPathAndIdHandler();
            if (switchPathAndIdHandler != null && (fullPathAfterSwitch = switchPathAndIdHandler.switchRefIdToPath(refToId, userId)) != null) {
                fullPath = fullPathAfterSwitch;
            }
            item.put("fullPath", fullPath);
            List<OutsideReference> outSideRefList = this.getDashboardDao().loadSchemaRef(fId);
            this.setMapFullPath(outSideRefList);
            item.put("outSideRef", JsonUtil.encodeToString(ImportUtil.createRefMap(outSideRefList)));
            refInfo.add(item);
        }
        return refInfo;
    }

    private void setMapFullPath(List<OutsideReference> outSideRefList) throws AbstractQingIntegratedException, SQLException {
        for (int j = 0; j < outSideRefList.size(); ++j) {
            OutsideReference outSideRef = outSideRefList.get(j);
            if (!StringUtils.isBlank((CharSequence)outSideRef.getRefToFullPath())) continue;
            String mapId = outSideRef.getRefToId();
            MapVO mapVO = this.getMapManageDao().getMapPath(mapId);
            String mapNameSpace = NameSpace.getNameSpace((String)mapVO.getNameSpace()).toPersistance();
            String mapPath = mapNameSpace + "/" + mapVO.getMapGroupName() + "/" + mapVO.getMapName();
            outSideRef.setRefToFullPath(mapPath);
        }
    }

    private void exportDsbRefContent(ZipOutputStream zos, List<Map<String, String>> refInfo, String dsbFolderPath, String dsbId, boolean isPreset) throws IOException, AbstractQingIntegratedException, SQLException, QingImglibException {
        for (int i = 0; i < refInfo.size(); ++i) {
            ReferenceMap referenceMap = (ReferenceMap)refInfo.get(i);
            String refType = (String)referenceMap.get((Object)"refType");
            IRefHandler refHandler = this.getRefHandler(RefTypeEnum.valueOf((String)refType));
            if (!(refHandler instanceof IExImportable)) continue;
            ((IExImportable)((Object)refHandler)).exportRefContent(dsbId, dsbFolderPath, isPreset, referenceMap, zos);
        }
    }

    @Override
    protected void doSaveOrUpdate(ThemePO themePO) throws AbstractQingIntegratedException {
    }

    @Override
    protected void doMove(String groupID, String themeID, String themeName) throws AbstractQingIntegratedException {
    }

    @Override
    public void collectExportMapModel(ThemeVO themeVo, List<ExportMapModel> exportMapModels, List<String> mapIdList, boolean withPublish) throws AbstractQingIntegratedException, SQLException {
        String userId = this.qingContext.getUserId();
        String queryUserId = themeVo.isPreset() ? IntegratedHelper.getPresetUserId() : userId;
        List<ReferenceMap> refList = this.getDashboardDao().getRefList(themeVo.getThemeID());
        for (int j = 0; j < refList.size(); ++j) {
            ReferenceMap refItem = refList.get(j);
            List<OutsideReference> outSideRefList = this.getDashboardDao().loadSchemaRef((String)refItem.get((Object)"id"));
            for (int g = 0; g < outSideRefList.size(); ++g) {
                OutsideReference outSideRef = outSideRefList.get(g);
                String mapId = outSideRef.getRefToId();
                if (mapIdList.indexOf(mapId) != -1) continue;
                ExportMapModel exportMapModel = this.getMapManageDao().loadMapWithGroupName(mapId);
                if (exportMapModel != null) {
                    exportMapModels.add(exportMapModel);
                }
                mapIdList.add(mapId);
            }
        }
        if (withPublish) {
            List publishInfos = this.getPublishInfoDao().loadPublishInfoByTagId(themeVo.getThemeID(), queryUserId);
            for (int t = 0; t < publishInfos.size(); ++t) {
                PublishPO publishPO = (PublishPO)publishInfos.get(t);
                String schemaId = publishPO.getSchemaId();
                List<OutsideReference> outSideRefList = this.getSchemaDao().loadSchemaRef(schemaId);
                for (int g = 0; g < outSideRefList.size(); ++g) {
                    OutsideReference outSideRef = outSideRefList.get(g);
                    String mapId = outSideRef.getRefToId();
                    if (mapIdList.indexOf(mapId) != -1) continue;
                    ExportMapModel exportMapModel = this.getMapManageDao().loadMapWithGroupName(mapId);
                    if (exportMapModel != null) {
                        exportMapModels.add(exportMapModel);
                    }
                    mapIdList.add(mapId);
                }
            }
        }
    }

    @Override
    public void updateMapRef(Map<String, String> importMapId, String dsbId) throws AbstractQingIntegratedException, SQLException {
        List<ReferenceMap> dsbRefs = this.getDashboardDao().getRefList(dsbId);
        String userId = this.qingContext.getUserId();
        try {
            this.tx.beginRequired();
            for (int i = 0; i < dsbRefs.size(); ++i) {
                ReferenceMap ref = dsbRefs.get(i);
                List<ReferenceMap> outSideRefList = this.getDashboardDao().getRefList((String)ref.get((Object)"id"));
                for (int j = 0; j < outSideRefList.size(); ++j) {
                    ReferenceMap outSideRef = outSideRefList.get(j);
                    String mapPath = outSideRef.getRefToFullPath();
                    String mapId = importMapId.get(mapPath);
                    if (mapId != null) {
                        this.getDashboardDao().updateOutSideRef(mapId, (String)outSideRef.get((Object)"id"));
                        continue;
                    }
                    String fullPath = outSideRef.getRefToFullPath();
                    if (StringUtils.isBlank((CharSequence)fullPath)) continue;
                    String[] path = fullPath.split("/");
                    String nameSpace = ImportUtil.getNameSpaceCode(path[0]);
                    String mapGroupName = path[1];
                    String mapName = path[2];
                    ExportMapModel exportMapModel = this.getMapManageDao().loadMapByNameAndGroupName(mapGroupName, mapName, nameSpace);
                    if (exportMapModel == null) continue;
                    mapId = exportMapModel.getMapId();
                    this.getDashboardDao().updateOutSideRef(mapId, (String)outSideRef.get((Object)"id"));
                }
            }
            List publishPOs = this.getPublishInfoDao().loadPublishInfoByTagId(dsbId, userId);
            for (int i = 0; i < publishPOs.size(); ++i) {
                PublishPO publishPO = (PublishPO)publishPOs.get(i);
                String publishId = publishPO.getId();
                List<ReferenceMap> refList = this.getDashboardPublishDao().getRefList(publishId);
                for (int j = 0; j < refList.size(); ++j) {
                    ReferenceMap ref = refList.get(j);
                    List<ReferenceMap> outSideRefList = this.getDashboardPublishDao().getRefList((String)ref.get((Object)"id"));
                    for (int k = 0; k < outSideRefList.size(); ++k) {
                        ReferenceMap outSideRef = outSideRefList.get(k);
                        String mapPath = outSideRef.getRefToFullPath();
                        String mapId = importMapId.get(mapPath);
                        if (mapId != null) {
                            this.getDashboardPublishDao().updateOutSideRef(mapId, (String)outSideRef.get((Object)"id"));
                            continue;
                        }
                        String fullPath = outSideRef.getRefToFullPath();
                        if (StringUtils.isBlank((CharSequence)fullPath)) continue;
                        String[] path = fullPath.split("/");
                        String nameSpace = ImportUtil.getNameSpaceCode(path[0]);
                        String mapGroupName = path[1];
                        String mapName = path[2];
                        ExportMapModel exportMapModel = this.getMapManageDao().loadMapByNameAndGroupName(mapGroupName, mapName, nameSpace);
                        if (exportMapModel == null) continue;
                        mapId = exportMapModel.getMapId();
                        this.getDashboardPublishDao().updateOutSideRef(mapId, (String)outSideRef.get((Object)"id"));
                    }
                }
            }
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }
}

