/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.domain.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.manage.domain.AbstractThemeManageDomain;
import com.kingdee.bos.qing.manage.domain.impl.DashboardManageDomain;
import com.kingdee.bos.qing.manage.domain.impl.SubjectManageDomain;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class ThemeMangeDomainFactory {
    private static Map<String, Class<? extends AbstractThemeManageDomain>> map = new HashMap<String, Class<? extends AbstractThemeManageDomain>>();

    public static void register(String themeType, Class<? extends AbstractThemeManageDomain> clazz) {
        if (map.get(themeType) == null) {
            map.put(themeType, clazz);
        }
    }

    public static AbstractThemeManageDomain create(String themeType, QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        Class<? extends AbstractThemeManageDomain> clazz = map.get(themeType);
        if (clazz == null) {
            return null;
        }
        try {
            Constructor<? extends AbstractThemeManageDomain> constructor = clazz.getDeclaredConstructor(QingContext.class, ITransactionManagement.class, IDBExcuter.class, IScheduleEngine.class);
            AbstractThemeManageDomain instance = constructor.newInstance(qingContext, tx, dbExcuter, scheduleEngine);
            return instance;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        map.put("0", SubjectManageDomain.class);
        map.put("1", DashboardManageDomain.class);
    }
}

