/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.handler;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.manage.handler.ISubjectManageHandler;
import com.kingdee.bos.qing.manage.handler.convertQSHandler.ConvertQSFileHandler;
import java.util.ArrayList;
import java.util.List;

public class SubjectManageHandlers
implements ISubjectManageHandler {
    List<ISubjectManageHandler> handlers = new ArrayList<ISubjectManageHandler>();

    public void init(ITransactionManagement tx, IDBExcuter dbExcuter, QingContext qingContext) {
        this.register(new ConvertQSFileHandler(qingContext));
    }

    public void register(ISubjectManageHandler subjectManageHandler) {
        if (this.handlers != null) {
            this.handlers.add(subjectManageHandler);
        }
    }

    private List<ISubjectManageHandler> getHandlers() {
        return this.handlers;
    }

    @Override
    public void handleAfterSaveModel(String themeId, Box boxModel, Box originalBoxModel) {
        List<ISubjectManageHandler> handlers = this.getHandlers();
        for (ISubjectManageHandler subjectManageHandler : handlers) {
            subjectManageHandler.handleAfterSaveModel(themeId, boxModel, originalBoxModel);
        }
    }

    @Override
    public void handleAfterDeleteTheme(Box box, String themeId) {
        List<ISubjectManageHandler> handlers = this.getHandlers();
        for (ISubjectManageHandler subjectManageHandler : handlers) {
            subjectManageHandler.handleAfterDeleteTheme(box, themeId);
        }
    }
}

