/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.handler.convertQSHandler.task;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.ICustomDBStrategy;
import com.kingdee.bos.qing.common.strategy.TXDBExcuter;
import com.kingdee.bos.qing.manage.handler.convertQSHandler.domain.ConvertQSHandleDomain;
import com.kingdee.bos.qing.manage.handler.convertQSHandler.model.ConvertQSEntityInfo;
import com.kingdee.bos.qing.manage.handler.convertQSHandler.model.ConvertStateEnum;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.concurrent.Callable;

public class ConvertQSFileTask
implements Callable<Boolean> {
    private ConvertQSEntityInfo convertQSEntityInfo;
    private QingContext qingContext;

    public ConvertQSFileTask(ConvertQSEntityInfo convertQSEntityInfo, QingContext qingContext) {
        this.convertQSEntityInfo = convertQSEntityInfo;
        this.qingContext = qingContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean call() {
        if (this.convertQSEntityInfo == null) return Boolean.TRUE;
        QingContext.setCurrent((QingContext)this.qingContext);
        ICustomDBStrategy customDbService = (ICustomDBStrategy)CustomStrategyRegistrar.getStrategy(ICustomDBStrategy.class);
        TXDBExcuter tXDBExcuter = customDbService.getTXAndDBExecutor(this.qingContext);
        ConvertQSHandleDomain convertQSHandleDomain = new ConvertQSHandleDomain(tXDBExcuter.getDbExcuter(), tXDBExcuter.getTx(), this.qingContext);
        String entityUniqueCacheKey = convertQSHandleDomain.createEntityUniqueCacheKey(this.convertQSEntityInfo.getFileUrl(), this.convertQSEntityInfo.getEntityName());
        ILock lock = LockFactory.createLock((String)entityUniqueCacheKey);
        try {
            lock.lock();
            ConvertStateEnum convertState = this.convertQSEntityInfo.getConvertState();
            switch (convertState) {
                case ADD: {
                    convertQSHandleDomain.createQSFile(this.convertQSEntityInfo);
                    return Boolean.TRUE;
                }
                case DELETE: {
                    convertQSHandleDomain.deleteQSFile(this.convertQSEntityInfo);
                    return Boolean.TRUE;
                }
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LogUtil.error((String)"convert qs file task execute error", (Throwable)e);
            return Boolean.TRUE;
        }
        finally {
            lock.unlock();
        }
    }
}

