/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.imexport.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileWriter;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingAppLocalTempFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingEncryptedStreamUtil;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.filesystem.stream.QingOutputStream;
import com.kingdee.bos.qing.imexport.importer.pkg.domain.ImportPKGDomain;
import com.kingdee.bos.qing.manage.domain.AbstractThemeManageDomain;
import com.kingdee.bos.qing.manage.domain.ThemeDomain;
import com.kingdee.bos.qing.manage.domain.ThemeGroupDomain;
import com.kingdee.bos.qing.manage.domain.ThemeSysPkgStateDomain;
import com.kingdee.bos.qing.manage.domain.impl.DashboardManageDomain;
import com.kingdee.bos.qing.manage.domain.impl.ThemeMangeDomainFactory;
import com.kingdee.bos.qing.manage.exception.ExportThemeException;
import com.kingdee.bos.qing.manage.exception.ImportThemeFileParseException;
import com.kingdee.bos.qing.manage.exception.ThemeManagementException;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.manage.imexport.model.po.ExportThemeGroupModel;
import com.kingdee.bos.qing.manage.imexport.model.po.ExportThemeModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractThemeImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.ProgramableCardImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.SubjectImportModel;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportPublishConflictVO;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportThemeVO;
import com.kingdee.bos.qing.manage.model.FolderNode;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemeSysPkgStatePO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.map.exception.MapException;
import com.kingdee.bos.qing.map.imexport.MapImExportDomain;
import com.kingdee.bos.qing.map.imexport.exception.ImExportException;
import com.kingdee.bos.qing.map.imexport.model.ExportMapModel;
import com.kingdee.bos.qing.publish.dao.DashboardPublishDao;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.NameUtil;
import com.kingdee.bos.qing.util.PresetUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ImExportDomain {
    private QingContext qingContext;
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    private IScheduleEngine scheduleEngine;
    private ThemeGroupDomain themeGroupDomain;
    private ThemeDomain themeDomain;
    private ImportPKGDomain importPKGDomain;
    private DashboardPublishDao dashboardPublishDao;
    private Map<String, AbstractThemeManageDomain> manageDomainMap;
    private SchemaManageDao schemaDao;
    private MapImExportDomain mapImExportDomain;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public IDBExcuter getDbExcuter() {
        return this.dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setScheduleEngine(IScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    private ThemeGroupDomain getThemeGroupDomain() {
        if (this.themeGroupDomain == null) {
            this.themeGroupDomain = new ThemeGroupDomain();
            this.themeGroupDomain.setDbExcuter(this.dbExcuter);
            this.themeGroupDomain.setQingContext(this.qingContext);
            this.themeGroupDomain.setTx(this.tx);
        }
        return this.themeGroupDomain;
    }

    private ThemeDomain getThemeDomain() {
        if (this.themeDomain == null) {
            this.themeDomain = new ThemeDomain(this.qingContext, this.dbExcuter);
        }
        return this.themeDomain;
    }

    protected SchemaManageDao getSchemaDao() {
        if (this.schemaDao == null) {
            this.schemaDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaDao;
    }

    private MapImExportDomain getMapImExportDomain() {
        if (this.mapImExportDomain == null) {
            this.mapImExportDomain = new MapImExportDomain();
            this.mapImExportDomain.setDbExcuter(this.dbExcuter);
            this.mapImExportDomain.setQingContext(this.qingContext);
            this.mapImExportDomain.setTx(this.tx);
        }
        return this.mapImExportDomain;
    }

    private AbstractThemeManageDomain getThemeManageDomain(ThemeVO themeVO) {
        String themeType = themeVO.getThemeType();
        return this.getThemeManageDomain(themeType);
    }

    private AbstractThemeManageDomain getThemeManageDomain(String themeType) {
        AbstractThemeManageDomain manageDomain;
        if (this.manageDomainMap == null) {
            this.manageDomainMap = new HashMap<String, AbstractThemeManageDomain>();
        }
        if ((manageDomain = this.manageDomainMap.get(themeType)) == null) {
            manageDomain = ThemeMangeDomainFactory.create(themeType, this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
            this.manageDomainMap.put(themeType, manageDomain);
        }
        return manageDomain;
    }

    private DashboardPublishDao getDashboardPublishDao() {
        if (this.dashboardPublishDao == null) {
            this.dashboardPublishDao = new DashboardPublishDao(this.dbExcuter);
        }
        return this.dashboardPublishDao;
    }

    private ImportPKGDomain getImportPKGDomain() {
        if (this.importPKGDomain == null) {
            this.importPKGDomain = new ImportPKGDomain();
            this.importPKGDomain.setDbExcuter(this.dbExcuter);
            this.importPKGDomain.setQingContext(this.qingContext);
            this.importPKGDomain.setScheduleEngine(this.scheduleEngine);
            this.importPKGDomain.setTx(this.tx);
        }
        return this.importPKGDomain;
    }

    public final FolderNode getExportThemeFolder(String userID) throws AbstractQingIntegratedException, ExportThemeException {
        FolderNode root = new FolderNode();
        try {
            List<ThemeGroupVO> themeGroupList = this.getThemeGroupDomain().getThemeGroups();
            for (int i = 0; i <= themeGroupList.size() - 1; ++i) {
                ThemeGroupVO themeGroupVO = themeGroupList.get(i);
                List<ThemeVO> themeVOList = this.getThemeDomain().listThemes(userID, themeGroupVO.getThemeGroupID());
                if (themeVOList.size() <= 0) continue;
                FolderNode themeGroupNode = new FolderNode();
                themeGroupNode.setName(themeGroupVO.getThemeGroupName());
                themeGroupNode.setThemeId(themeGroupVO.getThemeGroupID());
                themeGroupNode.setPreset(themeGroupVO.isPreset());
                root.addChild(themeGroupNode);
                for (int j = 0; j < themeVOList.size(); ++j) {
                    ThemeVO themeVO = themeVOList.get(j);
                    String themeType = themeVO.getThemeType();
                    String themeId = themeVO.getThemeID();
                    FolderNode themeNode = new FolderNode();
                    themeNode.setName(themeVO.getThemeName());
                    themeNode.setThemeId(themeId);
                    themeNode.setThemeType(themeType);
                    themeNode.setPreset(themeVO.isPreset());
                    themeGroupNode.addChild(themeNode);
                    if (!"1".equals(themeVO.getThemeType())) continue;
                    List<String> relativeTheme = ((DashboardManageDomain)this.getThemeManageDomain(themeType)).getRelativeSubjectIdForExport(themeId);
                    List<String> publishRelativeTheme = this.getDashboardPublishDao().getDsbRelativeIdForExport(themeId);
                    relativeTheme.removeAll(publishRelativeTheme);
                    relativeTheme.addAll(publishRelativeTheme);
                    themeNode.setRelativeTheme(relativeTheme);
                }
            }
        }
        catch (SQLException e) {
            throw new ExportThemeException(e);
        }
        return root;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void compressZipFile(String userID, List<ExportThemeVO> themeList, boolean needPublish, IQingFile zipFile) throws AbstractQingIntegratedException, ExportThemeException {
        IQingFileWriter zipFileWriter = null;
        QingOutputStream fos = null;
        ZipOutputStream zos = null;
        Throwable exception = null;
        HashMap<String, String> themeGroupFloderMap = new HashMap<String, String>();
        try {
            zipFileWriter = zipFile.createWriter();
            fos = zipFileWriter.getOutputStream();
            zos = new ZipOutputStream((OutputStream)fos);
            this.compressMap(themeList, needPublish, zos);
            for (int i = 0; i < themeList.size(); ++i) {
                String themeGroupFolderPath;
                ExportThemeVO exportTheme = themeList.get(i);
                String themeGroupName = exportTheme.getThemeGroupName();
                String themeId = exportTheme.getThemeID();
                ThemeVO themeVo = this.getThemeDomain().loadThemeIncludePreset(userID, themeId);
                if (themeGroupFloderMap.get(themeGroupName) == null && !NameUtil.isFileNameAccept((String)themeGroupName) || themeVo.isPreset()) {
                    String etgFolderUuid = UUID.randomUUID().toString();
                    String etgPropertyPath = etgFolderUuid + File.separator + "qing-theme-group.xml";
                    ExportThemeGroupModel themeGroupModel = new ExportThemeGroupModel();
                    themeGroupModel.setId(etgFolderUuid);
                    themeGroupModel.setName(themeGroupName);
                    Element propertyElement = themeGroupModel.toXml();
                    themeGroupFloderMap.put(themeGroupName, etgFolderUuid);
                    zos.putNextEntry(new ZipEntry(etgPropertyPath));
                    XmlUtil.save((Element)propertyElement, (OutputStream)zos);
                    zos.flush();
                }
                if ((themeGroupFolderPath = (String)themeGroupFloderMap.get(themeGroupName)) == null) {
                    themeGroupFolderPath = themeGroupName;
                }
                AbstractThemeManageDomain themeManageDomain = this.getThemeManageDomain(themeVo);
                themeManageDomain.exportTheme(themeGroupName, themeGroupFolderPath, themeVo, needPublish, zos);
            }
        }
        catch (AbstractQingIntegratedException e) {
            try {
                exception = e;
                throw e;
                catch (Exception e2) {
                    exception = e2;
                    throw new ExportThemeException(e2);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{zos});
                if (zipFileWriter != null) {
                    zipFileWriter.close((Exception)exception);
                    zipFileWriter = null;
                }
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{zos});
        if (zipFileWriter != null) {
            zipFileWriter.close((Exception)exception);
            return;
        }
    }

    public void compressMap(List<ExportThemeVO> themeList, boolean withPublish, ZipOutputStream zos) throws AbstractQingIntegratedException, SQLException, IOException, MapException {
        ArrayList<String> mapIdList = new ArrayList<String>();
        ArrayList<ExportMapModel> exportMapModels = new ArrayList<ExportMapModel>();
        for (int i = 0; i < themeList.size(); ++i) {
            ExportThemeVO exportTheme = themeList.get(i);
            String themeId = exportTheme.getThemeID();
            String userId = this.qingContext.getUserId();
            ThemeVO themeVo = this.getThemeDomain().loadThemeIncludePreset(userId, themeId);
            if (themeVo == null) continue;
            AbstractThemeManageDomain themeManageDomain = this.getThemeManageDomain(themeVo);
            themeManageDomain.collectExportMapModel(themeVo, exportMapModels, mapIdList, withPublish);
        }
        String mapRootFloder = UUID.randomUUID().toString() + "_map";
        this.getMapImExportDomain().compressMapZipFile(exportMapModels, mapRootFloder, zos);
    }

    public FolderNode parseThemeZipFile(String fileName) throws ImportThemeFileParseException {
        IQingFileVisitor zipFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)fileName);
        HashMap<String, String> themeGroupUuidMap = new HashMap<String, String>();
        FolderNode root = new FolderNode();
        QingInputStream in = null;
        ZipInputStream zis = null;
        try {
            in = zipFile.getInputStream();
            zis = new ZipInputStream((InputStream)in);
            ZipEntry zipEntry = null;
            while ((zipEntry = zis.getNextEntry()) != null) {
                ByteArrayInputStream byteArrayInputStream;
                ExportThemeGroupModel themeGroupProperty;
                String zipEntryName = zipEntry.getName();
                String[] zipEntryPath = ImExportDomain.parseEntryNameToList(zipEntryName);
                if (zipEntryName.endsWith("qing-theme-group.xml") && (themeGroupProperty = ExportThemeGroupModel.parseFromZipFile(byteArrayInputStream = ImExportDomain.getInputStreamFromZipInputStream(zis))).getId() != null && themeGroupProperty.getName() != null) {
                    themeGroupUuidMap.put(themeGroupProperty.getId(), themeGroupProperty.getName());
                }
                if (!zipEntryName.endsWith("qing-theme.xml") && !zipEntryName.endsWith("qing-dsb.xml") && !zipEntryName.endsWith("qing-programablecard.xml")) continue;
                byteArrayInputStream = ImExportDomain.getInputStreamFromZipInputStream(zis);
                ExportThemeModel themeProperty = ExportThemeModel.parseFromZipFile(byteArrayInputStream, zipEntryPath);
                if (zipEntryPath != null && themeGroupUuidMap.get(zipEntryPath[0]) != null) {
                    zipEntryPath[0] = (String)themeGroupUuidMap.get(zipEntryPath[0]);
                }
                String themeGroupName = null;
                if (zipEntryPath != null) {
                    themeGroupName = zipEntryPath[0];
                }
                this.addThemeFloderNode(root, themeProperty, themeGroupName);
            }
        }
        catch (Exception e) {
            try {
                throw new ImportThemeFileParseException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{zis});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{zis});
        return root;
    }

    private void addThemeFloderNode(FolderNode root, ExportThemeModel themeProperty, String themeGroupName) throws AbstractQingIntegratedException, SQLException {
        FolderNode themeGroupFolderNode = null;
        themeGroupFolderNode = new FolderNode();
        themeGroupFolderNode.setName(themeGroupName);
        if (root.getChildCount() == 0 || !root.containChild(themeGroupFolderNode)) {
            String themeGroupId = this.getThemeGroupId(themeGroupName);
            themeGroupFolderNode.setThemeId(themeGroupId);
            root.addChild(themeGroupFolderNode);
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                FolderNode child = root.getChildren().get(i);
                if (!child.getName().equals(themeGroupName)) continue;
                themeGroupFolderNode = child;
                break;
            }
        }
        FolderNode themeFolderNode = new FolderNode();
        themeFolderNode.setName(themeProperty.getName());
        themeFolderNode.setThemeId(themeProperty.getId());
        themeFolderNode.setThemeType(themeProperty.getThemeType());
        themeFolderNode.setRelativeTheme(themeProperty.getRelativeTheme());
        themeGroupFolderNode.addChild(themeFolderNode);
    }

    private String getThemeGroupId(String themeGroupName) throws AbstractQingIntegratedException, SQLException {
        String userId = this.qingContext.getUserId();
        ThemeGroupVO themeGroupVO = this.getThemeGroupDomain().loadThemeGroupByGroupName(userId, themeGroupName);
        String themeGroupId = null;
        themeGroupId = themeGroupVO != null ? themeGroupVO.getThemeGroupID() : UUID.randomUUID().toString();
        return themeGroupId;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> importSelectedTheme(IQingFileVisitor zipFile, List<ExportThemeVO> selectedImportThemeList, String sourceStrategy, boolean firstTimeImport, String cacheImportMapIdKey) throws AbstractQingException {
        ArrayList<ExportThemeVO> conflictExportThemeList = new ArrayList<ExportThemeVO>();
        ArrayList<ExportPublishConflictVO> confilctPublishList = new ArrayList<ExportPublishConflictVO>();
        HashMap<String, String> saveSuccessThemeIdAndType = new HashMap<String, String>();
        ArrayList<String> saveSuccessThemeGroupIDList = new ArrayList<String>();
        HashMap<String, List<String>> cacheDsbIdAndUid = new HashMap<String, List<String>>();
        HashSet<String> mapPaths = new HashSet<String>();
        HashMap<String, String> importSubjectPathAndId = new HashMap<String, String>();
        HashMap<String, String> importCardPathAndId = new HashMap<String, String>();
        HashMap<String, String> importAppmenuPathAndId = new HashMap<String, String>();
        HashMap<String, String> importQingCenterPathAndId = new HashMap<String, String>();
        HashMap<String, Object> result = new HashMap<String, Object>();
        String cacheMapKey = null;
        ZipInputStream zis = null;
        try {
            AbstractThemeImportModel importModel;
            AbstractThemeImportModel abstractThemeImportModel;
            if (selectedImportThemeList == null) {
                selectedImportThemeList = this.parseAllThemeZipFileToList(zipFile);
            } else if (firstTimeImport) {
                this.checkSelectedImportTheme(selectedImportThemeList, conflictExportThemeList);
            }
            QingInputStream in = zipFile.getInputStream();
            zis = new ZipInputStream((InputStream)in);
            Map<String, AbstractThemeImportModel> importModelMap = this.toMap(selectedImportThemeList);
            this.getThemeManageDomain("0").collectImportModels(zis, importModelMap);
            for (Map.Entry<String, AbstractThemeImportModel> entry : importModelMap.entrySet()) {
                abstractThemeImportModel = importModelMap.get(entry.getKey());
                if (!"0".equals(abstractThemeImportModel.getThemeType())) continue;
                importModel = (SubjectImportModel)abstractThemeImportModel;
                importModel.setMapPath(mapPaths);
                importModel.setZipFile(zipFile);
                importModel.setSourceStrategy(sourceStrategy);
                importModel.setSaveSuccessThemeGroupIDList(saveSuccessThemeGroupIDList);
                importModel.setConflictExportThemeList(conflictExportThemeList);
                importModel.setConfilctPublishList(confilctPublishList);
                importModel.setImportSubjectPathAndId(importSubjectPathAndId);
                importModel.setImportCardPathAndId(importCardPathAndId);
                importModel.setImportQingCenterPathAndId(importQingCenterPathAndId);
                importModel.setImportAppmenuPathAndId(importAppmenuPathAndId);
                this.getThemeManageDomain(importModel.getThemeType()).doImportTheme(importModel);
                if (importModel.getThemeID() == null) {
                    conflictExportThemeList.add(importModel.toExportThemeVO());
                    continue;
                }
                saveSuccessThemeIdAndType.put(importModel.getThemeID(), importModel.getThemeType());
            }
            for (Map.Entry<String, AbstractThemeImportModel> entry : importModelMap.entrySet()) {
                abstractThemeImportModel = importModelMap.get(entry.getKey());
                if (!"1".equals(abstractThemeImportModel.getThemeType())) continue;
                importModel = (DashboardImportModel)abstractThemeImportModel;
                importModel.setMapPath(mapPaths);
                importModel.setZipFile(zipFile);
                importModel.setSourceStrategy(sourceStrategy);
                importModel.setSaveSuccessThemeGroupIDList(saveSuccessThemeGroupIDList);
                importModel.setConflictExportThemeList(conflictExportThemeList);
                importModel.setConfilctPublishList(confilctPublishList);
                importModel.setImportSubjectPathAndId(importSubjectPathAndId);
                importModel.setImportCardPathAndId(importCardPathAndId);
                importModel.setImportQingCenterPathAndId(importQingCenterPathAndId);
                importModel.setImportAppmenuPathAndId(importAppmenuPathAndId);
                ((DashboardImportModel)importModel).setCacheDsbIdAndUid(cacheDsbIdAndUid);
                this.getThemeManageDomain(importModel.getThemeType()).doImportTheme(importModel);
                if (importModel.getThemeID() == null) {
                    conflictExportThemeList.add(importModel.toExportThemeVO());
                    continue;
                }
                saveSuccessThemeIdAndType.put(importModel.getThemeID(), importModel.getThemeType());
            }
            for (Map.Entry<String, AbstractThemeImportModel> entry : importModelMap.entrySet()) {
                AbstractThemeManageDomain manageDomain;
                abstractThemeImportModel = importModelMap.get(entry.getKey());
                if (!"2".equals(abstractThemeImportModel.getThemeType()) || (manageDomain = this.getThemeManageDomain(abstractThemeImportModel.getThemeType())) == null) continue;
                ProgramableCardImportModel programableCardImportModel = (ProgramableCardImportModel)abstractThemeImportModel;
                programableCardImportModel.setZipFile(zipFile);
                programableCardImportModel.setSaveSuccessThemeGroupIDList(saveSuccessThemeGroupIDList);
                manageDomain.doImportTheme(programableCardImportModel);
                if (programableCardImportModel.getThemeID() == null) {
                    conflictExportThemeList.add(abstractThemeImportModel.toExportThemeVO());
                    continue;
                }
                saveSuccessThemeIdAndType.put(programableCardImportModel.getThemeID(), programableCardImportModel.getThemeType());
            }
            cacheMapKey = this.importMap(sourceStrategy, mapPaths, zipFile, firstTimeImport, conflictExportThemeList, cacheImportMapIdKey, saveSuccessThemeIdAndType);
        }
        catch (AbstractQingException e) {
            try {
                this.deleteThemeAndGroupList(saveSuccessThemeIdAndType, saveSuccessThemeGroupIDList);
                throw e;
                catch (Exception e2) {
                    this.deleteThemeAndGroupList(saveSuccessThemeIdAndType, saveSuccessThemeGroupIDList);
                    throw new ImportThemeFileParseException(e2);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{zis});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{zis});
        if ((conflictExportThemeList.size() > 0 || confilctPublishList.size() > 0) && cacheDsbIdAndUid.size() > 0) {
            IQingSession session = QingSessionUtil.getQingSessionImpl();
            session.set(zipFile.getName(), JsonUtil.encodeToString(cacheDsbIdAndUid));
        }
        result.put("cacheIdKey", cacheMapKey);
        result.put("conflictTheme", conflictExportThemeList);
        result.put("conflictPublish", confilctPublishList);
        return result;
    }

    private String importMap(String sourceStrategy, Set<String> mapPaths, IQingFileVisitor zipFile, boolean firstTimeImport, List<ExportThemeVO> conflictExportThemeList, String cacheImportMapIdKey, Map<String, String> saveSuccessThemeIdAndType) throws ModelParseException, ImExportException, MapException, AbstractQingIntegratedException, IOException, JDOMException, SQLException {
        if (ExportThemeVO.StrategyType.ignore != ExportThemeVO.StrategyType.valueOf(sourceStrategy)) {
            HashMap<String, String> importMapId = new HashMap();
            Map<String, String> cacheImportMapId = new HashMap<String, String>();
            String cacheMapKey = UUID.randomUUID().toString();
            if (firstTimeImport) {
                List<ExportMapModel> importMapModelList = this.createImportMapParam(mapPaths, sourceStrategy, cacheImportMapId);
                importMapId = this.getMapImExportDomain().importMapForThemeImport(zipFile, importMapModelList);
                if (conflictExportThemeList.size() > 0 && importMapId.size() > 0) {
                    IQingSession session = QingSessionUtil.getQingSessionImpl();
                    session.set(cacheMapKey, JsonUtil.encodeToString(importMapId));
                }
            } else {
                IQingSession session = QingSessionUtil.getQingSessionImpl();
                if (cacheImportMapIdKey != null && session.get(cacheImportMapIdKey) != null) {
                    cacheImportMapId = (Map)JsonUtil.decodeFromString((String)session.get(cacheImportMapIdKey), Map.class);
                }
                List<ExportMapModel> importMapModelList = this.createImportMapParam(mapPaths, sourceStrategy, cacheImportMapId);
                importMapId = this.getMapImExportDomain().importMapForThemeImport(zipFile, importMapModelList);
                if (cacheImportMapId != null) {
                    importMapId.putAll(cacheImportMapId);
                }
            }
            this.updateRefMapInfo(importMapId, saveSuccessThemeIdAndType);
            return cacheMapKey;
        }
        return null;
    }

    private void checkSelectedImportTheme(List<ExportThemeVO> importTheme, List<ExportThemeVO> conflictTheme) throws AbstractQingIntegratedException, SQLException {
        String userId = this.qingContext.getUserId();
        for (int i = 0; i < importTheme.size(); ++i) {
            ExportThemeVO exportThemeVO = importTheme.get(i);
            String themeGroupName = exportThemeVO.getThemeGroupName();
            String themeName = exportThemeVO.getThemeName();
            String themeType = exportThemeVO.getThemeType();
            ThemeVO themeVO = this.getThemeDomain().loadThemeByNameAndGroupNameAndType(userId, themeGroupName, themeName, themeType);
            if (themeVO == null) continue;
            importTheme.remove(i);
            conflictTheme.add(exportThemeVO);
        }
    }

    private Map<String, AbstractThemeImportModel> toMap(List<ExportThemeVO> importList) {
        HashMap<String, AbstractThemeImportModel> map = new HashMap<String, AbstractThemeImportModel>(16);
        for (int i = 0; i < importList.size(); ++i) {
            ExportThemeVO selectedImportVO = importList.get(i);
            AbstractThemeImportModel abstractThemeImportModel = selectedImportVO.toImportModel();
            map.put(abstractThemeImportModel.getKey(), abstractThemeImportModel);
        }
        return map;
    }

    private List<ExportMapModel> createImportMapParam(Set<String> mapPaths, String sourceStrategy, Map<String, String> cacheImportMapId) {
        ArrayList<ExportMapModel> exportMapModelList = new ArrayList<ExportMapModel>(10);
        for (String fullPath : mapPaths) {
            if (cacheImportMapId.containsKey(fullPath)) continue;
            String[] path = fullPath.split("/");
            ExportMapModel exportMapModel = new ExportMapModel();
            exportMapModel.setNameSpace(ImportUtil.getNameSpaceCode(path[0]));
            exportMapModel.setMapGroupName(path[1]);
            exportMapModel.setMapName(path[2]);
            exportMapModel.setStrategy(sourceStrategy);
            exportMapModelList.add(exportMapModel);
        }
        return exportMapModelList;
    }

    private void updateRefMapInfo(Map<String, String> importMapId, Map<String, String> saveSuccessThemeIdAndType) throws AbstractQingIntegratedException, SQLException {
        for (Map.Entry<String, String> entry : saveSuccessThemeIdAndType.entrySet()) {
            String themeType = saveSuccessThemeIdAndType.get(entry.getKey());
            this.getThemeManageDomain(themeType).updateMapRef(importMapId, entry.getKey());
        }
    }

    private void deleteThemeAndGroupList(Map<String, String> saveSuccessThemeIdAndType, List<String> themeGroupIDList) throws ThemeManagementException, AbstractQingIntegratedException {
        String userID = this.qingContext.getUserId();
        for (String themeId : saveSuccessThemeIdAndType.keySet()) {
            this.getThemeManageDomain("0").deleteTheme(userID, themeId, true);
        }
        if (themeGroupIDList != null) {
            for (int i = 0; i < themeGroupIDList.size(); ++i) {
                this.getThemeGroupDomain().deleteThemeGroup(userID, themeGroupIDList.get(i));
            }
        }
    }

    private List<ExportThemeVO> parseAllThemeZipFileToList(IQingFileVisitor zipFile) throws ImportThemeFileParseException {
        ArrayList<ExportThemeVO> allExportTheme = new ArrayList<ExportThemeVO>();
        HashMap<String, String> themeGroupNameUuidMap = new HashMap<String, String>();
        QingInputStream in = null;
        ZipInputStream zis = null;
        try {
            in = zipFile.getInputStream();
            zis = new ZipInputStream((InputStream)in);
            ZipEntry zipEntry = null;
            while ((zipEntry = zis.getNextEntry()) != null) {
                ByteArrayInputStream byteArrayInputStream;
                String zipEntryName = zipEntry.getName();
                String[] zipEntryPath = ImExportDomain.parseEntryNameToList(zipEntryName);
                if (zipEntryName.endsWith("qing-theme-group.xml")) {
                    byteArrayInputStream = ImExportDomain.getInputStreamFromZipInputStream(zis);
                    ExportThemeGroupModel themeGroupProperty = ExportThemeGroupModel.parseFromZipFile(byteArrayInputStream);
                    if (themeGroupProperty.getId() == null || themeGroupProperty.getName() == null) continue;
                    themeGroupNameUuidMap.put(themeGroupProperty.getId(), themeGroupProperty.getName());
                    continue;
                }
                if (!zipEntryName.endsWith("qing-theme.xml") && !zipEntryName.endsWith("qing-dsb.xml") && !zipEntryName.endsWith("qing-programablecard.xml")) continue;
                byteArrayInputStream = ImExportDomain.getInputStreamFromZipInputStream(zis);
                ExportThemeModel themeProperty = ExportThemeModel.parseFromZipFile(byteArrayInputStream, zipEntryPath);
                if (zipEntryPath != null && themeGroupNameUuidMap.get(zipEntryPath[0]) != null) {
                    zipEntryPath[0] = (String)themeGroupNameUuidMap.get(zipEntryPath[0]);
                }
                String themeGroupName = null;
                if (zipEntryPath != null) {
                    themeGroupName = zipEntryPath[0];
                }
                ExportThemeVO exportTheme = themeProperty.toExportTheme();
                exportTheme.setThemeGroupName(themeGroupName);
                exportTheme.setStrategy(ExportThemeVO.StrategyType.overwrite.toPersistance());
                exportTheme.setPublishStrategy(ExportThemeVO.PublishConflictStrategy.overwrite.name());
                allExportTheme.add(exportTheme);
            }
        }
        catch (Exception e) {
            try {
                throw new ImportThemeFileParseException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{zis});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{zis});
        return allExportTheme;
    }

    public void importThemeSysPkg(String userID) throws IOException, SQLException, AbstractQingException {
        ZipInputStream zis;
        InputStream fileIn;
        InputStream in;
        boolean succeed;
        ILock transactionLock;
        block14: {
            Properties properties;
            IQingFile qingZipFile;
            block13: {
                transactionLock = LockFactory.createLock((String)("QingTransactionLockImportThemeSysPkg" + this.qingContext.getUserId()));
                succeed = false;
                qingZipFile = null;
                in = null;
                fileIn = null;
                zis = null;
                succeed = transactionLock.tryLock(1800000L);
                if (!succeed) {
                    throw new IntegratedRuntimeException("lock QingTransactionLockImportThemeSysPkg time out.");
                }
                properties = new Properties();
                in = this.getClass().getResourceAsStream("Theme_Sys_Pkg_Config.properties");
                if (in != null) break block13;
                CloseUtil.close((Closeable[])new Closeable[]{in, fileIn, zis});
                if (succeed) {
                    transactionLock.unlock();
                }
                PresetUtil.removePresetTag(userID);
                return;
            }
            try {
                properties.load(in);
                String version = properties.getProperty("version");
                ThemeSysPkgStateDomain themeSysPkgStateDomain = new ThemeSysPkgStateDomain();
                themeSysPkgStateDomain.setDbExcuter(this.dbExcuter);
                themeSysPkgStateDomain.setTx(this.tx);
                ThemeSysPkgStatePO themeSysPkgStatePO = themeSysPkgStateDomain.findData(userID);
                int state = Integer.parseInt(version);
                if (themeSysPkgStatePO != null && themeSysPkgStatePO.getState() >= state) break block14;
                PresetUtil.publishPresettingMsg(userID);
                String fileName = properties.getProperty("fileName");
                fileIn = this.getClass().getResourceAsStream(fileName);
                zis = QingEncryptedStreamUtil.createZipInputStream((InputStream)fileIn);
                ZipEntry zipEntry = zis.getNextEntry();
                if (zipEntry != null && zipEntry.getName().equals("package-meta.xml")) {
                    CloseUtil.close((Closeable[])new Closeable[]{zis, fileIn});
                    fileIn = this.getClass().getResourceAsStream(fileName);
                    qingZipFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.UPLOAD);
                    if (!qingZipFile.exists()) {
                        qingZipFile.write((IWriteCall)new CopyWriteCall(fileIn, false), true);
                    }
                    CloseUtil.close((Closeable[])new Closeable[]{fileIn});
                    this.getImportPKGDomain().importSelected(qingZipFile.getName(), null, ExportThemeVO.StrategyType.overwrite.toPersistance(), true, null, null);
                } else {
                    CloseUtil.close((Closeable[])new Closeable[]{zis, fileIn});
                    fileIn = this.getClass().getResourceAsStream(fileName);
                    qingZipFile = FileFactory.newAppLocalTempFile((QingAppLocalTempFileType)QingAppLocalTempFileType.LOCAL_TEMP);
                    if (!qingZipFile.exists()) {
                        qingZipFile.write((IWriteCall)new CopyWriteCall(fileIn, false), true);
                    }
                    this.importSelectedTheme((IQingFileVisitor)qingZipFile, null, ExportThemeVO.StrategyType.overwrite.toPersistance(), true, null);
                }
                themeSysPkgStateDomain.save(userID, state, themeSysPkgStatePO == null);
            }
            catch (Throwable e) {
                try {
                    throw new ThemeManagementException(e);
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{in, fileIn, zis});
                    if (succeed) {
                        transactionLock.unlock();
                    }
                    PresetUtil.removePresetTag(userID);
                    throw throwable;
                }
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{in, fileIn, zis});
        if (succeed) {
            transactionLock.unlock();
        }
        PresetUtil.removePresetTag(userID);
    }

    public static String[] parseEntryNameToList(String zipEntryName) {
        String[] zipEntryPath = null;
        if (zipEntryName.contains("\\")) {
            zipEntryPath = zipEntryName.split("\\\\");
        } else if (zipEntryName.contains("/")) {
            zipEntryPath = zipEntryName.split("/");
        }
        return zipEntryPath;
    }

    public static ByteArrayInputStream getInputStreamFromZipInputStream(ZipInputStream zipInputStream) throws IOException {
        return new ByteArrayInputStream(ImExportDomain.getBytesFromZipInputStream(zipInputStream));
    }

    private static byte[] getBytesFromZipInputStream(ZipInputStream zipInputStream) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = zipInputStream.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        return baos.toByteArray();
    }
}

