/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.map.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.map.exception.MapDuplicateNameException;
import com.kingdee.bos.qing.map.exception.MapGroupDuplicateNameException;
import com.kingdee.bos.qing.map.imexport.model.ExportMapModel;
import com.kingdee.bos.qing.map.model.MapGroupPO;
import com.kingdee.bos.qing.map.model.MapGroupVO;
import com.kingdee.bos.qing.map.model.MapPO;
import com.kingdee.bos.qing.map.model.MapType;
import com.kingdee.bos.qing.map.model.MapVO;
import com.kingdee.bos.qing.util.IntegratedHelper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MapManageDao {
    private IDBExcuter dbExcuter;

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public String saveMapGroup(MapGroupPO mapGroupPO) throws AbstractQingIntegratedException, SQLException, MapGroupDuplicateNameException {
        if (this.checkGoupNameExistForSave(mapGroupPO.getMapGroupName(), mapGroupPO.getNameSpace().getCode())) {
            throw new MapGroupDuplicateNameException();
        }
        Object[] params = new Object[8];
        Date createDate = new Date();
        String id = this.dbExcuter.genStringId("T_QING_Map_Group");
        params[0] = id;
        params[1] = mapGroupPO.getMapGroupName();
        params[2] = mapGroupPO.getParentId();
        params[3] = mapGroupPO.getCreatorId();
        params[4] = mapGroupPO.getUpdaterId();
        params[5] = createDate;
        params[6] = createDate;
        params[7] = mapGroupPO.getNameSpace().getCode();
        this.dbExcuter.execute("INSERT INTO T_QING_Map_Group (FId, FName, FParentId, FCreatorId, FUpdaterId, FCreateDate, FModifyDate, FNameSpace) VALUES(?,?,?,?,?,?,?,?)", params);
        return id;
    }

    public List<MapGroupVO> loadMapGroupList(String nameSpace) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FId, FName, FParentId, FCreatorId, FCreateDate, FModifyDate, FNameSpace FROM T_QING_Map_Group WHERE FNameSpace = ? ORDER BY FCreateDate", new Object[]{nameSpace}, (ResultHandler)new ResultHandler<List<MapGroupVO>>(){

            public List<MapGroupVO> handle(ResultSet rs) throws SQLException {
                ArrayList<MapGroupVO> voList = new ArrayList<MapGroupVO>(10);
                while (rs.next()) {
                    MapGroupVO vo = new MapGroupVO();
                    vo.setMapGroupId(rs.getString("FId"));
                    vo.setMapGroupName(rs.getString("FName"));
                    vo.setParentId(rs.getString("FParentId"));
                    vo.setNameSpace(NameSpace.getNameSpace((String)rs.getString("FNameSpace")).getCode());
                    if (IntegratedHelper.getPresetUserId().equals(rs.getString("FCreatorId"))) {
                        vo.setNameSpace(NameSpace.system.getCode());
                    }
                    voList.add(vo);
                }
                return voList;
            }
        });
    }

    public List<MapGroupVO> loadMapGroupListForMoveMap(String mapGroupId, String nameSpace) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FId, FName, FParentId, FCreatorId, FCreateDate, FModifyDate, FNameSpace FROM T_QING_Map_Group WHERE FId != ? AND FNameSpace = ? ORDER BY FCreateDate", new Object[]{mapGroupId, nameSpace}, (ResultHandler)new ResultHandler<List<MapGroupVO>>(){

            public List<MapGroupVO> handle(ResultSet rs) throws SQLException {
                ArrayList<MapGroupVO> voList = new ArrayList<MapGroupVO>(10);
                while (rs.next()) {
                    MapGroupVO vo = new MapGroupVO();
                    vo.setMapGroupId(rs.getString("FId"));
                    vo.setMapGroupName(rs.getString("FName"));
                    vo.setParentId(rs.getString("FParentId"));
                    vo.setNameSpace(NameSpace.getNameSpace((String)rs.getString("FNameSpace")).getCode());
                    if (IntegratedHelper.getPresetUserId().equals(rs.getString("FCreatorId"))) {
                        vo.setNameSpace(NameSpace.system.getCode());
                    }
                    voList.add(vo);
                }
                return voList;
            }
        });
    }

    public MapGroupVO loadMapGroupByName(String mapGroupName, String nameSpace) throws AbstractQingIntegratedException, SQLException {
        return (MapGroupVO)this.dbExcuter.query("SELECT FId, FName, FParentId, FCreateDate, FModifyDate, FNameSpace FROM T_QING_Map_Group WHERE FNAME = ? AND FNameSpace = ?", new Object[]{mapGroupName, nameSpace}, (ResultHandler)new ResultHandler<MapGroupVO>(){

            public MapGroupVO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    MapGroupVO vo = new MapGroupVO();
                    vo.setMapGroupId(rs.getString("FId"));
                    vo.setMapGroupName(rs.getString("FName"));
                    vo.setParentId(rs.getString("FParentId"));
                    vo.setNameSpace(NameSpace.getNameSpace((String)rs.getString("FNameSpace")).getCode());
                    return vo;
                }
                return null;
            }
        });
    }

    public void updateMapGroup(String mapGroupId, String mapGroupName, String updaterId, String nameSpace) throws AbstractQingIntegratedException, SQLException, MapGroupDuplicateNameException {
        if (this.checkGoupNameExistForSave(mapGroupName, nameSpace)) {
            throw new MapGroupDuplicateNameException();
        }
        Object[] params = new Object[]{mapGroupName, new Date(), updaterId, mapGroupId};
        this.dbExcuter.execute("UPDATE T_QING_Map_Group SET FName = ?, FModifyDate = ?, FUpdaterId = ? WHERE FId = ?", params);
    }

    private boolean checkGoupNameExistForSave(String mapGroupName, String nameSpace) throws AbstractQingIntegratedException, SQLException {
        return (Boolean)this.dbExcuter.query("SELECT FName, FId FROM T_QING_Map_Group WHERE FName = ? AND FNameSpace = ?", new Object[]{mapGroupName, nameSpace}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    public void deleteMapGroup(String mapGroupId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_Map_Group WHERE FId = ?", new Object[]{mapGroupId});
    }

    public String saveMap(MapPO mapPO) throws AbstractQingIntegratedException, SQLException, MapDuplicateNameException {
        if (this.checkMapNameExist(mapPO.getMapName(), mapPO.getMapGroupId(), mapPO.getMapType().toPersistance(), mapPO.getMapId(), mapPO.getNameSpace().getCode())) {
            throw new MapDuplicateNameException();
        }
        return this.saveMapWithOutCheckName(mapPO);
    }

    public String saveMapWithOutCheckName(MapPO mapPO) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[11];
        String id = mapPO.getMapId() == null ? this.dbExcuter.genStringId("T_QING_Map") : mapPO.getMapId();
        params[0] = id;
        params[1] = mapPO.getMapName();
        params[2] = mapPO.getMapDescription();
        params[3] = mapPO.getMapGroupId();
        params[4] = mapPO.getMapType().toPersistance();
        params[5] = mapPO.getCreatorId();
        params[6] = mapPO.getUpdaterId();
        params[7] = mapPO.getNameSpace().getCode();
        params[8] = mapPO.getVersion();
        params[9] = mapPO.getMapCreateDate();
        params[10] = mapPO.getMapCreateDate();
        this.dbExcuter.execute("INSERT INTO T_QING_Map (FId, FName, FDescription, FMapGroupId, FType, FCreatorId, FUpdaterId, FNameSpace, FVersion, FCreateDate, FModifyDate) VALUES(?,?,?,?,?,?,?,?,?,?,?)", params);
        return id;
    }

    public void checkMapNameAndUpdateMap(MapPO mapPO) throws AbstractQingIntegratedException, SQLException, MapDuplicateNameException {
        if (this.checkMapNameExist(mapPO.getMapName(), mapPO.getMapGroupId(), mapPO.getMapType().toPersistance(), mapPO.getMapId(), mapPO.getNameSpace().getCode())) {
            throw new MapDuplicateNameException();
        }
        this.updateMap(mapPO);
    }

    public void updateMap(MapPO mapPO) throws AbstractQingIntegratedException, SQLException, MapDuplicateNameException {
        Object[] params = new Object[]{mapPO.getMapName(), mapPO.getMapDescription(), mapPO.getMapModifyDate(), mapPO.getUpdaterId(), mapPO.getVersion(), mapPO.getMapId()};
        this.dbExcuter.execute("UPDATE T_QING_Map SET FName = ?, FDescription = ?, FModifyDate = ?, FUpdaterId = ?, FVersion = ? WHERE FId = ?", params);
    }

    public void deteteMap(MapPO mapPO) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_Map WHERE FId = ?", new Object[]{mapPO.getMapId()});
    }

    public List<MapVO> loadMapList(String mapGroupId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT map.FId, map.FName, map.FDescription, map.FMapGroupId, map.FCreatorId, map.FType, map.FNameSpace, map.FVersion, map.FCreateDate, map.FModifyDate, content.FModifyDate AS FMapContentModifyDate, content.FThumbnailFileName FROM T_QING_Map map LEFT JOIN T_QING_Map_Content content ON map.FID = content.FMapId WHERE map.FMapGroupId = ? ORDER BY map.FCreateDate DESC", new Object[]{mapGroupId}, (ResultHandler)new ResultHandler<List<MapVO>>(){

            public List<MapVO> handle(ResultSet rs) throws SQLException {
                ArrayList<MapVO> voList = new ArrayList<MapVO>(10);
                while (rs.next()) {
                    MapVO vo = new MapVO();
                    vo.setMapId(rs.getString("FId"));
                    vo.setMapName(rs.getString("FName"));
                    vo.setMapDescription(rs.getString("FDescription"));
                    vo.setMapGroupId(rs.getString("FMapGroupId"));
                    vo.setCreateDate(rs.getDate("FCreateDate"));
                    java.sql.Date modifyDate = rs.getDate("FMapContentModifyDate");
                    if (modifyDate == null) {
                        modifyDate = rs.getDate("FModifyDate");
                    }
                    vo.setMapModifyDate(modifyDate);
                    vo.setMapType(MapType.getMapType(rs.getInt("FType")));
                    vo.setNameSpace(rs.getString("FNameSpace"));
                    if (IntegratedHelper.getPresetUserId().equals(rs.getString("FCreatorId"))) {
                        vo.setNameSpace(NameSpace.system.getCode());
                    }
                    vo.setVersion(rs.getString("FVersion"));
                    vo.setThumbnail(rs.getString("FThumbnailFileName"));
                    voList.add(vo);
                }
                return voList;
            }
        });
    }

    public boolean checkMapNameExist(String mapName, String mapGroupId, String mapType, final String mapId, String isUser) throws AbstractQingIntegratedException, SQLException {
        return (Boolean)this.dbExcuter.query("SELECT FId FROM T_QING_MAP WHERE FNAME = ? AND FMAPGROUPID = ? AND FTYPE = ? AND FNameSpace = ?", new Object[]{mapName, mapGroupId, mapType, isUser}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    if (mapId == null) {
                        return true;
                    }
                    if (!rs.getString("FId").equals(mapId)) {
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public void moveMap(MapPO mapPO, String newGroupMapId) throws AbstractQingIntegratedException, SQLException, MapDuplicateNameException {
        if (this.checkMapNameExist(mapPO.getMapName(), newGroupMapId, mapPO.getMapType().toPersistance(), mapPO.getMapId(), mapPO.getNameSpace().getCode())) {
            throw new MapDuplicateNameException();
        }
        Object[] params = new Object[]{newGroupMapId, new Date(), mapPO.getMapId()};
        this.dbExcuter.execute("UPDATE T_QING_Map SET FMapGroupId = ? , FModifyDate = ? WHERE FId=?", params);
    }

    public MapGroupVO loadMapGroupById(String mapGroupId) throws AbstractQingIntegratedException, SQLException {
        return (MapGroupVO)this.dbExcuter.query("SELECT FId, FName, FParentId, FCreateDate, FModifyDate, FNameSpace FROM T_QING_Map_Group WHERE FId = ?", new Object[]{mapGroupId}, (ResultHandler)new ResultHandler<MapGroupVO>(){

            public MapGroupVO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    MapGroupVO vo = new MapGroupVO();
                    vo.setMapGroupId(rs.getString("FId"));
                    vo.setMapGroupName(rs.getString("FName"));
                    return vo;
                }
                return null;
            }
        });
    }

    public MapVO loadMap(String mapId) throws AbstractQingIntegratedException, SQLException {
        return (MapVO)this.dbExcuter.query("SELECT Map.FId, Map.FName, Map.FMapGroupId, Content.FThumbnailFileName FROM T_QING_Map Map LEFT JOIN T_QING_Map_Content Content ON Map.FId = Content.FMapId WHERE Map.FId = ?", new Object[]{mapId}, (ResultHandler)new ResultHandler<MapVO>(){

            public MapVO handle(ResultSet rs) throws SQLException {
                MapVO vo = new MapVO();
                if (rs.next()) {
                    vo.setMapId(rs.getString("FId"));
                    vo.setMapGroupId(rs.getString("FMapGroupId"));
                    vo.setMapName(rs.getString("FName"));
                    vo.setThumbnail(rs.getString("FThumbnailFileName"));
                    return vo;
                }
                return vo;
            }
        });
    }

    public MapVO loadMapForExport(String mapId, String nameSpace) throws AbstractQingIntegratedException, SQLException {
        return (MapVO)this.dbExcuter.query("SELECT MAP.FId, MAP.FName, MAP.FCreatorId, MAP.FDescription, MAP.FMapGroupId, MAP.FType, MAP.FNameSpace, MAP.FVersion, MAP.FCreateDate, MAPGROUP.FNAME AS FMapGroupName, MAPGROUP.FNameSpace AS FMapGroupIsUser FROM T_QING_Map MAP LEFT JOIN T_QING_Map_Group MAPGROUP ON MAP.FMapGroupId = MAPGROUP.FID WHERE MAP.FId = ? AND MAP.FNAMESPACE = ?", new Object[]{mapId, nameSpace}, (ResultHandler)new ResultHandler<MapVO>(){

            public MapVO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    MapVO vo = new MapVO();
                    vo.setMapId(rs.getString("FId"));
                    vo.setMapName(rs.getString("FName"));
                    vo.setMapDescription(rs.getString("FDescription"));
                    vo.setMapGroupId(rs.getString("FMapGroupId"));
                    vo.setNameSpace(rs.getString("FNameSpace"));
                    vo.setVersion(rs.getString("FVersion"));
                    vo.setMapGroupName(rs.getString("FMapGroupName"));
                    if (IntegratedHelper.getPresetUserId().equals(rs.getString("FCreatorId"))) {
                        vo.setNameSpace(NameSpace.system.getCode());
                    }
                    return vo;
                }
                return null;
            }
        });
    }

    public ExportMapModel loadMapByNameAndGroupId(String mapGroupId, String mapName, String mapType) throws AbstractQingIntegratedException, SQLException {
        return (ExportMapModel)this.dbExcuter.query("SELECT FId, FName, FDescription, FMapGroupId, FType, FNameSpace, FVersion, FCreateDate FROM T_QING_Map WHERE FMapGroupId = ? AND FName = ? AND FType = ?", new Object[]{mapGroupId, mapName, mapType}, (ResultHandler)new ResultHandler<ExportMapModel>(){

            public ExportMapModel handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    ExportMapModel vo = new ExportMapModel();
                    vo.setMapId(rs.getString("FId"));
                    vo.setMapName(rs.getString("FName"));
                    vo.setMapDescription(rs.getString("FDescription"));
                    vo.setMapGroupId(rs.getString("FMapGroupId"));
                    vo.setCreateDate(rs.getDate("FCreateDate"));
                    vo.setMapType(MapType.getMapType(rs.getInt("FType")));
                    vo.setNameSpace(rs.getString("FNameSpace"));
                    vo.setVersion(rs.getString("FVersion"));
                    return vo;
                }
                return null;
            }
        });
    }

    public ExportMapModel loadMapByNameAndGroupName(String mapGroupName, String mapName, String nameSpace) throws AbstractQingIntegratedException, SQLException {
        return (ExportMapModel)this.dbExcuter.query("SELECT Map.FId FROM T_QING_Map Map LEFT JOIN T_QING_Map_Group MapGroup ON Map.FMapGroupId = MapGroup.FID  WHERE MapGroup.FName = ? AND Map.FName = ? AND Map.FNameSpace = ?", new Object[]{mapGroupName, mapName, nameSpace}, (ResultHandler)new ResultHandler<ExportMapModel>(){

            public ExportMapModel handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    ExportMapModel vo = new ExportMapModel();
                    vo.setMapId(rs.getString("FId"));
                    return vo;
                }
                return null;
            }
        });
    }

    public ExportMapModel loadMapWithGroupName(String mapId) throws AbstractQingIntegratedException, SQLException {
        return (ExportMapModel)this.dbExcuter.query("SELECT MAP.FId, MAP.FName, MAP.FDescription, MAP.FMapGroupId, MAP.FType, MAP.FNameSpace, MAP.FVersion, MAP.FCreateDate, MAPGROUP.FNAME AS FMapGroupName, MAPGROUP.FNameSpace AS FMapGroupIsUser FROM T_QING_Map MAP LEFT JOIN T_QING_Map_Group MAPGROUP ON MAP.FMapGroupId = MAPGROUP.FID WHERE MAP.FId = ?", new Object[]{mapId}, (ResultHandler)new ResultHandler<ExportMapModel>(){

            public ExportMapModel handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    ExportMapModel vo = new ExportMapModel();
                    vo.setMapId(rs.getString("FId"));
                    vo.setMapName(rs.getString("FName"));
                    vo.setMapDescription(rs.getString("FDescription"));
                    vo.setMapGroupId(rs.getString("FMapGroupId"));
                    vo.setCreateDate(rs.getDate("FCreateDate"));
                    vo.setMapType(MapType.getMapType(rs.getInt("FType")));
                    vo.setNameSpace(rs.getString("FNameSpace"));
                    vo.setVersion(rs.getString("FVersion"));
                    vo.setMapGroupName(rs.getString("FMapGroupName"));
                    vo.setMapGroupNameSpace(rs.getString("FMapGroupIsUser"));
                    return vo;
                }
                return null;
            }
        });
    }

    public MapVO getMapPath(String mapId) throws AbstractQingIntegratedException, SQLException {
        ExportMapModel exportMapModel = this.loadMapWithGroupName(mapId);
        MapVO mapVO = new MapVO();
        if (exportMapModel != null) {
            mapVO.setNameSpace(exportMapModel.getNameSpace());
            mapVO.setMapName(exportMapModel.getMapName());
            mapVO.setMapGroupName(exportMapModel.getMapGroupName());
        }
        return mapVO;
    }

    public void cleanEmptyGroupByUserId(String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_MAP_GROUP WHERE FID IN(SELECT FID FROM T_QING_MAP_GROUP WHERE FCREATORID=? AND FID NOT IN(SELECT FMAPGROUPID FROM T_QING_MAP WHERE FCREATORID=?))";
        Object[] params = new Object[]{userId, userId};
        this.dbExcuter.execute(sql, params);
    }
}

