/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.cache;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.data.exception.entity.NoEntityPermissionException;
import com.kingdee.bos.qing.response.ResponseErrorWrap;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;

public class ProgressModel
implements ISessionCacheable {
    private static String KEY = "Qing.Prepare.Progress.";
    private String sessionId;
    private String clientID;
    private String clallID;
    private String tag;
    private String timeStamp = "0";
    private boolean needDealProgress;
    private String shareTag;
    private long totalEntity = -1L;
    private long currentEntity = 1L;
    private long totalRows = -1L;
    private long dealRows = 0L;
    private boolean metaChanged = false;
    private ResponseErrorWrap errorWrap = null;
    private String subMessage;
    private int subCode;
    private boolean isFinished = false;
    private boolean asynResult = false;

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getClallID() {
        return this.clallID;
    }

    public void setClallID(String clallID) {
        this.clallID = clallID;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setShareTag(String shareTag) {
        this.shareTag = shareTag;
    }

    public String getShareTag() {
        return this.shareTag;
    }

    public long getTimeStamp() {
        return Long.parseLong(this.timeStamp);
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public boolean isNeedDealProgress() {
        return this.needDealProgress;
    }

    public void setNeedDealProgresss(boolean needDealProgress) {
        this.needDealProgress = needDealProgress;
    }

    public long getTotalEntity() {
        return this.totalEntity;
    }

    public void setTotalEntity(long totalEntity) {
        this.totalEntity = totalEntity;
    }

    public void setCurrentEntity(long currentEntity) {
        this.currentEntity = currentEntity;
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(long totalRows) {
        this.totalRows = totalRows;
    }

    public long getDealRows() {
        return this.dealRows;
    }

    public void setDealRows(long dealRows) {
        this.dealRows = dealRows;
    }

    public void setMetaChanged(boolean metaChanged) {
        this.metaChanged = metaChanged;
    }

    public boolean isMetaChanged() {
        return this.metaChanged;
    }

    public String getSubMessage() {
        return this.subMessage;
    }

    public int getSubCode() {
        return this.subCode;
    }

    public void finishOneEntity() {
        ++this.currentEntity;
        if (this.currentEntity > this.totalEntity) {
            this.currentEntity = this.totalEntity;
        }
        this.dealRows = 0L;
        this.totalRows = -1L;
    }

    public void finish(AbstractQingException exception) {
        if (exception != null) {
            if (!(exception instanceof NoEntityPermissionException)) {
                LogUtil.error((String)exception.getMessage(), (Throwable)exception);
            }
            this.errorWrap = this.warpException(exception);
        }
        this.isFinished = true;
    }

    public void finish(String subMessage, int subCode) {
        this.errorWrap = this.warpException(subCode, subMessage);
        this.subMessage = subMessage;
        this.subCode = subCode;
        this.isFinished = true;
    }

    public AbstractQingException getException() {
        if (this.errorWrap != null) {
            return new AbstractQingException(this.errorWrap.getErrorMessage(), this.errorWrap.getErrorCode());
        }
        return null;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public ResponseErrorWrap getErrorWrap() {
        return this.errorWrap;
    }

    public void setAsynResult(boolean asynResult) {
        this.asynResult = asynResult;
    }

    public boolean isAsynResult() {
        return this.asynResult;
    }

    public ProgressModel createShareModel() {
        ProgressModel progressModel = new ProgressModel();
        progressModel.setTag(this.shareTag);
        progressModel.setTimeStamp(this.timeStamp);
        progressModel.setTotalEntity(this.totalEntity);
        progressModel.setCurrentEntity(this.currentEntity);
        progressModel.setTotalRows(this.totalRows);
        progressModel.setDealRows(this.dealRows);
        progressModel.setMetaChanged(this.metaChanged);
        return progressModel;
    }

    public void copyProgessToModel(ProgressModel copyModel) {
        copyModel.setTotalEntity(this.totalEntity);
        copyModel.setCurrentEntity(this.currentEntity);
        copyModel.setTotalRows(this.totalRows);
        copyModel.setDealRows(this.dealRows);
        copyModel.setMetaChanged(this.metaChanged);
        copyModel.isFinished = this.isFinished;
        copyModel.subCode = this.subCode;
        copyModel.subMessage = this.subMessage;
        copyModel.errorWrap = this.errorWrap;
    }

    public static String getCacheKey(String tag) {
        return KEY + tag;
    }

    public String getChannel() {
        return "ExtractData" + this.timeStamp;
    }

    public String getCacheKey() {
        return ProgressModel.getCacheKey(this.tag);
    }

    public ISessionCacheable fromJson(String json) {
        return (ISessionCacheable)JsonUtil.decodeFromString((String)json, ProgressModel.class);
    }

    public String toJson() {
        return JsonUtil.encodeToString((Object)this);
    }

    public int getTimeoutSeconds() {
        return 360;
    }

    private ResponseErrorWrap warpException(AbstractQingException ex) {
        return new ResponseErrorWrap((Throwable)ex);
    }

    private ResponseErrorWrap warpException(int errorCode, String errorMessage) {
        return new ResponseErrorWrap(errorCode, errorMessage);
    }
}

