/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.data.domain.visitor.DSModelBuilder;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.ColumnToRowProperty;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.model.designtime.Parild;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.Relation;
import com.kingdee.bos.qing.data.model.designtime.UnionEntity;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.meta.DSMetaEntity;
import com.kingdee.bos.qing.datasource.meta.DSMetaRelation;
import com.kingdee.bos.qing.datasource.model.graph.ERGraph;
import com.kingdee.bos.qing.datasource.model.graph.ERGraphUtil;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FixPubToLappExtractDataEntity {
    private static final String splitFlag = "\\.";
    private SchemaManageDao schemaManageDao;
    protected IDBExcuter dbExcuter;

    public FixPubToLappExtractDataEntity(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    private SchemaManageDao getSchemaManageDao() {
        if (this.schemaManageDao == null) {
            this.schemaManageDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaManageDao;
    }

    public void filterUnusedEntities(Box box, Set<String> schemaIdSet) throws Exception {
        if (CollectionUtils.isEmpty(schemaIdSet) || box == null) {
            return;
        }
        HashSet<String> usedMetaFields = new HashSet<String>(16);
        ModelBook schemaBook = null;
        for (String schemaId : schemaIdSet) {
            schemaBook = this.getSchemaManageDao().loadSchemaModelBook(schemaId);
            if (schemaBook == null) continue;
            usedMetaFields.addAll(schemaBook.lookupUsedMetaFields());
        }
        if (CollectionUtils.isEmpty(usedMetaFields)) {
            return;
        }
        HashSet<String> usedEntityNames = new HashSet<String>(16);
        for (String filed : usedMetaFields) {
            String[] arrFiled = filed.split(splitFlag);
            String entityName = arrFiled[0];
            usedEntityNames.add(entityName);
        }
        Set<String> allUsedEntityParentNames = this.collectAllParentEntityNames(box, usedEntityNames);
        usedEntityNames.addAll(allUsedEntityParentNames);
        Set<DSMetaRelation> dsMetaRelationSet = this.getUsedEntityRelations(box, usedEntityNames);
        if (CollectionUtils.isNotEmpty(dsMetaRelationSet)) {
            for (DSMetaRelation relation : dsMetaRelationSet) {
                String fromEntityName = relation.getFromEntity().getName();
                String fromPropertyName = relation.getFromProperty().getName();
                String toEntityName = relation.getToEntity().getName();
                String toPropertyName = relation.getToProperty().getName();
                usedEntityNames.add(fromEntityName);
                usedEntityNames.add(toEntityName);
                usedMetaFields.add(fromEntityName + "." + fromPropertyName);
                usedMetaFields.add(toEntityName + "." + toPropertyName);
            }
        }
        HashMap entityPropertyNameMap = new HashMap(16);
        HashMap<String, AbstractEntity> entityMap = new HashMap<String, AbstractEntity>(16);
        List entities = box.getEntities();
        for (AbstractEntity entity : entities) {
            FilterItem filterItem2;
            List filterItems;
            String entityName = entity.getName();
            entityMap.put(entityName, entity);
            if (usedEntityNames.contains(entityName) && CollectionUtils.isNotEmpty((Collection)(filterItems = entity.getFilters()))) {
                for (FilterItem filterItem2 : entity.getFilters()) {
                    usedMetaFields.add(entityName + "." + filterItem2.getProprety());
                }
            }
            HashMap<String, Property> propertyNameMap = new HashMap<String, Property>(16);
            List propertyList = entity.getProperties();
            filterItem2 = propertyList.iterator();
            while (filterItem2.hasNext()) {
                Property property = (Property)filterItem2.next();
                propertyNameMap.put(property.getName(), property);
            }
            entityPropertyNameMap.put(entityName, propertyNameMap);
        }
        Iterator iteratorFields = usedMetaFields.iterator();
        HashSet<String> extraFields = new HashSet<String>(16);
        while (iteratorFields.hasNext()) {
            String filed = (String)iteratorFields.next();
            String[] arrFiled = filed.split(splitFlag);
            String entityName = arrFiled[0];
            String propertyName = arrFiled[1];
            AbstractEntity entity = (AbstractEntity)entityMap.get(entityName);
            Map<String, List<String>> colToRowMap = this.collectColumnToRowInfo(entityName, entity.getColumnToRowProperties());
            List<String> colToRowPropertyNames = colToRowMap.get("colToRowPropertyNames");
            List<String> colToRowUsedPropertyNames = colToRowMap.get("colToRowUsedPropertyNames");
            Map<String, List<String>> parildMap = this.collectParildInfo(entityName, entity.getParilds());
            Map propertyNameMap = (Map)entityPropertyNameMap.get(entityName);
            Property property = (Property)propertyNameMap.get(propertyName);
            String fullPropertyName = entityName + "." + propertyName;
            if (property != null) {
                if (property.isCalculation()) {
                    Set dependencesSet = property.getDependences();
                    for (String dependenceFieldName : dependencesSet) {
                        String fullFieldName = entityName + "." + dependenceFieldName;
                        extraFields.add(fullFieldName);
                        this.dealColToRowAndParildFields(fullFieldName, colToRowPropertyNames, colToRowUsedPropertyNames, parildMap, extraFields);
                    }
                    continue;
                }
                this.dealColToRowAndParildFields(fullPropertyName, colToRowPropertyNames, colToRowUsedPropertyNames, parildMap, extraFields);
                continue;
            }
            if (!CollectionUtils.isNotEmpty(colToRowPropertyNames) || !colToRowPropertyNames.contains(fullPropertyName)) continue;
            extraFields.addAll(colToRowUsedPropertyNames);
        }
        usedMetaFields.addAll(extraFields);
        this.fixAllUnusedEntityAndProperty(entities, usedMetaFields, usedEntityNames);
        this.fixBoxRelations(box, usedEntityNames);
        this.fixUnionChildEntityProperty(box);
    }

    private void fixAllUnusedEntityAndProperty(List<AbstractEntity> entities, Set<String> usedMetaFields, Set<String> usedEntityNames) {
        String entityName;
        HashMap<String, HashSet<String>> entityUsedPropertyNameMap = new HashMap<String, HashSet<String>>(16);
        for (String filed : usedMetaFields) {
            String[] arrFiled = filed.split(splitFlag);
            entityName = arrFiled[0];
            String propertyName = arrFiled[1];
            HashSet<String> propertyNames = (HashSet<String>)entityUsedPropertyNameMap.get(entityName);
            if (propertyNames == null) {
                propertyNames = new HashSet<String>();
                propertyNames.add(propertyName);
                entityUsedPropertyNameMap.put(entityName, propertyNames);
                continue;
            }
            propertyNames.add(propertyName);
        }
        Iterator<AbstractEntity> entitiesIterator = entities.iterator();
        while (entitiesIterator.hasNext()) {
            AbstractEntity entity = entitiesIterator.next();
            entityName = entity.getName();
            if (!usedEntityNames.contains(entityName)) {
                entitiesIterator.remove();
                continue;
            }
            Set usedPropertyNames = (Set)entityUsedPropertyNameMap.get(entityName);
            if (!CollectionUtils.isNotEmpty((Collection)usedPropertyNames)) continue;
            List currentEntityProperties = entity.getProperties();
            HashSet<String> flexPropertyNames = new HashSet<String>(16);
            boolean isUsedFlexProperty = false;
            for (Property property : currentEntityProperties) {
                if (usedPropertyNames.contains(property.getName())) {
                    if (property.getParent() == null) continue;
                    isUsedFlexProperty = true;
                    flexPropertyNames.add(property.getParent().getName());
                    continue;
                }
                if (property.getParent() == null) continue;
                flexPropertyNames.add(property.getName());
            }
            Iterator propertyIterator = currentEntityProperties.iterator();
            while (propertyIterator.hasNext()) {
                String value;
                Property property;
                property = (Property)propertyIterator.next();
                String propertyName = property.getName();
                if (usedPropertyNames.contains(propertyName) || null != (value = (String)property.getExtensionValue("unionPropUnRemovable", String.class)) && !"false".equals(value)) continue;
                if (isUsedFlexProperty) {
                    if (flexPropertyNames.contains(propertyName)) continue;
                    propertyIterator.remove();
                    continue;
                }
                propertyIterator.remove();
            }
        }
    }

    private void fixUnionChildEntityProperty(Box box) {
        List resultEntityList = box.getEntities();
        for (AbstractEntity unionEntity : resultEntityList) {
            if (!(unionEntity instanceof UnionEntity)) continue;
            List unionProperties = unionEntity.getProperties();
            HashMap<String, String> unionPropertyMap = new HashMap<String, String>(unionProperties.size());
            for (Property property : unionProperties) {
                unionPropertyMap.put(property.getName(), property.getName());
            }
            List childEntityList = ((UnionEntity)unionEntity).getChildren();
            for (Entity childEntity : childEntityList) {
                List columToRowProperties = childEntity.getColumnToRowProperties();
                if (columToRowProperties != null) {
                    Map<String, List<String>> colToRowInfoMap = this.collectColumnToRowInfo(null, columToRowProperties);
                    List<String> columnToRowGeneartePropertyNames = colToRowInfoMap.get("colToRowPropertyNames");
                    List<String> colToRowUsedPropertyNames = colToRowInfoMap.get("colToRowUsedPropertyNames");
                    for (String propertyName : columnToRowGeneartePropertyNames) {
                        if (!unionPropertyMap.containsKey(propertyName)) continue;
                        for (String userdPropertyName : colToRowUsedPropertyNames) {
                            unionPropertyMap.put(userdPropertyName, userdPropertyName);
                        }
                    }
                }
                Iterator iterator = childEntity.getProperties().iterator();
                while (iterator.hasNext()) {
                    Property property = (Property)iterator.next();
                    if (null != unionPropertyMap.get(property.getName())) continue;
                    iterator.remove();
                }
            }
        }
    }

    private void fixBoxRelations(Box box, Set<String> usedEntityNames) {
        List allRelations = box.getRelations();
        if (CollectionUtils.isNotEmpty((Collection)allRelations)) {
            Iterator relationIterator = allRelations.iterator();
            while (relationIterator.hasNext()) {
                Relation relation = (Relation)relationIterator.next();
                String fromEntity = relation.getFromEntity();
                String toEntity = relation.getToEntity();
                if (usedEntityNames.contains(fromEntity) && usedEntityNames.contains(toEntity)) continue;
                relationIterator.remove();
            }
        }
    }

    private Set<String> collectAllParentEntityNames(Box box, Set<String> usedEntityNames) {
        List allEntities = box.getEntities();
        HashMap<String, AbstractEntity> allEntityMap = new HashMap<String, AbstractEntity>(allEntities.size());
        for (AbstractEntity entity : allEntities) {
            allEntityMap.put(entity.getName(), entity);
        }
        HashSet<String> allUsedEntityParentNames = new HashSet<String>(16);
        for (String usedEntityName : usedEntityNames) {
            AbstractEntity usedEntity = (AbstractEntity)allEntityMap.get(usedEntityName);
            String entityParentName = usedEntity.getParentName();
            if (entityParentName == null) continue;
            this.collectParentEntityName(allEntityMap, entityParentName, allUsedEntityParentNames);
        }
        return allUsedEntityParentNames;
    }

    private void collectParentEntityName(Map<String, AbstractEntity> allEntityMap, String parentEntityName, Set<String> allUsedEntityParentNames) {
        if (parentEntityName != null) {
            allUsedEntityParentNames.add(parentEntityName);
            AbstractEntity parentEntity = allEntityMap.get(parentEntityName);
            if (parentEntity != null && parentEntity.getParentName() != null) {
                allUsedEntityParentNames.add(parentEntity.getParentName());
                this.collectParentEntityName(allEntityMap, parentEntity.getParentName(), allUsedEntityParentNames);
            }
        }
    }

    private Map<String, List<String>> collectParildInfo(String entityName, List<Parild> parilds) {
        if (CollectionUtils.isEmpty(parilds)) {
            return null;
        }
        HashMap<String, List<String>> parildFieldNameMap = new HashMap<String, List<String>>(16);
        ArrayList<String> parildFieldNames = new ArrayList<String>(4);
        for (Parild parild : parilds) {
            String idFieldFullName = entityName + "." + parild.getIdField();
            String parentIdFieldFullName = entityName + "." + parild.getParentIdField();
            String defaultDisplayFullName = entityName + "." + parild.getDefaultDisplayField();
            String sortAccordingFieldFullName = entityName + "." + parild.getSortAccordingField();
            parildFieldNames.add(idFieldFullName);
            parildFieldNames.add(parentIdFieldFullName);
            parildFieldNames.add(defaultDisplayFullName);
            parildFieldNames.add(sortAccordingFieldFullName);
            parildFieldNameMap.put(idFieldFullName, parildFieldNames);
            parildFieldNameMap.put(parentIdFieldFullName, parildFieldNames);
            parildFieldNameMap.put(defaultDisplayFullName, parildFieldNames);
            parildFieldNameMap.put(sortAccordingFieldFullName, parildFieldNames);
        }
        return parildFieldNameMap;
    }

    private void dealColToRowAndParildFields(String fullFieldName, List<String> colToRowPropertyNames, List<String> colToRowUsedPropertyNames, Map<String, List<String>> parildMap, Set<String> extraFields) {
        List<String> parildList;
        if (CollectionUtils.isNotEmpty(colToRowPropertyNames) && colToRowPropertyNames.contains(fullFieldName)) {
            extraFields.addAll(colToRowUsedPropertyNames);
        } else if (parildMap != null && CollectionUtils.isNotEmpty(parildList = parildMap.get(fullFieldName))) {
            extraFields.addAll(parildList);
        }
    }

    private Map<String, List<String>> collectColumnToRowInfo(String entityName, List<ColumnToRowProperty> columnToRowProperties) {
        HashMap<String, List<String>> columnToRowMap = new HashMap<String, List<String>>(16);
        String prefix = null;
        if (entityName != null) {
            prefix = entityName + ".";
        }
        if (CollectionUtils.isNotEmpty(columnToRowProperties)) {
            ArrayList<String> colToRowPropertyNames = new ArrayList<String>(10);
            ArrayList<String> colToRowUsedPropertyNames = new ArrayList<String>(10);
            for (ColumnToRowProperty columnToRowProperty : columnToRowProperties) {
                colToRowPropertyNames.add(prefix + columnToRowProperty.getFieldNameProperty().getName());
                for (Property property : columnToRowProperty.getFieldValueProperties()) {
                    colToRowPropertyNames.add(prefix + property.getName());
                }
                for (String usedPropertyName : columnToRowProperty.getUsedColumnToRowPropertyNames()) {
                    colToRowUsedPropertyNames.add(prefix + usedPropertyName);
                }
            }
            columnToRowMap.put("colToRowPropertyNames", colToRowPropertyNames);
            columnToRowMap.put("colToRowUsedPropertyNames", colToRowUsedPropertyNames);
        }
        return columnToRowMap;
    }

    private Set<DSMetaRelation> getUsedEntityRelations(Box box, Set<String> usedEntityNames) throws AbstractDataSourceException {
        DSModelBuilder dSModelBuilder = new DSModelBuilder(box, new HashMap());
        List erEntities = dSModelBuilder.getErEntities();
        List erRelations = dSModelBuilder.getErRelations();
        ERGraph graph = new ERGraph(erEntities, erRelations);
        HashMap<String, DSMetaEntity> selectedEntitiesMap = new HashMap<String, DSMetaEntity>(16);
        for (DSMetaEntity entity : erEntities) {
            if (!usedEntityNames.contains(entity.getName())) continue;
            selectedEntitiesMap.put(entity.getName(), entity);
        }
        Set dsMetaRelationSet = ERGraphUtil.getSelectedEntitiesRelation((ERGraph)graph, selectedEntitiesMap);
        return dsMetaRelationSet;
    }
}

