/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler;

import com.kingdee.bos.qing.common.cache.AbstractDataSource;
import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.cache.ThemeDataSource;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.framework.manage.ClientCallManager;
import com.kingdee.bos.qing.common.framework.manage.ClientManager;
import com.kingdee.bos.qing.common.framework.model.server.ServerRemoteCallMessage;
import com.kingdee.bos.qing.common.framework.server.msgpublish.ServerChannelMessagePublisher;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.preparedata.cache.ProgressModel;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.ResponseErrorWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ShareSourceProgressUpdateTask
implements Runnable {
    private static final String GLOBAL_SHARE_SOURCE_PROGRESS_UPDATE_TASK_SHARE_TAG = "QingShareSourceProgressUpdateTaskShareTag";
    private static ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static long ttlIntervalMillis = TimeUnit.SECONDS.toMillis(3L);
    private static Runnable task = new Runnable(){

        @Override
        public void run() {
            try {
                Set shareTags = ShareSourceProgressUpdateTask.getExtractTaskTags(ShareSourceProgressUpdateTask.GLOBAL_SHARE_SOURCE_PROGRESS_UPDATE_TASK_SHARE_TAG);
                if (shareTags != null && !shareTags.isEmpty()) {
                    for (String tempShareTag : shareTags) {
                        ShareSourceProgressUpdateTask.tryToStartUpdateProgressTask(tempShareTag);
                    }
                }
            }
            catch (Exception e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
        }
    };
    private String shareTag;
    private int tryTime = 0;

    public static void stop() {
        scheduler.shutdown();
    }

    public ShareSourceProgressUpdateTask(String shareTag) {
        this.shareTag = shareTag;
    }

    private static String getShareUpdateProgressTaskLockKey(String shareTag) {
        return shareTag + "UpdateProgressTask";
    }

    private static String getShareExtractTaskLockKey(String shareTag) {
        return shareTag + "ShareExctratTask";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startShareExtractTask(ProgressModel progressModel) throws QingLockRequireException, InterruptedException {
        String tag = progressModel.getTag();
        String shareTag = progressModel.getShareTag();
        ILock shareExtractTaskLock = null;
        try {
            shareExtractTaskLock = LockFactory.createLock((String)ShareSourceProgressUpdateTask.getShareExtractTaskLockKey(shareTag));
            shareExtractTaskLock.lock();
            progressModel.setAsynResult(true);
            IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
            globalQingSession.setCache((ISessionCacheable)progressModel);
            ShareSourceProgressUpdateTask.addExtractTaskTag(shareTag, tag);
            ShareSourceProgressUpdateTask.addExtractTaskTag(GLOBAL_SHARE_SOURCE_PROGRESS_UPDATE_TASK_SHARE_TAG, shareTag);
            ShareSourceProgressUpdateTask.tryToStartUpdateProgressTask(shareTag);
        }
        finally {
            if (null != shareExtractTaskLock) {
                shareExtractTaskLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endShareExtractTask(String shareTag, ILock lock, ShareSourceProgressUpdateTask nextTask) {
        block17: {
            Set<String> extractTaskTagSet = ShareSourceProgressUpdateTask.getExtractTaskTags(shareTag);
            if (extractTaskTagSet != null && !extractTaskTagSet.isEmpty() && nextTask != null) {
                ShareSourceProgressUpdateTask.invokeMeAgainLater(nextTask);
                return;
            }
            ILock shareExtractTaskLock = null;
            try {
                shareExtractTaskLock = LockFactory.createLock((String)ShareSourceProgressUpdateTask.getShareExtractTaskLockKey(shareTag));
                shareExtractTaskLock.lock();
                extractTaskTagSet = ShareSourceProgressUpdateTask.getExtractTaskTags(shareTag);
                if (extractTaskTagSet != null && !extractTaskTagSet.isEmpty()) {
                    if (nextTask != null) {
                        ShareSourceProgressUpdateTask.invokeMeAgainLater(nextTask);
                        return;
                    }
                    ILock updateLock = null;
                    try {
                        updateLock = LockFactory.createGlobalLock((String)ShareSourceProgressUpdateTask.getShareUpdateProgressTaskLockKey(shareTag));
                        updateLock.lock();
                        ShareSourceProgressUpdateTask.updateBatchProgress(shareTag, 0);
                        ShareSourceProgressUpdateTask.removeExtractTaskTag(GLOBAL_SHARE_SOURCE_PROGRESS_UPDATE_TASK_SHARE_TAG, shareTag);
                        IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
                        String shareProgressCacheKey = ProgressModel.getCacheKey(shareTag);
                        globalQingSession.remove(shareProgressCacheKey);
                        break block17;
                    }
                    catch (Exception e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                        break block17;
                    }
                    finally {
                        if (updateLock != null) {
                            updateLock.unlock();
                        }
                    }
                }
                ShareSourceProgressUpdateTask.removeExtractTaskTag(GLOBAL_SHARE_SOURCE_PROGRESS_UPDATE_TASK_SHARE_TAG, shareTag);
            }
            catch (Exception e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
                if (null != shareExtractTaskLock) {
                    shareExtractTaskLock.unlock();
                }
            }
        }
    }

    private static void invokeMeAgainLater(final ShareSourceProgressUpdateTask nextTask) {
        scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                ThreadPoolManage.submit((ThreadPoolManage.QingThreadPoolName)ThreadPoolManage.QingThreadPoolName.QING_SHORT_TIME_TASK_HANDLER, (Runnable)nextTask);
            }
        }, 1000L, TimeUnit.MILLISECONDS);
    }

    private static void tryToStartUpdateProgressTask(String shareTag) {
        ILock lock = null;
        try {
            lock = LockFactory.createGlobalLock((String)ShareSourceProgressUpdateTask.getShareUpdateProgressTaskLockKey(shareTag));
            if (lock.tryLock()) {
                ThreadPoolManage.submit((ThreadPoolManage.QingThreadPoolName)ThreadPoolManage.QingThreadPoolName.QING_SHORT_TIME_TASK_HANDLER, (Runnable)new ShareSourceProgressUpdateTask(shareTag));
            }
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isLock = false;
        ILock lock = null;
        try {
            lock = LockFactory.createGlobalLock((String)ShareSourceProgressUpdateTask.getShareUpdateProgressTaskLockKey(this.shareTag));
            isLock = lock.tryLock();
            if (!isLock) {
                return;
            }
            boolean isTryTimeAdd = ShareSourceProgressUpdateTask.updateBatchProgress(this.shareTag, this.tryTime);
            if (isTryTimeAdd) {
                ++this.tryTime;
            }
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != lock) {
                lock.unlock();
            }
            if (isLock) {
                ShareSourceProgressUpdateTask.endShareExtractTask(this.shareTag, null, this);
            }
        }
    }

    public static boolean updateBatchProgress(String shareTag, int tryTime) {
        IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
        String shareProgressCacheKey = ProgressModel.getCacheKey(shareTag);
        String shareDatasourceCacheKey = ThemeDataSource.getCacheKey(shareTag);
        boolean isTryTimeAdd = false;
        Set<String> valueSet = ShareSourceProgressUpdateTask.getExtractTaskTags(shareTag);
        if (valueSet != null && !valueSet.isEmpty()) {
            ProgressModel shareProgressModel = (ProgressModel)globalQingSession.getCache(shareProgressCacheKey, ProgressModel.class);
            AbstractDataSource shareDataSource = (AbstractDataSource)globalQingSession.getCache(shareDatasourceCacheKey, AbstractDataSource.class);
            AbstractQingException exception = null;
            if (shareProgressModel != null && shareProgressModel.isFinished()) {
                exception = shareProgressModel.getException();
            } else if (!ClientCallManager.isCallWorkingInServer((ServerRequestInvokeContext.CheckerName)ServerRequestInvokeContext.CheckerName.RPCServer, (String)shareTag, (String)shareTag, (boolean)false)) {
                if (tryTime >= 10) {
                    exception = new AbstractQingException("server stop call, please retry,sharedTag=" + shareTag, -2);
                }
                isTryTimeAdd = true;
            }
            if (exception != null || shareProgressModel != null) {
                HashMap<String, Boolean> clientsClosed = new HashMap<String, Boolean>();
                HashMap<String, Boolean> callsCanceled = new HashMap<String, Boolean>();
                HashSet<String> removedTags = new HashSet<String>();
                for (String tag : valueSet) {
                    ShareSourceProgressUpdateTask.updateSingleProgress(globalQingSession, tag, shareTag, shareProgressModel, shareDataSource, (Exception)((Object)exception), removedTags, clientsClosed, callsCanceled);
                }
                ShareSourceProgressUpdateTask.removeExtractTaskTag(shareTag, removedTags);
            }
        }
        return isTryTimeAdd;
    }

    private static void updateSingleProgress(IGlobalQingSession globalQingSession, String tag, String shareTag, ProgressModel shareProgressModel, AbstractDataSource shareDataSource, Exception exception, Set<String> removedTags, Map<String, Boolean> clientsClosed, Map<String, Boolean> callsCanceled) {
        String cacheKey = ProgressModel.getCacheKey(tag);
        ProgressModel progressModel = (ProgressModel)globalQingSession.getCache(cacheKey, ProgressModel.class);
        if (progressModel == null) {
            removedTags.add(tag);
        } else {
            String callID = progressModel.getClallID();
            String clientID = progressModel.getClientID();
            if (ClientManager.isClientClosed((String)clientID, (boolean)true, clientsClosed) || ClientCallManager.isCallCanceled((String)clientID, (String)callID, callsCanceled)) {
                ClientCallManager.removeRelativeClientIDs((String)shareTag, (String)clientID);
                removedTags.add(tag);
                globalQingSession.remove(cacheKey);
            } else {
                if (exception != null || shareProgressModel != null && shareProgressModel.isFinished()) {
                    ResponseErrorWrap data = null;
                    if (exception != null) {
                        data = new ResponseErrorWrap((Throwable)exception);
                    } else if (shareProgressModel.getSubCode() != 0 && shareProgressModel.getSubMessage() != null) {
                        data = new ResponseErrorWrap(shareProgressModel.getSubCode(), shareProgressModel.getSubMessage());
                    } else {
                        String sessionId = progressModel.getSessionId();
                        IQingSession qingSession = QingSessionUtil.getQingSession((String)sessionId);
                        shareDataSource.setTag(tag);
                        AbstractDataSource oldDataSource = (AbstractDataSource)qingSession.getCache(AbstractDataSource.getCacheKey(tag), AbstractDataSource.class);
                        try {
                            boolean hasMetaChanged = shareDataSource.isMetaChanged(oldDataSource);
                            progressModel.setMetaChanged(hasMetaChanged);
                            qingSession.setCache((ISessionCacheable)shareDataSource);
                            data = new ResponseSuccessWrap((Object)progressModel);
                        }
                        catch (AbstractDataSourceException e) {
                            exception = new PrepareDataException(e);
                            data = new ResponseErrorWrap((Throwable)exception);
                        }
                    }
                    removedTags.add(tag);
                    ClientCallManager.removeRelativeClientIDs((String)shareTag, (String)clientID);
                    ServerRemoteCallMessage serverRemoteCallMessage = new ServerRemoteCallMessage(clientID, callID, (AbstractResponseWrap)data);
                    ClientCallManager.setCallResult((ServerRemoteCallMessage)serverRemoteCallMessage);
                    globalQingSession.remove(cacheKey);
                    return;
                }
                globalQingSession.expireAfter(cacheKey, progressModel.getTimeoutSeconds(), TimeUnit.SECONDS);
                if (progressModel.isNeedDealProgress()) {
                    if (shareProgressModel != null) {
                        shareProgressModel.copyProgessToModel(progressModel);
                    }
                    ServerChannelMessagePublisher.publish((String)progressModel.getClientID(), (String)progressModel.getChannel(), (String)progressModel.toJson());
                }
            }
        }
    }

    public static void addExtractTaskTag(String shareTag, String tag) {
        if (tag == null || tag.isEmpty()) {
            return;
        }
        IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
        globalQingSession.addToSet(shareTag, new String[]{tag}, 1, TimeUnit.DAYS);
    }

    private static void removeExtractTaskTag(String shareTag, Object removedTag) {
        IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
        if (removedTag instanceof Collection) {
            Collection collection = (Collection)removedTag;
            globalQingSession.removeSetValue(shareTag, collection.toArray(new String[0]));
        } else {
            globalQingSession.removeSetValue(shareTag, new String[]{removedTag.toString()});
        }
    }

    private static Set<String> getExtractTaskTags(String shareTag) {
        IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
        String[] tags = globalQingSession.getSetValues(shareTag);
        if (null == tags || tags.length == 0) {
            return Collections.emptySet();
        }
        HashSet<String> tagSet = new HashSet<String>(tags.length);
        for (String tag : tags) {
            tagSet.add(tag);
        }
        return tagSet;
    }

    static {
        scheduler.scheduleAtFixedRate(task, ttlIntervalMillis, ttlIntervalMillis, TimeUnit.MILLISECONDS);
    }
}

