/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler.publish;

import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.PublishedNotExistPrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.PublishedPrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.AbstractPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.handler.publish.IPublishDataPrepareHandler;
import com.kingdee.bos.qing.preparedata.handler.publish.PublishPrepareDataContext;
import com.kingdee.bos.qing.preparedata.handler.publish.PublishPrepareDataHandleFactory;
import com.kingdee.bos.qing.preparedata.preparedatacontext.IPrepareDataContext;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import java.sql.SQLException;

public class PublishedPrepareDataHandler
extends AbstractPrepareDataHandler {
    private CommonPublishDomain commonPublishDomain;

    public PublishedPrepareDataHandler(IPrepareDataContext extractContext) {
        super(extractContext);
        this.commonPublishDomain = new CommonPublishDomain(extractContext.getQingContext(), extractContext.getTransManagement(), extractContext.getDBExecuter());
    }

    @Override
    public void createDataSource() throws PrepareDataException {
        PublishPrepareDataContext prepareContext = (PublishPrepareDataContext)this.getPrepareContext();
        this.createDataSource(prepareContext.getPublishId(), prepareContext.isEditScene());
    }

    private void createDataSource(String publishId, boolean isEditScene) throws PrepareDataException {
        PublishSourceEnum publishSourceEnum = null;
        PublishPO publishPO = null;
        try {
            publishPO = this.commonPublishDomain.loadPublishInfo(publishId);
            if (publishPO == null) {
                throw new PublishedNotExistPrepareDataException();
            }
            publishSourceEnum = this.commonPublishDomain.confirmSourceTypeByPublishInfo(publishPO);
        }
        catch (SQLException e) {
            throw new PublishedPrepareDataException(e);
        }
        catch (AbstractQingIntegratedException e) {
            throw new PublishedPrepareDataException(e);
        }
        IPublishDataPrepareHandler publishDataPrepareHandler = PublishPrepareDataHandleFactory.newPublishedDataPrepareHandler(publishSourceEnum, this.getPrepareContext());
        if (null == publishDataPrepareHandler) {
            throw new PublishedPrepareDataException("unsupported publishSource type");
        }
        publishDataPrepareHandler.createPublishDataSource(publishPO, isEditScene);
    }
}

