/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler.subject;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.preparedata.cache.ProgressModel;
import com.kingdee.bos.qing.preparedata.handler.subject.ISubjectCallbackFunction;
import com.kingdee.bos.qing.preparedata.strategy.ISubjectPrepareDataLimitStrategy;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class ShareSubjectPrepareDataCallbackImpl
implements ISubjectCallbackFunction {
    private ProgressModel progressModel;
    private AbstractQingException e;
    private ProgressProcessor progressProcessor;
    private DealtRowsChangedLisenterImpl dealtRowsChangedLisenter;
    private IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
    private volatile Queue<ThreadProgressModel> modelQueue = new LinkedBlockingQueue<ThreadProgressModel>();
    private static ThreadLocal<ThreadProgressModel> progressModelThreadLocal = new ThreadLocal();

    public ShareSubjectPrepareDataCallbackImpl(ProgressModel progressModel) {
        this.progressModel = progressModel;
    }

    @Override
    public AbstractQingException getException() {
        return this.e;
    }

    @Override
    public void finishAll(AbstractQingException exception) {
        this.e = exception;
        this.progressModel.finish(exception);
        this.modelQueue.clear();
        this.globalQingSession.setCache((ISessionCacheable)this.progressModel);
    }

    @Override
    public void finishAll(String subMessage, int subCode) {
        this.progressModel.finish(subMessage, subCode);
        this.modelQueue.clear();
        this.globalQingSession.setCache((ISessionCacheable)this.progressModel);
    }

    public void start() {
        this.dealtRowsChangedLisenter = new DealtRowsChangedLisenterImpl();
        this.globalQingSession.setCache((ISessionCacheable)this.progressModel);
    }

    public ProgressProcessor startOneEntity() {
        ThreadProgressModel model = new ThreadProgressModel();
        this.modelQueue.offer(model);
        model.setProgressProcessor(this.progressProcessor);
        model.setProgressModel(new ProgressModel());
        progressModelThreadLocal.set(model);
        this.dealtRowsChangedLisenter.fireDataChanged(0L, -1L);
        long limit = ShareSubjectPrepareDataCallbackImpl.getSubjectPrepareDataLimitStrategyImpl();
        this.progressProcessor = new ProgressProcessor(limit);
        this.progressProcessor.setDealtRowsChangedLisenter((ProgressProcessor.IDealtRowsChangedLisenter)this.dealtRowsChangedLisenter);
        return this.progressProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishOneEntity() {
        this.progressProcessor.dealtAllRows();
        ThreadProgressModel threadProgressModel = progressModelThreadLocal.get();
        if (threadProgressModel != null) {
            Queue<ThreadProgressModel> queue = this.modelQueue;
            synchronized (queue) {
                ThreadProgressModel firstModel = this.modelQueue.peek();
                if (firstModel != null && threadProgressModel == firstModel) {
                    this.progressModel.finishOneEntity();
                    this.modelQueue.poll();
                    while (!this.modelQueue.isEmpty()) {
                        ThreadProgressModel head = this.modelQueue.peek();
                        if (head.isFinished()) {
                            this.progressModel.finishOneEntity();
                            this.modelQueue.poll();
                            continue;
                        }
                        ProgressModel model = head.getProgressModel();
                        if (model == null) continue;
                        this.progressModel.setTotalRows(model.getTotalRows());
                        this.progressModel.setDealRows(model.getDealRows());
                        break;
                    }
                    this.globalQingSession.setCache((ISessionCacheable)this.progressModel);
                } else {
                    threadProgressModel.setFinished(true);
                }
            }
        }
    }

    public void setTotalEntity(int totalEntitySize) {
        this.progressModel.setTotalEntity(totalEntitySize);
        this.globalQingSession.setCache((ISessionCacheable)this.progressModel);
    }

    @Override
    public void setMetaChanged(boolean metaChange) {
        this.progressModel.setMetaChanged(metaChange);
        this.globalQingSession.setCache((ISessionCacheable)this.progressModel);
    }

    private static int getSubjectPrepareDataLimitStrategyImpl() {
        ISubjectPrepareDataLimitStrategy subjectPrepareDataLimitStrategy = (ISubjectPrepareDataLimitStrategy)CustomStrategyRegistrar.getStrategy(ISubjectPrepareDataLimitStrategy.class);
        if (subjectPrepareDataLimitStrategy == null) {
            return -1;
        }
        return subjectPrepareDataLimitStrategy.getDataLimit();
    }

    private static class ThreadProgressModel {
        private ProgressModel progressModel;
        private ProgressProcessor progressProcessor;
        private boolean finished;

        private ThreadProgressModel() {
        }

        public ProgressModel getProgressModel() {
            return this.progressModel;
        }

        public void setProgressModel(ProgressModel progressModel) {
            this.progressModel = progressModel;
        }

        public ProgressProcessor getProgressProcessor() {
            return this.progressProcessor;
        }

        public void setProgressProcessor(ProgressProcessor progressProcessor) {
            this.progressProcessor = progressProcessor;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void setFinished(boolean finished) {
            this.finished = finished;
        }
    }

    private class DealtRowsChangedLisenterImpl
    implements ProgressProcessor.IDealtRowsChangedLisenter {
        private DealtRowsChangedLisenterImpl() {
        }

        public void fireDataChanged(long dealRows, long totalRows) {
            ThreadProgressModel threadProgressModel = (ThreadProgressModel)progressModelThreadLocal.get();
            if (threadProgressModel != null) {
                ProgressModel model = threadProgressModel.getProgressModel();
                model.setTotalRows(totalRows);
                model.setDealRows(dealRows);
                if (threadProgressModel == ShareSubjectPrepareDataCallbackImpl.this.modelQueue.peek()) {
                    ShareSubjectPrepareDataCallbackImpl.this.progressModel.setTotalRows(totalRows);
                    ShareSubjectPrepareDataCallbackImpl.this.progressModel.setDealRows(dealRows);
                    ShareSubjectPrepareDataCallbackImpl.this.globalQingSession.setCache((ISessionCacheable)ShareSubjectPrepareDataCallbackImpl.this.progressModel);
                }
            }
        }
    }
}

