/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.domain;

import com.kingdee.bos.qing.common.cache.FormDataSource;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.core.model.ModelJsonDecoder;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.manager.model.ResourceFromType;
import com.kingdee.bos.qing.publish.dao.BillManagerDao;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.domain.IBillPublishSourceDomain;
import com.kingdee.bos.qing.publish.domain.IPublishSourceDomain;
import com.kingdee.bos.qing.publish.exception.MapNotFoundException;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishSourcePublishNotExistException;
import com.kingdee.bos.qing.publish.model.AbstractPublishSourceModel;
import com.kingdee.bos.qing.publish.model.BillModel;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSchemaModel;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.schema.domain.SchemaDomain;
import com.kingdee.bos.qing.schema.model.SchemaAttrVO;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.schema.model.SchemaModel;
import com.kingdee.bos.qing.schema.model.SchemaVO;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jdom2.Element;

public class BillPublishSourceDomain
implements IPublishSourceDomain,
IBillPublishSourceDomain {
    public static final String QING_CTRL_KEY = "qing_ctrl_tag_";
    public static final String QING_FILTER_KEY = "qing_filter_";
    private IDBExcuter dbExcuter;
    private QingContext context;
    private ITransactionManagement tx;
    private SchemaManageDao schemaManageDao;
    private BillManagerDao billManagerDao;
    private PublishInfoDao publishInfoDao;
    private SchemaDomain schemaDomain;

    public BillPublishSourceDomain(QingContext context, IDBExcuter dbExcuter, ITransactionManagement tx) {
        this.context = context;
        this.dbExcuter = dbExcuter;
        this.tx = tx;
    }

    private SchemaManageDao getSchemaManageDao() {
        if (this.schemaManageDao == null) {
            this.schemaManageDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaManageDao;
    }

    private BillManagerDao getBillManagerDao() {
        if (this.billManagerDao == null) {
            this.billManagerDao = new BillManagerDao(this.dbExcuter);
        }
        return this.billManagerDao;
    }

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    public AbstractPublishSourceModel parsePublishSourceModel(String modelJsonString) {
        SchemaVO schemaVO = (SchemaVO)ModelJsonDecoder.decode((String)modelJsonString, SchemaVO.class);
        PublishSchemaModel importSubjectSource = new PublishSchemaModel();
        importSubjectSource.setSchemaAttr(schemaVO.getSchemaAttr());
        importSubjectSource.setSchemaContent(schemaVO.getSchemaContent());
        return importSubjectSource;
    }

    public PublishPO savePublish(String tag, String bizTag, PublishPO publishInfo, List<AbstractPublishSourceModel> abstractPublishSourceModelList, List<IQingFile> savedQingFiles) throws PublishException, AbstractQingIntegratedException {
        try {
            this.savePersistentFileAndData(tag, publishInfo, savedQingFiles);
            return this.saveSchema(publishInfo, abstractPublishSourceModelList);
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
        catch (IOException e) {
            throw new PublishException((Throwable)e);
        }
    }

    public PublishPO savePublishWithCtrlKey(PublishPO publishInfo, List<AbstractPublishSourceModel> abstractPublishSourceModelList, Map<String, Object> billContent) throws PublishException, AbstractQingIntegratedException {
        try {
            this.saveBillContent(publishInfo, billContent);
            return this.saveSchema(publishInfo, abstractPublishSourceModelList);
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
    }

    public void overwritePublishWithCtrlKey(PublishPO publishInfoNew, PublishPO publishInfoOld, List<AbstractPublishSourceModel> abstractPublishSourceModelList, Map<String, Object> billContent) throws AbstractQingIntegratedException, PublishException {
        try {
            this.updateSchema(publishInfoNew, publishInfoOld, abstractPublishSourceModelList, true);
            List<BillModel> billModels = this.getBillManagerDao().findBillsByPublishId(publishInfoOld.getId());
            this.saveBillContent(publishInfoNew, billContent);
            this.deletePersistentFileAndData(billModels);
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
    }

    private void saveBillContent(PublishPO publishInfo, Map<String, Object> billContent) throws AbstractQingIntegratedException, SQLException {
        String publishId = publishInfo.getId();
        String ctrlKey = (String)billContent.get("ctrlKey");
        byte[] filterContent = (byte[])billContent.get("filterContent");
        BillModel billModel = new BillModel();
        billModel.setCtrKey(ctrlKey);
        billModel.setPublishId(publishId);
        billModel.setFilterContent(filterContent);
        this.getBillManagerDao().insertBill(billModel);
    }

    public void deletePublish(PublishPO publishInfo) throws PublishException, AbstractQingIntegratedException {
        try {
            String publishId = publishInfo.getId();
            List<BillModel> billModels = this.getBillManagerDao().findBillsByPublishId(publishId);
            this.deletePersistentFileAndData(billModels);
            this.getSchemaManageDao().deleteSchemaByBizTag(publishId);
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
    }

    public void updatePublish(int updateType, PublishPO publishInfoNew, PublishPO publishInfoOld, List<AbstractPublishSourceModel> abstractPublishSourceModelList) throws PublishException, AbstractQingIntegratedException {
        try {
            switch (updateType) {
                case 4: 
                case 6: {
                    this.updateSchema(publishInfoNew, publishInfoOld, abstractPublishSourceModelList, false);
                    break;
                }
            }
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
    }

    public BillModel loadBillInfo(String publishId) throws AbstractQingIntegratedException, SQLException {
        BillModel billModel = this.getBillManagerDao().findBillByPublishId(publishId);
        byte[] filterContentBytes = this.getBillManagerDao().loadFilterContent(publishId);
        billModel.setFilterContent(filterContentBytes);
        return billModel;
    }

    public void overwritePublish(String tag, PublishPO publishInfoNew, PublishPO publishInfoOld, List<AbstractPublishSourceModel> abstractPublishSourceModelList, List<IQingFile> savedQingFiles) throws AbstractQingIntegratedException, PublishException {
        try {
            this.updateSchema(publishInfoNew, publishInfoOld, abstractPublishSourceModelList, true);
            List<BillModel> billModels = this.getBillManagerDao().findBillsByPublishId(publishInfoOld.getId());
            this.savePersistentFileAndData(tag, publishInfoNew, savedQingFiles);
            this.deletePersistentFileAndData(billModels);
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
        catch (IOException e) {
            throw new PublishException((Throwable)e);
        }
    }

    private void updateSchema(PublishPO publishInfoNew, PublishPO publishInfoOld, List<AbstractPublishSourceModel> abstractPublishSourceModelList, boolean isOverride) throws AbstractQingIntegratedException, SQLException, PublishException {
        if (isOverride) {
            List<SchemaModel> schemaModelList = this.packageInfoToSchemaModel(abstractPublishSourceModelList, publishInfoNew, false);
            this.getSchemaManageDao().updateSchemaBoList(publishInfoOld.getId(), schemaModelList);
        } else {
            List<SchemaModel> schemaModelList;
            List<AbstractPublishSourceModel> newPublishSchemaList;
            List<SchemaAttrVO> samePublishSchemaList;
            List<SchemaAttrVO> updatePublishSchemaList;
            ArrayList<SchemaAttrVO> existPublishSchema = new ArrayList<SchemaAttrVO>(abstractPublishSourceModelList.size());
            List<SchemaBO> existPublishSchemaList = this.getSchemaManageDao().findSchemaByBiztag(publishInfoOld.getId(), "SystemUser", 0);
            this.adjustPublishSchemaSeq(abstractPublishSourceModelList, existPublishSchemaList);
            List<String> deletePublishSchemaIdList = BillPublishSourceDomain.obtainDeletePublishSchema(abstractPublishSourceModelList, existPublishSchemaList);
            if (deletePublishSchemaIdList.size() > 0) {
                this.getSchemaManageDao().deletePublishSchemaInfoById(deletePublishSchemaIdList);
            }
            if ((updatePublishSchemaList = BillPublishSourceDomain.obtainUpdatePublishSchema(abstractPublishSourceModelList, existPublishSchemaList)).size() > 0) {
                existPublishSchema.addAll(updatePublishSchemaList);
                this.getSchemaManageDao().updateSchemaAttrList(updatePublishSchemaList);
            }
            if ((samePublishSchemaList = this.obtainSamePublishSchema(abstractPublishSourceModelList, existPublishSchemaList)).size() > 0) {
                existPublishSchema.addAll(updatePublishSchemaList.size(), samePublishSchemaList);
            }
            if ((newPublishSchemaList = BillPublishSourceDomain.obtainNewPublishSchema(abstractPublishSourceModelList, existPublishSchemaList)).size() > 0 && (schemaModelList = this.packageInfoToSchemaModel(newPublishSchemaList, publishInfoNew, true)).size() > 0) {
                List<SchemaAttrVO> schemaAttrVOList = this.packageInfoToSchemaAttrVO(schemaModelList);
                existPublishSchema.addAll(updatePublishSchemaList.size() + samePublishSchemaList.size(), schemaAttrVOList);
                this.getSchemaManageDao().insertSchemaList(schemaModelList);
            }
            this.updateSchemaIdForPublishInfo(existPublishSchema, publishInfoNew, publishInfoOld);
        }
    }

    private void updateSchemaIdForPublishInfo(List<SchemaAttrVO> schemaAttrVOList, PublishPO publishInfoNew, PublishPO publishInfoOld) throws AbstractQingIntegratedException, SQLException {
        if (schemaAttrVOList.size() > 0) {
            String defaultPublishSchema = BillPublishSourceDomain.findSetDefaultPublishSchema(schemaAttrVOList);
            publishInfoNew.setSchemaId(defaultPublishSchema != null ? defaultPublishSchema : schemaAttrVOList.get(0).getfId());
            if (!Objects.equals(defaultPublishSchema, publishInfoOld.getSchemaId())) {
                this.getSchemaManageDao().updateSchemaRelation(publishInfoOld.getSchemaId(), "0", "SystemUser");
                if (defaultPublishSchema != null) {
                    this.updateCustomSetDefaultSchema(defaultPublishSchema, publishInfoNew);
                }
            }
        }
    }

    private List<SchemaAttrVO> packageInfoToSchemaAttrVO(List<SchemaModel> schemaModelList) {
        ArrayList<SchemaAttrVO> schemaAttrVOList = new ArrayList<SchemaAttrVO>(schemaModelList.size());
        for (SchemaModel schemaModel : schemaModelList) {
            SchemaAttrVO schemaAttrVO = new SchemaAttrVO();
            schemaAttrVO.setfId(schemaModel.getSchemaBO().getfId());
            schemaAttrVO.setIsDefault(schemaModel.getSchemaBO().IsDefault());
            schemaAttrVOList.add(schemaAttrVO);
        }
        return schemaAttrVOList;
    }

    private void adjustPublishSchemaSeq(List<AbstractPublishSourceModel> abstractPublishSourceModelList, List<SchemaBO> existPublishSchemaList) throws AbstractQingIntegratedException, SQLException {
        int schemaSeq = abstractPublishSourceModelList.size() - 1;
        for (AbstractPublishSourceModel abstractPublishSourceModel : abstractPublishSourceModelList) {
            PublishSchemaModel publishSourceModel = (PublishSchemaModel)abstractPublishSourceModel;
            publishSourceModel.getSchemaAttr().setSeq(schemaSeq--);
        }
        List<SchemaAttrVO> updateSchemaSeq = this.obtainSamePublishSchema(abstractPublishSourceModelList, existPublishSchemaList);
        if (updateSchemaSeq.size() > 0) {
            this.getSchemaManageDao().updatePublishSchemaSeq(updateSchemaSeq);
        }
    }

    private List<SchemaAttrVO> obtainSamePublishSchema(List<AbstractPublishSourceModel> abstractPublishSourceModelList, List<SchemaBO> existPublishSchemaList) {
        ArrayList<SchemaAttrVO> samePublishSchema = new ArrayList<SchemaAttrVO>(existPublishSchemaList.size());
        block0: for (SchemaBO schemaBO : existPublishSchemaList) {
            for (AbstractPublishSourceModel abstractPublishSourceModel : abstractPublishSourceModelList) {
                PublishSchemaModel publishSchemaModel = (PublishSchemaModel)abstractPublishSourceModel;
                if (!Objects.equals(schemaBO.getfId(), publishSchemaModel.getSchemaAttr().getfId())) continue;
                samePublishSchema.add(publishSchemaModel.getSchemaAttr());
                continue block0;
            }
        }
        return samePublishSchema;
    }

    private void updateCustomSetDefaultSchema(String updateDefaultSchemaId, PublishPO publishPO) throws AbstractQingIntegratedException, SQLException {
        List<String> defaultPlanUserId = this.getSchemaManageDao().findSetDefaultPlanUserId(publishPO);
        if (defaultPlanUserId.size() == 0) {
            SchemaBO schemaBO = new SchemaBO();
            schemaBO.setfId(updateDefaultSchemaId);
            schemaBO.setUserId("SystemUser");
            schemaBO.setIsDefault(true);
            this.getSchemaManageDao().insertSchemaRelation(schemaBO);
        } else {
            this.getSchemaManageDao().updateSchemaRelation(updateDefaultSchemaId, "1", "SystemUser");
        }
    }

    private static List<String> obtainDeletePublishSchema(List<AbstractPublishSourceModel> importSubjectSourceList, List<?> existPublishSchemaList) {
        int i;
        ArrayList<String> deleteSchemaIdList = new ArrayList<String>(existPublishSchemaList.size());
        HashMap<String, Integer> existSchemaId = new HashMap<String, Integer>(existPublishSchemaList.size());
        for (i = 0; i < existPublishSchemaList.size(); ++i) {
            if (existPublishSchemaList.get(i) instanceof SchemaBO) {
                SchemaBO schemaBO = (SchemaBO)existPublishSchemaList.get(i);
                existSchemaId.put(schemaBO.getfId(), 1);
            }
            if (!(existPublishSchemaList.get(i) instanceof SchemaModel)) continue;
            SchemaModel schemaModel = (SchemaModel)existPublishSchemaList.get(i);
            existSchemaId.put(schemaModel.getSchemaBO().getfId(), 1);
        }
        for (i = 0; i < importSubjectSourceList.size(); ++i) {
            PublishSchemaModel publishSourceModel = (PublishSchemaModel)importSubjectSourceList.get(i);
            String editPublishSchemaId = publishSourceModel.getSchemaAttr().getfId();
            if (!existSchemaId.containsKey(editPublishSchemaId)) continue;
            existSchemaId.put(editPublishSchemaId, 2);
        }
        for (Map.Entry entry : existSchemaId.entrySet()) {
            if ((Integer)entry.getValue() != 1) continue;
            deleteSchemaIdList.add((String)entry.getKey());
        }
        return deleteSchemaIdList;
    }

    private static List<SchemaAttrVO> obtainUpdatePublishSchema(List<AbstractPublishSourceModel> importSubjectSourceList, List<SchemaBO> existPublishSchemaList) {
        ArrayList<SchemaAttrVO> updateSchemaAttrList = new ArrayList<SchemaAttrVO>(existPublishSchemaList.size());
        for (int i = 0; i < existPublishSchemaList.size(); ++i) {
            SchemaBO schemaBO = existPublishSchemaList.get(i);
            for (int j = 0; j < importSubjectSourceList.size(); ++j) {
                PublishSchemaModel publishSchemaModel = (PublishSchemaModel)importSubjectSourceList.get(j);
                SchemaAttrVO updatePublishSchemaAttr = publishSchemaModel.getSchemaAttr();
                if (!Objects.equals(schemaBO.getfId(), updatePublishSchemaAttr.getfId()) || Objects.equals(schemaBO.getSchemaName(), updatePublishSchemaAttr.getSchemaName()) && schemaBO.IsDefault() == updatePublishSchemaAttr.IsDefault()) continue;
                updateSchemaAttrList.add(updatePublishSchemaAttr);
            }
        }
        return updateSchemaAttrList;
    }

    private static String findSetDefaultPublishSchema(List<?> schemaList) {
        for (int i = 0; i < schemaList.size(); ++i) {
            SchemaModel schemaModel;
            SchemaAttrVO schemaAttrVO;
            PublishSchemaModel publishSchemaModel;
            SchemaBO schemaBO;
            if (schemaList.get(i) instanceof SchemaBO && (schemaBO = (SchemaBO)schemaList.get(i)).IsDefault().booleanValue()) {
                return schemaBO.getfId();
            }
            if (schemaList.get(i) instanceof AbstractPublishSourceModel && (publishSchemaModel = (PublishSchemaModel)((Object)schemaList.get(i))).getSchemaAttr().IsDefault().booleanValue()) {
                return publishSchemaModel.getSchemaAttr().getfId();
            }
            if (schemaList.get(i) instanceof SchemaAttrVO && (schemaAttrVO = (SchemaAttrVO)schemaList.get(i)).IsDefault().booleanValue()) {
                return schemaAttrVO.getfId();
            }
            if (!(schemaList.get(i) instanceof SchemaModel) || !(schemaModel = (SchemaModel)schemaList.get(i)).getSchemaBO().IsDefault().booleanValue()) continue;
            return schemaModel.getSchemaBO().getfId();
        }
        return null;
    }

    private static List<AbstractPublishSourceModel> obtainNewPublishSchema(List<AbstractPublishSourceModel> importSubjectSourceList, List<SchemaBO> existPublishSchemaList) {
        ArrayList<AbstractPublishSourceModel> NewSchemaList = new ArrayList<AbstractPublishSourceModel>(importSubjectSourceList.size());
        for (int i = 0; i < importSubjectSourceList.size(); ++i) {
            boolean bNewDefaultSchema = false;
            PublishSchemaModel publishSchemaModel = (PublishSchemaModel)importSubjectSourceList.get(i);
            SchemaAttrVO updatePublishSchemaAttr = publishSchemaModel.getSchemaAttr();
            for (int j = 0; j < existPublishSchemaList.size(); ++j) {
                SchemaBO schemaBO = existPublishSchemaList.get(j);
                if (!Objects.equals(schemaBO.getfId(), updatePublishSchemaAttr.getfId())) continue;
                bNewDefaultSchema = true;
                break;
            }
            if (bNewDefaultSchema) continue;
            NewSchemaList.add(publishSchemaModel);
        }
        return NewSchemaList;
    }

    private void checkMapExist(List<OutsideReference> outerRefList, PublishPO publishInfo) throws MapNotFoundException {
        if (!publishInfo.isImport()) {
            for (int i = 0; i < outerRefList.size(); ++i) {
                String refToId = outerRefList.get(i).getRefToId();
                if (refToId == null) {
                    throw new MapNotFoundException();
                }
                outerRefList.get(i).setRefToFullPath(null);
            }
        }
    }

    private void savePersistentFileAndData(String tag, PublishPO publishInfo, List<IQingFile> savedQingFiles) throws AbstractQingIntegratedException, SQLException, PublishSourcePublishNotExistException, IOException {
        String publishId = publishInfo.getId();
        String bizTag = publishInfo.getTagId();
        byte[] fFilter = null;
        String ctrKey = null;
        if (PublishUtil.isPublish((String)bizTag)) {
            PublishPO oldInfo = this.getPublishInfoDao().getPublishInfoByInfoId(bizTag);
            if (oldInfo == null) {
                throw new PublishSourcePublishNotExistException();
            }
            bizTag = oldInfo.getTagId();
            fFilter = this.getBillManagerDao().loadFilterContent(oldInfo.getId());
            ctrKey = this.getBillManagerDao().getBillCtrKey(oldInfo.getId());
        } else {
            String filterStr = QingSessionUtil.get((String)(QING_FILTER_KEY + tag));
            if (filterStr != null) {
                try {
                    fFilter = filterStr.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    LogUtil.error((String)e.getMessage(), (Throwable)e);
                }
            }
            ctrKey = QingSessionUtil.get((String)(QING_CTRL_KEY + tag));
        }
        BillModel billModel = new BillModel();
        billModel.setCtrKey(ctrKey);
        billModel.setPublishId(publishId);
        billModel.setFilterContent(fFilter);
        if (publishInfo.isCarryData()) {
            FormDataSource formDataSource = (FormDataSource)QingSessionUtil.getCache((String)FormDataSource.getCacheKey(tag), FormDataSource.class);
            String qsFileName = formDataSource.getFileName();
            IQingFileVisitor qsTempFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.TEMP_QS, (String)qsFileName);
            if (!qsTempFile.exists()) {
                qsTempFile = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.EMBEDDED_PUB_QS, (String)qsFileName);
            }
            QingFileResourceInfo resourceInfo = new QingFileResourceInfo();
            resourceInfo.setDisplayName(ctrKey == null ? bizTag : bizTag + ctrKey);
            resourceInfo.setFromId(publishId);
            if (publishInfo.isTimingPush()) {
                resourceInfo.setFromType(ResourceFromType.TIMINGPUSH);
            } else {
                resourceInfo.setFromType(ResourceFromType.PUBLISHED);
            }
            IQingFile qsPersistentFile = FileFactory.newPersistentFile((QingContext)this.context, (QingFileResourceInfo)resourceInfo, (QingPersistentFileType)QingPersistentFileType.EMBEDDED_PUB_QS);
            FileFactory.copy((IQingFileVisitor)qsTempFile, (IQingFile)qsPersistentFile, (boolean)true);
            savedQingFiles.add(qsPersistentFile);
            billModel.setQsFileName(qsPersistentFile.getName());
            billModel.setExtractDataTime(new Date(formDataSource.getExtractDataTime()));
        }
        this.getBillManagerDao().insertBill(billModel);
    }

    private PublishPO saveSchema(PublishPO publishInfo, List<AbstractPublishSourceModel> abstractPublishSourceModelList) throws AbstractQingIntegratedException, SQLException, PublishException {
        List<SchemaModel> schemaModelList = this.packageInfoToSchemaModel(abstractPublishSourceModelList, publishInfo, false);
        this.getSchemaManageDao().insertSchemaList(schemaModelList);
        return publishInfo;
    }

    public List<SchemaModel> packageInfoToSchemaModel(List<AbstractPublishSourceModel> importSubjectSourceList, PublishPO publishInfo, boolean isEditPublishInfo) throws SQLException, AbstractQingIntegratedException, PublishException {
        ArrayList<SchemaModel> schemaModelList = new ArrayList<SchemaModel>(importSubjectSourceList.size());
        byte[] modelBookContent = null;
        List<OutsideReference> outerRefList = null;
        int schemaSeq = importSubjectSourceList.size() - 1;
        ArrayList<String> schemaIdList = new ArrayList<String>(importSubjectSourceList.size());
        for (int i = 0; i < importSubjectSourceList.size(); ++i) {
            SchemaAttrVO schemaAttrVO;
            PublishSchemaModel publishSchemaModel = (PublishSchemaModel)importSubjectSourceList.get(i);
            if (publishSchemaModel.getSchemaContent() != null || schemaIdList.contains((schemaAttrVO = publishSchemaModel.getSchemaAttr()).getfId())) continue;
            schemaIdList.add(schemaAttrVO.getfId());
        }
        Map<Object, Object> existSchemaContentMap = new HashMap(schemaIdList.size());
        if (schemaIdList.size() != 0) {
            existSchemaContentMap = this.getSchemaManageDao().loadSchemaContentList(schemaIdList);
        }
        for (int i = 0; i < importSubjectSourceList.size(); ++i) {
            SchemaBO schemaBO = new SchemaBO();
            PublishSchemaModel publishSourceModel = (PublishSchemaModel)importSubjectSourceList.get(i);
            SchemaAttrVO schemaAttrVO = null;
            if (publishSourceModel.getSchemaContent() == null) {
                schemaAttrVO = publishSourceModel.getSchemaAttr();
                modelBookContent = (byte[])existSchemaContentMap.get(schemaAttrVO.getfId());
                schemaIdList.add(schemaAttrVO.getfId());
                outerRefList = this.getSchemaManageDao().loadSchemaRef(publishInfo.getSchemaId());
            } else {
                schemaAttrVO = publishSourceModel.getSchemaAttr();
                ModelBook schemaContent = publishSourceModel.getSchemaContent();
                outerRefList = schemaContent.pickReferences();
                modelBookContent = XmlUtil.toByteArray((Element)schemaContent.toXml());
            }
            this.checkMapExist(outerRefList, publishInfo);
            String newSchemaFid = this.getSchemaManageDao().genSchemaId();
            this.updateSchemaRef(outerRefList, newSchemaFid);
            schemaBO.setfId(newSchemaFid);
            schemaBO.setSchemaName(schemaAttrVO.getSchemaName() == null ? Messages.getMLS((QingContext)this.context, (String)"systemDefaultSchema", (String)"\u7cfb\u7edf\u9ed8\u8ba4\u65b9\u6848", (Messages.ProjectName)Messages.ProjectName.QING_THEME) : schemaAttrVO.getSchemaName());
            schemaBO.setSource(schemaAttrVO.getSource());
            schemaBO.setBizTag(publishInfo.getId());
            schemaBO.setUserId(schemaAttrVO.IsDefault() != false && schemaAttrVO.getSchemaType() == 2 ? "SystemUser" : this.context.getUserId());
            schemaBO.setIsDefault(schemaAttrVO.IsDefault());
            schemaBO.setSchemaType(schemaAttrVO.getSchemaType());
            schemaBO.setSeq(isEditPublishInfo ? schemaAttrVO.getSeq() : schemaSeq--);
            if ((schemaBO.IsDefault().booleanValue() || schemaBO.getSchemaType() == 1) && modelBookContent != null) {
                if (schemaBO.IsDefault().booleanValue()) {
                    publishInfo.setSchemaId(newSchemaFid);
                }
                this.getSchemaManageDao().insertSchemaRelation(schemaBO);
            }
            SchemaModel schemaModel = new SchemaModel();
            schemaModel.setSchemaBO(schemaBO);
            schemaModel.setSchemaContent(modelBookContent);
            if (modelBookContent == null) continue;
            schemaModelList.add(schemaModel);
        }
        if (publishInfo.getSchemaId() == null || Objects.equals(publishInfo.getSchemaId(), "currentAnalysisState")) {
            publishInfo.setSchemaId(((SchemaModel)schemaModelList.get(0)).getSchemaBO().getfId());
        }
        return schemaModelList;
    }

    public void updateSchemaRef(List<OutsideReference> outerRefList, String schemaId) throws PublishException {
        try {
            this.getSchemaManageDao().deleteSchemaRef(schemaId);
            for (int i = 0; i < outerRefList.size(); ++i) {
                OutsideReference outerRef = outerRefList.get(i);
                this.getSchemaManageDao().saveSchemaRef(outerRef, schemaId);
            }
        }
        catch (Exception e) {
            throw new PublishException("save outsideRef error");
        }
    }

    private void deletePersistentFileAndData(List<BillModel> billModels) throws AbstractQingIntegratedException, SQLException {
        for (BillModel billModel : billModels) {
            if (billModel == null) continue;
            this.getBillManagerDao().deleteBillById(billModel.getId());
            String qsFileName = billModel.getQsFileName();
            List<BillModel> otherBillModels = this.getBillManagerDao().findBillsByPath(qsFileName);
            if (qsFileName == null || "".equals(qsFileName) || otherBillModels.size() != 0) continue;
            IQingFileUpdater fileUpdater = FileFactory.newFileUpdater((QingContext)this.context, (AbstractQingFileType)QingPersistentFileType.EMBEDDED_PUB_QS, (String)qsFileName);
            fileUpdater.delete();
        }
    }

    public void addPublicSchemaInfo(Map<String, String> result) throws AbstractQingIntegratedException, SQLException {
        String schemaId = result.get("schemaId");
        SchemaManageDao schemaDao = this.getSchemaManageDao();
        int schemaSource = schemaDao.findSchemaById(schemaId).getSource();
        String schemaType = schemaSource == 0 ? "longer" : "square";
        result.put("schemaType", schemaType);
    }

    public String getPublishSourceName(String bizTag, String publishSourceType) throws SQLException, AbstractQingIntegratedException {
        return IntegratedHelper.queryFormDisplayName((String)bizTag, (String)publishSourceType, (QingContext)this.context, (IDBExcuter)this.dbExcuter);
    }

    public String getPublishSourceGroupName(String bizTag, String publishSourceType) throws SQLException, AbstractQingIntegratedException {
        return IntegratedHelper.queryFormDisplayName((String)bizTag, (String)publishSourceType, (QingContext)this.context, (IDBExcuter)this.dbExcuter);
    }

    public PublishSourceEnum confirmSourceTypeByPublishInfo(PublishPO publishInfo) throws AbstractQingIntegratedException, SQLException {
        String publishId = publishInfo.getId();
        String tagId = publishInfo.getTagId();
        BillModel billModel = this.getBillManagerDao().findBillById(tagId);
        if (billModel != null) {
            return PublishSourceEnum.bill;
        }
        List<BillModel> billModels = this.getBillManagerDao().findBillsByPublishId(publishId);
        if (billModels != null && !billModels.isEmpty()) {
            return PublishSourceEnum.bill;
        }
        return null;
    }

    private SchemaDomain getSchemaDomain() {
        if (this.schemaDomain == null) {
            this.schemaDomain = new SchemaDomain();
            this.schemaDomain.setTx(this.tx);
            this.schemaDomain.setDbExcuter(this.dbExcuter);
        }
        return this.schemaDomain;
    }

    public byte[] getAllSchemaAttrs(String bizTag, int source, String userId, boolean isEditPublishInfo) {
        try {
            String publishSourceId = bizTag;
            if (PublishUtil.isPublish((String)bizTag) && isEditPublishInfo) {
                publishSourceId = this.getSchemaDomain().getLastBizTagByFId(bizTag);
            }
            ArrayList<SchemaAttrVO> schemaAttrVOS = this.getSchemaDomain().loadSchemaAttrs(publishSourceId, userId, source);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(schemaAttrVOS);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] setPublicPlanDefaultAttr(String bizTag, String modelJsonString, String userId) {
        SchemaAttrVO vo = (SchemaAttrVO)JsonUtil.decodeFromString((String)modelJsonString, SchemaAttrVO.class);
        int source = vo.getSource();
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getSchemaDomain().setSchemaDefaultAttr(bizTag, userId, source, vo));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getSchemaAttrByPublishId(String fid, String userId, int source) {
        try {
            List<SchemaAttrVO> schemaAttrVOList = this.getSchemaDomain().getSchemaAttrByPublishId(fid, userId, source);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(schemaAttrVOList);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public List<String> getPublishedRecordNameByInputText(String userId, String inputText, String publishSourceType, String publishTargetType) throws AbstractQingIntegratedException, SQLException {
        return this.getSchemaDomain().getPublishedRecordNameByInputText(userId, inputText, publishSourceType, publishTargetType);
    }

    public boolean checkBeforeEditAndPublishInfo(PublishPO publishPO, List<AbstractPublishSourceModel> abstractPublishSourceModelList) throws PublishException, SQLException, AbstractQingIntegratedException {
        return this.checkBeforeEditPublishInfo(publishPO, abstractPublishSourceModelList);
    }

    public boolean checkBeforeMovingRight(PublishPO publishPO, List<AbstractPublishSourceModel> abstractPublishSourceModelList) throws AbstractQingIntegratedException, SQLException, PublishException {
        return false;
    }

    public boolean checkBeforeEditPublishInfo(PublishPO publishInfoNew, List<AbstractPublishSourceModel> importSubjectSourceList) throws SQLException, PublishException, AbstractQingIntegratedException {
        List<SchemaBO> existPublishSchemaList = this.getSchemaManageDao().findSchemaByBiztag(publishInfoNew.getId(), "SystemUser", 0);
        List<String> deletePublishSchemaIdList = BillPublishSourceDomain.obtainDeletePublishSchema(importSubjectSourceList, existPublishSchemaList);
        List<AbstractPublishSourceModel> newPublishSchemaList = BillPublishSourceDomain.obtainNewPublishSchema(importSubjectSourceList, existPublishSchemaList);
        List<SchemaModel> schemaModelList = this.packageInfoToSchemaModel(newPublishSchemaList, publishInfoNew, true);
        return deletePublishSchemaIdList.size() == existPublishSchemaList.size() && schemaModelList.size() == 0;
    }
}

